/*	
 *	clipmp3.c
 *
 *	P/ECE MP3 Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Tue Oct 28 08:11:00 JST 2003 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Nov  4 00:00:00 JST 2003 Naoyuki Sawa
 *	- SCMPXŃGR[hMP3t@CĐł悤AłB
 *	  ̐ݒŃGR[ht@CĐāAnOAbv͂ȂȂ܂B
 *		C[	III
 *		rbg[g	64000 Œ
 *		m
 *		Gt@VX	Ȃ
 *	  ͂܂܂ŁAƂĂmCY܂B
 *	  ́A܂V[gubNE~bNXubNɑΉĂȂłB
 *	  _ł́AǂOubNƂ݂ȂčĐĂ܂Ă܂B
 *	* Thu Nov  6 23:50:00 JST 2003 Naoyuki Sawa
 *	- V[gubNΉB
 *	- XP[t@N^ΉB
 *	- mp3_read_granule_info()̃oOCB
 *	- mp3_read_scalefactor()̃oOCB
 *	* Mon Nov 10 03:15:00 JST 2003 Naoyuki Sawa
 *	- mp3_bitstream_skip()read_bitsJEgĂȂoOCB
 *	  ɂ͊֌W܂(part2_3_lengtḧmp3_bitstream_skip()͎gȂ)A
 *	  ̂߂ɏCĂ܂B
 *	* Wed Nov 12 05:25:00 JST 2003 Naoyuki Sawa
 *	- CLiPCuֈړB
 *	* Mon Nov 24 06:00:00 JST 2003 Naoyuki Sawa
 *	- clippce.hSPEAKER_FREQUENCY`̂ŁAo͎g萔ɂ̃V{g悤CB
 *	  \[Xゾ̏CłBsoCiɂ͕ω܂B
 *	* Mon Mar  7 04:09:00 JST 2005 Naoyuki Sawa
 *	- turbo()֐ɏo̓fBZ[uxԂ̐ݒǉƂɒǏ]܂B
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	ID3 Tag V1
 ****************************************************************************/

/* gpEmF */

static const void*
mp3_id3_tag_v1_read1(const void* _in, char* out, int len)
{
	const char* in = (const char*)_in;
	int i;
	memcpy(out, in, len);
	for(i = len - 1; i >= 0; i--) {
		if(!isspace(out[i])) break;
		out[i] = '\0';
	}
	return in + len;
}
	
/* ID3 Tag V1ǂݍ݂܂B
 * [in]
 *	tag		ID3 Tag V1ǂݍލ\́B
 *	ptr		MP3t@C̏I[128oCgڂnĂB
 *			t@C128oCg̏ꍇ́Å֐Ăł͂܂B
 * [out]
 *	* ߂l	ǂݍݐȂ0Ԃ܂B
 *			ǂݍݎsȂ0ȊO̒lԂ܂B
 */
int
mp3_id3_tag_v1_read(MP3ID3TAGV1* tag, const void* ptr)
{
	if(memcmp(ptr, "TAG", 3) != 0) return -1;

	memset(tag, 0, sizeof(MP3ID3TAGV1));
	ptr = mp3_id3_tag_v1_read1(ptr, tag->tag,      3);
	ptr = mp3_id3_tag_v1_read1(ptr, tag->title,   30);
	ptr = mp3_id3_tag_v1_read1(ptr, tag->artist,  30);
	ptr = mp3_id3_tag_v1_read1(ptr, tag->album,   30);
	ptr = mp3_id3_tag_v1_read1(ptr, tag->year,     4);
	ptr = mp3_id3_tag_v1_read1(ptr, tag->comment, 30);
	tag->genre = *(unsigned char*)ptr;

	return 0;
}

/****************************************************************************
 *	rbgXg[
 ****************************************************************************/

/* rbgXg[J܂B
 * [in]
 *	bs		rbgXg[\́B
 *	pos		ŏ̓ǂݍ݃AhXB
 */
void
mp3_bitstream_open(MP3BITSTREAM* bs, const void* pos)
{
	bs->read_bits = 0;
	bs->cnt = 0;
	/*bs->buf = 0;{{sv}}*/
	bs->pos = (const unsigned char*)pos;
}

/* rbgXg[rbgǂݔ΂܂B
 * [in]
 *	bs		rbgXg[\́B
 *	cnt		ǂݔ΂rbgB(0`C)
 */
void
mp3_bitstream_skip(MP3BITSTREAM* bs, int cnt)
{
	bs->read_bits += cnt;
	if(bs->cnt >= cnt) {
		bs->cnt -= cnt;
	} else {
		cnt -= bs->cnt;
		bs->pos += cnt / 8;
		cnt &= 7;
		if(cnt) {
			bs->buf = *bs->pos++;
			bs->cnt = 8 - cnt;
		} else {
			bs->cnt = 0;
		}
	}
}

/****************************************************************************
 *	t[wb_
 ****************************************************************************/

/* t[wb_ǂݍ݂܂B
 * [in]
 *	bs		rbgXg[\́B
 *	frame		t[wb_i[\́B
 * [out]
 *	߂l		Ȃ0Ԃ܂B
 *			sȂ0ȊO̒lԂ܂B
 */
int
mp3_read_frame_header(MP3BITSTREAM* bs, MP3FRAMEHEADER* frame)
{
	frame->syncword			= mp3_bitstream_get(bs, 12);
	frame->id			= mp3_bitstream_get(bs,  1);
	frame->layer			= mp3_bitstream_get(bs,  2);
	frame->protection_bit		= mp3_bitstream_get(bs,  1);
	frame->bitrate_index		= mp3_bitstream_get(bs,  4);
	frame->sampling_frequency	= mp3_bitstream_get(bs,  2);
	frame->padding_bit		= mp3_bitstream_get(bs,  1);
	frame->private_bit		= mp3_bitstream_get(bs,  1);
	frame->mode			= mp3_bitstream_get(bs,  2);
	frame->mode_extention		= mp3_bitstream_get(bs,  2);
	frame->copyright		= mp3_bitstream_get(bs,  1);
	frame->original			= mp3_bitstream_get(bs,  1);
	frame->emphasis			= mp3_bitstream_get(bs,  2);

	/* Œ̃G[`FbNB */
	if(frame->syncword != 0xfff) return -1;	/* [h */
	if(frame->id       !=     1) return -1;	/* MPEG1      */
	if(frame->layer    !=     1) return -1;	/* LayerIII   */

	/* CRCی삠ȂACRCیrbgǂݔ΂܂B
	 * uprotection_bit=0:CRCی삠/1:ȂvłBv!!
	 */
	if(!frame->protection_bit) mp3_bitstream_skip(bs, 16);

	return 0;
}

/****************************************************************************
 *	Oj[
 ****************************************************************************/

/* Oj[ǂݍ݂܂B
 * [in]
 *	bs		rbgXg[\́B
 *	granule		Oj[i[\́B
 */
void
mp3_read_granule_info(MP3BITSTREAM* bs, MP3GRANULEINFO* granule)
{
	granule->part2_3_length			= mp3_bitstream_get(bs, 12);
	granule->big_values			= mp3_bitstream_get(bs,  9);
	granule->global_gain			= mp3_bitstream_get(bs,  8);
	granule->scalefac_compress		= mp3_bitstream_get(bs,  4);
	granule->window_switching_flag		= mp3_bitstream_get(bs,  1);
	if(!granule->window_switching_flag) {
		granule->block_type		= 0;
		granule->table_select[0]	= mp3_bitstream_get(bs,  5);
		granule->table_select[1]	= mp3_bitstream_get(bs,  5);
		granule->table_select[2]	= mp3_bitstream_get(bs,  5);
		granule->region0_count		= mp3_bitstream_get(bs,  4);
		granule->region1_count		= mp3_bitstream_get(bs,  3);
	} else {
		granule->block_type		= mp3_bitstream_get(bs,  2);
		granule->mixed_block_flag	= mp3_bitstream_get(bs,  1);
		granule->table_select[0]	= mp3_bitstream_get(bs,  5);
		granule->table_select[1]	= mp3_bitstream_get(bs,  5);
		granule->subblock_gain[0]	= mp3_bitstream_get(bs,  3);
		granule->subblock_gain[1]	= mp3_bitstream_get(bs,  3);
		granule->subblock_gain[2]	= mp3_bitstream_get(bs,  3);
		if(granule->block_type == 2 && !granule->mixed_block_flag) {
			granule->region0_count	=       8         ;
			granule->region1_count	= 22 - (8 + 1) - 1;
		} else {
			granule->region0_count	=       7         ;
			granule->region1_count	= 22 - (7 + 1) - 1;
		}
	}
	granule->preflag			= mp3_bitstream_get(bs,  1);
	granule->scalefac_scale			= mp3_bitstream_get(bs,  1);
	granule->count1table_select		= mp3_bitstream_get(bs,  1);
}

/****************************************************************************
 *	TCh
 ****************************************************************************/

/* TChǂݍ݂܂B
 * [in]
 *	bs		rbgXg[\́B
 *	side		TChi[\́B
 *	channels	`lB
 */
void
mp3_read_side_info(MP3BITSTREAM* bs, MP3SIDEINFO* side, int channels)
{
	int i_granule;
	int i_channel;

	side->main_data_begin		= mp3_bitstream_get(bs, 9);
	switch(channels) {
	case 1:
		side->private_bits	= mp3_bitstream_get(bs, 5);
		side->scfsi[0]		= mp3_bitstream_get(bs, 4);
		break;
	case 2:
		side->private_bits	= mp3_bitstream_get(bs, 3);
		side->scfsi[0]		= mp3_bitstream_get(bs, 4);
		side->scfsi[1]		= mp3_bitstream_get(bs, 4);
		break;
	}
	for(i_granule = 0; i_granule < 2; i_granule++) {
		for(i_channel = 0; i_channel < channels; i_channel++) {
			mp3_read_granule_info(bs, &side->granule_info[i_granule][i_channel]);
		}
	}
}

/****************************************************************************
 *	XP[t@N^
 ****************************************************************************/

/* XP[t@N^ǂݍ݂܂B
 * [in]
 *	bs		rbgXg[\́B
 *	granule		Oj[\́B
 *	scale		XP[t@N^[\́B(ɃXP[t@N^[ǂݍ݂܂)
 *	scfsi		1Oj[̏ꍇA0nĂB
 *			2Oj[̏ꍇAMP3SIDEINFO.scsfi[ch#]̒lnĂB
 * [out]
 *	*scale		XP[t@N^[ǂݍ݁Ai[܂B
 * [note]
 *	* 2Oj[̓ǂݍ݂ł́Aꕔ̒l1Oj[ƋLꍇ܂B
 *	  ̏ꍇAω镔ǂݍ݁AL͓ǂݍ݂܂B
 *	  ]āA1Oj[œǂݍ񂾃XP[t@N^[\̂A
 *	  ej󂹂ɓ`l̑2Oj[̃XP[t@N^[ǂݍ݂ɎgĂB
 */
void
mp3_read_scalefactor(MP3BITSTREAM* bs, const MP3GRANULEINFO* granule, MP3SCALEFACTOR* scale, int scfsi)
{
	int i, slen1, slen2;
	short* out;

	slen1 = mp3_scalefactor_compress_table[granule->scalefac_compress][0];
	slen2 = mp3_scalefactor_compress_table[granule->scalefac_compress][1];

	if(granule->block_type == 2) {
		if(granule->mixed_block_flag) {
			/* ~bNXubN */
			out = &scale->long_block[(i = 0)];
			do { *out++ = mp3_bitstream_get(bs, slen1); } while(++i <= 7);	/* long_block[0`7] */
			out = &scale->short_block[(i = 3)][0];
			do { *out++ = mp3_bitstream_get(bs, slen1);
			     *out++ = mp3_bitstream_get(bs, slen1);
			     *out++ = mp3_bitstream_get(bs, slen1); } while(++i <= 5);	/* short_block[3` 5] */
		} else {
			/* V[gubN */
			out = &scale->short_block[(i = 0)][0];
			do { *out++ = mp3_bitstream_get(bs, slen1);
			     *out++ = mp3_bitstream_get(bs, slen1);
			     *out++ = mp3_bitstream_get(bs, slen1); } while(++i <= 5);	/* short_block[0` 5] */
		}
		do { *out++ = mp3_bitstream_get(bs, slen2);
		     *out++ = mp3_bitstream_get(bs, slen2);
		     *out++ = mp3_bitstream_get(bs, slen2); } while(++i <= 11);		/* short_block[6`11] */
		     *out++ = 0;
		     *out++ = 0;
		     *out++ = 0;							/* short_block[   12] */
	} else {
		/* OubN */
		if(!(scfsi & 1 << 3)) { for(i =  0; i <=  5; i++) { scale->long_block[ i] = mp3_bitstream_get(bs, slen1); } };	/* long_block[ 0` 5] */
		if(!(scfsi & 1 << 2)) { for(i =  6; i <= 10; i++) { scale->long_block[ i] = mp3_bitstream_get(bs, slen1); } };	/* long_block[ 6`10] */
		if(!(scfsi & 1 << 1)) { for(i = 11; i <= 15; i++) { scale->long_block[ i] = mp3_bitstream_get(bs, slen2); } };	/* long_block[11`15] */
		if(!(scfsi & 1 << 0)) { for(i = 16; i <= 20; i++) { scale->long_block[ i] = mp3_bitstream_get(bs, slen2); } };	/* long_block[16`20] */
								    scale->long_block[21] = 0;					/* long_block[    21] */
	}
}

/****************************************************************************
 *	nt}
 ****************************************************************************/

/* nt}B
 * [in]
 *	bs		rbgXg[\́B
 *	granule		Oj[\́B
 *	out		o̓obt@B
 * [out]
 *	߂l		BigValuëCount1̈̍vf[^B
 * [note]
 *	* rbgXg[\̂read_bitsAXP[t@N^ǂݍݒÕ^C~OŃZbgĂĂB
 */
int
mp3_huffman_decode(MP3BITSTREAM* bs, const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, short* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/)
{
	int i, count, region1_start, region2_start, big_values_2;

	/* Region0/1/2̋E擾B */
	if(granule->block_type == 2) {
		/* V[gubN(~bNXubN?) */
		region1_start =  36;
		region2_start = 576;
	} else {
		/* OubN */
		region1_start = mp3_scalefactor_band_index_table[frame->sampling_frequency][0/*LongBlock*/][(granule->region0_count + 1)];
		region2_start = mp3_scalefactor_band_index_table[frame->sampling_frequency][0/*LongBlock*/][(granule->region0_count + 1) + (granule->region1_count + 1)];
	}

	/* BigValuë... */
	big_values_2 = granule->big_values * 2/*{x,y}*/;
	if(region1_start > big_values_2) region1_start = big_values_2; /* Kv */
	if(region2_start > big_values_2) region2_start = big_values_2; /* Kv */
	i = 0;
	/* Region0 */
	count = region1_start - i;
	mp3_huffman_decode_bigvalue(bs, granule->table_select[0], count, out);
	i   += count;
	out += count;
	/* Region1 */
	count = region2_start - i;
	mp3_huffman_decode_bigvalue(bs, granule->table_select[1], count, out);
	i   += count;
	out += count;
	/* Region2 */
	count = big_values_2  - i;
	mp3_huffman_decode_bigvalue(bs, granule->table_select[2], count, out);
	i   += count;
	out += count;

	/* Count1̈... */
	count = mp3_huffman_decode_count1(bs, granule->count1table_select, MP3_GRANULE_SIZE - i, out, granule->part2_3_length);
	i   += count;
	out += count;
	ASSERT(i <= MP3_GRANULE_SIZE);

	/* BigValuëCount1̈̍vf[^LĂ܂B */
	count = i;

	/* rzerö...
	 * * OubN̏ꍇASrzeröɊ܂܂Tuoh͏ĂȂ̂ŁA[tBȂĂłB
	 *   AG邽߂ƁAɏxԂɍĂ̂ŁAɍŌ܂Ń[tB邱Ƃɂ܂B
	 *   A̕KvAĂ݂ĂB
	 */
	while(i < MP3_GRANULE_SIZE) {
		*out++ = 0;
		i++;
	}

	/* BigValuëCount1̈̍vf[^Ԃ܂B */
	return count;
}

/****************************************************************************
 *	tʎq
 ****************************************************************************/

/* tʎqB(V[gubN)
 * [in]
 *	frame		t[wb_\́B
 *	granule		Oj[\́B
 *	scale		XP[t@N^\́B
 *	in		̓obt@B
 *	out		o̓obt@B
 * [note]
 *	* XP[t@N^XP[(MP3GRANULEINFO.scalefac_scale)͖ΉłB
 *	  ۂMP3t@Cł͂قƂ0ɂȂĂ悤Ȃ̂ŁA܂e͂ȂƎv܂B
 *	* TuubNQC(MP3GRANULEINFO.subblock_gain[])͖ΉłB
 *	  ۂMP3t@Cł͂قƂ0ɂȂĂ悤Ȃ̂ŁA܂e͂ȂƎv܂B
 *	* ʏMP3t@Cł̓OubN唼߁AV[gubN͑Ŝ10%xłB
 *	  łAV[gubN֐ĂAb͏ȂłB
 *	  RAMȂȂꍇ́Å֐SRAMɈڂĂ܂ĂƎv܂B
 *	  
 *	  SRAMֈڂ܂B
 */
void
mp3_requantize_short(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, short* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/)
{
	int gain, i, j, k, w, index;
	short h;
	const short* sfb_index;
	const short (*sfb_scale)[MP3_SUBBLOCK_COUNT];
	const short* reorder;

	/* XP[t@N^oh̏B */
	sfb_index = &mp3_scalefactor_band_index_table[frame->sampling_frequency][1/*ShortBlock*/][1/*̃oh̊JnCfNX*/];
	sfb_scale = scale->short_block;
	index = 0;

	/* TvёւṕAǂݍݑCfNXe[u擾B */
	reorder = mp3_reorder_read_index_table[frame->sampling_frequency];

	gain = mp3_gain_table[granule->global_gain];	/* 1.13.18 */
	for(i = 0; i < MP3_SUBBAND_COUNT; i++) {
		for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
			/* g1AԎ3Tv(=3TuubN)tʎqB
			 * ̌AV[gubNIMDCT (g6~Ԏ1)~Ԏ3 PʂƂď̂ŁA
			 *  [g32][Ԏ3][g6] ̏ɕёւĂ܂B
			 */
			for(k = 0; k < MP3_SUBBLOCK_COUNT; k++) {
				h = in[*reorder++];			/* 1.15. 0 */
				w = h * mp3_pow1_3_table[abs(h)];	/* 1.21.10 (short~short) */
				w = w * gain;				/* 1. 3.28 (int~int) */
				*out = w >> (14 + (*sfb_scale)[k] / 2);	/* 1. 1.14 (I[o[t[) */
				out += MP3_SHORT_IMDCT_SIZE;
			}
			out -= MP3_SUBBAND_SIZE - 1;

			/* ̃XP[t@N^oh̊JnCfNXɓBAgpXP[֐i߂܂B */
			index++;
			if(index == *sfb_index) {
				sfb_index++;
				sfb_scale++;
			}
		}
		out += MP3_SUBBAND_SIZE - MP3_SHORT_IMDCT_SIZE;
	}
}

/****************************************************************************
 *	IMDCT
 ****************************************************************************/

/* IMDCTB(V[gubN)
 * [in]
 *	in		̓obt@B
 *	out		o̓obt@B
 *	save		t[ԂŕۑKv̂obt@B
 * [note]
 *	* Tuoḧꕔ肵Ă܂B
 *	* ʏMP3t@Cł̓OubN唼߁AV[gubN͑Ŝ10%xłB
 *	  łAV[gubN֐ĂAb͏ȂłB
 *	  RAMȂȂꍇ́Å֐SRAMɈڂĂ܂ĂƎv܂B
 *	  
 *	  SRAMֈڂ܂B
 */
#ifndef PIECE /**************************************************************/

void
mp3_imdct_short(const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, short* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, short* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/)
{
	int i, j, k, sum;
	const short* m;

	for(k = 0; k < MP3_SUBBAND_COUNT; k++) {
		/* |=`=| |=a=| |=b=| |=c=| |=d=| |=e=| */
		/* 000000 ------ ------ ------ ------ 000000 */
		/* ------ ?????? ?????? ------ ------ ------ */
		/* ------ ------ ?????? ?????? ------ ------ */
		/* ------ ------ ------ ?????? ?????? ------ */
		/* |=saveƑďo=| |====saveɕۑ====| ~ MP3_SUBBAND_COUNT */

		/* |=`=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = *save++;	/* 1.1.14 */
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;	/* 1.1.14 */
			out += MP3_SUBBAND_COUNT;
		}

		/* |=a=| */
		m = &mp3_imdct_short_matrix[0][0];
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			sum >>= 14;	/* 1.1.14 */
			sum += *save++;	/* 1.1.14 */
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;	/* 1.1.14 */
			out += MP3_SUBBAND_COUNT;
			in  -= MP3_SHORT_IMDCT_SIZE;
		}

		/* |=b=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			m -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			sum >>= 14;	/* 1.1.14 */
			sum += *save++;	/* 1.1.14 */
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;	/* 1.1.14 */
			out += MP3_SUBBAND_COUNT;
			m  += MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
			in -= MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
		}
		m    -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
		in   += MP3_SHORT_IMDCT_SIZE;
		out  -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;

		/* |=c=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			m -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			sum >>= 14;	/* 1.1.14 */
			*save++ = sum;	/* 1.1.14 */
			m  += MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
			in -= MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE;
		}
		m  -= MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE;
		in += MP3_SHORT_IMDCT_SIZE;

		/* |=d=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SHORT_IMDCT_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			sum >>= 14;	/* 1.1.14 */
			*save++ = sum;	/* 1.1.14 */
			in -= MP3_SHORT_IMDCT_SIZE;
		}
		in += MP3_SHORT_IMDCT_SIZE;

		/* |=e=| */
		for(i = 0; i < MP3_SHORT_IMDCT_SIZE; i++) {
			*save++ = 0;	/* 1.1.14 */
		}
	}
}

#else	/********************************************************************/

/* TODO: C^[bNfBCXbgAÖقextߐl͂܂sĂ܂B */
asm("
	.code
	.align 1
	.global mp3_imdct_short
mp3_imdct_short:
	;
	xld.w %r7, 32				; k = MP3_SUBBAND_COUNT
mp3_imdct_short_L10:
	;
	; |=`=|
	;
	xld.w %r6, 6				; i = MP3_SHORT_IMDCT_SIZE
mp3_imdct_short_L20:
	ld.h %r10, [%r14]+			; sum = *save++
	;
	xld.w %r15, 1				; if(k & i & 1) sum = -sum
	and %r15, %r7
	and %r15, %r6
	xjreq mp3_imdct_short_L30
	not %r10, %r10
	xadd %r10, %r10, 1
mp3_imdct_short_L30:
	ld.h [%r13], %r10			; *out = sum
	xadd %r13, %r13, 64			; out += MP3_SUBBAND_COUNT * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_short_L20
	;
	; |=a=|
	;
	xld.w %r11, mp3_imdct_short_matrix	; m = mp3_imdct_short_matrix
	xld.w %r6, 6				; i = MP3_SHORT_IMDCT_SIZE
mp3_imdct_short_L40:
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 6				; MP3_SHORT_IMDCT_SIZE
	mac %r10	
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h %r15, [%r14]+			; sum += *save++
	add %r10, %r15
	;
	xld.w %r15, 1				; if(k & i & 1) sum = -sum
	and %r15, %r7
	and %r15, %r6
	xjreq mp3_imdct_short_L50
	not %r10, %r10
	xadd %r10, %r10, 1
mp3_imdct_short_L50:
	ld.h [%r13], %r10			; *out = sum
	xadd %r13, %r13, 64			; out += MP3_SUBBAND_COUNT * sizeof(short)
	xsub %r12, %r12, 12			; in -= MP3_SHORT_IMDCT_SIZE * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_short_L40
	;
	; |=b=|
	;
	xld.w %r6, 6				; i = MP3_SHORT_IMDCT_SIZE
mp3_imdct_short_L60:
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 6				; MP3_SHORT_IMDCT_SIZE
	mac %r10	
	xsub %r11, %r11, 84			; m -= (MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	; (%alrp)				; ݍ
	xld.w %r10, 6				; MP3_SHORT_IMDCT_SIZE
	mac %r10	
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h %r15, [%r14]+			; sum += *save++
	add %r10, %r15
	;
	xld.w %r15, 1				; if(k & i & 1) sum = -sum
	and %r15, %r7
	and %r15, %r6
	xjreq mp3_imdct_short_L70
	not %r10, %r10
	xadd %r10, %r10, 1
mp3_imdct_short_L70:
	ld.h [%r13], %r10			; *out = sum
	xadd %r13, %r13, 64			; out += MP3_SUBBAND_COUNT * sizeof(short)
	xadd %r11, %r11, 72			; m += (MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	xsub %r12, %r12, 24			; in -= (MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_short_L60
	;
	xsub %r11, %r11, 72			; m -= (MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	xadd %r12, %r12, 12			; in += MP3_SHORT_IMDCT_SIZE * sizeof(short)
	xsub %r13, %r13, 1150			; out -= (MP3_GRANULE_SIZE - 1) * sizeof(short)
	xsub %r14, %r14, 36			; save -= MP3_SUBBAND_SIZE * sizeof(short)
	;
	; |=c=|
	;
	xld.w %r6, 6				; i = MP3_SHORT_IMDCT_SIZE
mp3_imdct_short_L80:
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 6				; MP3_SHORT_IMDCT_SIZE
	mac %r10	
	xsub %r11, %r11, 84			; m -= (MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	; (%alrp)				; ݍ
	xld.w %r10, 6				; MP3_SHORT_IMDCT_SIZE
	mac %r10	
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h [%r14]+, %r10			; *save++ = sum
	xadd %r11, %r11, 72			; m += (MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	xsub %r12, %r12, 24			; in -= (MP3_SHORT_IMDCT_SIZE + MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_short_L80
	;
	xsub %r11, %r11, 72			; m -= (MP3_SHORT_IMDCT_SIZE * MP3_SHORT_IMDCT_SIZE) * sizeof(short)
	xadd %r12, %r12, 12			; in += MP3_SHORT_IMDCT_SIZE * sizeof(short)
	;
	; |=d=|
	;
	xld.w %r6, 6				; i = MP3_SHORT_IMDCT_SIZE
mp3_imdct_short_L90:
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 6				; MP3_SHORT_IMDCT_SIZE
	mac %r10	
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h [%r14]+, %r10			; *save++ = sum
	xsub %r12, %r12, 12			; in -= MP3_SHORT_IMDCT_SIZE * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_short_L90
	;
	xadd %r12, %r12, 12			; in += MP3_SHORT_IMDCT_SIZE * sizeof(short)
	;
	; |=e=|
	;
	xld.w %r6, 6				; i = MP3_SHORT_IMDCT_SIZE
mp3_imdct_short_L100:
	ld.h [%r14]+, %r8			; *save++ = 0
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_short_L100
	;
	xsub %r7, %r7, 1
	xjrne mp3_imdct_short_L10
	;
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	MP3hCo
 ****************************************************************************/

#define MP3BUFLEN	(64 * 5)

int
mp3_init(MP3DRIVER* mp3, const void* data, int len)
{
	/* ܂[NAB */
	memset(mp3, 0, sizeof(MP3DRIVER));

	/* ǂݍ݈ʒuƏI[ʒui[܂B */
	mp3->pos = data;
	mp3->end = mp3->pos + len;

	/* TvOgϊDDȀB */
	mp3->e_fbuff = -SPEAKER_FREQUENCY;

	/* ŏ̃t[fR[hAobt@𖞂܂B */
	if(mp3_decode_frame(mp3) != 0) return -1;

	return 0;
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//mp3_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
mp3_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	MP3DRIVER* mp3 = (MP3DRIVER*)param;
	short* wbuff_end = wbuff + MP3BUFLEN;
	int sampling_frequency = mp3->sampling_frequency;
	int c_fbuff = mp3->c_fbuff;
	int i_fbuff = mp3->i_fbuff;
	int e_fbuff = mp3->e_fbuff;
	short* fbuff = mp3->fbuff;

	while(wbuff < wbuff_end) {
		*wbuff++ = fbuff[i_fbuff];
		e_fbuff += sampling_frequency;
		while(e_fbuff >= 0) {
			e_fbuff -= SPEAKER_FREQUENCY;
			i_fbuff++;
		}
		while(i_fbuff >= c_fbuff) {
			i_fbuff -= c_fbuff;
			if(mp3_decode_frame(mp3) != 0) return -1;
			sampling_frequency = mp3->sampling_frequency;
			c_fbuff = mp3->c_fbuff;
		}
	}

	mp3->i_fbuff = i_fbuff;
	mp3->e_fbuff = e_fbuff;

	return 0;
}

/* 1t[fR[h܂B
 * [in]
 *	mp3			MP3hCo\́B
 * [out]
 *	߂l			Ȃ0Ԃ܂B
 *				sȂ0ȊO̒lԂ܂B(I[ɒBꍇȂ)
 *	mp3->fbuff		fR[ht[f[^i[܂B
 *	mp3->sampling_frequency	fR[ht[̃TvOgi[܂B
 */
int
mp3_decode_frame(MP3DRIVER* mp3)
{
	MP3BITSTREAM bs, bs_tmp;
	MP3FRAMEHEADER frame;
	MP3SIDEINFO side;
	MP3SCALEFACTOR scale;
	MP3GRANULEINFO* granule;
	const MP3SAMPLINGFREQUENCYCONVERTTABLE* convert;
	int bitrate, sampling_frequency, channels, frame_size, main_data_size;
	int i_granule, i_channel, count, subband_count;
	short* out;

	/* t[ԂŕۑKv̂Ȃobt@B */
#ifndef PIECE
	/* SRAMɎꍇB */
	static short buf1[MP3_GRANULE_SIZE];
	static short buf2[MP3_GRANULE_SIZE];
#else
	/* RAMɎꍇB̂悤ȃCAEgɂȂ܂B
	 *	0002000 +-----------------+
	 *	        | buf1            |
	 *	0001b80 +-----------------+
	 *	        | buf2            |
	 *	0001700 +-----------------+
	 *	        | frammp3.o(CODE) |
	 *	0001000 +-----------------+
	 * * P/ECEŏԂɍ킹ɂ́A̔zuK{łBɁA48MHz[hƃ1WAITK{łB
	 * * ȂX^bNĂƎv̂ŁA[U[X^bNEVXeX^bNƂ₵ĂSłB
	 *   2003/11/09݂̂ƂA[U[X^bN4KBEVXeX^bN4KBŁAmFĂ܂B
	 */
	static short* buf1 = (short*)0x2000 - MP3_GRANULE_SIZE * 1;
	static short* buf2 = (short*)0x2000 - MP3_GRANULE_SIZE * 2;
	extern unsigned long __END_FRAM_ADDR[];
	if((int)buf2 < (int)__END_FRAM_ADDR) DIE();
#endif

	/* t[Jnʒu܂B */
	for(;;) {
		/* f[^I[? */
		if(mp3->pos >= mp3->end - 1) return -1;
		/* [h? */
		if(mp3->pos[0] == 0xff &&
		  (mp3->pos[1] &  0xf0) == 0xf0) break;
		mp3->pos++;
	}

	/* rbgXg[J܂B */
	mp3_bitstream_open(&bs, mp3->pos);

	/* t[wb_ǂݍ݂܂B */
	if(mp3_read_frame_header(&bs, &frame) != 0) return -1/*t[wb_s*/;
	bitrate = mp3_bitrate_table[frame.bitrate_index];
	sampling_frequency = mp3_sampling_frequency_table[frame.sampling_frequency];
	channels = frame.mode == 3 ? 1 : 2;
	frame_size = 144 * bitrate / sampling_frequency + frame.padding_bit; /* t[TCYvZ */

	/* TChǂݍ݂܂B */
	mp3_read_side_info(&bs, &side, channels);

	/* Cf[^̃rbg~ρB */
	ASSERT(bs.cnt == 0); /* TCh̖ŃoCgEɐ񂵂Ă͂ */
	main_data_size = frame_size - (bs.pos - mp3->pos)/*t[wb_ƃTChc肪Cf[^*/;
	if(mp3->main_save_size + main_data_size > sizeof mp3->main_save) {
		memmove(&mp3->main_save[0], &mp3->main_save[mp3->main_save_size - side.main_data_begin], side.main_data_begin);
		mp3->main_save_size = side.main_data_begin;
	}
	memcpy(&mp3->main_save[mp3->main_save_size], bs.pos, main_data_size);
	mp3_bitstream_open(&bs, &mp3->main_save[mp3->main_save_size - side.main_data_begin]);
	mp3->main_save_size += main_data_size;

	/* TvOgϊe[u擾܂B */
	convert = &mp3_sampling_frequency_convert_table[frame.sampling_frequency];

	/* eOj[fR[h܂B */
	out = mp3->fbuff;
	for(i_granule = 0; i_granule < MP3_GRANULE_COUNT; i_granule++) {
		for(i_channel = 0; i_channel < channels; i_channel++) {
			granule = &side.granule_info[i_granule][i_channel];
			if(i_channel == 0) { /* `l̂ݎgp */
				bs_tmp = bs;
				/* nt}Count1̈I[ô߁Aǂݍ񂾃rbgZbgĂ܂B
				 * XP[t@N^(Part2)+nt}(Part3)̍vrbgGRANULE.part2_3_lengthƂȂ܂B
				 */
				bs_tmp.read_bits = 0;
				/* Part2: XP[t@N^ǂݍ݁B */
				mp3_read_scalefactor(&bs_tmp, granule, &scale, !i_granule ? 0 : side.scfsi[i_channel]);
				/* Part3: nt}B */
				count = mp3_huffman_decode(&bs_tmp, &frame, granule, buf1);
				if(granule->block_type == 2) {
					if(granule->mixed_block_flag) {
						/* ~bNXubN */
						/* TODO: ~bNXubN𐶐GR[_܂݂Ȃ炵̂ŁAƂ肠KvȂ悤łB */
						memset(buf1, 0, sizeof buf1);
					} else {
						/* V[gubN */
						/* tʎqB */
						mp3_requantize_short(&frame, granule, &scale, buf1, buf2);
						/* V[gubNɂ͂ƂƃGAVO팸͂܂B */
						/* IMDCTB */
						mp3_imdct_short(buf2, buf1, &mp3->imdct_save[0]);
					}
				} else {
					/* BigValue/Count1̈̃f[^܂ރTuoh߂܂B */
					subband_count = (count + (MP3_SUBBAND_COUNT - 1)) / MP3_SUBBAND_COUNT;
					/* OubN */
					/* tʎqB */
					mp3_requantize_long(&frame, granule, &scale, buf1, buf2, count);
					/* GAVO팸B */
					mp3_antialias(buf2, subband_count);
					/* IMDCTB */
					mp3_imdct_long(buf2, buf1, &mp3->imdct_save[0], subband_count);
				}
				/* TuohB */
				mp3->subband_synthesys_offset = mp3_subband_synthesys(buf1, out, &mp3->subband_synthesys_save[0][0], mp3->subband_synthesys_offset, convert);
				out += convert->count * MP3_SUBBAND_SIZE; /* TvOgϊ̃Oj[Tv */
			}
			mp3_bitstream_skip(&bs, granule->part2_3_length);
		}
	}

	/* TvOgƃTvi[܂B */
	mp3->sampling_frequency = convert->sampling_frequency;
	mp3->c_fbuff = convert->count * MP3_SUBBAND_SIZE * MP3_GRANULE_COUNT; /* TvOgϊ̃t[Tv */

	/* t[ʒui߂܂B */
	mp3->pos += frame_size;

	return 0;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

int
mp3_play(const void* data, int len)
{
	static MP3DRIVER mp3; /* STATICł! */

#ifdef PIECE
	/* ԂɍȂ̂ŁA~ނ𓾂EFCg炵܂B
	 * AvP[VIɁAIɃEFCgɖ߂Kv͂܂B
	 *   AvP[VÍAVXepceCPUSetSpeed()Ăł邩łB
	 *   pceCPUSetSpeed()ĂԂƁAWX^Đݒ肳ĎIɌɖ߂܂B
	 * 
	 * 48MHzEg2EFCghłقƂǊԂɍ悤ɂȂ܂B
	 * ł܂Ɉ̂ŁAς1EFCĝ܂܂ɂĂ܂B
	 * SD悷ȂA2EFCgɖ߂Ăm܂B
	 * ̏ꍇAubA6_4_A5WT = 1vubA10_9_A10WT = 1v̓sRgAEgĂB
	 */
	//turbo(1);		/* m48MHz[hɂ */
	//bA6_4_A5WT   = 1;	/* SRAM  2=>1 WAIT */
	//bA10_9_A10WT = 1;	/* FLASH 2=>1 WAIT */
	//2003/11/22 EFCg̒turbo()֐łł悤ɂȂ܂B
	//turbo(7); /* CLOCK:48MHz/SRAM:1WAIT/FLASH:1WAIT */
	//2005/03/07 turbo()֐ɏo̓fBZ[uxԂ̐ݒǉƂɒǏ]܂B
	turbo(-1); /* SRAM:1WAIT,0.5Cycle/FLASH:1WAIT,0.5Cycle/CLOCK:48MHz */
#endif /*PIECE*/

	/* ܂mɒ~܂B */
	mp3_stop();

	/* MP3hCo܂B */
	if(mp3_init(&mp3, data, len) != 0) return -1;

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(MP3BUFLEN, mp3_stream_callback, (int)&mp3, 0);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(MP3BUFLEN, mp3_stream_callback, (intptr_t)&mp3, 0);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
mp3_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* MP3hCõN[Abv͕svłB */
}

