/*	
 *	clipmod.c
 *
 *	P/ECE MOD Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Sun Sep 14 18:44:00 JST 2003 Naoyuki Sawa
 *	- clippce.c番B
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	P/ECE MOD Driver/Stream
 ****************************************************************************/

/*---------- P/ECE MOD Driver (}Vˑ) ----------*/

typedef struct _MODTAG {
	char tag[4 + 1];	/* ^O */
	unsigned char chans;	/* `l */
} MODTAG;
static const MODTAG mod_tags[] = {
	{ "M.K.",  4 },		/* ꂪWMOD` */
	{ "1CHN",  1 },		/* ȉAgMOD` */
	{ "2CHN",  2 },
	{ "3CHN",  3 },
	{ "4CHN",  4 },
	{ "5CHN",  5 },
	{ "6CHN",  6 },
	{ "7CHN",  7 },
	{ "8CHN",  8 },
	{ "9CHN",  9 },
	{ "10CH", 10 },
	{ "11CH", 11 },
	{ "12CH", 12 },
	{ "13CH", 13 },
	{ "14CH", 14 },
	{ "15CH", 15 },
	{ "16CH", 16 },
	{ "    ",  0 },		/* (I[) */
};

int
mod_init(MODDRIVER* driver, const void* data)
{
	MODHEADER* header = (MODHEADER*)data;
	int i, patno_max;
	MODSAMPLE* sample;
	unsigned int* pattern;
	unsigned char* smpdat;

	/* ܂[NAB */
	memset(driver, 0, sizeof(MODDRIVER));

	/* wb_AhXi[܂B */
	driver->header = header;

	/* ^O𒲂ׂāA`li[܂B */
	for(i = 0; mod_tags[i].chans != 0; i++) {
		if(memcmp(header->tag, mod_tags[i].tag, 4) == 0) break;
	}
	if(mod_tags[i].chans == 0) return -1; /* m̃^O */
	driver->chans = mod_tags[i].chans;

	/* őp^[ԍ𒲂ׂ܂B */
	patno_max = -1;
	for(i = 0; i < header->seqlen; i++) {
		if(header->sequence[i] > patno_max) {
			patno_max = header->sequence[i];
		}
	}

	/* p^[AhXi[܂B */
	pattern = (unsigned int*)(header + 1);
	for(i = 0; i <= patno_max; i++) {
		driver->pattern[i] = pattern;
		pattern += driver->chans * 64; /* ROW=NOTE*chans, PATTERN=ROW*64 */
	}

	/* Tvf[^AhXi[܂B */
	smpdat = (unsigned char*)pattern;
	for(i = 0, sample = header->sample; i < 31; i++, sample++) {
		driver->smpdat[i] = smpdat;
		smpdat += SWAPH(sample->length) * 2;
	}

	/* lݒB */
	driver->speed = 6;
	driver->tempo = 125;
	driver->tick = (driver->speed - 1) * driver->tempo; /* ^CAEg悤 */

	return 0;
}

int
mod_tick(MODDRIVER* driver, short wbuff[/*MODBUFLEN*/])
{
	int retval;

	/* Mon Feb 24 19:00:00 JST 2003 Naoyuki Sawa
	 * - GtFNgF00(SetSpeed=0)w肳ꂽAt~܂B
	 *   FastTracker 2Â悤ȋɂȂĂ邻łB
	 * - {AMODHEADER.seqrep127ȏ̒lw肷΁AȂ̓[vȂȂ܂B
	 *   ModPlugTrackerł́AseqrepɗLȃV[PXԍ傫ȒlwłȂ悤ŁA
	 *   127w肵ĂAZ[uƒlςĂ܂A[vȈɂȂĂ܂܂B
	 *   Ȃ̍ŌɔȂ̃p^[uāAŃ[vđΏ邱Ƃł܂A
	 *   ]v1p^[̗eʁi4gbN1KBjĂ܂܂B
	 *   ŁAȂ̍ŌSetSpeed=0uāAt~@̂邱Ƃɂ܂B
	 *   MOD̐Ȏdlł͂܂񂪁AFastTracker 2݊Ȃ΂قǖ͂Ȃł傤B
	 * - ܂łǂAseqrep127ȏ̒lċȂ~@LłB
	 *   ꂪ@Ȃ̂ŁAgbJ[ΉĂȂAseqrepɂ~@gĂB
	 */
	if(driver->speed == 0) return 1;

	/* V[PXB */
	retval = mod_seq(driver);
	if(retval != 0) return retval;

	/* ~LVOB */
	retval = mod_mix(driver, wbuff);
	if(retval != 0) return retval;

	return 0;
}

/*---------- P/ECE MOD Stream (}Vˑ) ----------*/

static int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//mod_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
mod_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	return mod_tick((MODDRIVER*)param, wbuff);
}

int
mod_play(const void* data)
{
	static MODDRIVER driver; /* rs`shbłI */

	/* ܂mɒ~܂B */
	mod_stop();

	/* MODhCo܂B */
	if(mod_init(&driver, data) != 0) return -1;

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(MODBUFLEN, mod_stream_callback, (int)&driver, 0);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(MODBUFLEN, mod_stream_callback, (intptr_t)&driver, 0);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
mod_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* MODhCõN[Abv͕svłB */
}

