/*	
 *	clipmidi.h
 *
 *	P/ECE MIDI Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Tue Aug 30 22:28:00 JST 2003 Naoyuki Sawa
 *	- VK쐬B
 *	* Tue Sep 02 24:00:00 JST 2003 Naoyuki Sawa
 *	- F}bvΉB
 *	- Yp[gΉB
 *	- `laΉB
 *	* Tue Sep 03 04:02:00 JST 2003 Naoyuki Sawa
 *	- e|CB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	[J֐錾
 ****************************************************************************/

//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//static int midi_stream_callback(short* wbuff, int param);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
static int midi_stream_callback(short* wbuff, intptr_t param);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
static int midi_read(const unsigned char** ptr, int len);
static void midi_note_on(MIDIDRIVER* driver, int i_channel, int note, int velocity);
static void midi_note_off(MIDIDRIVER* driver, int i_channel, int note, int velocity);

/****************************************************************************
 *	[Jϐ`
 ****************************************************************************/

/* MIDIm[gio[MODsIhlϊ\() */
static const short note_period[128] = {
	13696,12928,12192,11520,10848,10240, 9664, 9120, 8608, 8128, 7680, 7248,	/*   0` 11 */
	 6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3624,	/*  12` 23 */
	 3424, 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1812,	/*  24` 35 */
	 1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016,  960,  906,	/*  36` 47 */
	  856,  808,  762,  720,  678,  640,  604,  570,  538,  508,  480,  453,	/*  48` 59 */
	  428,  404,  381,  360,  339,  320,  302,  285,  269,  254,  240,  226,	/*  60` 71 */
	  214,  202,  190,  180,  170,  160,  151,  143,  135,  127,  120,  113,	/*  72` 83 */
	  107,  101,   95,   90,   85,   80,   75,   71,   67,   63,   60,   56,	/*  84` 95 */
	   53,   50,   47,   45,   42,   40,   37,   35,   33,   31,   30,   28,	/*  96`107 */
	   26,   25,   23,   22,   21,   20,   18,   17,   16,   15,   15,   14,	/* 108`119 */
	   13,   12,   11,   11,   10,   10,    9,    8,				/* 120`127 */
};

#define RHYTHM_NOTE	60	/* YF͏ɂ̉Ŗ炷() */

/****************************************************************************
 *	midi_play
 ****************************************************************************/

int
midi_play(const void* data, const void* inst, const MIDIMAP* map)
{
	static MIDIDRIVER driver; /* rs`shbłI */

	/* ܂mɒ~܂B */
	midi_stop();

	/* MIDIhCo܂B */
	if(midi_init(&driver, data, inst, map) != 0) return -1;

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(MODBUFLEN, midi_stream_callback, (int)&driver, 0);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(MODBUFLEN, midi_stream_callback, (intptr_t)&driver, 0);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

/****************************************************************************
 *	midi_stop
 ****************************************************************************/

void
midi_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* MIDIhCõN[Abv͕svłB */
}

/****************************************************************************
 *	midi_init
 ****************************************************************************/

int
midi_init(MIDIDRIVER* driver, const void* data, const void* inst, const MIDIMAP* map)
{
	const unsigned char* ptr = data;
	int value, i_track;
	MIDITRACK* track;

	/* ܂[NAB */
	memset(driver, 0, sizeof(MIDIDRIVER));

	/* F}bvi[܂B */
	driver->map = map;

	/*----- MOD -----*/

	if(mod_init(&driver->mod, inst) != 0) DIE();
	driver->mod.chans = MODCHANS; /* ƂđS`lgp */

	/*----- wb_`N -----*/

	/* `N^Cv܂B */
	if(memcmp(ptr, "MThd", 4) != 0) DIE();
	ptr += 4;

	/* f[^܂B */
	value = midi_read(&ptr, 4);
	if(value != 6) DIE();

	/* tH[}bg܂B */
	value = midi_read(&ptr, 2);
	if(value < 0 || 1 < value) DIE(); /* tH[}bg2͖Ή */

	/* gbNi[܂B */
	driver->track_count = midi_read(&ptr, 2);
	if(driver->track_count > MIDITRACKS) driver->track_count = MIDITRACKS; /* T|[gőgbNȍ~͖ */

	/* ԒPʂi[܂B */
	driver->time_unit = midi_read(&ptr, 2);
	if(driver->time_unit & 0x8000) DIE(); /* ΎԎw͖Ή */

	/*----- gbN`N -----*/

	for(i_track = 0; i_track < driver->track_count; i_track++) {
		track = &driver->track[i_track];

		/* `N^Cv܂B */
		if(memcmp(ptr, "MTrk", 4) != 0) DIE();
		ptr += 4;

		/* f[^擾܂B */
		value = midi_read(&ptr, 4);

		/* tʒuݒ肵܂B */
		track->pos = ptr;
		ptr += value; /* ptr͎̃gbN`Nw */

		/* f^^Cݒ肵܂B */
		track->delta = midi_read(&track->pos, 0);
	}

	/*----- lݒ -----*/

	driver->tempo = 60 * 1000 * 1000 / 120; /*  */

	return 0;
}

/****************************************************************************
 *	midi_tick
 ****************************************************************************/

int
midi_tick(MIDIDRIVER* driver, short wbuff[/*MODBUFLEN*/])
{
	int retval;

	/* V[PXB */
	retval = midi_seq(driver);
	if(retval != 0) return retval;

	/* ~LVOB */
	retval = midi_mix(driver, wbuff);
	if(retval != 0) return retval;

	return 0;
}

/****************************************************************************
 *	midi_seq
 ****************************************************************************/

int
midi_seq(MIDIDRIVER* driver)
{
	long long delta_step, usec_per_delta; /* ԌvZ̓~bPʂȂ̂ŁAintł͑Ȃ */
	int playing, i_track, i_channel, event, data1, data2;
	MIDITRACK* track;

	/* o߃f^^C߂܂B */
	driver->timer += 1000 * 1000 / 50/*Xg[Đ̊荞݃TCN*/;
	usec_per_delta = driver->tempo / driver->time_unit; /* Z덷͂قƂǋCɂȂȂ̂Ŗ */
	delta_step = driver->timer / usec_per_delta;
	driver->timer -= delta_step * usec_per_delta;

	playing = 0; /* t̃gbN */
	for(i_track = 0; i_track < driver->track_count; i_track++) {
		track = &driver->track[i_track];
		if(!track->pos) continue; /* tgbN͔΂ */

		/* CxgB */
		track->delta -= delta_step;
		while(track->delta <= 0) {
			/* Cxgǂݍ݂܂B */
			event = midi_read(&track->pos, 1);
			if(event & 0x80) {
				track->running_status = event;
			} else {
				event = track->running_status;
				track->pos--;
			}

			/* `l擾܂B */
			i_channel = event & 0xf;

			/* Cxg̎ނɂāc */
			switch(event >> 4) {
			case 0x8: /* m[gIt */
				data1 = midi_read(&track->pos, 1);
				data2 = midi_read(&track->pos, 1);
				if(i_channel != 10 - 1) { /* MIDĨm[gItCxg͖ǂ */
					midi_note_off(driver, i_channel, data1, data2);
				}
				break;
			case 0x9: /* m[gI */
				data1 = midi_read(&track->pos, 1);
				data2 = midi_read(&track->pos, 1);
				if(data2 != 0) {
					midi_note_on(driver, i_channel, data1, data2);
				} else { /* xVeB0̃m[gÍAm[gIt̑p */
					if(i_channel != 10 - 1) { /* MIDĨm[gItCxg͖ǂ */
						midi_note_off(driver, i_channel, data1, data2);
					}
				}
				break;
			case 0xa: /* |tHjbNL[vbV[ */
				data1 = midi_read(&track->pos, 1);
				data2 = midi_read(&track->pos, 1);
				/* Ή */
				break;
			case 0xb: /* Rg[`FW */
				data1 = midi_read(&track->pos, 1);
				data2 = midi_read(&track->pos, 1);
				/* Ή */
				break;
			case 0xc: /* vO`FW */
				data1 = midi_read(&track->pos, 1);
				driver->channel[i_channel].program = data1;
				break;
			case 0xd: /* `lvbV[ */
				data1 = midi_read(&track->pos, 1);
				/* Ή */
				break;
			case 0xe: /* sb`xh`FW */
				data1 = midi_read(&track->pos, 1);
				data2 = midi_read(&track->pos, 1);
				/* Ή */
				break;
			case 0xf:
				switch(i_channel) {
				case 0x0: /* VXeGNXN[VubZ[W(I[) */
					data1 = midi_read(&track->pos, 0);
					track->pos += data1 - 1;
					data1 = midi_read(&track->pos, 1);
					if(data1 != 0xf7) DIE();
					break;
				case 0x7: /* VXeGNXN[VubZ[W(I[Ȃ) */
					data1 = midi_read(&track->pos, 0);
					track->pos += data1;
					break;
				case 0xf: /* ^Cxg */
					data1 = midi_read(&track->pos, 1);
					data2 = midi_read(&track->pos, 1);
					switch(data1) {
					case 0x2f: /* GhIugbN */
						if(data2 != 0) DIE();
						track->pos = NULL; /* t}[N */
						goto NEXT_TRACK;
						break;
					case 0x51: /* Zbge| */
						if(data2 != 3) DIE();
						driver->tempo = midi_read(&track->pos, 3);
						break;
					/*{{Ή*/
					case 0x00: /* V[PXԍ */
					case 0x01: /* eLXg */
					case 0x02: /* 쌠\ */
					case 0x03: /* V[PX/gbN */
					case 0x04: /* y햼 */
					case 0x05: /* ̎ */
					case 0x06: /* }[J */
					case 0x07: /* L[|Cg */
					case 0x20: /* MIDI`lvtBbNX */
					//case 0x2f: /* GhIugbN */
					//case 0x51: /* Zbge| */
					case 0x54: /* SMPTEItZbg */
					case 0x58: /* q */
					case 0x59: /*  */
					case 0x7f: /* V[PTŗL̃^Cxg */
					default: /* (s) */
						track->pos += data2;
						break;
					}
					/*}}Ή*/
					break;
				default:
					DIE();
				}
				break;
			default:
				DIE();
			}

			/* ̃f^^Cݒ肵܂B */
			track->delta += midi_read(&track->pos, 0);
		}
		playing++; /* t̃gbNJEgAbv */
NEXT_TRACK:
	}

	/* t̃gbN0AȂ1Ԃ܂B */
	return playing == 0;
}

/****************************************************************************
 *	midi_mix
 ****************************************************************************/

int
midi_mix(MIDIDRIVER* driver, short wbuff[/*MODBUFLEN*/])
{
	int result, i_voice;
	MIDIVOICE* voice;
	MODCHANNEL* modch;

	/* MODɔC܂B */
	result = mod_mix(&driver->mod, wbuff);

	/* MOD`lǗXVB */
	voice = &driver->voice[0];
	modch = &driver->mod.channel[0];
	for(i_voice = 0; i_voice < MODCHANS; i_voice++) {
		/* }[NĂ... */
		if(voice->age) {
			if(modch->period) {
				/* pȂAJEgAbvB */
				voice->age++;
			} else {
				/* IĂAǗNAB */
				voice->age = 0;
			}
		}
		voice++;
		modch++;
	}

	return result;
}

/****************************************************************************
 *	midi_stream_callback
 ****************************************************************************/

static int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//midi_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
midi_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	return midi_tick((MIDIDRIVER*)param, wbuff);
}

/****************************************************************************
 *	midi_read
 ****************************************************************************/

static int
midi_read(const unsigned char** ptr, int len)
{
	int value, n;

	value = 0;
	if(len == 0) {
		/* ϒ */
		do {
			n = *(*ptr)++;
			value = (value << 7) | (n & 0x7f);
		} while(n & 0x80);
	} else {
		/* Œ蒷 */
		do {
			n = *(*ptr)++;
			value = (value << 8) | n;
		} while(--len);
	}

	return value;
}

/****************************************************************************
 *	midi_note_on
 ****************************************************************************/

static void
midi_note_on(MIDIDRIVER* driver, int i_channel, int note, int velocity)
{
	const MIDIMAP* map;
	MIDICHANNEL* midch;
	MIDIVOICE* voice;
	MODCHANNEL* modch;
	int smpno, i_voice, sel_voice, age, max_age;

	/* `lEm[gɖĂAmɒ~܂B */
	midi_note_off(driver, i_channel, note, velocity);

	/* MIDIvOio[܂MIDIm[gio[AMODTvio[֕ϊ܂B */
	map = driver->map;
	if(i_channel != 10 - 1) { /* fB */
		midch = &driver->channel[i_channel];
		smpno = map->melody[midch->program];
	} else {		  /* Y */
		smpno = map->rhythm[note];
	}
	if(!smpno) return; /* F}bvݒ肳ĂȂΖ炳Ȃ */

	/* 󂫃`lA܂͂΂񋌂`lT܂B */
	voice = &driver->voice[0];
	sel_voice = 0;
	max_age = 0;
	for(i_voice = 0; i_voice < MODCHANS; i_voice++) {
		age = voice->age;
		if(!age) {
			/* 󂫃`lAmB */
			sel_voice = i_voice;
			break;
		}
		if(age > max_age) {
			/* 苌`lB */
			sel_voice = i_voice;
			max_age = age;
			/* p */
		}
		voice++;
	}

	/* Ǘɔ}[NB */
	voice = &driver->voice[sel_voice];
	voice->age = 1;
	voice->channel = i_channel;
	voice->note = note;

	/*{{F*/
	if(smpno & 0x80) {
		velocity <<= 2;
		smpno &= ~0x80;
		if(!smpno) DIE();
	}
	/*}}F*/

	/* MODhCoɔwB */
	modch = &driver->mod.channel[sel_voice];
	modch->smpno = smpno - 1; /* MODhCoł́ATvio[1`320`31ɒuĈĂ܂ */
	modch->volume = (velocity + 1) / 2; /* velocity:0`127 => volume:0`64 */
	if(i_channel != 10 - 1) { /* fB */
		modch->period = note_period[note];
	} else {		  /* Y */
		modch->period = note_period[RHYTHM_NOTE];
	}
	modch->offset = 0;
}

/****************************************************************************
 *	midi_note_off
 ****************************************************************************/

static void
midi_note_off(MIDIDRIVER* driver, int i_channel, int note, int velocity)
{
	MIDIVOICE* voice;
	MODCHANNEL* modch;
	int i_voice;

	/* w̃`lEm[gĂA~܂B */
	voice = &driver->voice[0];
	for(i_voice = 0; i_voice < MODCHANS; i_voice++) {
		if(voice->age) {
			if(voice->channel == i_channel && voice->note == note) {
				/* Ǘɒ~}[NB */
				voice->age = 0;
				/* MODhCoɒ~wB */
				modch = &driver->mod.channel[i_voice];
				modch->period = 0;
				return;
			}
		}
		voice++;
	}
}

