/*	
 *	clipmati.c
 *
 *	[eBeBFw֐()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Aug 10 21:41:17 JST 2017 Naoyuki Sawa
 *	- 쐬JnB
 *	- clipmath.cAł̊֐̎Aclipmati.c֕܂B
 *	  ۂ̃AvP[Vł͎łł̕Еgp鎖AЕʂɃNėeʂ鎖邽߂łB
 */
#include "clip.h"
//*****************************************************************************
//	`()
//*****************************************************************************
//x`yAn/dŕԂ܂B
//[in]
//	x		JnlB		INT_MIN`INT_MAX
//	y		IlB		INT_MIN`INT_MAX
//	n		ԌW̕qB	INT_MIN`INT_MAX
//	d		ԌW̕B	1`INT_MAX,-1`INT_MIN	0̂ݕs
//[out]
//	߂l		x+(y-x)*(n/d)		ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ́A߂l͕sƂȂB<>{x=0,y=1<<30,n=5,d=1}w肵ꍇȂǁB
//[note]
//	- ֐́A̕⊮p{ɂȂƎv̂ŁAėpdāA̒l͈݂̔͂̐Ȃ悤ɍ쐬܂B
//	  Iɂ͉Zr64rbgZsĂ̂ŁA(ʈȊO)Zrł̌ӂSzKv͗L܂B
//	  ł'lerp()'ƁAقړoŎgƎv܂B
//	  ڍׂ́Aȉ̒ʂłB
//	- xy̑召͕słB
//	  (x<y)ł(x=y)ł(x>y)ł\܂B
//	- xy͂ꂼAINT_MIN`INT_MAX̔Cӂ̒lłB
//	  (|x-y|>INT_MAX)ł\܂B				ʓIɂ(|x-y|INT_MAX)Ƃ͎v܂Aėp̂߂(|x-y|>INT_MAX)Ή܂B̑Ή̂߂ɁA⏈ȂĂ܂B
//	- n͈ʓIɂ́A0ȏdȉ(d<0̏ꍇ0ȉdȏ)̒lłB
//	  K{ł͂ȂAL͈̔͊O̒lł\܂B
//	- d͈ʓIɂ́A1`INT_MAX̒lłB
//	  K{ł͂ȂA-1`INT_MIN̒lł\܂B		ʓIɂ(1dINT_MAX)Ƃ͎v܂Aėp̂߂(-1dINT_MIN)Ή܂B̑Ή̂߂ɁA⏈ȂĂ܂B
#ifndef PIECE
int lerp_i(int x, int y, int n, int d) {
	if(d < 0) {
		n = -n;
		d = -d;
	}
	if(y < x) {
		y -= x;
		y = -y;
	    //{{ʏ
		if(n < 0) {
			n = -n;
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
			y = -y;	//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
		} else {
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
		}		//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
	    //}}ʏ
		y = -y;
	} else {
		y -= x;
	    //{{ʏ
		if(n < 0) {
			n = -n;
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
			y = -y;	//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
		} else {
			y = (uint64_t)(unsigned)y * (uint64_t)(unsigned)n / (uint64_t)(unsigned)d;
		}		//    ~~~~~~~~~~              ~~~~~~~~~~              ~~~~~~~~~~	X̕ϐy,n,d͕t̒lłAɕ̒lɕ␳ς݂Ȃ̂ŁAbit31bit63`32֕gȂ悤ɁA܂(unsigned)ւ̃LXgKvłB
	    //}}ʏ
	}
	return x + y;
}
#else //PIECE
//AZułlerp_i()ۑ郌WX^ɂ:
//AZułlerp_i()́A%r9,%r10,%r11,%r13,%r14,%r15,%alr,%ahr,%psr j󂵂܂B
//ĂяoKɂĕۑ`tĂ %r0`%r3,y,%r8 ɉāA%r4`%r7,y,%r12 ۑ܂B	!!
//Ăяo̊֐́AL̃WX^ۑ鎖OƂāAL̃WX^̑ޔȗĂ\܂B	
//AZuł̐\ɂ(2017/07/28)
//CłAZuł̕A64oCgA10{łB	!!
//Cłframdi.oRAMɒuꍇƔׂĂA3{łB	
//CłƃAZuł̑x傫ႤŔACłł́AKv܂Ńt64rbg揜ZsĂ܂Ă܂A
//AZułł́AKvŒ32rbg~32rbg64rbgZCyсC64rbg32rbg32rbgZɍœK̂ŁA
//CłƈāA\tgEFAɂ64rbg揜Z[`(framdi.o)͌ĂяoA@Bꖽ߂ōς܂ꂽłB
//xv̌ʂ̏ڍׂ́Aȉ̒ʂłB
//yxvɎgpeXgvOz
//#define N 10000
//int data[N][4];
//int app_main(int argc, char* argv[]) {
//  int i, j, t;
//  srand48(0);
//  for(i = 0; i < N; i++) {
//    double d;
//         data[i][0] = mrand48();
//         data[i][1] = mrand48();
//         data[i][2] = mrand48();
//    do { data[i][3] = mrand48(); } while(!data[i][3]);
//    d = lerp(data[i][0], data[i][1], (double)data[i][2] / (double)data[i][3]);
//    if((d < INT_MIN) || (d > INT_MAX)) { i--; }
//  }
//  t = pceTimerGetCount();
//  for(j = 0; j < 10; j++) {
//    for(i = 0; i < N; i++) {
//      lerp_i(data[i][0], data[i][1], data[i][2], data[i][3]);
//    }
//  }
//  t = pceTimerGetCount() - t;
//  die("%d", t);
//  return 0;
//}
//yxv̌ʁzTURBO[hAX^bN͍RAMɔzuĎs܂B
//EC(framdi.oSRAMɔzu)     7555~b
//EC(framdi.oRAMɔzu)  2272~b
//EAZu(framdi.o͊֌W)   767~b
int lerp_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		lerp_i
lerp_i:
		;//%r12 := x
		;//%r13 := y
		;//%r14 := n
		;//%r15 := d
		cmp		%r15, 0			;//if(d < 0) {
		jrge.d		lerp_i_L10		;//  
		ld.w		%r9, 8-1		;//%r9       := i = 8-1		*delay*	
		not		%r14, %r14		;//  %r14    := n = -n			@
		add		%r14, 1			;//  					@
		not		%r15, %r15		;//  %r15    := d = -d			@
		add		%r15, 1			;//  					@
lerp_i_L10:						;//}					@
		sub		%r13, %r12		;//%r13      := y -= x			@
		jrge.d		lerp_i_L20		;//if(ύXOy < x) {			@
		ld.w		%r11, %psr		;//%psrۑ@			*delay*	@
		not		%r13, %r13		;//  %r13    := y = -y			@
		add		%r13, 1			;//  					@
lerp_i_L20:						;//}					@
		cmp		%r14, -1		;//if(ύXOn <= -1) {		@		(n>-1)Ȃ%psr(Z)=0ŕ򂷂B(n<=-1)Ȃ%psr(Z)=1̉\L邪Ả̏%psr(Z)=0ɂȂB
		jrgt.d		lerp_i_L30		;//  					@
		ld.w		%r10, %psr		;//%psrۑA			*delay*	@
		sub		%r14, 1			;//  %r14    := n = -n			@		̏ŕK%psr(Z)=0ɂȂB-10ɂȂ̂(n=1)ꍇ݂̂A(n=1)Ȃ΂ւ͗ȂB
		not		%r14, %r14		;//					@
lerp_i_L30:						;//}					@		򂵂ꍇ򂵂ȂꍇAŕK%psr(Z)=0ɂȂĂB̌̃[v̏%psr(Z)܂ŕωȂ悤ӂB
		mltu.w		%r13, %r14		;//%ahr:%alr := (y * n)			@	@
		ld.w		%r14, %ahr		;//%r14      := (y * n)[63:32]		@	@
		div0u		%r15			;//%ahr      :=    0			@	@	%psr(DS,N)=0
		ld.w		%ahr, %r14		;//%ahr:%alr := (y * n)			@	@
	;//	ld.w		%r9, 8-1		;//%r9       := i = 8-1				@
lerp_i_L40:						;//do {						@
		div1		%r15			;//  1						@	
		div1		%r15			;//  2						@	div1s鎞'%psr(DS,N)=0'ێĂKv鎖ɒӂB
		div1		%r15			;//  3						@	
		div1		%r15			;//  4						@	
		jrne.d		lerp_i_L40		;//} while(i != 0)					%psr(Z)=0ł͂Ȃ̂ŕK[vBڈȍ~͂̉ŕω%psr(Z)QƂă[vB
		sub		%r9, 1			;//  %r9     := i--		*delay*		
		ld.w		%psr, %r10		;//%psrA
		jrgt.d		lerp_i_L50		;//if(ύXOn <= -1) {
		ld.w		%r10, %alr		;//%r10      := y = (y * n) / d	*delay*
		not		%r10, %r10		;//  %r10    := y = -y
		add		%r10, 1			;//  
lerp_i_L50:						;//}
		ld.w		%psr, %r11		;//%psr@
		jrge		lerp_i_L60		;//if(ύXOn < 0) {
		not		%r10, %r10		;//  %r10    := y = -y
		add		%r10, 1			;//  
lerp_i_L60:						;//}
		ret.d					;//return       x + y
		add		%r10, %r12		;//%r10      := x + y		*delay*
");
#endif//PIECE
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//lerp_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		     n = mrand48();
		do { d = mrand48(); } while(!d);
		a = lerp_i(x, y,         n,          d);
		b = lerp(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//*****************************************************************************
//	C[WO()
//*****************************************************************************
//蓮oĉ铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX
//	y		IlB		INT_MIN`INT_MAX
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeIn_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
#ifndef PIECE
int easeIn_i(int x, int y, int n, int d) {
	n *= n;	//
	d *= d;	//
	return lerp_i(x, y, n, d);
}
#else //PIECE
int easeIn_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		easeIn_i
easeIn_i:
		mlt.h		%r14, %r14		;//%r14 := n *= n
		ld.w		%r14, %alr		;//
		mlt.h		%r15, %r15		;//%r15 := d *= d
		xjp.d		lerp_i			;//return lerp_i(x, y, n, d)
		ld.w		%r15, %alr		;//				*delay*
");
#endif//PIECE
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeIn_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		a = easeIn_i(x, y,         n,          d);
		b = easeIn(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//œoČ铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX
//	y		IlB		INT_MIN`INT_MAX
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeOut_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
#ifndef PIECE
int easeOut_i(int x, int y, int n, int d) {
	n = -n;
	n += d;
	return easeIn_i(y, x, n, d);
}
#else //PIECE
int easeIn_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		easeOut_i
easeOut_i:
		not		%r14, %r14		;//%r14 := n = -n
		add		%r14, 1			;//
		add		%r14, %r15		;//%r14 := n += d
		ld.w		%r9, %r12		;//%r9  :=            x
		ld.w		%r12, %r13		;//%r12 :=         y
		xjp.d		easeIn_i		;//return easeIn_i(y, x, n, d)
		ld.w		%r13, %r9		;//%r13 :=            x		*delay*
");
#endif//PIECE
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeOut_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		a = easeOut_i(x, y,         n,          d);
		b = easeOut(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//蓮oĉA܂铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX	̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	y		IlB		INT_MIN`INT_MAX	
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeInOut_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
//{{2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//#ifndef PIECE
//int easeInOut_i(int x, int y, int n, int d) {
//	y += x;								//̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	n <<= 1;
//	if(n >= d) {
//		x = -x;
//		x += y;
//		n = -n;
//		n += d << 1;
//	}
//	y >>= 1;
//	return easeIn_i(x, y, n, d);										//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//}
//#else //PIECE
//int easeInOut_i(int x, int y, int n, int d);
//asm("
//		.code
//		.align		1
//		.global		easeInOut_i
//easeInOut_i:
//		sla		%r14, 1			;//%r14 := n <<= 1
//		cmp		%r14, %r15		;//if(n >= d) {
//		jrlt.d		easeInOut_i_L10		;//  
//		add		%r13, %r12		;//%r13 := y += x		*delay*
//		not		%r12, %r12		;//  %r12 := x = -x
//		add		%r12, 1			;//  
//		add		%r12, %r13		;//  %r12 := x += y
//		not		%r14, %r14		;//  %r14 := n = -n
//		add		%r14, 1			;//  
//		add		%r14, %r15		;//  %r14 := n += d << 1
//		add		%r14, %r15		;//  
//easeInOut_i_L10:					;//}
//		xjp.d		easeIn_i		;//return easeIn_i(x, y, n, d)				//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//		sra		%r13, 1			;//%r13 := y >>= 1		*delay*
//");
//#endif//PIECE
//}}2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeInOut_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		if((((double)x + (double)y) < (double)INT_MIN) || (((double)x + (double)y) > (double)INT_MAX)) { continue; }
		a = easeInOut_i(x, y,         n,          d);
		b = easeInOut(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//œoČA܂铮łB
//[in]
//	x		JnlB		INT_MIN`INT_MAX	̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	y		IlB		INT_MIN`INT_MAX	
//	n		ԌW̕qB	0`d
//	d		ԌW̕B	1`SHRT_MAX
//[out]
//	߂l		ԌʁB
//[note]
//	- lerp_i()͊{Ȃ̂ŔėpdĈ̒l͈݂̔͂̐Ȃ悤ɂ܂A֐(easeOutIn_i())͖[Ǝv̂Ŕėp͏d܂łB
//	  ̂߁Alerp_i()d(ЂĂ͈n)̒l͈̔͂̐łB
//	  ʓIȎgł͏[Ǝv܂A̒l5(=?)ȏɂȂP[Xł́AӂĉB
//{{2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//#ifndef PIECE
//int easeOutIn_i(int x, int y, int n, int d) {
//	y += x;								//̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
//	n <<= 1;
//	if(n >= d) {
//		x = -x;
//		x += y;
//		n = -n;
//		n += d << 1;
//	}
//	y >>= 1;
//	return easeOut_i(x, y, n, d);										//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//}
//#else //PIECE
//int easeOutIn_i(int x, int y, int n, int d);
//asm("
//		.code
//		.align		1
//		.global		easeOutIn_i
//easeOutIn_i:
//		sla		%r14, 1			;//%r14 := n <<= 1
//		cmp		%r14, %r15		;//if(n >= d) {
//		jrlt.d		easeOutIn_i_L10		;//  
//		add		%r13, %r12		;//%r13 := y += x		*delay*
//		not		%r12, %r12		;//  %r12 := x = -x
//		add		%r12, 1			;//  
//		add		%r12, %r13		;//  %r12 := x += y
//		not		%r14, %r14		;//  %r14 := n = -n
//		add		%r14, 1			;//  
//		add		%r14, %r15		;//  %r14 := n += d << 1
//		add		%r14, %r15		;//  
//easeOutIn_i_L10:					;//}
//		xjp.d		easeOut_i		;//return easeIn_i(x, y, n, d)				//easeInOut_i()easeOutIn_i()̈Ⴂ́A̍słB
//		sra		%r13, 1			;//%r13 := y >>= 1		*delay*
//");
//#endif//PIECE
//}}2017/08/08폜:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#if 0
//easeOutIn_i()̃eXgXC[g
int app_main(int argc, char* argv[]) {
	int x, y, n, d, a;
	double b;
	for(;;) {
		     x = mrand48();
		     y = mrand48();
		do { d = lrand48() % (SHRT_MAX + 1); } while(!d);
		     n = lrand48() % d;
		if((((double)x + (double)y) < (double)INT_MIN) || (((double)x + (double)y) > (double)INT_MAX)) { continue; }
		a = easeOutIn_i(x, y,         n,          d);
		b = easeOutIn(  x, y, (double)n / (double)d);
	#ifndef PIECE
		       printf(                     "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
	#else //PIECE
		surface_clear(&surface, 0);
		render_printf(&render, 0, 0, 2, 3, "% 11d % 11d % 2d\n", a, lround(b), a - lround(b));
		update();
		if(pcePadGetDirect() & PAD_SELECT) { break; }
	#endif//PIECE
		if((b >= INT_MIN) && (b <= INT_MAX)) {	//ʂINT_MIN`INT_MAX͈̔͂Ɏ܂Ȃꍇ΁c
			if(abs(a - lround(b)) > 1) {	//̐؂̂Č덷͈̔͂Őʂ͂B
				die("x = % 11d\n"
				    "y = % 11d\n"
				    "n = % 11d\n"
				    "d = % 11d\n"
				    "a = % 11d\n"
				    "b = % 11d\n", x, y, n, d, a, lround(b));
			}
		}
	}
	return 0;
}
#endif
//-----------------------------------------------------------------------------
//{{2017/08/08ǉ:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
#ifndef PIECE
static int easeInOut_easeOutIn_i(int x, int y, int n, int d, int (*fn)(int x, int y, int n, int d));		//OQ
int easeInOut_i(int x, int y, int n, int d) { return easeInOut_easeOutIn_i(x, y, n, d, easeIn_i); }
int easeOutIn_i(int x, int y, int n, int d) { return easeInOut_easeOutIn_i(x, y, n, d, easeOut_i); }
static int easeInOut_easeOutIn_i(int x, int y, int n, int d, int (*fn)(int x, int y, int n, int d)) {
	y += x;								//̓sAZrŁA(y + x)INT_MIN`INT_MAX͈̔͂𒴂ꍇAʂsɂȂ܂B
	n <<= 1;
	if(n >= d) {
		x = -x;
		x += y;
		n = -n;
		n += d << 1;
	}
	y >>= 1;
	return (*fn)(x, y, n, d);
}
#else //PIECE
int easeInOut_i(int x, int y, int n, int d);
int easeOutIn_i(int x, int y, int n, int d);
asm("
		.code
		.align		1
		.global		easeInOut_i
		.global		easeOutIn_i
easeInOut_i:
		xld.w		%r9, easeIn_i			;//%r9  := fn = easeIn_i
		jp		easeInOut_easeOutIn_i
easeOutIn_i:
		xld.w		%r9, easeOut_i			;//%r9  := fn = easeOut_i
easeInOut_easeOutIn_i:
		sla		%r14, 1				;//%r14 := n <<= 1
		cmp		%r14, %r15			;//if(n >= d) {
		jrlt.d		easeInOut_easeOutIn_i_L10	;//  
		add		%r13, %r12			;//%r13 := y += x		*delay*
		not		%r12, %r12			;//  %r12 := x = -x
		add		%r12, 1				;//  
		add		%r12, %r13			;//  %r12 := x += y
		not		%r14, %r14			;//  %r14 := n = -n
		add		%r14, 1				;//  
		add		%r14, %r15			;//  %r14 := n += d << 1
		add		%r14, %r15			;//  
easeInOut_easeOutIn_i_L10:					;//}
		sra		%r13, 1				;//%r13 := y >>= 1
		jp		%r9				;//return (*fn)(x, y, n, d)	(jp.d %rb͕s)
");
#endif//PIECE
//}}2017/08/08ǉ:easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
