/*	
 *	clipmath.c
 *
 *	[eBeBFw֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Dec 31 09:54:58 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 *	- math.hɂ͊܂܂ȂẂAw֐܂Ƃ߂邽߂̃W[łB
 *	  AW̐w֐ǉꍇ́AW[ɒǉĉB
 *	* Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
 *	- determinant(),cofactor(),solve()ǉ܂B
 *	* Wed May 24 21:26:30 JST 2017 Naoyuki Sawa
 *	- easeIn(),easeOut(),easeInOut()ǉ܂B
 *	* Fri Jul 28 21:55:48 JST 2017 Naoyuki Sawa
 *	- lerp_i()ǉ܂B
 *	* Sat Jul 29 22:27:07 JST 2017 Naoyuki Sawa
 *	- easeIn_i(),easeOut_i(),easeInOut_i()ǉ܂B
 *	* Tue Aug 08 21:44:58 JST 2017 Naoyuki Sawa
 *	- easeOutIn(),easeOutIn_i()ǉ܂B
 *	* Tue Aug 08 22:18:34 JST 2017 Naoyuki Sawa
 *	- easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
 *	  easeInOut_i()easeOutIn_i()̏ʉāAR[hTCY팸܂B
 *	  R[hTCY팸̌ʂ́AO84oCg,12oCgŁAv96oCgȂ܂B
 *	* Thu Aug 10 21:41:17 JST 2017 Naoyuki Sawa
 *	- clipmath.cAł̊֐̎Aclipmati.c֕܂B
 *	  ۂ̃AvP[Vł͎łł̕Еgp鎖AЕʂɃNėeʂ鎖邽߂łB
 *	* Thu Aug 10 22:36:01 JST 2017 Naoyuki Sawa
 *	- easeIn(),easeOut()AZu܂B
 *	  R[hTCYA12oCgȂ܂B
 *	* Fri Aug 11 23:01:44 JST 2017 Naoyuki Sawa
 *	- easeInOut(),easeOutIn()AZu܂B
 *	  R[hTCYA64oCgȂ܂B
 */
#include "clip.h"
//*****************************************************************************
//	`
//*****************************************************************************
//Performs a Linear intERPolation.
//[in]
//	x		The first-floating point value.							xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.						
//	s		A value that Linearly intERPolates between the x parameter and the y parameter.	Iɂ(0<=s<=1)łA(s<0)(s>1)ł삵܂B
//[out]
//	return value	The result of the Linear intERPolation.
//[note]
//	- PȐ`Ԋ֐łB
//	  WC֐ł͂܂񂪁ÃQ[pCuɔĂ̂ŁAĂɂ܂B
//	- ʓIɂ'x+(s*(y-x))'ŌvZ܂A'x-(s*(x-y))'ŌvZ܂B
//	  'x+(s*(y-x))''x-(s*(x-y))'̕AAsmɃWX^̈ړ񐔂ČǂłB
#ifndef PIECE
double lerp(double x, double y, double s) {
    //{{ό`čœK܂B
    //	return (x * (1.0 - s)) + (y * s);	//Z~2,Z~2
    //ό`čœK܂B
	return x - (s * (x - y));		//Z~1,Z~2
    //}}ό`čœK܂B
}
#else //PIECE
double lerp(double x, double y, double s);
asm("
		.code
		.align		1
		.global		lerp
lerp:
		pushn		%r1
		;//%r12     := xl
		;//%r13     := xh
		;//%r14     := yl
		;//%r15     := yh
		;//[%sp+ 0] := %r0
		;//[%sp+ 4] := %r1
		;//[%sp+ 8] := retp
		;//[%sp+12] := sl
		;//[%sp+16] := sh
		ld.w		%r0, %r12		;//%r0       := xl
		xcall.d		__subdf3		;//%r11:%r10 :=          (x - y)
		ld.w		%r1, %r13		;//%r1       := xh			*delay*
		xld.w		%r12, [%sp+12]		;//%r12      :=      sl
		xld.w		%r13, [%sp+16]		;//%r13      :=      sh
		ld.w		%r14, %r10		;//%r14      :=          (x - y)l
		xcall.d		__muldf3		;//%r11:%r10 :=     (s * (x - y))
		ld.w		%r15, %r11		;//%r15      :=          (x - y)h	*delay*
		ld.w		%r12, %r0		;//%r12      := xl
		ld.w		%r13, %r1		;//%r13      := xh
		popn		%r1
		ld.w		%r14, %r10		;//%r14      :=     (s * (x - y))l
		xjp.d		__subdf3		;//%r11:%r10 := x - (s * (x - y))
		ld.w		%r15, %r11		;//%r15      :=     (s * (x - y))h	*delay*
");
#endif//PIECE
//*****************************************************************************
//	C[WO
//*****************************************************************************
//Performs a EASE-IN interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-IN interpolates between the x parameter and the y parameter.		(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-IN interpolation.
//[note]
//	- 蓮oĉ铮łB
#ifndef PIECE
double easeIn(double x, double y, double s) {
	return lerp(x, y, (s * s)/**/);
}
#else //PIECE
double easeIn(double x, double y, double s);
asm("
		.code
		.align		1
		.global		easeIn
easeIn:
		xsub		%sp, %sp, 16			;//
		xld.w		[%sp+0], %r12			;//[%sp+0]   := xl
		xld.w		[%sp+4], %r13			;//[%sp+4]   := xh
		xld.w		[%sp+8], %r14			;//[%sp+8]   := yl
		xld.w		[%sp+12], %r15			;//[%sp+12]  := yh
		xld.w		%r12, [%sp+20]			;//%r12      := sl
		xld.w		%r13, [%sp+24]			;//%r13      := sh
		ld.w		%r14, %r12			;//%r14      := sl
		xcall.d		__muldf3			;//%r11:%r10 :=      s * s
		ld.w		%r15, %r13			;//%r15      := sh			*delay*
		xld.w		%r12, [%sp+0]			;//%r12      := xl
		xld.w		%r13, [%sp+4]			;//%r13      := xh
		xld.w		%r14, [%sp+8]			;//%r14      := yl
		xld.w		%r15, [%sp+12]			;//%r15      := yh
		xld.w		[%sp+20], %r10			;//[%sp+20]  :=     (s * s).l				X^bNnꂽ͔̃j󂵂ĂSȂ̂ŁÃ̊֐Ăяöi[prɂgB
		xld.w		[%sp+24], %r11			;//[%sp+24]  :=     (s * s).h				
		xjp.d		lerp				;//return lerp(x, y, s * s)
		xadd		%sp, %sp, 16			;//					*delay*
");
#endif//PIECE
//-----------------------------------------------------------------------------
//Performs a EASE-OUT interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-OUT interpolates between the x parameter and the y parameter.		(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-OUT interpolation.
//[note]
//	- œoČ铮łB
#ifndef PIECE
double easeOut(double x, double y, double s) {
	return easeIn(y, x, 1.0 - s);
}
#else //PIECE
double easeOut(double x, double y, double s);
asm("
		.code
		.align		1
		.global		easeOut
easeOut:
		xsub		%sp, %sp, 16
		xld.w		[%sp+0], %r12			;//[%sp+0]   := xl
		xld.w		[%sp+4], %r13			;//[%sp+4]   := xh
		xld.w		[%sp+8], %r14			;//[%sp+8]   := yl
		xld.w		[%sp+12], %r15			;//[%sp+12]  := yh
	;//	ld.w		%r12, 0				;//%r13:%r12 := 1.0
		xld.w		%r13, 0x3FF00000		;//	
		xld.w		%r14, [%sp+20]			;//%r14      := sl		
		xld.w		%r15, [%sp+24]			;//%r15      := sh		
		xcall.d		__subdf3			;//%r11:%r10 :=        1.0 - s	
		ld.w		%r12, 0				;//		*delay*
		xld.w		%r12, [%sp+8]			;//%r12      := yl
		xld.w		%r13, [%sp+12]			;//%r13      := yh
		xld.w		%r14, [%sp+0]			;//%r14      := xl
		xld.w		%r15, [%sp+4]			;//%r15      := xh
		xld.w		[%sp+20], %r10			;//[%sp+20]  :=       (1.0 - s).l			X^bNnꂽ͔̃j󂵂ĂSȂ̂ŁÃ̊֐Ăяöi[prɂgB
		xld.w		[%sp+24], %r11			;//[%sp+24]  :=       (1.0 - s).h			
		xjp.d		easeIn				;//return easeIn(y, x, 1.0 - s)
		xadd		%sp, %sp, 16			;//					*delay*
");
#endif//PIECE
//-----------------------------------------------------------------------------
//Performs a EASE-IN-OUT interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-IN-OUT interpolates between the x parameter and the y parameter.	(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-IN-OUT interpolation.
//[note]
//	- 蓮oĉA܂铮łB
//{{2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//double easeInOut(double x, double y, double s) {
//	double mid = (x + y) / 2.0;
//	if(s >= 0.5) {
//		x = y;
//		s = 1.0 - s;
//	}
//	return easeIn(x, mid, s * 2.0);										//easeInOut()easeOutIn()̈Ⴂ́A̍słB
//}
//}}2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//-----------------------------------------------------------------------------
//Performs a EASE-OUT-IN interpolation.
//[in]
//	x		The first-floating point value.								xy̑召͕słB(x<y)ł(x=y)ł(x>y)ł\܂B
//	y		The second-floating point value.							
//	s		A value that EASE-OUT-IN interpolates between the x parameter and the y parameter.	(s<0)(s>1)w肵ĂG[ɂ͂Ȃ܂񂪁A炭Ӑ}ƈႤʂɂȂ܂B
//[out]
//	return value	The result of the EASE-OUT-IN interpolation.
//[note]
//	- œoČA܂铮łB
//{{2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//double easeOutIn(double x, double y, double s) {
//	double mid = (x + y) / 2.0;
//	if(s >= 0.5) {
//		x = y;
//		s = 1.0 - s;
//	}
//	return easeOut(x, mid, s * 2.0);									//easeInOut()easeOutIn()̈Ⴂ́A̍słB
//}
//}}2017/08/08폜:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//-----------------------------------------------------------------------------
//{{2017/08/08ǉ:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
#ifndef PIECE
static double easeInOut_easeOutIn(double x, double y, double s, double (*fn)(double x, double y, double s));	//OQ
double easeInOut(double x, double y, double s) { return easeInOut_easeOutIn(x, y, s, easeIn); }
double easeOutIn(double x, double y, double s) { return easeInOut_easeOutIn(x, y, s, easeOut); }
static double easeInOut_easeOutIn(double x, double y, double s, double (*fn)(double x, double y, double s)) {
#if 0
//fȎB
	double mid = (x + y) / 2.0;
	if(s >= 0.5) {
		x = y;
		s = 1.0 - s;
	}
	return (*fn)(x, mid, s * 2.0);
#else//ǂVerłʂɂȂ܂B
//AZuՂ悤Ɏό`B
	double mid = (x + y) / 2.0;
	   s *= 2.0;
	if(s >= 1.0) {
		s = 2.0 - s;
		x = y;
	}
	return (*fn)(x, mid, s);
#endif
}
#else //PIECE
double easeInOut(double x, double y, double s);
double easeOutIn(double x, double y, double s);
asm("
		.code
		.align		1
		.global		easeInOut
		.global		easeOutIn
easeInOut:
		xld.w		%r9, easeIn
		jp		easeInOut_easeOutIn
easeOutIn:
		xld.w		%r9, easeOut
easeInOut_easeOutIn:
		xsub		%sp, %sp, 28
		;//[%sp+0]  := (fn)
		;//[%sp+4]  := (x.l)
		;//[%sp+8]  := (x.h)
		;//[%sp+12] := (y.l)
		;//[%sp+16] := (y.h)
		;//[%sp+20] := (mid.l)
		;//[%sp+24] := (mid.l)
		;//[%sp+28] := retp
		;//[%sp+32] := s.l
		;//[%sp+36] := s.h
		xld.w		[%sp+0], %r9			;//[%sp+0]   := fn
		xld.w		[%sp+4], %r12			;//[%sp+4]   := x.l
		xld.w		[%sp+8], %r13			;//[%sp+8]   := x.h
		xld.w		[%sp+12], %r14			;//[%sp+12]  := y.l
		xld.w		[%sp+16], %r15			;//[%sp+16]  := y.h
		xcall		__adddf3			;//%r11:%r10 :=       (x + y)							[mod] %r4,%r5,%r6,%r7,%r12,%r13,%r14,%r15
		ld.w		%r12, %r10			;//%r12      :=       (x + y).l
		ld.w		%r13, %r11			;//%r13      :=       (x + y).h
	;//	ld.w		%r14, 0				;//%r14      :=                 (2.0).l		
	;//{{œK:3߁2										@
	;//	xld.w		%r15, 0x40000000		;//%r15      :=                 (2.0).h		@
	;//œK:3߁2										@
		ld.w		%r15, 1				;//%r15      :=                 (2.0).h		@
		rr		%r15, 2				;//						@
	;//}}œK:3߁2										@
		xcall.d		__divdf3			;//%r11:%r10 := mid = (x + y) /  2.0		@				[mod] %r4,%r5,%r12,%r13,%r14,%r15
		ld.w		%r14, 0				;//%r14      :=                 (2.0).l				*delay*
		xld.w		[%sp+20], %r10			;//[%sp+20]  := mid.l
		xld.w		[%sp+24], %r11			;//[%sp+24]  := mid.h
		xld.w		%r12, [%sp+32]			;//%r12      := s.l
		xld.w		%r13, [%sp+36]			;//%r13      := s.h
	;//	ld.w		%r14, 0				;//%r14      :=     (2.0).l			
	;//{{œK:3߁2										@
	;//	xld.w		%r15, 0x40000000		;//%r15      :=     (2.0).h			@
	;//œK:3߁2										@
		ld.w		%r15, 1				;//%r15      :=     (2.0).h			@
		rr		%r15, 2				;//						@
	;//}}œK:3߁2										@
		xcall.d		__muldf3			;//%r11:%r10 := s *= 2.0			@			[mod] %r4,%r5,%r12,%r13,%r14,%r15
		ld.w		%r14, 0				;//%r14      :=     (2.0).l			@@	*delay*
		ld.w		%r12, %r10			;//%r12      := s.l				@@@
		ld.w		%r13, %r11			;//%r13      := s.h				@@@
	;//	ld.w		%r14, 0				;//%r14      :=     (1.0).l			@@
		xld.w		%r15, 0x3FF00000		;//%r15      :=     (1.0).h			@@@
		xcall.d		__fcmpd				;//%psr      := s -  1.0			@@@			[mod] %r12,%r13,%r14,%r15	__fcmpd%r10,%r11j󂵂ȂɈˑĂ܂B
		ld.w		%r14, 0				;//%r14      :=     (1.0).l			@@	*delay*
		xld.w		%r12, [%sp+4]			;//%r12      := x.l				@@@@
		xld.w		%r13, [%sp+8]			;//%r13      := x.h				@@@@
		jrlt		easeInOut_easeOutIn_L10		;//if(          s >= 1.0) {			@@@@
		ld.w		%r12, 0				;//  %r12      :=    (2.0).l			@@@@
	;//{{œK:3߁2										@@@@
	;//	xld.w		%r13, 0x40000000		;//  %r13      :=    (2.0).h			@@@@
	;//œK:3߁2										@@@@
		ld.w		%r13, 1				;//  %r13      :=    (2.0).h			@@@@
		rr		%r13, 2				;//						@@@@
	;//}}œK:3߁2										@@@@
		ld.w		%r14, %r10			;//  %r14      :=           s.l			@@@
	;//	ld.w		%r15, %r11			;//  %r15      :=           s.h			@
		xcall.d		__subdf3			;//  %r11:%r10 := s = 2.0 - s			@@			[mod] %r4,%r5,%r6,%r7,%r12,%r13,%r14,%r15
		ld.w		%r15, %r11			;//  %r15      :=           s.h			@@	*delay*
		xld.w		%r12, [%sp+12]			;//  %r12      := x.l = y.l			@@@@
		xld.w		%r13, [%sp+16]			;//  %r13      := x.h = y.h			@@@@
easeInOut_easeOutIn_L10:					;//}						@@@@
		xld.w		%r14, [%sp+20]			;//%r14      :=      mid.l			@@@@
		xld.w		%r15, [%sp+24]			;//%r15      :=      mid.h			@@@@
		xld.w		[%sp+32], %r10			;//[%sp+32]  :=           s.l			@@			X^bNnꂽ͔̃j󂵂ĂSȂ̂ŁÃ̊֐Ăяöi[prɂgB
		xld.w		[%sp+36], %r11			;//[%sp+36]  :=           s.h			@@			
		;//[%sp+0]  := fn	@ret.dɂfnǂݏoc
		;//[%sp+4]  := sv	Ac%sp͂wB
		;//[%sp+8]  := sv	Bxadd %sp,%sp,24ɂĂ͈̔͂jB
		;//[%sp+12] := sv	
		;//[%sp+16] := sv	
		;//[%sp+20] := sv	
		;//[%sp+24] := sv	
		;//[%sp+28] := retp	
		;//[%sp+32] := s.l	CfnɂĈƂĎQƂB
		;//[%sp+36] := s.h	Dfn̖߂ƂȂB
		ret.d						;//return (*fn)(  x, mid, s)							̓s͂ƍ(^^)eNjbNgĂ܂Bڍׂ́Ȁ̃Rg(@`D)QƂĉB
		xadd		%sp, %sp, 24			;//								*delay*		
");
#endif//PIECE
//}}2017/08/08ǉ:easeInOut()easeOutIn()̏ʉāAR[hTCY팸܂B
//*****************************************************************************
//	A
//*****************************************************************************
//m[ns][n]̍s(determinant)߂܂B
//[note]
//	- matnf_determinant()APx˔{xɕύX֐łB
//	  gASÝAmatnf_determinant()ƓłB
//	  ڍׂ́Aclipflt1.cmatnf_determinant()̎QƂĉB
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
double determinant(const double* m/*[n][n]*/, int n) {
	int i;
	double d;
	if(n < 1) { DIE(); }
	//]qWJpāAs(determinant)߂܂B
	d = 0.0;
	for(i = 0; i < n; i++) {
		d += (m[(n * i) + 0/*j*/] * cofactor(m, n, i, 0/*j*/));
	}
	return d;
}
//-----------------------------------------------------------------------------
//m[ns][n]isjA]q(cofactor)߂܂B
//[note]
//	- matnf_cofactor()APx˔{xɕύX֐łB
//	  gASÝAmatnf_cofactor()ƓłB
//	  ڍׂ́Aclipflt1.cmatnf_cofactor()̎QƂĉB
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
double cofactor(const double* m/*[n][n]*/, int n, int i, int j) {
	int k, l;
	double d;
	double* s/*[n-1][n-1]*/;
	double* t/*[n-1][n-1]*/;
	if((n < 1) ||
	   (i < 0) || (i > (n - 1)) ||
	   (j < 0) || (j > (n - 1))) { DIE(); }
	//m[ns][n]isjAs(submatrix)쐬܂B
	if(n == 1) { return 1; } //s0s0ɂȂꍇ
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	s = malloc(sizeof(double) * ((n - 1) * (n - 1)));
	if(!s) { DIE(); }
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
	s = alloca(sizeof(double) * ((n - 1) * (n - 1)));
#endif//!(defined(_WIN32)&&defined(_MT))
	t = s;
	for(k = 0; k < n; k++) {
		for(l = 0; l < n; l++) {
			if((k != i) && (l != j)) {
				*t++ = *m;
			}
			m++;
		}
	}
	//s(minor determinant)߂܂B
	d = determinant(s, (n - 1));
	//]q(cofactor)߂܂B
	if((i ^ j) & 1) { d = -d; }
	//s܂B
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	free(s);
#endif//!(defined(_WIN32)&&defined(_MT))
	return d;
}
//-----------------------------------------------------------------------------
//nẢ߂܂B
//[note]
//	- solve_simultaneous_equations()APx˔{xɕύX֐łB
//	  gASÝAsolve_simultaneous_equations()ƓłB
//	  ڍׂ́Aclipflt1.csolve_simultaneous_equations()̎QƂĉB
//	- Asolve_simultaneous_equations()ƊrׂāAύX_L܂B
//	  solve_simultaneous_equations()͖߂lłA֐͏̓rŋ߂s񎮂̒lԂ悤ɂ܂B
//	  ẢLs񎮂̒lĔf邽߂ɁAʓrdeterminant()ĂяoǂłB
//	  solve_simultaneous_equations()ł́ALȉA͎w肳ȂOŖ߂lɂĂ܂A
//	  ۂɂ́ALȉAw肳\LƍlďL̖߂l̎dlύXsɂ܂B
//	  ܂ł̓rŋ߂s񎮂̒lԂ悤ɂ̕ύXłAê͈ؕύXĂ܂B
//	  ܂A֐ԂlQƂ邩ǂAĂяołB
//	  LȉAw肵ȂOȂ΁A߂l𖳎Ă\܂B
//	- ֐ZĂՓ˂Ȃ̂ŁAv؂ĒZ܂B
//	  ֐Փ˂ꍇ́AύXĉB
//	  Ȃ݂MATLABɂAA֐Ƃsolve()ƂO̊֐邻łB
//	  pr͎Ă܂Adl͌݊ł͂܂B܂ܖOvłB
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n) {
	int i, j;
	double d;
	//s(determinant)߂܂B
	d = determinant(A, n);
	//ŇpāAA̋ts߂ȂAb|āAx߂܂B
	for(i = 0; i < n; i++) {
		x[i] = 0.0;
		for(j = 0; j < n; j++) {
			x[i] += (cofactor(A, n, j, i) / d) * b[j];
			//            !!~~~~
		}
	}
	//s񎮂Ԃ܂B
	return d;
}
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
struct _ST_solve {
	const double*		A/*[n][n]*/;	//solve()̈ƓłBsolve_start_routine()͎QƐpłBĂ͂܂B
	const double*		b/*[n]*/;	//
	double*			x/*[n]*/;	//
	int			n;		//
	double			d;		//solve()li[܂Bsolve_start_routine()͎QƐpłBĂ͂܂B
	volatile int		i;		//i0nBsolve_start_routine()ǂݏ܂Biǂݏ鎞csbNĉB
	CRITICAL_SECTION 	cs;		//
};
static unsigned __stdcall solve_start_routine(void* _arg) {
	struct _ST_solve* arg = _arg;
	const double* const A = arg->A;
	const double* const b = arg->b;
	double*       const x = arg->x;
	int           const n = arg->n;
	double        const d = arg->d;
	for(;;) {
		int i, j;
	    EnterCriticalSection(&arg->cs);	//{{arg->i̓ǂݏ:
		i = arg->i;
		if(i != n) { arg->i = (i + 1); }
	    LeaveCriticalSection(&arg->cs);	//}}arg->i̓ǂݏ:܂
		if(i == n) { break; }
		x[i] = 0.0;
		for(j = 0; j < n; j++) {
			x[i] += (cofactor(A, n, j, i) / d) * b[j];
			//            !!~~~~
		}
	}
	return 0;
}
double solve(const double* A/*[n][n]*/, const double* b/*[n]*/, double* x/*[n]*/, int n) {
	struct _ST_solve arg;
	HANDLE hThread[16/**/];	//֐쐬Xbh̐͂̔zTCYƂȂB2016/03/19݂16XbhƂB16RAȏCPUʓIɂȂꍇ͂̔zTCY𑝂₹B
	int nThread, iThread;
	SYSTEM_INFO si;
	//\̂B
	arg.A = A;
	arg.b = b;
	arg.x = x;
	arg.n = n;
	arg.d = determinant(A, n);	//s(determinant)߂܂B
	arg.i = 0;
	//NeBJZNV쐬B
	InitializeCriticalSection(&arg.cs);
	//Xbh߂邽߂ɁACPU̘_RA擾B
	GetSystemInfo(&si);
	nThread = si.dwNumberOfProcessors;
	//CPU̘_RAAhThread[]z̃TCYꍇ́A؂l߂B
	if(nThread > ARRAY_SIZE(hThread)) { nThread = ARRAY_SIZE(hThread); }
	//CPU̘_RAAz̎ꍇ́A؂l߂B
	// - z̎葽Xbh𐶐ĂA͖薳AȂXbhĖʂłB
	if(nThread > n) { nThread = n; }
	//Xbh쐬B
	for(iThread = 0; iThread < nThread; iThread++) {
		hThread[iThread] = (HANDLE)_beginthreadex(NULL,
			0,
			solve_start_routine,
			&arg,
			0,
			NULL);
		if(!hThread[iThread]) { DIE(); }	//oO,,\[Xs
	}
	//Xbh̊҂B
	iThread = WaitForMultipleObjects(nThread, hThread, TRUE, INFINITE);
	if((unsigned)(iThread - WAIT_OBJECT_0) >= (unsigned)nThread) { DIE(); }	//oO
	//XbhJB
	for(iThread = 0; iThread < nThread; iThread++) {
		if(!CloseHandle(hThread[iThread])) { DIE(); }	//oO
	}
	//NeBJZNV폜B
	DeleteCriticalSection(&arg.cs);	//YȂ!!
	//s񎮂Ԃ܂B
	return arg.d;
}
#endif//!(defined(_WIN32)&&defined(_MT))
