/*	
 *	clipit.h
 *
 *	P/ECE IT Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Nov 18 18:59:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#ifndef __CLIP_IT_H__
#define __CLIP_IT_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	ITt@Cdl
 ****************************************************************************/

/* Impulse Header Layout */
typedef struct _ITMODULEHEADER {
		 char  impm[4];				/* +0000,  4: "IMPM" */
		 char  song_name[26];			/* +0004, 26: Song Name, max 26 characters, includes NULL */
	unsigned short philigt;				/* +001e,  2: Pattern row hilight information.                */
							/*              Only relevant for pattern editing situations. */
	unsigned short ordnum;				/* +0020,  2: Number of orders in song. */
	unsigned short insnum;				/* +0022,  2: Number of instruments in song. */
	unsigned short smpnum;				/* +0024,  2: Number of samples in song. */
	unsigned short patnum;				/* +0026,  2: Number of patterns in song. */
	unsigned short cwt;				/* +0028,  2: Created with tracker.          */
							/*              Impulse Tracker y.xx = 0yxxh */
							/*              (Cwt͍쐬ɎgpTracker̃o[WŁAt@C`Ƃ͖֌WłB        ) */
							/*              (  t@C`o[ẂACwtł͂ȂCmwtłB                     ) */
							/*              (  ƂCmwt$200ȏォۂɂāAInstrument Header`قȂ܂B     ) */
							/*              (  q悤ɁACmwt$200ITt@C͂قƂǑ݂Ȃ悤łB) */
	unsigned short cmwt;				/* +002a,  2: Compatible with tracker with version greater than value.                             */
							/*              (ie. format version)                                                               */
							/*              (Hornet ArchiveITt@C_ׂƂAł̂ł2.xxnłB) */
							/*              (  1.xxñt@C͂قƂǑ݂ȂƐA1.xxn͍lȂƂɂ܂B) */
	unsigned short flags;				/* +002c,  2: Bit 0: On = stereo, Off = Mono                                                                                                     */
							/*            Bit 1: Vol0MixOptimizations                                                                                                        */
							/*                     - If on, no mixing occurs if the volume at mixing time is 0 (redundant v1.04+)                                            */
							/*            Bit 2: On = Use instruments, Off = Use samples.                                                                                    */
							/*            Bit 3: On = Linear slides, Off = Amiga slides.                                                                                     */
							/*            Bit 4: On = Old Effects, Off = IT Effects                                                                                          */
							/*                     Differences:                                                                                                              */
							/*                       - Vibrato is updated EVERY frame in IT mode, whereas it is updated every non-row frame in other formats.                */
							/*                         Also, it is two times deeper with old Effects ON                                                                      */
							/*                       - Command Oxx will set the sample offset to the END of a sample instead of ignoring the command under old effects mode. */
							/*                       - (More to come, probably)                                                                                              */
							/*            Bit 5: On = Link Effect G's memory with Effect E/F.                                                                                */
							/*                     Also Gxx with an instrument present will cause the envelopes to be retriggered.                                           */
							/*                     If you change a sample on a row with Gxx, it'll adjust the frequency of the current note according to:                    */
							/*                       NewFrequency = OldFrequency * NewC5 / OldC5;                                                                            */
							/*            Bit 6: Use MIDI pitch controller, Pitch depth given by PWD                                                                         */
							/*            Bit 7: Request embedded MIDI configuration                                                                                         */
							/*                     (Coded this way to permit cross-version saving)                                                                           */
	unsigned short special;				/* +002e,  2: Bit 0: On = Song message attached.                                               */
							/*                     Song message:                                                           */
							/*                       Stored at offset given by "Message offset" field.                     */
							/*                       Length = MsgLgth.                                                     */
							/*                       NewLine = 0Dh (13 dec)                                                */
							/*                       EndOfMsg = 0                                                          */
							/*                     Note: v1.04+ of IT may have song messages of up to 8000 bytes included. */
	unsigned char  gv;				/* +0030,  1: Global volume. (0->128)            */
							/*              All volumes are adjusted by this */
	unsigned char  mv;				/* +0031,  1: Mix volume (0->128)                                                          */
							/*              During mixing, this value controls the magnitude of the wave being mixed.  */
							/*              (S3MMaster volumeɑ? ԂTEhJ[hpłBg܂B) */
	unsigned char  is;				/* +0032,  1: Initial speed of song. */
	unsigned char  it;				/* +0033,  1: Initial tempo of song. */
	unsigned char  sep;				/* +0034,  1: Panning separation between channels (0->128, 128 is max sep.) */
	unsigned char  pwd;				/* +0035,  1: Pitch wheel depth for MIDI controllers */
	unsigned short msglgth;				/* +0036,  2: (Special̐Q) */
		 int   message_offset;			/* +0038,  4: (Special̐Q) */
		 int   x003c;				/* +003c,  4: Reserved */
	unsigned char  chnl_pan[64];			/* +0040, 64: Each byte contains a panning value for a channel.                                                                 */
							/*              Ranges from 0 (absolute left) to 64 (absolute right). 32 = central pan, 100 = surround sound.                   */
							/*              +128 = disabled channel (notes will not be played, but note that effects in muted channels are still processed) */
	unsigned char  chnl_vol[64];			/* +0080, 64: Volume for each channel. */
        						/*              Ranges from 0->64      */
//	unsigned char  orders[ordnum];			/* +00c0,ordnum: This is the order in whitch the patterns are played. */
//							/*                 Valid values are from 0-199.                       */
//							/*                 255 = "---", End of song marker                    */
//							/*                 254 = "+++", Skip to next order                    */
//		 int   offset_of_instruments[insnum];	/* +00c0+ordnum,insnum*4                  : 'Long' Offset of instruments, Length = InsNum*4 */
//		 int   offset_of_samples[smpnum];	/* +00c0+ordnum+insnum*4,smpnum*4         : 'Long' Offset of samples headers, Length = SmpNum*4 */
//		 int   offset_of_patterns[patnum];	/* +00c0+ordnum+insnum*4+smpnum*4,patnum*4: 'Long' Offset of patterns, Length = PatNum*4 */
} ITMODULEHEADER;					/* =00c0+ordnum+insnum*4+smpnum*4+patnum*4 */

///* Old Impulse Instrument Format (cmwt < 200h) */
//typedef struct _ITOLDINSTRUMENTHEADER {
//		 char  impi[4];				/* +0000,  4: "IMPI" */
//		 char  dos_filename[12];		/* +0004, 12: Dos FileName (12345678.123) */
//	unsigned char  _00h;				/* +0010,  1: 00h */
//	unsigned char  flg;				/* +0011,  1: Bit 0. On = Use volume envelope     */
//							/*            Bit 1. On = Use volume loop         */
//							/*            Bit 2. On = Use sustain volume loop */
//	unsigned char  vls;				/* +0012,  1: Volume loop start (node number) */
//	unsigned char  vle;				/* +0013,  1: Volume loop end (node number) */
//	unsigned char  sls;				/* +0014,  1: Sustain loop start (node number) */
//	unsigned char  sle;				/* +0015,  1: Sustain loop end (node number) */
//	unsigned short x0016;				/* +0016,  2: Reserved */
//	unsigned short fadeout;				/* +0018,  2: Ranges between 0 and 64, but the fadeout "Count" is 512. */
//	unsigned char  nna;				/* +001a,  1: New note action:    */
//							/*              0 = Note cut      */
//							/*              1 = Note continue */
//							/*              2 = Note off      */
//							/*              3 = Note fade     */
//	unsigned char  dnc;				/* +001b,  1: Duplicate note check (0 = Off, 1 = On) */
//	unsigned short trkvers;				/* +001c,  2: Tracker version used to save the instrument. */
//							/*              This is only used in the instrument files. */
//	unsigned char  nos;				/* +001e,  1: Number of samples associated with instrument. */
//							/*              This is only used in the instrument files.  */
//	unsigned char  x001f;				/* +001f,  1: Reserved */
//		 char  instrument_name[26];		/* +0020, 26: Instrument Name, max 26 bytes, includes NUL */
//	unsigned char  x003a[6];			/* +003a,  6: Reserved */
//	unsigned char  note_sample_keyboard_table[240];	/* +0040,240: Note-Sample/Keyboard Table, Length = 240 bytes                                               */
//		 					/*              Each note of the instrument is first converted to a sample number and a note (C-0 -> B-9). */
//		 					/*              These are stored as note/sample byte pairs                                                 */
//		 					/*              (note first, range 0->119 for C-0 to B-9, sample ranges from 1-99, 0=no sample)            */
//	unsigned char  volume_envelope[200];		/* +0130,200: Volume envelope (200 bytes) */
//	unsigned char  node_points[50];			/* +01f8, 50: Node points (25x2 bytes) */
//} ITOLDINSTRUMENTHEADER;				/* =022a */
//2004/11/18݁A(ITMODULEHEADER.cmwt<$200)ITt@Cɂ͖ΉłBOld Impulse Instrument Format͎g܂B

/* Envelope layout */
typedef struct _ITENVELOPESTRUCTURE {
	unsigned char  flg;				/* +0000,  1: Bit 0: Envelope on/off, 1 = on, 0 = off */
							/*            Bit 1: Loop on/off, 1 = on, 0 = off     */
							/*            Bit 2: SusLoop on/off, 1 = on, 0 = off  */
	unsigned char  num;				/* +0001,  1: Number of node points */
	unsigned char  lpb;				/* +0002,  1: Loop beggining                                                                             */
	unsigned char  lpe;				/* +0003,  1: Loop end                                                                                   */
	unsigned char  slb;				/* +0004,  1: Sustain loop beggining                                                                     */
	unsigned char  sle;				/* +0005,  1: Sustain loop end                                                                           */
							/*              (IT`ł́AI[̕\L(I[+1)Ƃ̂ZI[Ȃ̂łAEnvelopeႢ܂B) */
							/*              (  Loop endASustain loop end́AI[̂̂̃CfNX܂BƂ΁A        ) */
							/*              (  lpb=2Alpe=4Ȃ΁A{2,3,4,2,3,4,...}ƌJԂ܂B{2,3,2,3,...}ł͂܂B  ) */
							/*              (ǂݍݎ(I[+1)ɕϊ邱Ƃɂ܂Bit_init()̎QƂĂB   ) */
	unsigned char  node_points[75];			/* +0006, 75: 1 byte for y-value (0->64 for vol, -32->+32 for panning or pitch) */
							/*            1 word (2 bytes) for tick number (0->9999)                        */
	unsigned char  _x0051;				/* +0051,  1: Reserved */
} ITENVELOPESTRUCTURE;					/* =0052 */

/* Impulse Instrument Format */
typedef struct _ITINSTRUMENTHEADER {
		 char  impi[4];				/* +0000,  4: "IMPI" */
		 char  dos_filename[12];		/* +0004, 12: Dos FileName (12345678.123) */
	unsigned char  _00h;				/* +0010,  1: 00h */
	unsigned char  nna;				/* +0011,  1: New Note Action                 */
							/*              0 = Cut         1 = Continue  */
							/*              2 = Note off    3 = Note fade */
	unsigned char  dct;				/* +0012,  1: Duplicate Check Type             */
							/*              0 = Off         1 = Note       */
							/*              2 = Sample      3 = Instrument */
	unsigned char  dca;				/* +0013,  1: Duplicate Check Action */
							/*              0 = Cut              */
							/*              1 = Note Off         */
							/*              2 = Note fade        */
	unsigned short fadeout;				/* +0014,  2: Ranges between 0 and 128, but the fadeout "Count" is 1024                     */
							/*              See the Last section on how this works. (it.txtMathematics̏͂Q)   */
							/*              Fade applied when:                                                          */
							/*              1) Note fade NNA is selected and triggered (by another note)                */
							/*              2) Note off NNA is selected with no volume envelope or volume envelope loop */
							/*              3) Volume envelope end is reached                                           */
	unsigned char  pps;				/* +0016,  1: Pitch-Pan separation, range -32 -> +32 */
	unsigned char  ppc;				/* +0017,  1: Pitch-Pan center: C-0 to B-9 represented as 0->119 inclusive */
	unsigned char  gbv;				/* +0018,  1: Global volume, 0->128 */
	unsigned char  dfp;				/* +0019,  1: Default Pan, 0->64, &128 => Don't use */
	unsigned char  rv;				/* +001a,  1: Random volume variation (percentage) */
	unsigned char  rp;				/* +001b,  1: Random panning variation (panning change - not implemented yet) */
	unsigned short trkvers;				/* +001c,  2: Tracker version used to save the instrument. */
							/*              This is only used in the instrument files. */
	unsigned char  nos;				/* +001e,  1: Number of samples associated with instrument. */
							/*              This is only used in the instrument files.  */
	unsigned char  _x001f;				/* +001f,  1: Reserved */
		 char  instrument_name[26];		/* +0020, 26: Instrument Name, max 26 bytes, includes NUL */
	unsigned char  ifc;				/* +003a,  1: (it.txtɐ܂BtB^W?) */
	unsigned char  ifr;				/* +003b,  1: (it.txtɐ܂BtB^W?) */
	unsigned char  mch;				/* +003c,  1: MIDI Channel */
	unsigned char  mpr;				/* +003d,  1: MIDI Program (Instrument) */
	unsigned short midibnk;				/* +003e,  2: (it.txtɐ܂BÔƂMIDIFoNƎv܂B) */
	unsigned char  note_sample_keyboard_table[240];	/* +0040,240: Note-Sample/Keyboard Table, Length = 240 bytes                                               */
		 					/*              Each note of the instrument is first converted to a sample number and a note (C-0 -> B-9). */
		 					/*              These are stored as note/sample byte pairs                                                 */
		 					/*              (note first, range 0->119 for C-0 to B-9, sample ranges from 1-99, 0=no sample)            */
	ITENVELOPESTRUCTURE volume_envelope;		/* +0130, 82: 3 structures, first  for volume  (130h), */
	ITENVELOPESTRUCTURE panning_envelope;		/* +0182, 82:               second for panning (182h), */
	ITENVELOPESTRUCTURE pitch_envelope;		/* +01d4, 82:               third  for pitch   (1d4h). */
} ITINSTRUMENTHEADER;					/* =0226 */
// Total length of an instrument is 547 bytes, but 554 bytes are written, just to simplify the loading of the old format.
// (Hence there are 7 'wasted' bytes per instrument)
// (Impulse Instrument Format̃TCY"550 bytes"Ǝv܂BBBit.txtɏĂ"547 bytes"͌Ał傤? )
// (  ɂAeImpulse Instrument Formaẗʒu͌ʂɎw肳Ă̂ŁA㑱pfBOTCY͖ɂȂ܂B)

/* Impulse sample format */
typedef struct _ITSAMPLEHEADER {
		 char  imps[4];				/* +0000,  4: "IMPS" */
		 char  dos_filename[12];		/* +0004, 12: Dos Filename (12345678.123) */
	unsigned char  _00h;				/* +0010,  1: 00h */
	unsigned char  gvl;				/* +0011,  1: Global volume for instrument, ranges from 0->64 */
	unsigned char  flg;				/* +0012,  1: Bit 0. On = sample associated with header.                       */
							/*            Bit 1. On = 16 bit, Off = 8 bit.                                 */
							/*            Bit 2. On = stereo, Off = mono. Stereo samples not supported yet */
							/*            Bit 3. On = compressed samples.                                  */
							/*            Bit 4. On = Use loop                                             */
							/*            Bit 5. On = Use sustain loop                                     */
							/*            Bit 6. On = Ping Pong loop, Off = Forwards loop                  */
							/*            Bit 7. On = Ping Pong Sustain loop, Off = Forwards Sustain loop  */
	unsigned char  vol;				/* +0013,  1: Default volume for instrument */
	         char  sample_name[26];			/* +0014, 26: Sample Name, max 26 bytes, includes NUL */
	unsigned char  cvt;				/* +002e,  1: Convert - bits other than bit 0 are used internally for the loading of alternative formats. */
							/*              Bit 0:                                                                                    */
							/*               Off: Samples are unsigned } IT 2.01 and below use unsigned samples                       */
							/*                On: Samples are signed   } IT 2.02 and above use signed samples                         */
							/*                (Hornet ArchiveITt@C_ׂƂAt@CSigned samplełB) */
							/*                (  Unsigned samplegt@C͂قƂǑ݂ȂƐAlȂƂɂ܂B) */
							/*                (  Length=0̖SamplȅꍇBit 0=Off̏ꍇ̂ŁALengthĂB) */
							/*              Bit 1:                                             }                                      */
							/*               Off: Intel lo-hi byte order for 16-bit samples    }                                      */
							/*                On: Motorola hi-lo byte order for 16-bit samples }                                      */
							/*              Bit 2:                                             }                                      */
							/*               Off: Samples are stored as PCM values             }                                      */
							/*                On: Samples are stored as Delta values           }                                      */
							/*              Bit 3:                                             }                                      */
							/*                On: Samples are stored as byte delta values      } Safe to ignore these values...       */
							/*                    (for PTM loader)                             }                                      */
							/*              Bit 4:                                             }                                      */
							/*                On: Samples are stored as TX-wave 12-bit values  }                                      */
							/*              Bit 5:                                             }                                      */
							/*                On: Left/Right/All Stereo prompt                 }                                      */
							/*              Bit 6: Reserved                                    }                                      */
							/*              Bit 7: Reserved                                    }                                      */
	unsigned char  dfp;				/* +002f,  1: Default Pan. Bits 0->6 = Pan value, Bit 7 ON to USE (opposite of inst) */
		 int   length;				/* +0030,  4: Length of sample in no. of samples NOT no. of bytes                                    */
							/*              (Rgp̖SamplȅꍇALength=0Ȃ̃tB[h͕sƂȂ悤łB) */
		 int   loop_begin;			/* +0034,  4: Start of loop (no of samples in, not bytes) */
		 int   loop_end;			/* +0038,  4: Sample no. AFTER end of loop */
		 int   c5speed;				/* +003c,  4: Number of bytes a second for C-5 (ranges from 0->9999999) */
		 int   susloop_begin;			/* +0040,  4: Start of sustain loop */
		 int   susloop_end;			/* +0044,  4: Sample no. AFTER end of sustain loop */
		 int   sample_pointer;			/* +0048,  4: 'Long' Offset of sample in file. */
	unsigned char  vis;				/* +004c,  1: Vibrato Speed, ranges from 0->64 */
	unsigned char  vid;				/* +004d,  1: Vibrato Depth, ranges from 0->64 */
	unsigned char  vir;				/* +004e,  1: Vibrato Rate, rate at which vibrato is applied (0->64)                                                                */
							/*              The depth of the vibrato at any point is workid out in the following way:                                           */
							/*                Every processing cycle, the following occurs:                                                                     */
							/*                  1) Mov AX, [SomeVariableNameRelatingToVibrato]                                                                  */
							/*                  2) Add AL, Rate                                                                                                 */
							/*                  3) AdC AH, 0                                                                                                    */
							/*                  4) AH contains the depth of the vibrato as a fine-linear slide.                                                 */
							/*                  5) Mov [SomeVariableNameRelatingToVibrato], AX  ; For the next cycle.                                           */
							/*                For those that don't understand assembly, then the depth is basically the running-sum of the rate divided by 256. */
							/*                Sample vibrato uses a table 256-bytes long                                                                        */
	unsigned char  vit;				/* +004f,  1: Vibrato waveform type.                 */
							/*                    0=Sine wave                    */
							/*                    1=Ramp down                    */
							/*                    2=Square wave                  */
							/*                    3=Random (speed is irrelevant) */
} ITSAMPLEHEADER;					/* =0050 */
// The cache file has the following pieces of information added on:
//		 char  file_size[4];
//	unsigned short date;
//	unsigned short time;
//	unsigned char  fmt;
//	unsigned char  x0059[7];

/* Impulse Pattern Format */
typedef struct _ITPATTERNHEADER {
	unsigned short length;				/* +0000,  2: Length of packed pattern, not including the 8 byte header                */
							/*              Note that the pattern + the 8 byte header will ALWAYS be less than 64k */
	unsigned short rows;				/* +0002,  2: Number of rows in this patetrn (Ranges from 32->200) */
		 int   x0004;				/* +0004,  4: Reserved */
} ITPATTERNHEADER;					/* =0008 */
//	unsigned char  packed_data[/*length*];

/****************************************************************************
 *	P/ECE IT Driver
 ****************************************************************************/

#define ITBUFLEN 320	/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

typedef struct _ITPATTERN {
	int rows;					/* ITPATTERNHEADER.rowsAPatternȂ0 */
	const unsigned char* packed_data;		/* ITPATTERNHEADER.packed_data, Direct */
} ITPATTERN;

typedef struct _ITNOTESAMPLE {
	unsigned char note;				/* ITINSTRUMENTHEADER.note_sample_keyboard_table[2*i+0] */
	unsigned char sample;				/* ITINSTRUMENTHEADER.note_sample_keyboard_table[2*i+1] */
} ITNOTESAMPLE;

typedef struct _ITENVELOPENODEPOINT {
	unsigned short y;				/* ITENVELOPESTRUCTURE.node_points[3*i+0   ] */
	unsigned short tick;				/* ITENVELOPESTRUCTURE.node_points[3*i+1..2] */
} ITENVELOPENODEPOINT;

typedef struct _ITENVELOPE {
	ITENVELOPENODEPOINT* node_points;		/* Alloc */
	ITENVELOPENODEPOINT* node_points_end;
	ITENVELOPENODEPOINT* loop_begin;		/* Loop offȂNULL */
	ITENVELOPENODEPOINT* loop_end;			/* Loop offȂNULL */
	ITENVELOPENODEPOINT* susloop_begin;		/* Sustain loop offȂNULL */
	ITENVELOPENODEPOINT* susloop_end;		/* Sustain loop offȂNULL */
} ITENVELOPE;

typedef struct _ITINSTRUMENT {
	int fadeout;					/* ITINSTRUMENTHEADER.fadeout */
	int gbv;					/* ITINSTRUMENTHEADER.gbv */
	ITNOTESAMPLE note_sample_keyboard_table[120];	/* ITINSTRUMENTHEADER.note_sample_keyboard_table */
	ITENVELOPE* volume_envelope;			/* Alloc, Volume envelope offȂNULL */
} ITINSTRUMENT;

typedef struct _ITSAMPLE {
	int gvl;					/* ITSAMPLEHEADER.gvl */
	int flg;					/* ITSAMPLEHEADER.flg */
	int vol;					/* ITSAMPLEHEADER.vol */
	int c5speed;					/* ITSAMPLEHEADER.c5speed */
	const unsigned char* sample_data;		/* ITSAMPLEHEADER.sample_pointerZoASampleȂNULL */
	const unsigned char* sample_end;		/* ITSAMPLEHEADER.lengthZo */
	const unsigned char* loop_begin;		/* ITSAMPLEHEADER.loop_beginZoALoop OffȂNULL */
	const unsigned char* loop_end;			/* ITSAMPLEHEADER.loop_endZoALoop OffȂNULL */
	const unsigned char* susloop_begin;		/* ITSAMPLEHEADER.susloop_beginZoASustain loop OffȂNULL */
	const unsigned char* susloop_end;		/* ITSAMPLEHEADER.susloop_endZoASustain loop OffȂNULL */
} ITSAMPLE;

typedef struct _ITCHANNELMARKER {
	int note;
	int instrument;
	int volume_panning;
	int command;
	int command_value;
} ITCHANNELMARKER;

typedef struct _ITCHANNEL {
	int stat;					/* 0 = Disabled, 1 = Silent, 2 = NoteOn, 3 = NoteOff */

	ITINSTRUMENT* pending_instrument;		/* 񔭐Instrument */
	ITINSTRUMENT* playing_instrument;		/* Instrument */
	ITSAMPLE* playing_sample;			/* ݔSample */

	int chnl_vol;					/* ITMODULEHEADER.chnl_vol */
	int vol;

	const unsigned char* sample_position;
	int sample_direction;
	int progress;
	int pitch;					/* note<<8 () */

	int previous_mask_variable;
	ITCHANNELMARKER last_channel_marker;
	int volume_panning;				/* -1 =  */
	int command;					/* -1 =  */
	int command_value;
} ITCHANNEL;

/* ITCHANNEL.stat */
#define ITCHANNEL_DISABLED	0			/* Disabled */
#define ITCHANNEL_SILENT	1			/* Silent */
#define ITCHANNEL_NOTEON	2			/* NoteOn (Attack/Decay/Sustain) */
#define ITCHANNEL_NOTEOFF	3			/* NoteOff (Release) */

typedef struct _ITDRIVER {
	int ordnum;					/* ITMODULEHEADER.ordnum */
	int insnum;					/* ITMODULEHEADER.insnum */
	int smpnum;					/* ITMODULEHEADER.smpnum */
	int patnum;					/* ITMODULEHEADER.patnum */

	int gv;						/* ITMODULEHEADER.gvAEffectɂĕύX */
	int speed;					/* ITMODULEHEADER.isAEffectɂĕύX */
	int tempo;					/* ITMODULEHEADER.itAEffectɂĕύX */

	int progress;					/* TempoispJE^ */
	int tick;					/* SpeedispJE^ */
	int order;					/* ݂Order */
	int row;					/* Row */
	ITPATTERN* pattern;				/* ݂Pattern */
	const unsigned char* pattern_position;		/* Pattern data */

	int stat;					/* ʏ0Bt~ɗvi[ */
	int position_jump;				/* ʏ-1BPosition jumporderݒ */
	int pattern_break;				/* ʏ-1BPattern breakrowݒ */

	const unsigned char* orders/*[orders]*/;	/* ITMODULEHEADER.orders, Direct */
	ITINSTRUMENT* instruments/*[insnum]*/;		/* Alloc */
	ITSAMPLE* samples/*[smpnum]*/;			/* Alloc */
	ITPATTERN* patterns/*[patnum]*/;		/* Alloc */

	ITCHANNEL channels[64];
} ITDRIVER;

extern const int it_pitch_table[12];

int it_init(ITDRIVER* driver, const void* data);
void it_free(ITDRIVER* driver);
int it_run(ITDRIVER* driver);
int it_mix(ITDRIVER* driver, short wbuff[/*ITBUFLEN*/]);
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//int it_stream_callback(short* wbuff, int param);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
int it_stream_callback(short* wbuff, intptr_t param);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* ITt@C̍ĐJn܂B
 * [in]
 *	data		ITf[^̐擪AhXB
 * [out]
 *	߂l		ĐJnɐ0Ԃ܂B
 *			ĐJnɎs0ȊO̒lԂ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKit_stop()ĂŁAxN^𕜌ĂB
 */
int it_play(const void* data);

/* ITt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void it_stop();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_IT_H__*/
