/*	
 *	clipit.c
 *
 *	P/ECE IT Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Nov 18 18:59:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/* * G[R[h̒ĺAsԍ𕉒lɂ̂łB
 *   vOCƁAG[R[hς\܂B
 *   G[R[h̒ĺAfobÔ߂ɗpĂB
 */
#define ERRNO	(-__LINE__)

/****************************************************************************
 *	P/ECE IT Driver
 ****************************************************************************/

const int
it_pitch_table[12] = {     /* bit */
	(int)(1.0000000000000000 * (1 << 10) + 0.5),	/* C  = 2^( 0/12) */
	(int)(1.0594630943592953 * (1 << 10) + 0.5),	/* C# = 2^( 1/12) */
	(int)(1.1224620483093730 * (1 << 10) + 0.5),	/* D  = 2^( 2/12) */
	(int)(1.1892071150027210 * (1 << 10) + 0.5),	/* D# = 2^( 3/12) */
	(int)(1.2599210498948732 * (1 << 10) + 0.5),	/* E  = 2^( 4/12) */
	(int)(1.3348398541700344 * (1 << 10) + 0.5),	/* F  = 2^( 5/12) */
	(int)(1.4142135623730951 * (1 << 10) + 0.5),	/* F# = 2^( 6/12) */
	(int)(1.4983070768766815 * (1 << 10) + 0.5),	/* G  = 2^( 7/12) */
	(int)(1.5874010519681994 * (1 << 10) + 0.5),	/* G# = 2^( 8/12) */
	(int)(1.6817928305074290 * (1 << 10) + 0.5),	/* A  = 2^( 9/12) */
	(int)(1.7817974362806785 * (1 << 10) + 0.5),	/* A# = 2^(10/12) */
	(int)(1.8877486253633868 * (1 << 10) + 0.5),	/* B  = 2^(11/12) */
};

static int
_it_init(ITDRIVER* driver, const void* data)
{
#define module_header     (header._module_header)
#define instrument_header (header._instrument_header)
#define sample_header     (header._sample_header)
#define pattern_header    (header._pattern_header)

	/* ITt@C\̕oCgtB[h͐񂪕ۏ؂Ȃ̂ŁA񃍁[Jϐɓǂݍ݂܂B
	 * e\̂500Bx̑傫Aʂɒ`ƃX^bNʂ傫邽߁Ap̂Ƃ܂B
	 * ł500B`1KB炢Ǝv܂BX^bNTCY𑽂߂ɐݒ肷悤AӂĂB
	 */
	union {
		ITMODULEHEADER     _module_header;
		ITINSTRUMENTHEADER _instrument_header;
		ITSAMPLEHEADER     _sample_header;
		ITPATTERNHEADER    _pattern_header;
	} header;
	//
	const unsigned char* ptr;
	const unsigned char* offset_of_instruments;
	const unsigned char* offset_of_samples;
	const unsigned char* offset_of_patterns;
	int note;
	int offset;
	int i_instrument;
	int i_sample;
	int i_point;
	int i_pattern;
	int i_channel;
	ITINSTRUMENT* instrument;
	ITSAMPLE* sample;
	ITENVELOPENODEPOINT* point;
	ITPATTERN* pattern;
	ITCHANNEL* channel;

	/* ܂AITDRIVER\̂NA܂B */
	memset(driver, 0, sizeof(ITDRIVER));

	/***************************
	 *  Impulse Header Layout  *
	 ***************************/

	/* ITMODULEHEADERǂݍ݂܂B */
	ptr = (const unsigned char*)((int)data + 0);
	memcpy(&module_header, ptr, sizeof(ITMODULEHEADER));

	/* ŒtB[h܂B */
	if(memcmp(module_header.impm, "IMPM", 4) != 0) {
		return ERRNO;
	}
	if(module_header.cmwt < 0x200) {
		return ERRNO; /* 1.xx͖Ή */
	}

	/* OrdnumAInsnumASmpnumAPatnum擾܂B */
	driver->ordnum = module_header.ordnum;
	if(driver->ordnum < 1) {
		return ERRNO; /* Ordnums */
	}
	driver->insnum = module_header.insnum;
	if(module_header.flags & 4) { /* Instrument mode */
		if(driver->insnum < 1) {
			return ERRNO; /* Insnums */
		}
	}
	driver->smpnum = module_header.smpnum;
	if(driver->smpnum < 1) {
		return ERRNO; /* smpnums */
	}
	driver->patnum = module_header.patnum;
	if(driver->patnum < 1) {
		return ERRNO; /* patnums */
	}

	/* Global volumeAInitial speedAInitial tempo擾܂B */
	driver->gv = module_header.gv;
	driver->speed = module_header.is;
	if(driver->speed < 1) {
		return ERRNO; /* Initial speeds */
	}
	driver->tempo = module_header.it;
	if(driver->tempo < 1) {
		return ERRNO; /* Initial tempos */
	}

	/* OrdersAOffset of instrumentsAOffset of samplesAOffset of patterns擾܂B */
	ptr += sizeof(ITMODULEHEADER);
	driver->orders = ptr;
	ptr += driver->ordnum * sizeof(unsigned char);
	offset_of_instruments = ptr;
	ptr += driver->insnum * sizeof(int);
	offset_of_samples = ptr;
	ptr += driver->smpnum * sizeof(int);
	offset_of_patterns = ptr;

	/* ȍ~module_header͏㏑܂B(p̂̂)
	 * module_header̃tB[hɃANZXĂ͂܂B
	 */

	/*******************************
	 *  Impulse Instrument Format  *
	 *******************************/

	if(module_header.flags & 4) { /* Instrument mode */

		/* ITINSTRUMENT\̔zmۂ܂B */
		driver->instruments = calloc(driver->insnum, sizeof(ITINSTRUMENT));
		if(!driver->instruments) {
			return ERRNO;
		}

		/* eInstrumentɂ... */
		for(i_instrument = 0, instrument = driver->instruments;
		    i_instrument < driver->insnum;
		    i_instrument++, instrument++) {

			/* ITINSTRUMENTHEADER\̂ǂݍ݂܂B */
			ptr = offset_of_instruments + i_instrument * sizeof(int);
			offset = LEWORD(ptr);
			ptr = (const unsigned char*)((int)data + offset);
			memcpy(&instrument_header, ptr, sizeof(ITINSTRUMENTHEADER));

			/* ŒtB[h܂B */
			if(memcmp(instrument_header.impi, "IMPI", 4) != 0) {
				return ERRNO;
			}
			if(instrument_header._00h != 0x00) {
				return ERRNO;
			}

			/* FadeoutAGlobal volume擾܂B */
			instrument->fadeout = instrument_header.fadeout;
			instrument->gbv = instrument_header.gbv;

			/* Note-Sample/Keyboard Table擾܂B */
			ptr = instrument_header.note_sample_keyboard_table;
			for(note = 0; note < 120; note++) {
				instrument->note_sample_keyboard_table[note].note = *ptr++;
				instrument->note_sample_keyboard_table[note].sample = *ptr++;
			}

			/* Volume envelope擾܂B */
			if(instrument_header.volume_envelope.flg & 1/*Envelope on*/) {

				/* ITENVELOPE\̂mۂ܂B */
				instrument->volume_envelope = calloc(1, sizeof(ITENVELOPE));
				if(!instrument->volume_envelope) {
					return ERRNO;
				}

				/* ITENVELOPENODEPOINT\̔zmۂ܂B */
				if((instrument_header.volume_envelope.num < 2) ||
				   (instrument_header.volume_envelope.num > 25)) {
					return ERRNO; /* Number of node pointss */
				}
				instrument->volume_envelope->node_points = calloc(instrument_header.volume_envelope.num, sizeof(ITENVELOPENODEPOINT));
				if(!instrument->volume_envelope->node_points) {
					return ERRNO;
				}
				instrument->volume_envelope->node_points_end = instrument->volume_envelope->node_points + instrument_header.volume_envelope.num;

				/* Node pointsǂݍ݂܂B */
				ptr = instrument_header.volume_envelope.node_points;
				for(i_point = 0, point = instrument->volume_envelope->node_points;
				    i_point < instrument_header.volume_envelope.num;
				    i_point++, point++) {
					point->y    = LEBYTE(ptr); ptr += 1;
					point->tick = LEHALF(ptr); ptr += 2;
					if(i_point) {
						if(point->tick < (point - 1)->tick) {
							return ERRNO; /* Tickts (==͉) */
						}
					}
				}

				/* Loop beginALoop end擾܂B
				 * * IT`ł́AI[̕\L(I[+1)Ƃ̂ZI[Ȃ̂łAEnvelope(I[)̂̂Ă܂B
				 *   Ƃ̐̂߁Aǂݍݎ(I[+1)ƂĂƂɂ܂B
				 */
				if(instrument_header.volume_envelope.flg & 2/*Loop on*/) {
					if(instrument_header.volume_envelope.lpb >= instrument_header.volume_envelope.num) {
						return ERRNO; /* Loop begins (0..(num-1)K{) */
					}
					if(instrument_header.volume_envelope.lpe >= instrument_header.volume_envelope.num) {
						return ERRNO; /* Loop ends (0..(num-1)K{) */
					}
					if(instrument_header.volume_envelope.lpb > instrument_header.volume_envelope.lpe) {
						return ERRNO; /* Loop begin/ends ((begin)<=(end)K{) */
					}
					instrument->volume_envelope->loop_begin = instrument->volume_envelope->node_points + instrument_header.volume_envelope.lpb;
					instrument->volume_envelope->loop_end   = instrument->volume_envelope->node_points + instrument_header.volume_envelope.lpe + 1/*I[+1*/;
				}

				/* Sustain loop beginALoop end擾܂B
				 * * IT`ł́AI[̕\L(I[+1)Ƃ̂ZI[Ȃ̂łAEnvelope(I[)̂̂Ă܂B
				 *   Ƃ̐̂߁Aǂݍݎ(I[+1)ƂĂƂɂ܂B
				 */
				if(instrument_header.volume_envelope.flg & 4/*Sustain loop on*/) {
					if(instrument_header.volume_envelope.slb >= instrument_header.volume_envelope.num) {
						return ERRNO; /* Sustain loop begins (0..(num-1)K{) */
					}
					if(instrument_header.volume_envelope.sle >= instrument_header.volume_envelope.num) {
						return ERRNO; /* Sustain loop ends (0..(num-1)K{) */
					}
					if(instrument_header.volume_envelope.slb > instrument_header.volume_envelope.sle) {
						return ERRNO; /* Sustain loop begin/ends ((begin)<=(end)K{) */
					}
					instrument->volume_envelope->susloop_begin = instrument->volume_envelope->node_points + instrument_header.volume_envelope.slb;
					instrument->volume_envelope->susloop_end   = instrument->volume_envelope->node_points + instrument_header.volume_envelope.sle + 1/*I[+1*/;
				}
			}
		}

	} else { /* Sample mode */

		/* SampleɈΈ̉zInstrument쐬܂B */
		driver->insnum = driver->smpnum;

		/* ITINSTRUMENT\̔zmۂ܂B */
		driver->instruments = calloc(driver->insnum, sizeof(ITINSTRUMENT));
		if(!driver->instruments) {
			return ERRNO;
		}

		/* eInstrumentɂ... */
		for(i_instrument = 0, instrument = driver->instruments;
		    i_instrument < driver->insnum;
		    i_instrument++, instrument++) {

			/* Global volumeݒ肵܂B */
			instrument->gbv = 128;

			/* Note-Sample/Keyboard Table쐬܂B */
			for(note = 0; note < 120; note++) {
				instrument->note_sample_keyboard_table[note].note = note;
				instrument->note_sample_keyboard_table[note].sample = i_instrument + 1; /* Sampleԍ1x[X */
			}
		}
	}

	/***************************
	 *  Impulse sample format  *
	 ***************************/

	/* ITSAMPLE\̔zmۂ܂B */
	driver->samples = calloc(driver->smpnum, sizeof(ITSAMPLE));
	if(!driver->samples) {
		return ERRNO;
	}

	/* eSampleɂ... */
	for(i_sample = 0, sample = driver->samples;
	    i_sample < driver->smpnum;
	    i_sample++, sample++) {

		/* ITSAMPLEHEADER\̂ǂݍ݂܂B */
		ptr = offset_of_samples + i_sample * sizeof(int);
		offset = LEWORD(ptr);
		ptr = (const unsigned char*)((int)data + offset);
		memcpy(&sample_header, ptr, sizeof(ITSAMPLEHEADER));

		/* Rgp̖SampleȂ΃XLbv܂B */
		if(sample_header.length < 1) {
			continue;
		}

		/* ŒtB[h܂B */
		if(memcmp(sample_header.imps, "IMPS", 4) != 0) {
			return ERRNO;
		}
		if(sample_header._00h != 0x00) {
			return ERRNO;
		}
		if(!(sample_header.cvt & 1)) {
			return ERRNO; /* Unsigned sample͖Ή */
		}

		/* Global volumeAFlagsADefault volumeAC5speed擾܂B */
		sample->gvl = sample_header.gvl;
		sample->flg = sample_header.flg;
		if(sample->flg & (4/*Stereo samples*/ | 8/*Compressed samples*/)) {
			return ERRNO; /* Stereo samplesACompressed samples͖Ή */
		}
		sample->vol = sample_header.vol;
		sample->c5speed = sample_header.c5speed;
		if((sample->c5speed < 0) ||
		   (sample->c5speed > 9999999)) {
			return ERRNO; /* C5speeds */
		}

		/* Sample dataԂZo܂B */
		sample->sample_data = (const unsigned char*)((int)data + sample_header.sample_pointer);
		if(sample->flg & 2/*16 bit*/) {
			sample->sample_end = sample->sample_data + sample_header.length * 2;
		} else { /*8 bit*/
			sample->sample_end = sample->sample_data + sample_header.length * 1;
		}

		/* LoopԂZo܂B */
		if(sample->flg & 16/*Use loop*/) {
			if((sample_header.loop_begin < 0) ||
			   (sample_header.loop_begin >= sample_header.length)) {
				return ERRNO; /* Loop begins (0..(length-1)K{) */
			}
			if((sample_header.loop_end <= 0) ||
			   (sample_header.loop_end > sample_header.length)) {
				return ERRNO; /* Loop ends (1..(length)K{) */
			}
			if(sample_header.loop_begin >= sample_header.loop_end) {
				return ERRNO; /* Loop begin/ends ((begin)<(end)K{) */
			}
			if(sample->flg & 2/*16 bit*/) {
				sample->loop_begin = sample->sample_data + sample_header.loop_begin * 2;
				sample->loop_end   = sample->sample_data + sample_header.loop_end   * 2;
			} else { /*8 bit*/
				sample->loop_begin = sample->sample_data + sample_header.loop_begin * 1;
				sample->loop_end   = sample->sample_data + sample_header.loop_end   * 1;
			}
		}

		/* Sustain loopԂZo܂B */
		if(sample->flg & 32/*Use sustain loop*/) {
			if((sample_header.susloop_begin < 0) ||
			   (sample_header.susloop_begin >= sample_header.length)) {
				return ERRNO; /* Sustain loop begins (0..(length-1)K{) */
			}
			if((sample_header.susloop_end <= 0) ||
			   (sample_header.susloop_end > sample_header.length)) {
				return ERRNO; /* Sustain loop ends (1..(length)K{) */
			}
			if(sample_header.susloop_begin >= sample_header.susloop_end) {
				return ERRNO; /* Sustain loop begin/ends ((begin)<(end)K{) */
			}
			if(sample->flg & 2/*16 bit*/) {
				sample->susloop_begin = sample->sample_data + sample_header.susloop_begin * 2;
				sample->susloop_end   = sample->sample_data + sample_header.susloop_end   * 2;
			} else { /*8 bit*/
				sample->susloop_begin = sample->sample_data + sample_header.susloop_begin * 1;
				sample->susloop_end   = sample->sample_data + sample_header.susloop_end   * 1;
			}
		}
	}

	/****************************
	 *  Impulse Pattern Format  *
	 ****************************/

	/* ITPATTERN\̔zmۂ܂B */
	driver->patterns = calloc(driver->patnum, sizeof(ITPATTERN));
	if(!driver->patterns) {
		return ERRNO;
	}

	/* ePatternɂ... */
	for(i_pattern = 0, pattern = driver->patterns;
	    i_pattern < driver->patnum;
	    i_pattern++, pattern++) {

		/* ITPATTERNHEADER\̂ǂݍ݂܂B */
		ptr = offset_of_patterns + i_pattern * sizeof(int);
		offset = LEWORD(ptr);
		if(!offset) {
			/* PatternOffset=0ŕۑ悤łB(NO-TMATF.IT)
			 * [hɂ̓G[AXLbv邱Ƃɂ܂B
			 * tɂrows==0ŔfA254(Skip)ƓƂ܂B(Ǝf)
			 */
			continue;
		}
		ptr = (const unsigned char*)((int)data + offset);
		memcpy(&pattern_header, ptr, sizeof(ITPATTERNHEADER));

		/*{{̌ptrĝŔj󂵂Ȃ!! */

		/* Rows擾܂B */
		pattern->rows = pattern_header.rows;
		if((pattern->rows < 32) ||
		   (pattern->rows > 200)) {
			return ERRNO; /* Rowss (32..200K{) */
		}

		/*}}܂łptrj󂵂ĂȂ!! */

		/* Packed data擾܂B
		 * Rs[̃[Jϐł͂ȂARs[Packed dataQƂ܂B
		 */
		pattern->packed_data = (const unsigned char*)((int)ptr + sizeof(ITPATTERNHEADER));
	}

	/************************
	 *  tJn̏ݒ  *
	 ************************/

	/* ITMODULEHEADERǂݍ݂܂B
	 * (Kv!! module_header͋p̂Ȃ̂ŁAŏɓǂݍ񂾓e͔j󂳂Ă܂B)
	 */
	ptr = (const unsigned char*)((int)data + 0);
	memcpy(&module_header, ptr, sizeof(ITMODULEHEADER));

	/* eChannelɂ... */
	for(i_channel = 0, channel = driver->channels;
	    i_channel < 64;
	    i_channel++, channel++) {

		/* ChannelȂ΃XLbv܂B */
		if(module_header.chnl_pan[i_channel] & 128) {
			continue;
		}

		/* SilentԂɂ܂B(LChannel) */
		channel->stat = ITCHANNEL_SILENT;

		/* Channel volume擾܂B */
		channel->chnl_vol = module_header.chnl_vol[i_channel];

		/* Instrumentŏ񔭐vꂽꍇɔāAInstrument 0ݒ肵Ă܂B */
		channel->pending_instrument = &driver->instruments[0];

		/* Volume/PanningCommandĂ܂B */
		channel->volume_panning = -1;
		channel->command = -1;
	}

	/* ŏPattern擾܂B */
	for(;;) {
		if((driver->order < 0) ||
		   (driver->order > driver->ordnum - 1)) {
			return ERRNO; /* SongI[ */
		}
		i_pattern = driver->orders[driver->order];
		if(i_pattern != 254) { /* SkipłȂ */
			if((i_pattern < 0) ||
			   (i_pattern > driver->patnum - 1)) {
				return ERRNO; /* Patterns */
			}
			driver->pattern = &driver->patterns[i_pattern];
			if(driver->pattern->rows) { /* ԂłȂ */
				driver->pattern_position = driver->pattern->packed_data;
				break;
			}
		}
		driver->order++;
	}

	return 0;

#undef module_header
#undef instrument_header
#undef sample_header
#undef pattern_header
}

int
it_init(ITDRIVER* driver, const void* data)
{
	int retval;

	retval = _it_init(driver, data);
	if(retval != 0) {
		it_free(driver); /* J */
	}

	return retval;
}

void
it_free(ITDRIVER* driver)
{
	int i_instrument;
	ITINSTRUMENT* instrument;

	/* ITINSTRUMENT\́AITENVELOPE\́AITENVELOPENODEPOINT\̂J܂B */
	if(driver->instruments) {
		for(i_instrument = 0, instrument = driver->instruments;
		    i_instrument < driver->insnum;
		    i_instrument++, instrument++) {
			if(instrument->volume_envelope) {
				if(instrument->volume_envelope->node_points) {
					free(instrument->volume_envelope->node_points);
				}
				free(instrument->volume_envelope);
			}
		}
		free(driver->instruments);
	}

	/* ITSAMPLE\̂J܂B */
	if(driver->samples) {
		free(driver->samples);
	}

	/* ITPATTERN\̂J܂B */
	if(driver->patterns) {
		free(driver->patterns);
	}

	/* it_free()ȏĂ΂ꂽꍇ̂߂ɁAITDRIVER\̂NAĂ܂B */
	memset(driver, 0, sizeof(ITDRIVER));
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//it_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
it_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	ITDRIVER* driver = (ITDRIVER*)param;
	//
	int retval;

	retval = it_run(driver);
	if(retval == 0) {
		retval = it_mix(driver, wbuff);
	}

	return retval;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

static ITDRIVER driver;

int
it_play(const void* data)
{
	int retval;

	/* ܂mɒ~܂B */
	it_stop();

	/* IT Driver܂B */
	retval = it_init(&driver, data);
	if(retval != 0) {
		return retval;
	}

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(ITBUFLEN, it_stream_callback, (int)&driver, 1/*X^bN؊gp*/);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(ITBUFLEN, it_stream_callback, (intptr_t)&driver, 1/*X^bN؊gp*/);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
it_stop()
{
	/* mɃXg[Đ~܂B */
	stream_stop();

	/* mIT DriverJ܂B */
	it_free(&driver);
}

