/*	
 *	clipio.c
 *
 *	S1C33 Family CRpCpbP[W io.lib ֐u܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2018 Naoyuki Sawa
 *
 *	* Mon Nov 25 20:37:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Nov 30 08:06:00 JST 2002 Naoyuki Sawa
 *	- stderr_open()/close()/write()ǉB
 *	* Wed Dec 11 12:30:00 JST 2002 Naoyuki Sawa
 *	- LbVpoϐ(cache_sct/len/ptr)ƁALbVV[N֐(io_seek())ǉB
 *	  Afread()ĂяoŃZN^ωȂꍇ́ApceFileReadSct()g킸LbVg܂B
 *	  ̉ǂɂAfgetc()fgets()̂悤ȍׂȒPʂœǂݍ݂sA2{ȏ㑬Ȃ܂B
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- stderr_open()̓AvP[V疾IɌĂԂ悤ɂ̂ŁA(clippce.cQ)
 *	  stderr_open()Ă΂ꂽꍇ͏ɏo̓j^̐ڑ҂悤ɕύX܂B
 *	* Wed Jun 26 20:03:00 JST 2005 Naoyuki Sawa
 *	- stderr_open()̕svpceLCDDispStop()Ăяo폜܂B
 *	* Tue Dec 13 04:35:00 JST 2005 Naoyuki Sawa
 *	- Wo͂ւ݂̏AWG[o͂ƓlɁAWG[o̓j^֏o͂悤ɕύX܂B
 *	  ܂ł́AWo(stdout)ւ݂̏́AG[IƂĂ܂B
 *	  ̕ύXɂAfprintf(stderr, fmt, ...)łȂAprintf(fmt, ...)j^ł悤ɂȂ܂B
 *	* Sun Jan 15 04:02:00 JST 2005 Naoyuki Sawa
 *	- ungetc()ɂāAEOFw肳ꂽAG[ƂĈAEOFԂǉ܂B
 *	  ܂ł́AEOFw肳ꂽꍇɂAG[ƂɁAXg[֖߂sĂ܂B
 *	* Tue Oct 30 00:38:57 JST 2012 Naoyuki Sawa
 *	- fileno(),isatty()ǉ܂B錾́Aclippce.h ɂ܂B	//{{2015/01/07ǋL:fileno(),isatty()̐錾Aclippce.hinclude/stdio.hֈړ܂Bclipio.cɂ܂Bisatty()͖{io.hunistd.hŐ錾ׂȂ̂łAP/ECEɂio.hunistd.ĥinclude/stdio.hŐ錾邱Ƃɂ܂B}}
 *	* Tue Oct 30 22:43:07 JST 2012 Naoyuki Sawa
 *	- isatty()̐R[h(͂Ȃ)Ȃ悤AύX܂B
 *	* Sat Mar 23 17:43:37 JST 2013 Naoyuki Sawa
 *	- stat(),fstat()ǉ܂B錾́Ainclude/sys/stat.h ɂ܂B
 *	* Sun Mar 09 14:07:14 JST 2014 Naoyuki Sawa
 *	- stdin_read()ǉ܂B
 *	  ̋@\ǉɔAtool/dstderr ɂ@\ǉs܂B
 *	  ڍׂ́Atool/dstderr/dstderr.c ̓̃RgQƂĂB
 *	* Mon Mar 10 17:00:24 JST 2014 Naoyuki Sawa
 *	- puts()so͂ĂȂoOC܂B
 *	- getchar,getc,putchar,putc}NA֐폜܂B
 *	  /clip/include/stdio.h QƂĂB
 *	* Thu Mar 13 01:48:55 JST 2014 Naoyuki Sawa
 *	- ڑ̃bZ[W͂̎זɂȂ鎖L邽ߍ폜܂B
 *	- tool/dstderr/dstdpipe 쐬܂B
 *	  ܂ł dstderr Ɠ̋@\A_łB
 *	  L[{[hȊO̓͂󂯕t̂ŁAt@C̗݂AvOP/ECE̒ppCvƂĂ삵܂B
 *	  ́Adstderr  dstdpipe gp悤ɂĂB
 *	* Thu Aug 07 23:44:53 JST 2014 Naoyuki Sawa
 *	- fcloseall()ǉ܂B
 *	* Sun Sep 07 20:09:27 JST 2014 Naoyuki Sawa
 *	- stat.st_blksize,stat.st_blocksǉ܂B
 *	- statvfs(),fstatvfs()ǉ܂B錾́Ainclude/sys/statvfs.h ɂ܂B
 *	* Thu Oct 23 18:26:54 JST 2014 Naoyuki Sawa
 *	- ֐vg^Cvfscanf(),scanf()폜Aclipscan.cɂĎ܂B
 *	* Wed Dec 31 17:37:43 JST 2014 Naoyuki Sawa
 *	- cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B
 *	  ̕ύXɔAstderr_open()pceLCDDispStart()Ăяo͕svɂȂA폜܂B
 *	* Wed Mar 11 21:52:17 JST 2015 Naoyuki Sawa
 *	- truncate(),ftruncate()ǉ܂B
 *	  錾include/stdio.hɗL܂B
 *	  {unistd.hŐ錾ׂȂ̂łP/ECEɂunistd.ĥőinclude/stdio.hŐ錾鎖ɂ܂B
 *	* Fri Mar 13 21:06:23 JST 2015 Naoyuki Sawa
 *	- fwrite()܂Bfwrite()ĂяoĂfprintf()fputc()A삷悤ɂȂ܂B
 *	  ZN^Pʂŏނ̂ŁAɒ[ɃtbV߂鎖͗L܂BŐL^ɗpłƎv܂B
 *	  Apɂfflush()ĂяoƁAtbV߂\L܂B
 *	  ȂׂIfflush()Ăяo͍s킸Afwrite()fclose()ł̎Iȏ݂ɔCĂB
 *	- ݃[hŊJXg[ɑ΂fseek()͖ΉłB
 *	  ݂̎ł́A݃[hŊJXg[ɑ΂fseek()gpƁAԈf[^݂܂B
 *	- ̕ύXɍۂăLbVpoϐ(cache_sct/len/ptr)폜̂ŁAύXOfread()̐\ቺ܂B
 *	  LbVpoϐ폜R͕KRł͂ȂAG炵ăoO̊댯ጸ悤ƎvłB
 *	  fread()̐\ቺ傫eP[X͏ȂƎv܂A肪ꍇ͕ύXÕvWFNgQƂăLbVpoϐ߂ĂB
 *	- ͏ύXƃ\[X`𑽂s߁AύXÕR[h\[XɎcĂ܂B
 *	  ύXȌQƂꍇ́AO܂ł̃A[JCvQƂĂB
 *	* Sat Mar 14 21:29:01 JST 2015 Naoyuki Sawa
 *	- truncate()́upceFileCreate()pŁv쐬܂B
 *	* Fri May 01 00:17:04 JST 2015 Naoyuki Sawa
 *	- io_open()ɒǉ݃[h('a')̏ǉ܂B
 *	  ̕ύXɂfopen()"a"wł悤ɂȂ܂B
 *	* Fri May 01 22:43:26 JST 2015 Naoyuki Sawa
 *	- vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
 *	  vfprintf()͌Xt@C݂xāAxdvł͂Ȃ̂ŁA񃁃m,JsĂe͏Ǝv܂B
 *	- fprintf()vfprintf()_def_vbuff[]j󂵂ȂȂ̂ŁÅ֐荞݃[`łg悤ɂȂ܂B
 *	  ႦΊ荞݃[`̊JɁAfobOOP/ECEt@CVXẽt@CƂďo͂悤Ȏgo܂B
 *	* Sun Aug 02 16:45:48 JST 2015 Naoyuki Sawa
 *	- fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂B
 *	  Win32vWFNgłAdoprnt()𗘗pprintf()𗘗płB
 *	  clipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
 *	* Tue Dec 08 21:34:19 JST 2015 Naoyuki Sawa
 *	- fwrite()Iɍ܂B
 *	- ܂ł́A݂pɂɍsƁAfwrite()ɒ[ɒx肪L܂B
 *	  x́Atruncate()ĂяoĂłB
 *	  قƂǂ̏ꍇAtruncate()pceFileCreate()ĂяoApceFileCreate()t@CTCY̕ύXsvł鎖o܂B
 *	  ]āAtbV͔̏AtbV߂鎖͖̂ŁÂ܂܂łԈႢł͂Ȃ̂łAɒ[ɒxƂ肪܂B
 *	  pceFileCreate()Ăяoxclippce.c̃tbNɂăNbN̐؂ւFRAM4̑ޔ܂AP/ECEJ[lpceFileCreate()̏̂Ȃ莞Ԃ邩łB
 *	- ύX́At@CTCY̕ύX̗v/sv𓖊֐ŔfAt@CTCY̕ύXKvłꍇ̂݁Atruncate()Ăяo悤ɂ܂B
 *	  ̕ύXɂāAfwrite()Iɍ܂B
 *	  vʂ́Aȉ̒ʂłB
 *	  eXgvO(48MHz,FRAMX^bN)
 *	  for(i=0;i<10000;i++){fwrite("ABC",1,3,fp);}
 *	  EύXO˖19.5b
 *	  EύX˖ 1.5b
 *	* Tue Jun 14 22:46:37 JST 2016 Naoyuki Sawa
 *	- Wo͂ɑ΂fflush()Ăяoꂽ́AȂ悤ɏC܂B
 *	  ܂ł́Aʏ̃t@CƓlɏ悤Ƃio_file()ĂяoĂ܂ĂAio_file()ŃG[~Ă܂Ă܂B
 *	  Ⴆ΁ALuaXNvg'print'߂́AWo͂֕o͂AIɕWo͂fflush()ŝŁA'print'߂gƃG[~Ă܂Ă܂B(Lua 5.3.3ɂĊmF)
 *	  ĆAL̖͖Ȃ܂B
 *	* Thu Jul 20 22:55:59 JST 2017 Naoyuki Sawa
 *	- fputs()A܂ł͈ꕶÂoĂ܂Axőo悤ɕύX܂B
 *	  ɁAWG[o͂ւ̃fobOꍇ̐\P܂B
 *	  ܂ł͌ʓIɈꕶƂstderr_write()ĂяoꕶƂpceUSBCOMStartTx()ăI[o[wbh傫̂łA͕ŜpceUSBCOMStartTx()őo悤ɂȂłB
 *	- Afgets()͕ύXĂ炸A܂ŒʂꕶÂĂ܂B
 *	  fgets()͉sŏł؂KvL邽߁AsŜ܂Ƃ߂ēǂݍގłB
 *	  fgets()͈ꕶÂ̏̂܂܂łꕶƂpceUSBCOMStartRx()悤ȃASYɂ͂ȂĂȂ̂ŁÂ݂܂܂Ŗ薳Ǝv܂B
 *	* Fri Jul 21 22:18:50 JST 2017 Naoyuki Sawa
 *	- stdin_read()ɂāAPCUSBCOMؒfOɑMf[^AƂ肱ڂȂ悤ɏC܂B
 *	  CŔAȉ̒ʂłB
 *	- COstdin_read()ł́AUSBCOMؒfĂAMς݂̃f[^LƂĂāA'M'ԂĂ܂B
 *	  ł́Aȉ̂悤ȎgɁAPCMŌ̈sP/ECẼAvŎ擾ꂸAƂ肱ڂĂ܂肪܂B
 *	  P/ECẼAv
 *	  int app_main(int argc, char* argv[]) {
 *	    char buf[512];
 *	    FILE* fp = fopen("out.txt", "w");
 *	    if(!fp) { DIE(); }
 *	    for(;;) {
 *	      schedule();
 *	      if(fgets(buf, sizeof buf, stdin)) { fputs(buf, fp); }
 *	    } //"out.txt"mFOSELECT{^ăAvIĉBȂƃt@C̏݃obt@tbV܂B
 *	    return 0;
 *	  }
 *	  PCł̑
 *	  type sample.txt | dstdpipe.exe
 *	  ȂŌ̈sƂ肱ڂ邩ƌƁAdstdpipe.exéAsample.txt̍Ō̈s𑗐MAUSBCOMؒfďI܂B
 *	  P/ECẼAṽC[vŎfgets()Ă΂ꂽAMobt@ɂ͍Ō̈sĂ邪AUSBCOM͐ؒfꂽԂłACOstdin_read()̃ASYł͂̈sƂ肱ڂĂ܂̂łB
 *	  ʂƂāALP/ECẼAv̗ł́Asample.txt̍Ō̈ssԂŁAout.txtĂ܂Ă܂B
 *	- Cstdin_read()́AUSBCOMؒfĂĂAMς݂̃f[^L΁Astdin_read()̌Ăяoɑ΂Ă͂܂USBCOMؒfĂȂ̂悤ɐU镑āAؒfOɎMf[^Ԃ悤ɂ܂B
 *	  CAOq̕@œmFsAŌ̈sƂ肱ڂout.txt悤ɂȂmF܂B
 *	  ̏Čʂ(ǂӖ)傾Ǝv܂AύX_͋͂Ȃ̂ŁA̕ύXɂ鈫eGoO̊댯͏Ǝv܂B
 *	* Thu May 24 23:59:59 JST 2018 Naoyuki Sawa
 *	- UFEɑΉ܂B
 */
#include "clip.h"
//2002/11/26݂̎ł́Å֐G[errnoݒ肵܂B
//errnoăG[𔻒fĂvÓAȂ\܂B
//TODO:errnoݒ肷悤CB
/****************************************************************************
 *	֐vg^Cv
 ****************************************************************************/
//ȉ́wS5U1C33000C Manual (S1C33 Family CRpCpbP[W) (Ver.4)x(S5U1C33000C_J.pdf) p.97 8.2.1 o͊֐(io.lib) \8.2.1.1 o͊֐ꗗ ̕тƓԂłBeX̊֐ARgAEgčsĂB
//FILE* fopen(const char* filename, const char* mode) { DIE(); }
//FILE* freopen(const char* filename, const char* mode, FILE* stream) { DIE(); }
//int fclose(FILE* stream) { DIE(); }
//int fflush(FILE* stream) { DIE(); }
//int fseek(FILE* stream, long offset, int origin) { DIE(); }
//long ftell(FILE* stream) { DIE(); }
//void rewind(FILE* stream) { DIE(); }
//int fgetpos(FILE* stream, fpos_t* pos) { DIE(); }
//int fsetpos(FILE* stream, const fpos_t* pos) { DIE(); }
//size_t fread(void* buffer, size_t size, size_t count, FILE* stream) { DIE(); }
//size_t fwrite(const void* buffer, size_t size, size_t count, FILE* stream) { DIE(); }
//int fgetc(FILE* stream) { DIE(); }
//int getc(FILE* stream) { DIE(); }
//int getchar() { DIE(); }
//int ungetc(int c, FILE* stream) { DIE(); }
//char* fgets(char* string, int n, FILE* stream) { DIE(); }
//char* gets(char* buffer) { DIE(); }
//int fputc(int c, FILE* stream) { DIE(); }
//int putc(int c, FILE* stream) { DIE(); }
//int putchar(int c) { DIE(); }
//int fputs(const char* string, FILE* stream) { DIE(); }
//int puts(const char* string) { DIE(); }
//int remove(const char* filename) { DIE(); }
int rename(const char* oldname, const char* newname) { DIE(); }
void setbuf(FILE* stream, char* buffer) { DIE(); }
int setvbuf(FILE* stream, char* buffer, int mode, size_t size) { DIE(); }
FILE* tmpfile() { DIE(); }
char* tmpnam(char* string) { DIE(); }
//int feof(FILE* stream) { DIE(); }
//int ferror(FILE* stream) { DIE(); }
//void clearerr(FILE* stream) { DIE(); }
//void perror(const char* string) { DIE(); }
//int fscanf(FILE* stream, const char* format, ...) { DIE(); }	-> 2014/10/23 clipscan.c
//int scanf(const char* format, ...) { DIE(); }			-> 2014/10/23 clipscan.c
//int sscanf(char* buffer, const char* format, ...); -> io.lib(̂܂܎gp)
//int fprintf(FILE* stream, const char* format, ...) { DIE(); }
//int printf(const char* format, ...) { DIE(); }
//int sprintf(char* buffer, const char* format, ...); -> P/ECE Kernel(pcesprintf) -> 2003/05/20 clipprnt.c
//int vfprintf(FILE* stream, const char* format, va_list argptr) { DIE(); }
//int vprintf(const char* format, va_list argptr) { DIE(); }
//int vsprintf(char* buffer, const char* format, va_list argptr); -> P/ECE Kernel(pcevsprintf) -> 2003/05/20 clipprnt.c
/****************************************************************************
 *	[JϐE֐
 ****************************************************************************/
//_~[̕Wo͗pAhX`B
//AhXɂĂȂio_file()ŃG[oOɃAhXG[ŗ̂ŒӁB
#define FILE_STDIN	((FILE*)(- 4))	//_~[Bio_file()ŃG[Bfread() ̂ݓʏ
#define FILE_STDOUT	((FILE*)(- 8))	//_~[Bio_file()ŃG[Bfwrite()̂ݓʏ
#define FILE_STDERR	((FILE*)(-12))	//_~[Bio_file()ŃG[Bfwrite()̂ݓʏ
/*--------------------------------------------------------------------------*/
#define MAX_IO		(3+3)		//ɊJőt@C	Wo(3)+ʏt@C(3)	
#define VALIDFILEACC	0x9CE6		//-> fa.valid	\usr\PIECE\sysdev\pcekn\file.c Q
#define IO_WRT		(1<<0)		//-> IO.flag	݃[h
#define IO_EOF		(1<<1)		//-> IO.flag	EOFwq
#define IO_ERR		(1<<2)		//-> IO.flag	G[wq
typedef struct _IO {
	FILEACC		fa;				//+ 0,   16  t@CANZX\
	int		pos;				//+16,    4  ̓ǂݍ/݈ʒu
	unsigned char	flag;				//+20,    1  IO_EOF,IO_ERȒgݍ킹
	char		filename[26/*MAXFILENAME*/+1];	//+21,   27  t@C
	unsigned char	sctbuf[0/*BLOCKSIZE*/];		//+48,(4096) ZN^obt@	݃[hŊJmۂBێĂoCg(pos%BLOCKSIZE)ŋ߂B傤BLOCKSIZEoCgێ鎖͖Bfwrite()ɂBLOCKSIZEoCgPʂŃtbV֏ނB
} IO;							//=48+(4096)
static IO* ios[MAX_IO] = {	//t@CI/O\̃|C^z
	(IO*)FILE_STDIN,	//0(STDIN_FILENO ) W		
	(IO*)FILE_STDOUT,	//1(STDOUT_FILENO) Wo		Œ
	(IO*)FILE_STDERR,	//2(STDERR_FILENO) WG[o	
	//ȍ~ʏt@CpBlNULLB
};
/*--------------------------------------------------------------------------*/
//w肳ꂽXg[|C^Aʏt@C̃Xg[|C^ł鎖mFŁAt@CI/O\̃|C^ɃLXgĕԂB
//NULL|C^AWo͂̃Xg[|C^Aꂽ|C^⃁w肵ꍇA֐̒ŃG[~B
static IO* io_file(FILE* stream) {
	IO* io = (IO*)stream;
//{{2018/05/24ύX:UFEɑΉ܂B
//	if(io->fa.valid != VALIDFILEACC) { DIE(); } //t@CJĂ邱ƂmFB
//2018/05/24ύX:UFEɑΉ܂B
	static_assert(FILEACC_PFFS == VALIDFILEACC, "FILEACC_PFFS̒`zƈقȂ܂B");
	if((io->fa.valid != FILEACC_PFFS) &&
	   (io->fa.valid != FILEACC_UFE)) { DIE(); } //t@CJĂ邱ƂmFB
//}}2018/05/24ύX:UFEɑΉ܂B
	return io;
}
/*--------------------------------------------------------------------------*/
static IO* io_open(const char* filename, const char* mode) {
	IO* io;
	switch(mode[0]) { //ȗāAꕶڂŔ肷鎖ɂB
	case 'r':
		//t@CI/O\̂̃mۂBǂݍ݃[h̏ꍇ̓ZN^obt@svB
		io = calloc(1, sizeof(IO));
		if(!io) { DIE(); }	//s
		//t@CJ܂B
		if(pceFileOpen(&io->fa, filename, FOMD_RD)) {	//pceFileOpen()(io->fa.valid==VALIDFILEACC)ɂȂĂ܂B
			free(io);	//s炷ɁAt@CI/O\̂̃JB
			return NULL;	//t@CJȂB
		}
		break;
	case 'w':
		//t@CI/O\̂̃mۂB݃[h̏ꍇ̓ZN^obt@KvB
		io = calloc(1, sizeof(IO) + BLOCKSIZE);
		if(!io) { DIE(); }	//s
		//t@C쐬܂B
		if(pceFileCreate(filename, 0) ||	//t@CΐVK쐬Bt@CL0oCgɐ؂l߂B
		   pceFileOpen(&io->fa, filename, FOMD_WR)) {	//pceFileOpen()(io->fa.valid==VALIDFILEACC)ɂȂĂ܂B
			free(io);	//s炷ɁAt@CI/O\̂̃JB
			return NULL;	//t@C쐬łȂB
		}
		io->flag |= IO_WRT;	//݃[h
		break;
	case 'a':
		//t@CI/O\̂̃mۂB݃[h̏ꍇ̓ZN^obt@KvB
		io = calloc(1, sizeof(IO) + BLOCKSIZE);
		if(!io) { DIE(); }	//s
		//t@CJ܂B
		if(pceFileOpen(&io->fa, filename, FOMD_WR) &&	//t@CLΊJB
		  (pceFileCreate(filename, 0) ||		//t@CΐVK쐬B
		   pceFileOpen(&io->fa, filename, FOMD_WR))) {	//pceFileOpen()(io->fa.valid==VALIDFILEACC)ɂȂĂ܂B
			free(io);	//s炷ɁAt@CI/O\̂̃JB
			return NULL;	//t@C쐬łȂB
		}
		io->flag |= IO_WRT;	//݃[h
		//݈ʒut@C̏I[Ƃ܂B
		io->pos = io->fa.fsize;
		//݈ʒu܂ރZN^̊̃f[^ZN^obt@֓ǂݍ݂܂B
		{
			int sct = io->pos / BLOCKSIZE;					//sct=݈ʒu܂ރZN^ԍB
			int sln = pceFileReadSct(&io->fa, NULL, sct, BLOCKSIZE);	//sln=̃ZN^̃f[^TCYB(==io->pos%BLOCKSIZE)
			memcpy(io->sctbuf, io->fa.aptr, sln);				//ZN^obt@֓ǂݍ݂܂B
		}
		break;
	default:
		DIE();/*return NULL;*/	//AvP[ṼoỎ\̂ŁAG[lԂ̂ł͂ȂG[~鎖ɂB
	}
	//t@Ci[B
	strcpy(io->filename, filename);
	return io;
}
/*--------------------------------------------------------------------------*/
static void io_close(FILE* stream) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	//t@CB
	pceFileClose(&io->fa);
	//t@CI/O\̂̃JB
	free(io);
}
/****************************************************************************
 *	O[oϐE֐
 ****************************************************************************/
FILE* stdin  = FILE_STDIN;
FILE* stdout = FILE_STDOUT;
FILE* stderr = FILE_STDERR;
/*--------------------------------------------------------------------------*/
FILE* fopen(const char* filename, const char* mode) {
	int fd;
	//t@CLqq̋󂫂B
	for(fd = 0; fd < MAX_IO; fd++) {
		//t@CLqq̋󂫂L΁c
		if(!ios[fd]) {
			//t@CJB
			ios[fd] = io_open(filename, mode);	//sȂ(ios[fd]=NULL)̂܂܁B
			return (FILE*)ios[fd];			//sȂ(ios[fd]=NULL)ԂB
		}
	}
	return NULL; //t@CLqq̋󂫂B
}
/*--------------------------------------------------------------------------*/
FILE* freopen(const char* filename, const char* mode, FILE* stream) {
	//̃Xg[̃t@CLqq擾B
	int fd = fileno(stream);
	//̃Xg[B
	fclose(stream);		//Wo͂w肳ꂽꍇ͂̒ŃG[~B
	if(ios[fd]) { DIE(); }	//t@CLqqJꂽmFBJĂȂfclose()̃oOłB
	//t@CJAƓt@CLqq̈ʒuɊi[B
	ios[fd] = io_open(filename, mode);	//sȂ(ios[fd]=NULL)̂܂܁B
	return (FILE*)ios[fd];			//sȂ(ios[fd]=NULL)ԂB
}
/*--------------------------------------------------------------------------*/
int fclose(FILE* stream) {
	//̃Xg[̃t@CLqq擾B
	int fd = fileno(stream);
	//݃[hȂ΃ZN^obt@tbVBǂݍ݃[hȂ΃_~[ƂȂB
	int result = fflush(stream);	//Wo͂w肳ꂽꍇ͂̒ŃG[~B
	//t@CB
	io_close(stream);
	//t@CLqqJB
	ios[fd] = NULL;	//̏fflush()ōsBfflush()truncate()̒ios[]QƂ'݊JĂt@CI/O\̂ɂf鏈'sB
	//fflush()̌ʂAfclose()̖߂lƂB
	return result;
}
/*--------------------------------------------------------------------------*/
//{{2015/03/14:pceAppExit()̒fcloseall()̌Ăяoǉ܂B
// * Sat Mar 14 21:29:01 JST 2015 Naoyuki Sawa
// - pceAppExit()̒fcloseall()̌Ăяoǉ܂B
//   fcloseall()̒DIE()ƈُ퓮ɂȂ̂ŒӂĂBoǑoȂΎdN蓾G[ɑ΂Ăfcloseall()DIE()łȂG[lԂ悤ɂĂB
//   pceAppExit()fcloseall()ԂG[l𖳎ďIp܂B
//}}2015/03/14:pceAppExit()̒fcloseall()̌Ăяoǉ܂B
int fcloseall() {
	//fcloseall()̖߂lɂ́A̗V܂B
	//GNU C: SẴt@Cɕꂽꍇ(0)ԂBG[̏ꍇAEOFԂB
	//Visual C++: N[YXg[̑ԂBG[ƁAEOFԂB
	//{W[̎́AGNU C̗Vɏ]܂B
	int fd, result = 0;
    //	for(fd =                 0; fd < MAX_IO; fd++) { //͂c
	for(fd = STDERR_FILENO + 1; fd < MAX_IO; fd++) { //ł͕Wo͕͂ȂɂB
		FILE* stream = (FILE*)ios[fd];
		//Xg[JĂB1łG[߂lEOFɂBG[Ă[vpB
		if(stream && fclose(stream)) { result = EOF; }
	}
	return  result;
}
/*--------------------------------------------------------------------------*/
int fflush(FILE* stream) {
	// * Tue Jun 14 22:46:37 JST 2016 Naoyuki Sawa
	// - Wo͂ɑ΂fflush()Ăяoꂽ́AȂ悤ɏC܂B
	//   ܂ł́Aʏ̃t@CƓlɏ悤Ƃio_file()ĂяoĂ܂ĂAio_file()ŃG[~Ă܂Ă܂B
	//   Ⴆ΁ALuaXNvg'print'߂́AWo͂֕o͂AIɕWo͂fflush()ŝŁA'print'߂gƃG[~Ă܂Ă܂B(Lua 5.3.3ɂĊmF)
	//   ĆAL̖͖Ȃ܂B
	if((stream == FILE_STDIN ) ||
	   (stream == FILE_STDOUT) ||
	   (stream == FILE_STDERR)) {
		/** no job **/
	} else {
		IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
		//݃[hȂ΁c
		if(io->flag & IO_WRT) {
			int sct = io->pos / BLOCKSIZE;	//݂݈̏ʒu܂ރZN^ԍ
			int len = io->pos % BLOCKSIZE;	//ZN^obt@ɎcĂoCg
			//ZN^obt@ɎcĂoCgL΁c
			if(len) {
				//t@CTCYLB
				if(truncate(io->filename, io->pos)) { return EOF; }	//eʕs
				//ZN^obt@ɎcĂf[^ށB
				if(pceFileWriteSct(&io->fa, io->sctbuf, sct, len) != len) { DIE(); }	//oO
			}
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
int fseek(FILE* stream, long offset, int origin) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	clearerr(stream); //EOFwqƃG[wqNAB
	switch(origin) {
	case SEEK_SET:
		io->pos = offset;
		break;
	case SEEK_CUR:
		io->pos += offset;
		break;
	case SEEK_END:
		io->pos = io->fa.fsize - offset;
		break;
	default:
		DIE();/*return -1;*/	//AvP[ṼoỎ\̂ŁAG[lԂ̂ł͂ȂG[~鎖ɂB
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
long ftell(FILE* stream) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	return io->pos;
}
/*--------------------------------------------------------------------------*/
void rewind(FILE* stream) {
	fseek(stream, 0, SEEK_SET); //fseek()̒EOFwqƃG[wqNA܂B
}
/*--------------------------------------------------------------------------*/
int fgetpos(FILE* stream, fpos_t* pos) {
	*pos = ftell(stream);
	return 0;
}
/*--------------------------------------------------------------------------*/
int fsetpos(FILE* stream, const fpos_t* pos) {
	return fseek(stream, *pos, SEEK_SET); //fseek()̒EOFwqƃG[wqNA܂B
}
/*--------------------------------------------------------------------------*/
size_t fread(void* buffer, size_t size, size_t count, FILE* stream) {
	if(stream == FILE_STDIN) { //W͓͂ʏŁAWG[o̓j^͂܂B
		//ɂ́Ȁ͌łB
		//{́AW͂ɕcĂƂĂAsize̔{ɖȂubN͓ǂݍł͂ȂB
		//AP/ECEvOł͂قsize=1ŎgpƎv̂ŁǍ͎ɂ͂ȂȂƔfÂ܂܂ɂ邱ƂɂB
		return stdin_read(buffer, size * count) / size;
	} else {
		IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
		char* p = (char*)buffer;
		int len = size * count;
		int ofs, sct, sof, sln;
		//݂̎ł́AŌ̍ڂr[ɓǂݍ߂ꍇA̕obt@ɓǂݍł܂܂B
		//Ⴆ΁A150oCg̃t@C̑O100oCgobt@ɓǂݍޏꍇA{fread()Ȃ΁F
		//char buf[100];
		//retval = fread(buf, 100, 2, fp); -> ߂l1ŁAbuf[0`99]܂łɃf[^ǂݍ܂܂
		//ƂȂ܂A̎ł́F
		//char buf[100];
		//retval = fread(buf, 100, 2, fp); -> ߂l1łAbuf[0`149]܂Ńf[^ǂݍ܂܂
		//ƂȂAobt@I[o[NĂ܂܂B
		//̂悤Ȋ댯ȌĂяo邱Ƃ͂܂ȂƎv܂AÔ߂ӂB
		ofs = 0;
		while(ofs < len) {
			//ZN^̃tbVAhX擾܂B
			sct = (io->pos + ofs) / BLOCKSIZE;			//sct=݂̓ǂݍ݃ItZbg܂ރZN^ԍB
			sln = pceFileReadSct(&io->fa, NULL, sct, BLOCKSIZE);	//sln=̃ZN^̃f[^TCYBŏIZN^̂(sln<BLOCKSIZE)ɂȂ蓾B
			if(sln == 0) { break; }					//ԂItZbg߁B
			//̃ZN^ǂݍރTCY肵܂B
			sof = (io->pos + ofs) % BLOCKSIZE;			//ZN^ItZbgB
			sln -= sof;						//ZN^ItZbgȍ~ǂݍ݉\ȍőf[^TCYB
			if(sln > len - ofs) { sln = len - ofs; }		//ǂݍ݉\ȍőf[^TCYcǂݍ݃TCYȏȂA؂l߂܂B
			if(sln <= 0) { break; }					//ԂItZbg߁A܂͓ǂݍ݃TCY0ȉw肳ꂽ(len<=0)B
			//ZN^obt@֓ǂݍ݂܂B
			memcpy(p + ofs, io->fa.aptr + sof, sln);
			ofs += sln;
		}
		count = ofs / size;						//Sɓǂݍ߂ڐB
		io->pos += count * size;					//Sɓǂݍ߂ڂ̕At@C|C^݈̌ʒui߂܂B
		if(count * size < len) { io->flag |= IO_EOF; }			//Sɓǂݍ߂oCgAvTCY**AEOF}[NB
		return count;							//Sɓǂݍ߂ڐԂ܂B
	}
}
/*--------------------------------------------------------------------------*/
size_t fwrite(const void* buffer, size_t size, size_t count, FILE* stream) {
	if((stream == FILE_STDOUT) || (stream == FILE_STDERR)) { //Wo͂ƕWG[o͓͂ʏŁAWG[o̓j^֏o͂܂B
		stderr_write(buffer, size * count);
		return count;
	} else {
		IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
		char* p = (char*)buffer;
		int len = size * count;
	    //{{2015/12/08ύX:fwrite()Iɍ܂B
	    //	//t@CTCYAf[^ǉ̃TCY𒴂Ȃ,,ZN^TCY̔{ɐLB
	    //	if(truncate(io->filename, (io->pos + len) & ~(BLOCKSIZE - 1))) { return 0; }	//eʕs
	    //2015/12/08ύX:fwrite()Iɍ܂B
		// * Tue Dec 08 21:34:19 JST 2015 Naoyuki Sawa
		// - fwrite()Iɍ܂B
		// - ܂ł́A݂pɂɍsƁAfwrite()ɒ[ɒx肪L܂B
		//   x́Atruncate()ĂяoĂłB
		//   قƂǂ̏ꍇAtruncate()pceFileCreate()ĂяoApceFileCreate()t@CTCY̕ύXsvł鎖o܂B
		//   ]āAtbV͔̏AtbV߂鎖͖̂ŁÂ܂܂łԈႢł͂Ȃ̂łAɒ[ɒxƂ肪܂B
		//   pceFileCreate()Ăяoxclippce.c̃tbNɂăNbN̐؂ւFRAM4̑ޔ܂AP/ECEJ[lpceFileCreate()̏̂Ȃ莞Ԃ邩łB
		// - ύX́At@CTCY̕ύX̗v/sv𓖊֐ŔfAt@CTCY̕ύXKvłꍇ̂݁Atruncate()Ăяo悤ɂ܂B
		//   ̕ύXɂāAfwrite()Iɍ܂B
		//   vʂ́Aȉ̒ʂłB
		//   eXgvO(48MHz,FRAMX^bN)
		//   for(i=0;i<10000;i++){fwrite("ABC",1,3,fp);}
		//   EύXO˖19.5b
		//   EύX˖ 1.5b
		//̃ZN^݂ɕKvȃt@CTCY(=f[^ǉ̃TCY𒴂Ȃ,,ZN^TCY̔{̃TCY)߂B
		int newSize = (io->pos + len) & ~(BLOCKSIZE - 1);
		//̃ZN^݂ɕKvȃt@CTCYÃ݂t@CTCY傫΁At@CTCYύXB
		if((newSize > io->fa.fsize) && truncate(io->filename, newSize)) { return 0; }	//eʕs
	    //}}2015/12/08ύX:fwrite()Iɍ܂B
		//f[^̎coCgȂ܂Łc
		while(len) {
			int sct = io->pos / BLOCKSIZE;		//݂݈̏ʒu܂ރZN^ԍ
			int sof = io->pos % BLOCKSIZE;		//ZN^obt@ɒǉItZbg
			int sln = BLOCKSIZE - sof;		//ZN^obt@ɒǉłoCg
			if(sln > len) { sln = len; }		//ZN^obt@ɒǉoCg߂B
			memcpy(&io->sctbuf[sof], p, sln);	//ZN^obt@ɒǉB
			p       += sln;				//f[^AhXi߂B
			len     -= sln;				//f[^̎coCg炷B
			io->pos += sln;				//݈ʒui߂B
			if(io->pos % BLOCKSIZE) { break; }	//ZN^obt@tɂȂOɃf[^sAtbVɏ܂ɔB
			if(pceFileWriteSct(&io->fa, io->sctbuf, sct, BLOCKSIZE) != BLOCKSIZE) { DIE(); }	//oO
		}
		if(len) { DIE(); }	//oO
		return count;
	}
}
/*--------------------------------------------------------------------------*/
int fgetc(FILE* stream) {
	unsigned char c; //fgetc(),getc(),getchar()́Aunsigned charƂēǂintɃLXgĕԂB(uLinux Programmer's Manual - FGETCv)
	if(fread(&c, 1, 1, stream) != 1) { return EOF; }
	return c;
}
/*--------------------------------------------------------------------------*/
//{{2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB
//int getc(FILE* stream) {
//	return fgetc(stream);
//}
//int getchar() {
//	return getc(stdin);
//}
//}}2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB
/*--------------------------------------------------------------------------*/
int ungetc(int c, FILE* stream) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	//EOFԂƂAXg[֖߂s킸ɁAG[EOFԂ܂B
	//ȊOȂ΁AXg[֖߂sA߂R[ĥ܂ܕԂ܂B
	if(c != EOF) {
		io->pos--; //KȎI{ungetc()Ƃ͂񂺂Ⴂ܂B
		//ĂяoA'\x80'`'\xFF'𕄍gāA'\xFF80'`'\xFFFF'nꍇłAungetc()̖߂ĺA'\x80'`'\xFF'ƂȂ܂B
		//ۂɂ́A8bit\xFFǂɂ炸Aɏ8bitNA܂B
		//̎dĺAVisual C++ 6.0 SP6́A^CCũ\[X̎ɍ킹܂B
		c = (unsigned char)c;
	}
	return c;
}
/*--------------------------------------------------------------------------*/
char* fgets(char* string, int n, FILE* stream) {
	char* p = string;
	if(n <= 0) { return NULL; } //string̗eʂ0ȉȂΉȂB(*p='\0')sĂ͂ȂB
	while(--n) { //(n-1)܂łǂݍ܂Ȃ̂ŃvfNg0肷B
		if(fread(p, 1, 1, stream) != 1) {
			if(p == string) { return NULL; } //ꕶǂ߂ȂB
			break;
		}
		if(*p++ == '\n') { break; } //'\n'\0ɒuȂ̂'\n'̏ꍇp++sB
	}
	*p = '\0';
	return string;
}
/*--------------------------------------------------------------------------*/
char* gets(char* buffer) {
	char* p = buffer;
	for(;;) {
		if(fread(p, 1, 1, stdin) != 1) {
			if(p == buffer) { return NULL; } //ꕶǂ߂ȂB
			break;
		}
		if(*p == '\n') { break; } //'\n''\0'ɒû'\n'Ȃp++sȂB
		p++;
	}
	*p = '\0';
	return buffer;
}
/*--------------------------------------------------------------------------*/
int fputc(int c, FILE* stream) {
	if(fwrite(&c, 1, 1, stream) != 1) { return EOF; }
	return (unsigned char)c; //fputc(),putc(),putchar()unsigned charƂď܂ꂽintɃLXgĕԂB(uLinux Programmer's Manual - PUTSv)
}
/*--------------------------------------------------------------------------*/
//{{2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB
//int putc(int c, FILE* stream) {
//	return fputc(c, stream);
//}
//int putchar(int c) {
//	return putc(c, stdout);
//}
//}}2014/03/10폜:getchar,getc,putchar,putc}NA֐폜܂B/clip/include/stdio.h QƂĂB
/*--------------------------------------------------------------------------*/
int fputs(const char* string, FILE* stream) {
//{{2017/07/20ύX:fputs()A܂ł͈ꕶÂoĂ܂Axőo悤ɕύX܂B
//	int c;
//	while((c = *string++)) {
//		if(fwrite(&c, 1, 1, stream) != 1) { return EOF; }
//	}
//2017/07/20ύX:fputs()A܂ł͈ꕶÂoĂ܂Axőo悤ɕύX܂B
	int len = strlen(string);
	if(fwrite(string, 1, len, stream) != len) { return EOF; }
//}}2017/07/20ύX:fputs()A܂ł͈ꕶÂoĂ܂Axőo悤ɕύX܂B
	return 0; //͏񂾃oCgł͂Ȃ0ԂB
}
/*--------------------------------------------------------------------------*/
int puts(const char* string) {
	if((fputs(string, stdout) < 0) ||
	   (fputc('\n'  , stdout) < 0)) { return EOF; }
	return 0; //͏񂾃oCgł͂Ȃ0ԂB
}
/*--------------------------------------------------------------------------*/
int remove(const char* filename) {
	if(pceFileDelete(filename) != 0) { return -1; }
	return 0;
}
/*--------------------------------------------------------------------------*/
int feof(FILE* stream) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	return io->flag & IO_EOF;
}
/*--------------------------------------------------------------------------*/
int ferror(FILE* stream) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	return io->flag & IO_ERR;
}
/*--------------------------------------------------------------------------*/
void clearerr(FILE* stream) {
	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	io->flag &= ~(IO_EOF|IO_ERR);
}
/*--------------------------------------------------------------------------*/
void perror(const char* string) {
	//uMSDN Cu Microsoft Visual Studio 6.0 - perrorv:
	//ŏstring\AɃRAɃG[NŌ̃CuĂяõVXeG[bZ[WƑAŌɉso͂܂B
	//stringNULL|C^܂NULLւ̃|C^ɂƁAperror֐̓VXeG[bZ[W\܂B
	if(string && string[0]) { fprintf(stderr, "%s: ", string); }
	fprintf(stderr, "%s\n", strerror(errno));
}
/*--------------------------------------------------------------------------*/
//{{2015/08/02폜:fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂BWin32vWFNgłAdoprnt()𗘗pprintf()𗘗płBclipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
//int fprintf(FILE* stream, const char* format, ...) {
//	int retval;
//	va_list argptr;
//	va_start(argptr, format);
//	retval = vfprintf(stream, format, argptr);
//	va_end(argptr);
//	return retval;
//}
///*--------------------------------------------------------------------------*/
//int printf(const char* format, ...) {
//	int retval;
//	va_list argptr;
//	va_start(argptr, format);
//	retval = vprintf(format, argptr);
//	va_end(argptr);
//	return retval;
//}
///*--------------------------------------------------------------------------*/
//int vfprintf(FILE* stream, const char* format, va_list argptr) {
//   //{{2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
//   //	//WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B
//   //	return fwrite(_def_vbuff, 1, vsprintf(_def_vbuff, format, argptr), stream);
//   //2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
//	char* s;
//	int n = vasprintf(&s, format, argptr);
//	if(n < 0) { DIE(); }
//	n = fwrite(s, 1, n, stream);
//	free(s);
//	return n;
//   //}}2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
//}
///*--------------------------------------------------------------------------*/
//int vprintf(const char* format, va_list argptr) {
//	return vfprintf(stdout, format, argptr);
//}
//}}2015/08/02폜:fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂BWin32vWFNgłAdoprnt()𗘗pprintf()𗘗płBclipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
/****************************************************************************
 *	WbCu̕⏕ -> clippce.h					//{{2015/01/07ǋL:fileno(),isatty()̐錾Aclippce.hinclude/stdio.hֈړ܂Bclipio.cɂ܂Bisatty()͖{io.hunistd.hŐ錾ׂȂ̂łAP/ECEɂio.hunistd.ĥinclude/stdio.hŐ錾邱Ƃɂ܂B}}
 ****************************************************************************/
int fileno(FILE* stream) {
    //{{2015/03/14C:fileno()ɂ͕Wo͂w\Ƃ邽߂io_file()g킸IȃLXgs悤ɏCB
    //	IO* io = io_file(stream);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
    //2015/03/14C:fileno()ɂ͕Wo͂w\Ƃ邽߂io_file()g킸IȃLXgs悤ɏCB
	IO* io = ((IO*)stream ? /*GCCg@\*/ : (IO*)-1);	//Xg[|C^t@CI/O\̃|C^ɃLXgBWo͂w\Ƃ邽߂io_file()͎gpȂBNULL|C^(-1)ɕϊĂBŕϊĂȂƂ̌̌ios[]NULLGgɈvĂ܂B
    //}}2015/03/14C:fileno()ɂ͕Wo͂w\Ƃ邽߂io_file()g킸IȃLXgs悤ɏCB
	int fd;
	//t@CI/O\̃|C^zāc
	for(fd = 0; fd < MAX_IO; fd++) {
		//w肳ꂽXg[Ɉvt@CLqqAw肳ꂽXg[Ɉvt@CLqqԂ܂B
		if(ios[fd] == io) { return fd; }
	}
	//w肳ꂽXg[Ɉvt@CLqqȂ΁c
	DIE();/*return -1;*/	//AvP[ṼoỎ\̂ŁAG[lԂ̂ł͂ȂG[~鎖ɂB
}
/*--------------------------------------------------------------------------*/
int isatty(int fd) {
	//w肳ꂽt@CLqqA[QƂt@CLqqȂ΁A1Ԃ܂B
	//łȂ΁A0Ԃ܂B
//{{2012/10/30:R[h(͂Ȃ)Ȃ悤AύX܂B
//	return (fd == STDIN_FILENO ) ||	//W
//	       (fd == STDOUT_FILENO) ||	//Wo
//	       (fd == STDERR_FILENO);	//WG[o
//2012/10/30:R[h(͂Ȃ)Ȃ悤AύX܂B
	return (unsigned)fd <= STDERR_FILENO;	//W,Wo,WG[o
//}}2012/10/30:R[h(͂Ȃ)Ȃ悤AύX܂B
}
/****************************************************************************
 *	WbCu̕⏕ -> include/sys/stat.h
 ****************************************************************************/
int stat(const char* path, struct stat* buf) {
	FILEACC fa;
	if(pceFileOpen(&fa, path, FOMD_RD)) {
		errno = ENOENT;	//No such file or directory
		return -1;	//stat()̓t@C̑݃`FbNɗp鎖AsĂAvP[VoỎ\͒Ⴂ̂ŁADIE()ɃG[lԂ̂ǂ낤B
	}
	memset(buf, 0, sizeof(struct stat));
	buf->st_mode    = S_IFREG|S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH;
	buf->st_nlink   = 1;
	buf->st_size    = fa.fsize;
	buf->st_blksize = BLOCKSIZE;			/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/
	buf->st_blocks  = (buf->st_size + 511) >> 9;	/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/
	pceFileClose(&fa);
	return 0;
}
/*--------------------------------------------------------------------------*/
int fstat(int fd, struct stat* buf) {
	memset(buf, 0, sizeof(struct stat));
	buf->st_nlink   = 1;
	buf->st_blksize = BLOCKSIZE;				/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/	//Wo͂st_blksizei[dl̂悤łB(WebLinux̏)
	if(isatty(fd)) {	//Wo͂Ȃ΁c
		buf->st_mode    = S_IFCHR;
	//sv	buf->st_blocks  = (buf->st_size + 511) >> 9;	/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/	//Wo͂st_blocks=0BɃNAς݂Ȃ̂ŖIȊi[͕svłB
	} else {		//ʏt@CȂ΁c
		IO* io = io_file((FILE*)ios[fd]);	//sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
		buf->st_mode    = S_IFREG|S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH;
		buf->st_size    = io->fa.fsize;
		buf->st_blocks  = (buf->st_size + 511) >> 9;	/*{{2014/09/07ύX:stat.st_blksize,stat.st_blocksǉ܂B}}*/
	}
	return 0;
}
/****************************************************************************
 *	WbCu̕⏕ -> include/sys/statvfs.h
 ****************************************************************************/
int statvfs(const char* path, struct statvfs* buf) {
	memset(buf, 0, sizeof(struct statvfs));
	{
		const pffsMASTERBLOCK* msb = (pffsMASTERBLOCK*)pceSystemGetInfo()->pffs_top;
		{
			const DIRECTORY *pdir = msb->dir, *pdir_end = msb->dir + MAXDIR;
			do {
				if((pdir->name[0] ==  0) ||	//\usr\PIECE\sysdev\pcekn\file.c
				   (pdir->name[0] == -1)) {	//Search() Q
					buf->f_ffree++;
				}
			} while(++pdir < pdir_end);
		}
		{
			const FAT *pfat = msb->fat, *pfat_end = msb->fat + MAXFAT;
			do {
				switch(pfat->chain) {
				case FAT_INVALID:		//ZN^(512KBł2MBł̍)
				case FAT_SYSTEM:		//}X^[ubN
					/** no job **/
					break;
				case FAT_FREE:			//󂫃ZN^
					buf->f_bfree++;
					/*FALLTHRU*/
				case FAT_END:			//`FC̏I[
				default:			//`FC̓r
					buf->f_blocks++;
					break;
				}
			} while(++pfat < pfat_end);
		}
	}
	buf->f_bsize	= BLOCKSIZE;
	buf->f_frsize	= BLOCKSIZE;
//	buf->f_blocks	= ̏Őݒς
//	buf->f_bfree	= ̏Őݒς
	buf->f_bavail	= buf->f_bfree;
	buf->f_files	= MAXDIR;
//	buf->f_ffree	= ̏Őݒς
	buf->f_favail	= buf->f_ffree;
//sv	buf->f_fsid	= 0;
//sv	buf->f_flag	= 0;
	buf->f_namemax	= FIELD_SIZEOF(DIRECTORY, name) - 1;
	return 0;
}
/*--------------------------------------------------------------------------*/
int fstatvfs(int fd, struct statvfs* buf) {
	return statvfs("/", buf);
}
/****************************************************************************
 *	WbCu̕⏕ -> include/stdio.h
 ****************************************************************************/
//{{2015/03/13폜:clipdfrg.cύXĐÕZN^тłȂĂo悤ɂ̂ł̒ӎ͕svɂȂ܂Btruncate()ftruncate()file_defrag()𕹗pĂSłB
////dv
////truncate()ftruncate()gĐLt@ĆAFATCAEgȉ̏ɔ\L܂B@@@@@@@@@@@@
////clipdfrg.cdefrag_sub()ˁwg̃`FCɊ܂܂ĂꍇA͌ł͂łBiO͐ς݂̂͂jx
////truncate()ftruncate()gĐLt@Cɑ΂ẮAfile_defrag()gpȂ悤ɂĉB@@@@@@@@@@@@
////
//}}2015/03/13폜:clipdfrg.cύXĐÕZN^тłȂĂo悤ɂ̂ł̒ӎ͕svɂȂ܂Btruncate()ftruncate()file_defrag()𕹗pĂSłB
//uLinux Programmer's Manual - TRUNCATEv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man2/truncate.2.html):
//
//truncate()pathŎw肳t@CAftruncate()fdŎQƂt@CAlengthoCg̒ɂȂ悤ɉA͐؂l߂B
//؂l߂Õt@Clength蒷΁AlengthoCgz镔̃f[^͎B
//؂l߂Õt@ClengthZ΁ALB
//Lꂽǂ񂾏ꍇ̓koCg('\0')̗񂪕ԂB							ł͂̏ȗBL͕slƂȂB
//t@CItZbg͕ύXȂB
//傫ύXƁAt@Cst_ctimest_mtimetB[h(ꂼŏIԕύXAŏIC)XVB	P/ECEł͊֌WB
//܂Aset-user-IDset-group-ID̋rbgNA邩ȂB						P/ECEł͊֌WB
//ftruncate()̏ꍇAt@C͏ݗpɊJĂȂ΂ȂȂB							ł͂̌ȗBǂݍݗpɊJĂĂ삷B
//truncate()̏ꍇAt@C͏݉\łȂ΂ȂȂB							P/ECEł͊֌WB
//Ԃl
//ꍇ0ԂB
//G[̏ꍇ-1ԂAerrnoK؂ɐݒ肳B									̓G[ꍇ̓G[~ԂȂB
#if 0 //utXNb`Łv
int truncate(const char* path, /*off_t*/long length) {
	const SYSTEMINFO* const sip = pceSystemGetInfo();
	pffsMASTERBLOCK *msb, *pmb;
	DIRECTORY* pdir;
	int i, sct, sctcnt, fatcnt;
	unsigned short* psct;
	//t@C󕶎łȂ0łȂŏɌĂBŏɌĂł̌̏炩PɂłB
	if((*path == 0) || (length < 0)) { DIE(); }
	//ǗubÑRs[쐬Bȉ̏͂̃Rs[ύXASĐŃtbV̊ǗubN֏߂B
	msb = (pffsMASTERBLOCK*)sip->pffs_top;
	pmb = malloc(BLOCKSIZE);
	if(!pmb) { DIE(); }	//s
	memcpy(pmb, msb, BLOCKSIZE);
	//w肳ꂽt@C̃fBNgGgB
	for(i = 0; i < MAXDIR; i++) {
		pdir = &pmb->dir[i];
		if(//(*pdir->name != '\x00') &&		//0x00œhԂꂽGgBŏpath󕶎ŖmFς݂Ȃ̂ŋRv댯͖ŌKv͖B
		   //(*pdir->name != '\xFF') &&		//0xFFœhԂꂽGgB'\xFF'x26pathnꂽv\L邪Ӑ}IɍsȂL蓾Ȃ̂ŌȂĂǂ낤B
		   !strcmp(pdir->name, path)) { break; }
	}
	if(i == MAXDIR) { DIE(); }	//w肳ꂽt@C̃fBNgGg݂ȂB
	//ύXÕTCYƕύX̃TCYقȂȂ΁c
	if(pdir->size != length) {
		//ύX̃TCYi[B
		pdir->size = length;
		//ύX̕KvZN^߂B
		sctcnt = (length + (BLOCKSIZE - 1)) / BLOCKSIZE;
		//FAT̐߂Bȉ̂悤ɂȂ͂ł:
		//512KBP/ECE (0xC80000-0xC28000)/0x1000= 88
		//  2MBP/ECE (0xE00000-0xC28000)/0x1000=472
		fatcnt = (sip->pffs_end - sip->pffs_top) / BLOCKSIZE;
		//fBNgGgFAT`FC̃tB[hǂāc
		psct = &pdir->chain;
		while(--sctcnt >= 0) {	//KvZN^Ȃ甲BKvZN^=0(TCY=0)ȂΈx[vʂȂB
			//̃ZN^ԍ擾B
			sct = *psct;
			//̃ZN^ԍ΁c
			if(sct == FAT_END) {	//ύXOFAT`FC̏I[,,ύXFAT`FC
				//FATGgTB
				for(sct = 0; sct < fatcnt; sct++) {
					if(pmb->fat[sct].chain == FAT_FREE) { break; }
				}
				if(sct == fatcnt) { DIE(); }	//FATGgB
				//FATGg󂫂łȂȂ}[NB̃ZN^ύXFAT`FC̈ꎞIȏI[ƂȂBɉꍇ͎̃[v̂̉̏ŏ㏑B
				pmb->fat[sct].chain = FAT_END;
				//ύXFAT`FCB
				*psct = sct;
			}
			//FAT`FC̃tB[hւ̃|C^擾B
			psct = &pmb->fat[sct].chain;
		}
		//ŌFAT`FC̎̃ZN^ԍoĂB
		sct = *psct;
		//ύXFAT`FCI[BύXύXOFAT`FC̕Zꍇ͊(*psct==FAT_END)ɂȂĂ̂Ń_~[ƂȂB
		*psct = FAT_END;
		//ύXFAT`FCύXOFAT`FC̕Ȃ΁c
		while(sct != FAT_END) {	//̔́u!(ύXύXOFAT`FC̕Z)vBڈȍ~̔́u!(ύXOFAT`FC̏I[)vB
			//FAT`FC̃tB[hւ̃|C^擾B
			psct = &pmb->fat[sct].chain;
			//̃ZN^ԍoĂB
			sct = *psct;
			//̃ZN^JB
			*psct = FAT_FREE;
		}
		//ύXǗubÑRs[AtbV̊ǗubN֏߂B
		i = turbo(0);	//pceFlashErase/Write()48MHzł͓삵Ȃ̂ŁAmɒʏ탂[hɂĂB
		if(pceFlashErase(msb) || pceFlashWrite(msb, pmb, BLOCKSIZE)) { DIE(); }
		turbo(i);	//̃Xs[hɖ߂B
		//'݊JĂt@CI/O\̂ɂf鏈'sB
		//fwrite()fflush()oRŌĂяopceFileWriteSct()Aio->fa.fsizeio->fa.chainQƂ̂ŁȀ͕K{łB	dv
		for(i = 0; i < MAX_IO; i++) {
			IO* io = ios[i];
			if(io && !strcmp(io->filename, pdir->name)) {
				io->fa.fsize = pdir->size;
				io->fa.chain = pdir->chain;
				//t@C𕡐JĂ\L̂ŏpB(HƂ͎v)
			}
		}
	}
	//ǗubÑRs[JB
	free(pmb);
	return 0;
}
#else //upceFileCreate()pŁv
// * Sat Mar 14 21:29:01 JST 2015 Naoyuki Sawa
// - truncate()́upceFileCreate()pŁv쐬܂B
//   utXNb`ŁvɋCt̂łAeقƂpceFileCreate()ƓŁApceFileCreate()𗘗pčR[hTCYߖł܂B
// - utXNb`ŁvƁupceFileCreate()pŁv̂ǂgpĂ\܂B݂̂ƂupceFileCreate()pŁvIĂɂ܂B
//   utXNb`Łv쌟؍ς݂łB̎QlƂāAutXNb`ŁṽR[hcĂɂ܂B
int truncate(const char* path, /*off_t*/long length) {
	FILEACC fa;
	int i;
	if(pceFileOpen(&fa, path, FOMD_WR) ||			//1. t@C݂鎖mFBtruncate()݂͑Ȃt@CLk鎖͂łȂdlłBȂpceFileCreate()Ăяoƃt@C݂Ȃꍇɍ쐬Ă܂̂truncate()̎dlɔĂ܂B
	   pceFileClose(&fa) ||					//2. 1.ŊJt@CɕB
	   pceFileCreate(path, length) ||			//3. t@CLkB
	   pceFileOpen(&fa, path, FOMD_WR)) { return -1; }	//4. t@CLk̏擾邽߂Ƀt@CJB
	//'݊JĂt@CI/O\̂ɂf鏈'sB
	//fwrite()fflush()oRŌĂяopceFileWriteSct()Aio->fa.fsizeio->fa.chainQƂ̂ŁȀ͕K{łB	dv
	for(i = 0; i < MAX_IO; i++) {
		IO* io = ios[i];
//{{2018/05/24ύX:UFEɑΉ܂B
//		if(io && !strcmp(io->filename, path)) {
//2018/05/24ύX:UFEɑΉ܂B
		if(io && (io->fa.valid == fa.valid) && !strcmp(io->filename, path)) {
//}}2018/05/24ύX:UFEɑΉ܂B
			io->fa.fsize = fa.fsize;
//{{2018/05/24ǉ:UFEɑΉ܂B
			if(io->fa.valid == FILEACC_UFE) { continue; }	//UFȄꍇ́AchainbposÄPC̃t@C|C^(FILE*)Ă̂ŁAchainĂ͂ȂB
//}}2018/05/24ǉ:UFEɑΉ܂B
			io->fa.chain = fa.chain;
			//t@C𕡐JĂ\L̂ŏpB(HƂ͎v)
		}
	}
	return pceFileClose(&fa);				//5. 4.ŊJt@CB
}
#endif//
/*--------------------------------------------------------------------------*/
int ftruncate(int fd, /*off_t*/long length) {
	IO* io = io_file((FILE*)ios[fd]);	//Wo,,sȃt@CLqqw肳ꂽꍇ͂̒ŃG[~B
	return truncate(io->filename, length);
}
/****************************************************************************
 *	WG[o,W
 ****************************************************************************/
//UCS_RXDONEUCS_TXDONÉApceUSBCOMGetStat()ĂԂƃNAĂ܂̂ŁA~ς邽߂̕ϐKvłB
//ʂ̖ړIŌĂяopceUSBCOMGetStat()ɂāAUCS_RXDONEUCS_TXDONENAĂ܂̂邽߁A
//pceUSBCOMGetStat()ĂяoтɁAucsϐUCS_RX*UCS_TX*~ς悤ɂB
static int ucs;	//UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~
/*--------------------------------------------------------------------------*/
//void stderr_open() {
//	USBCOMINFO uci = { "stderr" };
//	//WG[o͂J܂B
//	pceUSBCOMSetup(&uci);
//	//B{^ĂAWG[o̓j^̐ڑ҂܂B
//	if(pcePadGetDirect() & PAD_B) {
//		unsigned char* old_vbuff;
//		pceLCDDispStop();
//		old_vbuff = pceLCDSetBuffer(_def_vbuff);
//		pceLCDDispStart();
//		pceFontSetType(0x80);
//		pceFontSetTxColor(3);
//		pceFontSetBkColor(0);
//		pceFontSetPos(0, (DISP_Y - 10 * 5) / 2);
//		//             OPQRSTUVWXOPQ
//		pceFontPutStr(" +----------------------+\n"
//		              " |WG[o̓j^|\n"
//		              " | ڑ҂Ă܂c |\n"
//		              " |(`{^ŃLZ)|\n"
//		              " +----------------------+");
//		pceLCDTrans();
//		while(pcePadGetDirect() & PAD_A) { /*J҂*/ }
//		for(;;) {
//			if(pceUSBCOMGetStat() & UCS_PCSTAT) { break; } //ڑ
//			if(pcePadGetDirect() & PAD_A) { break; } //LZ
//		}
//		while(pcePadGetDirect() & PAD_A) { /*J҂*/ }
//		pceLCDSetBuffer(old_vbuff);
//		stderr_write("ڑ\n", 9); //WG[o̓j^ɕ\
//	}
//}
//2003/11/22 stderr_open()̓AvP[V疾IɌĂԂ悤ɂ̂ŁAstderr_open()Ă΂ꂽꍇ͏ɏo̓j^̐ڑ҂悤ɕύX܂B
void stderr_open(int timeout) {
	USBCOMINFO uci = { "stderr" };
	unsigned char* old_vbuff;
	int T0, T1;
	//WG[o͂J܂B
	pceUSBCOMSetup(&uci);
	//WG[o̓j^̐ڑ҂B
//sv	pceLCDDispStop(); {{2005/06/26 Naoyuki Sawa svȂ̂ō폜܂}}
	old_vbuff = pceLCDSetBuffer(_def_vbuff);
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
	pceFontSetType(0x80);
	pceFontSetTxColor(3);
	pceFontSetBkColor(0);
	pceFontSetPos(0, (DISP_Y - 10 * 5) / 2);
	//             OPQRSTUVWXOPQ
	pceFontPutStr(" +----------------------+\n"
	              " |WG[o̓j^|\n"
	              " | ڑ҂Ă܂c |\n"
	              " |(`{^ŃLZ)|\n"
	              " +----------------------+");
	pceLCDTrans();
	while(pcePadGetDirect() & PAD_A) { /*J҂*/ }
	T0 = pceTimerGetCount();
	for(;;) {
		if(pceUSBCOMGetStat() & UCS_PCSTAT) { break; } //ڑ
		if(pcePadGetDirect() & PAD_A) { break; } //LZ
		if(timeout >= 0) {
			T1 = timeout * 1000 - (pceTimerGetCount() - T0);
			if(T1 <= 0) { break; } //^CAEg
			pceFontSetPos((DISP_X - 5 * 9) / 2, DISP_Y - 16);
			//             012345678
			pceFontPrintf("%3db", (T1 + 999) / 1000);
			pceLCDTrans();
		}
	}
	while(pcePadGetDirect() & PAD_A) { /*J҂*/ }
	pceLCDSetBuffer(old_vbuff);
//	stderr_write("ڑ\n", 9); //WG[o̓j^ɕ\(LZ/dev/nul)	{{2014/03/13폜:ڑ̃bZ[W͂̎זɂȂ鎖L邽ߍ폜܂B}}
	//W͂́A̎Mv𔭍s܂B
	stdin_read(NULL, 0);
}
/*--------------------------------------------------------------------------*/
void stderr_close() {
	USBCOMINFO uci = { "" };
	//WG[o͂܂B
	// - PpceUSBCOMStop()Ă񂾂ł́AUSBCOMؒfł܂B
	//   PCƂ̐ڑmĂꍇApceUSBCOMStop()͐ؒfsȂłB
	//   ܂AVOl`NA܂B(ȏABIOS 1.18ŊmF)
	// - ̖ɂ́ApceUSBCOMSetup()gUSBCOMؒf܂B
	//   pceUSBCOMSetup()Ȃ΁APC̐ڑtONÂŁA
	//   pceUSBCOMSetup()gāF
	//   mystat(P/ECE̐ڑtO) -> 1
	//   pcstat(PC̐ڑtO)    -> 0
	//   VOl`                  -> ""
	//   ƂĂA炽߂pceUSBCOMStop()ĂŁF
	//   mystat(P/ECE̐ڑtO) -> 0
	//   Ƃ܂B
	pceUSBCOMSetup(&uci);
	pceUSBCOMStop();
	ucs = 0;	//~ϕϐNA
}
/*--------------------------------------------------------------------------*/
void stderr_write(const void* ptr, int len) {
	//0oCgőMv𔭍sƁA΂UCS_TXDONEȂ̂ŁA(usbcom.c: txsub() Q)
	//炩ߏOĂ܂B
	if(len <= 0) { return; }
	//PCƂ̐ڑmĂc
	// - PISTAT1łȂPCSTAT1ɂȂ܂B(usbcom.c: usbcom() case13: (USBCOM Open) Q)
	//   PCSTAT1łPISTAT0ɖ߂܂B(usbcom.c: pceUSBCOMStop() Q)
	//   ]āAPCSTAT1ȂPISTATK1łBPISTATKv͂܂B
	ucs = pceUSBCOMGetStat() | (ucs & (UCS_RXSTAT|UCS_TXSTAT));	//UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~
	if(ucs & UCS_PCSTAT) {
		//Mv𔭍s܂B
		pceUSBCOMStartTx(ptr, len);
		ucs &= ~UCS_TXSTAT;	//UCS_TX*NA
		//M܂ő҂܂B
		for(;;) {
			ucs = pceUSBCOMGetStat() | (ucs & (UCS_RXSTAT|UCS_TXSTAT));	//UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~
			if(!(ucs & UCS_PCSTAT)) { break; }	//PCƂ̐ڑ؂ꂽB
			if(  ucs & UCS_TXDONE ) { break; }	//MB
		}
	}
}
/*--------------------------------------------------------------------------*/
int stdin_read(void* _buf, int bufsize) {
#define STDIN_RXSIZE (127/**/ + 1/*nul*/)
	static char*   rxbuf/*[STDIN_RXSIZE]*/;
	static char* keepbuf/*[STDIN_RXSIZE]*/;
	static int i_keepbuf;
	//
	char* buf = _buf;
	int i_buf = 0, c;
	//PCƂ̐ڑmĂc
	// - PISTAT1łȂPCSTAT1ɂȂ܂B(usbcom.c: usbcom() case13: (USBCOM Open) Q)
	//   PCSTAT1łPISTAT0ɖ߂܂B(usbcom.c: pceUSBCOMStop() Q)
	//   ]āAPCSTAT1ȂPISTATK1łBPISTATKv͂܂B
	ucs = pceUSBCOMGetStat() | (ucs & (UCS_RXSTAT|UCS_TXSTAT));	//UCS_PCSTATUCS_PISTAT͑fAUCS_RX*UCS_TX*͒~
//{{2017/07/21폜:stdin_read()ɂāAPCUSBCOMؒfOɑMf[^AƂ肱ڂȂ悤ɏC܂B
//	if(ucs & UCS_PCSTAT) {
//}}2017/07/21폜:stdin_read()ɂāAPCUSBCOMؒfOɑMf[^AƂ肱ڂȂ悤ɏC܂B
		//ɎMobt@ƕێobt@mۂ܂B΁Astdin_read()Ă΂ȂΗ]ȃ܂B
		if(!rxbuf) {
			rxbuf = calloc(2, STDIN_RXSIZE);
			if(!rxbuf) { DIE(); }	//s
			keepbuf = rxbuf + STDIN_RXSIZE;
		}
		//݃|C^A݃obt@̃oCgɒB܂Łc
		while(i_buf < bufsize) {
			//ێobt@̕A܂cĂc
			if((c = keepbuf[i_keepbuf])) {
				//ێobt@ǂݏoA݃obt@Ɋi[܂B
				buf[i_buf++] = c;
				//ێobt@̓ǂݏoʒui߂܂B
				i_keepbuf++;
			//ێobt@̕AcĂȂ΁c
			} else {
				//O̎MvĂȂ΁c
				if(!(ucs & UCS_RXDONE)) { break; }	//MvsȂ΁Ảŏ̎Mv𔭍sB
				//O̎MvĂc
				ucs &= ~UCS_RXSTAT;	//UCS_RX*NA			//̉Ŏ̎Mv𔭍sB
				//Meێobt@ɕێ܂BMobt@́Ǎ̎MvsŔj󂳂邩łB
				strcpy(keepbuf, rxbuf);
				//ێobt@̓ǂݏoʒuA擪ɖ߂܂B
				i_keepbuf = 0;
			}
		}
//{{2017/07/21ǉ:stdin_read()ɂāAPCUSBCOMؒfOɑMf[^AƂ肱ڂȂ悤ɏC܂B
	if(ucs & UCS_PCSTAT) {
//}}2017/07/21ǉ:stdin_read()ɂāAPCUSBCOMؒfOɑMf[^AƂ肱ڂȂ悤ɏC܂B
		//MvsĂȂ΁c
		if(!(ucs & (UCS_RXWAIT|UCS_RXING))) { //Mҋ@,,M
			//̂߂ɁAMobt@ւ̎Mv𔭍sĂB
			pceUSBCOMStartRx(rxbuf, STDIN_RXSIZE - 1/*nul*/);
		}
	}
	//݃obt@Ɋi[oCgԂ܂B
	return i_buf;
#undef  STDIN_RXSIZE
}
