/*	
 *	cliphes.h
 *
 *	P/ECE HES Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#ifndef __CLIP_HES_H__
#define __CLIP_HES_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	HESt@Cdl
 ****************************************************************************/

/* * HESHEADER̃tB[h͓K؂ɃACgĂ܂B
 *   (Ahes_init()ĂяoHESHEADER擪AhX4oCgACgmۂĂƉ)
 *
 * * HESCHUNKꍇAsHESCHUNKdata_size4̔{łȂꍇɁA
 *   㑱HESCHUNKwb_̃tB[h͓K؂ɃACgĂȂ\܂B
 *   K؂ɃACgĂȂtB[h𒼐ړǂƂƁAAhXsO܂B
 *   AhXsOh߂ɁAHESBYTE/HESHALF/HESWORD}NgătB[hǂłB
 *
 * * Oq̂悤ɁAHESHEADER̃tB[h͓K؂ɃACgĂ̂ŁA
 *   HESBYTE/HESHALF/HESWORD}NgKv͂Ȃ̂łAvO̓̂߂ɁA
 *   HESHEADER̃tB[hǂݍ݂ɂHESBYTE/HESHALF/HESWORD}NgƂɂ܂B
 *
 * * ۂɂHESCHUNK݂邱Ƃ͋HȂ悤ŁA茳HESt@Cׂł
 *   SĒPHESCHUNK܂ł܂B
 *   炭قƂǑSHESt@CPHESCHUNK܂łȂ̂ł͂ȂƎv܂B
 *   ۂɂ͏q̂悤ȃACg̔z͂ȂĂ܂ȂmȂ̂łǁA
 *   dl͈ꉞHESCHUNK݂̂ŁA΍̂ĂƂɂ܂B
 */
#define HESBYTE(v)	(((unsigned char*)&(v))[0])
#define HESHALF(v)	(((unsigned char*)&(v))[0] | ((unsigned char*)&(v))[1] << 8)
#define HESWORD(v)	(((unsigned char*)&(v))[0] | ((unsigned char*)&(v))[1] << 8 | ((unsigned char*)&(v))[2] << 16 | ((unsigned char*)&(v))[3] << 24)

/* HESt@Cwb_ */
typedef struct _HESHEADER {
	         char  magic_id[4];	/* +0x00,4: magic-id 'HESM'                   */
	unsigned char  version;		/* +0x04,1: VERSION (0)                       */
	unsigned char  start_song;	/* +0x05,1: start song                        */
	unsigned short request_address;	/* +0x06,2: request address (logical address) */
	unsigned char  initial_mpr[8];	/* +0x08,1: initial MPR0 ($FF)                */
					/* +0x09,1: initial MPR1 ($F8)                */
					/* +0x0a,1: initial MPR2                      */
					/* +0x0b,1: initial MPR3                      */
					/* +0x0c,1: initial MPR4                      */
					/* +0x0d,1: initial MPR5                      */
					/* +0x0e,1: initial MPR6                      */
					/* +0x0f,1: initial MPR7 ($00)                */
} HESHEADER;				/* =0x10 */
					/* ̌t@CI[܂ŁA0ȏHESCHUNK܂B */

/* HES`Nwb_ */
typedef struct _HESCHUNK {
	char     sub_id[4];		/* +0x00,4: sub-id 'DATA' */
	unsigned data_size;		/* +0x04,4: data size */
	unsigned load_address;		/* +0x08,4: load address (physical address) */
	unsigned reserved;		/* +0x0c,4: reserved (0) */
} HESCHUNK;				/* =0x10 */
					/* ̌ɁAdata_sizeoCg̃f[^{̂܂B */

/****************************************************************************
 *	HEShCo
 ****************************************************************************/

#define HESBUFLEN		320				/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

#define HES_CPU_CLOCK		(NTSC_COLOR_SUBCARRIER * 2)	/* =7.16MHz CPUNbN ({x1/x2ςłAx2ŒƂ܂) */
#define HES_PSG_CLOCK		(NTSC_COLOR_SUBCARRIER * 1)	/* =3.58MHz PSG̓NbN */

#define HES_VBLANK_PERIOD	(HES_CPU_CLOCK / 60)		/* VBLANK荞݊Ԋu[CPUTCN] */

/*
 *	HEShCo
 */
typedef struct _HESDRIVER {
	/*{{HuC6280RAREADO֐g߁ACAEgŒ*/
	HUC6280 huc6280;		/* HuC6280-CPU */
	unsigned char mem[0x10000];	/* C */
	/*}}HuC6280RAREADO֐g߁ACAEgŒ*/
	HUC6280PSG psg;			/* HuC6280-PSG */
	//
	const void* data;		/* hes_init()ɓnꂽHESf[^̐擪AhX */
	int size;			/* hes_init()ɓnꂽHESf[^̃oCg     */
	//
	int vdc_regsel;			/* VDC݃WX^I */
	int vblank_enable;		/* VBLANK荞ݗL */
	int vblank_progress;		/* VBLANKisJE^ */
	//
	int timer_start;		/* ^C}X^[g */
	int timer_period;		/* ^C}[hl */
	int timer_progress;		/* ^C}isJE^ */
	//
	int timer_limit;		/* ^C}荞݃~b^[1ɂȂ܂B   */
					/* hes_huc6280_out()̃RgQƂĂB */
} HESDRIVER;

/*
 *	HuC6280G~[VpO֐
 */
unsigned char hes_huc6280_read(HUC6280* huc6280, unsigned short addr); /* eXgp */
void hes_huc6280_write(HUC6280* huc6280, unsigned short addr, unsigned char data);
void hes_huc6280_out(HUC6280* huc6280, unsigned short addr, unsigned char data);
void hes_huc6280_mprset(HUC6280* huc6280, int addr/*0`7*/, unsigned char data);
void hes_huc6280_vdcout(HUC6280* huc6280, int addr/*0`2*/, unsigned char data);

/*
 *	HEShCo֐
 */
int hes_init(HESDRIVER* hes, const void* data, int size, int i_song);
int hes_mix(HESDRIVER* hes, short wbuff[/*HESBUFLEN*/]);
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//int hes_stream_callback(short* wbuff, int param);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
int hes_stream_callback(short* wbuff, intptr_t param);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* HESt@C̍ĐJn܂B
 * [in]
 *	data		HESf[^̐擪AhXB
 *	size		HESf[^̃oCgB
 *	i_song		gbNԍB(0`)
 *			-1w肷ƁAHESt@C̊JnȔԍƂȂ܂B
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKhes_stop()ĂŁAxN^𕜌ĂB
 */
int hes_play(const void* data, int size, int i_song);

/* HESt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void hes_stop();

/* ^C}荞݃~b^[ǂ擾܂B
 * [out]
 *	߂l		ʏ́A0Ԃ܂B
 *			^C}荞݃~b^[A0ȊO̒lԂ܂B
 * [note]
 *	* t~́A0Ԃ܂B
 *	* ڂ́Ahes_huc6280_out()̃RgQƂĂB
 */
int hes_timer_limit();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_HES_H__*/
