/*	
 *	cliphes.h
 *
 *	P/ECE HES Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

//̃V{`ƁAHuC6280 READO֐CXg[āA
//READANZX𒲂ׂ܂BeXgpłBʏ͒`ȂłB
//#define HES_DEBUG

/* MPR0=$FF(I/O area)ƉAI/O area̖16oCg󂫂Ɖ肵āA
 * I/O area̖16oCgprɗp܂B
 */
#define PLAYER_ADDR	0x1ff0	/* vC[[`쐬AhX */
#define HALT_ADDR	0x1fff	/* ɔCӂ̒lނHALT */

/****************************************************************************
 *	HuC6280G~[VpO֐
 ****************************************************************************/

#ifdef HES_DEBUG
unsigned char
hes_huc6280_read(HUC6280* huc6280, unsigned short addr) /* eXgp */
{
	HESDRIVER* hes = (HESDRIVER*)huc6280;
	unsigned char* mem = hes->mem;

	if(addr < PLAYER_ADDR) {
		TRACE("READ %04x\n", addr);
	}

	return mem[addr];
}
#endif /*HES_DEBUG*/

void
hes_huc6280_out(HUC6280* huc6280, unsigned short addr, unsigned char data)
{
	HESDRIVER* hes = (HESDRIVER*)huc6280;
	unsigned char* mem = hes->mem;
	//
	int addr_hi = addr >> 8;
	int addr_lo = addr & 0xff;

	/* ܂i[B */
	mem[addr] = data;

	switch(addr_hi) {
	/***** VDC *****/
	case 0x00:
		switch(addr_lo) {
		case 0: /* VDC݃WX^I */
			hes->vdc_regsel = data;
			return;
		case 2: /* VDCWX^(Lo) */
			if(hes->vdc_regsel == 5) {
				hes->vblank_enable = (data >> 3) & 1;
			}
			return;
		//case 3: /* VDCWX^(Hi) */
		//	/* HEStɂ͊֌W܂B */
		//	return;
		}
		return;

	/***** PSG *****/
	case 0x08:
		huc6280psg_write(&hes->psg, addr_lo, data);
		return;

	/***** TIMER *****/
	case 0x0c:
		switch(addr_lo) {
		case 0:	/* ?ppppppp (p:^C}[hl) */
			/* * ^C}̓NbNCPUNbN1024łB
			 * * ۂɂ́A^C}A_[t[(0-1)Ŋ荞݂܂B
			 *   10𔻒肷yȂ̂ŁA炩߃[hl+1Ă܂B
			 */
			data &= 0x7f;
			hes->timer_period = (data + 1) << 10;
			return;
		case 1:	/* ???????e (e:^C}Start/Stop) */
			data &= 1;
			if(hes->timer_start == data) return;	/* ωȂ */
			hes->timer_start = data;	/* ω̒li[ */
			if(hes->timer_start) {	/* Stop => Start */
				hes->timer_progress = hes->timer_period;
			}
			/* ^C}荞݃~b^[s܂B
			 * - PC-Enginẽ^C}荞݂́AőŖ7KHzłB
			 *   7KHz荞݂PSGDirect D/A쓮APCMTEh炷\tg܂B
			 *   (X[p[X^[\W[Ao!!cCr[)
			 * - P/ECȄxł́A7KHz̊荞݂ɂ͕tĂAnOAbv܂B
			 *   ŁA銄荞ݗv͖邱Ƃɂ܂B
			 *   KHz̃^C}荞݂́A炭Direct D/Ap̏sĂȂ̂ŁA
			 *   ^C}荞݂~߂Ă܂ĂAVBLANK荞݂ňꉞt͐is܂B
			 * - ȂA\`S\KHzx̒ᑬ^C}荞݂ŉtsĂ\tg܂B
			 *   (JgPAאlN}T[)
			 *   ̃^C}荞݂~߂Ă܂ƁAʏ̉t܂Ŏ~܂Ă܂ꂪ܂B
			 *   ܂AɃ^C}荞݂𖳎邱Ƃ͂ł܂B
			 * - ŁA3.5KHzȏ̍荞݂𖳎邱Ƃɂ܂B
			 *   ^C}荞ݐݒltimer_progress̊֌ẂÂƂłB(̏ꏊŌvZĂ܂)
			 *	timer_period = (ݒl + 1) << 10 [CPUTCN]
			 *   ݒl0̂ƂőŁA
			 *	7.16MHz / ((0 + 1) << 10) = 7.16MHz / 0x400 = 6.99KHz
			 *   ƂȂ܂Bݒl1̂ƂA
			 *	7.16MHz / ((1 + 1) << 10) = 7.16MHz / 0x800 = 3.50KHz
			 *   ƂȂ܂B́A̓̐ݒ̏ꍇA^C}荞݂𖳎邱Ƃɂ܂B
			 *   ۂɂ́ADirect D/Ag\tg͂قƂǍő6.99KHz荞݂vĂ悤łA
			 *   Ô߁Axݒ3.50KHz荞ݗv邱Ƃɂ܂B
			 * - HESvC[AvP[VA^C}荞݂ꂽǂׂ悤ɁA
			 *   ^C}荞݂𖳎timer_limittB[h1}[N邱Ƃɂ܂B
			 *   hes_timer_limit()AvP[V֐gāÃtB[h̒l擾ł܂B
			 * - ^C}荞݂timer_limit1ɂȂAIɃ^C}~timer_limit0ɖ߂܂B
			 *   ܂A(܂肦܂)x^C}荞݂ėvĎ󂯕tꂽꍇAtimer_limit0ɖ߂܂B
			 *   ܂A^C}荞݂ۂɖĂԂAtimer_limit1ɂȂ܂B
			 */
			if(hes->timer_start) {
				if(hes->timer_period <= (1 + 1) << 10) {
					hes->timer_start = 0;	/* ^C}荞ݖ */
					hes->timer_limit = 1;	/* ~b^[Ƃ}[N */
				} else {
					hes->timer_limit = 0;	/* ~b^[}[NNA */
				}
			} else {
				hes->timer_limit = 0;		/* ~b^[}[NNA */
			}
			return;
		}
		return;

	/***** INTERRUPT *****/
	//case 0x14:
	//	switch(addr_lo) {
	//	case 2:	/* ?????tab (t:^C}荞0:ON/1:OFF, a:IRQ1 0:ON/1:OFF, b:IRQ2 0:ON/1:OFF) */
	//		/* * 荞ݐ[`AڃQƂ܂B
	//		 *   āÃAhXւ݂̏ʂɏKv͂܂B
	//		 */
	//		return;
	//	case 3:	/* ???????? (ݒlɊ֌WȂA^C}X^[g܂BvmF) */
	//		/* * PC-Enginẽ^C}͎^C}ł͂܂B
	//		 *   A_[t[荞ݔAIɃX^[gKv܂B
	//		 *   ̓G~[V̓sŁAX^[g^C}ƂĈƂɂ܂B
	//		 *   āÃAhXւ̏(X^[gw)͖܂B
	//		 * * ۂ̃vOł́ATIMER isr̐擪Ń^C}X^[gĂ悤łB
	//		 *   A悻^C}ƌȂĂ\ȂƎv܂B
	//		 */
	//		return;
	//	}
	//	return;

	/***** HALT (P/ECE HES Driver Ǝdl) *****/
	case (HALT_ADDR >> 8):
		if(addr_lo == (HALT_ADDR & 0xff)) {
			ASSERT(data == 0); /* STZȂ̂0݂̂͂ */
			huc6280->halt = 1;
		}
		return;
	}
}

void
hes_huc6280_mprset(HUC6280* huc6280, int addr/*0`7*/, unsigned char data)
{
	HESDRIVER* hes = (HESDRIVER*)huc6280;
	unsigned char* mem = hes->mem;
	//
	const HESHEADER* header = (HESHEADER*)hes->data;
	const HESCHUNK* chunk = (HESCHUNK*)(header + 1);
	const void* eof = (unsigned char*)hes->data + hes->size;
	//
	unsigned char* dst = &mem[addr << 13];	/* ]GA擪ւ̃|C^ */
	int phy_top =   data      << 13;	/* }bsOAhX擪 */
	int phy_end = ((data + 1) << 13) - 1;	/* }bsOAhXI[ */
	//
	const unsigned char* src;
	int src_top;
	int src_end;
	int ofs;
	int len;

	ASSERT(addr >= 0 && addr <= 7);

	/* fobO₷悤A]GANAĂ܂B({͕Kv܂) */
	memset(dst, 0, (1 << 13) - 1);

	/* HESf[^I[܂ł́ASẴ`N𑖍B */
	while((void*)chunk < (void*)eof) {
		/* DATA`N̂ݏ܂B(ۂɂDATA`NȂ悤łc) */
		if(memcmp(chunk->sub_id, "DATA", 4) == 0) {
			/* ̃`NɊ܂܂f[^̐擪AhX擾܂B */
			src = (unsigned char*)(chunk + 1);

			/* ̃`NɊ܂܂镨AhX͈͂߂܂B */
			src_top = chunk->load_address;
			src_end = chunk->load_address + chunk->data_size - 1;

			/* }bsOAhX͈͂ɂăNbsOB */
			if(src_top < phy_top) {
				src += phy_top - src_top;
				src_top = phy_top;
			}
			if(src_end > phy_end) {
				src_end = phy_end;
			}

			/* }bsOAhX͈͂܂łA]܂B */
			if(src_top <= src_end) {
				ofs = src_top - phy_top;
				len = src_end - src_top + 1;
				memcpy(dst + ofs, src, len);
			}
		}

		/* ̃`NցB */
		chunk = (HESCHUNK*)((unsigned char*)(chunk + 1) + chunk->data_size);
	}
}

void
hes_huc6280_vdcout(HUC6280* huc6280, int addr/*0`2*/, unsigned char data)
{
	ASSERT(addr >= 0 && addr <= 2);

	switch(addr) {
	case 0:	/* VDC Address */
		hes_huc6280_out(huc6280, 0x0000, data);
		break;
	case 1:	/* VDC Data Lo */
		hes_huc6280_out(huc6280, 0x0002, data);
		break;
	case 2:	/* VDC Data Hi */
		hes_huc6280_out(huc6280, 0x0003, data);
		break;
	}
}

/****************************************************************************
 *	HEShCo֐
 ****************************************************************************/

int
hes_init(HESDRIVER* hes, const void* data, int size, int i_song)
{
	HUC6280* huc6280 = &hes->huc6280;
	unsigned char* mem = hes->mem;
	HUC6280PSG* psg = &hes->psg;
	//
	const HESHEADER* header = (HESHEADER*)data;
	//
	int i;

	ASSERT(sizeof(HESHEADER) == 0x10);
	ASSERT(sizeof(HESCHUNK ) == 0x10);

	/* ܂NA܂B */
	memset(hes, 0, sizeof(HESDRIVER));

	/* HESf[^AhXAHESf[^TCYi[B */
	hes->data = data;
	hes->size = size;

	/* VOl`B */
	if(memcmp(header->magic_id, "HESM", 4) != 0) return -1;

	/* tgbNԍ-1w肳ĂÅJngbNԍgpB */
	if(i_song < 0) i_song = HESBYTE(header->start_song);

	/* CPUZbgB */
#ifdef HES_DEBUG
	huc6280_reset(huc6280, hes_huc6280_read, hes_huc6280_write, hes_huc6280_mprset, hes_huc6280_vdcout); /* eXgp */
#else /*HES_DEBUG*/
	huc6280_reset(huc6280, NULL, hes_huc6280_write, hes_huc6280_mprset, hes_huc6280_vdcout);
#endif /*HES_DEBUG*/

	/* MPRB */
	for(i = 0; i < 8; i++) {
		huc6280_mpr_set(huc6280, i, HESBYTE(header->initial_mpr[i]));
	}

	/* PSGZbgB */
	huc6280psg_reset(psg, HES_PSG_CLOCK);

	/* vC[[`ZbgAbvB */
	mem[PLAYER_ADDR + 0] = 0x20;	// JSR request_address
	mem[PLAYER_ADDR + 1] = HESHALF(header->request_address) & 0xff;
	mem[PLAYER_ADDR + 2] = HESHALF(header->request_address) >> 8;
	mem[PLAYER_ADDR + 3] = 0x9c;	// STZ HALT_ADDR
	mem[PLAYER_ADDR + 4] = HALT_ADDR & 0xff;
	mem[PLAYER_ADDR + 5] = HALT_ADDR >> 8;
	mem[PLAYER_ADDR + 6] = 0x4c;	// JMP PLAYER_ADDR + 3
	mem[PLAYER_ADDR + 7] = (PLAYER_ADDR + 3) & 0xff;
	mem[PLAYER_ADDR + 8] = (PLAYER_ADDR + 3) >> 8;

	/* vC[[`sZbgAbvB */
	huc6280->a = i_song;
	huc6280->pc = PLAYER_ADDR;

	/* vC[`sBHALTƂ܂ŁB */
	huc6280_run(huc6280, HES_CPU_CLOCK/*ňł1bȓɂ͊Ɖ*/);
	if(!huc6280->halt) return -1; /* ȂΉtsƂ܂ */

	return 0;
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//hes_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
hes_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	return hes_mix((HESDRIVER*)param, wbuff);
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

static HESDRIVER g_hes;

int
hes_play(const void* data, int size, int i_song)
{
	/* ܂mɒ~܂B */
	hes_stop();

	/* HEShCo܂B */
	if(hes_init(&g_hes, data, size, i_song) != 0) return -1;

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(HESBUFLEN, hes_stream_callback, (int)&g_hes, 1/*X^bN؊gp*/);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(HESBUFLEN, hes_stream_callback, (intptr_t)&g_hes, 1/*X^bN؊gp*/);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
hes_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* HEShCõN[Abv͕svłB */

	/* tɊւĂ̓N[AbvsvȂ̂łEEE */

	/* t~hes_timer_limit()0ԂdlȂ̂ŁA[tBĂ܂B */
	memset(&g_hes, 0, sizeof(HESDRIVER));
}

int
hes_timer_limit()
{
	return g_hes.timer_limit;
}

