/*	
 *	clipgym.c
 *
 *	P/ECE GYM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Dec 9 18:16:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	GYMhCo֐
 ****************************************************************************/

#define MD_CLOCK	53693100	/* NTSCMegaDrivěUNbN */
#define YM2612_CLOCK	(MD_CLOCK / 7)	/* 7YM2612֋ */
#define SN76489_CLOCK	(MD_CLOCK / 15)	/* 15SN76489֋ */

int
gym_init(GYMDRIVER* driver, const char* fname)
{
	int retval;
	GYMHEADER header;

	/* ܂NA܂B */
	memset(driver, 0, sizeof(GYMDRIVER));

	/* YM2612 chip܂B */
	{
		extern YM2612 gym_ym2612; /* RAMɔzu */
		driver->ym2612 = &gym_ym2612;
	}
	ym2612_init(driver->ym2612, YM2612_CLOCK);

	/* SN76489 chip܂B */
	{
		static SN76489 gym_sn76489; /* SRAMɔzu */
		driver->sn76489 = &gym_sn76489;
	}
	sn76489_reset(driver->sn76489, SN76489_CLOCK);

	/* t@CJ܂B */
	driver->fp = fopen(fname, "rb");
	if(!driver->fp) {
		goto L_ERR;
	}

	/* wb_ǂݍ݂܂B */
	retval = fread(&header, sizeof(GYMHEADER), 1, driver->fp);
	if(retval != 1) {
		goto L_ERR;
	}

	/* VOl`܂B */
	if(memcmp(header.identifier, "GYMX", 4) != 0) {
		goto L_ERR;
	}

	/* k`ɂ͖ΉłB */
	if(header.uncompressed_size) {
		goto L_ERR;
	}

	/* [vJnʒu܂ł̎ct[܂B(񃋁[vȂȂΏl0) */
	driver->loopcnt = header.loop_integer;

	return 0; /*  */

L_ERR:
	/* mɃt@C܂B */
	gym_free(driver);

	return -1; /* s */
}

void
gym_free(GYMDRIVER* driver)
{
	/* mɃt@C܂B */
	if(driver->fp) {
		fclose(driver->fp);
		driver->fp = NULL;
	}
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//gym_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
gym_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	int retval;
	int i;

	i = GYMFRAME;
	do {
		retval = gym_mix((GYMDRIVER*)param, wbuff);
		if(retval != 0) {
			break;
		}
		wbuff += GYMBUFLEN;
	} while(--i);

	return retval;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

static GYMDRIVER driver; /* rs`shbłI */

int
gym_play(const char* fname)
{
	/* ܂mɒ~܂B */
	gym_stop();

	/* hCo܂B */
	if(gym_init(&driver, fname) != 0) {
		return -1;
	}

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(GYMBUFLEN * GYMFRAME, gym_stream_callback, (int)&driver, 1/*X^bN؊gp*/);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(GYMBUFLEN * GYMFRAME, gym_stream_callback, (intptr_t)&driver, 1/*X^bN؊gp*/);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
gym_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* GYMhCo܂B(K{!!) */
	gym_free(&driver);
}
