/*	
 *	clipgbs.h
 *
 *	P/ECE GBS Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Fri Feb 18 18:41:00 JST 2005 Naoyuki Sawa
 *	- dmg_reset()GameBoy[IPLsp̈ǉꂽƂɒǏ]A
 *	  dmg_reset()𗘗pĂR[hC܂B
 *	  GBS DriverGameBoy[IPLgȂ̂ŁAɉe܂B
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	DMGG~[VpO֐
 ****************************************************************************/

void
gbs_dmg_out(DMG* dmg, unsigned char addr, unsigned char data)
{
	GBSDRIVER* gbs = (GBSDRIVER*)dmg;
	DMGSOUND* ds = &gbs->ds;

	/* 0x10-0x3f: DMG-SoundWX^B */
	if(addr >= 0x10 && addr <= 0x3f) {
		dmgsound_write(ds, addr, data);
		return;
	}

	/* DMG-SoundWX^ȊOB */
	gbs->mem[0xff00 | addr] = data;

	/* 荞݃^C~OݒB */
	switch(addr) {
	case 0x06: /* TMA (Timer Modulo ) */
	case 0x07: /* TAC (Timer Control) */
		if(gbs->header->timer_ctl & 4) {
			/* ^C}荞݃^C~OB */
			switch(gbs->mem[0xff07] & 3) {
			case 0: /* {NbN1024(=  4096Hz) * (256-TMA) */
				gbs->interrupt_interval = 1024 * (256 - gbs->mem[0xff06]);
				break;
			case 1: /* {NbN  16(=262144Hz) * (256-TMA) */
				gbs->interrupt_interval =   16 * (256 - gbs->mem[0xff06]);
				break;
			case 2: /* {NbN  64(= 65536Hz) * (256-TMA) */
				gbs->interrupt_interval =   64 * (256 - gbs->mem[0xff06]);
				break;
			default:/* {NbN 256(= 16384Hz) * (256-TMA) */
				gbs->interrupt_interval =  256 * (256 - gbs->mem[0xff06]);
				break;
			}
		} else {
			/* V-BLANK荞݃^C~OB(V-BLANK=59.7Hz) */
			gbs->interrupt_interval = (int)(GBS_CLOCK / 59.7);
		}
		gbs->interrupt_progress = gbs->interrupt_interval;
		return;
	}
}

/****************************************************************************
 *	GBShCo֐
 ****************************************************************************/

/* [`/t[`̌ĂяovO */
static const char gbs_program[] = {
	'\xcd',		/* +0: CALL nn */
	'\x00',		/* +1: ɌĂяoAhX̉ʃoCgZbg */
	'\x00',		/* +2: ɌĂяoAhX̏ʃoCgZbg */
	'\x76',		/* +3: HALT */
};

/* ĂяovO]AhX
 * * ROM Area0̗\̈̌ԁA
 *	0x0000`0x006?: RST xxH/荞݃xN^)
 *   
 *	0x0100`      : GameBoyN[`
 *   ̊ԂɒuƂɂ܂B
 */
#define GBS_PROGRAM_ADDRESS	0x0080 /*  */

/* Ăяo([`/t[`)AhXZbgAhX
 * ĂяovÓuCALL nnv߂̃IyhƂȂ܂B
 */
#define GBS_RUN_PC_ADDRESS	(GBS_PROGRAM_ADDRESS + 1)

void
gbs_dmg_setup(GBSDRIVER* gbs, int a, int pc)
{
	DMG* dmg = &gbs->dmg;
	unsigned char* mem = gbs->mem;

	/* ĂяovOoRŁAĂяovOĂяo܂B */
	mem[GBS_RUN_PC_ADDRESS + 0] = pc & 0xff;
	mem[GBS_RUN_PC_ADDRESS + 1] = pc >> 8;
	dmg->af = a << 8;
	dmg->pc = GBS_PROGRAM_ADDRESS;
	dmg->halt = 0;  /* Kv!! */
	dmg->cycle = 0; /* Kv!! */
}

/* I/OWX^l */
static const unsigned char gbs_iop_init[][2] = {
	{ 0x05, 0x00 }, /* TIMA */
	{ 0x06, 0x00 }, /* TMA */
	{ 0x07, 0x00 }, /* TAC */
	{ 0x10, 0x80 }, /* NR10 */
	{ 0x11, 0xbf }, /* NR11 */
	{ 0x12, 0xf3 }, /* NR12 */
	//{ 0x14, 0xbf }, /* NR14 */ ̔h߂ɍ폜
	{ 0x16, 0x3f }, /* NR21 */
	{ 0x17, 0x00 }, /* NR22 */
	//{ 0x19, 0xbf }, /* NR24 */ ̔h߂ɍ폜
	{ 0x1a, 0x7f }, /* NR30 */
	{ 0x1b, 0xff }, /* NR31 */
	{ 0x1c, 0x9f }, /* NR32 */
	{ 0x1e, 0xbf }, /* NR33 */
	{ 0x20, 0xff }, /* NR41 */
	{ 0x21, 0x00 }, /* NR42 */
	{ 0x22, 0x00 }, /* NR43 */
	{ 0x23, 0xbf }, /* NR30 */
	{ 0x24, 0x77 }, /* NR50 */
	{ 0x25, 0xf3 }, /* NR51 */
	{ 0x26, 0xf1 }, /* NR52 */
	{ 0x40, 0x91 }, /* LCDC */
	{ 0x42, 0x00 }, /* SCY */
	{ 0x43, 0x00 }, /* SCX */
	{ 0x45, 0x00 }, /* LYC */
	{ 0x47, 0xfc }, /* BGP */
	{ 0x48, 0xff }, /* OBP0 */
	{ 0x49, 0xff }, /* OBP1 */
	{ 0x4a, 0x00 }, /* WY */
	{ 0x4b, 0x00 }, /* WX */
	{ 0xff, 0x00 }, /* IE */
};

int
gbs_init(GBSDRIVER* gbs, const void* data, int len, int i_song)
{
	DMG* dmg = &gbs->dmg;
	unsigned char* mem = gbs->mem;
	DMGSOUND* ds = &gbs->ds;
	//
	GBSHEADER* header = (GBSHEADER*)data;
	const unsigned char* code = (const unsigned char*)(header + 1);
	int bank0_size;
	int i;

	ASSERT(sizeof(GBSHEADER) == 0x70);

	/* ܂NA܂B */
	memset(gbs, 0, sizeof(GBSDRIVER));

	/* VOl`B */
	if(memcmp(header->signature, "GBS", 3) != 0) return -1;

	/* GBSHEADERAhXi[B */
	gbs->header = header;

	/* RST xxH [hAhXΈʒuɃ_CNgB */
	for(i = 0x00; i <= 0x38; i += 0x08) {
		mem[i + 0] = 0xc3; /* JP nn */
		mem[i + 1] = (header->load_addr + i) & 0xff;
		mem[i + 2] = (header->load_addr + i) >> 8;
	}

	/* [`/t[`ĂяovO]܂B */
	memcpy(&mem[GBS_PROGRAM_ADDRESS], gbs_program, sizeof gbs_program);

	/* [hAhXĂяovO]GAł邱ƂmFB */
	if(header->load_addr < GBS_PROGRAM_ADDRESS + sizeof gbs_program) return -1;

	/* ROM Bank0̃TCYZoB */
	bank0_size = 0x4000 - header->load_addr; /* lcBank0Ȃ */

	/* ROM Area0΁Aǂݍ݂܂B */
	if(bank0_size > 0) memcpy(mem + header->load_addr, code, bank0_size);

	/* ROM Bank1擪AhXZoAi[B */
	gbs->bank1 = code + bank0_size;

	/* bank1ȍ~̗LoCgZoAi[B */
	gbs->length = len - sizeof(GBSHEADER) - bank0_size;

	/* ԂŁAROM Area1Bank1IĂ܂B
	 * (ŏ̃NAgbs->rom1_bank0ɏĂ̂ŁA
	 *  0=>1̕ωƂȂAgbs_rom1_bank()͂Əs͂ł)
	 */
	gbs_rom1_bank(gbs, 1);

	/* CPUZbgB */
	dmg_reset(dmg, NULL/*gbs_dmg_read*/, gbs_dmg_write, 0/*GameBoy[IPL͎g܂*/);
	dmg->sp = header->stack_ptr; /* X^bN */

	/* SoundZbgB */
	dmgsound_reset(ds, &mem[0xff00]/*0xff00`0xffffL*/, GBS_CLOCK);

	/* I/OWX^B */
	for(i = 0; i < sizeof gbs_iop_init / sizeof *gbs_iop_init; i++) {
		gbs_dmg_out(dmg, gbs_iop_init[i][0], gbs_iop_init[i][1]);
	}

	/* 荞݃^C~OB */
	gbs_dmg_out(dmg, 0x06, header->timer_mod);
	gbs_dmg_out(dmg, 0x07, header->timer_ctl);

	/* tȔԍB
	 * : GBSHEADER.first_songA1x[XłB
	 *	 ȊÓAinit_addr֓nAWX^l(Ȕԍ)A
	 *	 gbs_init()֐ɓni_songA0x[XłB
	 */
	if(i_song < 0) i_song = header->first_song/*1-based!*/ - 1;
	if(i_song < 0 || i_song > header->num_songs - 1) return -1;

	/* [`Ăяo܂B */
	gbs_dmg_setup(gbs, i_song, header->init_addr);
	dmg_run(dmg, GBS_CLOCK);

	return 0;
}

void
gbs_rom1_bank(GBSDRIVER* gbs, int i_bank)
{
	int offset, size;

	/* * ROM Area1ROM Bank0͑Ił܂B(dl)
	 *   Bank0w肳ꂽABank1I܂B
	 */
	if(!i_bank) i_bank++;
	if(gbs->rom1_bank == i_bank) return; /* ωȂ */

	/* IꂽROM BankAROM Area1ɃRs[܂B */
	offset = 0x4000 * (i_bank - 1/*Bank1x[X*/);
	size = gbs->length - offset;
	if(size > 0x4000) size = 0x4000;
	if(size <= 0) DIE(); /* oN? */
	memcpy(&gbs->mem[0x4000], gbs->bank1 + offset, size);
}

int
gbs_mix(GBSDRIVER* gbs, short wbuff[/*GBSBUFLEN*/])
{
	int cnt1 = GBSBUFLEN;	/* cTv */
	int cnt2;

	ASSERT(GBS_CLOCK >= SPEAKER_FREQUENCY);
	do {
		/* 񊄂荞ݔ܂ł̎cTCNŁATv~LVOł邩? */
		cnt2 = (gbs->interrupt_progress * SPEAKER_FREQUENCY + GBS_CLOCK - 1) / GBS_CLOCK;
		if(cnt2 > cnt1) cnt2 = cnt1;

		/* ~LVOB */
		dmgsound_mix(&gbs->ds, wbuff, cnt2);
		wbuff += cnt2;
		cnt1 -= cnt2;

		/* 񊄂荞ݔ܂ł̎cTCN炵āA0ɂȂ犄荞ݏB */
		gbs->interrupt_progress -= cnt2 * GBS_CLOCK / SPEAKER_FREQUENCY;
		while(gbs->interrupt_progress <= 0) {
			gbs->interrupt_progress += gbs->interrupt_interval;
			gbs_dmg_setup(gbs, 0, gbs->header->play_addr);
			dmg_run(&gbs->dmg, GBS_CLOCK/*ňł1bȓɂ͊Ɖ*/);
		}
	} while(cnt1);

	return 0;
}

int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//gbs_stream_callback(short* wbuff, int param)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
gbs_stream_callback(short* wbuff, intptr_t param)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	return gbs_mix((GBSDRIVER*)param, wbuff);
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

int
gbs_play(const void* data, int len, int i_song)
{
	static GBSDRIVER gbs; /* STATICł! */

	/* ܂mɒ~܂B */
	gbs_stop();

	/* GBShCo܂B */
	if(gbs_init(&gbs, data, len, i_song) != 0) return -1;

	/* Xg[ĐJn܂B */
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//	stream_play(GBSBUFLEN, gbs_stream_callback, (int)&gbs, 1/*X^bN؊gp*/);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
	stream_play(GBSBUFLEN, gbs_stream_callback, (intptr_t)&gbs, 1/*X^bN؊gp*/);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

	return 0;
}

void
gbs_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* GBShCõN[Abv͕svłB */
}

