/*
 *	clipdlyq.c
 *
 *	xR[obNL[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2017-2018 Naoyuki Sawa
 *
 *	* Mon Jan 30 21:41:16 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Apr 11 23:59:59 JST 2018 Naoyuki Sawa
 *	- DlyQue_AddArg_l(),DlyQue_AddArg_a(),DlyQue_AddArg_v()ǉ܂B
 *	  xR[obNL[AhzbNɗp邽߂̊֐łB
 *	  clipcbkq.cW[ɂ\Ȃ̂łAxR[obNL[łgȂƎv̂ŁAclipdlyq.cW[Ɏ鎖ɂ܂B
 *	  Aclipcbkq.cW[ł̂悤Ȏgo֗Ɣfꍇ́Aclipcbkq.cW[ɂ̊֐ǉĉB
 */
#include "clip.h"
/*****************************************************************************
 *	\
 *****************************************************************************/
/*typedef*/ struct _ST_DlyQue {
	int		t;		//ݎ									DlyQue_New()Ăяoꂽ_0ƂāADlyQue_Exec()Ăяox+1܂BPȂJE^łAtime()GetTickCount()ԂƂ͊֌WL܂B
	GTree*		tree;		//(˃R[obNL[)̃c[	key=(pDlyQue->t+dly),value=pCbkQue
	GSList*		list;		//R[obNL[̃v[	data=pCbkQue				DlyQue_ReleaseCbkQue()ɂāAR[obNL[v[ɖ߂OɁACbkQue_Clear()săR[obNL[ɂĂ܂B]āAv[ێĂR[obNL[͑SāȀԂ̃R[obNL[łB
} /*ST_DlyQue*/;
/*---------------------------------------------------------------------------*/
typedef struct _ST_DlyQue_Param {
	ST_DlyQue*	pDlyQue;
	void		(*fn)(ST_DlyQue* pDlyQue, int pri, void* param);
	void*		param;
    //	char		mem[memBytes];
} ST_DlyQue_Param;
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
static int DlyQue_KeyCompare(const void* a, const void* b, void* user_data) {
	if(a < b) { return -1; }
	if(a > b) { return  1; }
	          { return  0; }
}
/*---------------------------------------------------------------------------*/
static ST_CbkQue* DlyQue_LookupCbkQue(ST_DlyQue* pDlyQue, int dly) {
	//(ݎ+x)L[ƂB
	void* const key = (void*)(intptr_t)(pDlyQue->t + dly);
	//̃L[ɑΉR[obNL[ɓo^Ă邩?
	ST_CbkQue* pCbkQue = g_tree_lookup(pDlyQue->tree, key);
	//̃L[ɑΉR[obNL[܂o^ĂȂ΁c
	if(!pCbkQue) {
		//R[obNL[̃v[Ȃ΁c
		if(!pDlyQue->list) {
			//R[obNL[쐬āAR[obNL[̃v[ɒǉB
			pDlyQue->list = g_slist_prepend(pDlyQue->list, DynamicCbkQue_New(0));
#ifdef  DEBUG
			syslog(LOG_DEBUG, "DlyQue_LookupCbkQue: New Callback queue is allocated.");	//ʓIȎgł́AxAvP[V̎spAv[̃R[obNL[ł܂Ȃ悤ɂȂAVȃR[obNL[͍쐬ȂȂ͂łB܂ł̍ssꑱꍇAoỎ\L܂B
#endif//DEBUG
		}
		//R[obNL[̃v[AR[obNL[oB
		pCbkQue = pDlyQue->list->data;
		pDlyQue->list = g_slist_delete_link(pDlyQue->list, pDlyQue->list);
		//̃L[ɑΉR[obNL[o^B
		g_tree_insert(pDlyQue->tree, key, pCbkQue);
	}
	//R[obNL[ԂB
	return pCbkQue;
}
/*---------------------------------------------------------------------------*/
static void DlyQue_ReleaseCbkQue(ST_DlyQue* pDlyQue, ST_CbkQue* pCbkQue) {
	//R[obNL[ɂB
	CbkQue_Clear(pCbkQue);
	//R[obNL[AR[obNL[̃v[ɒǉB
	pDlyQue->list = g_slist_prepend(pDlyQue->list, pCbkQue);
}
/*---------------------------------------------------------------------------*/
static void DlyQue_fnStub(ST_CbkQue* pCbkQue, int pri, void* param) {
	ST_DlyQue_Param* pParam = param;
	(*pParam->fn)(pParam->pDlyQue, pri, pParam->param);
}
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//xR[obNL[쐬B
//[out]
//	߂l			쐬xR[obNL[̃|C^B
ST_DlyQue* DlyQue_New() {
	//\̂̃mۂB
	ST_DlyQue* pDlyQue = calloc(1, sizeof(ST_DlyQue));
	if(!pDlyQue) { DIE(); }
	//(˃R[obNL[)̃c[쐬B
	pDlyQue->tree = g_tree_new_full(
		DlyQue_KeyCompare,		//key_compare_func
		NULL,				//key_compare_data
		NULL,				//key_destroy_func
		(void (*)(void*))CbkQue_Free);	//value_destroy_func	Ŏw肷CbkQue_Free()́Ac[ɖs̃R[obNL[cĂԂŁADlyQue_Free()Ă΂ꂽꍇ̉łBDlyQue_Exec()ɂăR[obNL[Oۂ́AŎw肵CbkQue_Free()Ă΂Ȃ悤Ag_tree_remove()ł͂Ȃg_tree_steal()gĎOĂ܂B
	return pDlyQue;
}
/*---------------------------------------------------------------------------*/
//xR[obNL[B
//[out]
//	߂l			xR[obNL[̃|C^B
void DlyQue_Free(ST_DlyQue* pDlyQue) {
	//(˃R[obNL[)̃c[폜B
	g_tree_unref(pDlyQue->tree);
	//R[obNL[̃v[폜B
	g_slist_free_full(pDlyQue->list,
		(void (*)(void*))CbkQue_Free);	//free_func_
	//\̂̃B
	free(pDlyQue);
}
/*---------------------------------------------------------------------------*/
//֐o^B
//[in]
//	pDlyQue			xR[obNL[̃|C^B
//	dly			xԁB	0̒xԂw肵ꍇA(unsigned)lƂĉ߂܂B
//				0Ȃ΁ADlyQue_Exec()Ă񂾎ɃR[obNB
//				1Ȃ΁A̎DlyQue_Exec()Ă񂾎ɃR[obNB
//				2Ȃ΁A̎̎DlyQue_Exec()Ă񂾎ɃR[obNB
//				c
//	pri			̒ł̗DxB
//				ڍׂ́Aclipcbkq.cW[QƂĉB
//				CDxȂ΁Ao^ƓŃR[obN鎖Aclipcbkq.cW[̓ƓłB
//	fn,param,memBytes	CbkQue_Add(),y,CbkQue_AddMem()ƓłB
void DlyQue_Add(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(ST_DlyQue* pDlyQue, int pri, void* param), void* param) {
	//(ݎ+x)ɑΉR[obNL[擾B
	ST_CbkQue* pCbkQue = DlyQue_LookupCbkQue(pDlyQue, dly);
	//R[obNL[Ɋ֐o^B
	ST_DlyQue_Param* pParam = CbkQue_AddMem(pCbkQue, pri, DlyQue_fnStub, sizeof(ST_DlyQue_Param));
	pParam->pDlyQue = pDlyQue;
	pParam->fn = fn;
	pParam->param = param;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
void* DlyQue_AddMem(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(ST_DlyQue* pDlyQue, int pri, void* param), int memBytes) {
	//(ݎ+x)ɑΉR[obNL[擾B
	ST_CbkQue* pCbkQue = DlyQue_LookupCbkQue(pDlyQue, dly);
	//R[obNL[Ɋ֐o^B
	ST_DlyQue_Param* pParam = CbkQue_AddMem(pCbkQue, pri, DlyQue_fnStub, sizeof(ST_DlyQue_Param) + memBytes);
	pParam->pDlyQue = pDlyQue;
	pParam->fn = fn;
	pParam->param = pParam + 1;
	return pParam->param;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//{{2018/04/11ǉ:DlyQue_AddArg_l(),DlyQue_AddArg_a(),DlyQue_AddArg_v()ǉ܂B
#define DlyQue_AddArg_MaxArgc	8	//
typedef struct _ST_DlyQue_AddArg_Param {
	void	(*fn)();
	void*	argv[DlyQue_AddArg_MaxArgc];
} ST_DlyQue_AddArg_Param;
static void DlyQue_AddArg_fn(ST_DlyQue* pDlyQue, int pri, void* param) {
	ST_DlyQue_AddArg_Param* p = param;
	static_assert((sizeof p->argv / sizeof p->argv[0]) == 8, "DlyQue_AddArg_MaxArgc̒lzƈقȂ܂B");
	(*p->fn)(p->argv[0], p->argv[1], p->argv[2], p->argv[3], p->argv[4], p->argv[5], p->argv[6], p->argv[7]);	//]ȈcdeclďoKɂĖ̂ŁAɍő̈nĖL܂B
}
#ifndef PIECE
void DlyQue_AddArg_l(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(), int argc, ...) {
	va_list ap;
	va_start(ap, argc);
//sv	if((unsigned)argc > DlyQue_AddArg_MaxArgc) { DIE(); }	//Œ~ꍇ́ADlyQue_AddArg_MaxArgc̒l𑝂₹B	DlyQue_AddArg_a()Ōŝłł͌svłB
	DlyQue_AddArg_a(pDlyQue, dly, pri, fn, argc, ap);
	va_end(ap);
}
void DlyQue_AddArg_a(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(), int argc, va_list ap) {
	void* argv[DlyQue_AddArg_MaxArgc];
	int i;
	if((unsigned)argc > DlyQue_AddArg_MaxArgc) { DIE(); }	//Œ~ꍇ́ADlyQue_AddArg_MaxArgc̒l𑝂₹B
	for(i = 0; i < argc; i++) { argv[i] = va_arg(ap, void*); }
	DlyQue_AddArg_v(pDlyQue, dly, pri, fn, argc, argv);
}
#else //PIECE
void DlyQue_AddArg_l(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(), int argc, ...);
void DlyQue_AddArg_a(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(), int argc, va_list ap);
asm("
		.code
		.align		1
		.global		DlyQue_AddArg_l
		.global		DlyQue_AddArg_a
DlyQue_AddArg_l:
		xsub		%sp, %sp, 8
		;//%r12     := pDlyQue
		;//%r13     := dly
		;//%r14     := pri
		;//%r15     := fn
		;//[%sp+ 8] := retp
		;//[%sp+12] := argc
		;//[%sp+16] := ...
		xadd		%r9, %sp, 16		;//%r9     :=                                   ap = &...
		xld.w		[%sp+4], %r9		;//[%sp+4] :=                                   ap
		xld.w		%r9, [%sp+12]		;//%r9     :=                             argc
		xld.w		[%sp+0], %r9		;//[%sp+0] :=                             argc
		call		DlyQue_AddArg_a		;//DlyQue_AddArg_a(pDlyQue, dly, pri, fn, argc, ap)
		xadd		%sp, %sp, 8
		ret
DlyQue_AddArg_a:
		;//%r12     := pDlyQue
		;//%r13     := dly
		;//%r14     := pri
		;//%r15     := fn
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := argc
		;//[%sp+ 8] := ap
		xjp		DlyQue_AddArg_v
");
#endif//PIECE
void DlyQue_AddArg_v(ST_DlyQue* pDlyQue, int dly, int pri/*SHRT_MIN`SHRT_MAX*/, void (*fn)(), int argc, void* argv[/*argc*/]) {
	ST_DlyQue_AddArg_Param* p;
	if((unsigned)argc > DlyQue_AddArg_MaxArgc) { DIE(); }
	p = DlyQue_AddMem(pDlyQue, dly, pri, DlyQue_AddArg_fn, sizeof(ST_DlyQue_AddArg_Param));
	p->fn = fn;
	memcpy(p->argv, argv, sizeof(void*) * argc);
}
#if 0
//gp
int cpp_main(int argc, char* argv[]) {
	if(!setjmp(env_exit)) {
		for(;;) {
			schedule();
			if(keyTrig[KEY_INPUT_1]) {
				//1bɃTEh炷B
				DlyQue_AddArg_l(pDlyQue, SEC(1), 0, (void (*)())TapLogCh_Play,
					6,		//argc
					pTapSeq,	//argv[0]
					TapLogCh_Bgm,	//argv[1]
					PhrNo_RINGIN,	//argv[2]
					1,		//argv[3]
					0,		//argv[4]
					0);		//argv[5]
			}
			if(keyTrig[KEY_INPUT_2]) {
				//1bɃTEh~߂B
				DlyQue_AddArg_l(pDlyQue, SEC(1), 0, (void (*)())TapLogCh_Stop,
					2,		//argc
					pTapSeq,	//argv[0]
					TapLogCh_Bgm);	//argv[1]
			}
		}
	}
	return 0;
}
#endif
#undef  DlyQue_AddArg_MaxArgc
//}}2018/04/11ǉ:DlyQue_AddArg_l(),DlyQue_AddArg_a(),DlyQue_AddArg_v()ǉ܂B
/*---------------------------------------------------------------------------*/
//xR[obNL[sB
//[in]
//	pDlyQue			xR[obNL[̃|C^B
//[note]
//	- PʎԂƂɈAĂяoĉB
//	  ʏ́Aschedule()̒ňĂяoɂȂƎv܂B
//	- cxԂ0ł֐R[obN܂B
//	  悻Aclipcbkq.cW[CbkQue_Invoke()ƓłAȉ̓_قȂ_ɒӂĉB
//	  ECbkQue_InvokePri()ɑ֐͗L܂B
//	    xR[obNL[́AsɎIɃNÂ(LQ)ADx͈̔͂w肵Ďs鎖͈ӖƎvłB
//	  EDlyQue_Exec()́AR[obN֐Iɓo^܂B
//	    CbkQue_Invoke()ɑ΂CbkQue_Clear()Ăяô悤ȖIȓo^͕̑KvL܂B
//	  L̒ʂACbkQue_Invoke()Ƃ͏gႤ̂ŁAȂ悤ɂĊ֐ς܂B(DlyQue_Invoke()ł͂ȂDlyQue_Exec()Ƃ܂B)
//	- R[obN֐̒'DlyQue_Add(pDlyQue,0,pri,fn,param)'s鎖\łB(CbkQue_Invoke()ł͕słADlyQue_Exec()ł͉\łB)
//	  ̏ꍇAɓo^Ă̊֐SĎsɁA߂ėDx\[gČĂяo܂B
//	  ڍׂ́AL̎̃RgQƂĉB
void DlyQue_Exec(ST_DlyQue* pDlyQue) {
	//ݎL[ƂB
	void* const key = (void*)(intptr_t)pDlyQue->t;
	//̃L[ɑΉR[obNL[݂ԁc
	// - JԂŔAȉ̒ʂłB
	//   Ăяo֐̒'DlyQue_Add(pDlyQue,0,pri,fn,param)'sꂽꍇAł̎svƌȂ܂B
	//   A܏ĂR[obNL[̓\[gς݂łAɊ荞ōă\[g鎖͓łB
	//   ŁAĂяo֐̒'DlyQue_Add(pDlyQue,0,pri,fn,param)'sꂽꍇA܏ĂR[obNL[Ƃ͕ʂ́AVȃR[obNL[ɕێĂāAŎs鎖ɂ܂B
	//   ̂߂ɁAȉ̏̒ł́Aŏ'g_tree_steal(pDlyQue->tree,key)'sĂ鎖ɒӂĉB
	// - L̕@ŏ΁ÃR[obNL[rŕύXĂ܂͖h܂B
	//   ADlyQue_Exec()̎sOɓo^Ă(ʂ̎gł͂炪ł)֐̗DxƁADlyQue_Exec()̎sɓo^ꂽ֐̗Dx́A}[WȂɒӂĉB(R͏L̐Q)
	ST_CbkQue* pCbkQue;
	while((pCbkQue = g_tree_lookup(pDlyQue->tree, key))) {
		//̃L[ɑΉR[obNL[OB	//g_tree_remove()ł͂Ȃg_tree_steal()gĎOɒӂĉBg_tree_remove()gƁAvalue_destroy_funcƂCbkQue_Free()Ă΂Ă܂܂B
		if(!g_tree_steal(pDlyQue->tree, key)) { DIE(); }
		//R[obNL[ɓo^Ă֐ĂяoB	//֐̒'DlyQue_Add(pDlyQue,0,pri,fn,param)'sꂽꍇAł̎svƌȂāAVȃR[obNL[ɕێB(L̐Q)
		CbkQue_Invoke(pCbkQue);
		//R[obNL[ɂāAR[obNL[̃v[ɒǉB
		DlyQue_ReleaseCbkQue(pDlyQue, pCbkQue);
		//'CbkQue_Invoke(pCbkQue)'̒'DlyQue_Add(pDlyQue,0,pri,fn,param)'sꂽ\L̂ŁÃL[ɑΉR[obNL[Ȃ܂ŌJԂB
	}
	//ݎi߂B
	pDlyQue->t++;
}
/*****************************************************************************
 *	gp
 *****************************************************************************/
#if 0
//TODO:͊JɓKɏgpłBƂƂgpB
static void fn1(ST_DlyQue* pDlyQue, int pri, void* param) {
	printf("fn1: %s\n", param);
}
int app_main(int argc, char* argv[]) {
	ST_DlyQue* pDlyQue;
	pDlyQue = DlyQue_New();
	{
		int i;
		DlyQue_Add(pDlyQue, 5, 0, fn1, "foo");
		DlyQue_Add(pDlyQue, 5, -1, fn1, "bar");
		DlyQue_Add(pDlyQue, 1, 0, fn1, "baz");
		{
			char* mem = DlyQue_AddMem(pDlyQue, 3, 0, fn1, 5);
			strcpy(mem, "qux");
		}
		for(i = 0; i < 10; i++) {
			printf("%d ----------------\n", i);
			DlyQue_Exec(pDlyQue);
		}
	}
	{
		int i;
		DlyQue_Add(pDlyQue, 5, 0, fn1, "2foo");
		DlyQue_Add(pDlyQue, 5, -1, fn1, "2bar");
		DlyQue_Add(pDlyQue, 1, 0, fn1, "2baz");
		DlyQue_Add(pDlyQue, 7, 0, fn1, "2quux");
		{
			char* mem = DlyQue_AddMem(pDlyQue, 3, 0, fn1, 5);
			strcpy(mem, "2qux");
		}
		for(i = 0; i < 10; i++) {
			printf("%d ----------------\n", i);
			DlyQue_Exec(pDlyQue);
		}
	}
	DlyQue_Free(pDlyQue);
	return 0;
}
#endif
