
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

		.code
		.align		1
		.global		InitializeListHead
		.global		IsListEmpty
		.global		RemoveHeadList
		.global		RemoveTailList
		.global		RemoveEntryList
		.global		InsertHeadList
		.global		InsertTailList
		;//-------------------------------------;//
InitializeListHead:
	ext	0x4		; 		xld.w		[%r12+0x4], %r12		;//ListHead->Blink = ListHead
	ld.w	[%r12],%r12
		ld.w		[%r12], %r12		;//ListHead->Flink = ListHead
		ret
		;//-------------------------------------;//
IsListEmpty:
		ld.w		%r10, [%r12]		;//%r10    :=  ListHead->Flink
		cmp		%r10, %r12		;//%psr(Z) := (ListHead->Flink == ListHead)	!INTERLOCK!
		ld.w		%r10, %psr		;//%r10[1] := (ListHead->Flink == ListHead)
		ret.d					;//
		and		%r10, 2			;//return     (ListHead->Flink == ListHead)	*delay*		//Cł͔0lƂ1ԂAAsmł͔0lƂ2ԂB0lɈˑȂ悤ӂB
		;//-------------------------------------;//
RemoveHeadList:
		ld.w		%r12, [%r12]		;//%r12 := Head = ListHead->Flink
		jp		RemoveEntryList		;//return RemoveEntryList(Head)					//AsmRemoveEntryList()̉B߂lɈˑ
		;//-------------------------------------;//
RemoveTailList:
	ext	0x4		; 		xld.w		%r12, [%r12+0x4]		;//%r12 := Tail = ListHead->Blink
	ld.w	%r12,[%r12]
	;//sv	jp		RemoveEntryList		;//return RemoveEntryList(Tail)					//AsmRemoveEntryList()̉B߂lɈˑ
		;//-------------------------------------;//
RemoveEntryList:
	;//{{C^[bN
	;//	ld.w		%r10, %r12		;//%r10 := Entry
	;//	ld.w		%r11, [%r12]+		;//%r11 := Flink = Entry->Flink
	;//	ld.w		%r12, [%r12]		;//%r12 := Blink = Entry->Blink
	;//	ld.w		[%r12] %r11		;// Blink->Flink = Flink			!INTERLOCK!
	;//	xld.w		[%r11+4], %r12		;// Flink->Blink = Blink
	;//	ret					;//return  Entry						//AsmRemoveEntryList()̉B߂l %r10 := Entry
	;//C^[bN
		ld.w		%r10, %r12		;//%r10 := Entry
		ld.w		%r11, [%r12]+		;//%r11 := Flink = Entry->Flink
		ld.w		%r12, [%r12]		;//%r12 := Blink = Entry->Blink
	ext	0x4		; 		xld.w		[%r11+0x4], %r12		;// Flink->Blink = Blink
	ld.w	[%r11],%r12
		ld.w		[%r12] %r11		;// Blink->Flink = Flink
		ret					;//return  Entry						//AsmRemoveEntryList()̉B߂l %r10 := Entry
	;//}}C^[bN
		;//-------------------------------------;//
InsertHeadList:
	;//{{C^[bN,1ߐߖ
	;//	ld.w		%r9, [%r12]		;//%r9  :=    Head = ListHead->Flink
	;//	ld.w		[%r13], %r9		;//   Entry->Flink = Head			!INTERLOCK!
	;//	xld.w		[%r13+4], %r12		;//   Entry->Blink = ListHead
	;//	xld.w		[%r9+4], %r13		;//    Head->Blink = Entry
	;//	ld.w		[%r12], %r13		;//ListHead->Flink = Entry
	;//	ret
	;//C^[bN,1ߐߖ
		ld.w		%r9, [%r12]		;//%r9  :=    Head = ListHead->Flink
	ext	0x4		; 		xld.w		[%r9+0x4], %r13		;//    Head->Blink = Entry
	ld.w	[%r9],%r13
		ld.w		[%r12], %r13		;//ListHead->Flink = Entry
		ld.w		[%r13]+, %r9		;//   Entry->Flink = Head, %r13 := &Entry->Blink
		ld.w		[%r13], %r12		;//   Entry->Blink = ListHead
		ret
	;//}}C^[bN,1ߐߖ
		;//-------------------------------------;//
InsertTailList:
	;//{{1ߐߖ
	;//	xld.w		%r9, [%r12+4]		;//%r9  :=    Tail = ListHead->Blink
	;//	ld.w		[%r13], %r12		;//   Entry->Flink = ListHead
	;//	xld.w		[%r13+4], %r9		;//   Entry->Blink = Tail
	;//	xld.w		[%r12+4], %r13		;//ListHead->Blink = Entry
	;//	ld.w		[%r9], %r13		;//    Tail->Flink = Entry
	;//	ret
	;//1ߐߖ
		ld.w		[%r13], %r12		;//   Entry->Flink = ListHead
		add		%r12, 4			;//%r12 :=          &ListHead->Blink
		ld.w		%r9, [%r12]		;//%r9  :=    Tail = ListHead->Blink
	ext	0x4		; 		xld.w		[%r13+0x4], %r9		;//   Entry->Blink = Tail
	ld.w	[%r13],%r9
		ld.w		[%r12], %r13		;//ListHead->Blink = Entry
		ld.w		[%r9], %r13		;//    Tail->Flink = Entry
		ret
	;//}}1ߐߖ

; NO_APP
	.code
	.align	1
	.global	SortList
SortList:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r14,0x0
	call	SortList_r	; 	xcall	SortList_r
	ret
	.align	1
	.global	SortList_r
SortList_r:
;	.frame	%sp,44,$31		# vars= 24, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x6		; 	xsub	%sp,%sp,24
	ld.w	%r2,%r12
	ld.w	[%sp+0x4],%r13	; 	xld.w	[%sp+0x10],%r13
	ld.w	[%sp+0x5],%r14	; 	xld.w	[%sp+0x14],%r14
	ld.w	%r12,%sp
	call	InitializeListHead	; 	xcall	InitializeListHead
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,8
	add	%r12,0x8
	call	InitializeListHead	; 	xcall	InitializeListHead
__LX72:				; __L72:
	ld.w	%r12,%r2
	call	IsListEmpty	; 	xcall	IsListEmpty
	cmp	%r10,0x0
	jrne	__LX73		; 	xjrne	__L73
	ld.w	%r12,%r2
	call	RemoveHeadList	; 	xcall	RemoveHeadList
	ld.w	%r12,%sp
	ld.w	%r13,%r10
	call	InsertTailList	; 	xcall	InsertTailList
	ld.w	%r12,%r2
	call	IsListEmpty	; 	xcall	IsListEmpty
	cmp	%r10,0x0
	jrne	__LX73		; 	xjrne	__L73
	ld.w	%r12,%r2
	call	RemoveHeadList	; 	xcall	RemoveHeadList
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,8
	add	%r12,0x8
	ld.w	%r13,%r10
	call	InsertTailList	; 	xcall	InsertTailList
	jp	__LX72		; 	xjp	__L72
__LX73:				; __L73:
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,8
	add	%r0,0x8
	ld.w	%r12,%r0
	call	IsListEmpty	; 	xcall	IsListEmpty
	cmp	%r10,0x0
	jrne	__LX77		; 	xjrne	__L77
	ld.w	%r12,%sp
	ld.w	%r13,[%sp+0x4]	; 	xld.w	%r13,[%sp+0x10]
	ld.w	%r14,[%sp+0x5]	; 	xld.w	%r14,[%sp+0x14]
	call	SortList_r	; 	xcall	SortList_r
	ld.w	%r12,%r0
	ld.w	%r13,[%sp+0x4]	; 	xld.w	%r13,[%sp+0x10]
	ld.w	%r14,[%sp+0x5]	; 	xld.w	%r14,[%sp+0x14]
	call	SortList_r	; 	xcall	SortList_r
__LX77:				; __L77:
	ld.w	%r3,%r0
__LX78:				; __L78:
	ld.w	%r12,%sp
	call	IsListEmpty	; 	xcall	IsListEmpty
	cmp	%r10,0x0
	jrne	__LX81		; 	xjrne	__L81
	ld.w	%r12,%sp
	call	RemoveHeadList	; 	xcall	RemoveHeadList
	ld.w	%r1,%r10
	jp	__LX82		; 	xjp	__L82
__LX81:				; __L81:
	ld.w	%r1,0x0
__LX82:				; __L82:
	ld.w	%r12,%r3
	call	IsListEmpty	; 	xcall	IsListEmpty
	cmp	%r10,0x0
	jrne	__LX83		; 	xjrne	__L83
	ld.w	%r12,%r3
	call	RemoveHeadList	; 	xcall	RemoveHeadList
	ld.w	%r0,%r10
	jp	__LX84		; 	xjp	__L84
__LX83:				; __L83:
	ld.w	%r0,0x0
__LX84:				; __L84:
	cmp	%r1,0x0
	jreq	__LX85		; 	xjreq	__L85
	cmp	%r0,0x0
	jreq	__LX86		; 	xjreq	__L86
	ld.w	%r12,%r1
	ld.w	%r13,%r0
	ld.w	%r14,[%sp+0x5]	; 	xld.w	%r14,[%sp+0x14]
	ld.w	%r11,[%sp+0x4]	; 	xld.w	%r11,[%sp+0x10]
	call	%r11
	cmp	%r10,0x0
	jrgt	__LX87		; 	xjrgt	__L87
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	call	InsertTailList	; 	xcall	InsertTailList
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,8
	add	%r12,0x8
	ld.w	%r13,%r0
	call	InsertHeadList	; 	xcall	InsertHeadList
	jp	__LX78		; 	xjp	__L78
__LX87:				; __L87:
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	call	InsertTailList	; 	xcall	InsertTailList
	ld.w	%r12,%sp
	ld.w	%r13,%r1
	call	InsertHeadList	; 	xcall	InsertHeadList
	jp	__LX78		; 	xjp	__L78
__LX86:				; __L86:
	ld.w	%r12,%r2
	ld.w	%r13,%r1
	call	InsertTailList	; 	xcall	InsertTailList
	jp	__LX78		; 	xjp	__L78
__LX85:				; __L85:
	cmp	%r0,0x0
	jreq	__LX79		; 	xjreq	__L79
	ld.w	%r12,%r2
	ld.w	%r13,%r0
	call	InsertTailList	; 	xcall	InsertTailList
	jp	__LX78		; 	xjp	__L78
__LX79:				; __L79:
	add	%sp,0x6		; 	xadd	%sp,%sp,24
	popn	%r3
	ret
