/*	
 *	clipcvid.h
 *
 *	CinepakfR[_
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2007 Naoyuki Sawa
 *
 *	* Fri Nov 16 16:28:45 JST 2007 Naoyuki Sawa
 *	- 1st [XB
 *	- ̂߂ɎQlɂAukeep/Cinepak.7zvɕۑ܂B
 *	* Fri Nov 16 22:35:55 JST 2007 Naoyuki Sawa
 *	- CVIDSTRIP\̂̕тA{v1[256],v4[256]}{v4[256],v1[256]} ɕύX܂B
 *	* Sat Nov 17 20:54:00 JST 2007 Naoyuki Sawa
 *	- CVIDCODEBOOKrbgtB[h̕тA{v0,v1,v2,v3}{v0,v2,v1,v3} ɕύX܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_CVID_H__
#define __CLIP_CVID_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

/*{{CAEgŒ*/
/* ǂ4sNZÂvbgł悤A{v0,v1,v2,v3}ł͂Ȃ{v0,v2,v1,v3}̕тƂ܂B
 * ڂ́AASMcvid_decode()̃\[XR[hQƂĂB
 */
typedef struct _CVIDCODEBOOK {
	unsigned char y0 : 4;	/* +0,1 */
	unsigned char y2 : 4;
	unsigned char y1 : 4;	/* +1,1 */
	unsigned char y3 : 4;
} CVIDCODEBOOK;			/* =2 */
/*}}CAEgŒ*/

/*{{CAEgŒ*/
/* v1v4̕gppx̂ŁAfANZXł悤Av1v4ɔzu܂B
 * ڂ́AASMcvid_decode()̃\[XR[hQƂĂB
 */
typedef struct _CVIDSTRIP {
	CVIDCODEBOOK v4[256];	/* +   0,512 */
	CVIDCODEBOOK v1[256];	/* + 512,512 */
} CVIDSTRIP;			/* =1024 */
/*}}CAEgŒ*/

typedef struct _CVIDDRIVER {
/*{{CAEgŒ*/
	SURFACE surface;					/* + 0,12 (+0=w,+2=h,+4=vbuff,+8=zbuff) */
	unsigned char* buffer/*[strh.dwSuggestedBufferSize]*/;	/* +12, 4 */
	int num_strips;						/* +16, 4 */
	CVIDSTRIP* strips/*[num_strips]*/;			/* +20, 4 */
/*}}CAEgŒ*/
	HMMIO mmio;		/* t@Cnh */
	MMCKINFO mmci_riff;	/* RIFF('AVI ')`N */
	MMCKINFO mmci_movi;	/* LIST('movi')`N */
	MMCKINFO mmci_rec;	/* LIST('rec ')`N (ckidɂēO𔻒f) */
	int stri;		/* Ԗڂ̃Xg[CinepakrfIXg[ */
	AVIStreamHeader strh;	/* Xg[wb_ (t[[gȂ) */
	BITMAPINFOHEADER strf;	/* Xg[tH[}bg (𑜓xȂ) */
	int loop;		/* 0=ĐI, 1`=c胋[v, -1=[v */
	int loop_pos;		/* [vʒũt@C|C^ */
} CVIDDRIVER;

extern CVIDDRIVER cvid_driver;

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef DEBUG
void cvid_enum(const char* fname);
#endif /*DEBUG*/

/* AVI`CinepakrfIXg[̃fR[h܂B
 * [in]
 *	fname		AVIt@CB
 *	loop		1` = [v, -1 = [vB
 * [out]
 *	cvid_driver
 *	.surface.w,h	4x4sNZ̔{ɐ؂グ𑜓xB
 *	.strh		t[Ԃ̃C^[o[ms]́Aȉ̎ŌvZł܂B
 *			=(1000*cvid_driver.strh.dwScale/cvid_driver.strh.dwRate)
 *	.strf		TCYBcvid_init()̃RgQƂĂB
 * [note]
 *	* cvid_init()ĂԂƁAĐt@CJ܂܂̏ԂƂȂ܂B
 *	  svɂȂAcvid_free()ĂяoāAt@CĂB
 */
void cvid_init(const char* fname, int loop);

/* fR[hIAt@C܂B
 */
void cvid_free();

/* 1t[AfR[h܂B
 * [out]
 *	߂l		ĐpȂ΁A0Ԃ܂B
 *			t[AĐIȂ΁A0ȊOԂ܂B
 *			cvid_init()ĂяoɃ[vw肵ꍇɂ́A
 *			K؂ȉ񐔃[vɁA0ȊO(ĐI)Ԃ܂B
 *	cvid_driver
 *	.surface.vbuff	Đp(߂l0)̏ꍇAt[̉摜i[܂B
 *			ĐI(߂l0ȊO)̏ꍇAO̓eێ܂B
 * [note]
 *	* AvP[VAcvid_driver.surface.vbuff̓eĂ͂܂B
 *	  Cinepak̓t[Ԃ̍XVłAt[̏o͕͂ωłB
 */
int cvid_update();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_CVID_H__*/
