/*
 *	clipcqr2.c
 *
 *	R[obNL[pDxt`(3D֘AW[Ɉˑ֐)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Sun Aug 06 22:33:03 JST 2017 Naoyuki Sawa
 *	- VK쐬B
 *	  W[쐬ŔAclipcqrd.h̓̃RgQƂĉB
 *	- W[̊֐gpƁA3D֘AW[(framds25.o)N܂B
 *	  SĂframds**.oNƖʂȂ̂ŁAAvP[VɂāAsvframds**.o̓NȂ悤ɂ̂]܂łB
 *	  ̓Iɂ́A/clip/test.pce/app.ćusvȕ`֐uăߖ񂷂vQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_render_polygon {
	RENDER*			render;			//+ 0, 4
	uint16_t		n_vertices;		//+ 4, 2
	uint16_t		color;			//+ 6, 2
	VERTEX			vertices[0];		//+ 8, 6*n_vertices
};							//= 8+ 6*n_vertices
static void fn_CbkQue_render_polygon(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_render_polygon* p = param;
	render_polygon(p->render, p->vertices, p->n_vertices, p->color);
}
/*--------------------------------------------------------------------------*/
//render_polygon()̗Dxto[W
void CbkQue_render_polygon(ST_CbkQue* pCbkQue, int pri, RENDER* render, const VERTEX* vertices, int n_vertices, int color) {
	struct ST_CbkQue_render_polygon* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_render_polygon, sizeof(struct ST_CbkQue_render_polygon) + (sizeof(VERTEX) * n_vertices));
	p->render		= render;
	p->n_vertices		= n_vertices;
	p->color		= color;
	memcpy(p->vertices, vertices, sizeof(VERTEX) * n_vertices);
}
/****************************************************************************
 *	
 ****************************************************************************/
struct ST_CbkQue_sprite_draw2 {
	 int16_t		x;			//+ 0, 2
	 int16_t		y;			//+ 2, 2
	uint16_t		sprno;			//+ 4, 2
	uint16_t		param;			//+ 6, 2
	fixed			scale_x;		//+ 8, 4
	fixed			scale_y;		//+12, 4
	fixed			rot;			//+16, 4
};							//=20
static void fn_CbkQue_sprite_draw2(ST_CbkQue* pCbkQue, int pri, void* param) {
	struct ST_CbkQue_sprite_draw2* p = param;
	sprite_draw2(p->x, p->y, p->sprno, p->param, p->scale_x, p->scale_y, p->rot);
}
/*--------------------------------------------------------------------------*/
//sprite_draw2()̗Dxto[W
void CbkQue_sprite_draw2(ST_CbkQue* pCbkQue, int pri, int x, int y, int sprno, int param, fixed scale_x, fixed scale_y, fixed rot) {
	struct ST_CbkQue_sprite_draw2* p = CbkQue_AddMem(pCbkQue, pri, fn_CbkQue_sprite_draw2, sizeof(struct ST_CbkQue_sprite_draw2));
	p->x			= x;
	p->y			= y;
	p->sprno		= sprno;
	p->param		= param;
	p->scale_x		= scale_x;
	p->scale_y		= scale_y;
	p->rot			= rot;
}
