/*	
 *	clipcosp.h
 *
 *	FԃCu
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2013-2017 Naoyuki Sawa
 *
 *	* Sun Jun 02 14:32:55 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	- P/ECEɃJ[\͂܂񂪁AIȌvZɗpAc[ŗp邽߂ɗpӂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Sun Dec 31 23:59:59 JST 2017 Naoyuki Sawa
 *	- RGBtoHSL(),HSLtoRGB()ǉ܂B
 *	  HSVFԂHSLFԂ̕AF,ʓxύXɋPxŔ܂Ŏčŝŕ֗łB
 */
#ifndef __CLIP_COSP_H__
#define __CLIP_COSP_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	HSVF
 ****************************************************************************/

//HSVFԂ̒` (QlURL:http://ja.wikipedia.org/wiki/HSVF)
//
//	F(Hue)        [0.0,1.0)
//	ʓx(Saturation) [0.0,1.0]	~fƉ~fAʓx̒`قȂBW[̎́A~fɑB
//	x(Value)      [0.0,1.0]
//
//	@@@H=0/6`1/6
//	@@@H=1/6`2/6
//	@@@H=2/6`3/6
//	@@@H=3/6`4/6
//	@@@H=4/6`5/6
//	@@@H=5/6`6/6
//	
//	qP_QQ^P
//	
//	f^PP_QQ
//	
//	aQQ^PP_
//	

/*--------------------------------------------------------------------------*/

/* RGBHSV֕ϊ܂B
 * [in]
 *	rgb[0]	[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 *	rgb[1]	[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 *	rgb[2]	[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 * [out]
 *	hsv[0]	F[0.0,1.0)
 *	hsv[1]	ʓx[0.0,1.0]
 *	hsv[2]	x[0.0,1.0]
 * [note]
 *	- rgb[]hsv[]̓GAXZ[tłAdȂ郁̈w\łB
 */
void RGBtoHSV(const double rgb[3], double hsv[3]);

/*--------------------------------------------------------------------------*/

/* HSVRGB֕ϊ܂B
 * [in]
 *	hsv[0]	F[0.0,1.0)	0.0,y,1.0ȏ́A[0.0,1.0)͈̔͂Ɋۂ߂܂B
 *	hsv[1]	ʓx[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 *	hsv[2]	x[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 * [out]
 *	rgb[0]	[0.0,1.0]
 *	rgb[1]	[0.0,1.0]
 *	rgb[2]	[0.0,1.0]
 * [note]
 *	- hsv[]rgb[]̓GAXZ[tłAdȂ郁̈w\łB
 */
void HSVtoRGB(const double hsv[3], double rgb[3]);

/****************************************************************************
 *	HSLF
 ****************************************************************************/

//HSLFԂ̒` (https://ja.wikipedia.org/wiki/HLSF)
//
//	F(Hue)        [0.0,1.0)
//	ʓx(Saturation) [0.0,1.0]	~fƉ~fAʓx̒`قȂBW[̎́A~fɑB
//	Px(Lightness)  [0.0,1.0]
//
//	@@@H=0/6`1/6
//	@@@H=1/6`2/6
//	@@@H=2/6`3/6
//	@@@H=3/6`4/6
//	@@@H=4/6`5/6
//	@@@H=5/6`6/6
//	
//	qP_QQ^P
//	
//	f^PP_QQ
//	
//	aQQ^PP_
//	

/*--------------------------------------------------------------------------*/

/* RGBHSL֕ϊ܂B
 * [in]
 *	rgb[0]	[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 *	rgb[1]	[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 *	rgb[2]	[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 * [out]
 *	hsl[0]	F[0.0,1.0)
 *	hsl[1]	ʓx[0.0,1.0]
 *	hsl[2]	Px[0.0,1.0]
 * [note]
 *	- rgb[]hsl[]̓GAXZ[tłAdȂ郁̈w\łB
 */
void RGBtoHSL(const double rgb[3], double hsl[3]);

/*--------------------------------------------------------------------------*/

/* HSLRGB֕ϊ܂B
 * [in]
 *	hsl[0]	F[0.0,1.0)	0.0,y,1.0ȏ́A[0.0,1.0)͈̔͂Ɋۂ߂܂B
 *	hsl[1]	ʓx[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 *	hsl[2]	Px[0.0,1.0]	0.00.0ɁC1.0߂1.0ɕ␳܂B
 * [out]
 *	rgb[0]	[0.0,1.0]
 *	rgb[1]	[0.0,1.0]
 *	rgb[2]	[0.0,1.0]
 * [note]
 *	- hsl[]rgb[]̓GAXZ[tłAdȂ郁̈w\łB
 */
void HSLtoRGB(const double hsl[3], double rgb[3]);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_COSP_H__*/
