/*	
 *	clipcosp.c
 *
 *	FԃCu
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2013-2017 Naoyuki Sawa
 *
 *	* Sun Jun 02 14:32:55 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	- P/ECEɃJ[\͂܂񂪁AIȌvZɗpAc[ŗp邽߂ɗpӂ܂B
 *	* Sun Dec 31 23:59:59 JST 2017 Naoyuki Sawa
 *	- RGBtoHSL(),HSLtoRGB()ǉ܂B
 *	  HSVFԂHSLFԂ̕AF,ʓxύXɋPxŔ܂Ŏčŝŕ֗łB
 */
#include "clip.h"

/****************************************************************************
 *	HSVF
 ****************************************************************************/

void RGBtoHSV(const double rgb[3], double hsv[3]) {
	double H, S, V, MAX, MIN, MAX_MIN;
	const double R = (rgb[0] < 0.0) ? 0.0 : (rgb[0] > 1.0) ? 1.0 : rgb[0];
	const double G = (rgb[1] < 0.0) ? 0.0 : (rgb[1] > 1.0) ? 1.0 : rgb[1];
	const double B = (rgb[2] < 0.0) ? 0.0 : (rgb[2] > 1.0) ? 1.0 : rgb[2];
	MAX = R; if(G > MAX) { MAX = G; } if(B > MAX) { MAX = B; }
	MIN = R; if(G < MIN) { MIN = G; } if(B < MIN) { MIN = B; }
	MAX_MIN = MAX - MIN;
	if(MAX_MIN != 0.0) {
		      if(MAX == R)  { H = (G - B) / MAX_MIN + 0.0; }
		else  if(MAX == G)  { H = (B - R) / MAX_MIN + 2.0; }
		else/*if(MAX == B)*/{ H = (R - G) / MAX_MIN + 4.0; }
		H /= 6.0;
		H -= floor(H);
		S  = MAX_MIN / MAX;
		V  = MAX;
	} else {
		H  = 0.0;
		S  = 0.0;
		V  = MAX;
	}
	hsv[0] = (H < 0.0) ? 0.0 : (H > 1.0) ? 1.0 : H;
	hsv[1] = (S < 0.0) ? 0.0 : (S > 1.0) ? 1.0 : S;
	hsv[2] = (V < 0.0) ? 0.0 : (V > 1.0) ? 1.0 : V;
}

/*--------------------------------------------------------------------------*/

void HSVtoRGB(const double hsv[3], double rgb[3]) {
	double R, G, B, Hi, f, p, q, t;
	const double H = (hsv[0] - floor(hsv[0]));
	      double S = (hsv[1] < 0.0) ? 0.0 : (hsv[1] > 1.0) ? 1.0 : hsv[1];
	const double V = (hsv[2] < 0.0) ? 0.0 : (hsv[2] > 1.0) ? 1.0 : hsv[2];
	S *= V;
	f = modf(H * 6.0, &Hi);
	p = V - (            S);
	q = V - (       f  * S);
	t = V - ((1.0 - f) * S);
	      if(Hi == 0.0)  { R = V; G = t; B = p; }
	else  if(Hi == 1.0)  { R = q; G = V; B = p; }
	else  if(Hi == 2.0)  { R = p; G = V; B = t; }
	else  if(Hi == 3.0)  { R = p; G = q; B = V; }
	else  if(Hi == 4.0)  { R = t; G = p; B = V; }
	else/*if(Hi == 5.0)*/{ R = V; G = p; B = q; }
	rgb[0] = (R < 0.0) ? 0.0 : (R > 1.0) ? 1.0 : R;
	rgb[1] = (G < 0.0) ? 0.0 : (G > 1.0) ? 1.0 : G;
	rgb[2] = (B < 0.0) ? 0.0 : (B > 1.0) ? 1.0 : B;
}

/****************************************************************************
 *	HSLF
 ****************************************************************************/

void RGBtoHSL(const double rgb[3], double hsl[3]) {
	double H, S, L, MAX, MIN, MAX_MIN;
	const double R = (rgb[0] < 0.0) ? 0.0 : (rgb[0] > 1.0) ? 1.0 : rgb[0];
	const double G = (rgb[1] < 0.0) ? 0.0 : (rgb[1] > 1.0) ? 1.0 : rgb[1];
	const double B = (rgb[2] < 0.0) ? 0.0 : (rgb[2] > 1.0) ? 1.0 : rgb[2];
	MAX = R; if(G > MAX) { MAX = G; } if(B > MAX) { MAX = B; }
	MIN = R; if(G < MIN) { MIN = G; } if(B < MIN) { MIN = B; }
	MAX_MIN = MAX - MIN;
	if(MAX_MIN != 0.0) {
		      if(MAX == R)  { H = (G - B) / MAX_MIN + 0.0; }
		else  if(MAX == G)  { H = (B - R) / MAX_MIN + 2.0; }
		else/*if(MAX == B)*/{ H = (R - G) / MAX_MIN + 4.0; }
		H /= 6.0;
		H -= floor(H);
		S  = MAX_MIN / (1.0 - fabs((MAX + MIN) - 1.0));
		L  = (MAX + MIN) / 2.0;
	} else {
		H  = 0.0;
		S  = 0.0;
		L  = (MAX + MIN) / 2.0;
	}
	hsl[0] = (H < 0.0) ? 0.0 : (H > 1.0) ? 1.0 : H;
	hsl[1] = (S < 0.0) ? 0.0 : (S > 1.0) ? 1.0 : S;
	hsl[2] = (L < 0.0) ? 0.0 : (L > 1.0) ? 1.0 : L;
}

/*--------------------------------------------------------------------------*/

void HSLtoRGB(const double hsl[3], double rgb[3]) {
	double R, G, B, Hi, f, p, q, t;
	const double H = (hsl[0] - floor(hsl[0]));
	      double S = (hsl[1] < 0.0) ? 0.0 : (hsl[1] > 1.0) ? 1.0 : hsl[1];
	      double L = (hsl[2] < 0.0) ? 0.0 : (hsl[2] > 1.0) ? 1.0 : hsl[2];
	S *= 1.0 - fabs((L * 2.0) - 1.0), L += S / 2.0;
	f = modf(H * 6.0, &Hi);
	p = L - (            S);
	q = L - (       f  * S);
	t = L - ((1.0 - f) * S);
	      if(Hi == 0.0)  { R = L; G = t; B = p; }
	else  if(Hi == 1.0)  { R = q; G = L; B = p; }
	else  if(Hi == 2.0)  { R = p; G = L; B = t; }
	else  if(Hi == 3.0)  { R = p; G = q; B = L; }
	else  if(Hi == 4.0)  { R = t; G = p; B = L; }
	else/*if(Hi == 5.0)*/{ R = L; G = p; B = q; }
	rgb[0] = (R < 0.0) ? 0.0 : (R > 1.0) ? 1.0 : R;
	rgb[1] = (G < 0.0) ? 0.0 : (G > 1.0) ? 1.0 : G;
	rgb[2] = (B < 0.0) ? 0.0 : (B > 1.0) ? 1.0 : B;
}

