/*	
 *	clipcoll.h
 *
 *	RNV
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Jan 06 21:26:41 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- RNV֘A̐錾Aclipmisc.hclipcoll.h֕܂B
 *	  RNV֘A̎͊ɁAclipmisc.cclipcoll.c֕Ă̂ŁA񕪗̂͐錾݂̂łB
 *	  錾邱ƂɂŔA錾Ǝ̃t@C̑ΉtAՂ邽߂łB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_COLL_H__
#define __CLIP_COLL_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*****************************************************************************
 *	[eBeBFRNṼwp֐
 *****************************************************************************/

/* wp֐̎: RNVǗsȂ|C^A܂́Al
 */
void* ptr_copy(void* a);
void  ptr_delete(void* a);
int   ptr_equals(void* a, void* b);

/* wp֐̎: RNVǗs
 * * map_put()́AnꂽRs[āARNVɕێ܂B
 * // * map_get()́ARs[AێĂ镶̃|C^̂܂ܕԂ܂B
 * //   KvɉāAmap_get()̌ĂяoÃRs[쐬ĂB
 * 2005/12/11 dlύX
 * * map_get()́AێĂ镶̃Rs[쐬āAĂяoɕԂ܂B
 *   map_get()̌ĂяóA̎gpIAstr_delete()gĕĂB
 *   str_delete()̎́APfree()sĂ邾Ȃ̂ŁAfree()gĉĂ\܂B
 */
void* str_copy(void* a);
void  str_delete(void* a);
int   str_equals(void* a, void* b);

/* wp֐̎: C^[tFCX|C^ (UNKNOWN_INTERFACE**)
 * * L[Ƃėpꍇ̓́AIuWFNgrłB
 *   IuWFNg̃C^[tFCXT|[gĂꍇA
 *   ̃IuWFNgɑ΂UNKNOWNC^[tFCX|C^́A݂܂B
 *   unk_equals()́ÄقȂC^[tFCX|C^𓙉ƌȂ܂B
 *   ̂悤ȋKvȂꍇ(PȂ|C^rŗǂꍇ)́A
 *   unk_equals()̑ɁAptr_equals()gĂB
 * * map_put()́AnꂽC^[tFCX|C^addref()āARNVɕێ܂B
 * // * map_get()́AC^[tFCX|C^addref()Â܂ܕԂ܂B
 * //   ̋́AQƃJEg̑[[[1-1]ɔAłB
 * //   KvɉāAmap_get()̌ĂяoAaddref()sĂB
 * //   ĂяoAaddref()sȂꍇ́Arelease()svłB
 * 2005/12/11 dlύX
 * * map_get()AC^[tFCX|C^addref()āAĂяoɕԂ悤ɂȂ܂B
 *   ĂяoAmap_get()ԂꂽC^[tFCX|C^ɑ΂Aaddref()Kv͂܂B
 *   ĂяóAԂꂽC^[tFCX|C^̎gpIArelease()sKv܂B
 *   ȏ̋́AQƃJEg̑[[[1-1]ɏĂ܂B
 *   Ȃ킿A2005/12/11̎dlύXɂAmap_get()̋ʈKvȂ܂B
 */
void* unk_copy(void* a);
void  unk_delete(void* a);
int   unk_equals(void* a, void* b);

/*****************************************************************************
 *	[eBeBF}bv (RNV)
 *****************************************************************************/

/* }bv */
typedef struct _MAP_INFO {
	void* (*key_copy)(void* key);			/* L[𕡐Awp֐ */
	void  (*key_delete)(void* key);			/* L[폜Awp֐ */
	int   (*key_equals)(void* key1, void* key2);	/* L[rAwp֐ */
	void* (*val_copy)(void* val);			/* l  𕡐Awp֐ */
	void  (*val_delete)(void* val);			/* l  폜Awp֐ */
} MAP_INFO;

/* }bv */
typedef struct _MAP {
	LIST_ENTRY list_head;	/* MAP_NODẼXgwb_ */
	MAP_INFO map_info;	/* }bv */
} MAP;

/* }bvvf
 * * Kx[WRNVgp\Ƃ邽߂ɁA}bvvfƃXgGg̐擪AhX𑵂Ă܂B
 *   ҂̃AhXĂƁAKx[WRN^J̃}bvvfĊJĂ܂߂łB
 * - Kx[WRNV̎gp͕K{ł͂܂B
 *   MAP\̂MAP_NODE\̂̃J́ACuIɍsĂ܂B
 *   L[ƒl̃Ǘ́AAvP[V`̃wp֐ɂāAIɍsƂ\łB
 * - Kx[WRNVgƁAIȁAL[ƒl̃ȗAwp֐ȗł܂B
 */
typedef struct _MAP_NODE {
	LIST_ENTRY list_entry;	/* MAP_NODẼXgGg */
	void* key;		/* L[ (ۂ̌^̓AvP[V`) */
	void* val;		/* l   (ۂ̌^̓AvP[V`) */
} MAP_NODE;

/* }bv쐬܂B
 * [in]
 *	map_info	}bvB
 * [out]
 *	߂l		}bvB
 */
MAP* map_create(const MAP_INFO* map_info);

/* }bv폜܂B
 * [in]
 *	map		}bvB
 * [note]
 *	* Imap_clear()ĂсAcĂ}bvvfׂč폜܂B
 *	  Imap_clear()ĂłKv͂܂B
 */
void map_delete(MAP* map);

/* }bv̑Svf폜܂B
 * [in]
 *	map		}bvB
 * [note]
 *	* e}bvvfɂāAkey_delete()wp֐pāAL[폜܂B
 *	                        val_delete()wp֐pāAl  폜܂B
 */
void map_clear(MAP* map);

/* w肳ꂽL[ɑΉ}bvvfL邩A肵܂B
 * [in]
 *	map		}bvB
 *	key		L[B
 * [out]
 *	߂l		}bvvfL΁A  0ȊO̒lԂ܂B
 *			}bvvf΁A0Ԃ܂B
 */
int map_contains(MAP* map, void* key);

/* w肳ꂽL[ɑΉ}bvvf쐬Ali[܂B
 * [in]
 *	map		}bvB
 *	key		L[B
 *	val		lB
 * [note]
 *	* key_copy()wp֐pāAL[𕡐A}bvvfɊi[܂B
 *	  AvP[V́AĂяoɎw肵keyێKv͂܂B
 *	  Akey_copy()wp֐sȂꍇ́Ǎł͂܂B
 *	* val_copy()wp֐pāAl𕡐A}bvvfɊi[܂B
 *	  AvP[V́AĂяoɎw肵valێKv͂܂B
 *	  Aval_copy()wp֐sȂꍇ́Ǎł͂܂B
 *	* ɁAw肳ꂽL[ɑΉl݂ꍇ́A̒l폜܂B
 *	  ̒l̍폜ɂ́Aval_delete()wp֐p܂B
 */
void map_put(MAP* map, void* key, void* val);

/* w肳ꂽL[ɑΉ}bvvf́Al擾܂B
 * [in]
 *	map		}bvB
 *	key		L[B
 * [out]
 *	߂l		lB
 * [note]
 *	* w肳ꂽL[ɑΉ}bvvf݂Ȃꍇ́AAT[g܂B
 *	  map_contains()pāAL[ɑΉ}bvvf݂邱ƂmFĂB
 *	  <>	if(map_contains(map, key)) {
 *			val = map_get(map, key);
 *			...
 *			free(val); // 2005/12/11̎dlύXɂAl̉KvƂȂ܂B
 *		}
 *	// * ԂĺAł͂ȂA}bvvfێĂl̂܂ܕԂ܂B
 *	//   ĂяoAvP[VɂāAԂꂽl폜Ă͂܂B
 *	//2005/12/11 dlύX
 *	* map_get()́Aval_copy()wp֐pĒl̕쐬A̕Ԃ܂B
 *	  Ԃꂽl̏ĹAmap_get()Ăяô݂ɗL܂B
 *	  map_get()ĂяóAԂꂽlK؂ɉ邱ƂYȂłB
 */
void* map_get(MAP* map, void* key);

/* w肳ꂽL[ɑΉ}bvvf폜܂B
 * [in]
 *	map		}bvB
 *	key		L[B
 * [note]
 *	* w肳ꂽL[ɑΉ}bvvf݂Ȃꍇ́AAT[g܂B
 *	  map_contains()pāAL[ɑΉ}bvvf݂邱ƂmFĂB
 *	  <>	if(map_contains(map, key)) {
 *			map_remove(map, key);
 *		}
 *	* 폜}bvvf̃L[́Akey_delete()wp֐pāAIɍ폜܂B
 *	  폜}bvvf̒l  ́Aval_delete()wp֐pāAIɍ폜܂B
 */
void map_remove(MAP* map, void* key);

/* }bv𕡐܂B
 * [in]
 *	map		̃}bvB
 * [out]
 *	߂l		}bvB
 * [note]
 *	* ̊֐śAȉ̂ƂłB
 *	  1. ̃}bvƓ}bvÃ}bv쐬܂B
 *	     ꂪÃ}bvƂȂ܂B
 *	  2. ̃}bv̊evf̃L[ƒlɂāAkey_copyval_copy()wp֐pĕA
 *	     ̃}bv֒ǉ܂B
 *	  3. ̃}bvԂ܂B
 */
MAP* map_duplicate(MAP* map);

/* }bvvfɊ܂܂ĂAׂẴL[琬AXg쐬܂B
 * [in]
 *	map		}bvB
 * [out]
 *	߂l		XgB
 * [note]
 *	* 쐬ꂽXg̃wp֐́A쐬̃}bṽwp֐̈ꕔƓƂȂ܂B
 *	  Xg̃wp֐ƁA}bṽwp֐Ƃ̑Ή́Aȉ̂ƂłB
 *		==== 쐬̃}bv ====    ==== 쐬ꂽXg ====
 *		map->map_info.key_copy    list->list_info.val_copy  
 *		map->map_info.key_delete  list->list_info.val_delete
 *		map->map_info.key_equals  g܂
 *		map->map_info.val_copy    g܂
 *		map->map_info.val_delete  g܂
 *	* ԂꂽXgsvɂȂAĂяoɂlist_delete()sAXg폜ĂB
 */
struct _LIST* map_keys(MAP* map);

/* }bv󂩔ۂׂ܂B
 * [in]
 *	map		}bvB
 * [out]
 *	߂l		Ȃ0ȊOԂ܂B
 *			łȂ0Ԃ܂B
 */
int map_empty(MAP* map);

/*****************************************************************************
 *	[eBeBFXg (RNV)
 *****************************************************************************/

/* Xg */
typedef struct _LIST_INFO {
	void* (*val_copy)(void* val);	/* l𕡐Awp֐ */
	void  (*val_delete)(void* val);	/* l폜Awp֐ */
} LIST_INFO;

/* Xg */
typedef struct _LIST {
	LIST_ENTRY list_head;	/* LIST_NODẼXgwb_ */
	LIST_INFO list_info;	/* Xg */
} LIST;

/* Xgvf
 * * Kx[WRNVgp\Ƃ邽߂ɁAXgvfƃXgGg̐擪AhX𑵂Ă܂B
 *   ҂̃AhXĂƁAKx[WRN^J̃XgvfĊJĂ܂߂łB
 * - Kx[WRNV̎gp͕K{ł͂܂B
 *   LIST\̂LIST_NODE\̂̃J́ACuIɍsĂ܂B
 *   l̃Ǘ́AAvP[V`̃wp֐ɂāAIɍsƂ\łB
 * - Kx[WRNVgƁAIȁAl̃ȗAwp֐ȗł܂B
 */
typedef struct _LIST_NODE {
	LIST_ENTRY list_entry;	/* LIST_NODẼXgGg */
	void* val;		/* l (ۂ̌^̓AvP[V`) */
} LIST_NODE;

/* Xg쐬܂B
 * [in]
 *	list_info	XgB
 * [out]
 *	߂l		XgB
 */
LIST* list_create(const LIST_INFO* list_info);

/* Xg폜܂B
 * [in]
 *	list		XgB
 * [note]
 *	* Ilist_clear()ĂсAcĂ}bvvfׂč폜܂B
 *	  Ilist_clear()ĂłKv͂܂B
 */
void list_delete(LIST* list);

/* Xg̑Svf폜܂B
 * [in]
 *	list		XgB
 * [note]
 *	* eXgvfɂāAval_delete()wp֐pāAl폜܂B
 */
void list_clear(LIST* list);

/* Xg̗vf擾܂B
 * [in]
 *	list		XgB
 * [out]
 *	߂l		vfB
 */
int list_size(LIST* list);

/* CfNXɂĎw肳ꂽʒuɁAli[܂B
 * [in]
 *	list		XgB
 *	index		CfNXB(0`size-1)
 *	val		lB
 * [note]
 *	* CfNX́ALȈʒu(0ȏAzTCY)łȂ΂Ȃ܂B
 *	  ͈̔͊ÕCfNXw肳ꂽꍇ́AAT[g܂B
 *	  ̃Xgɑ΂Ă̊֐Ăяoꍇ́AɃAT[g܂B
 *	* val_copy()wp֐pāAl𕡐AXgvfɊi[܂B
 *	  AvP[V́AĂяoɎw肵valێKv͂܂B
 *	  Aval_copy()wp֐sȂꍇ́Ǎł͂܂B
 *	* w肳ꂽʒuɑ݂̒ĺAIɍ폜܂B
 *	  ̒l̍폜ɂ́Aval_delete()wp֐p܂B
 */
void list_set(LIST* list, int index, void* val);

/* CfNXɂĎw肳ꂽʒúAl擾܂B
 * [in]
 *	list		XgB
 *	index		CfNXB(0`size-1)
 * [out]
 *	߂l		lB
 * [note]
 *	* CfNX́ALȈʒu(0ȏAzTCY)łȂ΂Ȃ܂B
 *	  ͈̔͊ÕCfNXw肳ꂽꍇ́AAT[g܂B
 *	  ̃Xgɑ΂Ă̊֐Ăяoꍇ́AɃAT[g܂B
 *	* list_get()́Aval_copy()wp֐pĒl̕쐬A̕Ԃ܂B
 *	  Ԃꂽl̏ĹAlist_get()Ăяô݂ɗL܂B
 *	  list_get()ĂяóAԂꂽlK؂ɉ邱ƂYȂłB
 */
void* list_get(LIST* list, int index);

/* Xg̖ɁAlǉ܂B
 * [in]
 *	list		XgB
 *	val		lB
 * [note]
 *	* "list_insert(list, list_size(list), val)"ƓłB
 */
void list_add(LIST* list, void* val);

/* CfNXɂĎw肳ꂽʒuɁAlǉ܂B
 * [in]
 *	list		XgB
 *	index		CfNXB(0`size)
 *	val		lB
 * [note]
 *	* CfNX́ALȈʒu(0ȏAzTCY)A܂́A(=zTCY)łȂ΂Ȃ܂B
 *	  ͈̔͊ÕCfNXw肳ꂽꍇ́AAT[g܂B
 *	* val_copy()wp֐pāAl𕡐AXgvfɊi[܂B
 *	  AvP[V́AĂяoɎw肵valێKv͂܂B
 *	  Aval_copy()wp֐sȂꍇ́Ǎł͂܂B
 *	* CfNXɁAzTCYw肵ꍇAǉʒu̗vf́AЂƂÂAֈړ܂B
 */
void list_insert(LIST* list, int index, void* val);

/* CfNXɂĎw肳ꂽʒúAl폜܂B
 * [in]
 *	list		XgB
 *	index		CfNXB(0`size-1)
 * [note]
 *	* CfNX́ALȈʒu(0ȏAzTCY)łȂ΂Ȃ܂B
 *	  ͈̔͊ÕCfNXw肳ꂽꍇ́AAT[g܂B
 *	  ̃Xgɑ΂Ă̊֐Ăяoꍇ́AɃAT[g܂B
 *	* w肳ꂽʒuɑ݂̒ĺAIɍ폜܂B
 *	  ̒l̍폜ɂ́Aval_delete()wp֐p܂B
 *	* 폜ʒu̗vf́AЂƂÂAOֈړ܂B
 */
void list_remove(LIST* list, int index);

/* Xg𕡐܂B
 * [in]
 *	list		̃XgB
 * [out]
 *	߂l		XgB
 * [note]
 *	* ̊֐śAȉ̂ƂłB
 *	  1. ̃XgƓXgÃXg쐬܂B
 *	     ꂪÃXgƂȂ܂B
 *	  2. ̃Xg̊evf̒lɂāAval_copy()wp֐pĕA
 *	     ̃Xg֒ǉ܂B
 *	  3. ̃XgԂ܂B
 */
LIST* list_duplicate(LIST* list);

/* Xg󂩔ۂׂ܂B
 * [in]
 *	list		XgB
 * [out]
 *	߂l		Ȃ0ȊOԂ܂B
 *			łȂ0Ԃ܂B
 * [note]
 *	* Xg󂩔ۂ𒲂ׂ邾Ȃ΁A
 *		if(!list_size(list)) { ̏ꍇ̏ } else { łȂꍇ̏ }
 *	  ƂA
 *		if(list_empty(list)) { ̏ꍇ̏ } else { łȂꍇ̏ }
 *	  ƂłB
 */
int list_empty(LIST* list);

/*****************************************************************************
 *	[eBeBFv[ (RNV)
 *****************************************************************************/

#if 0 /*{{2006/12/06:pool_free()ԋpv[̈svƂύXɂ폜*/
///* * Mon Dec 04 16:24:06 JST 2006 Naoyuki Sawa
// * - malloc()Afree()̃I[o[wbh邽߂́AubNv[łB
// *   IȁAv[̏ƃN[AbvsȂėǂ̂łB
// * - ȉ̂悤ɗpĂB
// *
// * @POOL\̂AO[oϐ(܂staticϐ)ƂĒ`ĂB
// *   `ƓɁAsizeoubNPʂ̃TCYɏĂB
// *
// *	POOL foo_pool = { sizeof(FOO) };
// *
// * Apool_alloc()ĂяoāAubNmۂĂB
// *   K؂ɁAq[v܂̓v[烁ubN蓖Ă܂B
// *   蓖ĂɎsꍇ́Apool_alloc()ŃAT[ĝŁA߂lKv͂܂B
// *   ԂꂽubŃApool_alloc()ɂă[NAĂ܂B
// *
// *	int main(int argc, char* argv[]) {
// *		FOO* foo1 = pool_alloc(&foo_pool);
// *
// * Bpool_free()ĂяoāAsvɂȂubNv[ɕԂĂB
// *
// *		pool_free(&foo_pool, foo1);
// *
// * CŏIIȁAv[̃N[Abv͕svłB
// *   蓖ĂubNSăv[ɕԂꂽ^C~OŁAIɑSăq[vɕԂ܂B
// *
// *		foo1 = pool_alloc(&foo_pool);	// 蓖Đ1Av[0 (q[vm)
// *		foo2 = pool_alloc(&foo_pool);	// 蓖Đ2Av[0 (q[vm)
// *		pool_free(&foo_pool, foo1);	// 蓖Đ1Av[1 (v[֕Ԃ)
// *		foo3 = pool_alloc(&foo_pool);	// 蓖Đ2Av[0 (v[m)
// *		pool_free(&foo_pool, foo2);	// 蓖Đ1Av[1 (v[֕Ԃ)
// *		pool_free(&foo_pool, foo3);	// 蓖Đ0Av[2 (v[֕Ԃ)(q[v֕Ԃ)v[0
// *
// * - ł͍\FOÔ߂foo_poolpӂĂ܂A̍\̂ň̃v[L邱Ƃ\łB
// *   Ƃ΁A\FOOBARň̃v[LꍇA傫̍\̃TCYPOOL.sizeɐݒ肵ĂB
// * - 蓖ĐЂς0ɖ߂悤Ȋ蓖/Jp^[̏ꍇAI[o[wbhጸȂꍇ܂B
// *
// *		foo1 = pool_alloc(&foo_pool);	// 蓖Đ1Av[0 (q[vm)
// *		pool_free(&foo_pool, foo1);	// 蓖Đ0Av[1 (v[֕Ԃ)(q[v֕Ԃ)v[0
// *		foo2 = pool_alloc(&foo_pool);	// 蓖Đ1Av[0 (q[vm)
// *		pool_free(&foo_pool, foo2);	// 蓖Đ0Av[1 (v[֕Ԃ)(q[v֕Ԃ)v[0
// *		foo3 = pool_alloc(&foo_pool);	// 蓖Đ1Av[0 (q[vm)
// *		pool_free(&foo_pool, foo3);	// 蓖Đ0Av[1 (v[֕Ԃ)(q[v֕Ԃ)v[0
// *
// * - 4oCg]vɊ蓖ĂĐ擪ɕԋpv[ւ̃|C^i[A[U[ɂ+4̈ʒu@܂B
// *   ̂悤ɂ΁Apool_free()ԋpv[̈svɂȂ֗Ȃ̂łA͍̗p܂łB
// *   [U[ێ|C^ubN擪wĂȂƁAK[x[WRN^ƕpłȂȂ邩łB
// */
//typedef struct _POOL {
//	int size;			/* 蓖Ă郁ubNPʂ̃oCg */
//	int cnt;			/* (蓖ĉ - J) */
//	struct _POOL_NODE* first;	/* v[̍ŏ̃ubNւ̃N (NULL=) */
//} POOL;
//
//typedef struct _POOL_NODE {
//	struct _POOL_NODE* next;	/* v[̎̃ubNւ̃N (NULL=I[) */
//} POOL_NODE;
//
///* ubNmۂ܂B
// * [in]
// *	pool		v[B
// * [out]
// *	߂l		ubNB
// */
//void* pool_alloc(POOL* pool);
//
///* ubNJ܂B
// * [in]
// *	pool		v[B
// *	ptr		ubNB
// */
//void pool_free(POOL* pool, void* ptr);
#endif /*}}2006/12/06:pool_free()ԋpv[̈svƂύXɂ폜*/
// * Wed Dec 06 03:36:51 JST 2006 Naoyuki Sawa
// - pool_free()ԋpv[̈svƂ܂B
//   ubN12oCg̃I[o[wbh܂AgՂD悵Ă̂悤ȎdlɕύX܂B
// - 蓖Ē̃ubN擪`FC邱ƂŁAK[x[WRNV̑ΏۂƂȂ邱Ƃhł܂B
//   Ȃ̂悤ȑ΍􂪕Kv́ÃRgAEgubÑRǵAŌ̕QƂĂB
// - pool_free()ԋpv[̈svƂƈȊÓAgp@͕ςĂ܂B
//   ̃RgAEgubÑRgQƂĂB

/* * Tue Jan 02 22:11:35 JST 2007 Naoyuki Sawa
 * - v[ɁAQƃJEgK[x[WRNV̋@\܂B
 * - v[mۂubŃAɃv[Ƀ`FCɂĂ邽߁AsvɂȂubN𔻒fłAʏGCŉł܂B
 *   ŁAQƃJEgK[x[WRNV̋@\邱Ƃɂ܂B
 * - ̋@\̓v[ɒڊ֌Ŵ@\ł͂ȂAPȊmۂƉ̊ǗȂ΁AK[x[WRNV̎dg݂͕svłB
 *   Ảӏ烁ubNL悤ȎgꍇAKvɂȂ@\ł܂B
 *   KvȏꍇAAvP[VŎQƃJEg̊Ǘs@܂AȒP̂߁Av[̋@\ɓĂ܂Ƃɂ܂B
 * - ̋@\ǉɂAvP[VC^[tFCX̕ώApool_lock()ƂłB
 *   pool_alloc()̎QƃJEg1łApool_free()0ɂȂĉ̂ŁÃAvP[Vւ̉e͂܂B
 *   ubN4oCg̃I[o[wbh(QƃJEg̕)Ă܂܂A܂Ae͈͂Ǝv܂B
 * - NULL|C^ɑ΂pool_lock()pool_free()͉sȂ悤ɂ܂B
 *   ]āA郁ubNp̎QƃJEg𑝂₷ꍇɁApNULLł邩ۂ𔻒fKv͂܂B
 *   pNULLȂ΁As܂B
 *
 *	<>
 *		void MyClass_constructor(MyClass* This, void* p) {
 *			This->p = p;
 *			pool_lock(This->p); // pNULLłv
 *		}
 *		void MyClass_destructor(MyClass* This) {
 *			pool_free(This->p); // pNULLłv
 *		}
 *
 * - ʏGCƂ̕p\łB
 *   ̏ꍇAmalloc()/free()ŊmہEIuWFNg̓}[N&XC[vGCA
 *   pool_alloc()/pool_free()/pool_lock()ŊmہEIuWFNg͎QƃJEgGCAƁAGC݂邱ƂɒӂĂB
 * - ȉɁAgp܂B
 *
 *	void main() {
 *		void* p;
 *		p = pool_alloc(&pool);	// QƃJEg=1
 *		foo1(p);		// QƃJEg=2
 *		foo2(p);		// QƃJEg=3
 *		pool_free(p);		// QƃJEg=2
 *		bar1(p);		// QƃJEg=1
 *		bar2(p);		// QƃJEg=0 -> 
 *	}
 *
 *	void* g_ptr1;
 *	void foo1(void* p) {
 *		g_ptr1 = p;
 *		pool_lock(g_ptr1);	// QƃJEg+1
 *	}
 *	void bar1() {
 *		pool_free(g_ptr1);	// QƃJEg-1
 *		g_ptr1 = NULL;
 *	}
 *
 *	void* g_ptr2;
 *	void foo2(void* p) {
 *		g_ptr2 = p;
 *		pool_lock(g_ptr2);	// QƃJEg+1
 *	}
 *	void bar2() {
 *		pool_free(g_ptr2);	// QƃJEg-1
 *		g_ptr2 = NULL;
 *	}
 *
 */

/* * Sat Mar 14 21:13:42 JST 2009 Naoyuki Sawa
 * - v[ɁAmێR[obNƉR[obNǉ܂B
 * - ȉɁAgp܂B
 *
 *	void foo_init_proc(void* data) {
 *		// mۂubŃAʏȂ
 *	}
 *	void foo_free_proc(void* data) {
 *		// 郁ubŃAʃN[AbvȂ
 *	}
 *	POOL foo_pool = { sizeof(FOO), foo_init_proc, foo_free_proc };
 *	void main() {
 *		FOO* foo = pool_alloc(&foo_pool);	// foo_init_proc()Ăяo܂B
 *		pool_lock(foo);		// QƃJEg=2
 *		pool_free(foo);		// QƃJEg=1
 *		pool_free(foo);		// QƃJEg=0Bfoo_free_proc()Ăяo܂B
 *	}
 */

//{{2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
//typedef struct _POOL {
//	int size;		/* ̃tB[hA[U[ݒ肵Ă */
//	int init;		/* (gp: ς or ̔fp) */
//	LIST_ENTRY alloc_list;	/* (gp: 蓖ĒubN̐擪`FCAGCh) */
//	LIST_ENTRY free_list;	/* (gp: ꂽubN̐擪`FCĕێ) */
//} POOL;
//2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX
typedef struct _POOL {
	int size;			/* 蓖Ă郁ubÑoCgB([U[ݒ肵Ă) */
	void (*init)(void* data);	/* mێR[obNB([U[ݒ肵ĂBsvȂNULL) */
	void (*free)(void* data);	/* R[obNB([U[ݒ肵ĂBsvȂNULL) */
	int mark;			/* (gp: ς or ̔fp) */
	LIST_ENTRY alloc_list;		/* (gp: 蓖ĒubN̐擪`FCAGCh) */
	LIST_ENTRY free_list;		/* (gp: ꂽubN̐擪`FCĕێ) */
} POOL;
//}}2009/03/14:mێR[obNƉR[obNǉ邽߂ɕύX

typedef struct _POOL_NODE {			/* (gp) */
	LIST_ENTRY list_entry;			/* POOL.alloc_listA܂́APOOL.free_listɃ`FC */
	POOL* pool;				/* ̃ubN̊蓖Čv[ւ̃|C^ */
	/*{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
	int ref_cnt;				/* QƃJEg */
	/*}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
	/*unsigned char data[pool->size];*/	/* [U[ɂ́Ä̗̐擪AhXԂ܂ */
} POOL_NODE;

/* ubNmۂ܂B
 * [in]
 *	pool		v[B
 * [out]
 *	߂l		ubNB
 * [note]
 *	{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\
 *	- ubNmۂ́AQƃJEg̏l1łB
 *	}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\
 */
void* pool_alloc(POOL* pool);

/* ubNJ܂B
 * [in]
 *	data		ubNB
 *			NULLȂ΁As܂B
 * [note]
 *	{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\
 *	- QƃJEg炵AQƃJEgcĂ܂B
 *	}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\
 */
void pool_free(void* data/*NULLOK*/);

/*{{2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/
/* QƃJEg𑝂₵܂B
 * [in]
 *	data		ubNB
 *			NULLȂ΁As܂B
 */
void pool_lock(void* data/*NULLOK*/);
/*}}2007/01/02ǉ: QƃJEgK[x[WRNV̋@\*/

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif//__CLIP_COLL_H__
