/*	
 *	clipbmgc.c
 *
 *	Bitmap GC
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Fri Dec 12 00:29:38 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Dec 12 21:20:33 JST 2014 Naoyuki Sawa
 *	- gc_scan()AZu܂B
 *	  W[̋@\Ƃ͒ڊ֌WL܂񂪁Agc_scan()́yX^bNt[1߂ŊJHvz̓KpɂȂĂ܂B
 *	- gc_mark()AZu܂B
 *	- ȏ̃AZusÁuP/ECEpK[x[WRN^[vƂ̑xrsČ܂B
 *	  TclC^v^őxrƂAclipgc.cclipbmgc.c̕A27%ɂȂ܂B
 *	  ́Aɒ[Ƀߖ񂪕KvȃAvP[VAuBitmap GCvgpǂłB
 *	* Sat Dec 13 11:52:53 JST 2014 Naoyuki Sawa
 *	- ܂ŁAGC\̂SRAM͈͂ێĂ܂Aq[v͈͂ێ悤ɕύX܂B
 *	  悭lAGC̃}[NΏۂ́ASRAMŜł͂ȂAq[v͈͂ŗǂƂɋCtłB
 *	  (pceHeapAlloc()ɂāAubN蓖Ă͈͂́Aq[v͈͂łB)
 *	  L̂悤ɕύX邱ƂɂāABitmap̃TCY炷ł郁bg܂B
 *	- L̕ύX́A'clipgc.c'ɂKp\Ȃ̂łA'clipgc.c'ɂ͓KpȂƂɂ܂B
 *	  'clipgc.c'͂܂ŒԎgpė̂ŁAA傫ȕύX̂͏|ƎvłB
 *	* Sat Dec 13 13:46:03 JST 2014 Naoyuki Sawa
 *	- uBitmapPʂ܂ubŃA㔼BitmapPʓ̃AhXQƂ|C^LĂAubNJĂ܂oOvC܂B
 *	  ܂ł͏L̃oÔ߂ɁAӐ}'ϋɓI'GC̋ƂȂĂ܂Ă܂B
 *	  L̃oOĈŁAӐ}ʂ'ێI'GC̋ƂȂ܂B
 *	* Sun Dec 14 01:27:04 JST 2014 Naoyuki Sawa
 *	- ȉ_̕ύXsA܂B
 *	- pceHeapAlloc()Aq[v擪瑖ŝł͂ȂAŌɊ蓖ĂubN瑖p悤ɂ܂B
 *	- pceHeapFree()͉Ȃ悤ɂAJBitmapGC_Run()ɏW񂵂܂B
 *	  _gc.phmwĂ郁ubNJȂ悤ɂ邽߂łB
 *	* Mon Dec 15 21:12:11 JST 2014 Naoyuki Sawa
 *	- pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
 *	- pceFileCreate(),pceFileDelete()́AJ[lpceHeapAlloc()ɐÓINĂ܂B
 *	  q[v̎ceʂ4KB̂ƂɁALAPIĂяoƁABitmapGC_Run()NꂸAAPIs܂B
 *	  ŁApceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()sA\Ȍq[v󂯂邱Ƃɂ܂B
 *	- LAPÍAJ[lpceHeapFree()ɂÓINĂAW[ɂpceHeapFree()̖̑ΏۊOƂȂĂ܂܂AL܂B
 *	  pceFileCreate(),pceFileDelete()́AAPI̊JnɊmۂubNAAPȈIOɊJ邩łB
 *	  AvP[V猩΁Aq[v̏Ԃ́ApceFileCreate(),pceFileDelete()ĂяoOƏ̌ƂŁAς܂B
 *	- ɂ́ApceFileCreate(),pceFileDelete()łȂApceFileRename()pceFileLoad()ɂl̑΍􂪕KvȂ̂łA͑΍􂵂ȂƂɂ܂B
 *	  pceFileRename(),pceFileLoad()́AAvP[V痘pȂƔfłB
 *	  fRɂẮAclippce.ćuq[v}l[WAPI̔rv́A'{{2014/09/05ǋL:'̃RgQƂĂB
 *	* Fri Dec 19 22:30:18 JST 2014 Naoyuki Sawa
 *	- _gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
 */
#include "clip.h"

//note
//{IȃASÝAclipgc.cƓłB
//W[ł́AڍׂȃRg͏ȗ܂BɂẴRǵAclipgc.cQƂĂB

//note
//clipgc.cłgc_scan()FRAM4]ɓ]č܂Aclipbmgc.cłgc_scan()SRAMŎs邱Ƃɂ܂B
//clipbmgc.cłgc_scan()̂̏ȂAbitarray_lsb1st_set()̏āAgc_scan()FRAM4]ɓ]ĂʂłB
//ČƂAgc_scan()FRAM4]ɓ]ĂA0.5%x܂łB
//0.5%x̍Ȃ΁AvOȌɕۂLvƎv̂ŁAgc_scan()FRAM4]ɓ]ȂƂɂ܂B

//note
//邽߂'frambary.o'RAMɔzu邱Ƃ́Ał͗L܂B
//W[bitarray_lsb1st_test()𑽗pĂ̂ŁAbitarray_lsb1st_test()ŎgpĂbitarray_lsb1st_get()ƁAʂ悤Ɏvm܂B
//ۂ́Abitarray_lsb1st_test()́Aɗ̓[hPʂŃeXg悤ɍHvĂAbitarray_lsb1st_get()ɂ͂قǈˑĂ܂B
//'frambary.o'RAMɔzuĂABitmap GC𗘗pAvP[VŜ̐\́A1%x܂łB(TclC^v^Ŏ܂)

//note
//_gc.phmA̋󂫃ubNłȂAŌɊ蓖ĂubNێ悤ɂŔAȉ̒ʂłB
//̋󂫃ubNێ悤ɂƁA̒ÕubNTCYꂽꍇɁAǗ\̂łȂʒuwĂ܂B
//΂āA蓖čς݃ubNwĂ΁AꂪTCYĂ薳B
//W[pceHeapFree()tbNĖĂ̂ŁAmȂƂŊ蓖čς݃ubNJ댯B
//ABitmapGC_Init(),BitmapGC_Run()̒̂݁Aq[v擪̋󂫃ubNwĂ邪AÕTCY̊댯̂ňSłB

/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _GC {														//AsmłœKՂtB[hяɂ܂B
	uint32_t		heapsize;							//+ 0,4 q[vTCY[byte]	(0:)	
	HEAPMEM*		heaptop;							//+ 4,4 q[v擪AhX						
	uint32_t*		bitmap;								//+ 8,4 Bitmap					gc_scanQƂ	gc_markQƂ
	uint8_t			unit;								//+12,1 1rbg(1<<unit)[byte]ɑ				
	//											//+13,3 (pfBO)
	HEAPMEM*		phm;								//+16,4 ŌɊ蓖ĂubN̊Ǘ\̂̃AhX	LnoteQƂ
	void*			(*old_pceHeapAlloc)(unsigned long size);			//+20,4 pceHeapAlloc()ۑ
	int			(*old_pceHeapFree)(void* memp);					//+24,4 pceHeapFree()ۑ
//{{2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
	int			(*old_pceFileCreate)(const char* fname, unsigned long size);	//+28,4 pceFileCreate()ۑ
	int			(*old_pceFileDelete)(const char* fname);			//+32,4pceFileDelete()ۑ
//}}2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
} GC;												//=36
static GC _gc;
/*--------------------------------------------------------------------------*/
#define HMO_NOREF_USER		0x1111						//ǂQƂĂȂHMO_DEFAULT_USER
/*--------------------------------------------------------------------------*/
static void _gc_run() __attribute__((unused));
#ifndef PIECE
static int gc_scan(void* top, void* end);
static int gc_mark(HEAPMEM* phm);
static void gc_sweep(HEAPMEM* phm);
#else //PIECE
/*static*/ int gc_scan(void* top, void* end);
/*static*/ int gc_mark(HEAPMEM* phm);
/*static*/ void gc_sweep(HEAPMEM* phm);
#endif//PIECE
static void* new_pceHeapAlloc(unsigned long size);
static int new_pceHeapFree(void* memp);
//{{2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
static int new_pceFileCreate(const char* fname, unsigned long size);
static int new_pceFileDelete(const char* fname);
//}}2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
/*--------------------------------------------------------------------------*/
extern uint8_t __START_FRAM_ADDR[];
extern uint8_t __END_FRAM_ADDR[];
extern uint8_t __START_DEFAULT_CODE[];
extern uint8_t __END_DEFAULT_CODE[];
extern uint8_t __START_DEFAULT_DATA[];
extern uint8_t __END_DEFAULT_DATA[];
extern uint8_t __START_DEFAULT_BSS[];
extern uint8_t __END_DEFAULT_BSS[];
/****************************************************************************
 *	
 ****************************************************************************/
void BitmapGC_Init(int unit) {
	const pceAPPHEAD* apphead;
	HEAPMEM* phm;
	int size;
	//܂mɖԂɖ߂܂B
	BitmapGC_Free();
	//BitmapPʂi[܂B
	if((unit < 2) || (unit > 8)) { DIE(); }	//2ȏɐRpceHeapAlloc()[hPʂł邩B8ȉɐRAsmł̎1߂ŃVtg邽߁B
	_gc.unit = unit;
	//q[v擪AhXƃq[vTCY[byte]擾܂B
	apphead = (const pceAPPHEAD*)__START_DEFAULT_CODE;
	_gc.phm = _gc.heaptop = (HEAPMEM*)(apphead->bss_end + apphead->stack_size);	//_gc.phmcBitmapGC_Init()̒́Aq[v擪̋󂫃ubN瑖B
	if(_gc.heaptop->mark != HEAPMEMMK) { DIE(); }
	for(phm = _gc.heaptop; phm->chain; phm = phm->chain) { /** no job **/ }	//phmHMO_SYSTEMwԂŔB
	_gc.heapsize = (uint32_t)phm - (uint32_t)_gc.heaptop;
	//Bitmapmۂ܂B
	size = (_gc.heapsize + (1 << _gc.unit) - 1) >> _gc.unit;	//bits
	_gc.bitmap = bitarray_alloc(size);
	if(!_gc.bitmap) { DIE(); }
ENTER_CS;
	//APItbN܂B
	_gc.old_pceHeapAlloc = pceVectorSetKs(KSNO_HeapAlloc, new_pceHeapAlloc);
	_gc.old_pceHeapFree  = pceVectorSetKs(KSNO_HeapFree,  new_pceHeapFree);
//{{2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
	_gc.old_pceFileCreate = pceVectorSetKs(KSNO_FileCreate, new_pceFileCreate);
	_gc.old_pceFileDelete = pceVectorSetKs(KSNO_FileDelete, new_pceFileDelete);
//}}2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
LEAVE_CS;
}
/****************************************************************************
 *	
 ****************************************************************************/
void BitmapGC_Free() {
	//ĂȂΉ܂B
	if(!_gc.heapsize) { return; }
ENTER_CS;
	//APĨtbN܂B
	pceVectorSetKs(KSNO_HeapAlloc, _gc.old_pceHeapAlloc);
	pceVectorSetKs(KSNO_HeapFree,  _gc.old_pceHeapFree);
//{{2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
	pceVectorSetKs(KSNO_FileCreate, _gc.old_pceFileCreate);
	pceVectorSetKs(KSNO_FileDelete, _gc.old_pceFileDelete);
//}}2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
LEAVE_CS;
	//BitmapJ܂B
	free(_gc.bitmap);
	//\̂NA܂B
	memset(&_gc, 0, sizeof _gc);
}
/****************************************************************************
 *	
 ****************************************************************************/
void BitmapGC_Run();
asm("
		.code
		.align		1
		.global		BitmapGC_Run
BitmapGC_Run:
		;//Ăяo֐ALȃubNւ̃|C^%r0-3ɕێĂ\܂B
		;//K[x[WRN^[̓WX^̃ubNQƂȂ̂ŁA
		;//̂܂܂ł́AWX^QƂĂ郁ubNĊJĂ܂\܂B
		;//̖邽߁A%r0-3X^bNɐςłAK[x[WRN^[{̂ĂяoƂɂ܂B
		pushn		%r3
		call		_gc_run
		popn		%r3
		ret
");
/*--------------------------------------------------------------------------*/
static void _gc_run() {
	HEAPMEM* phm;
	int size;
	//ɌĂł͂܂B
	if(!_gc.heapsize) { DIE(); }
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//ENTER_CS;
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
ENTER_IL(1);
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	//BitmapNA܂B
	size = (_gc.heapsize + (1 << _gc.unit) - 1) >> _gc.unit;	//bits
	size = ((size + 31) >> 5) << 2;					//bytes
	memset(_gc.bitmap, 0, size);
	//蓖čς݃[U[ubNAɖQƃubNƂĂ܂B
	for(phm = _gc.heaptop; phm; phm = phm->chain) {
		if(phm->mark != HEAPMEMMK) DIE();
		switch(phm->owner) {
		//󂫃ubN
		case 0:
			/** no job **/
			break;
		//蓖čς݃VXeubN
		case HMO_SYSTEM:
			if(phm->chain) { DIE(); }	//PieceSystem 1.20ɂẮAHMO_SYSTEḾAq[v[̋ubNƂĂ̂ݗpĂ܂B
			break;
		//蓖čς݃[U[ubN
		case HMO_DEFAULT_USER:
			phm->owner = HMO_NOREF_USER;	//ɖQƃubNƂĂAQƂo瑖sŁAHMO_DEFAULT_USERɖ߂܂B
			break;
		//\ȂubN
		default:
			DIE();
		}
	}
	//X^bN̈orf[^̈悩QƂĂAhX𑖍܂B
	gc_scan(stack_info.sysstack_top, stack_info.sysstack_end);	//VXeX^bN c SRAM
	gc_scan(stack_info.usrstack_top, stack_info.usrstack_end);	//[U[X^bN c SRAM or FRAM
	gc_scan(__START_DEFAULT_DATA, __END_DEFAULT_DATA);
	gc_scan(__START_DEFAULT_BSS, __END_DEFAULT_BSS);
	//VȗvubNoԁA}[NƑJԂ܂B
	while(gc_mark(_gc.heaptop)) { /** no job **/ }
	//QƃubN̂܂܎cubNAׂĊJ܂B
	gc_sweep(_gc.heaptop);
	//BitmapGC_Run()̒́Aq[v擪̋󂫃ubN瑖B
	_gc.phm = _gc.heaptop;
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//LEAVE_CS;
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
LEAVE_IL;
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
}
/*--------------------------------------------------------------------------*/
#ifndef PIECE
static int gc_scan(void* top, void* end) {
	int result = 0;
	uint32_t* pos;
	for(pos = top; (uint32_t)pos < (uint32_t)end; pos++) {
		uint32_t addr = *pos - (uint32_t)_gc.heaptop;
		if((uint32_t)addr < (uint32_t)_gc.heapsize) {
			addr >>= _gc.unit;
			bitarray_lsb1st_set(_gc.bitmap, addr, 1, 1);
			result = 1;
		}
	}
	return result;
}
#else //PIECE
#if 0 //'fȎ'ƁA'X^bNt[1߂ŊJHv'́AǂgĂʂ͓łB\قړłBR[hTCYߖeNjbN̓쌟؂̂߂ɁA'X^bNt[1߂ŊJHv'̕gp邱Ƃɂ܂B
//fȎB
asm("
		.code
		.align		1
gc_scan:
		pushn		%r3				;//
		xsub		%sp, %sp, 4			;//[%sp+0].b := result
		xld.b		[%sp+0], %r8			;//[%sp+0].b := result = 0
		ld.w		%r0, %r12			;//%r0  := pos = top
		ld.w		%r1, %r13			;//%r1  := end
		xld.w		%r9, _gc			;//%r9  :=           &_gc.heapsize
		ld.w		%r2, [%r9]+			;//%r2  := heapsize = _gc.heapsize
		ld.w		%r3, [%r9]			;//%r3  := heaptop  = _gc.heaptop
		;//%r0       := pos
		;//%r1       := end
		;//%r2       := heapsize
		;//%r3       := heaptop
		;//[%sp+0].b := result
		cmp		%r0, %r1			;//									
gc_scan_L10:							;//									@
		jruge		gc_scan_RET			;//while(pos < end) {							
		ld.w		%r13, [%r0]+			;//  %r13 := addr = *pos++						@
		sub		%r13, %r3			;//  %r13 := addr -= heaptop						@
		cmp		%r13, %r2			;//  if((uint32_t)addr >= (uint32_t)heapsize) { continue }		@
		jruge.d		gc_scan_L10			;//  									@
		cmp		%r0, %r1			;//  										*delay*			򂵂Ȃꍇ͖ʏƂȂ邪A򂷂P[X唼Ȃ̂ŁA̒xXbg𗘗pƎvB
		xld.w		%r9, _gc+8			;//  %r9  :=         &_gc.bitmap					@
		ld.w		%r12, [%r9]+			;//  %r12 := bitmap = _gc.bitmap					@
		ld.b		%r9, [%r9]			;//  %r9  := unit   = _gc.unit			2unit8		@
		ld.w		%r14, 1				;//  %r14 :=                           1				@	*anti-interlock*
		srl		%r13, %r9			;//  %r13 := addr >>= unit			1߂ŃVtg\	@
		xld.b		[%sp+0], %r14			;//  [%sp+0].b := result = 1						@
		xcall.d		bitarray_lsb1st_set		;//  bitarray_lsb1st_set(bitmap, addr, 1, 1)				@
		ld.w		%r15, 1				;//  %r15 :=                              1				@	*delay*
		jp.d		gc_scan_L10			;//  									@
		cmp		%r0, %r1			;//  										*delay*
gc_scan_RET:							;//}
		xld.b		%r10, [%sp+0]			;//return result
		xadd		%sp, %sp, 4			;//
		popn		%r3				;//
		ret						;//
");
#else //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//X^bNt[1߂ŊJHv܂BWX^ޔƃX^bNt[mۂ̏Ԃւ邱ƂŁA߂莞'xadd %sp,%sp,n'ȗ1ߐߖł܂B֐ɂĂ͂قǌʂ͖̂łAR[hTCYߖeNjbN̋L^Ƃē֐ɓKp邱Ƃɂ܂B
asm("
		.code
		.align		1
gc_scan:
		xsub		%sp, %sp, 4			;//[%sp+16].b := result											
		pushn		%r3				;//													yX^bNt[1߂ŊJHvz
		xld.b		[%sp+16], %r8			;//[%sp+16].b := result = 0										
		ld.w		%r0, %r12			;//%r0  := pos = top
		ld.w		%r1, %r13			;//%r1  := end
		xld.w		%r9, _gc			;//%r9  :=           &_gc.heapsize
		ld.w		%r2, [%r9]+			;//%r2  := heapsize = _gc.heapsize
		ld.w		%r3, [%r9]			;//%r3  := heaptop  = _gc.heaptop
		;//%r0        := pos
		;//%r1        := end
		;//%r2       := heapsize
		;//%r3       := heaptop
		;//[%sp+ 0].w := %r0																	
		;//[%sp+ 4].w := %r1																	
		;//[%sp+ 8].w := %r2																	yX^bNt[1߂ŊJHvz
		;//[%sp+12].w := %r3																	
		;//[%sp+16].b := result																	
		;//[%sp+20].w := retp
		cmp		%r0, %r1			;//									
gc_scan_L10:							;//									@
		jruge		gc_scan_RET			;//while(pos < end) {							
		ld.w		%r13, [%r0]+			;//  %r13 := addr = *pos++						@
		sub		%r13, %r3			;//  %r13 := addr -= heaptop						@
		cmp		%r13, %r2			;//  if((uint32_t)addr >= (uint32_t)heapsize) { continue }		@
		jruge.d		gc_scan_L10			;//  									@
		cmp		%r0, %r1			;//  										*delay*			򂵂Ȃꍇ͖ʏƂȂ邪A򂷂P[X唼Ǝv̂ŁA̒xXbg𗘗pƎvB
		xld.w		%r9, _gc+8			;//  %r9  :=         &_gc.bitmap					@
		ld.w		%r12, [%r9]+			;//  %r12 := bitmap = _gc.bitmap					@
		ld.b		%r9, [%r9]			;//  %r9  := unit   = _gc.unit			2unit8		@
		ld.w		%r14, 1				;//  %r14 :=                           1				@	*anti-interlock*
		srl		%r13, %r9			;//  %r13 := addr >>= unit			1߂ŃVtg\	@
		xld.b		[%sp+16], %r14			;//  [%sp+16].b := result = 1						@				yX^bNt[1߂ŊJHvz
		xcall.d		bitarray_lsb1st_set		;//  bitarray_lsb1st_set(bitmap, addr, 1, 1)				@
		ld.w		%r15, 1				;//  %r15 :=                              1				@	*delay*
		jp.d		gc_scan_L10			;//  									@
		cmp		%r0, %r1			;//  										*delay*
gc_scan_RET:							;//}
		xld.b		%r10, [%sp+16]			;//return result
		popn		%r4				;//													yX^bNt[1߂ŊJHvz
		ret						;//
");
#endif
#endif//PIECE
/*--------------------------------------------------------------------------*/
//'oOL̎'́ABitmapPʂ܂ubŃA㔼BitmapPʓ̃AhXQƂ|C^LĂAubNJĂ܂oOLB
//'oOC'ɂāA̖CB
//۸
//void app_main() {
//  extern uint8_t __START_DEFAULT_CODE[];
//  const pceAPPHEAD* apphead=(const pceAPPHEAD*)__START_DEFAULT_CODE;
//  HEAPMEM* heaptop=(HEAPMEM*)(apphead->bss_end+apphead->stack_size);
//  void* volatile p;
//  BitmapGC_Init(4);//BitmapP=16޲
//  //BitmapPʂɂ܂12޲Ăۯmۂł܂ŌJԂ
//  do{
//    surface_clear(&surface,0);
//    render_printf(&render,0,0,1,3,"%p",(p=malloc(12)));
//    update();
//  }while((((int)p-(int)heaptop)&15)!=(16-4));//(OBitmapPʂ4޲+㔼BitmapPʂ8޲)̌`ɂȂ܂ŌJԂ
//  p+=8;//QƂ12޲Ăۯ8޲Ė(=㔼BitmapPʂɊ܂܂8޲ĕ̒)w悤ɂ炷̂炵낢ςČ؂޸ނL4~11̎ɕsɊJ顐ȂΏȂƂ~19܂ł͌㔼ۯŵŊJȂ
//  render_printf(&render,0,88,1,3,"%p",p);	//؂ɌÂp̺ЂcĂ\炷߂а̌Ăяos
//  BitmapGC_Run();//QƂĂȂ؂J
//  do{schedule();}while(!(joy&TRG_A));//ݸނPCdmalloc.exesĤ؊蓖ďԂmF桏LۯJĂȂΐł
//  BitmapGC_Free();
//}
#if 0 //'oOL̎'́AL^̂߂ɎcĂ邾łBK҂'oOC'gpĂB
//~oOL̎B
#ifndef PIECE
static int gc_mark(HEAPMEM* phm) {
	int result = 0;
	do {
		if(phm->mark != HEAPMEMMK) { DIE(); }				//q[vĂB									Asmłł͂̌͏ȗ܂B
		if(phm->owner == HMO_NOREF_USER) {				//QƃubNȂ΁c
			void* top = phm + 1/*Kv!!*/;
			void* end = phm->chain;
			uint32_t addr = (uint32_t)top - (uint32_t)_gc.heaptop;
			uint32_t size = (uint32_t)end - (uint32_t)top;
			addr >>=       _gc.unit;
			size  += (1 << _gc.unit) - 1;
			size >>=       _gc.unit;
			if(bitarray_lsb1st_test(_gc.bitmap, addr, size)) {	//QƂĂ邩?
				result |= gc_scan(top, end);			//B
				phm->owner = HMO_DEFAULT_USER;			//ς݂ɖ߂B
			}
		}
	} while((phm = phm->chain));						//HMO_SYSTEMɓB!phmɂȂĔB
	return result;
}
#else //PIECE
asm("
		.code
		.align		1
gc_mark:
		pushn		%r3
		ld.w		%r0, 0				;//%r0  := result = 0
		xadd		%r1, %r12, 2			;//%r1  := &phm->owner
gc_mark_L10:							;//do {
		;//%r0  := result
		;//%r1  := &phm->owner
		ld.uh		%r9, [%r1]+			;//  %r9  := owner = phm->owner, %r1  := &phm->chain
		xcmp		%r9, 0x1111			;//  if(owner == HMO_NOREF_USER) {
		jrne		gc_mark_L20
		ld.w		%r2, %r1			;//    %r2  :=      &phm->chain
		ld.w		%r3, [%r2]+			;//    %r3  := end = phm->chain, %r2  := top = phm + 1
		;//%r0  := result
		;//%r1  := &phm->chain
		;//%r2  := top
		;//%r3  := end
		xld.w		%r9, _gc+4			;//    %r9  :=          &_gc.heaptop
		ld.w		%r4, [%r9]+			;//    %r4  := heaptop = _gc.heaptop
		ld.w		%r12, [%r9]+			;//    %r12 := bitmap  = _gc.bitmap
		ld.b		%r9, [%r9]			;//    %r9  := unit    = _gc.unit	2unit8
		ld.w		%r13, %r2			;//    %r13 :=        top
		sub		%r13, %r4			;//    %r13 := addr = top - heaptop
		ld.w		%r14, %r3			;//    %r14 :=        end
		sub		%r14, %r2			;//    %r14 := size = end - top
		srl		%r13, %r9			;//    %r13 := addr >>= unit		1߂ŃVtg\
		ld.w		%r4, 1				;//    %r4  :=          1
		sll		%r4, %r9			;//    %r4  :=          1 << unit	1߂ŃVtg\
		sub		%r4, 1				;//    %r4  :=         (1 << unit) - 1
		add		%r14, %r4			;//    %r14 := size += (1 << unit) - 1
		xcall.d		bitarray_lsb1st_test		;//    if(bitarray_lsb1st_test(bitmap, addr, size)) {
		srl		%r14, %r9			;//    %r13 := size >>= unit		1߂ŃVtg\	*delay*
		cmp		%r10, 0				;//      
		jreq		gc_mark_L20			;//      
		ld.w		%r12, %r2			;//      %r12 :=               top
		xcall.d		gc_scan				;//      %r10 := tmp = gc_scan(top, end)
		ld.w		%r13, %r3			;//      %r13 :=                    end				*delay*
		or		%r0, %r10			;//      %r0  := result |= tmp
		sub		%r1, 2				;//      %r1  := &phm->owner
		ld.w		%r9, 1				;//      %r9  :=      HMO_DEFAULT_USER
		ld.h		[%r1]+, %r9			;//      phm->owner = HMO_DEFAULT_USER, %r1  := &phm->chain
gc_mark_L20:							;//  } }
		;//%r0  := result
		;//%r1  := &phm->chain
		ld.w		%r1, [%r1]			;//  %r1  := phm = phm->chain
		cmp		%r1, 0				;//} while(  phm)						!INTERLOCK!
		jrne.d		gc_mark_L10			;//  
		add		%r1, 2				;//  %r0  := &phm->owner					*delay*
		ld.w		%r10, %r0			;//%r10 := result
		popn		%r3
		ret
");
#endif//PIECE
#else //- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//oOCB
#ifndef PIECE
//yKv!!z̍sɂẴRg	//Oq́uBitmapPʂ܂ubŃA㔼BitmapPʓ̃AhXQƂ|C^LĂAubNJĂ܂oOvƂ͕ʌłB
//pceHeapAlloc(0)\ł̂ŁA0bytẽubN(top==end)B
//0bytẽubŃAtop܂BitmapPʂQƂ|C^LꍇAJȂƂɂB
//ŊJĂ܂ƁǍɃAvP[V0bytẽubNJ悤ƂɁAdJɂȂĂ܂łB
//p=pceHeapAlloc(0);
//BitmapGC_Run();//pJĂ܂Ɓc
//pceHeapFree(p);//dJɂȂ
//ۂɂ́ApceHeapFree(p)͓dJoĉȂ̂ňSȂ̂A炩̃oǑɂȂ鋰ꂪ̂ŁAȂȂ悤ɂĂmłB
//۸
//void app_main() {
//  void* volatile p;
//  BitmapGC_Init(2);//BitmapP=4޲
//  render_printf(&render,0,0,1,3,"%p",(p=malloc(0)));//0޲Ăۯmۂ
//  update();
//  BitmapGC_Run();//QƂĂȂ؂J
//  do{schedule();}while(!(joy&TRG_A));//ݸނPCdmalloc.exesĤ؊蓖ďԂmF桏LۯJĂȂΐł
//  BitmapGC_Free();
//}
//dv!!
//'clipgc.c'ƂL̖ĂB܂Ō݉ȂƂƂ́A0bytẽubN̓dJɋŃAۂ̃AvP[Vł͂قƂǔȂ̂낤B
//AL̑΍ŝ͓W['clipbmgc.c'ŁA'clipgc.c'͕ύXĂȂ(XύX̂|ł)BAlqāA'clipgc.c'C邱ƂB
static int gc_mark(HEAPMEM* phm) {
	int result = 0;
	do {
		if(phm->mark != HEAPMEMMK) { DIE(); }					//q[vĂB								Asmłł͂̌͏ȗ܂B
		if(phm->owner == HMO_NOREF_USER) {					//QƃubNȂ΁c
			void* top = phm + 1/*Kv!!*/;					//ubN̐擪AhX(+0)
			void* end = phm->chain;						//ubN̍ŏIAhX(+1)
			int pos1 = ((int)top - (int)_gc.heaptop    ) >> _gc.unit;	//ubN̐擪AhX(+0)܂BitmapP	0bytẽubN(top==end)L蓾邽߁A(pos1==(pos2-1))ɂȂ\LB
			int pos2 = ((int)end - (int)_gc.heaptop - 1) >> _gc.unit;	//ubN̍ŏIAhX(+0)܂BitmapP	
			int size = pos2 - pos1 + 1;					//ubN܂BitmapPʂ̐			0bytẽubN(top==end)L蓾邽߁Asize=0ɂȂ\LB
			if(!size) { size = 1; }						//yKv!!z̍s폜ƁA'QƂĂ0bytẽubNJĂ܂'oOBڍׂ͏L̃RgQƂB
			if(bitarray_lsb1st_test(_gc.bitmap, pos1, size)) {		//QƂĂ邩?
				result |= gc_scan(top, end);				//B						0bytẽubN(top==end)̏ꍇA͂ɏI邪Agc_scan()ĂяoƂ͈SłB
				phm->owner = HMO_DEFAULT_USER;				//ς݂ɖ߂B
			}
		}
	} while((phm = phm->chain));							//HMO_SYSTEMɓB!phmɂȂĔB
	return result;
}
#else //PIECE
asm("
		.code
		.align		1
gc_mark:
		pushn		%r3
		ld.w		%r0, 0				;//%r0  := result = 0
		xadd		%r1, %r12, 2			;//%r1  := &phm->owner
gc_mark_L10:							;//do {
		;//%r0  := result
		;//%r1  := &phm->owner
		ld.uh		%r9, [%r1]+			;//  %r9  := owner = phm->owner, %r1  := &phm->chain
		xcmp		%r9, 0x1111			;//  if(owner == HMO_NOREF_USER) {
		jrne		gc_mark_L20
		ld.w		%r2, %r1			;//    %r2  :=      &phm->chain
		ld.w		%r3, [%r2]+			;//    %r3  := end = phm->chain, %r2  := top = phm + 1
		;//%r0  := result
		;//%r1  := &phm->chain
		;//%r2  := top
		;//%r3  := end
		xld.w		%r9, _gc+4			;//    %r9  :=          &_gc.heaptop
		ld.w		%r4, [%r9]+			;//    %r4  := heaptop = _gc.heaptop
		ld.w		%r12, [%r9]+			;//    %r12 := bitmap  = _gc.bitmap
		ld.b		%r9, [%r9]			;//    %r9  := unit    = _gc.unit			2unit8
		ld.w		%r13, %r2			;//    %r13 :=         top
		sub		%r13, %r4			;//    %r13 :=         top - heaptop
		sra		%r13, %r9			;//    %r13 := pos1 = (top - heaptop    ) >> unit	1߂ŃVtg\	pos1 0
		ld.w		%r14, %r3			;//    %r14 :=         end
		sub		%r14, %r4			;//    %r14 :=         end - heaptop
		sub		%r14, 1				;//    %r14 :=         end - heaptop - 1
		sra		%r14, %r9			;//    %r14 := pos2 = (end - heaptop - 1) >> unit	1߂ŃVtg\	pos2-1
		sub		%r14, %r13			;//    %r14 :=        pos2 - pos1      ,%psr(C) := (pos2 < pos1)		'if(!size){size=1;}'̏Aadc1߂Ŏsďߖ񂵂B
		ld.w		%r9, 1				;//    %r9  :=                      1						ɂ͂ł͑ʖځBpos1=0,pos2=-1̎ɁAsize=0ɂȂĂ܂łB
		xcall.d		bitarray_lsb1st_test		;//    if(bitarray_lsb1st_test(bitmap, addr, size)) {				ۂɂ́A擪BitmapPʂɋR0bytẽubN쐬邱Ƃ͂܂AJĖ肪݉\͂ɔB
		adc		%r14, %r9			;//    %r14 := size = pos2 - pos1 + 1 + %psr(C)			*delay*		p薳ƔfāÂ܂܂ƂBɏƁA1ߑĂ܂łB
		cmp		%r10, 0				;//      
		jreq		gc_mark_L20			;//      
		ld.w		%r12, %r2			;//      %r12 :=               top
		xcall.d		gc_scan				;//      %r10 := tmp = gc_scan(top, end)
		ld.w		%r13, %r3			;//      %r13 :=                    end				*delay*
		or		%r0, %r10			;//      %r0  := result |= tmp
		sub		%r1, 2				;//      %r1  := &phm->owner
		ld.w		%r9, 1				;//      %r9  :=      HMO_DEFAULT_USER
		ld.h		[%r1]+, %r9			;//      phm->owner = HMO_DEFAULT_USER, %r1  := &phm->chain
gc_mark_L20:							;//  } }
		;//%r0  := result
		;//%r1  := &phm->chain
		ld.w		%r1, [%r1]			;//  %r1  := phm = phm->chain
		cmp		%r1, 0				;//} while(  phm)						!INTERLOCK!
		jrne.d		gc_mark_L10			;//  
		add		%r1, 2				;//  %r0  := &phm->owner					*delay*
		ld.w		%r10, %r0			;//%r10 := result
		popn		%r3
		ret
");
#endif//PIECE
#endif
/*--------------------------------------------------------------------------*/
//{{͈̔͂clipgc.cRs[܂Bclipgc.cgc_sweep()ƑSłB
#ifndef PIECE
static void gc_sweep(HEAPMEM* phm) {
	do {
		if(phm->mark != HEAPMEMMK) { DIE(); }					//q[vĂB								Asmłł͂̌͏ȗ܂B
		if(!phm->owner || (phm->owner == HMO_NOREF_USER)) {			//󂫃ubNȂ΁c
			HEAPMEM* phm1 = phm;						//ȍ~̃ubNŁAŏɋ󂫃ubNłȂubNB
			do {
				phm1 = phm1->chain;
				if(phm1->mark != HEAPMEMMK) { DIE(); }			//q[vĂB								Asmłł͂̌͏ȗ܂B
			} while(!phm1->owner || (phm1->owner == HMO_NOREF_USER));	//󂫃ubNłȂΔB	HMO_SYSTEMɓBꍇŔB
			//ubNݒ肷B
		//sv	phm->mark  = HEAPMEMMK;
			phm->owner = 0;							//HMO_NOREF_USER0,,00
			phm->chain = phm1;						//ȍ~̃ubNŁAŏɋ󂫃ubNłȂubÑAhXB
		}
	} while((phm = phm->chain));							//HMO_SYSTEMɓB!phmɂȂĔB
}
#else //PIECE
asm("
		.code
		.align		1
gc_sweep:
		xld.w		%r4, 0x1111A431		;//%r4  := (HEAPMEMMK,HMO_NOREF_USER)
		ld.uh		%r5, %r4		;//%r5  := (HEAPMEMMK,0)
gc_sweep_L10:						;//do {
		ld.w		%r9, [%r12]+		;//  %r9  := (mark,owner) = (phm->mark,phm->owner), %r12 := &phm->chain
		cmp		%r9, %r4		;//  if(((mark,owner) == (HEAPMEMMK,HMO_NOREF_USER)) ||
		jreq		3
		 cmp		%r9, %r5		;//     ((mark,owner) == (HEAPMEMMK,0))) {
		 jrne		gc_sweep_L30
		;//-------------------------------------;//
		ld.w		%r6, %r12		;//    %r6  := &phm1->chain = &phm->chain
gc_sweep_L20:						;//    do {
		ld.w		%r6, [%r6]		;//      %r6  := phm1 = phm1->chain
		ld.w		%r9, [%r6]+		;//      %r9  := (mark,owner) = (phm->mark,phm->owner), %r6  := &phm1->chain	!INTERLOCK!
		cmp		%r9, %r4		;//    } while(((mark,owner) == (HEAPMEMMK,HMO_NOREF_USER)) ||
		jreq		gc_sweep_L20
		cmp		%r9, %r5		;//            ((mark,owner) == (HEAPMEMMK,0)))
		jreq		gc_sweep_L20
		sub		%r12, 4			;//    %r12 := phm
		ld.w		[%r12]+, %r5		;//    (phm->mark,phm->owner) = (HEAPMEMMK,0), %r12 := &phm->chain
		sub		%r6, 4			;//    %r6  := phm1
		ld.w		[%r12], %r6		;//    phm->chain = phm1
		;//-------------------------------------;//
gc_sweep_L30:						;//  }
		ld.w		%r12, [%r12]		;//  %r12 := phm->chain
		cmp		%r12, 0			;//										!INTERLOCK!
		jrne		gc_sweep_L10		;//} while(  phm)
		ret
");
#endif//PIECE
//}}͈̔͂clipgc.cRs[܂Bclipgc.cgc_sweep()ƑSłB
/*--------------------------------------------------------------------------*/
//{{͈̔͂clippce.cRs[ĕύX܂BύX_clippce.c̓̊֐ƔrĂB
#ifndef PIECE
static void* first_fit_pceHeapAlloc(unsigned long size0) {
	HEAPMEM* phm = _gc.phm;	//ŌɊ蓖ĂubN瑖pB
	HEAPMEM *phm0, *phm1;
	//mۂTCYɁAubNǗ\̂̃TCYA[hTCY̔{ɐ؂グB
	size0 = ((size0 + sizeof(HEAPMEM) + 3) & ~3);
	//ubN𑖍āc
	do {
		if(phm->mark != HEAPMEMMK) { DIE(); }	//q[vĂB
		phm0 = phm->chain;
		//󂫃ubNc
		if(!phm->owner) {
			//̃ubÑTCY(ubNǗ\̂̃TCY)߂B
			unsigned long size1 = (unsigned long)phm0 - (unsigned long)phm;
			//mۂTCY(ubNǗ\̂̃TCY)ȏȂ΁c
			if(size1 >= size0) {
				//ubÑTCYAmۂTCY(ubNǗ\̂̃TCY)ƁAꍇɑǗ\̂̍v傫΁c
				if(size1 > (size0 + sizeof(HEAPMEM))) {
					//ȍ~̃ubN󂫃ubNȂ΁AubNɌB
					phm1 = phm;
					do {
						phm1 = phm1->chain;
						if(phm1->mark != HEAPMEMMK) { DIE(); }	//q[vĂB
					} while(!phm1->owner);		//󂫃ubNłȂΔB	HMO_SYSTEMɓBꍇŔB
					//ubNݒ肷B
					phm0 = (void*)phm + size0;	//(void*)ւ̉Zgccg
			/*v*/		phm0->mark  = HEAPMEMMK;
					phm0->owner = 0;
					phm0->chain = phm1;		//ȍ~̃ubNŁAŏɋ󂫃ubNłȂubÑAhXB
				}
				//mۂubNݒ肷B
			//sv	phm->mark  = HEAPMEMMK;
				phm->owner = HMO_DEFAULT_USER;
				phm->chain = phm0;			//ifubNʂȂꍇ́Aphm0==phm->chain̂܂܂łB
				//ŌɊ蓖ĂubN̊Ǘ\̂̃AhXi[B
				_gc.phm = phm;
				//mۂubŃAǗ\̂̌̃AhXԂB
				phm++;
				break;	//܂
			}
		}
	} while((phm = phm0));	//HMO_SYSTEMɓB!phmɂȂĔA蓖ĎsƂNULLԂB
	return   phm;
}
#else //PIECE
/*static*/ void* first_fit_pceHeapAlloc(unsigned long size0);
asm("
		.code
		.align		1
first_fit_pceHeapAlloc:
		xld.w		%r10, [_gc+16]			;//%r10 := phm = _gc.phm
		add		%r12, 3				;//%r12 := size0' +=  3			(size0' := size0 - 8)
		and		%r12, -4			;//%r12 := size0' &= ~3
		xld.w		%r4, 0x1A431			;//%r4  := (HEAPMEMMK,HMO_DEFAULT_USER)
		ld.uh		%r5, %r4			;//%r5  := (HEAPMEMMK,0)
first_fit_pceHeapAlloc_L10:					;//do {
		;//%r4  := (HEAPMEMMK,HMO_DEFAULT_USER)
		;//%r5  := (HEAPMEMMK,0)
		;//%r10 := phm
		;//%r12 := size0'
		ld.w		%r9, [%r10]+			;//  %r9  := (mark,owner) = (phm->mark,phm->owner)
		ld.w		%r6, [%r10]+			;//  %r6  := phm0 = phm->chain, %r10 := phm + 8
		cmp		%r9, %r5			;//  if((mark,owner) == (HEAPMEMMK,0)) {
		jrne		first_fit_pceHeapAlloc_L30
		;//---------------------------------------------;//
		;//%r4  := (HEAPMEMMK,HMO_DEFAULT_USER)
		;//%r5  := (HEAPMEMMK,0)
		;//%r6  := phm0
		;//%r10 := phm + 8
		;//%r12 := size0'
		ld.w		%r7, %r6			;//    %r7  :=          phm0
		sub		%r7, %r10			;//    %r7  := size1' = phm0 - phm - 8	(size1' := size1 - 8)
		sub		%r7, %r12			;//    %r7  := size1' - size0'
		jrult		first_fit_pceHeapAlloc_L40	;//    if((size1' - size0') < 0) { goto L40 }
		add		%r12, %r10			;//    %r12 := phm + size0
		cmp		%r7, 8				;//    if((size1' - size0') > 8) {
		jrule.d	first_fit_pceHeapAlloc_L20
		sub		%r10, 8				;//      %r10 := phm						*delay*
		;//%r4  := (HEAPMEMMK,HMO_DEFAULT_USER)
		;//%r5  := (HEAPMEMMK,0)
		;//%r6  := phm0
		;//%r10 := phm
		;//%r12 := phm + size0
		ld.w		%r7, %r10			;//      %r7  := phm1 = phm
		ext		4				;//      do {
		 ld.w		%r7, [%r7]			;//        %r7  := phm1 = phm1->chain
		 ld.w		%r9, [%r7]			;//        %r9  := (mark,owner) = (phm1->mark,phm1->owner)	!INTERLOCK!
		 cmp		%r9, %r5			;//      } while((mark,owner) == (HEAPMEMMK,0))			!INTERLOCK!
		jreq		-4
		ld.uh		%r9, %r9			;//      %r9  := mark
		cmp		%r9, %r5			;//      if(mark != HEAPMEMMK) { DIE() }
		jrne		first_fit_pceHeapAlloc_DIE
		ld.w		%r6, %r12			;//      %r6  := phm0 = phm + size0
		ld.w		[%r12]+, %r5			;//      (phm0->mark,phm0->owner) = (HEAPMEMMK,0)
		ld.w		[%r12], %r7			;//      phm0->chain = phm1
first_fit_pceHeapAlloc_L20:					;//    }
		xld.w		[_gc+16], %r10			;//    _gc.phm = phm
		ld.w		[%r10]+, %r4			;//    (phm->mark,phm->owner) = (HEAPMEMMK,HMO_DEFAULT_USER)
		ld.w		[%r10]+, %r6			;//    phm->chain = phm0, %r10 := phm + 8
		ret						;//    return                     phm + 8
		;//---------------------------------------------;//  }
		;//%r4  := (HEAPMEMMK,HMO_DEFAULT_USER)
		;//%r5  := (HEAPMEMMK,0)
		;//%r6  := phm0
		;//%r9  := (mark,owner)
first_fit_pceHeapAlloc_L30:
		ld.uh		%r9, %r9			;//  %r9  :=  mark
		cmp		%r9, %r5			;//  if(mark != HEAPMEMMK) { DIE() }
		jrne		first_fit_pceHeapAlloc_DIE
first_fit_pceHeapAlloc_L40:
		cmp		%r6, 0
		jrne.d		first_fit_pceHeapAlloc_L10	;//} while(  phm)
		ld.w		%r10, %r6			;//  %r10 := phm = phm0						*delay*
		ret						;//return    phm
");
static void __attribute__((noreturn,unused))/*asmubNQ*/ first_fit_pceHeapAlloc_DIE() { DIE(); }
#endif//PIECE
//}}͈̔͂clippce.cRs[ĕύX܂BύX_clippce.c̓̊֐ƔrĂB
/*--------------------------------------------------------------------------*/
static void* new_pceHeapAlloc(unsigned long size) {
	void* ptr;
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//ENTER_CS;	//Kv
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
ENTER_IL(1);
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	ptr = first_fit_pceHeapAlloc(size);	//1st try
	if(!ptr) {
		BitmapGC_Run();
		ptr = first_fit_pceHeapAlloc(size);	//2nd try
		if(!ptr) { DIE(); }
	}
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//LEAVE_CS;	//Kv
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
LEAVE_IL;
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	return memset(ptr, -1, size);
}
/*--------------------------------------------------------------------------*/
static int new_pceHeapFree(void* memp) {
	//pceHeapFree()͉Ȃ悤ɂAJBitmapGC_Run()ɏW񂵂܂B
	//_gc.phmwĂ郁ubNJȂ悤ɂ邽߂łB
	HEAPMEM* phm = (HEAPMEM*)memp - 1;
//ENTER_CS;	//sv
    //	if((phm->mark != HEAPMEMMK) || (phm->owner != HMO_DEFAULT_USER)) { DIE(); }
    //œK
	if(*(uint32_t*)phm != (HEAPMEMMK|HMO_DEFAULT_USER<<16)) { DIE(); }
//LEAVE_CS;	//sv
	return 0;
}
/*--------------------------------------------------------------------------*/
//{{2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
static int new_pceFileCreate(const char* fname, unsigned long size) {
	int retval;
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//ENTER_CS;	//Kv
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
ENTER_IL(1);
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	BitmapGC_Run();
	retval = (*_gc.old_pceFileCreate)(fname, size);
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//LEAVE_CS;	//Kv
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
LEAVE_IL;
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	return retval;
}
static int new_pceFileDelete(const char* fname) {
	int retval;
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//ENTER_CS;	//Kv
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
ENTER_IL(1);
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	BitmapGC_Run();
	retval = (*_gc.old_pceFileDelete)(fname);
//{{2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
//LEAVE_CS;	//Kv
//2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
LEAVE_IL;
//}}2014/12/19ύX:_gc_run(),new_pceHeapAlloc(),new_pceFileCreate(),new_pceFileDelete()̔rAENTER_CS/LEAVE_CSENTER_IL(1)/LEAVE_ILɕύX܂B
	return retval;
}
//}}2014/12/15ǉ:pceFileCreate(),pceFileDelete()ĂяoOɁABitmapGC_Run()s悤ɂ܂B
/*--------------------------------------------------------------------------*/
