/*	
 *	clipblob.c
 *
 *	[eBeBFBLOB
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2017-2018 Naoyuki Sawa
 *
 *	* Tue Sep 26 23:05:51 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	- dRegTblC.exeƓdĺABLOBf[^쐬郆[eBeB֐łB
 *	  AdRegTblC.exełȂÃc[⃂W[łdlgƎv̂ŁAʂ̃[eBeB֐ƂĎĂɂ܂B
 *	- 쐬̂́ABLOBf[^쐬郆[eBeB֐ŁABLOBf[^ǂݏo[eBeB֐́A܂쐬Ă܂B
 *	  AABLOBf[^ǂݏoʉǂƔfA̎ɍ쐬悤Ǝv܂B	{{2017/09/27RgǋL:BLOBf[^ǂݏo[eBeB֐쐬܂B}}
 *	* Thu Sep 28 23:55:37 JST 2017 Naoyuki Sawa
 *	- BLOBf[^ǂݏo[eBeB֐쐬܂B
 *	  BLOBf[^쐬郆[eBeB֐eXg邽߂ɂ́A͂BLOBf[^ǂݏo[eBeB֐KvȂ̂ŁA쐬鎖ɂ܂B
 *	  AAvP[V痘p鎖o܂K{ł͂ȂABLOB̍\OƂĒڃANZXĂ\܂B
 *	- uBLOBf[^쐬郆[eBeB֐BLOBf[^ǂݏo[eBeB֐̃eXgv쐬܂B
 *	* Sun Oct 01 23:07:12 JST 2017 Naoyuki Sawa
 *	- BLOB\̂ɃVOl`ǉ܂B
 *	  ύXÔ܂܂ł͖薳̂łAdataɊԈBLOBȊÕ|C^nꍇɔhoOɂȂ̂ŁAɃG[~o悤ɃVOl`ǉAɌ鎖ɂ܂B
 *	  ̕ύX́AAvP[V̊ϓ_͓߂łAAvP[V̕ύX͕svłB
 *	* Tue Oct 03 23:59:59 JST 2017 Naoyuki Sawa
 *	- blob_compare()ǉ܂B
 *	* Sat Apr 07 23:59:59 JST 2018 Naoyuki Sawa
 *	- blob_add_ber(),blob_read_ber()ǉ܂B
 */
#include "clip.h"
//*****************************************************************************
//	BLOBf[^쐬郆[eBeB֐
//*****************************************************************************
//BLOB\́BAvP[V͕słB
//{{2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//struct blob {
//	int		bits;				//+ 0,4                i[rbgB	((bits&7)!=0)̎bitȊO̊i[sꍇ̓oCgE܂Ői߂(m((bits&7)==0)Ƃ)B((bits&7)!=0)̎f[^ŜƂČΊSȂ̂łǂ̃^C~Ołt@CiCY͕svłB
//	int		data[0/*(bits+31)/32*/];	//+ 4,4*((bits+31)/32) rbgzf[^B	W[̊֐ƁAAvP[V̊Ԃ̂Ƃł́Äʒuw|C^gp܂BAvP[V̊ϓ_ł́AW[ƂƂ肷|C^̂܂܁Af[^{̂ƌȂ܂B
//};							//= 4+4*((bits+31)/32)
//2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
#define FOURCC_BLOB	MAKEFOURCC('B','L','O','B')
struct blob {
	int		sig;				//+ 0,4                VOl`B		"BLOB"ŒB
	int		bits;				//+ 4,8                i[rbgB	((bits&7)!=0)̎bitȊO̊i[sꍇ̓oCgE܂Ői߂(m((bits&7)==0)Ƃ)B((bits&7)!=0)̎f[^ŜƂČΊSȂ̂łǂ̃^C~Ołt@CiCY͕svłB
	int		data[0/*(bits+31)/32*/];	//+ 8,4*((bits+31)/32) rbgzf[^B	W[̊֐ƁAAvP[V̊Ԃ̂Ƃł́Äʒuw|C^gp܂BAvP[V̊ϓ_ł́AW[ƂƂ肷|C^̂܂܁Af[^{̂ƌȂ܂B
};							//= 8+4*((bits+31)/32)
//}}2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//-----------------------------------------------------------------------------
//{{2017/10/01ǉ:BLOB\̂ɃVOl`ǉ܂B
//rbgzf[^ւ̃|C^ABLOB\̂ւ̃|C^ɕϊB
static struct blob* blob_from_data(void* data/*NULL*/) {
	//rbgzf[^ւ̃|C^ABLOB\̂ւ̃|C^ɕϊB
	struct blob* blob = CONTAINING_RECORD(data, struct blob, data);
	//VOl`B
	if(blob->sig != FOURCC_BLOB) { DIE(); }
	//BLOB\̂ւ̃|C^ԂB
	return blob;
}
//}}2017/10/01ǉ:BLOB\̂ɃVOl`ǉ܂B
//-----------------------------------------------------------------------------
//BLOB̃JB
void blob_free(void* data/*NULL*/) {
	//BLOB\̂̃mۍς݂Ȃ΁c
	if(data) {
		//BLOB\̂̃JB
//{{2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//		struct blob* blob = CONTAINING_RECORD(data, struct blob, data);
//2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		struct blob* blob = blob_from_data(data);
//}}2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		free(blob);
	}
}
//-----------------------------------------------------------------------------
//i[oCg(f[^̗]rbg)擾B
int blob_get_size(void* data/*NULL*/) {
	//BLOB\̂̃mۍς݂Ȃ΁c
	if(data) {
		//i[oCgԂB
//{{2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//		struct blob* blob = CONTAINING_RECORD(data, struct blob, data);
//2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		struct blob* blob = blob_from_data(data);
//}}2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		return (blob->bits + 7) / 8;
	//BLOB\̂̃mۂȂ΁c
	} else {
		//i[oCg=0ԂB
		return 0;
	}
}
//-----------------------------------------------------------------------------
//{{2017/10/03ǉ:blob_compare()ǉ܂B
int blob_compare(void* data1/*NULL*/, void* data2/*NULL*/) {
	int size1 = blob_get_size(data1);
	int size2 = blob_get_size(data2);
	int result = memcmp(data1, data2, min(size1, size2));
	if(result) { return result; }
	if(size1 < size2) { return -1; }
	if(size1 > size2) { return  1; }
	return 0;
}
//}}2017/10/03ǉ:blob_compare()ǉ܂B
//-----------------------------------------------------------------------------
//BLOB1rbgli[B(8rbgEւ̐񖳂)
void* blob_add_bit(void* data/*NULL*/, int n) {
	struct blob* blob;
	//BLOB\̂̃mۍς݂Ȃ΁c
	if(data) {
		//f[^ɗ]rbgL΁c
//{{2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//		blob = CONTAINING_RECORD(data, struct blob, data);
//2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		blob = blob_from_data(data);
//}}2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		if(blob->bits & 31) {
			//rbgi[B
			bitarray_lsb1st_set(blob->data, blob->bits, 1, n);	//ł'n & 1'͕svłB
			//i[rbg𑝂₷B
			blob->bits++;
			//rbgzf[^ւ̃|C^ԂB
			return blob->data;	//܂
		}
	}
	//ȒPɂ邽߁AoCgƂĊi[7rbg炷@B
	data = blob_add_byte(data, n & 1);	//i[rbgɃS~i[Ȃ悤ɁA'n & 1'͕K{łB
//{{2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//	blob = CONTAINING_RECORD(data, struct blob, data);
//2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
	blob = blob_from_data(data);
//}}2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
	blob->bits -= 7;
	//rbgzf[^ւ̃|C^ԂB
	return blob->data;
}
//-----------------------------------------------------------------------------
//BLOB1oCgli[B(8rbgEւ̐L)
void* blob_add_byte(void* data/*NULL*/, int n) {
	return blob_add_data(data, &n, 1);
}
//-----------------------------------------------------------------------------
//BLOB2oCgli[B(8rbgEւ̐L)
void* blob_add_half(void* data/*NULL*/, int n) {
	return blob_add_data(data, &n, 2);
}
//-----------------------------------------------------------------------------
//BLOB2oCgexp10li[B(8rbgEւ̐L)
void* blob_add_exp10(void* data/*NULL*/, int n) {
	int t = Exp10_Encode(n);	//֐͈nexp10l͈͓̔ł邩ȂBnexp10l͈̔͊OȂΊi[l͕s(ۂɂ-1)łBsli[鎖hɂ̓AvP[Vɂē֐ĂяoOɈnexp10l͈͓̔ł邩B
	return blob_add_data(data, &t, 2);
}
//-----------------------------------------------------------------------------
//BLOB4oCgli[B(8rbgEւ̐L)
void* blob_add_word(void* data/*NULL*/, int n) {
	return blob_add_data(data, &n, 4);
}
//-----------------------------------------------------------------------------
//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B
//BLOBBERkli[B(8rbgEւ̐L)
void* blob_add_ber(void* data/*NULL*/, int n) {
	unsigned char buf[(sizeof(int)*8+6)/7];
	return blob_add_data(data, buf, BER_Encode(buf, n));
}
//}}2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B
//-----------------------------------------------------------------------------
//BLOB2oCgli[B(8rbgEւ̐L)
void* blob_add_fp16(void* data/*NULL*/, double d) {
	fp16 t = truncdfhf2(d);
	return blob_add_data(data, &t, 2);
}
//-----------------------------------------------------------------------------
//BLOB4oCgli[B(8rbgEւ̐L)
void* blob_add_fp32(void* data/*NULL*/, double d) {
	float t = d;
	return blob_add_data(data, &t, 4);
}
//-----------------------------------------------------------------------------
//BLOB8oCgli[B(8rbgEւ̐L)
void* blob_add_fp64(void* data/*NULL*/, double d) {
	return blob_add_data(data, &d, 8);
}
//-----------------------------------------------------------------------------
//BLOBɃkI[i[B(8rbgEւ̐L)
void* blob_add_string(void* data/*NULL*/, const char* s) {
	int len = strlen(s);
	return blob_add_data(data, s, len + 1/*'\0'*/);
}
//-----------------------------------------------------------------------------
//BLOBɔCӒ̃f[^i[B(8rbgEւ̐L)
void* blob_add_data(void* data/*NULL*/, const void* p, int size/*0*/) {
	struct blob* blob;
	int old_words, new_words;
	//BLOB\̂̃mۍς݂Ȃ΁c
	if(data) {
		//mɃoCgE܂Ői߂B(Ƃ0oCg̃f[^i[łĂ!!)
//{{2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
//		blob = CONTAINING_RECORD(data, struct blob, data);
//2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		blob = blob_from_data(data);
//}}2017/10/01ύX:BLOB\̂ɃVOl`ǉ܂B
		blob->bits = (blob->bits + 7) & ~7;
	//BLOB\̂̃mۂȂ΁c
	} else {
		//mۂBLOBɑ΂āA0oCg̃f[^i[sꍇ́Aɂ̂܂NULLԂB(AvP[V̗֐̂߂Ƀmۍς݂BLOB͏ɋłȂƌȂ悤ɂ邽߂łB(data!=NULL)(blob_get_size(data)!=0)ɂȂ鎖͗L蓾܂BƋBLOB͏NULL|C^ł̂ݕ\܂B)
		if(!size) { return NULL; }
		//BLOB\̂mۂB
		blob = calloc(1, sizeof(struct blob));
		if(!blob) { DIE(); }
//{{2017/10/01ǉ:BLOB\̂ɃVOl`ǉ܂B
		//VOl`i[B
		blob->sig = FOURCC_BLOB;
//}}2017/10/01ǉ:BLOB\̂ɃVOl`ǉ܂B
	}
	//ύXOƕύX̃[hLpVeB߂B
	old_words = (blob->bits +              31) / 32;
	new_words = (blob->bits + (size * 8) + 31) / 32;
	//[hLpVeBωȂ΁c
	if(new_words != old_words) {
		//BLOB\̂gB
		blob = realloc(blob, sizeof(struct blob) + (new_words * 4));
		if(!blob) { DIE(); }
		//g[NAB(f[^ɗ]rbgLĂSȃf[^Ƃ邽߂łBڍׂstruct blob.bitstB[h̃RgQƂĉB)
		memset(blob->data + old_words, 0, (new_words - old_words) * 4);
	}
	//f[^i[B
	memcpy((char*)blob->data + (blob->bits / 8), p, size);
	//i[rbg𑝂₷B
	blob->bits += (size * 8);
	//rbgzf[^ւ̃|C^ԂB
	return blob->data;
}
//*****************************************************************************
//	BLOBf[^ǂݏo[eBeB֐
//*****************************************************************************
//BLOB[_[\̂B
void blob_reader_init(struct blob_reader* reader, const int* data, int size/*0*/) {
	reader->data = data;
	reader->bits = size * 8;
	reader->pos  = 0;
}
//-----------------------------------------------------------------------------
//BLOB1rbglǂݏoB(8rbgEւ̐񖳂)
int blob_read_bit(struct blob_reader* reader) {
	if(reader->pos >= reader->bits) { DIE(); }	//ǂݏorbgʒuArbgzf[^̑rbgȏȂ΁AG[~B(CR[AEgł)
	return bitarray_lsb1st_get(reader->data, reader->pos++, 1);
}
//-----------------------------------------------------------------------------
//BLOB1oCglǂݏoB(8rbgEւ̐L)
int blob_read_byte(struct blob_reader* reader) {
	return *(unsigned char*)blob_read_data(reader, 1);
}
//-----------------------------------------------------------------------------
//BLOB2oCglǂݏoB(8rbgEւ̐L)
int blob_read_half(struct blob_reader* reader) {
	unsigned short t;
	return *(unsigned short*)blob_copy_data(reader, &t, 2);
}
//-----------------------------------------------------------------------------
//BLOB2oCgexp10lǂݏoB(8rbgEւ̐L)
int blob_read_exp10(struct blob_reader* reader) {
	return Exp10_Decode(blob_read_half(reader));
}
//-----------------------------------------------------------------------------
//BLOB4oCglǂݏoB(8rbgEւ̐L)
int blob_read_word(struct blob_reader* reader) {
	int t;
	return *(int*)blob_copy_data(reader, &t, 4);
}
//-----------------------------------------------------------------------------
//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B
//BLOBBERklǂݏoB(8rbgEւ̐L)
int blob_read_ber(struct blob_reader* reader) {
	int t;
	blob_read_data(reader, BER_Decode(blob_read_data(reader, 0), &t));
	return t;
}
//}}2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B
//-----------------------------------------------------------------------------
//BLOB2oCglǂݏoB(8rbgEւ̐L)
double blob_read_fp16(struct blob_reader* reader) {
	return extendhfdf2(blob_read_half(reader));
}
//-----------------------------------------------------------------------------
//BLOB4oCglǂݏoB(8rbgEւ̐L)
double blob_read_fp32(struct blob_reader* reader) {
	float t;
	return *(float*)blob_copy_data(reader, &t, 4);
}
//-----------------------------------------------------------------------------
//BLOB8oCglǂݏoB(8rbgEւ̐L)
double blob_read_fp64(struct blob_reader* reader) {
	double t;
	return *(double*)blob_copy_data(reader, &t, 8);
}
//-----------------------------------------------------------------------------
//BLOBkI[ǂݏoB(8rbgEւ̐L)
const char* blob_read_string(struct blob_reader* reader) {
	return blob_read_data(reader, strlen(blob_read_data(reader, 0)) + 1/*'\0'*/);
}
//-----------------------------------------------------------------------------
//BLOBCӒ̃f[^ǂݏoB(8rbgEւ̐L)
// - ֐Ԃ|C^́An[t[hE⃏[hEɂ͐񂵂Ă܂B
//   ֐Ԃ|C^(int*)ɃLXgēǂݏoƁAAhXsO܂B
//   n[t[hE⃏[hEւ̐񂪕Kvȏꍇ́Ablob_copy_data()gpĉB
const void* blob_read_data(struct blob_reader* reader, int size/*0*/) {
	const void* p;
	//mɃoCgE܂Ői߂B(Ƃ0oCg̃f[^ǂݏołĂ!!)
	reader->pos = (reader->pos + 7) & ~7;
	//f[^̃|C^ۑB
	p = (char*)reader->data + (reader->pos / 8);
	//ɓǂݏorbgʒui߂B
	reader->pos += (size * 8);
	if(reader->pos > reader->bits) { DIE(); }	//ɓǂݏorbgʒuArbgzf[^̑rbg𒴂AG[~B(CR[̓Z[tł)
	//f[^̃|C^ԂB
	return p;
}
//-----------------------------------------------------------------------------
//BLOBCӒ̃f[^ǂݏoAw肳ꂽփRs[B(8rbgEւ̐L)
// - Ăяo̗֐̂߂ɁA֐͈p̂܂ܕԂ܂B
//   ̗ȗp@́Ablob_read_word()̎QƂĉB
void* blob_copy_data(struct blob_reader* reader, void* p, int size/*0*/) {
	return memcpy(p, blob_read_data(reader, size), size);
}
//*****************************************************************************
//	BLOBf[^쐬郆[eBeB֐BLOBf[^ǂݏo[eBeB֐̃eXg
//*****************************************************************************
#if 0
enum {
	type_bit = 1,
	type_byte,
	type_half,
	type_exp10,
	type_word,
	type_ber,	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
	type_fp16,
	type_fp32,
	type_fp64,
	type_string,
	type_data,
	type_max = type_data,
};
struct value_bit    { int type; int n; };
struct value_byte   { int type; int n; };
struct value_half   { int type; int n; };
struct value_exp10  { int type; int n; };
struct value_word   { int type; int n; };
struct value_ber    { int type; int n; };	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
struct value_fp16   { int type; double d; };
struct value_fp32   { int type; double d; };
struct value_fp64   { int type; double d; };
struct value_string { int type; char* s; };
struct value_data   { int type; unsigned char* p; int size; };
union value {
	int                 type;
	struct value_bit    v_bit;
	struct value_byte   v_byte;
	struct value_half   v_half;
	struct value_exp10  v_exp10;
	struct value_word   v_word;
	struct value_ber    v_ber;	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
	struct value_fp16   v_fp16;
	struct value_fp32   v_fp32;
	struct value_fp64   v_fp64;
	struct value_string v_string;
	struct value_data   v_data;
};
static void test() {
	void* data = NULL;
	struct blob_reader reader;
	int n_value, n_bit, i, j, n;
	union value *TBL_value/*[n_value]*/, *p_value;
	struct value_bit*    p_bit;
	struct value_byte*   p_byte;
	struct value_half*   p_half;
	struct value_exp10*  p_exp10;
	struct value_word*   p_word;
	struct value_ber*    p_ber;	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
	struct value_fp16*   p_fp16;
	struct value_fp32*   p_fp32;
	struct value_fp64*   p_fp64;
	struct value_string* p_string;
	struct value_data*   p_data;
	//f[^쐬B
	n_value = RND32_RANGE(seed, 10, 100);	//l̐
	TBL_value = calloc(n_value, sizeof(union value));
	n_bit = 0;	//type_bitAՂ悤ɂ邽߂̕ϐB
	for(i = 0; i < n_value; i++) {
		p_value = &TBL_value[i];
		if(n_bit) {	//type_bitAȂ΁c
			p_value->type = type_bit;
			n_bit--;
		} else {
			p_value->type = RND32_RANGE(seed, 1, type_max + 1);
			if(p_value->type == type_bit) {				//type_bitVɒIꂽc
				n_bit = RND32_RANGE(seed, 0, 16/**/);	//ȍ~type_bitA𒊑IB
			}
		}
		switch(p_value->type) {
		default:DIE();
		case type_bit:    p_bit    = &p_value->v_bit;    p_bit->n   =                        RND8( seed) & 1; break;
		case type_byte:   p_byte   = &p_value->v_byte;   p_byte->n  =                        RND8( seed);     break;
		case type_half:   p_half   = &p_value->v_half;   p_half->n  =                        RND16(seed);     break;
		case type_exp10:  p_exp10  = &p_value->v_exp10;  p_exp10->n =           Exp10_Decode(RND16(seed));    break;
		case type_word:   p_word   = &p_value->v_word;   p_word->n  =                        RND32(seed);     break;
		case type_ber:    p_ber    = &p_value->v_ber;    p_ber->n   =                        RND32(seed);     break;	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
		case type_fp16:   p_fp16   = &p_value->v_fp16;   p_fp16->d  = extendhfdf2(truncdfhf2(RNDF( seed)));   break;
		case type_fp32:   p_fp32   = &p_value->v_fp32;   p_fp32->d  =                 (float)RNDF( seed);     break;
		case type_fp64:   p_fp64   = &p_value->v_fp64;   p_fp64->d  =                        RNDF( seed);     break;
		case type_string: p_string = &p_value->v_string; n            = RND32_RANGE(seed, 0, 100); p_string->s = calloc(n + 1/*'\0'*/, 1); for(j = 0; j < n;            j++) { p_string->s[j] = RND32_RANGE(seed, 'A', 'Z' + 1); } break;
		case type_data:   p_data   = &p_value->v_data;   p_data->size = RND32_RANGE(seed, 0, 100); p_data->p   = malloc(p_data->size    ); for(j = 0; j < p_data->size; j++) { p_data->p[  j] = RND8(       seed);               } break;
		}
	}
	//BLOB쐬B
	for(i = 0; i < n_value; i++) {
		p_value = &TBL_value[i];
		switch(p_value->type) {
		default:DIE();
		case type_bit:    p_bit    = &p_value->v_bit;    data = blob_add_bit(   data, p_bit->n               ); break;
		case type_byte:   p_byte   = &p_value->v_byte;   data = blob_add_byte(  data, p_byte->n              ); break;
		case type_half:   p_half   = &p_value->v_half;   data = blob_add_half(  data, p_half->n              ); break;
		case type_exp10:  p_exp10  = &p_value->v_exp10;  data = blob_add_exp10( data, p_exp10->n             ); break;
		case type_word:   p_word   = &p_value->v_word;   data = blob_add_word(  data, p_word->n              ); break;
		case type_ber:    p_ber    = &p_value->v_ber;    data = blob_add_ber(   data, p_ber->n               ); break;	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
		case type_fp16:   p_fp16   = &p_value->v_fp16;   data = blob_add_fp16(  data, p_fp16->d              ); break;
		case type_fp32:   p_fp32   = &p_value->v_fp32;   data = blob_add_fp32(  data, p_fp32->d              ); break;
		case type_fp64:   p_fp64   = &p_value->v_fp64;   data = blob_add_fp64(  data, p_fp64->d              ); break;
		case type_string: p_string = &p_value->v_string; data = blob_add_string(data, p_string->s            ); break;
		case type_data:   p_data   = &p_value->v_data;   data = blob_add_data(  data, p_data->p, p_data->size); break;
		}
	}
	//BLOBǂݏoĔrB
	blob_reader_init(&reader, data, blob_get_size(data));
	for(i = 0; i < n_value; i++) {
		p_value = &TBL_value[i];
		switch(p_value->type) {
		default:DIE();
		case type_bit:    p_bit    = &p_value->v_bit;    if(blob_read_bit(  &reader) != p_bit->n  ) { DIE(); } break;
		case type_byte:   p_byte   = &p_value->v_byte;   if(blob_read_byte( &reader) != p_byte->n ) { DIE(); } break;
		case type_half:   p_half   = &p_value->v_half;   if(blob_read_half( &reader) != p_half->n ) { DIE(); } break;
		case type_exp10:  p_exp10  = &p_value->v_exp10;  if(blob_read_exp10(&reader) != p_exp10->n) { DIE(); } break;
		case type_word:   p_word   = &p_value->v_word;   if(blob_read_word( &reader) != p_word->n ) { DIE(); } break;
		case type_ber:    p_ber    = &p_value->v_ber;    if(blob_read_ber(  &reader) != p_ber->n  ) { DIE(); } break;	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
		case type_fp16:   p_fp16   = &p_value->v_fp16;   if(blob_read_fp16( &reader) != p_fp16->d ) { DIE(); } break;
		case type_fp32:   p_fp32   = &p_value->v_fp32;   if(blob_read_fp32( &reader) != p_fp32->d ) { DIE(); } break;
		case type_fp64:   p_fp64   = &p_value->v_fp64;   if(blob_read_fp64( &reader) != p_fp64->d ) { DIE(); } break;
		case type_string: p_string = &p_value->v_string; if(strcmp(blob_read_string(&reader              ), p_string->s            )) { DIE(); } break;
		case type_data:   p_data   = &p_value->v_data;   if(memcmp(blob_read_data(  &reader, p_data->size), p_data->p, p_data->size)) { DIE(); } break;
		}
	}
	//f[^JB
	for(i = 0; i < n_value; i++) {
		p_value = &TBL_value[i];
		switch(p_value->type) {
		default:DIE();
		case type_bit:    p_bit    = &p_value->v_bit;    /** no job **/     break;
		case type_byte:   p_byte   = &p_value->v_byte;   /** no job **/     break;
		case type_half:   p_half   = &p_value->v_half;   /** no job **/     break;
		case type_exp10:  p_exp10  = &p_value->v_exp10;  /** no job **/     break;
		case type_word:   p_word   = &p_value->v_word;   /** no job **/     break;
		case type_ber:    p_ber    = &p_value->v_ber;    /** no job **/     break;	//{{2018/04/07ǉ:blob_add_ber(),blob_read_ber()ǉ܂B}}
		case type_fp16:   p_fp16   = &p_value->v_fp16;   /** no job **/     break;
		case type_fp32:   p_fp32   = &p_value->v_fp32;   /** no job **/     break;
		case type_fp64:   p_fp64   = &p_value->v_fp64;   /** no job **/     break;
		case type_string: p_string = &p_value->v_string; free(p_string->s); break;
		case type_data:   p_data   = &p_value->v_data;   free(p_data->p  ); break;
		}
	}
	free(TBL_value);
	//BLOBJB
	blob_free(data);
}
int app_main(int argc, char* argv[]) {
	int cnt = 0;
	seed = 0;	//Č̂߂ɁAV[hJn鎖ɂB
	for(;;) {
		printf("\r%d", ++cnt);
		test();
	}
}
#endif
