/*
 *	clipber.c
 *
 *	BER - Basic Encoding Rules
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2018 Naoyuki Sawa
 *
 *	* Fri Apr 06 23:59:59 JST 2018 Naoyuki Sawa
 *	- 1st [XB
 *	- BERɂẮAL̎QƂĉB
 *	  @uSamayou Oharikuiv(http://www5d.biglobe.ne.jp/~stssk/index.html)̃TCǵABER(Basic Encoding Rules)x(http://www5d.biglobe.ne.jp/stssk/asn1/ber.html)̋L
 *	  AuInformation technology - ASN.1 encoding rules: Specification of Basic Encoding Rules (BER), Canonical Encoding Rules (CER) and Distinguished Encoding Rules (DER)v(https://www.itu.int/ITU-T/studygroups/com17/languages/X.690-0207.pdf)
 *	- AW[쐬́ARubypackev[g(https://docs.ruby-lang.org/ja/latest/doc/pack_template.html)̕׋ĂāABERk̎młB
 *	  ܂ŁAl̈ksۂ́AeW[ł̓sxĂ܂AWIȕ@ɉċʃW[ƂėpӂĂǂƎv̂ŁAW[쐬܂B
 *	- W[̋@\́AWdlɊSɉĂł͂ȂA悻̊TOvĂ邾łB
 *	  Rubypackev[gBERk`AWdlɌɉĂł͂Ȃ(?)悤Ɏv܂B
 *	- ܂AW[̋@\ƁARubypackev[gBERk`̊ԂɂAႢ܂B
 *	  Rubypackev[gBERk`́AɑΉĂȂ悤ŁAnƃG[ɂȂ܂B
 *	  ɑΉĂȂƎgĥŁAW[ł͕ɂΉ鎖ɂ܂B
 *	  BERk@ƂẮAƌȂăGR[h@L̂łAł͕Sđ傫ȃf[^ɃGR[hĂ܂̂ŁA̕@͎܂łB
 *	  W[ł́Ao͂7rbg̍ŏʃrbg𕄍g@ŁAɑΉ܂B(tŐƔĥŁAR[hǂޕՂƎv܂B)
 */
#include "clip.h"
//*****************************************************************************
//	
//*****************************************************************************
//BERGR[hꂽf[^AfR[hB
//[in]
//	buf		̓obt@B					NULLs
//	pVal		fR[hli[ϐւ̃|C^B	NULLs
//[out]
//	߂l		fR[hoCgB			1`((sizeof(int)*8+6)/7)BʓIɂ1`5łB
#ifndef PIECE
int BER_Decode(const unsigned char* buf, int* pVal) {
	//toCglƂēǂݏo߂ɁA|C^̌^ϊB
	const char* pos = buf;
	//1oCgǂݍށB
	int tmp = *pos++;
	//ǂݍ񂾒l̃rbg6𕄍glAʂ̒l̏lƂB
	int val = tmp << (32 - 7) >> (32 - 7);
	//ǂݍ񂾒lMSBZbgĂԁAJԂB
	while(tmp < 0) {
		//1oCgǂݍށB
		tmp = *pos++;
		//ǂݍ񂾒lMSBNAlAʂ̒lɍB
		val = (val << 7) | (tmp & 0x7F);
	}
	//ʂ̒li[B
	*pVal = val;
	//fR[hoCgԂB
	return pos - (const char*)buf;	//̃LXgsȂƁAGCCŁuinvalid operands to binary -vG[oBVC++6.0ł͑vȂ̂B
}
#else //PIECE
asm("
		.code
		.align		1
		.global		BER_Decode
BER_Decode:
		;//%r12 := buf
		;//%r13 := pVal
		ld.w		%r10, %r12			;//%r10 := pos = buf
		ld.b		%r11, [%r10]+			;//%r11 := tmp = *pos++
		ld.w		%r14, %r11			;//%r14 :=       tmp
		rr		%r14, 7				;//%r14 :=       tmp << (32 - 7)		̎_ł%r14[24:0]s肾AVtgAEĝŖ薳B
		xsra		%r14, 32-7			;//%r14 := val = tmp << (32 - 7) >> (32 - 7)
BER_Decode_LOOP:						;//for(;;) {
		cmp		%r11, 0				;//  if(tmp >= 0) { break }
		jrge		BER_Decode_RET			;//  
		ld.b		%r11, [%r10]+			;//  %r11 := tmp = *pos++
		sla		%r14, 7				;//  %r14 :=       (val << 7)
		xand		%r9, %r11, 0x7F			;//  %r9  :=                    (tmp & 0x7F)
		jp.d		BER_Decode_LOOP			;//}
		or		%r14, %r9			;//  %r14 := val = (val << 7) | (tmp & 0x7F)	*delay*
BER_Decode_RET:							;//
		ld.w		[%r13], %r14			;//*pVal = val
		ret.d						;//return  pos - buf
		sub		%r10, %r12			;//%r10 := pos - buf				*delay*
");
#endif//PIECE
//-----------------------------------------------------------------------------
//lvalBERGR[hAobt@bufɊi[B
//[in]
//	val		GR[hlB			INT_MIN`INT_MAX
//	buf		o̓obt@B				ȂƂ((sizeof(int)*8+6)/7)oCgȏmۂĉBʓIɂ5oCgłB	NULLs
//[out]
//	߂l		o̓obt@Ɋi[oCgB	1`((sizeof(int)*8+6)/7)BʓIɂ1`5łB
#ifndef PIECE
int BER_Encode(unsigned char buf[/*(sizeof(int)*8+6)/7*/], int val) {
	//o̓obt@̐擪AhXLĂB
	unsigned char* pos = buf;
	int len;
	for(;;) {
		//7rbǵAMSBZbgli[B
		*pos++ = (val | ~0x7F);
		//6rbgVtgAEgB
		val >>= 6;
		//i[ς݂7rbgڂƁAc̃rbgȂΔB
		if((val == 0) || (val == -1)) { break; }
		//i[ς݂7rbgڂAVtgAEgB
		val >>= 1;
	}
	//ŏɊi[7rbǵAMSBNAB
	*buf &= 0x7F;	//bclr [%rd],7
	//i[oCg߂B
	len = pos - buf;
	//i[l̕тtɂB
#if 0
	//ʂȌ͔ȂA擪Ń[vs߃R[hTCY傫o[WB
	while(--pos > buf) {
		int a = *pos;
		int b = *buf;
		*buf++ = a;
		*pos = b;
	}
#else
	//ʂȌ邪AŃ[vs߃R[hTCYo[WB(AZuł͂ɂ܂B)
	do {
		int a = *--pos;
		int b = *buf;
		*buf++ = a;
		*pos = b;
	} while(pos > buf);
#endif
	//i[oCgԂB
	return len;
}
#else //PIECE
asm("
		.code
		.align		1
		.global		BER_Encode
BER_Encode:
		;//%r12 := buf
		;//%r13 := val
		ld.w		%r11, %r12			;//%r11 := pos = buf
BER_Encode_L10:							;//for(;;) {
		xoor		%r9, %r13, ~0x7F		;//  %r9  :=  (val | ~0x7F)
		ld.b		[%r11]+, %r9			;//  *pos++ = (val | ~0x7F)
		sra		%r13, 6				;//  %r13 := val >>= 6
		cmp		%r13, 0				;//  
		jreq		BER_Encode_L20			;//  if(val ==  0) { break }
		cmp		%r13, -1			;//  
		jrne.d		BER_Encode_L10			;//  if(val == -1) { break }
		sra		%r13, 1				;//  %r13 := val >>= 1		*delay*
BER_Encode_L20:							;//}
		bclr		[%r12], 7			;//*buf &= 0x7F
		ld.w		%r10, %r11			;//%r10 :=       pos
		sub		%r10, %r12			;//%r10 := len = pos - buf
BER_Encode_L30:							;//do {
		sub		%r11, 1				;//  %r11 := pos--
		ld.b		%r9, [%r11]			;//  %r9  := a = *pos
		ld.b		%r13, [%r12]			;//  %r13 := b = *buf
		ld.b		[%r12]+, %r9			;//  *buf++ = a
		ld.b		[%r11], %r13			;//  *pos   = b
		cmp		%r11, %r12			;//  
		jrugt		BER_Encode_L30			;//} while(pos > buf)
		ret
");
#endif//PIECE
//*****************************************************************************
//	eXgvO
//*****************************************************************************
#if 0
void test() {
	int step = 0;
	for(;;) {
		char buf[16];
		int val1, val2, len1, len2;
		//GR[hl쐬B
		switch(step) {
		default:DIE();
		case 0: val1 =  RND32(seed); step = 1; break;	//
		case 1: val1 = -RND16(seed); step = 2; break;	//
		case 2: val1 =  RND16(seed); step = 3; break;	//_RND32()łeXgôAł͑傫Ȓlɕ΂Ă܂̂ŁAxϓɃeXg邽߂ɂB
		case 3: val1 = -RND8( seed); step = 4; break;	//
		case 4: val1 =  RND8( seed); step = 0; break;	//
		}
		//G[`FbN̂߂Ƀobt@-1ŃtBĂB
		memset(buf, -1, sizeof buf);
		//GR[hB
		len1 = BER_Encode(buf, val1);
		//f[^̃oCg͈͊OłȂmFB
		if((len1 < 1) || (len1 > ((sizeof(int)*8+6)/7))) { DIE(); }
		//f[^͈̔͊Õobt@j󂳂Ă炸Af[^̖MSB0ł鎖mFB
		if((buf[len1] != -1) || (buf[len1 - 1] < 0)) { DIE(); }
		//fR[hB
		len2 = BER_Decode(buf, &val2);
		//lƁAf[^̃oCgmFB
		if((val1 != val2) || (len1 != len2)) { DIE(); }
		printf("%11d %d ok\n", val1, len1);
	}
}
#endif
