/*	
 *	clipbary.c
 *
 *	ėprbgz
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Tue Dec 20 00:06:44 JST 2011 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Nov 20 20:22:14 JST 2014 Naoyuki Sawa
 *	- LSBso[WɉāAMSBso[W쐬܂B
 *	- bitarray_get(),bitarray_set()Abitarray_lsb1st_get(),bitarray_lsb1st_set()ɖ̕ύX܂B
 *	- VKɁAbitarray_msb1st_get(),bitarray_msb1st_set()ǉ܂B
 *	  bitarray_msb1st_get(),bitarray_msb1st_set()͂܂AAZuĂ܂B
 *	* Sat Nov 22 11:57:45 JST 2014 Naoyuki Sawa
 *	- bitarray_msb1st_get()AZu܂B
 *	  ̏Ձ`Ղ́Abitarray_lsb1st_get()̃AZułƂقړŁAVtgႤłB
 *	  ̏IՂ́Abitarray_lsb1st_get()ƈقȂA}XNKv̂ŁAPɂȂ܂B
 *	- HuffmanDecoder_Decode()gpāACłƓʂɂȂ邱Ƃ𓮍mF܂B
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xA1.203b˖1.106bɍ܂B(Clock=48MHz,Stack=FRAM)
 *	  bitarray_msb1st_get()P̂ŁAǂꂮ炢́A܂vĂ܂B
 *	* Sat Nov 22 13:00:53 JST 2014 Naoyuki Sawa
 *	- bitarray_msb1st_set()AZu܂B
 *	  ̏ՂƏIՂ́Abitarray_lsb1st_set()̃AZułƂقړŁAVtgႤłB
 *	  ̒Ղ́Abitarray_lsb1st_set()ƈقȂA}XNƒlꂼɃVtg悤ɂȂ܂B
 *	- HuffmanEncoder_Encode()gpāACłƓʂɂȂ邱Ƃ𓮍mF܂B
 *	  HuffmanEncoder_Encode()ŁA62KB˖39KB̈ks̑xA12.91b˖12.69bɍ܂B(Clock=48MHz,Stack=FRAM)
 *	  bitarray_msb1st_set()P̂ŁAǂꂮ炢́A܂vĂ܂B
 *	* Sat Nov 29 10:50:31 JST 2014 Naoyuki Sawa
 *	- bitarray_lsb1st_get(),bitarray_msb1st_get()Aclipbary.cframbary.c֕܂B
 *	  HuffmanDecoder_Decode()ŁA39KB˖62KB̓WJs̑xAȉ̂悤ɍ܂B(Clock=48MHz,Code=FRAM,Stack=FRAM)
 *	  RAMɔzu郂W[:                ˖0.756b
 *	  RAMɔzu郂W[:frambary.o          ˖0.586b
 *	  RAMɔzu郂W[:framhfm.o           ˖0.418b
 *	  RAMɔzu郂W[:frambary.o+framhfm.o˖0.248b
 *	* Thu Dec 11 21:02:26 JST 2014 Naoyuki Sawa
 *	- bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
 *	  ܂ł́Abits=1`32łÁAbits=0`32ƂȂ܂B
 *	  bits=0eŔAĂяȍ̓sbits=0ƂȂ蓾P[X悭LAĂяoŔfČĂяoAW[Ŕf֗łƍlłB
 *	- ύXsӏ́Abitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()Cł݂̂łB
 *	  bitarray_lsb1st_get(),bitarray_msb1st_get()́A̐擪bits=0ł邩fāAȂ0Ԃ悤ɓᏈǉ܂B
 *	  bitarray_lsb1st_set(),bitarray_msb1st_set()́A̐擪bits=0ł邩fāAȂΉɋAᏈǉ܂B
 *	  CłŁAL̓ᏈKvł闝ŔAbits=0̎ɂ̂܂܏sƁA(32-bits)rbg̃VtgsӏA32rbg̃VtgĂ܂łB
 *	  C̎dlɂA32rbg̃Vtg͕słAƂx86ł0rbgVtgƓƂȂAԈʂɂȂĂ܂łB
 *	- ̕ύXɂāAbitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()Asmł́AύXĂ܂B
 *	  Asmł̏́A32rbg̃VtgɂΉł悤ɍ쐬ĂÂ܂܏sĂʂƂȂ邩łB
 *	  Cł̕ύXƓlɁA̐擪œᏈsĂ\܂񂪁AR[hTCY邾ŖʂȂ̂ŁAᏈ̒ǉsȂƂɂ܂B
 *	  bits=0ŌĂяoP[XAłȂP[X̂̕ŁAbits=0̏ꍇ̐\}ēᏈǉ邱Ƃ́Ał͂܂B
 *	* Thu Dec 11 22:00:00 JST 2014 Naoyuki Sawa
 *	- bitarray_lsb1st_test(),bitarray_msb1st_test()ǉ܂B
 *	  gppx͒ႢƎv̂ŁAframbary.cł͂Ȃclipbary.cɊ܂߂܂B
 *	* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
 *	- bitarray_lsb1st_copy(),bitarray_msb1st_copy()ǉ܂B
 *	  gppx͒ႢƎv̂ŁAframbary.cł͂Ȃclipbary.cɊ܂߂܂B
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

#ifndef PIECE
void bitarray_lsb1st_set(void* ptr, int pos, int bits, int value) {
	//
	//	                                              s2               s1
	//	                                              /                /
	//	                                        +----------+----------------------+
	//	MSB|........ .......x xxxxxxxx xxxxxxxx|xxxxxxxx xxx..... ........ ........|LSB
	//	                    +------------------------------+                      |
	//	                                   /               |                      |
	//	                                 bits             pos                     p
	//	             mask = 1_11111111_11111111_11111111_111
	//
	int s1;
	int s2;
	int mask;
	int* p;
//{{2014/12/11ύX:bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
//	/* 1bitAyсA32bit߂̑͑ΉĂ܂B */
//	if((bits < 1) || (bits > 32)) { DIE(); }
//2014/12/11ύX:bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
	/* 32bit߂̑͑ΉĂ܂B */
	if((unsigned)bits > 32) { DIE(); }
	/* bits=0Ȃ΁AɋA܂B */
	if(!bits) { return; }
//}}2014/12/11ύX:bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
	/* 32bitPʂ̃|C^߂܂B */
	p = (int*)ptr + (pos >> 5);
	/* p[0]̈ʒuintlɊ܂܂Asvbit߂܂B */
	s1 = pos & 31;	/* 0`31 */
	/* p[0]̈ʒuintlɊ܂܂AKvbit߂܂B */
	s2 = 32 - s1;	/* 1`32 */
	/* i[ĺAsvbit}XN܂B */
	mask  = (unsigned)-1    >> (32 - bits);											//{{2014/12/11Rg:bits=0ȂΕs32rbgVtĝŁAbits=0ł֗Ȃ悤֐̐擪ŔfĂB}}
	value &= mask;
	/* p[0]̈ʒuintlɁAKvbit܂B */
	p[0] &= ~((unsigned)mask  << s1);
	p[0] |=   (unsigned)value << s1;
	/* p[1]̈ʒuintlɁAKvbit܂Ăc */
	if(bits > s2) {
		/* p[1]̈ʒuintlɁAKvbit܂B */
		p[1] &= ~((unsigned)mask  >> s2);
		p[1] |=   (unsigned)value >> s2;
	}
}
#else /*PIECE*/
void bitarray_lsb1st_set(void* ptr, int pos, int bits, int value);
asm("
		.code
		.align		1
		.global		bitarray_lsb1st_set
bitarray_lsb1st_set:
		;//-------------------------------------;//
		;// %r12 := ptr
		;// %r13 := pos
		;// %r14 := bits
		;// %r15 := value
		xand		%r4, %r13, 31		;// %r4  := s1 = pos & 31
;//{{xldextgߖ
;//		xld.w		%r5, 32			;// %r5  := s2 = 32 - s1
;//		sub		%r5, %r4
;//xldextgߖ
		not		%r5, %r4		;// %r5  := s2 = 32 - s1 = 33 + ~s1
		add		%r5, 33
;//}}xldextgߖ
		srl		%r13, 5			;// %r12 := p = (const int*)ptr + (pos >> 5)
		sll		%r13, 2
		add		%r12, %r13
		;//-------------------------------------;//
		;// %r4  := s1
		;// %r5  := s2
		;// %r12 := p
		;// %r14 := bits
		;// %r15 := value
		ld.w		%r6, -1			;// %r6  := -1
;//{{xldextgߖ
;//		xld.w		%r7, 32			;// %r7  := 32 - bits
;//		sub		%r7, %r14
;//xldextgߖ
		not		%r7, %r14		;// %r7  := 32 - bits = 33 + ~bits
		add		%r7, 33
;//}}xldextgߖ
;//{{%r7j󂵂Ăǂ̂xsrlœK
;//		xsrl		%r6, %r7		;// %r6  := mask = (unsigned)-1 >> (32 - bits)
;//%r7j󂵂Ăǂ̂xsrlœK
		cmp		%r7, 8			;//<---+								//{{2014/12/11Rg:Asmł32rbgVtg\Ȃ̂ŁACł̂悤ȓᏈ͕svŁAʏƓ@ŏč\ȂB}}
		jrle		4			;//--+ |
		srl		%r6, 8			;//  | |
		jp.d		-3			;//--|-+
		sub		%r7, 8			;//  |							*delay*
		srl		%r6, %r7		;//<-+
;//}}%r7j󂵂Ăǂ̂xsrlœK
		and		%r15, %r6		;// %r15 := value &= mask
		;//-------------------------------------;//
		;// %r4  := s1
		;// %r5  := s2
		;// %r6  := mask
		;// %r12 := p
		;// %r14 := bits
		;// %r15 := value
		ld.w		%r7, [%r12]		;// %r7  := tmp = p[0]
		ld.w		%r10, %r6		;// %r10 :=                   mask
		ld.w		%r11, %r15		;// %r11 :=                   value
;//{{%r4j󂵂Ăǂ̂xsllœK
;//		xsll		%r10, %r4		;// %r10 :=         (unsigned)mask  << s1
;//		xsll		%r11, %r4		;// %r11 :=         (unsigned)value << s1
;//%r4j󂵂Ăǂ̂xsllœK
		cmp		%r4, 8			;//<---+
		jrle		5			;//--+ |
		sll		%r10, 8			;//  | |
		sll		%r11, 8			;//  | |
		jp.d		-4			;//--|-+
		sub		%r4, 8			;//  |							*delay*
		sll		%r10, %r4		;//<-+
		sll		%r11, %r4
;//}}%r4j󂵂Ăǂ̂xsllœK
		not		%r10, %r10		;// %r10 :=       ~((unsigned)mask  << s1)
		and		%r7, %r10		;// %r7  := tmp & ~((unsigned)mask  << s1)
		or		%r7, %r11		;// %r7  := tmp & ~((unsigned)mask  << s1) | ((unsigned)value << s1)
		ld.w		[%r12]+, %r7		;// p[0]  = tmp
		;//-------------------------------------;//
		;// %r5  := s2
		;// %r6  := mask
		;// %r12 := p
		;// %r14 := bits
		;// %r15 := value
		cmp		%r14, %r5		;// if(bits > s2)
		jrle		14			;//---------------------------------------------------------------------+
		 ld.w		%r7, [%r12]		;//   %r7  := tmp = p[1]						|
;//{{%r5j󂵂Ăǂ̂xsrlœK		;//									|
;//		 xsrl		%r6, %r5		;//   %r6  :=         (unsigned)mask  >> s2				|
;//		 xsrl		%r15, %r5		;//   %r15 :=         (unsigned)value >> s2				|
;//%r5j󂵂Ăǂ̂xsrlœK		;//									|
		 cmp		%r5, 8			;//<---+								|
		 jrle		5			;//--+ |								|
		 srl		%r6, 8			;//  | |								|
		 srl		%r15, 8			;//  | |								|
		 jp.d		-4			;//--|-+								|
		 sub		%r5, 8			;//  |							*delay*		|
		 srl		%r6, %r5		;//<-+									|
		 srl		%r15, %r5		;//									|
;//}}%r5j󂵂Ăǂ̂xsrlœK		;//									|
		 not		%r6, %r6		;//   %r6  :=       ~((unsigned)mask  >> s2)				|
		 and		%r7, %r6		;//   %r7  := tmp & ~((unsigned)mask  >> s2)				|
		 or		%r7, %r15		;//   %r7  := tmp & ~((unsigned)mask  >> s2) | ((unsigned)value >> s2)	|
		 ld.w		[%r12], %r7		;//   p[1]  = tmp							|
		ret					;//<--------------------------------------------------------------------+
");
#endif/*PIECE*/

/*****************************************************************************
 *	
 *****************************************************************************/

#ifndef PIECE
void bitarray_msb1st_set(void* ptr, int pos, int bits, int value) {
	//
	//	                s1               s2
	//	                /                /
	//	    +----------------------+----------+
	//	MSB|........ ........ .....xxx xxxxxxxx|xxxxxxxx xxxxxxxx x....... ........|LSB
	//	    |                      +------------------------------+               |
	//	    |                      |              /                               |
	//	    p                     pos           bits                              p
	//	                    mask = 111_11111111_11111111_11111111_1
	//
	int s1;
	int s2;
	int mask;
	int* p;
//{{2014/12/11ύX:bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
//	/* 1bitAyсA32bit߂̑͑ΉĂ܂B */
//	if((bits < 1) || (bits > 32)) { DIE(); }
//2014/12/11ύX:bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
	/* 32bit߂̑͑ΉĂ܂B */
	if((unsigned)bits > 32) { DIE(); }
	/* bits=0Ȃ΁AɋA܂B */
	if(!bits) { return; }
//}}2014/12/11ύX:bitarray_lsb1st_get(),bitarray_msb1st_get(),bitarray_lsb1st_set(),bitarray_msb1st_set()ɁAbits=0wł悤ɕύX܂B
	/* 32bitPʂ̃|C^߂܂B */
	p = (int*)ptr + (pos >> 5);
	/* p[0]̈ʒuintlɊ܂܂Asvbit߂܂B */
	s1 = pos & 31;	/* 0`31 */
	/* p[0]̈ʒuintlɊ܂܂AKvbit߂܂B */
	s2 = 32 - s1;	/* 1`32 */
	/* i[ĺAsvbit}XN܂B */
	mask  = (unsigned)-1    << (32 - bits);											//{{2014/12/11Rg:bits=0ȂΕs32rbgVtĝŁAbits=0ł֗Ȃ悤֐̐擪ŔfĂB}}
	value = (unsigned)value << (32 - bits);											//{{2014/12/11Rg:bits=0ȂΕs32rbgVtĝŁAbits=0ł֗Ȃ悤֐̐擪ŔfĂB}}
	/* p[0]̈ʒuintlɁAKvbit܂B */
	p[0] &= ~((unsigned)mask  >> s1);
	p[0] |=   (unsigned)value >> s1;
	/* p[1]̈ʒuintlɁAKvbit܂Ăc */
	if(bits > s2) {
		/* p[1]̈ʒuintlɁAKvbit܂B */
		p[1] &= ~((unsigned)mask  << s2);
		p[1] |=   (unsigned)value << s2;
	}
}
#else /*PIECE*/
void bitarray_msb1st_set(void* ptr, int pos, int bits, int value);
asm("
		.code
		.align		1
		.global		bitarray_msb1st_set
bitarray_msb1st_set:
		;//-------------------------------------;//
		;// %r12 := ptr
		;// %r13 := pos
		;// %r14 := bits
		;// %r15 := value
		xand		%r4, %r13, 31		;// %r4  := s1 = pos & 31
;//{{xldextgߖ
;//		xld.w		%r5, 32			;// %r5  := s2 = 32 - s1
;//		sub		%r5, %r4
;//xldextgߖ
		not		%r5, %r4		;// %r5  := s2 = 32 - s1 = 33 + ~s1
		add		%r5, 33
;//}}xldextgߖ
		srl		%r13, 5			;// %r12 := p = (const int*)ptr + (pos >> 5)
		sll		%r13, 2
		add		%r12, %r13
		;//-------------------------------------;//
		;// %r4  := s1
		;// %r5  := s2
		;// %r12 := p
		;// %r14 := bits
		;// %r15 := value
		ld.w		%r6, -1			;// %r6  := -1
;//{{xldextgߖ
;//		xld.w		%r7, 32			;// %r7  := 32 - bits
;//		sub		%r7, %r14
;//xldextgߖ
		not		%r7, %r14		;// %r7  := 32 - bits = 33 + ~bits
		add		%r7, 33
;//}}xldextgߖ
;//{{%r7j󂵂Ăǂ̂xsllœK
;//		xsll		%r6, %r7		;// %r6  := mask  = (unsigned)-1    << (32 - bits)
;//		xsll		%r15, %r7		;// %r15 := value = (unsigned)value << (32 - bits)
;//%r7j󂵂Ăǂ̂xsllœK
		cmp		%r7, 8			;//<---+								//{{2014/12/11Rg:Asmł32rbgVtg\Ȃ̂ŁACł̂悤ȓᏈ͕svŁAʏƓ@ŏč\ȂB}}
		jrle		5			;//--+ |
		sll		%r6, 8			;//  | |
		sll		%r15, 8			;//  | |
		jp.d		-4			;//--|-+
		sub		%r7, 8			;//  |							*delay*
		sll		%r6, %r7		;//<-+
		sll		%r15, %r7		;//
;//}}%r7j󂵂Ăǂ̂xsllœK
		;//-------------------------------------;//
		;// %r4  := s1
		;// %r5  := s2
		;// %r6  := mask
		;// %r12 := p
		;// %r14 := bits
		;// %r15 := value
		ld.w		%r7, [%r12]		;// %r7  := tmp = p[0]
		ld.w		%r10, %r6		;// %r10 :=                   mask
		ld.w		%r11, %r15		;// %r11 :=                   value
;//{{%r4j󂵂Ăǂ̂xsrlœK
;//		xsrl		%r10, %r4		;// %r10 :=         (unsigned)mask  >> s1
;//		xsrl		%r11, %r4		;// %r11 :=         (unsigned)value >> s1
;//%r4j󂵂Ăǂ̂xsrlœK
		cmp		%r4, 8			;//<---+
		jrle		5			;//--+ |
		srl		%r10, 8			;//  | |
		srl		%r11, 8			;//  | |
		jp.d		-4			;//--|-+
		sub		%r4, 8			;//  |							*delay*
		srl		%r10, %r4		;//<-+
		srl		%r11, %r4
;//}}%r4j󂵂Ăǂ̂xsrlœK
		not		%r10, %r10		;// %r10 :=       ~((unsigned)mask  >> s1)
		and		%r7, %r10		;// %r7  := tmp & ~((unsigned)mask  >> s1)
		or		%r7, %r11		;// %r7  := tmp & ~((unsigned)mask  >> s1) | ((unsigned)value >> s1)
		ld.w		[%r12]+, %r7		;// p[0]  = tmp
		;//-------------------------------------;//
		;// %r5  := s2
		;// %r6  := mask
		;// %r12 := p
		;// %r14 := bits
		;// %r15 := value
		cmp		%r14, %r5		;// if(bits > s2)
		jrle		14			;//---------------------------------------------------------------------+
		 ld.w		%r7, [%r12]		;//   %r7  := tmp = p[1]						|
;//{{%r5j󂵂Ăǂ̂xsllœK		;//									|
;//		 xsll		%r6, %r5		;//   %r6  :=         (unsigned)mask  << s2				|
;//		 xsll		%r15, %r5		;//   %r15 :=         (unsigned)value << s2				|
;//%r5j󂵂Ăǂ̂xsllœK		;//									|
		 cmp		%r5, 8			;//<---+								|
		 jrle		5			;//--+ |								|
		 sll		%r6, 8			;//  | |								|
		 sll		%r15, 8			;//  | |								|
		 jp.d		-4			;//--|-+								|
		 sub		%r5, 8			;//  |							*delay*		|
		 sll		%r6, %r5		;//<-+									|
		 sll		%r15, %r5		;//									|
;//}}%r5j󂵂Ăǂ̂xsllœK		;//									|
		 not		%r6, %r6		;//   %r6  :=       ~((unsigned)mask  << s2)				|
		 and		%r7, %r6		;//   %r7  := tmp & ~((unsigned)mask  << s2)				|
		 or		%r7, %r15		;//   %r7  := tmp & ~((unsigned)mask  << s2) | ((unsigned)value << s2)	|
		 ld.w		[%r12], %r7		;//   p[1]  = tmp							|
		ret					;//<--------------------------------------------------------------------+
");
#endif/*PIECE*/

/*****************************************************************************
 *	
 *****************************************************************************/

#ifndef PIECE
static int bitarray_test(const int* ptr, int pos, int bits, int (*fnGet)(const void*, int, int));
int bitarray_lsb1st_test(const void* ptr, int pos, int bits) { return bitarray_test(ptr, pos, bits, bitarray_lsb1st_get); }
int bitarray_msb1st_test(const void* ptr, int pos, int bits) { return bitarray_test(ptr, pos, bits, bitarray_msb1st_get); }
static int bitarray_test(const int* ptr, int pos, int bits, int (*fnGet)(const void*, int, int)) {
	int m, n, v;
	ptr += pos >> 5;				//rbg͈͂̐擪܂ށA擪[h̃AhXB
	pos &= 31;					//rbg͈͂̐擪́A擪[hł̃rbgʒu(0`31)B
	if(!pos) { goto L20; }				//Lrbgʒu0Ȃ΁AL20ցB
	//---------------------------------------------------------------------
	m = 32 - pos;					//LrbgʒuA擪[h̖܂ł̃rbgB
	n = bits;					//鑍rbgB
	if(m < n) { n = m; }				//擪[h擾rbgB
	v = (*fnGet)(ptr, pos, n);			//擪[hrbg擾B					//{{2014/12/11Rg:n=0łSłB}}
	if(v) { return v; }				//1̃rbgL΁A0ȊO̒lԂB
	bits -= n;					//擾rbgA鑍rbg獷B
	ptr++;						//̃[h֐i߂B
	//---------------------------------------------------------------------
	goto L20;					//[vœK̂'while{`}'do{`}while'ɕϊBL20JnB
	do {
		v = *ptr++;				//݂̃[h擾āÃ[h֐i߂B
		if(v) { return v; }			//1̃rbgL΁A0ȊO̒lԂB
L20:		bits -= 32;				//鑍rbg32rbgȏcĂ΁c
	} while(bits >= 0);				//
	//---------------------------------------------------------------------
	bits += 32;					//L[v𔲂鎞Ɉ߂Ă̂Ŗ߂B
	v = (*fnGet)(ptr, 0, bits);			//鑍rbgcĂ΁A擾B				//{{2014/12/11Rg:bits=0łSłB}}
	return v;					//1̃rbgL΁A0ȊO̒lԂB
}
#else //PIECE
int bitarray_lsb1st_test(const void* ptr, int pos, int bits);
int bitarray_msb1st_test(const void* ptr, int pos, int bits);
asm("
		.code
		.align		1
		.global		bitarray_lsb1st_test
		.global		bitarray_msb1st_test
bitarray_lsb1st_test:
		xld.w		%r15, bitarray_lsb1st_get	;//%r15 := fnGet = bitarray_lsb1st_get
		jp		bitarray_test			;//
bitarray_msb1st_test:
		xld.w		%r15, bitarray_msb1st_get	;//%r15 := fnGet = bitarray_msb1st_get
bitarray_test:
		pushn		%r2
		ld.w		%r0, %r15			;//%r0  := fnGet
		ld.w		%r1, %r12			;//%r1  := ptr
		ld.w		%r2, %r14			;//%r2  := bits
		;//%r0  := fnGet
		;//%r1  := ptr
		;//%r2  := bits
		;//%r12 := ptr
		;//%r13 := pos
		;//%r14 := n = bits
		ld.w		%r9, %r13			;//%r9  :=         pos
		sra		%r9, 5				;//%r9  :=         pos >> 5
		sla		%r9, 2				;//%r9  :=        (pos >> 5) << 2
	;//	add		%r1, %r9			;//%r1  := ptr += (pos >> 5) << 2	
		and		%r13, 31			;//%r13 := pos &= 31			@
		jreq.d		bitarray_test_L20		;//if(!pos) { goto L20 }		@
		add		%r1, %r9			;//%r1  := ptr += (pos >> 5) << 2		*delay*
		not		%r9, %r13			;//%r9  := m =            ~pos
		add		%r9, 33				;//%r9  := m = 32 - pos = ~pos + 33
		cmp		%r9, %r14			;//if(m < n) { n = m }
		jrge.d		3				;//
		 ld.w		%r12, %r1			;//%r12 :=              ptr			*delay*
		 ld.w		%r14, %r9			;//
		sub		%r2, %r14			;//%r2  := bits -= n
		call.d		%r0				;//%r10 := v = (*fnGet)(ptr, pos, n)				//{{2014/12/11Rg:n=0łSłB}}
		add		%r1, 4				;//%r1  := ptr  += 4				*delay*
		cmp		%r10, 0				;//if(v) { return v }
		jrne		bitarray_test_RET		;//
		;//---------------------------------------------;//
		;//%r1  := ptr
		;//%r2  := bits
		jp		bitarray_test_L20		;//goto L20
bitarray_test_L10:						;//do {
		ld.w		%r10, [%r1]+			;//  %r10 := v = *ptr++
		cmp		%r10, 0				;//  if(v) { return v }
		jrne		bitarray_test_RET		;//  
bitarray_test_L20:						;//  
		sub		%r2, 32				;//  %r2  := bits -= 32
		jrge		bitarray_test_L10		;//} while(  bits >= 0)
		;//---------------------------------------------;//
		add		%r2, 32				;//%r2  := bits += 32
		ld.w		%r12, %r1			;//%r12 :=              ptr
		ld.w		%r13, 0				;//%r13 :=                   0
		call.d		%r0				;//%r10 := v = (*fnGet)(ptr, 0, bits)				//{{2014/12/11Rg:bits=0łSłB}}
		ld.w		%r14, %r2			;//%r14 :=                      bits		*delay*
bitarray_test_RET:
		popn		%r2
		ret						;//return v
");
#endif//PIECE

/*****************************************************************************
 *	
 *****************************************************************************/

#ifndef PIECE
static void bitarray_copy_subr(void* dst_ptr, int dst_pos, const void* src_ptr, int src_pos, int bits, int (*get)(const void*, int, int), void (*set)(void*, int, int, int)) {
	int n, value;
	if(bits < 0) { DIE(); }
	while(bits) {						//Rs[rbgcĂc
		n = (bits < 32) ? bits : 32;			//Rs[rbg肷B
		value = (*get)(src_ptr, src_pos, n);		//Rs[rbgz񂩂l擾B
		        (*set)(dst_ptr, dst_pos, n, value);	//Rs[rbgzɒli[B
		src_pos += n;					//Rs[̃rbgʒui߂B
		dst_pos += n;					//Rs[̃rbgʒui߂B
		bits    -= n;					//Rs[rbg炷B
	}
}
#else //PIECE
/*static*/ void bitarray_copy_subr(void* dst_ptr, int dst_pos, const void* src_ptr, int src_pos, int bits, int (*get)(const void*, int, int), void (*set)(void*, int, int, int));
asm("
		.code
		.align		1
bitarray_copy_subr:
		pushn		%r3
		xsub		%sp, %sp, 8
		;//%r12     := dst_ptr
		;//%r13     := dst_pos
		;//%r14     := src_ptr
		;//%r15     := src_pos
		;//[%sp+ 8] := %r0
		;//[%sp+12] := %r1
		;//[%sp+16] := %r2
		;//[%sp+20] := %r3
		;//[%sp+24] := retp
		;//[%sp+28] := bits
		;//[%sp+32] := get
		;//[%sp+36] := set
		xld.w		[%sp+0], %r12			;//[%sp+0] := dst_ptr
		ld.w		%r0, %r13			;//%r0     := dst_pos
		xld.w		[%sp+4], %r14			;//[%sp+4] := src_ptr
		ld.w		%r1, %r15			;//%r1     := src_pos
		xld.w		%r2, [%sp+28]			;//%r2     := bits
bitarray_copy_subr_LOOP:					;//for(;;) {
		ld.w		%r3, %r2			;//  %r3   := n     = bits	//,y,R[hTCY팸̂߂ɁACłƂ͏ASYς܂B쌋ʂ͓łB
		sub		%r2, 32				;//  %r2   := bits -= 32	//1. 32rbgObitsnɃRs[B
		jrge		2				;//  if(bits < 0) {		//2. 32rbgbits߂B
		 ld.w		%r2, 0				;//    %r2 := bits  = 0 }	//3. bits0rbgȂ0rbgɂB
		sub		%r3, %r2			;//  %r3   := n    -= bits	//4. (n-bits)]rbgłB
		jreq		bitarray_copy_subr_RET		;//  if(!n) { break }		//5. ]rbg0rbgȂ΃[v𔲂B	32rbgObits=0ꍇɁA32rbgbits=0,y,n=(0-0)=0ƂȂȀBȊȌꍇɁȀ鎖͖B
		xld.w		%r9, [%sp+32]			;//  %r9   :=           get
		xld.w		%r12, [%sp+4]			;//  %r12  :=                src_ptr
		ld.w		%r13, %r1			;//  %r13  :=                         src_pos
		call.d		%r9				;//  %r10  := value = (*get)(src_ptr, src_pos, n)
		ld.w		%r14, %r3			;//  %r14  :=                                  n		*delay*
		ld.w		%r15, %r10			;//  %r15  :=                                     value
		xld.w		%r9, [%sp+36]			;//  %r9   :=           set
		xld.w		%r12, [%sp+0]			;//  %r12  :=                dst_ptr
		ld.w		%r13, %r0			;//  %r13  :=                         dst_pos
		call.d		%r9				;//                   (*set)(dst_ptr, dst_pos, n, value)
		ld.w		%r14, %r3			;//  %r14  :=                                  n		*delay*
		add		%r0, %r3			;//  %r0   := dst_pos += n
		jp.d		bitarray_copy_subr_LOOP		;//}
		add		%r1, %r3			;//  %r1   := src_pos += n					*delay*
bitarray_copy_subr_RET:
		xadd		%sp, %sp, 8
		popn		%r3
		ret
");
#endif//PIECE
void bitarray_lsb1st_copy(void* dst_ptr, int dst_pos, const void* src_ptr, int src_pos, int bits) {	//LSBso[W
	bitarray_copy_subr(dst_ptr, dst_pos, src_ptr, src_pos, bits, bitarray_lsb1st_get, bitarray_lsb1st_set);
}
void bitarray_msb1st_copy(void* dst_ptr, int dst_pos, const void* src_ptr, int src_pos, int bits) {	//MSBso[W
	bitarray_copy_subr(dst_ptr, dst_pos, src_ptr, src_pos, bits, bitarray_msb1st_get, bitarray_msb1st_set);
}
