/*	
 *	clipay.h
 *
 *	P/ECE AY Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Nov 30 20:03:00 JST 2003 Naoyuki Sawa
 *	- Z80RAREAD/WRITEO֐g߁AAYDRIVER\̂̃CAEgύX܂B
 *	* Sat Feb 07 22:29:00 JST 2004 Naoyuki Sawa
 *	- PSG(AY-3-8910)G~[VAclippsg.*clipay3.*ɕύX܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 */
#ifndef __CLIP_AY_H__
#define __CLIP_AY_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	AYt@Cdl
 ****************************************************************************/

/* n[t[hlǂݍ (BigEndianŁAHWACgĂ܂!!) */
#define AYHALF(h)	(((unsigned char*)&h)[0] << 8 | ((unsigned char*)&h)[1])

/* ItZbg|C^ϊ (ItZbgϐg̃AhXɑ΂ł) */
#define AYPTR(o)	((unsigned char*)&(o) + (short)AYHALF(o))

/*
 *	AYt@Cwb_
 */
typedef struct _AYHEADER {
	char FileID[4];			/* + 0, 4: "ZYAY"Œ */
	char TypeID[4];			/* + 4, 4: "EMUL"Œ */
	unsigned char FileVersion;	/* + 8, 1: (g܂)o[W */
	unsigned char PlayerVersion;	/* + 9, 1: (g܂)o[W */
	short PSpecialPlayer;		/* +10, 2: (g܂)ȃvC[p */
	short PAuthor;			/* +12, 2: Җւ̃ItZbg */
	short PMisc;			/* +14, 2: ̑ւ̃ItZbg */
	unsigned char NumOfSongs;	/* +16, 1: Ȑ-1(v!!) */
	unsigned char FirstSong;	/* +17, 1: ŏɉtȂ̔ԍ */
	short PSongsStructure;		/* +18, 2: ȏzւ̃ItZbg */
} AYHEADER;				/* =20 */

/*
 *	ȏ
 */
typedef struct _AYSONGSTRUCTURE {
	short PSongName;		/* + 0, 2: Ȗւ̃ItZbg */
	short PSongData;		/* + 2, 2: ȃf[^ւ̃ItZbg */
} AYSONGSTRUCTURE;			/* = 4 */

/*
 *	ȃf[^
 */
typedef struct _AYSONGDATA {
	unsigned char AChan;		/* + 0, 1: (g܂)AMIGAp`l蓖 */
	unsigned char BChan;		/* + 1, 1: (g܂)AMIGAp`l蓖 */
	unsigned char CChan;		/* + 2, 1: (g܂)AMIGAp`l蓖 */
	unsigned char Noise;		/* + 3, 1: (g܂)AMIGAp`l蓖 */
	unsigned short SongLength;	/* + 4, 2: (g܂)t */
	unsigned short FadeLength;	/* + 6, 2: (g܂)tF[h */
	unsigned char HiReg;		/* + 8, 1: ʃWX^l */
	unsigned char LoReg;		/* + 9, 1: ʃWX^l */
	short PPoints;			/* +10, 2: |Cgf[^ւ̃ItZbg */
	short PAddresses;		/* +12, 2: ubNf[^zւ̃ItZbg */
} AYSONGDATA;				/* =14 */

/*
 *	|Cgf[^
 */
typedef struct _AYPOINTDATA {
	unsigned short Stack;		/* + 0, 2: X^bN|C^l  (BigEndianv!!) */
	unsigned short Init;		/* + 2, 2: [`AhX  (BigEndianv!!) */
	unsigned short Inter;		/* + 4, 2: 荞݃[`AhX(BigEndianv!!) */
} AYPOINTDATA;				/* = 6 */

/*
 *	ubNf[^
 */
typedef struct _AYBLOCKDATA {
	unsigned short Address;		/* + 0, 2: ]AhX(0:I[) */
	unsigned short Length;		/* + 2, 4: ]TCY */
	short Offset;			/* + 4, 2: ]f[^ւ̃ItZbg */
} AYBLOCKDATA;				/* = 6 */

/****************************************************************************
 *	AYhCo
 ****************************************************************************/

#define AYBUFLEN		AY38910BUFLEN	/* 1[tick](=1/50[sec])̃Tv */

#define AY_ZX_Z80_CLOCK		3546900		/* ZX-SpectrumZ80A     NbN[Hz] */
#define AY_ZX_AY38910_CLOCK	1773400		/* ZX-SpectrumAY-3-8910̓NbN[Hz] */

/*
 *	AYhCo
 */
typedef struct _AYDRIVER {
	/*===== Z80 =====*/
	/* Z80RAREAD/WRITEO֐𗘗p邽߂ɁÃoCiCAEgK{łB */
	Z80 z80;			/* +    0,   64: Z80A */
	unsigned char mem[0x10000];	/* +   64,65536: Z80AC */
	/*===== AY-3-8910 =====*/
	AY38910 ay38910;		/* +65600,   64: AY-3-8910 */
} AYDRIVER;

/*
 *	Z80G~[VpO֐
 */
unsigned char ay_z80_in(struct _Z80* z80, unsigned short addr);
void ay_z80_out(struct _Z80* z80, unsigned short addr, unsigned char data);

/*
 *	AYhCo֐
 */
int ay_init(AYDRIVER* ay, const void* data, int i_song);
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//int ay_stream_callback(short* wbuff, int param);
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
int ay_stream_callback(short* wbuff, intptr_t param);
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* AYt@C̍ĐJn܂B
 * [in]
 *	data		AYf[^̐擪AhXB
 *	i_song		gbNԍB(0`NumOfSongs)
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKay_stop()ĂŁAxN^𕜌ĂB
 */
int ay_play(const void* data, int i_song);

/* AYt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void ay_stop();

/* AYt@C̓eAWG[o͂Ƀ_v܂B
 * [in]
 *	data		AYf[^̐擪AhXB
 */
void ay_dump(const void* data);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_AY_H__*/
