/*
 *	clipadp.c
 *
 *	2-bit ADPCM Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Wed Dec 20 00:13:10 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Dec 20 17:31:02 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Mar 01 01:53:43 JST 2007 Naoyuki Sawa
 *	- adpcm_stat()ǉ܂B
 *	* Mon Jul 15 20:32:11 JST 2013 Naoyuki Sawa
 *	- ADPCMCHANNEL\̂ёւAvoltB[hǉ܂B
 *	- ʐݒ@\ɑΉ邽߁Aadpcm_att()֐ǉ܂B
 *	- RAMߖ񂷂邽߁AWe[uframadp.cclipadp.cֈړ܂B
 *	* Mon Jun 26 22:31:39 JST 2017 Naoyuki Sawa
 *	- adpcm_play()ɂāAvolatilew肪sĂR삵ĂR[hAvolatilet悤ɏC܂B
 *	- adpcm_rate()֐ǉ܂B
 *	* Tue Jun 27 22:55:03 JST 2017 Naoyuki Sawa
 *	- 2017/06/26̕ύXɂčŏI[v̒~O1Tvo͂ȂȂĂC܂B
 *	- [vprogressZbgɈpɂ܂B
 *	* Wed Aug 16 22:59:27 JST 2017 Naoyuki Sawa
 *	- 64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
 *	* Sat Aug 19 22:58:59 JST 2017 Naoyuki Sawa
 *	- adpcm_play()ɂleňvZI[o[t[āAԈōĐĂ܂LoOC܂B
 */
#include "clip.h"

/****************************************************************************
 *	[Jϐ
 ****************************************************************************/

static ADPCMDRIVER driver;

//{{2013/07/15ǉ:RAMߖ񂷂邽߁AWe[uframadp.cclipadp.cֈړ܂B
//static const short adpcm_tbl[4/*ADPCMl*/][2] = {
//	{  128, 233 },	/* + 0,4 */
//	{  384, 375 },	/* + 4,4 */
//	{ -128, 233 },	/* + 8,4 */
//	{ -384, 375 },	/* +12,4 */
//};			/* =16   */
//* Fri Dec 22 00:19:41 JST 2006 Naoyuki Sawa
#define A	233	/* =(    1.1^-1)*256 */
#define B	375	/* =(    1.1^ 4)*256 */
#define C	141	/* =(0.5/1.1^-1)*256 */
#define D	263	/* =(1.5/1.1^ 4)*256 */
/*static*/ const short adpcm_tbl[4/*ADPCMl*/][2] = {
#ifndef ADPCM_ASM
	{ A,  C },
	{ B,  D },
	{ A, -C },
	{ B, -D },
#else /*ADPCM_ASM*/
	/* ASMłł́A[hPʂłǂɎ擾āAʃn[tAʃn[t̏ɗp܂B
	 * ʃn[tʃn[tֈړہA"xsra %rd,16"ł2߂ɓWJ܂A
	 * ȉ̂悤ɁA\ߏʃn[tSwapĂ΁A"swap %rd,%rs"1߂ňړł܂B
	 */
	{ A, SWAPH( C) },
	{ B, SWAPH( D) },
	{ A, SWAPH(-C) },
	{ B, SWAPH(-D) },
#endif /*ADPCM_ASM*/
};
#undef A
#undef B
#undef C
#undef D
//}}2013/07/15ǉ:RAMߖ񂷂邽߁AWe[uframadp.cclipadp.cֈړ܂B

/****************************************************************************
 *	[J֐
 ****************************************************************************/

static int
//{{2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
//adpcm_stream_callback(short wbuff[/*ADPCMBUFLEN*/], int param/*NOUSE*/)
//2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
adpcm_stream_callback(short wbuff[/*ADPCMBUFLEN*/], intptr_t param/*NOUSE*/)
//}}2017/08/16ύX:64rbgΉ̂߂ɁASTREAMCALLBACKparam̌^Aintintptr_tɕύX܂B
{
	static int mixbuf[ADPCMBUFLEN]; /* ~LVOobt@Ars`shbłI */
	//
	int i;

	/* ~LVOobt@NA܂B */
	memset(mixbuf, 0, sizeof mixbuf);

	/* e`lɂ... */
	for(i = 0; i < driver.nch; i++) {
		/* ĐȂ... */
		if(driver.pch[i].loop) {
			/* `l̏o͂A~LVOobt@֍܂B */
			adpcm_mix1(&driver.pch[i], mixbuf);
		}
	}

	/* ~LVOobt@NbsOāAo̓obt@֏݂܂B */
	adpcm_mix2(wbuff, mixbuf);

	return 0;
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
adpcm_init(int nch)
{
	int i;

	/* mɖԂɂ܂B */
	adpcm_exit();

	/* `l\̂mۂ܂B */
	driver.nch = nch;
	driver.pch = calloc(nch, sizeof(ADPCMCHANNEL));
	if(!driver.pch) {
		DIE(); /* s */
	}

//{{2013/07/15ǉ
	/* S`l̉ʂAɏ܂B */
	for(i = 0; i < driver.nch; i++) {
		adpcm_att(i, 0);
	}
//}}2013/07/15ǉ

	/* Xg[ĐJn܂B
	 * - X^bN̎gppxȂ̂ŁAX^bNؑւgȂƂɂ܂B
	 *   ۂ̃AvP[VŎĂ݂āAǂ炪f\łB
	 * 2006/12/21ǋL
	 * - \ǂAX^bNؑւgȂł邱ƂmF܂B
	 */
	stream_play(ADPCMBUFLEN, adpcm_stream_callback, 0/*NOUSE*/, 0/*X^bN؊gȂ*/);
}

void
adpcm_exit()
{
	/* mɃXg[Đ~܂B */
	stream_stop();

	/* mɃ`l\̂܂B */
	free(driver.pch/*NULLOK*/);
	memset(&driver, 0, sizeof driver); /*Kv!!*/
}

void
adpcm_play(int ch, const void* data, int loop)
{
//{{2017/06/26ύX:adpcm_play()ɂāAvolatilew肪sĂR삵ĂR[hAvolatilet悤ɏC܂B
//	ADPCMCHANNEL* pch;
//2017/06/26ύX:adpcm_play()ɂāAvolatilew肪sĂR삵ĂR[hAvolatilet悤ɏC܂B
// * Mon Jun 26 22:31:39 JST 2017 Naoyuki Sawa
// - ̉̏ŁApch->loopɒli[鏇ɈˑĂ̂ŁApchɂvolatilew肪K{łB
//   ܂łpchvolatilew肵Ă炸AɌ΁ARpCڂ́upch->loop = 0;vœKč폜Apch->loopƂ̑̃tB[h̊i[ւ\LAȂƐ삵Ȃ̂łA
//   ܂܁Agcc33.exeApchvolatilew肵ꍇƓR[h𐶐Ă悤ŁARA삵Ă܂B
//   Ƃ͌Apchvolatilew肪s܂܂ƁAAׂȃR[h̕ύXɂGCC̍œKςA삵ȂȂR[h鋰ꂪL̂ŁAAƁApchvolatilewǉĂɂ܂B
	volatile ADPCMCHANNEL* pch;
//}}2017/06/26ύX:adpcm_play()ɂāAvolatilew肪sĂR삵ĂR[hAvolatilet悤ɏC܂B
	const PCEWAVEINFO* pwi;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	if(memcmp(data, "MCPP", 4) != 0) {
		DIE(); /* VOl`s */
	}
	pwi = (const PCEWAVEINFO*)((const unsigned char*)data + 4/*VOl`*/ + 4/*TCY*/);
	if((pwi->type & 3) != PW_TYPE_2BITADPCM) {
		DIE(); /* 2bit-ADPCMłȂ */
	}

//{{2017/06/26ύX:adpcm_rate()֐ǉ܂B
//	pch->loop = 0;
//	/*{{̊ԂŊ荞݂ĂA~`lƌȂ̂ňSł*/
////{{2013/07/15ύX
////	pch->pcm      = 0;
////	pch->data     = 0;
////	pch->delta    = 16;
////	pch->progress = 0;
////	pch->rate     = pwi->resv;
////	pch->len      = pwi->len;
////	pch->ptr      = (const unsigned char*)(pwi + 1); /* "pwi->pData"ł͂܂!! */
////	pch->init_len = pch->len;
////	pch->init_ptr = pch->ptr;
////2013/07/15ύX
//	pch->ptr      = (const unsigned char*)(pwi + 1); /* "pwi->pData"ł͂܂!! */
//	pch->len      = pwi->len;
//	pch->pcm      = 0;
//	pch->data     = 0;
//	pch->delta    = 16;
//	pch->progress = 0;
//	pch->rate     = pwi->resv;
////	pch->vol      = ĐJnɉʂAݒ肳Ă鉹ʂpƂɂ܂BpceWaveSetChAtt()̋ɍ킹邽߂łB
//	pch->init_ptr = pch->ptr;
//	pch->init_len = pch->len;
////}}2013/07/15ύX
//	/*}}̊ԂŊ荞݂ĂA~`lƌȂ̂ňSł*/
//	pch->loop = loop;
//2017/06/26ύX:adpcm_rate()֐ǉ܂B
	{
		int rate = pwi->resv;
	//{{2018/08/19ύX:adpcm_play()ɂleňvZI[o[t[āAԈōĐĂ܂LoOC܂B
	//	int len  = ((pwi->len * rate) + (SPEAKER_FREQUENCY - 1)) / SPEAKER_FREQUENCY;	//16000HzZł̃TvˎTvɕϊB'/clip/tool/dppcmcnv/main.cwriteadpcm2()'ɂĎTv16000HzZł̃Tvɕϊ鎞͒[؂̂ĂĂ̂ŁAł͋tɒ[؂グ鎖ɂČ̎Tvɖ߂͂B(v)
	//2018/08/19ύX:adpcm_play()ɂleňvZI[o[t[āAԈōĐĂ܂LoOC܂B
		int len  = (((int64_t)pwi->len * rate) + (SPEAKER_FREQUENCY - 1)) / SPEAKER_FREQUENCY;	//16000HzZł̃TvˎTvɕϊB'/clip/tool/dppcmcnv/main.cwriteadpcm2()'ɂĎTv16000HzZł̃Tvɕϊ鎞͒[؂̂ĂĂ̂ŁAł͋tɒ[؂グ鎖ɂČ̎Tvɖ߂͂B(v)
		//           ~~~~~~~~~Ⴆ΃TEhf[^16KHzŖ17bȏ̎ɁA(pwi->len*rate)I[o[t[ĎŜԈʂɂȂBʂ𓾂邽߂ɂ͎Ŝ64bitŌvZKvLÂ߂ɂpwi->len,,ratêǂ炩(ł\Ȃ)64bitɃLXgΗǂBpwi->len64bitɃLXg@őΉB
	//}}2018/08/19ύX:adpcm_play()ɂleňvZI[o[t[āAԈōĐĂ܂LoOC܂B
		const unsigned char* ptr = (const unsigned char*)(pwi + 1); /* "pwi->pData"ł͂܂!! */
		{
			pch->loop = 0;
			/*{{̊ԂŊ荞݂ĂA~`lƌȂ̂ňSł*/
			pch->ptr      = ptr;
			pch->len      = len;
			pch->pcm      = 0;
			pch->data     = 0;
			pch->delta    = 16;
			pch->progress = 0;
			pch->rate     = rate;
		//	pch->vol      = ĐJnɉʂAݒ肳Ă鉹ʂpƂɂ܂BpceWaveSetChAtt()̋ɍ킹邽߂łB
			pch->init_ptr = ptr;
			pch->init_len = len;
			/*}}̊ԂŊ荞݂ĂA~`lƌȂ̂ňSł*/
			pch->loop = loop;
		}
	}
//}}2017/06/26ύX:adpcm_rate()֐ǉ܂B
}

void
adpcm_stop(int ch)
{
	ADPCMCHANNEL* pch;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	pch->loop = 0; /* 1[h݂̏Ȃ̂ŁA荞݋֎~͕svł */
}

int
adpcm_stat(int ch)
{
	ADPCMCHANNEL* pch;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	return pch->loop; /* 1[h̓ǂݏoȂ̂ŁA荞݋֎~͕svł */
}

//{{2013/07/15ǉ
void
adpcm_att(int ch, int att)
{
	static const unsigned char dbtbl[64] = {
		256/*(1<<8)/(10^( 0/20))*/-1,229/*(1<<8)/(10^( 1/20))*/-1,204/*(1<<8)/(10^( 2/20))*/-1,182/*(1<<8)/(10^( 3/20))*/-1,
		162/*(1<<8)/(10^( 4/20))*/-1,144/*(1<<8)/(10^( 5/20))*/-1,129/*(1<<8)/(10^( 6/20))*/-1,115/*(1<<8)/(10^( 7/20))*/-1,
		102/*(1<<8)/(10^( 8/20))*/-1, 91/*(1<<8)/(10^( 9/20))*/-1, 81/*(1<<8)/(10^(10/20))*/-1, 73/*(1<<8)/(10^(11/20))*/-1,
		 65/*(1<<8)/(10^(12/20))*/-1, 58/*(1<<8)/(10^(13/20))*/-1, 52/*(1<<8)/(10^(14/20))*/-1, 46/*(1<<8)/(10^(15/20))*/-1,
		 41/*(1<<8)/(10^(16/20))*/-1, 37/*(1<<8)/(10^(17/20))*/-1, 33/*(1<<8)/(10^(18/20))*/-1, 29/*(1<<8)/(10^(19/20))*/-1,
		 26/*(1<<8)/(10^(20/20))*/-1, 23/*(1<<8)/(10^(21/20))*/-1, 21/*(1<<8)/(10^(22/20))*/-1, 19/*(1<<8)/(10^(23/20))*/-1,
		 17/*(1<<8)/(10^(24/20))*/-1, 15/*(1<<8)/(10^(25/20))*/-1, 13/*(1<<8)/(10^(26/20))*/-1, 12/*(1<<8)/(10^(27/20))*/-1,
		 11/*(1<<8)/(10^(28/20))*/-1, 10/*(1<<8)/(10^(29/20))*/-1,  9/*(1<<8)/(10^(30/20))*/-1,  8/*(1<<8)/(10^(31/20))*/-1,
		  7/*(1<<8)/(10^(32/20))*/-1,  6/*(1<<8)/(10^(33/20))*/-1,  6/*(1<<8)/(10^(34/20))*/-1,  5/*(1<<8)/(10^(35/20))*/-1,
		  5/*(1<<8)/(10^(36/20))*/-1,  4/*(1<<8)/(10^(37/20))*/-1,  4/*(1<<8)/(10^(38/20))*/-1,  3/*(1<<8)/(10^(39/20))*/-1,
		  3/*(1<<8)/(10^(40/20))*/-1,  3/*(1<<8)/(10^(41/20))*/-1,  3/*(1<<8)/(10^(42/20))*/-1,  2/*(1<<8)/(10^(43/20))*/-1,
		  2/*(1<<8)/(10^(44/20))*/-1,  2/*(1<<8)/(10^(45/20))*/-1,  2/*(1<<8)/(10^(46/20))*/-1,  2/*(1<<8)/(10^(47/20))*/-1,
		  2/*(1<<8)/(10^(48/20))*/-1,  1/*(1<<8)/(10^(49/20))*/-1,  1/*(1<<8)/(10^(50/20))*/-1,  1/*(1<<8)/(10^(51/20))*/-1,
		  1/*(1<<8)/(10^(52/20))*/-1,  1/*(1<<8)/(10^(53/20))*/-1,  1/*(1<<8)/(10^(54/20))*/-1,  1/*(1<<8)/(10^(55/20))*/-1,
		  1/*(1<<8)/(10^(56/20))*/-1,  1/*(1<<8)/(10^(57/20))*/-1,  1/*(1<<8)/(10^(58/20))*/-1,  1/*(1<<8)/(10^(59/20))*/-1,
		  1/*(1<<8)/(10^(60/20))*/-1,  1/*(1<<8)/(10^(61/20))*/-1,  1/*(1<<8)/(10^(62/20))*/-1,  1/*(1<<8)/(10^(63/20))*/-1,
	};
	ADPCMCHANNEL* pch;

	if((ch < 0) || (ch > driver.nch - 1)) {
		DIE(); /* A܂́A`lԍs */
	}
	pch = &driver.pch[ch];

	pch->vol = ((unsigned)att < 64) ? ((dbtbl[att]+1)<<1) : 0; /* 1[h݂̏Ȃ̂ŁA荞݋֎~͕svł */
	//      dbtbl[]1oCgzɂ邽߂̕␳~~ ~~~Xs[J[ʑ̂߁Amȉʂ2{̉ʂɂ
}
//}}2013/07/15ǉ

//{{2017/06/26ǉ:adpcm_rate()֐ǉ܂B
void adpcm_rate(int ch, int rate) {
	ADPCMCHANNEL* pch;
	if(((unsigned)ch >= (unsigned)driver.nch) ||		//A܂́A`lԍs
	   ((unsigned)rate > SPEAKER_FREQUENCY)) { DIE(); }	//Đ[gs
	pch = &driver.pch[ch];
	pch->rate = rate;	//1[h݂̏Ȃ̂ŁA荞݋֎~͕svłB
}
//}}2017/06/26ǉ:adpcm_rate()֐ǉ܂B
