//
//	ToolLib_ParamBar.c
//
//	GfB^[ʏ - c[GUĨp[^[o[
//
//	* Tue Apr 18 21:46:46 JST 2017 Naoyuki Sawa
//	- 1st [XB
//	* Wed Apr 19 22:11:14 JST 2017 Naoyuki Sawa
//	- u@DxLibɈˑȂ悤ɂvƁuACŃRpCo悤ɂvΉ܂B
//	  ڍׂ́A/clip/ToolLib/README.TXT ́ÃRgQƂĉB
//	* Thu Apr 20 21:31:57 JST 2017 Naoyuki Sawa
//	- CuIuWFNg̎ʎqAnh˃|C^ɕύX܂B
//	  IWiłł͐IuWFNgŒ蒷zɊi[ĊǗĂ̂łAߖ̂߂ɃXgŊǗ悤ɕύXÂ߂ɂ͐nh|C^̕sǂłB
//	  AtHgnhƕ̓nh́ACuIuWFNgł͂ȂobNGh̃IuWFNgȂ̂ŁA̕ύXɂ͊֌Wnĥ܂܂łB
//	* Tue May 02 22:54:46 JST 2017 Naoyuki Sawa
//	- eW[̃TCY`̔{ꗥŒo悤ɁAToolLib.hTOOL_SCALE̒`ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//	* Sun May 14 23:23:22 JST 2017 Naoyuki Sawa
//	- ToolParamBar_IsAnyHovered(),ToolParamBar_IsHovered()֐ǉ܂B
//	  ڍׂ́AToolLib.h̓̃RgQƂĉB
//
#include "clip.h"
#ifdef  TOOLLIB_USE_STRINGINPUT
//*****************************************************************************
//	萔A}NA\
//*****************************************************************************
#define TOOL_BAR_CURSOR_HEIGHT		(TOOL_SCALE*(12))	//o[̂܂݂̍B
#define TOOL_BAR_CURSOR_HALF_WIDTH	(TOOL_SCALE*(3))	//o[̂܂݂̔̕B
#define TOOL_BAR_Y			(TOOL_SCALE*(5))	//o[YWB
//-----------------------------------------------------------------------------
//p[^o[\
/*typedef*/ struct _SToolParamBar {
	SToolVisible*		TVisible;		//֘AtĂ\ԏB
	SToolWindow*		TWindow;		//֘AtĂEChEB
	SToolStringInput*	NumberTStringInput;	//lڕҏWp̕͏B
	char*			Name;			//O̕񂪊i[Ă郁AhXۑĂ|C^B
	int			PositionX, PositionY;	//p[^o[̕\ʒuB
	int			BarPositionX;		//o[\鑊XWB
	int			BarWidth;		//o[̉B
	double			ParamMin, ParamMax;	//o[őł͈͂̒l̍ŏlƍőlB
	double			Param;			//݂̐lB
	int			Change;			//lɕωǂB
	int			Grips;			//o[̂܂݂͂ł邩ǂB
	int			GripsX;			//o[̂܂݂͂񂾂Ƃ̃o[[݂XWB
} /*SToolParamBar*/;
//*****************************************************************************
//	[Jϐ
//*****************************************************************************
static GSList*	g_TParamBar;
//*****************************************************************************
//	[J֐錾
//*****************************************************************************
static void ToolParamBar_Step(SToolParamBar* TParamBar, double StepTime);
static void ToolParamBar_Draw(SToolParamBar* TParamBar);
//*****************************************************************************
//	AvP[Vp֐
//*****************************************************************************
//p[^o[쐬B
//[in]
//	Name			O̕񂪊i[ꂽAhXB
//	PositionX,PositionY	\WB
//	BarPositionX		o[\鑊XWB
//	BarWidth		o[̉B
//	NumberLength		\鐔ľB
//	ParamMin,ParamMax	o[őł͈͂̒l̍ŏlƍőlB
//	InitParam		lB
//[out]
//	߂l			p[^o[B
SToolParamBar* ToolParamBar_Create(const char* Name, int PositionX, int PositionY, int BarPositionX, int BarWidth, int NumberLength, double ParamMin, double ParamMax, double InitParam) {
	SToolParamBar* TParamBar;
	//V{^i[邽߂̃̊mہB
	TParamBar = calloc(1, sizeof(SToolParamBar));
	if(!TParamBar) { DIE(); }
	//mۂ̈ۑB
	g_TParamBar = g_slist_append(g_TParamBar, TParamBar);
	//B
//sv	TParamBar->TVisible     = NULL;
//sv	TParamBar->TWindow      = NULL;
	TParamBar->PositionX    = PositionX;
	TParamBar->PositionY    = PositionY;
	TParamBar->BarPositionX = BarPositionX;
	TParamBar->BarWidth     = BarWidth;
	TParamBar->ParamMin     = ParamMin;
	TParamBar->ParamMax     = ParamMax;
	TParamBar->Param        = InitParam;
//sv	TParamBar->Change       = 0;
//sv	TParamBar->Grips        = 0;
	if(Name) {
		TParamBar->Name = strdup(Name);
		if(!TParamBar->Name) { DIE(); }
	}
	//lҏWp̕͏쐬B
	TParamBar->NumberTStringInput = ToolStringInput_Create(NULL,
	                                                       PositionX + BarPositionX + BarWidth + 8,
	                                                       PositionY,
	                                                       1,
	                                                       NumberLength,
	                                                       0);
	//lݒB
	ToolStringInput_SetFloatNumber(TParamBar->NumberTStringInput, InitParam);
	//p[^o[ԂB
	return TParamBar;
}
//-----------------------------------------------------------------------------
//p[^o[폜B
//[in]
//	TParamBar		p[^o[B
void ToolParamBar_Delete(SToolParamBar* TParamBar) {
	//OۑpɃmۂĂꍇ͉B
	free(TParamBar->Name);
	//lҏWp̕͏폜B
	ToolStringInput_Delete(TParamBar->NumberTStringInput);
	//mۂĂB
	g_TParamBar = g_slist_remove(g_TParamBar, TParamBar);
	free(TParamBar);
}
//-----------------------------------------------------------------------------
//SẴp[^o[폜B
void ToolParamBar_Delete_All() {
	//LȑSẴp[^o[폜B
	while(g_TParamBar) { ToolParamBar_Delete(g_TParamBar->data); }
}
//-----------------------------------------------------------------------------
//p[^o[Ɋ֘At\ԏZbgB
//[in]
//	TParamBar		p[^o[B
//	TVisible		\ԏB
void ToolParamBar_SetVisibleHandle(SToolParamBar* TParamBar, SToolVisible* TVisible) {
	//\ԏۑB
	TParamBar->TVisible = TVisible;
	//lҏWp̕͏ɂݒ肷B
	ToolStringInput_SetVisibleHandle(TParamBar->NumberTStringInput, TVisible);
}
//-----------------------------------------------------------------------------
//p[^o[̕\ԂύXB
//[in]
//	TParamBar		p[^o[B
//	Visible			V\ԁB
void ToolParamBar_SetVisible(SToolParamBar* TParamBar, int Visible) {
	//lҏWp̕͏ɑ΂ĕ\ԐݒsB
	ToolStringInput_SetVisible(TParamBar->NumberTStringInput, Visible);
}
//-----------------------------------------------------------------------------
//p[^o[̕\Ԃ擾B
//[in]
//	TParamBar		p[^o[B
//[out]
//	߂l			\ԁB(0ȊO:\,0:\)
int ToolParamBar_GetVisible(SToolParamBar* TParamBar) {
	//lҏWp̕͏񂪔\Ԃ0ԂB
	if(!ToolStringInput_GetVisible(TParamBar->NumberTStringInput)) { return 0; }
	//֘AtĂEChE̕\Ԃ0̏ꍇ0ԂB
	if(!ToolWindow_GetVisible(TParamBar->TWindow)) { return 0; }
	//\ԏ񂪓o^ĂāA\ԏ̕\Ԃ0̏ꍇ0ԂB
	if(!ToolVisible_GetVisible(TParamBar->TVisible)) { return 0; }
	//ɂĂ\ł͂ȂƂƂȂ̂0ȊOԂB
	return 1;
}
//-----------------------------------------------------------------------------
//p[^o[Ɗ֘AtEChEݒ肷B
//[in]
//	TParamBar		p[^o[B
//	TWindow			EChEB
void ToolParamBar_SetWindow(SToolParamBar* TParamBar, SToolWindow* TWindow) {
	//EChEۑB
	TParamBar->TWindow = TWindow;
	//lҏWp̕͏ɂEChEZbgB
	ToolStringInput_SetWindow(TParamBar->NumberTStringInput, TParamBar->TWindow);
}
//-----------------------------------------------------------------------------
//p[^o[̍WύXB
//[in]
//	TParamBar		p[^o[B
//	PositionX,PositionY	ύX̍WB
void ToolParamBar_SetPosition(SToolParamBar* TParamBar, int PositionX, int PositionY) {
	//WۑB
	TParamBar->PositionX = PositionX;
	TParamBar->PositionY = PositionY;
	//lҏWp̕͏̍WύXB
	ToolStringInput_SetPosition(TParamBar->NumberTStringInput,
	                            TParamBar->PositionX + TParamBar->BarPositionX + TParamBar->BarWidth + 8,
	                            TParamBar->PositionY);
}
//-----------------------------------------------------------------------------
//p[^o[̐lύXB
//[in]
//	TParamBar		p[^o[B
//	Param			ύX̐lB
void ToolParamBar_SetParam(SToolParamBar* TParamBar, double Param) {
	//p[^ۑB
	TParamBar->Param = Param;
	//lҏWp̕͏ɂlZbgB
	ToolStringInput_SetFloatNumber(TParamBar->NumberTStringInput, Param);
}
//-----------------------------------------------------------------------------
//p[^o[̃o[ŕύXł鐔l̍őlƍŏlύXB
//[in]
//	TParamBar		p[^o[B
//	ParamMin,ParamMax	VŏlƍőlB
void ToolParamBar_SetMinMax(SToolParamBar* TParamBar, double ParamMin, double ParamMax) {
	TParamBar->ParamMin = ParamMin;
	TParamBar->ParamMax = ParamMax;
}
//-----------------------------------------------------------------------------
//p[^o[̐lҏWsĂꍇɖŏIB
//[in]
//	TParamBar		p[^o[B
void ToolParamBar_AlwaysEnd(SToolParamBar* TParamBar) {
	//lҏWp̕͏ɑ΂ĖȈsB
	ToolStringInput_AlwaysEnd(TParamBar->NumberTStringInput);
}
//-----------------------------------------------------------------------------
//p[^o[̐lɕωǂ擾B
//[in]
//	TParamBar		p[^o[B
//[out]
//	߂l			lɕωǂB(0ȊO:ω,0:ωȂ)
int ToolParamBar_CheckChange(SToolParamBar* TParamBar) {
	//lɕωǂ̃tO[JϐɃRs[ĂB
	int Result = TParamBar->Change;
	//lɕωǂ̃tO|B
	TParamBar->Change = 0;
	//Rs[Ăϐ̓eԂB
	return Result;
}
//-----------------------------------------------------------------------------
//p[^o[݂̌̐l擾B
//[in]
//	TParamBar		p[^o[B
//[out]
//	߂l			p[^o[̒lB
double ToolParamBar_GetParam(SToolParamBar* TParamBar) {
	return TParamBar->Param;
}
//-----------------------------------------------------------------------------
//SẴp[^o[̏ԐڏsB
//[in]
//	StepTime		i߂鎞ԁB(P:b)
void ToolParamBar_Step_All(double StepTime) {
	GSList* list = g_TParamBar;
	while(list) {
		ToolParamBar_Step(list->data, StepTime);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//SẴp[^o[̕`ڏsB
void ToolParamBar_Draw_All() {
	GSList* list = g_TParamBar;
	while(list) {
		ToolParamBar_Draw(list->data);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//}EXJ[\ꂩ̃p[^o[̓ɂ邩ǂ`FbNB
//[out]
//	߂l			ꂩ̃p[^o[̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolParamBar_IsAnyHovered() {
	GSList* list = g_TParamBar;
	while(list) {
		if(ToolParamBar_IsHovered(list->data)) { return 1; }
		list = list->next;
	}
	return 0;
}
//-----------------------------------------------------------------------------
//}EXJ[\p[^o[̓ɂ邩ǂ`FbNB
//[in]
//	TParamBar		p[^o[B
//[out]
//	߂l			p[^o[̓Ƀ}EXJ[\邩ǂB(0ȊO:ɂ,0:Oɂ)
int ToolParamBar_IsHovered(SToolParamBar* TParamBar) {
	//TODO:
	return 0;
}
//*****************************************************************************
//	[J֐
//*****************************************************************************
//p[^o[̏ԐڏsB
//[in]
//	TParamBar		p[^o[B
//	StepTime		i߂鎞ԁB(P:b)
static void ToolParamBar_Step(SToolParamBar* TParamBar, double StepTime) {
	int MouseX, MouseY;
	double TempF;
	int WinDrawX, WinDrawY;
	int In;
	int AreaX, AreaY;
	int CursorX;
	//\Ԃꍇ͉IB
	if(!ToolParamBar_GetVisible(TParamBar)) { return; }	//܂
	//}EXJ[\̈ʒu擾B
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	//lҏWp͏ɕωꍇ̓o[ɂfB
	if(ToolStringInput_CheckEnd(TParamBar->NumberTStringInput, 1)) {
		//lɕωǂ̃tO𗧂ĂB
		TParamBar->Change = 1;
		//lҏWp͏݂̌̐l擾B
		TempF = ToolStringInput_GetFloatNumber(TParamBar->NumberTStringInput);
		//lŏlől͈̔͂͂ݏoĂ␳B
		if(TempF < TParamBar->ParamMin) { TempF = TParamBar->ParamMin; }
		if(TempF > TParamBar->ParamMax) { TempF = TParamBar->ParamMax; }
		//lݒ肷֐Œl𔽉fB
		ToolParamBar_SetParam(TParamBar, TempF);
	}
	//}EX̍{^ĂȂo[̂܂݂͂ł邩ǂ̃tO|ďIB
	if(!(ToolStatic_GetMouseButton() & (1<<0)/*MOUSE_INPUT_LEFT*/)) {
		TParamBar->Grips = 0;
		return;	//܂
	}
	//o[̂܂݂͂łȂꍇ̓}EX̍{^uԂł͂Ȃꍇ͂ŏIB
	if(!TParamBar->Grips &&
	   !(ToolStatic_GetMouseEdgeButton() & (1<<0)/*MOUSE_INPUT_LEFT*/)) { return; }	//܂
	//EChEɊ֘AtĂꍇ̓EChE̍WEChEɃ}EXJ[\邩ǂȂǂ擾B
	if(TParamBar->TWindow) {
		ToolWindow_GetDrawLeftUpPos(TParamBar->TWindow, &WinDrawX, &WinDrawY);
		In = ToolWindow_CheckInfoAreaIn(TParamBar->TWindow, MouseX, MouseY);
	} else {
		WinDrawX = 0;
		WinDrawY = 0;
		In       = 1;
	}
	//o[\̈̍WZoB
	AreaX = TParamBar->PositionX + WinDrawX + TParamBar->BarPositionX;
	AreaY = TParamBar->PositionY + WinDrawY;
	//܂݂̈ʒuZoB
	CursorX = TParamBar->BarWidth * (TParamBar->Param    - TParamBar->ParamMin)
	                              / (TParamBar->ParamMax - TParamBar->ParamMin);
	//܂݂͂ł邩ǂŏ𕪊B
	if(!TParamBar->Grips) {
		//܂݂͂łȂꍇ̓o[̕\̈ɃJ[\ꍇ͏IB
		if(!In) { return; }	//܂
		//o[̕\̈悩炸ĂIB
		if((MouseX < (AreaX - TOOL_BAR_CURSOR_HALF_WIDTH)) ||
		   (MouseX > (AreaX + TOOL_BAR_CURSOR_HALF_WIDTH + TParamBar->BarWidth)) ||
		   (MouseY <  AreaY) ||
		   (MouseY > (AreaY + TOOL_BAR_CURSOR_HEIGHT))) { return; }	//܂
		//܂݂̊ONbNꍇ͂܂݂̈ʒuNbNʒuɈړB
		if((MouseX <  (CursorX + AreaX - TOOL_BAR_CURSOR_HALF_WIDTH)) ||
		   (MouseX >= (CursorX + AreaX + TOOL_BAR_CURSOR_HALF_WIDTH))) {
			CursorX           = MouseX - AreaX;
			TParamBar->GripsX = 0;
		} else {
			TParamBar->GripsX = MouseX - (AreaX + CursorX);
		}
		//܂݂͂ł邩ǂ̃tO𗧂ĂB
		TParamBar->Grips = 1;
	} else {
		//܂݂͂łꍇ͒͂ݎn߂}EXJ[\ʒuƌ݂̃}EXJ[\ʒu猻݂̂܂݂̈ʒu肷B
		if(       (MouseX - TParamBar->GripsX) < (AreaX                       - TOOL_BAR_CURSOR_HALF_WIDTH)) {
			CursorX = 0;
		} else if((MouseX - TParamBar->GripsX) > (AreaX + TParamBar->BarWidth + TOOL_BAR_CURSOR_HALF_WIDTH)) {
			CursorX = TParamBar->BarWidth;
		} else {
			CursorX = MouseX - TParamBar->GripsX - AreaX;
			if(CursorX <                   0) { CursorX =                   0; }
			if(CursorX > TParamBar->BarWidth) { CursorX = TParamBar->BarWidth; }
		}
	}
	//܂݂̈ʒuɉăp[^ZoB
	TempF = CursorX * (TParamBar->ParamMax - TParamBar->ParamMin) / TParamBar->BarWidth + TParamBar->ParamMin;
	//lωĂlωǂ̃tO𗧂āAlҏWp̕͏ɂfB
	if(TempF != TParamBar->Param) {
		TParamBar->Change = 1;
		TParamBar->Param  = TempF;
		ToolStringInput_SetFloatNumber(TParamBar->NumberTStringInput, TParamBar->Param);
	}
}
//-----------------------------------------------------------------------------
//p[^o[ʂɕ`悷B
//[in]
//	TParamBar		p[^o[B
static void ToolParamBar_Draw(SToolParamBar* TParamBar) {
	int CursorX;
	int WinDrawX, WinDrawY;
	//\ݒɂȂĂ牽ɏIB
	if(!ToolParamBar_GetVisible(TParamBar)) { return; }	//܂
	//EChEɊ֘AtĂꍇ̓EChE̍W擾B
	if(TParamBar->TWindow) {
		ToolWindow_GetDrawLeftUpPos(TParamBar->TWindow, &WinDrawX, &WinDrawY);
		//EChEɂ`͈͐ݒsB
		ToolWindow_SetupDrawArea(TParamBar->TWindow);
	} else {
		WinDrawX = 0;
		WinDrawY = 0;
	}
	//Oꍇ͖O`悷B
	if(TParamBar->Name) {
		ToolFunc_DrawStringToHandle(TParamBar->PositionX + WinDrawX,
		                            TParamBar->PositionY + WinDrawY,
		                            TParamBar->Name,
		                            ToolFunc_GetColor(255,255,255),
		                            ToolStatic_GetNormalFontHandle());
	}
	//o[̂܂݂̈ʒuZoB
	CursorX = TParamBar->BarWidth * (TParamBar->Param    - TParamBar->ParamMin)
	                              / (TParamBar->ParamMax - TParamBar->ParamMin);
	//o[`B
	ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 200);
	ToolFunc_DrawBox(TParamBar->PositionX + WinDrawX + TParamBar->BarPositionX,
	                 TParamBar->PositionY + WinDrawY + TOOL_BAR_Y,
	                 TParamBar->PositionX + WinDrawX + TParamBar->BarPositionX + TParamBar->BarWidth,
	                 TParamBar->PositionY + WinDrawY + TOOL_BAR_Y + 1,
	                 ToolFunc_GetColor(255,255,255),
	                 1);
	//o[̂܂݂`B
	ToolFunc_DrawBox(TParamBar->PositionX + WinDrawX + TParamBar->BarPositionX + CursorX - TOOL_BAR_CURSOR_HALF_WIDTH,
	                 TParamBar->PositionY + WinDrawY,
	                 TParamBar->PositionX + WinDrawX + TParamBar->BarPositionX + CursorX + TOOL_BAR_CURSOR_HALF_WIDTH,
	                 TParamBar->PositionY + WinDrawY + TOOL_BAR_CURSOR_HEIGHT,
	                 ToolFunc_GetColor(255,255,255),
	                 1);
	//`ݒɖ߂B
	ToolFunc_SetDrawBlendMode(0/*DX_BLENDMODE_NOBLEND*/, 0);
	ToolFunc_SetDrawAreaFull();
}
#endif//TOOLLIB_USE_STRINGINPUT
