/*
 *	app.c
 *
 *	̃pg[(ڐA)
 *
 *	* Wed Mar 29 00:00:00 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

/****************************************************************************
 *	main
 ****************************************************************************/

int main() {
#ifdef  USE_ARGS
	static char cmdline[128] = PRESCAN_STRINGIFY(PROJECT);	//ur.exevɃR}hCw肵ꍇA܂B
	char** const argv = strsplit(cmdline, " ", 0);
	int    const argc = strv_length(argv);
#else //USE_ARGS
	char** const argv = (char*[]){ PRESCAN_STRINGIFY(PROJECT), NULL };
	int    const argc = 1;
#endif//USE_ARGS
	/* ĂяovŐNɎgpꂽOݒ肵܂B */
	program_invocation_short_name = basename((program_invocation_name = argv[0]));
	/* ߑȂO߂邽߂́AOt[܂B */
	SEH_init();
	/* AvP[V܂B */
	app_init(argc, argv);
	/* C[vs܂B */
	return app_main(argc, argv);
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
//yӁz
//zTBL_TapMxrChMask[]͕KintzƂĒ`ĉB
//~LT[`lȂărbg肽ƂĂAzTBL_TapMxrChMask[]uint8_tzuint16_tzƂĒ`Ă͂܂B
//̉set_att()ɂĔzTBL_TapMxrChMask[]̗vfւ̃|C^TapMxr_GetAtt()̈aMxrChMaskƂĈnĂATapMxr_GetAtt()͈aMxrChMaskintEɐ񂵂Ă鎖OƂăANZXĂ邩łB
//zTBL_TapMxrChMask[]uint8_tzuint16_tzƂĒ`Ă܂ƁẢset_att()ĂяoTapMxr_GetAtt()̒ŃAhXG[܂B
static const int TBL_TapMxrChMask[(TapLogCh_Max+1)]={
BIN8(00000111),	//_0ɓKpзقޯϽ	ðBGM
BIN8(00000110),	//_1ɓKpзقޯϽ	oBGM
BIN8(00000110),	//_2ɓKpзقޯϽ	oSE
BIN8(00000110),	//_3ɓKpзقޯϽ	oSE
BIN8(00000110),	//_4ɓKpзقޯϽ	oSE
BIN8(00000110),	//_5ɓKpзقޯϽ	UI
BIN8(00000110),	//_6ɓKpзقޯϽ	UI
BIN8(00000100)};//_7ɓKpзقޯϽ	װ
//        ||+--- TAPз1:oBGMĐ	Ώۘ_:ðBGM
//        |+---- TAPз2:װĐ	Ώۘ_:װȊO
//        +----- TAPз0:İ		Ώۘ_:S
static void set_att(int iLogCh, ST_TapLogCh* pLogCh) {	//̘_ق̌ʂƤ̘_قɓKpзق̍vʂ𤂱̘_ق䂵Ă޲قɓKp	(pLogCh->iDevCh==UINT8_MAX)̎ɌĂяoĂ͂Ȃ
	int iAtt=pLogCh->iAtt;					//̘_ق̌				//2حё
	iAtt+=TapMxr_GetAtt(pTapMxr,&TBL_TapMxrChMask[iLogCh]);	//̘_قɓKpзق̍v	//1حё
	sound_att(pLogCh->iDevCh,iAtt);				//̘_ق䂵Ă޲قɤL2_̍vʂKp
}
static void TapMxr_TimerProc(void* iTime) {	//TAPзpϊ
	int iDevCh,iLogCh;
	if(TapSeq_GetLogCh(pTapSeq,TapLogCh_Bg2)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Stg,64, 0,  0);}	//_1ŉoBGMĐȂΤðBGM𑦏		
	else                                                       {TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Stg, 0,64,500);}	//_1ŉoBGM~ȂΤðBGM0.5bŕA		{{TODO:عݒ}}
	if(TapSeq_GetLogCh(pTapSeq,TapLogCh_Err)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Err,64, 0,  0);}	//_7ŴװĐȂΤðBGM,oBGM,SE𑦏	
	else                                                       {TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Err, 0, 0,  0);}	//_7Ŵװ~ȂΤðBGM,oBGM,SE𑦕A	
	TapMxr_Exec(pTapMxr,(int)iTime);	//TAPзs
	for(iDevCh=0;iDevCh<pTapSeq->pInfo->nDevCh;iDevCh++){	//޲ق̌ʂݒ肷
		iLogCh=TapSeq_GetDevCh(pTapSeq,iDevCh)->iLogCh;
		if(iLogCh!=UINT8_MAX){		//޲ق𐧌䂵Ă_قL΁c
			ST_TapLogCh* pLogCh=TapSeq_GetLogCh(pTapSeq,iLogCh);
			set_att(iLogCh,pLogCh);	//̘_ق̌ʂƤ̘_قɓKpзق̍vʂ޲قɓKp
		}
	}
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static void TapSeq_fnPlay(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
	sound_play(pLogCh->iDevCh,sound_table[pLogCh->iPhr],pLogCh->iLoop?pLogCh->iLoop:-1);
}
static void TapSeq_fnStop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	sound_stop(pLogCh->iDevCh);
}
static void TapSeq_fnLoop(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnEnd(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnNext(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
	sound_play(pLogCh->iDevCh,sound_table[pLogCh->iPhr],pLogCh->iLoop?pLogCh->iLoop:-1);
}
static void TapSeq_fnCtrl(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
}
static int TapSeq_fnGetPhrTime(ST_TapSeq* pTapSeq, int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int TapSeq_fnGetPhrNext(ST_TapSeq* pTapSeq, int iPhr) {
#ifdef  USE_REG
    #ifdef  RegKey_Next
	//t[YV[PXWXg擾ꍇB
	iPhr++;			//sound.h0x[X,t[YV[PX1x[XȂ̂ŁAꎞI1x[XɕϊBڍׂ́A/clip/tool/dPhrDefC/winapp.c QƂB
	iPhr = REG_get_value_l(TBL_RegTbl,RegKey_PhrDef,iPhr,RegKey_Next,-1)<<8>>8;	//ʏt[Y(-1),ԃt[Y(<>iPhr),[vt[Y(=iPhr),St[Y(-2)
	if(iPhr>=0){iPhr--;}	//ʏt[Y(-1),,St[Y(-2)ȊOȂ΁Asound.h̒l(=0x[X)ɖ߂B
	return iPhr;
    #else //RegKey_Next
	//t[YV[PXWXg擾邪ASĒʏt[Yłꍇ'RegKey_Next'`ȂB
	return -1;
    #endif//RegKey_Next
#else /*USE_REG*/
	//t[YV[PXvOŏꍇB
	return (iPhr==SND_BGM_1G)||(iPhr==SND_BGM_ST)?iPhr:-1;
#endif/*USE_REG*/
}
static void TapSeq_TimerProc(void* iTime) {
	TapSeq_Exec(pTapSeq,(int)iTime);
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now/FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_LOG_BUFFER
static int LogBuf_fnDraw(int x, int y, const char* Str) { //عݒ`̕`֐
	render_reduced_string(&render, x, y, Str, 3);
	return 10;
}
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_NVLOG
void nvlog_(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	nvlog_vprintf(nvlog, fmt, ap);
	va_end(ap);
	pceFileWriteSct(&faNvLog, nvlog, 0, NVLOG_SIZE);
}
#endif//USE_NVLOG

#ifdef  USE_TCL
//srand seed
static int Tcl_SrandCmd(Tcl_Interp* iPtr) {
	if((iPtr->argc < 1) || (iPtr->argc > 2)) { DIE(); }
	srand((iPtr->argc == 2) ? atoi(iPtr->argv[1]) : time(NULL));
	return TCL_OK;
}
//rand
static int Tcl_RandCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	iPtr->result = strdup_printf("%d", rand());
	return TCL_OK;
}
//log string
static int Tcl_LogCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 2) { DIE(); }
#ifdef  USE_LOG_BUFFER
	LogBuf_Print(pLogBuf, iPtr->argv[1]);
	update();
#else //USE_LOG_BUFFER
	TRACE("%s\n", iPtr->argv[1]);
#endif//USE_LOG_BUFFER
	return TCL_OK;
}
//schedule
static int Tcl_ScheduleCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	schedule();
	return TCL_OK;
}
#endif//USE_TCL

void app_init(int argc, char* argv[]) {
#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈ݒ肵܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_init();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND

	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Init(BITMAP_GC_UNIT);
#endif /*BITMAP_GC_UNIT*/

#ifdef  USE_PCL
	/* R[`܂B */
	co_thread_init();
#endif//USE_PCL

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_VQTC
	/* VQkeNX``܂B */
	VqTc_InitDrawing();
#endif /*USE_VQTC*/

#ifdef USE_MUSIC
	/* yCu܂B */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * //{{2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B
	 * //- music_wchύX鏈́AInitMusic()ōsKv܂B
	 * //  InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * //- Amusic_loudness()̋@\music_wchQƂĂ܂A
	 * //  Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 * //}}2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* TAPз܂ */
#ifdef  USE_SOUND_MIXER
	{
		pTapMxr=TapMxr_New(TapMxrCh_Max+1);
		timer_start(100,TapMxr_TimerProc,(void*)100);	//TAPзpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TAPݻ܂ */
#ifdef  USE_SOUND_SEQUENCER
	{
		static const uint8_t* const TBL_TapSet[]={
			(uint8_t[]){TapDevCh_Bg1,-1},			//ðBGM
			(uint8_t[]){TapDevCh_Bg2,-1},			//oBGM
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//UI
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//UI
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//װ
		};
		static const uint8_t TBL_BaseCh[]={
			0,	//ð	
			0,	//o	2017/02/09݂snd/TapDef.txtł́AV[PTf[^̒Ř_`lԍ𒼐ڎw肵Ă̂ŁATBL_BaseCh[]ɂItZbg0ƂĂ܂B
			0,	//UI	AV[PTf[^̒Ř_`lԍ𑊑Ύw肷悤ɕύXꍇ́ATBL_BaseCh[]ɂItZbgK؂ɕύXĉB
			0,	//װ	
		};
		static const ST_TapSeqInfo stTapSeqInfo={
			SOUND_COUNT,			//nPhr
			TapDevCh_Max+1,			//nDevCh
			TapLogCh_Max+1,			//nLogCh
			TapSeqCh_Max+1,			//nSeqCh
			1000/FPS,			//iCont
			31/**/,			//nEvt
			~(1<<TapEvt_Ctrl)/*ύX*/,	//iEvtMsk
			TapSeq_fnPlay,
			TapSeq_fnStop,
			TapSeq_fnLoop,
			TapSeq_fnEnd,
			TapSeq_fnNext,
			TapSeq_fnCtrl,
			TapSeq_fnGetPhrTime,
			TapSeq_fnGetPhrNext,
			TBL_TapSet,
			TBL_BaseCh,
		};
		if(ARRAY_SIZE(TBL_TapSet) != (TapLogCh_Max+1)) { DIE(); }
		if(ARRAY_SIZE(TBL_BaseCh) != (TapSeqCh_Max+1)) { DIE(); }
		pTapSeq=TapSeq_New(&stTapSeqInfo);
		timer_start(10,TapSeq_TimerProc,(void*)10);	//޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* LEDV[PT܂B */
#ifdef  USE_LED
	pLedSeq = LedSeq_New(LedCh_Max + 1, LedSeqCh_Max + 1);
#endif//USE_LED

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static ST_EvtTmrFunc stEvtTmrFunc = { EvtTmr_onEvent };
		pEvtTmr = EvtTmr_New(EvtTmrNo_Max+1);	//ς
		EvtTmr_AddFunc(pEvtTmr, &stEvtTmrFunc);	//ď֐o^
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_New(CntCh_Max+1);
#endif/*USE_COUNTER_MANAGER*/

	/* JE^܂B */
#ifdef  USE_DURATION_COUNTER
	pDurCnt = DurCnt_New();
#endif/*USE_DURATION_COUNTER*/

	/* Oobt@܂B */
#ifdef  USE_LOG_BUFFER
	pLogBuf = LogBuf_Init((DISP_Y+9)/10, LogBuf_fnDraw);
#endif/*USE_LOG_BUFFER*/

	//sOobt@܂B
#ifdef  USE_NVLOG
	{
		time_t t;
		pceFileCreate("nvlog.bin", NVLOG_SIZE);
		pceFileOpen(&faNvLog, "nvlog.bin", FOMD_WR);
		pceFileReadSct(&faNvLog, nvlog, 0, NVLOG_SIZE);	//ÕOɒǉ鎖ɂB̏ԂJnꍇ͂̍s폜B
		time(&t);
		NVLOG("Start at %s", strstrip(ctime(&t)));
	}
#endif//USE_NVLOG

#ifdef  USE_TCL
	//TclC^v^邽߂ɁAIɃK[x[WRNVsB
#if     defined(GC_LEVEL)
/*K{*/timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBʏGCTclC^v^gpꍇ́A̍ssȂƋɒ[ɒxȂB
#elif   defined(BITMAP_GC_UNIT)
//C	timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBBitmap GCgpꍇ͋ɒ[ɒx͂ȂA̍ssł͂B
#else //defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	#error TclC^v^̓K[x[WRN^[̕pK{łB
#endif//defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	//TclC^v^쐬B
	iPtr = Tcl_CreateInterp();
	//ėpIȃAvP[V`̃R}ho^B
	Tcl_CreateCommand(iPtr, "srand",    Tcl_SrandCmd,    NULL);
	Tcl_CreateCommand(iPtr, "rand",     Tcl_RandCmd,     NULL);
	Tcl_CreateCommand(iPtr, "log",      Tcl_LogCmd,      NULL);
	Tcl_CreateCommand(iPtr, "schedule", Tcl_ScheduleCmd, NULL);
#endif//USE_TCL

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef  USE_CBKQUE
	/* R[obNL[܂B */
	pCbkQue = DynamicCbkQue_New(2048/**/);	//2048CbkQue_sprite_draw()x100񕪂炢łBCbkQue_render_printf()gƂƏ܂BIR[obNL[Ȃ̂ŏȒlł(0ł)\܂B
#endif//USE_CBKQUE

#ifdef  USE_DLYQUE
	/* xR[obNL[܂B */
	pDlyQue = DlyQue_New();
#endif//USE_DLYQUE

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

#ifdef  USE_TASK
	/* ^XNXPW[܂B
	 * - AChXbhƕpꍇ́Aidle_proc()̒ŏĂB
	 *   AChXbhƕp@́Atask_yield()[note]QƂĂB */
	task_init(INT_MIN);//{{TODO:ѱ̎sDxͱعݒ}}
#endif/*USE_TASK*/

#if     (defined(USE_ENM)&&defined(USE_REG))
	/* 񋓒`L[擾܂B */
	pEnmKey = REG_open_key(TBL_RegTbl, RegKey_EnmDef);
#endif//(defined(USE_ENM)&&defined(USE_REG))

#ifdef  USE_PRP
	/* vpeBe[uL[擾܂B */
	pPrpKey = REG_open_key(TBL_RegTbl, RegKey_PrpTbl);
	if(!pPrpKey) { DIE(); }
	/* vpeBwb_܂B */
	PrpHdr_init(phApp, pPrpKey, PrpTbl_App);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_PRP

#ifdef  USE_FSM
	/* Lԋ@B}bvL[擾܂B */
	pFsmKey = REG_open_key(TBL_RegTbl, RegKey_FsmMap);
	if(!pFsmKey) { DIE(); }
	/* Lԋ@B܂B */
	FsmObj_Init(&foApp, pFsmKey, FsmMap_App, NULL);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_FSM

#ifdef  USE_ACT
	/* AN^[IuWFNg܂B */
	aoApp = ActObj_New(NULL);
#endif//USE_ACT

#ifdef  USE_RRS
	/* Round Robin Scheduler (RRS)܂B */
	RRS_new_l(&pRRS, 0/*stacksize*/,	//{{TODO:ύX}}
		//{{TODO:ɃWu֐񋓂ĉB}}
		NULL/*I[*/);
#endif//USE_RRS
#ifdef  USE_MSGHSK
	//bZ[WnhVFCNB
	MsgHsk_Init(&stMsgHsk, pRRS);
#endif//USE_MSGHSK

#ifdef  USE_NUKLEAR
	//NuklearReLXg쐬B
	ctx = nk_piece_new();
#endif//USE_NUKLEAR

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void app_exit() {
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef USE_VQTC
	/* VQkeNX``܂B */
	VqTc_ExitDrawing();
#endif /*USE_VQTC*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef  USE_PCL
	/* R[`I܂B */
	co_thread_cleanup();
#endif//USE_PCL

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Free();
#endif /*BITMAP_GC_UNIT*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/

#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_free();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 * * Thu Dec 21 21:17:56 JST 2014 Naoyuki Sawa
 * - Oobt@`A܂łschedule()ōsĂ܂Aupdate()ōs悤ɕύX܂B
 *   ɉāAOobt@`OŁAzVRAMۑ悤ɂ܂B
 *   ̕ύXɂāAAvP[V́AOobt@`̉e𖳎āAI[o[CƌȂ悤ɂȂ܂B
 *   ȉ̂悤ȏ\ƂȂ܂B
 *   1
 *   void app_main(){
 *     surface_clear(&surface,0);
 *     render_ellipse(&render,0,0,DISP_X,DISP_Y,3);//~`悷
 *     for(;;){
 *       schedule();//~j󂹂۸ޯ̧`݂̂۰قł
 *       LogBuf_Printf(pLogBuf,"%d",now);
 *   } }
 *   2
 *   void test(){
 *     //``
 *     LogBuf_Printf(pLogBuf,"some message");
 *     update();//۸ޯ̧`݂̂XV
 *     //``
 *   } }
 * - ̕ύXɔAOobt@`悪A^ƁAPC̉ʃLv`Ɋ܂܂ȂȂƂɁAӂĂB
 *   ^schedule()̒vidrec()ŁCLv`schedule()̒yield()ōs鏈łB
 *   vidrec()yield()Ă΂鎞_ł́AzVRAM͕ĂAOobt@`͎cĂȂłB
 *   Oobt@`́AɃeXĝ߂̕\ł̂ŁA^Lv`Ɋ܂܂ĂȂĂ肪Ǝv܂A
 *   Kvłꍇ́A֐̍ṒAzVRAM𕜌鏈폜΁AύXOƓlɊ܂܂悤ɂł܂B
 */
void update() {
#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɉzVRAMޔB */
    #ifdef  V_SCREEN
	static unsigned char tmpbuf[sizeof vbuff];	//Oobt@Əcʂ𕹗pꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgȂBrotate_screen()_def_vbuffj󂷂邩łBtmpbuf[]̕gpʂ邱ƂɒӂB
	memcpy(tmpbuf, vbuff, sizeof vbuff);
    #else //V_SCREEN
	memcpy(_def_vbuff, vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgB
    #endif//V_SCREEN
	/* Oobt@`B */
	LogBuf_Draw(pLogBuf, 0, 0);
#endif/*USE_LOG_BUFFER*/

#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();

#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɑޔzVRAM𕜌B */
    #ifdef  V_SCREEN
	memcpy(vbuff, tmpbuf, sizeof vbuff);		//Oobt@Əcʂ𕹗pꍇ
    #else //V_SCREEN
	memcpy(vbuff, _def_vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ
    #endif//V_SCREEN
#endif/*USE_LOG_BUFFER*/
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void vidrec() {
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void schedule() {
#ifdef  USE_RRS
	/* Round Robin Scheduler (RRS)B */
	RRS_yield(pRRS);
#endif//USE_RRS

#ifdef  USE_EVENT_TIMER
	/* Cxg^C}B */
	EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	/* ėpJE^ǗB */
	CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef  USE_DURATION_COUNTER
	/* JE^B */
	DurCnt_Exec(pDurCnt);
#endif/*USE_DURATION_COUNTER*/

#ifdef  USE_LED
	/* LEDV[PTB */
	{
		unsigned char Buffer[LedCh_Max + 1];
		memset(Buffer, 1/**/, sizeof Buffer);
		LedSeq_Exec(pLedSeq, Buffer, NULL);
		//{{TODO:Buffer[]ʂɕ`悵Ă}}
	}
#endif//USE_LED

#ifdef  USE_DLYQUE
	/* xR[obNL[B */
	DlyQue_Exec(pDlyQue);
#endif//USE_DLYQUE

#ifdef  USE_CBKQUE
	/* R[obNL[B */
	CbkQue_Invoke(pCbkQue);	//o^Ăm[hSČĂяoBAvP[VɂẮȀCbkQue_InvokePri()𕡐񕪂ČĂяo悤ɕύXĉB
	CbkQue_Clear(pCbkQue);	//R[obNL[̏Ԃɖ߂BAvP[VɂẮAxo^R[obNL[xg񂷏ꍇ́A̍s폜ĉB
#endif//USE_CBKQUE

#ifdef  USE_NUKLEAR
	//Nuklear̕`揈B
	// - GUI̕\Dx́Aڕ`R[obNL[`CPAUSEbZ[WK؂Ǝv̂ŁANuklear̕`揈sɂB
	nk_piece_render(ctx, &render);
#endif//USE_NUKLEAR

#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
///			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
//{{AvP[VL̕ύX
//							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
//AvP[VL̕ύX
							save[y][x] = vbuff[DISP_X * ((PAUSE_Y+(88-64)/2) + y) + (PAUSE_X + x)];
//}}AvP[VL̕ύX
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
//{{AvP[VL̕ύX
//							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
//AvP[VL̕ύX
							vbuff[DISP_X * ((PAUSE_Y+(88-64)/2) + y) + (PAUSE_X + x)] = save[y][x];
//}}AvP[VL̕ύX
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
//{{AvP[VL̕ύX
//						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
//AvP[VL̕ύX
						vbuff[DISP_X * ((PAUSE_Y+(88-64)/2) + y) + (PAUSE_X + x)] = save[y][x];
//}}AvP[VL̕ύX
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

#ifdef  USE_NUKLEAR
	//Nuklear̃CxgB
	nk_input_begin(ctx);
	nk_piece_handle_event(ctx, joy);
	nk_input_end(ctx);
#endif//USE_NUKLEAR

	now++;	/* O[o^C}XV */

/*{{AvP[VL̎*/
	surface_clear(&surface, 3/*ύX*/);	//Öق̃T[tFCXNAsB̏demo_main()̏ƏՓ˂̂ŁAdemo_main()ƓɎgp鎖͏oȂB]āAsimplify.sedɂdemo_main()폜ɁȀL悤ɂBAvP[VɂẮAÖق̃T[tFCXNAsvȏꍇ́A̍s폜ĉB
/*}}AvP[VL̎*/
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void delay(int frame) {
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	萔
 ****************************************************************************/
#define SCREEN_WIDTH	128
#define SCREEN_HEIGHT	64
//gameMode
#define BOOT		0
#define TITLE		1
#define GAME_MAIN	2
#define GAME_OVER	3
//argumentObjName
#define OBJ_HOLE	0
#define OBJ_ROCK	1
#define OBJ_ENEMY	2
/*--------------------------------------------------------------------------*/
const int bitmapsB1[] = { SPR_EXPLOSION2_1,SPR_EXPLOSION2_2,SPR_EXPLOSION2_3,SPR_EXPLOSION2_4 };
const char f[ 44] = { -2,-2,-2,-2,-1,-1,-1,-1, 0,-1, 0,-1, 0,-1, 0, 0,
                      -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0,
                       1, 0, 1, 0, 1, 1, 1, 1, 2, 2, 2, 2 };
const char f2[72] = { -1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,-1, 0,
                      -1, 0,-1, 0,-1, 0,-1, 0, 0,-1, 0, 0, 0,-1, 0, 0,
                       0,-1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0,
                       0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
                       0, 1, 0, 1, 0, 1, 0, 1 };
/****************************************************************************
 *	\
 ****************************************************************************/
typedef struct _Title {
	int		dummy;
} Title;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Title_update(Title* self);
/*--------------------------------------------------------------------------*/
typedef struct _GameOver {
	unsigned char	counter;
} GameOver;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void GameOver_update(GameOver* self);
/*--------------------------------------------------------------------------*/
typedef struct _StageManager {
	unsigned char	holeTimer;
	unsigned char	rockTimer;
	unsigned char	enemyTimer;
} StageManager;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void StageManager_initialize(StageManager* self);
void StageManager_update(StageManager* self);
void StageManager_setObj(StageManager* self, int argumentObjName);
/*--------------------------------------------------------------------------*/
typedef struct _Ground {
	unsigned char	x;
} Ground;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Ground_initialize(Ground* self, int i);
void Ground_update(Ground* self);
void Ground_disp(Ground* self);
/*--------------------------------------------------------------------------*/
typedef struct _ObjHole {
	unsigned char	x, y;
} ObjHole;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int ObjHole_getX(ObjHole* self) { return self->x - 8; }
int ObjHole_getY(ObjHole* self) { return self->y; }
int ObjHole_getW(ObjHole* self) { return 2; }
int ObjHole_getH(ObjHole* self) { return 10; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ObjHole_initialize(ObjHole* self);
void ObjHole_update(ObjHole* self);
void ObjHole_disp(ObjHole* self);
/*--------------------------------------------------------------------------*/
typedef struct _ObjRock {
	unsigned char	x, y;
	int/*bool*/	hit;
	unsigned char	framePriv;
	unsigned char	timerPriv;
} ObjRock;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ObjRock_setHit(ObjRock* self) { self->hit = 1/*true*/; self->timerPriv = 0; }
int ObjRock_getHit(ObjRock* self) { return self->hit; }
int ObjRock_getX(ObjRock* self) { return self->x - 4; }
int ObjRock_getY(ObjRock* self) { return self->y; }
int ObjRock_getW(ObjRock* self) { return 4; }
int ObjRock_getH(ObjRock* self) { return 8; }
void ObjRock_setY(ObjRock* self) { self->y = SCREEN_HEIGHT + 8; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ObjRock_initialize(ObjRock* self);
void ObjRock_update(ObjRock* self);
void ObjRock_disp(ObjRock* self);
/*--------------------------------------------------------------------------*/
typedef struct _ObjEnemy {
	unsigned char	x, y;
	int/*bool*/	hit;
	unsigned char	framePriv;
	unsigned char	timerPriv;
} ObjEnemy;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ObjEnemy_setHit(ObjEnemy* self) { self->hit = 1/*true*/; self->timerPriv = 0; }
int ObjEnemy_getHit(ObjEnemy* self) { return self->hit; }
int ObjEnemy_getX(ObjEnemy* self) { return self->x - 8; }
int ObjEnemy_getY(ObjEnemy* self) { return self->y; }
int ObjEnemy_getW(ObjEnemy* self) { return 4; }
int ObjEnemy_getH(ObjEnemy* self) { return 4; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ObjEnemy_initialize(ObjEnemy* self);
void ObjEnemy_update(ObjEnemy* self);
void ObjEnemy_disp(ObjEnemy* self);
/*--------------------------------------------------------------------------*/
typedef struct _Jiki{
	unsigned char	x, y;
	int/*bool*/	hit;
	int/*bool*/	alive;
	int/*bool*/	jump;
	unsigned char	framePriv;
	unsigned char	timerPriv;
	unsigned char	shotWait;
} Jiki;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int/*bool*/ Jiki_getAlive(Jiki* self) { return self->alive; }
void Jiki_setHit(Jiki* self) { self->hit = 1/*true*/; }
int Jiki_getHit(Jiki* self) { return self->hit; }
int Jiki_getX(Jiki* self) { return self->x - 16; }
int Jiki_getY(Jiki* self) { return self->y; }
int Jiki_getW(Jiki* self) { return 16; }
int Jiki_getH(Jiki* self) { return 8; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Jiki_initialize(Jiki* self);
void Jiki_update(Jiki* self);
void Jiki_dead(Jiki* self);
/*--------------------------------------------------------------------------*/
typedef struct _ShotManager {
	int		dummy;
} ShotManager;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void ShotManager_initialize(ShotManager* self);
void ShotManager_update(ShotManager* self);
/*--------------------------------------------------------------------------*/
typedef struct _PlayerShot1 {
	unsigned char	x, y;
	int/*bool*/	hit;
	unsigned char	timerPriv;
} PlayerShot1;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void PlayerShot1_setHit(PlayerShot1* self) { self->hit = 1/*true*/; }
int PlayerShot1_getX(PlayerShot1* self) { return self->x - 4; }
int PlayerShot1_getY(PlayerShot1* self) { return self->y; }
int PlayerShot1_getW(PlayerShot1* self) { return 4; }
int PlayerShot1_getH(PlayerShot1* self) { return 1; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void PlayerShot1_ctor(PlayerShot1* self);
void PlayerShot1_initialize(PlayerShot1* self, int argumentX, int argumentY);
void PlayerShot1_update(PlayerShot1* self);
/*--------------------------------------------------------------------------*/
typedef struct _PlayerShot2 {
	unsigned char	x, y;
	int/*bool*/	hit;
} PlayerShot2;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void PlayerShot2_setHit(PlayerShot2* self) { self->hit = 1/*true*/; }
int PlayerShot2_getX(PlayerShot2* self) { return self->x - 4; }
int PlayerShot2_getY(PlayerShot2* self) { return self->y; }
int PlayerShot2_getW(PlayerShot2* self) { return 1; }
int PlayerShot2_getH(PlayerShot2* self) { return 4; }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void PlayerShot2_ctor(PlayerShot2* self);
void PlayerShot2_initialize(PlayerShot2* self, int argumentX, int argumentY);
void PlayerShot2_update(PlayerShot2* self);
/*--------------------------------------------------------------------------*/
typedef struct _PlayerTire {
	unsigned char	x, y;
	unsigned char	timerPriv;
} PlayerTire;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void PlayerTire_ctor(PlayerTire* self);
void PlayerTire_initialize(PlayerTire* self, int argumentX, int argumentY, int argumentTireNum);
void PlayerTire_update(PlayerTire* self, int argumentTireNum);
/*--------------------------------------------------------------------------*/
typedef struct _Collision {
	int		dummy;
} Collision;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Collision_check(Collision* self);
/*--------------------------------------------------------------------------*/
typedef struct _Ui {
	int		dummy;
} Ui;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Ui_update(Ui* self);
/*--------------------------------------------------------------------------*/
typedef struct _Serval {
	unsigned char	x;
	unsigned char	prevScore;
	unsigned char	counter;
	unsigned char	appear;
	unsigned char	textNum;
} Serval;
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Serval_initialize(Serval* self);
void Serval_update(Serval* self);
/****************************************************************************
 *	ϐ
 ****************************************************************************/
int			score;
int			hiScore;
unsigned char		gameMode;
unsigned char		timer;
unsigned char		frame;
unsigned char		rndW;
/*--------------------------------------------------------------------------*/
#define			title		_title		//conflicting types for `title' C:\usr\PIECE\include/muslib.h:35: previous declaration of `title'
Title			title;
GameOver		gameOver;
StageManager		stageManager;
Collision		collision;
Ui			ui;
Serval			serval;
/*--------------------------------------------------------------------------*/
Jiki			jiki;
ShotManager		shotManager;
PlayerShot1		playerShot1;
PlayerShot2		playerShot2[2];
PlayerTire		playerTire[3];
/*--------------------------------------------------------------------------*/
Ground			ground[5];
ObjHole			objHole;
ObjRock			objRock;
ObjEnemy		objEnemy;
/****************************************************************************
 *	֐錾
 ****************************************************************************/
void updatecore();
void initialize();
void rnd();
void drawBitmap(char x, char y, int sprno, int c);
void fillRect(int x, int y, int w, int h, int c);
/****************************************************************************
 *	gamecore
 ****************************************************************************/
//
void updatecore() {
	timer++;
	frame = (timer / 8) % 4;
	rnd();
	Ui_update(&ui);
	switch(gameMode) {
	case BOOT:
		initialize();
	case TITLE:
		Title_update(&title);
//{{P/ECEœL̏
		if(joy & TRG_SELECT) { exit(0); }
//}}P/ECEœL̏
		break;
	case GAME_MAIN:
		Jiki_update(&jiki);
		StageManager_update(&stageManager);
		Serval_update(&serval);
		Collision_check(&collision);
//{{P/ECEœL̏
		if(joy & TRG_SELECT) { gameMode = BOOT; }
//}}P/ECEœL̏
		break;
	case GAME_OVER:
		GameOver_update(&gameOver);
		break;
	}
}
/*--------------------------------------------------------------------------*/
//N̏
void initialize() {
//{{P/ECEœL̏
	StopMusic();
//}}P/ECEœL̏
	Jiki_initialize(&jiki);
	StageManager_initialize(&stageManager);
	Serval_initialize(&serval);
	gameMode = TITLE;
	score = 0;
}
/*--------------------------------------------------------------------------*/
//ϐrndWɁA16`(SCREEN_WIDTH-1)̗i[B
void rnd() {
	rndW = RND32_RANGE(seed, 16, SCREEN_WIDTH);
}
/*--------------------------------------------------------------------------*/
//ʒu(x,y)ɁAXvCgsprnoAFcŕ`悷B
void drawBitmap(char x, char y, int sprno, int c) {	//GameOver_update()drawBitmap()̈x,y̌^toCgł鎖ɈˑĂ̂intɂĂ͂ȂB
	c = c ? COLOR_WHITE : COLOR_BLACK;
	sprite_draw(x, y, sprno, DRW_CLR(c,COLOR_MASK));
}
/*--------------------------------------------------------------------------*/
//ʒu(x,y)Aƍ(w,h)AFcœhׂB
void fillRect(int x, int y, int w, int h, int c) {
	c = c ? COLOR_WHITE : COLOR_BLACK;
	render_rectangle_fill(&render, x, y, w, h, c);
}
/****************************************************************************
 *	Collision
 ****************************************************************************/
void Collision_check(Collision* self) {
	int i;
	if(SCREEN_HEIGHT > PlayerShot1_getY(&playerShot1)) {
		if(abs(PlayerShot1_getW(&playerShot1) + ObjRock_getW(&objRock)) > abs(PlayerShot1_getX(&playerShot1) - ObjRock_getX(&objRock)) &&
		   abs(PlayerShot1_getH(&playerShot1) + ObjRock_getH(&objRock)) > abs(PlayerShot1_getY(&playerShot1) - ObjRock_getY(&objRock))) {
			if(!ObjRock_getHit(&objRock)) {
				PlayerShot1_setHit(&playerShot1);
				ObjRock_setHit(&objRock);
				score++;
//{{P/ECEœL̏
				sound_play(3, sound_table[SND_ROCK_HIT], 1);
//}}P/ECEœL̏
			}
		}
		if(abs(PlayerShot1_getW(&playerShot1) + ObjEnemy_getW(&objEnemy)) > abs(PlayerShot1_getX(&playerShot1) - ObjEnemy_getX(&objEnemy)) &&
		   abs(PlayerShot1_getH(&playerShot1) + ObjEnemy_getH(&objEnemy)) > abs(PlayerShot1_getY(&playerShot1) - ObjEnemy_getY(&objEnemy))) {
			if(!ObjEnemy_getHit(&objEnemy)) {
				PlayerShot1_setHit(&playerShot1);
				ObjEnemy_setHit(&objEnemy);
				score++;
//{{P/ECEœL̏
				sound_play(3, sound_table[SND_ENEMY_HIT], 1);
//}}P/ECEœL̏
			}
		}
	}
	for(i = 0; 2 > i; i++) {
		if(SCREEN_HEIGHT > PlayerShot2_getY(&playerShot2[i])) {
			if(abs(PlayerShot2_getW(&playerShot2[i]) + ObjEnemy_getW(&objEnemy)) > abs(PlayerShot2_getX(&playerShot2[i]) - ObjEnemy_getX(&objEnemy)) &&
			   abs(PlayerShot2_getH(&playerShot2[i]) + ObjEnemy_getH(&objEnemy)) > abs(PlayerShot2_getY(&playerShot2[i]) - ObjEnemy_getY(&objEnemy))) {
				if(!ObjEnemy_getHit(&objEnemy)) {
					PlayerShot2_setHit(&playerShot2[i]);
					ObjEnemy_setHit(&objEnemy);
					score++;
//{{P/ECEœL̏
					sound_play(3, sound_table[SND_ENEMY_HIT], 1);
//}}P/ECEœL̏
				}
			}
		}
	}
	if(!Jiki_getHit(&jiki)) {
		if(abs(Jiki_getW(&jiki) + ObjHole_getW(&objHole)) > abs(Jiki_getX(&jiki) - ObjHole_getX(&objHole)) &&
		   abs(Jiki_getH(&jiki) + ObjHole_getH(&objHole)) > abs(Jiki_getY(&jiki) - ObjHole_getY(&objHole))) {
			Jiki_setHit(&jiki);
//{{P/ECEœL̏
			sound_play(2, sound_table[SND_JIKI_HIT], 1);
//}}P/ECEœL̏
		}
		if(abs(Jiki_getW(&jiki) + ObjRock_getW(&objRock)) > abs(Jiki_getX(&jiki) - ObjRock_getX(&objRock)) &&
		   abs(Jiki_getH(&jiki) + ObjRock_getH(&objRock)) > abs(Jiki_getY(&jiki) - ObjRock_getY(&objRock))) {
			Jiki_setHit(&jiki);
//{{P/ECEœL̏
			sound_play(2, sound_table[SND_JIKI_HIT], 1);
//}}P/ECEœL̏
		}
		if(abs(Jiki_getW(&jiki) + ObjEnemy_getW(&objEnemy)) > abs(Jiki_getX(&jiki) - ObjEnemy_getX(&objEnemy)) &&
		   abs(Jiki_getH(&jiki) + ObjEnemy_getH(&objEnemy)) > abs(Jiki_getY(&jiki) - ObjEnemy_getY(&objEnemy))) {
			Jiki_setHit(&jiki);
//{{P/ECEœL̏
			sound_play(2, sound_table[SND_JIKI_HIT], 1);
//}}P/ECEœL̏
		}
	}
	if(abs(ObjHole_getW(&objHole) + ObjRock_getW(&objRock)) > abs(ObjHole_getX(&objHole) - ObjRock_getX(&objRock)) &&
	   abs(ObjHole_getH(&objHole) + ObjRock_getH(&objRock)) > abs(ObjHole_getY(&objHole) - ObjRock_getY(&objRock))) {
		ObjRock_setY(&objRock);
	}
}
/****************************************************************************
 *	Ui
 ****************************************************************************/
void Ui_update(Ui* self) {
	switch(gameMode) {
	case TITLE:
		render_printf(&render, 0, 0, 0, 0, "HI:%d", hiScore);
		break;
	case GAME_MAIN:
	case GAME_OVER:
		render_printf(&render, 0, 0, 0, 0, "SC:%d", score);
		if(score > hiScore) { hiScore = score; }
		break;
	}
}
/****************************************************************************
 *	Serval
 ****************************************************************************/
void Serval_initialize(Serval* self) {
	self->x = SCREEN_WIDTH;
	self->prevScore = 0;
	self->counter = 0;
	self->appear = 0;
	self->textNum = 0;
}
/*--------------------------------------------------------------------------*/
void Serval_update(Serval* self) {
	static const int text[] = { SPR_SERVAL_TEXT1,SPR_SERVAL_TEXT2,SPR_SERVAL_TEXT3,SPR_SERVAL_TEXT4 };
	if(self->prevScore != score) {
		if(self->x == SCREEN_WIDTH) {
			self->appear = rndW % 2;
			self->textNum = rndW % 5;
			if(self->textNum == 0) { self->textNum = 1; }
		}
	}
	if(self->appear) {
		self->counter++;
		if(19 > self->counter) {
			self->x -= 2;
		} else if(self->counter > 97) {
			self->counter = 0;
			self->appear = 0;
			self->textNum = 0;
			self->x = SCREEN_WIDTH;
		} else if(self->counter > 79) {
			self->x += 2;
		} else {
			drawBitmap(56, 24, text[self->textNum - 1], 1);
		}
	}
	drawBitmap(self->x, 0, SPR_SERVAL_2, 0);
	drawBitmap(self->x, 0, SPR_SERVAL_1, 1);
	self->prevScore = score;
}
/****************************************************************************
 *	Title
 ****************************************************************************/
void Title_update(Title* self) {
	if(joy & TRG_AB) {
		gameMode = GAME_MAIN;
//{{P/ECEœL̏
		{
			//CBGMJn
			extern /*const*/ unsigned char MAIN_BGM[];
			PlayMusic(MAIN_BGM);
		}
//}}P/ECEœL̏
	}
	drawBitmap(16, 16, SPR_TITLE_1, 1);
	drawBitmap(36, 56, SPR_TITLE_2, 1);
}
/****************************************************************************
 *	GameOver
 ****************************************************************************/
void GameOver_update(GameOver* self) {
	if(120 > self->counter) {
		drawBitmap(48, 232, SPR_SERVAL_1, 1);
		fillRect(48, 0, 32, 8, 0);
		render_printf(&render, 42, 48, 0, 0, "GAME OVER");
	} else {
		self->counter = 0;
		gameMode = BOOT;
	}
	self->counter++;
}
/****************************************************************************
 *	StageManager
 ****************************************************************************/
void StageManager_initialize(StageManager* self) {
	int i;
	for(i = 0; 5 > i; i++) {
		Ground_initialize(&ground[i], i);
	}
	ObjHole_initialize(&objHole);
	self->holeTimer = (rndW % 32) * 32;
	ObjRock_initialize(&objRock);
	self->rockTimer = self->holeTimer;
	ObjEnemy_initialize(&objEnemy);
	self->enemyTimer = self->holeTimer;
}
/*--------------------------------------------------------------------------*/
void StageManager_update(StageManager* self) {
	int i;
	if(self->holeTimer == self->rockTimer) {
		self->rockTimer = (rndW % 32) * 32;
	}
	for(i = 0; 3 > i; i++) {
		StageManager_setObj(self, i);
	}
	if(!Jiki_getHit(&jiki)) {
		for(i = 0; 5 > i; i++) {
			Ground_update(&ground[i]);
		}
		ObjHole_update(&objHole);
		ObjRock_update(&objRock);
		ObjEnemy_update(&objEnemy);
	}
	for(i = 0; 5 > i; i++) {
		Ground_disp(&ground[i]);
	}
	ObjHole_disp(&objHole);
	ObjRock_disp(&objRock);
	ObjEnemy_disp(&objEnemy);
}
/*--------------------------------------------------------------------------*/
void StageManager_setObj(StageManager* self, int argumentObjName) {
	int objY, objTimer;
	switch(argumentObjName) {
	default:DIE();
	case OBJ_ROCK:
		objY = ObjRock_getY(&objRock);
		objTimer = self->rockTimer;
		break;
	case OBJ_HOLE:
		objY = ObjHole_getY(&objHole);
		objTimer = self->holeTimer;
		break;
	case OBJ_ENEMY:
		objY = ObjEnemy_getY(&objEnemy);
		objTimer = self->enemyTimer;
		break;
	}
	if(timer == objTimer) {
		objTimer = (rndW % 32) * 32;
		if(objY == SCREEN_HEIGHT + 8) {
			switch(argumentObjName) {
			case OBJ_ROCK:
				ObjRock_initialize(&objRock);
				self->rockTimer = objTimer;
				break;
			case OBJ_HOLE:
				ObjHole_initialize(&objHole);
				self->holeTimer = objTimer;
				break;
			case OBJ_ENEMY:
				ObjEnemy_initialize(&objEnemy);
				self->enemyTimer = objTimer;
				break;
			}
		}
	}
}
/****************************************************************************
 *	Ground
 ****************************************************************************/
void Ground_initialize(Ground* self, int i) {
	self->x = 32 + 32 * i;
}
/*--------------------------------------------------------------------------*/
void Ground_update(Ground* self) {
	self->x--;
	if(self->x > 160) { self->x = 159; }
}
/*--------------------------------------------------------------------------*/
void Ground_disp(Ground* self) {
	drawBitmap(self->x - 32, 56, SPR_TILE, 1);
}
/****************************************************************************
 *	ObjHole
 ****************************************************************************/
void ObjHole_initialize(ObjHole* self) {
	self->x = SCREEN_WIDTH + 16;
	self->y = 60;
}
/*--------------------------------------------------------------------------*/
void ObjHole_update(ObjHole* self) {
	if(self->y == 60) { self->x--; }
	if(self->x > SCREEN_WIDTH + 16) { self->y = SCREEN_HEIGHT + 8; }
}
/*--------------------------------------------------------------------------*/
void ObjHole_disp(ObjHole* self) {
	drawBitmap(self->x - 16, self->y - 4, SPR_TILE2, 0);
}
/****************************************************************************
 *	ObjRock
 ****************************************************************************/
void ObjRock_initialize(ObjRock* self) {
	self->x = SCREEN_WIDTH + 8;
	self->y = 56;
	self->hit = 0/*false*/;
}
/*--------------------------------------------------------------------------*/
void ObjRock_update(ObjRock* self) {
	if(self->hit) {
		self->framePriv = (self->timerPriv / 4) % 4;
		self->timerPriv++;
		if(self->timerPriv == 15) {
			self->y = SCREEN_HEIGHT + 8;
			self->hit = 0/*false*/;
		}
	} else {
		if(self->y == 56) { self->x--; }
		if(self->x > SCREEN_WIDTH + 8) { self->y = SCREEN_HEIGHT + 8; }
	}
}
/*--------------------------------------------------------------------------*/
void ObjRock_disp(ObjRock* self) {
	if(self->hit) {
		drawBitmap(self->x - 8, self->y - 8, bitmapsB1[self->framePriv], 1);
	} else {
		drawBitmap(self->x - 8, self->y - 8, SPR_TILE3, 1);
	}
}
/****************************************************************************
 *	ObjEnemy
 ****************************************************************************/
void ObjEnemy_initialize(ObjEnemy* self) {
	self->x = rndW;
	self->y = 252;
}
/*--------------------------------------------------------------------------*/
void ObjEnemy_update(ObjEnemy* self) {
	if(self->hit) {
		self->framePriv = (self->timerPriv / 4) % 4;
		self->timerPriv++;
		if(self->timerPriv == 15) {
			self->y = SCREEN_HEIGHT + 8;
			self->hit = 0/*false*/;
		}
	} else {
		if(72 > self->timerPriv) {
			self->framePriv =      f2[self->timerPriv];
		} else {
			self->framePriv = -1 * f2[self->timerPriv - 72];
		}
		self->x += self->framePriv;
		self->timerPriv = (self->timerPriv + 1) % 144;
		if(!(timer % 18)) { self->y++; }
		if((252 > self->y) && (self->y > 56)) { self->y = SCREEN_HEIGHT + 8; }
	}
}
/*--------------------------------------------------------------------------*/
void ObjEnemy_disp(ObjEnemy* self) {
	if(self->hit) {
		drawBitmap(self->x - 8, self->y - 4, bitmapsB1[self->framePriv], 1);
	} else {
		drawBitmap(self->x - 16, self->y - 4, SPR_ENEMY, 1);
	}
}
/****************************************************************************
 *	Jiki
 ****************************************************************************/
void Jiki_initialize(Jiki* self) {
	self->x = 48;
	self->y = 44;
	self->alive = 1/*true*/;
	self->hit = 0/*false*/;
	self->jump = 0/*false*/;
	self->shotWait = 8;
	self->timerPriv = 0;
}
/*--------------------------------------------------------------------------*/
void Jiki_update(Jiki* self) {
	static const int bitmaps[] = { SPR_PLAYER_1,SPR_PLAYER_2,SPR_PLAYER_3,SPR_PLAYER_4,SPR_PLAYER_5 };
	static const int bitmapsB[] = { SPR_EXPLOSION1_1,SPR_EXPLOSION1_2 };
	if(self->hit) {
		int i;
		if(self->timerPriv == 0) {
			for(i = 0; 3 > i; i++) {
				PlayerTire_initialize(&playerTire[i], self->x, self->y, i);
			}
		}
		self->framePriv = (self->timerPriv / 8) % 2;
		self->timerPriv++;
		if(self->timerPriv == 63) { Jiki_dead(self); }
		drawBitmap(self->x - 32, self->y - 12, bitmapsB[self->framePriv], 1);
		for(i = 0; 3 > i; i++) {
			PlayerTire_update(&playerTire[i], i);
		}
	} else {
		if(joy & PAD_LF) { if(timer % 2) { self->x -= 1; } }
		if(joy & PAD_RI) { if(timer % 2) { self->x += 1; } }
		if(joy & TRG_B) {
			if(!self->jump) {
				self->jump = 1/*true*/;
//{{P/ECEœL̏
				sound_play(1, sound_table[SND_JUMP], 1);
//}}P/ECEœL̏
			}
		}
		if(self->shotWait) {
			self->shotWait--;
		} else {
			if(joy & PAD_A) { ShotManager_initialize(&shotManager); }
			self->shotWait = 8;
		}
		if(32 >= self->x) { self->x = 32; }
		if(self->x > SCREEN_WIDTH) { self->x = SCREEN_WIDTH; }
		if(4 >= self->y) { self->y = 4; }
		if(self->y > SCREEN_HEIGHT - 4) { self->y = SCREEN_HEIGHT - 4; }
		if(self->jump) {
			self->framePriv = 4;
			self->y += f[self->timerPriv];
			self->timerPriv = (self->timerPriv + 1) % 44;
			if(self->timerPriv == 0) { self->jump = 0/*false*/; }
		} else {
			self->framePriv = frame;
		}
		drawBitmap(self->x - 32, self->y - 12, bitmaps[self->framePriv], 1);
	}
	ShotManager_update(&shotManager);
}
/*--------------------------------------------------------------------------*/
void Jiki_dead(Jiki* self) {
//sv	self->hit = 0/*false*/;
//sv	self->alive = 0/*false*/;
	gameMode = GAME_OVER;
//{{P/ECEœL̏
	StopMusic();
//}}P/ECEœL̏
}
/****************************************************************************
 *	ShotManager
 ****************************************************************************/
void ShotManager_initialize(ShotManager* self) {
	int i;
	if(PlayerShot1_getY(&playerShot1) == SCREEN_HEIGHT + 8) {
		PlayerShot1_initialize(&playerShot1, Jiki_getX(&jiki), Jiki_getY(&jiki));
	}
	for(i = 0; 2 > i; i++) {
		if(PlayerShot2_getY(&playerShot2[i]) == SCREEN_HEIGHT + 8) {
			PlayerShot2_initialize(&playerShot2[i], Jiki_getX(&jiki), Jiki_getY(&jiki));
//{{P/ECEœL̏
			sound_play(0, sound_table[SND_SHOT], 1);
//}}P/ECEœL̏
			break;
		}
	}
}
/*--------------------------------------------------------------------------*/
void ShotManager_update(ShotManager* self) {
	int i;
	PlayerShot1_update(&playerShot1);
	for(i = 0; 2 > i; i++) {
		PlayerShot2_update(&playerShot2[i]);
	}
}
/****************************************************************************
 *	PlayerShot1
 ****************************************************************************/
void PlayerShot1_ctor(PlayerShot1* self) {
	self->y = SCREEN_HEIGHT + 8;
}
/*--------------------------------------------------------------------------*/
void PlayerShot1_initialize(PlayerShot1* self, int argumentX, int argumentY) {
	self->x = argumentX + 16;
	self->y = argumentY + 8;
	self->timerPriv = 0;
	self->hit = 0/*false*/;
}
/*--------------------------------------------------------------------------*/
void PlayerShot1_update(PlayerShot1* self) {
	if(self->y != SCREEN_HEIGHT + 8) {
		self->x += 2;
		self->timerPriv = (self->timerPriv + 1) % 16;
		if(self->timerPriv == 0) { self->hit = 1/*true*/; }
	}
	if(self->hit) {
		self->y = SCREEN_HEIGHT + 8;
		self->hit = 0/*false*/;
	}
	drawBitmap(self->x - 8, self->y - 4, SPR_SHOT, 1);
}
/****************************************************************************
 *	PlayerShot2
 ****************************************************************************/
void PlayerShot2_ctor(PlayerShot2* self) {
	self->y = SCREEN_HEIGHT + 8;
}
/*--------------------------------------------------------------------------*/
void PlayerShot2_initialize(PlayerShot2* self, int argumentX, int argumentY) {
	self->x = argumentX - 4;
	self->y = argumentY - 8;
	self->hit = 0/*false*/;
}
/*--------------------------------------------------------------------------*/
void PlayerShot2_update(PlayerShot2* self) {
	if(48 > self->y) {
		self->y -= 2;
	} else {
		self->y = SCREEN_HEIGHT + 8;
	}
	if(self->hit) {
		self->y = SCREEN_HEIGHT + 8;
		self->hit = 0/*false*/;
	}
	drawBitmap(self->x - 8, self->y - 4, SPR_SHOT2, 1);
}
/****************************************************************************
 *	PlayerTire
 ****************************************************************************/
void PlayerTire_ctor(PlayerTire* self) {
	self->y = SCREEN_HEIGHT + 8;
}
/*--------------------------------------------------------------------------*/
void PlayerTire_initialize(PlayerTire* self, int argumentX, int argumentY, int argumentTireNum) {
	switch(argumentTireNum) {
	case 0:
		self->x = argumentX - 4;
		self->y = argumentY + 12;
		break;
	case 1:
		self->x = argumentX - 10;
		self->y = argumentY;
		break;
	case 2:
		self->x = argumentX - 22;
		self->y = argumentY + 12;
		break;
	}
	self->timerPriv = 0;
}
/*--------------------------------------------------------------------------*/
void PlayerTire_update(PlayerTire* self, int argumentTireNum) {
	switch(argumentTireNum) {
	case 0:
		self->x++;
		break;
	case 1:
		/** no job **/
		break;
	case 2:
		self->x--;
		break;
	}
	self->y += f[self->timerPriv];
	self->timerPriv = (self->timerPriv + 1) % 44;
	if(self->timerPriv == 0) { self->y = 56; }
	drawBitmap(self->x - 4, self->y - 8, SPR_PLAYER_TIRE, 1);
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
int app_main(int argc, char* argv[]) {
  //{{JɊȒPɍő{[Adr\ɂ邽߂̉BR}hłB
	delay(1);
	if(joy & PAD_B) {	//BȂNc
		pceWaveSetMasterAtt(0);
		pcePowerSetReport(PWR_RPTOFF);
	}
  //}}JɊȒPɍő{[Adr\ɂ邽߂̉BR}hłB
	//C++ł̃O[oϐ̃RXgN^ɑ鏈sB
	{
		int i;
		PlayerShot1_ctor(&playerShot1);
		for(i = 0; i < ARRAY_SIZE(playerShot2); i++) { PlayerShot2_ctor(&playerShot2[i]); }
		for(i = 0; i < ARRAY_SIZE(playerTire); i++) { PlayerTire_ctor(&playerTire[i]); }
	}
	//Arduboy̕ʂ̂ŃZ^OB
	{
		surface_clear(&surface, 2);
		surface.h = SCREEN_HEIGHT;
		surface.vbuff += (DISP_X * (DISP_Y - SCREEN_HEIGHT) / 2);
		render_init_2d(&render, &surface, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
	}
	//ʉfނ̉ʂ傫̂ŏB
	{
		int i;
		for(i = 0; i < SOUND_MAXCH; i++) {
			sound_att(i, 8/**/);
		}
	}
	//C[v
	for(;;) {
		schedule();
		updatecore();
	}
	return 0;
}
