;#//	
;#//	nvlogd.tcl - nvlogd.exe߰
;#//	
;#//	* Sat Oct 31 21:12:42 JST 2015 Naoyuki Sawa
;#//	- 1st ذ
;#//	  dPrpTblD.tclްɂč쐬܂
;#//	
set VERSION 20151031	;#//ŏIXV
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//̧ق礼ٖ̱ڽ擾
proc getSymAddr {symFname symName} {
	set fp [open $symFname]
	while {[gets $fp line] >= 0} {
		set flds [regexp -all -inline {[^[:blank:]]+} $line]
		set name [lindex $flds 0]
		set addr [lindex $flds end]
		if {$name eq $symName} then {break}
	}
	if {[eof $fp]} then {error "### $symFname ̒ $symName ܂"}
	close $fp
	scan $addr {%x} addr
	return $addr
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//s۸ޯ̧̐擪4KB'core.'ɕۑ
proc coreDump {addr size} {
	file delete "core"					;#//܂mcore폜Ă֐̍Ōcore쐬omF
	set top [format {%x} $addr]
	set end [format {%x} [expr {$addr + $size - 1}]]
	set cmdLine "isd.exe w* core. $top $end"		;#//'.'tȂisd.exe'.bin'Ă܂
  ;#//{{---
	exec -ignorestderr {*}$cmdLine	;#//Tcl8.5ȍ~̏ꍇ
    ;#	exec {*}$cmdLine 2>@stderr	;#//Tcl8.4ȑȌꍇTcl8.5łok
  ;#//}}---
	if {![file exists "core"]} then {error "### core 쐬o܂łP/ECEڑĂȂ\L܂"}
	return "core"
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//P/ECȨټтs۸̧ق޳۰ނ
proc loadFile {fname} {
	file delete $fname					;#//܂m̧ق폜Ă֐̍Ō̧ق쐬omF
	set cmdLine "isd.exe =r $fname"
  ;#//{{---
	exec -ignorestderr {*}$cmdLine	;#//Tcl8.5ȍ~̏ꍇ
    ;#	exec {*}$cmdLine 2>@stderr	;#//Tcl8.4ȑȌꍇTcl8.5łok
  ;#//}}---
	if {![file exists $fname]} then {error "### $fname ޳۰ޏo܂łP/ECEڑĂȂ\L܂"}
	return $fname
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
;#//s۸̧ق̓e߂
proc nvlogDump {fname} {
	set cmdLine "nvlogd.exe $fname"
	set msg [exec {*}$cmdLine]
	return $msg
}
;#//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
if {$argc != 1} then {
	puts "nvlogd.tcl - nvlogd.exe߰ ($VERSION)"
	puts "Copyright (C) 2015 Naoyuki Sawa"
	puts ""
	puts "USAGE:"
	puts "  tclsh.exe $argv0 ̧ٖ.sym"
	puts "    ̧قs۸ޯ̧('nvlog')̱ڽ"
	puts "    P/ECE؂s۸ޯ̧ǂݏoe߂"
	puts "    <> tclsh.exe $argv0 sample.sym"
	puts ""
	puts "  tclsh.exe $argv0 s۸̧ٖ.bin"
	puts "    P/ECȨټтs۸̧ق޳۰ނe߂"
	puts "    <> tclsh.exe $argv0 nvlog.bin"
	exit 1
}
set fname [lindex $argv 0]
switch [file extension $fname] {
".sym"
	{
		set addr [getSymAddr $fname "nvlog"]
		set fname [coreDump $addr 4096]			;#//clipnvlg.hɂNVLOG_SIZE=BLOCKSIZE=4096ƒ`Ă̂š
		set msg [nvlogDump $fname]
		puts $msg
	}
".bin"
	{
		set fname [loadFile $fname]
		set msg [nvlogDump $fname]
		puts $msg
	}
default
	{
		error "### w肳ꂽ̧ق̎ނsł"
	}
}
