//┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
//┃★重要★このファイルはUTF-8形式で保存して下さい。シフトJIS形式で保存するとAfterEffectsが読み込めません。┃
//┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
//
//	MkAfxSeqXml2.jsx - AfterEffectsのアニメーションデータをXML形式で出力するツール	(複数のaepに対して連続処理するツール)
//
//	* Mon May 09 22:29:07 JST 2016 Naoyuki Sawa
//	- 1st リリース。
//
//=============================================================================
//■動作確認した環境
//│Adobe After Effects CS6 バージョン 11.0.4.2
//│Microsoft Windows 10 Home 64bit バージョン 1511 OS ビルド 10586.218
//-----------------------------------------------------------------------------
//■準備
//│「編集」→「環境設定」→「一般設定」→「スクリプトによるファイルへの書き込みとネットワークへのアクセスを許可」にチェックを付けておいて下さい。
//-----------------------------------------------------------------------------
//■使い方
//①AfterEffectsを起動する。プロジェクトは開かないで下さい。
//②「ファイル」→「スクリプト」→「スクリプトファイルを実行」→'MkAfxSeqXml2.jsx'を選択して下さい。
//③「ファイルリストを選択して下さい。」というダイアログが表示されるので、ファイルリストを指定して下さい。
//  │ファイルリストには一行に一個づつaepファイルのフルパス名を書いておいてください。			┐
//  │文字コードはシフトJISでもUTF-8でも構いません。(readln()が自動判別するから)			├■■■■■ファイルリストの書式■■■■■
//  │バスセパレータは'\'でも'/'でも構いません。(Undoc'd(?)ですが実験した所どちらでもokでした。)	┘
//④「以下のファイルを作成しました:～」というメッセージが表示されたら完了です。
//-----------------------------------------------------------------------------
//■データの作り方
//│'/clip/keep/MkAfxSeqXml用データの作り方.7z'を参照して下さい。
//=============================================================================
#include "MkAfxSeqXml.jsxinc"
//-----------------------------------------------------------------------------
//この配列に、作成したファイル名を追加して行く。
var outFiles = [ "以下のファイルを作成しました:" ]
//ファイルリストを選択する。
var fileList = File.openDialog("ファイルリストを選択して下さい。")
if(!fileList) {
	alert("処理を中止しました。")
} else {
	//ファイルリストを開く。
	if(!fileList.open("r")) {
		alert(fileList.fsName + "が開けません。")
	} else {
		//ファイルリストが終端に達するまで…
		while(!fileList.eof) {
			//一行読み込む。
			var fileName = fileList.readln()
			if(fileName == "") { continue }	//空行は飛ばす。
			//aepファイルを開く。
			var file = new File(fileName)
			var proj = app.open(file)	//app.open()の引数はファイル名ではなくファイルオブジェクトである事に注意せよ。
			if(!proj) {
				alert(fileName + "が開けません。")
				break	//ここまで
			}
			//mkAfxSeqXml()を実行する。
			var fsName = mkAfxSeqXml()
			//成功したら…
			if(fsName) {
				//作成したファイル名を連結する。
				outFiles.push(fsName)
			//失敗したら…
			} else {
				//中止メッセージを表示する。
				alert("処理を中止しました。")
				break	//ここまで
			}
			//aepファイルを閉じる。
			proj.close(CloseOptions.DO_NOT_SAVE_CHANGES)
			file.close()
		}
		//ファイルリストを閉じる。
		fileList.close()
		//完了メッセージを表示する。
		alert(outFiles.join("\n"))
	}
}
