/*
 *	app.cpp
 *
 *	AdxProbe.exe - Sofdec\c[
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Wed Mar 22 22:14:37 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	  /clip/tool/SofdecProbe/ɂč쐬܂B
 */
#include "app.h"
#define VERSION		"20170322"	//ŏIXV
/****************************************************************************
 *	main
 ****************************************************************************/
int main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
#ifdef  _DEBUG
	remove("syslog.out");			//񃍃O폜鎖ɂB
    #ifndef USE_JOB_DEBUG
	openlog(NULL, LOG_PERROR, LOG_USER);	//fobOrhł́AVXeOWG[ɂo͂BAfobOWugpꍇ́AfobOWucurses\ƏՓ˂Ȃ悤AWG[ɂ͏o͂ȂB
    #endif//USE_JOB_DEBUG
#else //_DEBUG
	setlogmask(LOG_UPTO(LOG_INFO));		//[Xrhł́ALOG_DEBUG}B
#endif//_DEBUG
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
//	putenv("GC_LOG_FILE=CON");//Oo͐w肷B
//	GC_set_find_leak(1);//[NoJnB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
#ifdef  __CLIP_SEH_H__
	SEH_init();
#endif//__CLIP_SEH_H__
#ifdef  USE_GDIPLUS
	Gdiplus_Init();
#endif//USE_GDIPLUS
	app_init(argc, argv);
	exitCode = app_main(argc, argv);
	app_exit();
#ifdef  USE_GDIPLUS
	Gdiplus_Exit();
#endif//USE_GDIPLUS
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
//	CHECK_LEAKS();//[NoB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
	return exitCode;
}
/****************************************************************************
 *	usage
 ****************************************************************************/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "AdxProbe.exe - Adx\c[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2017 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  AdxProbe.exe [option ...] filename[.hca] [filename[.hca] ...]\n");
	fprintf(stderr, "  EfilenaméAChJ[hɂ镡w\łB\n");
	fprintf(stderr, "  Efilename̊gqȗĂA'.hca'Ƃ܂B\n");
	fprintf(stderr, "  Efilename͑΃pXŎw肵ĉB΃pXŎw肷ƃG[܂B\n");		//΃pXG[ɂȂ闝ŔAcriFsBinder_BindDirectory()ŃtH_ɃoChƁAoC_΃pXȂ悤łB΃pX`ŐetH_֒Hčs͉\łB
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -c  CSV`ŏo͂܂B\n");
	fprintf(stderr, "      ̃IvVw肵Ȃ΁Aǂ݈Ղ`ŏo͂܂B\n");
	fprintf(stderr, "  -h  g\܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OUTPUT FIELDS:\n");
	fprintf(stderr, "  format           tH[}bg\n");
	fprintf(stderr, "  sampling_rate    TvOg\n");
	fprintf(stderr, "  num_samples      Tv\n");
	fprintf(stderr, "  loop_offset      [vJnTv\n");
	fprintf(stderr, "  loop_length      [vԃTv\n");
	fprintf(stderr, "  num_channels     `l\n");
	exit(EXIT_FAILURE);
}
/****************************************************************************
 *	
 ****************************************************************************/
void app_init(int argc, char* argv[]) {
	/** no job **/
}
/*--------------------------------------------------------------------------*/
void app_exit() {
	/** no job **/
}
/*--------------------------------------------------------------------------*/
int app_main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
	int opt_c = 0;	//'-c'IvVw肳ꂽ1ɂB
	//R}hCIvVB
	{
		int opt;
		opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
		while((opt = getopt(argc, argv, "ch")) != -1) {	//R}hCIvVB
			switch(opt) {
			case 'c':
				opt_c = 1;
				break;
			case 'h':
			default:
				usage();
			}
		}
	}
	//ȂƂȏTEht@Cw肳ĂȂ΂ȂB
	if(optind >= argc) { usage(); }
	//CuB
	{
		static const ST_SofdecHelperInfo stSofdecHelperInfo = {
			//--- SofdecHelper ---
			1,	//Đ郀[r[̐			0	//c[̓[r[gpĂȂ̂Ŗ{0ō\Ȃ͂Ȃ̂łAۂ0ɂCRICuŁuE2011030901M:CriManaLibConfig.max_decoder_handles must be at least 1.vƂG[̂ŁA_~[Ƃ1ɂ܂B
			NULL,	//[r[̃V[XAĐpR[obN	NULL
	    #ifdef  USE_ADX
			//--- AdxHelper ---
			0,	//ĐTEh̐			0	//AdxHelper_GetFormatInfo()́AĐv[ĂAꎞIȃv[쐬Ă擾ôŁAĐTEh̐(=Đv[̐)0ō\܂B
			NULL,	//TEh̃V[XAĐpR[obN	NULL
	    #endif//USE_ADX
		};
		SofdecHelper_Init(&stSofdecHelperInfo);
	}
	//eTEht@Cɂāc
	for(;;) {
		char path[MAX_PATH], drive[MAX_DRIVE], dir[MAX_DIR], fname[MAX_FNAME], ext[MAX_EXT];
		ST_AdxHelper_FormatInfo info;
		//TEht@C̊gqȗĂA'.hca'₤B
		splitpath(argv[optind], drive, dir, fname, ext);
		makepath(path, drive, dir, fname, ext[0] ? ext : ".hca");
		//tH[}bg擾B
		AdxHelper_GetFormatInfo(path, &info);
		//tH[}bg\B
		if(!opt_c) {
			//ǂ݈Ղ`
			printf("\"%s\"\n", path);
			printf("  format        %s\n", info.format);		//tH[}bg
			printf("  sampling_rate %d\n", info.sampling_rate);	//TvOg
			printf("  num_samples   %d\n", info.num_samples);	//Tv
			printf("  loop_offset   %d\n", info.loop_offset);	//[vJnTv
			printf("  loop_length   %d\n", info.loop_length);	//[vԃTv
			printf("  num_channels  %d\n", info.num_channels);	//`l
		} else {
			//CSV`
			printf("\"%s\",%s,%d,%d,%d,%d,%d\n",
				path,
				info.format,					//tH[}bg
				info.sampling_rate,				//TvOg
				info.num_samples,				//Tv
				info.loop_offset,				//[vJnTv
				info.loop_length,				//[vԃTv
				info.num_channels);				//`l
		}
		//TEht@C֐i߂B
		if(++optind >= argc) { break; }
		//ǂ݈Ղ`Ȃ΁AsށB
		if(!opt_c) { putchar('\n'); }
	}
	//CuN[AbvB
	SofdecHelper_Exit();
	return exitCode;
}
