/*
 *	obstack.c
 *
 *	Obstack - Pool of memory containing a stack of objects.
 *
 *	* Mon Oct 05 21:33:13 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- uObstackv(http://gcc.gnu.org/onlinedocs/libiberty/Obstacks.html)݊W[łB
 *	  ֐dĺuObstackvƓŁA͓ƎłB
 *	  IWił́uObstackv͑xdĂ╡GłA͒PɎ܂B
 *	- ֐dlg̐́AL̃hLg̑Aȉ̃hLgQlɂȂ܂B
 *	  uWikipedia - Obstackv(http://en.wikipedia.org/wiki/Obstack)
 *	  uIBM developerWorks Japan - [Ǘ̓v(http://www.ibm.com/developerworks/jp/linux/library/l-memory/)
 *	* Tue Oct 06 23:01:47 JST 2015 Naoyuki Sawa
 *	- obstack_free()objectwΉ܂B
 *	  objectNULLȊOw肷ƁAobjectȍ~(object܂)ɍ쐬IuWFNgJ܂B
 *	  ƂۂɂȏsP[X͂قƂǖAobstack_free()objectɂNULLw肷Ǝv܂B
 *	  BAobjectw肪ɗP[XƂẮAL̗p@炢łB
 *	  obstack_free(o,obstack_base(o)); //ݍ쐬̃IuWFNg̏Ԃ0oCgɖ߂B
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
struct _obstack_chunk {
	struct _obstack_chunk*	prev;			//܂łɊX̃IuWFNg܂ތÂ`Nւ̃`FCB
	int			size;			//ݍ쐬̃IuWFNgTCYB
	int			room;			//݂̎ceʁB
	char			data[0/*size*/];	//ݍ쐬̃IuWFNgB
};
/*--------------------------------------------------------------------------*/
static void _obstack_newchunk(struct obstack* o, int size) {
	struct _obstack_chunk* chunk = o->chunk;
	//̃`NL΁c
	if(chunk) {
		//ceʂsȂ΁c
		if(chunk->room < size) {
			//(ݍ쐬̃IuWFNgTCY+ǉTCY)PʃTCY̔{ɐ؂グTCYƂB
			size = (chunk->size + size + (obstack_chunk_size(o) - 1)) & ~(obstack_chunk_size(o) - 1);
			chunk = realloc(chunk, sizeof(struct _obstack_chunk) + size);
			if(!chunk) { DIE(); }
			//ceʂݒ肷B
			chunk->room = size - chunk->size;
		}
	//̃`N΁c
	} else {
		//(TCY)PʃTCY̔{ɐ؂グTCYƂB
		size = (size + (obstack_chunk_size(o) - 1)) & ~(obstack_chunk_size(o) - 1);
		chunk = calloc(sizeof(struct _obstack_chunk) + size, 1);
		if(!chunk) { DIE(); }
		//ceʂݒ肷B
		chunk->room = size;
	}
	//`Nݒ肷B
	o->chunk = chunk;
}
/****************************************************************************
 *	
 ****************************************************************************/
//2.3.1.2 Preparing for Using Obstacks
void obstack_init(struct obstack* o) {
	o->chunk = NULL;		//
	_obstack_newchunk(o, 0);	//V`N쐬B
}
/*--------------------------------------------------------------------------*/
//2.3.1.3 Allocation in an Obstack
void* obstack_alloc(struct obstack* o, int size) {
	obstack_blank(o, size);
	return obstack_finish(o);
}
void* obstack_copy(struct obstack* o, void* data, int size) {
	obstack_grow(o, data, size);
	return obstack_finish(o);
}
void* obstack_copy0(struct obstack* o, void* data, int size) {
	obstack_grow0(o, data, size);
	return obstack_finish(o);
}
/*--------------------------------------------------------------------------*/
//2.3.1.4 Freeing Objects in an Obstack
void obstack_free(struct obstack* o, void* object) {
	struct _obstack_chunk* chunk;			//{obstack_free()̊֐dlł͖(o->chunk=NULL)oɑ΂obstack_free(o,NULL)Ăяo̓͒`ĂȂ̂łA
	while((chunk = o->chunk)) {			//͂̂悤ɏĂ̂Ŗ(o->chunk=NULL)oɑ΂obstack_free(o,NULL)ĂяoĂSłB
		if(chunk->data == object) {
			chunk->room += chunk->size;	//objectݍ쐬̃IuWFNgꍇ́AceʂƃIuWFNgTCY̍vceʂƂȂBobjectIuWFNgꍇ́Aobstack_finish()ɂroom=0ɂĂ̂ŁAIuWFNgTCYceʂƂȂB
			chunk->size  = 0;		//IuWFNgTCY0ɖ߂B
			return;	//܂
		}
		o->chunk = chunk->prev;			//͕̏K{łB
		free(chunk);				//
	}
	if(object) { DIE(); }	//objectw肳ꂽ̂ɁA炸SĊJĂ܂ꍇ́A炭ĂяõoOłB
}
/*--------------------------------------------------------------------------*/
//2.3.1.6 Growing Objects
void obstack_blank(struct obstack* o, int size) {
	_obstack_newchunk(o, size);
	o->chunk->size += size;
	o->chunk->room -= size;
}
void obstack_grow(struct obstack* o, void* data, int size) {
	_obstack_newchunk(o, size);
	memcpy(&o->chunk->data[o->chunk->size], data, size);
	o->chunk->size += size;
	o->chunk->room -= size;
}
void obstack_grow0(struct obstack* o, void* data, int size) {
	obstack_grow(o, data, size);
	obstack_1grow(o, '\0');
}
void obstack_1grow(struct obstack* o, int data) {
	obstack_grow(o, &data, 1);
}
void obstack_ptr_grow(struct obstack* o, void* data) {
	obstack_grow(o, &data, sizeof data);				//[hEȊOłi[o悤ɂB
}
void obstack_int_grow(struct obstack* o, int data) {
	obstack_grow(o, &data, sizeof data);				//[hEȊOłi[o悤ɂB
}
void* obstack_finish(struct obstack* o) {
	struct _obstack_chunk* chunk = o->chunk;
	chunk = realloc(chunk, sizeof(struct _obstack_chunk) + chunk->size);	//̃`ÑIuWFNgTCY͌肵̂ŁA]ȃJB
	if(!chunk) { DIE(); }							//k̃TCY͏ɐ͂ł邪AÔߊmF鎖ɂB
	chunk->room = 0;							//obstack_free()ŎceʂĐݒ肷ꍇ̂߂ɁAԂƈvĂB
	o->chunk = NULL;		//V`N쐬邽߂ɁAUo->chunkNULLɂB
	_obstack_newchunk(o, 0);	//V`N쐬B
	o->chunk->prev = chunk;		//V`NɁAIuWFNg܂ތÂ`N`FCB
	return chunk->data;		//IuWFNg̃x[XAhXԂB
}
/*--------------------------------------------------------------------------*/
//2.3.1.7 Extra Fast Growing Objects
int obstack_room(struct obstack* o) {
	return o->chunk->room;
}
void obstack_blank_fast(struct obstack* o, int size) {
	if(o->chunk->room < size) { DIE(); }
	o->chunk->size += size;
	o->chunk->room -= size;
}
void obstack_1grow_fast(struct obstack* o, int data) {
	if(o->chunk->room < 1) { DIE(); }
	o->chunk->data[o->chunk->size] = data;
	o->chunk->size++;
	o->chunk->room--;
}
void obstack_ptr_grow_fast(struct obstack* o, void* data) {
	if(o->chunk->room < sizeof data) { DIE(); }
	memcpy(&o->chunk->data[o->chunk->size], &data, sizeof data);	//[hEȊOłi[o悤ɂB
	o->chunk->size += sizeof data;
	o->chunk->room -= sizeof data;
}
void obstack_int_grow_fast(struct obstack* o, int data) {
	if(o->chunk->room < sizeof data) { DIE(); }
	memcpy(&o->chunk->data[o->chunk->size], &data, sizeof data);	//[hEȊOłi[o悤ɂB
	o->chunk->size += sizeof data;
	o->chunk->room -= sizeof data;
}
/*--------------------------------------------------------------------------*/
//2.3.1.8 Status of an Obstack
void* obstack_base(struct obstack* o) {
	return o->chunk->data;
}
void* obstack_next_free(struct obstack* o) {
	return &o->chunk->data[o->chunk->size];
}
int obstack_object_size(struct obstack* o) {
	return o->chunk->size;
}
