// * Tue Mar 07 22:38:22 JST 2017 Naoyuki Sawa
// - Unity(少なくともUnity Version 5.5.2f1時点)の外部エディタとしてVS2015を使って、C#6を使うためのファイルです。
//   このファイルをそのまま、「Unityのプロジェクトフォルダ/Assets/Editor/ProjectFileHook.cs」にコピーして下さい。
//   そうする事によって、VS2015でソースコードを編集する時に、C#6が使えるようになります。
//   もし上手く行かない時は、「Unityのプロジェクトフォルダ/」直下に有るcsprojを全て一旦削除して、再起動して下さい。
// - 上記はあくまでも、VS2015でソースコードを編集する時のための対応です。
//   UnityがC#6のソースコードをビルドするために必要な「Assets/mcs.rsp」については、README.TXTの同日のコメントを参照して下さい。
//□参考資料
//│「Unity 5.5でasync/await使えた話 」(http://ufcpp.net/blog/2016/9/awaitinunity55/)						←←←←まず最初にこの記事を読みました。
//│「Project File Generation」(http://unityvs.com/documentation/api/project-file-generation/)					←──┐
//│「XElementをつかって要素の追加、削除、変更」(http://blog.livedoor.jp/tkarasuma/archives/1037273816.html)			←←←┼これらの記事を読んでもなかなか上手く行かなかったのですが…
//│「Remove XElement from XDocument Error」(http://stackoverflow.com/questions/15787689/remove-xelement-from-xdocument-error)	←──┘
//│「VS2015のRoslynでCode Analyzerを自作する(ついでにUnityコードも解析する)」(http://neue.cc/2014/11/20_485.html)		←←←←この記事が特に参考になりました。削除する要素をDescendants()で検索する時にデフォルトの名前空間の指定が必要である事に気付かせてくれました。
using System.IO;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using SyntaxTree.VisualStudio.Unity.Bridge;
using UnityEditor;
[InitializeOnLoad]
public class ProjectFileHook {
	//necessary for XLinq to save the xml project file in utf8
	class Utf8StringWriter : StringWriter {
		public override Encoding Encoding {
			get { return Encoding.UTF8; }
		}
	}
	static ProjectFileHook() {
		ProjectFilesGenerator.ProjectFileGeneration += (string name, string content) => {
			XDocument doc = XDocument.Parse(content);
			//-----------------------------------------------------------------------------
			var ns = doc.Root.Name.Namespace;
			var lv = doc.Descendants(ns + "LangVersion").ToArray();	//Unity(少なくともUnity Version 5.5.2f1時点)が生成するcsprojには「<LangVersion Condition=" '$(VisualStudioVersion)' != '10.0' ">4</LangVersion>」が含まれておりVS2015で開くとC#4しか使えない。C#6を使うにはこの行を削除すれば良い。
			foreach(var i in lv) {
				i.Remove();
			}
			//-----------------------------------------------------------------------------
			var str = new Utf8StringWriter();
			doc.Save(str);
			return str.ToString();
		};
	}
}
