//
//	ctype.cs
//
//	ރ[`
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2017 Naoyuki Sawa
//
//	* Wed Mar 15 22:06:35 JST 2017 Naoyuki Sawa
//	- 1st [XB
//
using System;
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	[J֐
		//*****************************************************************************
		private static bool ctype_subr(int c, ushort[] range) {
			int width, lo, i = 0;
			for(;;) {
				width = range[i++];					//lo|(width<<8)
				lo = (byte)width;					//lo=(rangẻl)-(Orangȅl+1)
				if((width >>= 8) == 0) { break; }			//widthoBwidth=0ȂΏI[łB		ǂrangeɂqbgȂ0ԂBwidth0ł邩widthԂΗǂB
				c -= lo;						//c(rangẻl)̑΂ƂB
				if((uint)c < (uint)width) { break; }			//crangeɃqbg𔻒肷B		ǂꂩrangeɃqbg0ȊOԂBwidth0ȊOł邩widthԂΗǂB
				c -= width;						//c(rangȅl+1)̑΂ƂB
			}
			return width != 0;
		}
		//*****************************************************************************
		//	O[o֐
		//*****************************************************************************
		public static bool isdigit(int c) {
			ushort[] range = new ushort[] {
						('0'-(0+0x0))|((1+'9')-'0')<<8,		//'0'`'9'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isxdigit(int c) {
			ushort[] range = new ushort[] {
						('0'-(0+0x0))|((1+'9')-'0')<<8,		//'0'`'9'
						('A'-(1+'9'))|((1+'F')-'A')<<8,		//'A'`'F'
						('a'-(1+'F'))|((1+'f')-'a')<<8,		//'a'`'f'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isupper(int c) {
			ushort[] range = new ushort[] {
						('A'-(0+0x00))|((1+'Z')-'A')<<8,	//'A'`'Z'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool islower(int c) {
			ushort[] range = new ushort[] {
						('a'-(0+0x00))|((1+'z')-'a')<<8,	//'a'`'z'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isalpha(int c) {
			ushort[] range = new ushort[] {
						('A'-(0+0x0))|((1+'Z')-'A')<<8,		//'A'`'Z'
						('a'-(1+'Z'))|((1+'z')-'a')<<8,		//'a'`'z'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isalnum(int c) {
			ushort[] range = new ushort[] {
						('0'-(0+0x0))|((1+'9')-'0')<<8,		//'0'`'9'
						('A'-(1+'9'))|((1+'Z')-'A')<<8,		//'A'`'Z'
						('a'-(1+'Z'))|((1+'z')-'a')<<8,		//'a'`'z'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool iscsymf(int c) {
			ushort[] range = new ushort[] {
						('A'-(0+0x0))|((1+'Z')-'A')<<8,		//'A'`'Z'
						('_'-(1+'Z'))|((1+'_')-'_')<<8,		//'_'
						('a'-(1+'_'))|((1+'z')-'a')<<8,		//'a'`'z'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool iscsym(int c) {
			ushort[] range = new ushort[] {
						('0'-(0+0x0))|((1+'9')-'0')<<8,		//'0'`'9'
						('A'-(1+'9'))|((1+'Z')-'A')<<8,		//'A'`'Z'
						('_'-(1+'Z'))|((1+'_')-'_')<<8,		//'_'
						('a'-(1+'_'))|((1+'z')-'a')<<8,		//'a'`'z'
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool iscntrl(int c) {
			ushort[] range = new ushort[] {
						(0x00-(0+0x00))|((1+0x1F)-0x00)<<8,	//0x00`0x1F
						(0x7F-(1+0x1F))|((1+0x7F)-0x7F)<<8,	//0x7F
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isblank(int c) {
			ushort[] range = new ushort[] {
						(0x09-(0+0x00))|((1+0x09)-0x09)<<8,	//0x09
						(0x20-(1+0x09))|((1+0x20)-0x20)<<8,	//0x20
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isspace(int c) {
			ushort[] range = new ushort[] {
						(0x09-(0+0x00))|((1+0x0D)-0x09)<<8,	//0x09`0x0D
						(0x20-(1+0x0D))|((1+0x20)-0x20)<<8,	//0x20
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isgraph(int c) {
			ushort[] range = new ushort[] {
						(0x21-(0+0x00))|((1+0x7E)-0x21)<<8,	//0x21`0x7E				//yNOTEzu0x7E+1vłȂu1+0x7EvƏRFu0x7E+1vƏgcc33.exeugarbage at end of numbervƂG[ɂȂB16iƕ_̎w\ƂʏoȂ߂̂悤Bd̂Łu+v̑OւB(G[ɂȂ邾܂}VBقĕ_̎w\ƌȂĂɌtÂ炢oOɂȂ鏊)
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool isprint(int c) {
			ushort[] range = new ushort[] {
						(0x20-(0+0x00))|((1+0x7E)-0x20)<<8,	//0x20`0x7E
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool ispunct(int c) {
			ushort[] range = new ushort[] {
						(0x21-(0+0x00))|((1+0x2F)-0x21)<<8,	//0x21`0x2F				//yNOTEzP/ECEJtEPSONCuispunct()́Aispunct(0x20)ɑ΂ĂtrueԂĂ܂oOłBispunct(0x20)ɑ΂ĂfalseԂ̂B
						(0x3A-(1+0x2F))|((1+0x40)-0x3A)<<8,	//0x3A`0x40
						(0x5B-(1+0x40))|((1+0x60)-0x5B)<<8,	//0x5B`0x60
						(0x7B-(1+0x60))|((1+0x7E)-0x7B)<<8,	//0x7B`0x7E
			0};//I[
			return ctype_subr(c, range);
		}
		//-----------------------------------------------------------------------------
		public static bool ismbblead(int c) {
			ushort[] range = new ushort[] {
						(0x81-(0+0x00))|((1+0x9F)-0x81)<<8,	//0x81`0x9F
						(0xE0-(1+0x9F))|((1+0xFC)-0xE0)<<8,	//0xE0`0xFC
			0};//I[
			return ctype_subr((byte)c, range);				//'(byte)'̏ctype_subr()Ɋ܂߂Ă͂܂Bc[31:8]𖳎̂ismbblead()ismbbtrail()łB
		}
		//-----------------------------------------------------------------------------
		public static bool ismbbtrail(int c) {
			ushort[] range = new ushort[] {
						(0x40-(0+0x00))|((1+0x7E)-0x40)<<8,	//0x40`0x7E
						(0x80-(1+0x7E))|((1+0xFC)-0x80)<<8,	//0x80`0xFC
			0};//I[
			return ctype_subr((byte)c, range);				//'(byte)'̏ctype_subr()Ɋ܂߂Ă͂܂Bc[31:8]𖳎̂ismbblead()ismbbtrail()łB
		}
		//-----------------------------------------------------------------------------
		public static int toupper(int c) {
			if(((c >= 'a') && (c <= 'z'))) {
				c -= ('a' - 'A');
			}
			return c;
		}
		//-----------------------------------------------------------------------------
		public static int tolower(int c) {
			if(((c >= 'A') && (c <= 'Z'))) {
				c += ('a' - 'A');
			}
			return c;
		}
	}
}
