//
//	clipsnd_uni.cs
//
//	アプリケーションのサウンド関数
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2017 Naoyuki Sawa
//
//	* Mon Mar 27 22:39:32 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	  まだアプリケーションとライブラリの分離が不完全で、当モジュール内にアプリケーション依存の定数やグローバル変数への参照が残っています。
//	  そのため、現在はまだ、当モジュールを直接アプリケーションに含めて、ビルドしています。
//	  引き続き、アプリケーションとライブラリの分離を行って行きます。(※TODO:)
//
#if UNITY_5_3_OR_NEWER
using System;
using static org.piece_me.libclip;
using static Const;
public static partial class Program {
	//*****************************************************************************
	//	ローカル変数
	//*****************************************************************************
	private static class Sound {
		public static ST_AudioHelper		pAudioHelper;
		public static ST_TapSeq			pTapSeq;
		public static ST_TapMxr			pTapMxr;
		public static ST_TapSeqInfo		pTapSeqInfo;
		public static int[][]			TBL_TapMxrChMask;
	}
	//*****************************************************************************
	//	Audioプレイヤーの実装
	//*****************************************************************************
	public class AudioPlayer : IAudioPlayer {
		CriAtomExPlayer		criAtomExPlayer;	//AtomExプレイヤー
		//-----------------------------------------------------------------------------
		public AudioPlayer() {
			//AtomExプレイヤーを作成する。
			criAtomExPlayer = new CriAtomExPlayer(260/*最大パス文字列長*/, 1/*同時再生ファイル数*/);
		#if     (!UNITY_EDITOR && UNITY_ANDROID)
			criAtomExPlayer.SetSoundRendererType(CriAtomEx.SoundRendererType.Native);
		#endif//(!UNITY_EDITOR && UNITY_ANDROID)
		}
		//-----------------------------------------------------------------------------
		void IDisposable.Dispose() {
			//AtomExプレイヤーを削除する。
			criAtomExPlayer.Dispose();
		}
		//-----------------------------------------------------------------------------
		AudioPlayerStatus IAudioPlayer.GetStatus() {
			//プレイヤーの状態を取得する。
			return (AudioPlayerStatus)criAtomExPlayer.GetStatus();
		}
		//-----------------------------------------------------------------------------
		void IAudioPlayer.Prepare(int iPhrNo) {
			//フレーズ番号を検査する。
			if((iPhrNo < 1) || (iPhrNo > PhrNo_Max)) { throw new ApplicationException(); }
			//フレーズのパス名を取得する。
			string path = REG_get_string_l(TBL_RegTbl, RegKey_PhrDef, iPhrNo, RegKey_Path);
			if(path == null) { throw new ApplicationException(); }
			//フレーズのパス名を設定する。
			criAtomExPlayer.SetFile(binder, path);
			//ヘッダ解析を開始する。
			criAtomExPlayer.Prepare();
		}
		//-----------------------------------------------------------------------------
		void IAudioPlayer.Start() {
			//再生準備が完了したら、再生が開始するようにしておく。
			criAtomExPlayer.Resume(CriAtomEx.ResumeMode.AllPlayback);
		}
		//-----------------------------------------------------------------------------
		void IAudioPlayer.Stop() {
			//再生,又は,再生準備を停止する。
			criAtomExPlayer.Stop(true/*リリース時間を無視して音声を即座に停止する*/);
			//プレイヤーの状態が停止中になるまで待つ。
			for(;;) {
				CriAtomExPlayer.Status status = criAtomExPlayer.GetStatus();
				if(status == CriAtomExPlayer.Status.Error) { throw new ApplicationException(); }
				if(status == CriAtomExPlayer.Status.Stop) { break; }
				//Unity版のCRIにはAtomEx_ExecuteMain()に相当する関数が無く、ここで呼び出さなくても構わないようです。(実験より)
			}
		}
		//-----------------------------------------------------------------------------
		void IAudioPlayer.SetVolume(double volume) {
			//ボリュームを設定する。
			criAtomExPlayer.SetVolume((float)volume);
			//再生パラメータを更新する。
			criAtomExPlayer.UpdateAll();	//忘れないで!!
		}
		//-----------------------------------------------------------------------------
		void IAudioPlayer.SetPan(double pan) {
			//※TODO:2Dパンを設定するADX2の関数がわかりません…
		}
	}
	//*****************************************************************************
	//	グローバル関数
	//*****************************************************************************
	//サウンドの初期化処理
	public static void Sound_Init(ST_TimMgr pTimMgr, ST_TapSeqInfo pTapSeqInfo, int[][] TBL_TapMxrChMask, out ST_TapSeq pTapSeq, out ST_TapMxr pTapMxr) {
//{{※TODO:削除しろ。
		//※TODO:最終的にアプリケーションから分離するのでこの検査は出来なくなる予定です。
		if(pTapSeqInfo.nDevCh != (TapDevCh_Max+1)) { throw new ApplicationException(); }
		if(pTapSeqInfo.nLogCh != (TapLogCh_Max+1)) { throw new ApplicationException(); }
		if(pTapSeqInfo.nSeqCh != (TapSeqCh_Max+1)) { throw new ApplicationException(); }
		if(TBL_TapMxrChMask.GetLength(0) != (TapLogCh_Max+1)) { throw new ApplicationException(); }
//}}※TODO:削除しろ。
		//オーディオ管理の初期化を実行する。
#if     (!UNITY_EDITOR && UNITY_ANDROID)
		int nCh = criWareInitializer.atomConfig.androidLowLatencyStandardVoicePoolConfig.streamingVoices;
#else //(!UNITY_EDITOR && UNITY_ANDROID)
		int nCh = criWareInitializer.atomConfig.standardVoicePoolConfig.streamingVoices;
#endif//(!UNITY_EDITOR && UNITY_ANDROID)
		if(nCh < pTapSeqInfo.nLogCh) { throw new ApplicationException(); }
		Sound.pAudioHelper = AudioHelper_New(nCh, delegate(object arg) { return new AudioPlayer(); }, null);
		//TAPシーケンサを初期化する。
		Sound.pTapSeqInfo = pTapSeqInfo;
		pTapSeqInfo.fnPlay		= Sound_fnPlay;		//再生開始通知						┐
		pTapSeqInfo.fnStop		= Sound_fnStop;		//再生停止通知						│
		pTapSeqInfo.fnLoop		= Sound_fnLoop;		//自然ループ通知					│
		pTapSeqInfo.fnEnd		= Sound_fnEnd;		//自然停止通知						│※TODO:渡された初期化情報を直接書き換えるのは望ましくない。何とかしろ。(このままでも動作はするが)
		pTapSeqInfo.fnNext		= Sound_fnNext;		//自然遷移通知						│
		pTapSeqInfo.fnCtrl		= Sound_fnCtrl;		//コントロール通知					│
		pTapSeqInfo.fnGetPhrTime	= Sound_fnGetPhrTime;	//フレーズ時間[ms]を取得する。				│
		pTapSeqInfo.fnGetPhrNext	= Sound_fnGetPhrNext;	//フレーズチェインの次のフレーズ番号を取得する。	┘
		Sound.pTapSeq = TapSeq_New(Sound.pTapSeqInfo);
		pTapSeq = Sound.pTapSeq;	//呼び出し側の再生処理のためにTAPシーケンサを返す。
		TimMgr_AddFunc(stTimMgr, TimMgrCh_10ms/*調整可*/, new ST_TimMgrFunc() {
				fn = Sound_TapSeq_TimeProc,
				uItv = 1/*調整可*/,
			});
		//TAPミキサーを初期化する。
		Sound.TBL_TapMxrChMask = TBL_TapMxrChMask;
		Sound.pTapMxr = TapMxr_New(TapMxrCh_Max+1);
		pTapMxr = Sound.pTapMxr;	//呼び出し側の再生処理のためにTAPミキサーを返す。
		TimMgr_AddFunc(stTimMgr, TimMgrCh_10ms/*調整可*/, new ST_TimMgrFunc() {
				fn = Sound_TapMxr_TimeProc,
				uItv = 5/*調整可*/,
			});
	}
	//-----------------------------------------------------------------------------
	//サウンドの周期処理
	public static void Sound_Exec() {
		//オーディオ管理の周期処理を実行する。
		AudioHelper_Exec(Sound.pAudioHelper);
	}
	//-----------------------------------------------------------------------------
	//サウンドの終了処理
	public static void Sound_Exit() {
		//オーディオ管理の終了処理を実行する。
		AudioHelper_Exit(Sound.pAudioHelper);
	}
	//*****************************************************************************
	//	アプリケーション定義のコールバック関数
	//*****************************************************************************
	//再生開始通知
	private static void Sound_fnPlay(ST_TapSeq pTapSeq, int iLogCh, ST_TapLogCh pLogCh) {
		Sound_play_phr(iLogCh, pLogCh);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//再生停止通知
	private static void Sound_fnStop(ST_TapSeq pTapSeq, int iLogCh, ST_TapLogCh pLogCh) {
		Sound_stop_phr(iLogCh, pLogCh);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//自然ループ通知
	private static void Sound_fnLoop(ST_TapSeq pTapSeq, int iLogCh, ST_TapLogCh pLogCh) {
		Sound_play_phr(iLogCh, pLogCh);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//自然停止通知
	private static void Sound_fnEnd(ST_TapSeq pTapSeq, int iLogCh, ST_TapLogCh pLogCh) {
		Sound_stop_phr(iLogCh, pLogCh);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//自然遷移通知
	private static void Sound_fnNext(ST_TapSeq pTapSeq,int iLogCh, ST_TapLogCh pLogCh) {
		Sound_play_phr(iLogCh, pLogCh);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//コントロール通知
	private static void Sound_fnCtrl(ST_TapSeq pTapSeq,int iLogCh, ST_TapLogCh pLogCh) {
		Sound_set_att(iLogCh, pLogCh);
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//フレーズ時間[ms]を取得する。
	private static int Sound_fnGetPhrTime(ST_TapSeq pTapSeq,int iPhr) {
		int nTime = REG_get_value_l(
			TBL_RegTbl,
			RegKey_PhrDef,
			iPhr,
			RegKey_Time);
		if(nTime == -1) { throw new ApplicationException(); }
		return nTime;
	}
	//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//フレーズチェインの次のフレーズ番号を取得する。
	private static int Sound_fnGetPhrNext(ST_TapSeq pTapSeq,int iPhr) {
		int iNext = REG_get_value_l(
			TBL_RegTbl,
			RegKey_PhrDef,
			iPhr,
			RegKey_Next);
		iNext = (iNext << 8) >> 8;	//iNext[23]を符号拡張する。	忘れないで!!
		return iNext;
	}
	//*****************************************************************************
	//	アプリケーション定義のタイマ関数
	//*****************************************************************************
	private static void Sound_TapSeq_TimeProc(object arg) {
		//TAPシーケンサを実行する。
		TapSeq_Exec(Sound.pTapSeq, (10*1)/*調整可*/);
	}
	//-----------------------------------------------------------------------------
	private static void Sound_TapMxr_TimeProc(object arg) {
		int iDevCh, iLogCh;
		//TAPミキサーを実行する。
		TapMxr_Exec(Sound.pTapMxr, (10*5)/*調整可*/);
		//各デバイスチャネルについて…
		for(iDevCh = 0; iDevCh < Sound.pTapSeqInfo.nDevCh; iDevCh++) {
			//このデバイスチャネルを制御している論理チャネルが有れば…
			iLogCh = TapSeq_GetDevCh(Sound.pTapSeq, iDevCh).iLogCh;
			if(iLogCh != byte.MaxValue) {
				//このデバイスチャネルを制御している論理チャネルを取得する。
				ST_TapLogCh pLogCh = TapSeq_GetLogCh(Sound.pTapSeq, iLogCh);
				//この論理チャネルに適用するミキサーチャネルの合計減衰量を、デバイスチャネルに設定する。
				Sound_set_att(iLogCh, pLogCh);
			}
		}
	}
	//*****************************************************************************
	//	ローカル関数
	//*****************************************************************************
	//指定された論理チャネルがデバイスチャネルを獲得していたら、そのデバイスチャネルでフレーズを'非ループ'再生する。
	private static void Sound_play_phr(int iLogCh, ST_TapLogCh pLogCh) {
		int iDevCh = pLogCh.iDevCh;
		//指定された論理チャネルがデバイスチャネルを獲得していたら…
		if(iDevCh != byte.MaxValue) {
			//デバイスチャネルを再生する。
			AudioHelper_Play(Sound.pAudioHelper, iDevCh, pLogCh.iPhr);
			//指定された論理チャネルに適用する合計減衰量を、デバイスチャネルに設定する。
			Sound_set_att(iLogCh, pLogCh);
		}
	}
	//-----------------------------------------------------------------------------
	//指定された論理チャネルがデバイスチャネルを獲得しており,かつ,そのデバイスチャネルで再生中のフレーズ番号が有れば、そのフレーズを停止する。
	private static void Sound_stop_phr(int iLogCh, ST_TapLogCh pLogCh) {
		int iDevCh = pLogCh.iDevCh;
		//指定された論理チャネルがデバイスチャネルを獲得していたら…
		if(iDevCh != byte.MaxValue) {
			//デバイスチャネルを停止する。
			// - 既に停止している場合はダミー処理となり安全です。
			AudioHelper_Stop(Sound.pAudioHelper, iDevCh);
		}
	}
	//-----------------------------------------------------------------------------
	//指定された論理チャネルがデバイスチャネルを獲得していたら、この論理チャネルに適用するミキサーチャネルの合計減衰量を、デバイスチャネルに設定する。
	private static void Sound_set_att(int iLogCh, ST_TapLogCh pLogCh) {
		int iDevCh = pLogCh.iDevCh;
		//指定された論理チャネルがデバイスチャネルを獲得していたら…
		if(iDevCh != byte.MaxValue) {
			//指定された論理チャネルに適用する合計減衰量を取得し、減衰量⇒音量に変換する。
			int iVol = 255;								//音量の最大値
			iVol -= TapMxr_GetAtt(Sound.pTapMxr, Sound.TBL_TapMxrChMask[iLogCh]);	//TAPミキサーの合計減衰量…1次ボリューム相当
			iVol -= pLogCh.iAtt;							//論理チャネルの減衰量   …2次ボリューム相当
			if(iVol < 0) { iVol = 0; }
			//変換した音量を、デバイスチャネルに設定する。
			AudioHelper_SetVolume(Sound.pAudioHelper, iDevCh, iVol / 255.0);
		}
	}
	//*****************************************************************************
	//	再生関数
	//*****************************************************************************
	//再生処理は、Sound_Init()が返したpTapSeq,pTapMxrを使って行って下さい。
	//従って、当モジュールに特有の再生関数は有りません。
	//-----------------------------------------------------------------------------
}
#endif//UNITY_5_3_OR_NEWER
