//
//	clipmisc.cs
//
//	エラー処理、その他いろいろです。
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2017 Naoyuki Sawa
//
//	* Sun Mar 19 22:19:43 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	  一先ず「Direct3D互換のD3DCOLOR形式マクロ」だけを実装しました。
//	  clipsprf.csモジュールにおいて必要だからです。
//	* Tue Mar 21 21:23:37 JST 2017 Naoyuki Sawa
//	- D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。
//	  詳細は、clipmisc.hの同日のコメントを参照して下さい。
//
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	Direct3D互換のD3DCOLOR形式マクロ
		//*****************************************************************************
		//□参照資料:/Program Files/Microsoft Visual Studio/VC98/Include/D3DTYPES.H
		//┌────┬────┬────┬────┐
		//│alpha   │red     │green   │blue    │
		//└────┴────┴────┴────┘
		public static int D3DRGBA(double r, double g, double b, double a)	{ return RGBA_MAKE((int)(r*255),(int)(g*255),(int)(b*255),(int)(a*255)); }	//これだけ[0.0～1.0]。これ以外は[0～255]。
		public static int RGBA_MAKE(int r, int g, int b, int a)			{ return (((byte)a)<<24)|(((byte)r)<<16)|(((byte)g)<<8)|((byte)b); }
		public static int RGBA_GETBLUE(int rgba)				{ return (byte)(rgba    ); }
		public static int RGBA_GETGREEN(int rgba)				{ return (byte)(rgba>> 8); }
		public static int RGBA_GETRED(int rgba)					{ return (byte)(rgba>>16); }
		public static int RGBA_GETALPHA(int rgba)				{ return (byte)(rgba>>24); }
		public static int RGBA_SETALPHA(int rgba, int a)			{ return (a<<24)|(rgba&0xFFFFFF); }
		public static int RGBA_TORGB(int rgba)					{ return RGBA_SETALPHA(rgba,0); }
		//┌────┬────┬────┬────┐
		//│ignored │red     │green   │blue    │
		//└────┴────┴────┴────┘
//{{2017/03/21変更:D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。
//		public static int D3DRGB(int r, int g, int b)				{ return D3DRGBA(r,g,b,0); }							//これだけ[0.0～1.0]。これ以外は[0～255]。
//↓2017/03/21変更:D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。
		public static int D3DRGB(int r, int g, int b)				{ return D3DRGBA(r,g,b,1); }							//これだけ[0.0～1.0]。これ以外は[0～255]。	//┐2017/03/21コメント追記:
//}}2017/03/21変更:D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。															//│RGB_MAKE()はα成分を0.0にするが、D3DRGB()はα成分を1.0にするという、Direct3Dの仕様に合わせました。
		public static int RGB_MAKE(int r, int g, int b)				{ return RGBA_MAKE(r,g,b,0); }													//┘なぜそういう判り辛い仕様になっているのか理解出来ないのですが、ともかく、合わせておく事にしました。
		public static int RGB_GETBLUE(int rgb)					{ return RGBA_GETBLUE(rgb); }
		public static int RGB_GETGREEN(int rgb)					{ return RGBA_GETGREEN(rgb); }
		public static int RGB_GETRED(int rgb)					{ return RGBA_GETRED(rgb); }
		public static int RGB_TORGBA(int rgb)					{ return RGBA_SETALPHA(rgb,255); }
	}
}
