
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

	.code
	.align	1
	.global	draw_primitive
draw_primitive:
	;// %r12 := vertices
	;// %r13 := n_vertices (>=3)
	;// %r14 := param
	;// %r15 := draw_scanline
	pushn	%r3
	sub	%sp,0x2a	; 	xsub	%sp, %sp, 168
	;// [%sp+  0] := side[0].iv	SIDE(0)
	;// [%sp+  2] := side[0].n
	;// [%sp+  4] := side[0].ny2
	;// [%sp+  6] := side[0].x	RENDVERTEX
	;// [%sp+  8] := side[0].y
	;// [%sp+ 10] := side[0].z
	;// [%sp+ 12] := side[0].s
	;// [%sp+ 14] := side[0].t
	;// [%sp+ 16] := side[0].nx2	DDA(x)
	;// [%sp+ 20] := side[0].ux
	;// [%sp+ 24] := side[0].vx
	;// [%sp+ 28] := side[0].dx
	;// [%sp+ 32] := side[0].nz2	DDA(z)
	;// [%sp+ 36] := side[0].uz
	;// [%sp+ 40] := side[0].vz
	;// [%sp+ 44] := side[0].dz
	;// [%sp+ 48] := side[0].ns2	DDA(s)
	;// [%sp+ 52] := side[0].us
	;// [%sp+ 56] := side[0].vs
	;// [%sp+ 60] := side[0].ds
	;// [%sp+ 64] := side[0].nt2	DDA(t)
	;// [%sp+ 68] := side[0].ut
	;// [%sp+ 72] := side[0].vt
	;// [%sp+ 76] := side[0].dt
	;// [%sp+ 80] := side[0].iv	SIDE(1)
	;// [%sp+ 82] := side[0].n
	;// [%sp+ 84] := side[0].ny2
	;// [%sp+ 86] := side[0].x	RENDVERTEX
	;// [%sp+ 88] := side[0].y
	;// [%sp+ 90] := side[0].z
	;// [%sp+ 92] := side[0].s
	;// [%sp+ 94] := side[0].t
	;// [%sp+ 96] := side[0].nx2	DDA(x)
	;// [%sp+100] := side[0].ux
	;// [%sp+104] := side[0].vx
	;// [%sp+108] := side[0].dx
	;// [%sp+112] := side[0].nz2	DDA(z)
	;// [%sp+116] := side[0].uz
	;// [%sp+120] := side[0].vz
	;// [%sp+124] := side[0].dz
	;// [%sp+128] := side[0].ns2	DDA(s)
	;// [%sp+132] := side[0].us
	;// [%sp+136] := side[0].vs
	;// [%sp+140] := side[0].ds
	;// [%sp+144] := side[0].nt2	DDA(t)
	;// [%sp+148] := side[0].ut
	;// [%sp+152] := side[0].vt
	;// [%sp+156] := side[0].dt
	;// [%sp+160] := param
	;// [%sp+164] := draw_scanline
	ld.w	%r0, %r12					; %r0       := vertices
	ld.w	%r1, %r13					; %r1       := n_vertices
	ld.w	[%sp+0x28],%r14	; 	xld.w	[%sp+0xa0], %r14					; [%sp+160] := param
	ld.w	[%sp+0x29],%r15	; 	xld.w	[%sp+0xa4], %r15					; [%sp+164] := draw_scanline
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r12 := vertices
	;// %r13 := n_vertices (>=3)

	;/* ㉺[̈ʒuƁA[̒_߂܂B */
	ld.w	%r2, -1						; %r2  :=          0xFFFFFFFF
	srl	%r2, 1						; %r2  := top    = 0x7FFFFFFF (=INT_MAX)
	not	%r3, %r2					; %r3  := bottom = 0x80000000 (=INT_MIN)
								; %r4  := itop
	ld.w	%r5, 0						; %r5  := i = 0
	add	%r12, 2						; %r12 := p = &vertices[0].y
								; %r13 := n = n_vertices
draw_primitive_TOP_BOTTOM:					; do {
	ld.uh	%r9, [%r12]					;   %r9  := y = p->y
	add	%r12, 10					;   %r12 := p++						*anti-interlock*
	cmp	%r9, %r2					;   if(y < top)
	jrge.d	4
	 cmp	%r9, %r3					;   <------------------+				*delay*
	 ld.w	%r2, %r9					;     %r2  := top  = y |
	 ld.w	%r4, %r5					;     %r4  := itop = i |
;//	cmp	%r9, %r3					;   if(y > bottom) ----+
	jrle.d	3
	 sub	%r13, 1						;   <--------------------+				*delay*
	 ld.w	%r3, %r9					;     %r3  := bottom = y |
;//	sub	%r13, 1						;   %r13 := n-- ---------+
	jrne.d	draw_primitive_TOP_BOTTOM			; } while(n)
	 add	%r5, 1						;   %r5  := i++						*delay*
	sub	%r3, %r2					; %r3  := lines = bottom - top
	jreq	draw_primitive_EXIT				; if(lines == 0) return
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;// %r4  := itop

	;/* E̕ӂ܂B */
	ld.w	[%sp+0x0],%r4	; 	xld.w	[%sp+ 0x0], %r4					; [%sp+ 0] := side[0].iv = itop, [%sp+ 2] := side[0].n = 0
	ld.w	[%sp+0x14],%r4	; 	xld.w	[%sp+0x50], %r4					; [%sp+80] := side[0].iv = itop, [%sp+82] := side[0].n = 0
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines

	;/* [AeXLCɂ... */
draw_primitive_SCANLINE:					; do {
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;/* ̕ӂɂ... */
	;/* ̕ӂɒB... */
	ld.uh	%r7,[%sp+0x1]	; 	xld.uh	%r7, [%sp+0x2]					;   %r7  := n = side[0].n
	sub	%r7, 1						;   if(--n <= 0) {					!INTERLOCK!
	jrgt	draw_primitive_SIDE0_SKIP
	ld.uh	%r4,[%sp+0x0]	; 	xld.uh	%r4, [%sp+0x0]					;     %r4  := iv = side[0].iv
draw_primitive_SIDE0_LOOP:					;     do {
	;/* ̕ӂ̗[̒_߂܂B */
	ld.w	%r9, 10						;       %r9  := sizeof(RENDVERTEX)
	mlt.h	%r4, %r9					;       %alr := iv * sizeof(RENDVERTEX)
	ld.w	%r5, %alr					;       %r5  := iv * sizeof(RENDVERTEX)
;//	add	%r5, %r0					;       %r5  := v0 = &vertices[iv] -+
	sub	%r4, 1						;       %r4  := iv--                |
	jrge.d	3						;       if(iv < 0)                  |
	 add	%r5, %r0					;       <---------------------------+			*delay*
	 add	%r4, %r1					;         %r4  := iv += n_vertices
	mlt.h	%r4, %r9					;       %alr := iv * sizeof(RENDVERTEX)
	ld.w	%r6, %alr					;       %r6  := iv * sizeof(RENDVERTEX)
	add	%r6, %r0					;       %r6  := v1 = &vertices[iv]
	;/* ̕ӂ̍̕ψʂ߂܂B */
	ext	0x2		; 	xld.uh	%r7, [%r6+0x2]					;       %r7  := v1->y
	ld.uh	%r7,[%r6]
	ext	0x2		; 	xld.uh	%r9, [%r5+0x2]					;       %r9  := v0->y
	ld.uh	%r9,[%r5]
	sub	%r7, %r9					;       %r7  := ny = v1->y - v0->y
	jrlt	draw_primitive_EXIT				;       if(ny < 0) return
	jreq	draw_primitive_SIDE0_LOOP			;     } while(ny == 0)
	;/* ̕ӂ܂ł̃JE^B */
	ld.h	[%sp+0x0],%r4	; 	xld.h	[%sp+0x0], %r4					;     [%sp+0] := side[0].iv = iv
	sla	%r7, 1						;     %r7  := ny * 2
	ld.h	[%sp+0x2],%r7	; 	xld.h	[%sp+0x4], %r7					;     [%sp+4] := side[0].ny2 = ny * 2
;//	sra	%r7, 1						;     %r7  := ny -------------+
	;/* DDAZbgAbvB */				;                             |
	ld.w	%r4, %sp					;     %r4  := side = &side[0] |
	;// %r0  := vertices					;                             |
	;// %r1  := n_vertices (>=3)				;                             |
	;// %r2  := y						;                             |
	;// %r3  := lines					;                             |
	;// %r4  := side					;                             |
	;// %r5  := v0						;                             |
	;// %r6  := v1						;                             |
	;// %r7  := ny						;                             |
	call.d	draw_primitive_SETUP				;                             |
	sra	%r7, 1						;     <-----------------------+				*delay*
draw_primitive_SIDE0_SKIP:					;   }
	ld.h	[%sp+0x1],%r7	; 	xld.h	[%sp+0x2], %r7					;   [%sp+2] := side[0].n = ny
	;/* E̕ӂɂ... */
	;/* ̕ӂɒB... */
	ld.uh	%r7,[%sp+0x29]	; 	xld.uh	%r7, [%sp+0x52]					;   %r7  := n = side[1].n
	sub	%r7, 1						;   if(--n <= 0) {					!INTERLOCK!
	jrgt	draw_primitive_SIDE1_SKIP
	ld.uh	%r4,[%sp+0x28]	; 	xld.uh	%r4, [%sp+0x50]					;     %r4  := iv = side[1].iv
draw_primitive_SIDE1_LOOP:					;     do {
	;/* ̕ӂ̗[̒_߂܂B */
	ld.w	%r9, 10						;       %r9  := sizeof(RENDVERTEX)
	mlt.h	%r4, %r9					;       %alr := iv * sizeof(RENDVERTEX)
	ld.w	%r5, %alr					;       %r5  := iv * sizeof(RENDVERTEX)
;//	add	%r5, %r0					;       %r5  := v0 = &vertices[iv] -+
	add	%r4, 1						;       %r4  := iv++                |
	cmp	%r4, %r1					;       if(iv >= n_vertices)        |
	jrlt.d	3						;                                   |
	 add	%r5, %r0					;       <---------------------------+			*delay*
	 sub	%r4, %r1					;         %r4  := iv -= n_vertices
	mlt.h	%r4, %r9					;       %alr := iv * sizeof(RENDVERTEX)
	ld.w	%r6, %alr					;       %r6  := iv * sizeof(RENDVERTEX)
	add	%r6, %r0					;       %r6  := v1 = &vertices[iv]
	;/* ̕ӂ̍̕ψʂ߂܂B */
	ext	0x2		; 	xld.uh	%r7, [%r6+0x2]					;       %r7  := v1->y
	ld.uh	%r7,[%r6]
	ext	0x2		; 	xld.uh	%r9, [%r5+0x2]					;       %r9  := v0->y
	ld.uh	%r9,[%r5]
	sub	%r7, %r9					;       %r7  := ny = v1->y - v0->y
	jrlt	draw_primitive_EXIT				;       if(ny < 0) return
	jreq	draw_primitive_SIDE1_LOOP			;     } while(ny == 0)
	;/* ̕ӂ܂ł̃JE^B */
	ld.h	[%sp+0x28],%r4	; 	xld.h	[%sp+0x50], %r4					;     [%sp+80] := side[1].iv = iv
	sla	%r7, 1						;     %r7  := ny * 2
	ld.h	[%sp+0x2a],%r7	; 	xld.h	[%sp+0x54], %r7					;     [%sp+84] := side[1].ny2 = ny * 2
;//	sra	%r7, 1						;     %r7  := ny -------------+
	;/* DDAZbgAbvB */				;                             |
	ld.w	%r4,%sp		; 	xadd	%r4, %sp, 80					;     %r4  := side = &side[1] |
	ext	0x1
	add	%r4,0x10
	;// %r0  := vertices					;                             |
	;// %r1  := n_vertices (>=3)				;                             |
	;// %r2  := y						;                             |
	;// %r3  := lines					;                             |
	;// %r4  := side					;                             |
	;// %r5  := v0						;                             |
	;// %r6  := v1						;                             |
	;// %r7  := ny						;                             |
	call.d	draw_primitive_SETUP				;                             |
	sra	%r7, 1						;     <-----------------------+				*delay*
draw_primitive_SIDE1_SKIP:					;   }
	ld.h	[%sp+0x29],%r7	; 	xld.h	[%sp+0x52], %r7					;   [%sp+82] := side[1].n = ny
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;/* E̕ӂ̊ԂɁA`܂B */
	ld.h	[%sp+0x4],%r2	; 	xld.h	[%sp+ 0x8], %r2					;   [%sp+ 8] := side[0].y = y
	ld.h	[%sp+0x2c],%r2	; 	xld.h	[%sp+0x58], %r2					;   [%sp+88] := side[1].y = y
	ld.w	%r12,%sp	; 	xadd	%r12, %sp,  6					;   %r12 := &side[0].x
	add	%r12,0x6
	ld.w	%r13,%sp	; 	xadd	%r13, %sp, 86					;   %r13 := &side[1].x
	ext	0x1
	add	%r13,0x16
;//	xld.w	%r14, [%sp+160]					;   %r14 := param --------+
	ld.w	%r9,[%sp+0x29]	; 	xld.w	%r9, [%sp+0xa4]					;   %r9  := draw_scanline |
	ld.w	%r14,[%sp+0x28]	; 	xld.w	%r14, [%sp+0xa0]					;   <---------------------+				*anti-interlock*
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;// %r12 := &side[0].x
	;// %r13 := &side[1].x
	;// %r14 := param
	call	%r9						;   draw_scanline(&side[0].x, &side[1].x, param)
	;/* ̕ӂɂ... */
	;/* DDAXebvsB */
	ld.w	%r4, %sp					;   %r4  := side = &side[0]
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;// %r4  := side
	call	draw_primitive_STEP
	;/* E̕ӂɂ... */
	;/* DDAXebvsB */
;//	xadd	%r4, %sp, 80					;   %r4  := side = &side[1] -+
	ld.w	%r4, %sp					;   <------------------------+
	add	%r4, 63						;   <------------------------+
	;// %r0  := vertices					;                            |
	;// %r1  := n_vertices (>=3)				;                            |
	;// %r2  := y						;                            |
	;// %r3  := lines					;                            |
	;// %r4  := side					;                            |
	call.d	draw_primitive_STEP				;                            |
	add	%r4, 17						;   <------------------------+				*delay*

	sub	%r3, 1						;   lines--
	jrne.d	draw_primitive_SCANLINE				; } while(lines)
	add	%r2, 1						;   %r2  := y++						*delay*
draw_primitive_EXIT:
	add	%sp,0x2a	; 	xadd	%sp, %sp, 168
	popn	%r3
	ret

	;/* DDAZbgAbvB */
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;// %r4  := side
	;// %r5  := v0
	;// %r6  := v1
	;// %r7  := ny
draw_primitive_SETUP:
	ext	0x6		; 	xadd	%r10, %r4, 6					; %r10 := &side->x
	add	%r10,%r4
	ext	0x10		; 	xadd	%r11, %r4, 16					; %r11 := &side->nx2
	add	%r11,%r4
	not	%r15, %r7					; %r15 := d = -ny
;//	add	%r15, 1						; --+
	call.d	draw_primitive_SETUP_ONE			; x |
	add	%r15, 1						; <-+							*delay*
	add	%r5, 2						; y (v0->y skip)
	add	%r6, 2						;   (v1->y skip)
;//	add	%r10, 2						;   (side->y skip) -+
	call.d	draw_primitive_SETUP_ONE			; z                 |
	add	%r10, 2						; <-----------------+					*delay*
	call	draw_primitive_SETUP_ONE			; s
	;/* FALLTHRU */						; t
draw_primitive_SETUP_ONE:
	ld.uh	%r12, [%r5]+					; %r12 := v0->i
	ld.uh	%r13, [%r6]+					; %r13 := v1->i
	ld.h	[%r10]+, %r12					; side->i = v0->i
	sub	%r13, %r12					; %r13 := n = v1->i - v0->i
	jrge.d	5						; if(n < 0)
	 ld.w	%r14, 1						; %r14 := v = 1						*delay*
	 not	%r13, %r13					;   %r13 := n = v0->i - v1->i
	 add	%r13, 1
	 ld.w	%r14, -1					;   %r14 := v = -1
	sla	%r13,0x8	; 	xsla	%r13, 16
	sla	%r13,0x8
	ld.w	%alr, %r13
	div0u	%r7
	div1	%r7						;//  1
	div1	%r7						;//  2
	div1	%r7						;//  3
	div1	%r7						;//  4
	div1	%r7						;//  5
	div1	%r7						;//  6
	div1	%r7						;//  7
	div1	%r7						;//  8
	div1	%r7						;//  9
	div1	%r7						;// 10
	div1	%r7						;// 11
	div1	%r7						;// 12
	div1	%r7						;// 13
	div1	%r7						;// 14
	div1	%r7						;// 15
	div1	%r7						;// 16
	ld.w	%r12, %ahr					; %r12 := n = (n % ny)
	add	%r12, %r12					; %r12 := n * 2
	ld.w	%r13, %alr					; %r13 := u = (n / ny) * v
	mlt.h	%r13, %r14
	ld.w	%r13, %alr
	ld.w	[%r11]+, %r12					; side->ni2 = n * 2
	ld.w	[%r11]+, %r13					; side->ui = u
	ld.w	[%r11]+, %r14					; side->vi = v
	ld.w	[%r11]+, %r15					; side->di = d
	ret

	;/* DDAXebvsB */
	;// %r0  := vertices
	;// %r1  := n_vertices (>=3)
	;// %r2  := y
	;// %r3  := lines
	;// %r4  := side
draw_primitive_STEP:
	ext	0x4		; 	xld.uh	%r5, [%r4+0x4]					; %r5  := ny * 2 = side->ny2
	ld.uh	%r5,[%r4]
	ext	0x6		; 	xadd	%r6, %r4, 6					; %r6  := &side->x
	add	%r6,%r4
;//	xadd	%r7, %r4, 16					; %r7  := &side->nx2 -+
	ld.w	%r7, %r4					; <-------------------+
	call.d	draw_primitive_STEP_ONE				; x                   |
	add	%r7, 16						; <-------------------+					*delay*
;//	add	%r6, 2						; y (side->y skip) -+
	call.d	draw_primitive_STEP_ONE				; z                 |
	add	%r6, 2						; <-----------------+					*delay*
	call	draw_primitive_STEP_ONE				; s
	;/* FALLTHRU */						; t
draw_primitive_STEP_ONE:
;//	ld.uh	%r10, [%r6]					; %r10 := i = side->i ------+
	ld.w	%r11, [%r7]+					; %r11 := n * 2 = side->ni2 |
	ld.w	%r12, [%r7]+					; %r12 := u = side->ui      |
	ld.w	%r13, [%r7]+					; %r13 := v = side->vi      |
	ld.w	%r14, [%r7]					; %r14 := d = side->di      |
	ld.uh	%r10, [%r6]					; <-------------------------+				*anti-interlock*
	add	%r14, %r11					; %r14 := d += n * 2
	jrlt.d	4						; if(d >= 0)
	 add	%r10, %r12					; %r10 := i += u					*delay*
	 add	%r10, %r13					;   %r10 := i += v
	 sub	%r14, %r5					;   %r14 := d -= ny * 2
	ld.h	[%r6]+, %r10					; side->i  = i
	ld.w	[%r7]+, %r14					; side->di = d
	ret


	.code
	.align	1
	.global	draw_scanline_SETUP
draw_scanline_SETUP:
	ld.uh	%r9, [%r12]+			; %r9  :=             v0->i
	ld.uh	%r10, [%r13]+			; %r10 :=     v1->i
	sub	%r10, %r9			; %r10 := n = v1->i - v0->i
	jrge.d	5				; if(n < 0)
	 ld.w	%r11, 1				; %r11 := v = 1					*delay*
	 not	%r10, %r10			;   %r10 := n = -n
	 add	%r10, 1
	 ld.w	%r11, -1			;   %r11 := v = -1
	sla	%r10,0x8	; 	xsla	%r10, 16
	sla	%r10,0x8
	ld.w	%alr, %r10
	div0u	%r7
	div1	%r7				;  1
	div1	%r7				;  2
	div1	%r7				;  3
	div1	%r7				;  4
	div1	%r7				;  5
	div1	%r7				;  6
	div1	%r7				;  7
	div1	%r7				;  8
	div1	%r7				;  9
	div1	%r7				; 10
	div1	%r7				; 11
	div1	%r7				; 12
	div1	%r7				; 13
	div1	%r7				; 14
	div1	%r7				; 15
	div1	%r7				; 16
	ld.w	%r10, %ahr			; %r10 := n
	ld.w	%r15, %alr			; %r15 := u
	mlt.h	%r15, %r11
	ld.w	%r15, %alr
	ret.d
	add	%r10, %r10			; %r10  := n * 2				*delay*

