/*	
 *	clipudp.c
 *
 *	UDPvgRhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Sep 07 03:55:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Sep 20 19:51:00 JST 2005 Naoyuki Sawa
 *	- udp_open()local_port=0Ȃ΁AGtF|[g蓖Ă悤ύX܂B
 *	* Fri Sep 23 02:34:00 JST 2005 Naoyuki Sawa
 *	- udp_socket_open()̎ML[eʂAȂƂ1480oCgȏɐ؂グ悤ύX܂B
 */
#include "clip.h"

/****************************************************************************
 *	UDPvgRhCo
 ****************************************************************************/

typedef struct _UDPDRIVER {
	IPCLIENT ip_client;		/* IPNCAgo^p */
	LIST_ENTRY client_list;		/* NCAgXg */
} UDPDRIVER;
static UDPDRIVER udp_driver;

static void udp_recv(IPCLIENT* ip_client, int source_ip_address, int destination_ip_address, const unsigned char* data/*[length]*/, int length);
static UDPCLIENT* udp_find_client(int local_port);

/*--------------------------------------------------------------------------*/

/* NCAgXgAw肵[J|[gɑΉNCAgT܂B
 * w肵[J|[gɑΉNCAgA|C^Ԃ܂B
 * w肵[J|[gɑΉNCAgȂ΁ANULLԂ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static UDPCLIENT*
udp_find_client(int local_port)
{
	LIST_ENTRY* list_head = &udp_driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;		/* 擪̗vf(orI[) */
	UDPCLIENT* client;

	while(list_entry != list_head) {
		if(!list_entry) {
			DIE(); /* A܂́ANCAgXgj */
		}
		client = CONTAINING_RECORD(list_entry, UDPCLIENT, list_entry);
		if(client->local_port == local_port) {
			return client;
		}
		list_entry = list_entry->Flink;
	}

	return NULL;
}

/* gp̃GtF|[gT܂B
 * ------------------------------------------------------------------------------------------------------------------------------------------------------------
 * ITpꎫT e-Words F GtF|[gƂ yephemeral portsz - ӖE
 * ̗pr(vgRł̎gpĂ炸AꎞIȒʐM̂߂ɎRɗpł|[gB_Ci~bN|[gƂBuephemeralv́uZȁv̈ӁB
 * ɑ΂āAHTTP80Ԃ̂悤ɁÃvgRp邱ƂLĂ|[g̓EFmE|[g(well-known port)ƌĂ΂B
 * GtF|[g͎ɃNCAgŗpBNCAgT[oɃNGXg𑗏oہA
 * T[õ|[g͖ړĨT[rXғĂ|[g(̏ꍇAEFmE|[g)łKv邪ANCAg͂ǂȃ|[ggĂ܂ȂB
 * ̂ƂANCAgłOS󂢂ĂGtF|[g̒KȂ̂IŊ蓖ĂBʐMIƂ̃|[g͉B
 * GtF|[ǵA{Iɂ1024Ԉȍ~p邪AOSɂقȂB
 * WindowsnߑOSł1024Ԃ5000ԂGtF|[gƂĊ蓖ĂĂ邪AႦ΁AFreeBSD 5.0ł49152Ԃ65535Ԃ蓖ĂĂB
 * ------------------------------------------------------------------------------------------------------------------------------------------------------------
 * {hCóAFreeBSDɕ킢A49152Ԃ65535($C000`$FFFF)GtF|[gƂĊ蓖Ă邱Ƃɂ܂B
 */
/* 荞݋֎~ԂŌĂяoĂ!! */
static int
udp_allocate_ephemeral_port()
{
	LIST_ENTRY* list_head = &udp_driver.client_list;	/* Xg̃[gvf */
	LIST_ENTRY* list_entry = list_head->Flink;		/* 擪̗vf(orI[) */
	UDPCLIENT* client;
	int ephemeral_port;

	for(ephemeral_port = 0xc000; ephemeral_port <= 0xffff; ephemeral_port++) {
		while(list_entry != list_head) {
			if(!list_entry) {
				DIE(); /* A܂́ANCAgXgj */
			}
			client = CONTAINING_RECORD(list_entry, UDPCLIENT, list_entry);
			if(client->local_port == ephemeral_port) {
				break; /* gpς */
			}
			list_entry = list_entry->Flink;
		}
		if(list_entry == list_head) {
			break; /* gp|[g */
		}
	}

	if(ephemeral_port > 0xffff) {
		DIE(); /* gp|[g */
	}

	return ephemeral_port;
}

void
udp_start(int txque_capacity)
{
	/* ܂Amɒ~܂B */
	udp_stop();

	/* hCo\̂NA܂B */
	memset(&udp_driver, 0, sizeof udp_driver);

	/* NCAgXg܂B */
	InitializeListHead(&udp_driver.client_list);

	/* UDPvgRhCoJn܂B */
	udp_driver.ip_client.protocol = 17/*UDP*/;
	udp_driver.ip_client.recv = udp_recv;
	ip_open(&udp_driver.ip_client);
}

void
udp_stop()
{
	/* JnĂȂ΁A܂B */
	if(!udp_driver.client_list.Flink) {
		return;
	}

	/* UDPvgRhCo~܂B */
	ip_close(&udp_driver.ip_client);

	/* hCo\̂NA܂B */
	memset(&udp_driver, 0, sizeof udp_driver);
}

void
udp_open(UDPCLIENT* client)
{
ENTER_CS;


	/* [J|[gw肳ĂȂ΁AGtF|[gmۂ܂B */
	if(!client->local_port) {
		client->local_port = udp_allocate_ephemeral_port(); /* $C000-$FFFF */

	/* [J|[gw肳ĂAsAo^ς݂łȂAmF܂B */
	} else {
		if(client->local_port & ~0xffff) {
			DIE(); /* sȃ|[g */
		}
		if(udp_find_client(client->local_port)) {
			DIE(); /* |[go^ς */
		}
	}

	/* NCAgXgɒǉ܂B */
	InsertTailList(&udp_driver.client_list, &client->list_entry);

LEAVE_CS;
}

void
udp_close(UDPCLIENT* client)
{
ENTER_CS;

	if(udp_find_client(client->local_port) != client) {
		DIE(); /* o^̃NCAg */
	}

	/* NCAgXg菜܂B */
	RemoveEntryList(&client->list_entry);

LEAVE_CS;
}

int
udp_send(UDPCLIENT* client, int remote_ip_address, int remote_port, const void* data/*[length]*/, int length)
{
	int retval;
	//
	int tmpbuf_length;
	unsigned char* tmpbuf = NULL; /* v */
	//
	IPCONFIG ip_config;
	ip_get_config(&ip_config);

	if(length < 0) {
		DIE(); /* p[^s */
	}

	/* UDPf[^O\zpobt@mۂ܂B */
	tmpbuf_length = 8/*UDPwb_*/ + length/*f[^*/;
	tmpbuf = malloc(tmpbuf_length);
	if(!tmpbuf) {
		DIE(); /* s */
	}

	/* UDPwb_\z܂B
	 * - UDṔAM|[gw(0)ł\܂B
	 *   {֐́Aclient=NULLŌĂяoꂽꍇɁAM|[g𖳎w(0)Ƃ܂B
	 */
	PUT_BEHALF(tmpbuf + 0, client ? client->local_port : 0);/* + 0,2: M|[g */
	PUT_BEHALF(tmpbuf + 2, remote_port);			/* + 2,2: Đ|[g */
	PUT_BEHALF(tmpbuf + 4, tmpbuf_length);			/* + 4,2: pPbg */
	//PUT_BEHALF(tmpbuf + 6, 0);				/* + 6,2: `FbNT  ŋ߂܂ */

	/* f[^Rs[܂B */
	memcpy(tmpbuf + 8, data, length);

	/* `FbNT߂܂B */
	update_internet_checksum_pseudo_header(
		ip_config.ip_address,	/* MIPAhX */
		remote_ip_address,	/* ĐIPAhX */
		17/*UDP*/,		/* vgR */
		tmpbuf,			/* pPbg */
		tmpbuf_length,		/* pPbg */
		6);			/* `FbNTʒu */

	/* UDP`FbNŤvZʂ0x0000Ȃ΁A0xffffɒu܂B
	 * - UDPł́A`FbNT̓IvVłA0x0000̓`FbNTӖ܂B
	 *   `FbNTł\Ȃ̂łA׋̂߁AƌvZ邱Ƃɂ܂B
	 */
	if(!BEHALF(tmpbuf + 6)) {
		PUT_BEHALF(tmpbuf + 6, 0xffff);
	}

	/* UDPf[^O𑗐M܂B */
	retval = ip_send(&udp_driver.ip_client, remote_ip_address, tmpbuf, tmpbuf_length);
	if(retval < 0) {
		length = -1; /* Ms */
		goto L_EXIT;
	}

L_EXIT:

	/* UDPf[^O\zpobt@܂B */
	free(tmpbuf);

	/* Ȃ΁Af[^̂܂ܕԂ܂B */
	return length;
}

static void
udp_recv(IPCLIENT* ip_client, int source_ip_address, int destination_ip_address, const unsigned char* data/*[length]*/, int length)
{
	UDPCLIENT* client;

	if(length < 8) {
		return; /* MpPbgAUDPwb_ */
	}

	/* UDPwb_ɋLqĂApPbg擾܂B */
	if(length < BEHALF(data + 4)) {			/* + 4,2: pPbg */
		return; /* MpPbgAUDPwb_ɋLqĂpPbg */
	}
	length = BEHALF(data + 4);			/* + 4,2: pPbg */

	/* `FbNT(0x0000)łȂ΁A`FbNT܂B
	 * - `FbNT0xffffȂ΁A{̃`FbNT0x0000ŁAM0xffffɒuƂӖ܂B
	 *   ŁA0xffff->0x0000ɖ߂Kv͂܂B(߂Ă\܂񂪁Aʂȏł)
	 *   1̕␔aɂāA0lɑ΂0x0000̉Z0xffff̉ŹAʂɂȂ邩łB
	 *   <> 0x1234 + 0x0000 =  0x1234
	 *        0x1234 + 0xffff = 0x11233 -> L[AEgŉʃrbgɉZ -> 0x1234
	 *   0ɑ΂Z̏ꍇ̂݁A0x0000̉Z0xffff̉Z͈قȂ錋ʂƂȂ܂A
	 *   UDP`FbNŤvŹA[wb_UDPwb_܂߂ČvZ邽߁A
	 *   `FbNTtB[hȊO1̕␔aA0ƂȂ邱Ƃ͗L蓾܂B
	 *   (1̕␔a0ƂȂ̂́AΏۃf[^ł邩A܂ׂ͂0̏ꍇł)
	 *   ]āA`FbNT0xffff̏ꍇA{̃`FbNT0x0000ɖ߂Â܂܌vZ邱Ƃ\łB
	 */
	if(BEHALF(data + 6)) {				/* + 6,2: `FbNT */
		if(internet_checksum_pseudo_header(
			source_ip_address,		/*        MIPAhX */
			destination_ip_address,		/*        ĐIPAhX */
			17/*UDP*/,			/*        vgR */
			data,				/*        pPbg */
			length)) {			/*        pPbg */
			return; /* `FbNTs */
		}
	}

	/* Đ|[gɑΉNCAg֑܂B */
	client = udp_find_client(BEHALF(data + 2));	/* + 2,2: Đ|[g */
	if(client) {
		if(client->recv) {
			client->recv(client,
				source_ip_address,	/*        MIPAhX */
				BEHALF(data + 0),	/* + 0,2: M|[g */
				data + 8,		/*        f[^ */
				length - 8);		/*        f[^ */
		}
	}
}

/****************************************************************************
 *	UDP\Pbg
 ****************************************************************************/

static void
internal_udp_socket_recv(UDPCLIENT* udp_client, int remote_ip_address, int remote_port, const unsigned char* data/*[length]*/, int length)
{
	UDPSOCKET* udp_socket = CONTAINING_RECORD(udp_client, UDPSOCKET, udp_client);
	//
	int tmpbuf_length;
	unsigned char* tmpbuf = NULL; /* v */

	/* ꎞobt@mۂ܂B */
	tmpbuf_length = 8/*MIPAhX+M|[g*/ + length/*f[^*/;
	tmpbuf = malloc(tmpbuf_length);
	if(!tmpbuf) {
		DIE();
	}

	/* MIPAhXAM|[gAf[^ML[Ɋi[܂B */
	PUT_LEWORD(tmpbuf + 0, remote_ip_address);	/* +0,4: MIPAhX */
	PUT_LEWORD(tmpbuf + 4, remote_port);		/* +4,4: M|[g */
	    memcpy(tmpbuf + 8, data, length);		/* +8,?: f[^ */
	write_queue(udp_socket->rxque, tmpbuf, tmpbuf_length); /* s͖ */

	/* ꎞobt@܂B */
	free(tmpbuf);
}

UDPSOCKET*
udp_socket_open(int local_port, int rxque_capacity)
{
	UDPSOCKET* udp_socket;

	/* ML[eʂAȂƂ1480oCgȏƂ܂B */
	if(rxque_capacity < 1480) {
		rxque_capacity = 1480;
	}

	/* UDP\Pbg\̂̃mۂ܂B */
	udp_socket = malloc(sizeof(UDPSOCKET));
	if(!udp_socket) {
		DIE(); /* s */
	}
	memset(udp_socket, 0, sizeof(UDPSOCKET));

	/* ML[쐬܂B */
	udp_socket->rxque = create_queue(rxque_capacity);

	/* UDPNCAgo^܂B */
	udp_socket->udp_client.local_port = local_port;
	udp_socket->udp_client.recv = internal_udp_socket_recv;
	udp_open(&udp_socket->udp_client);

	return udp_socket;
}

void
udp_socket_close(UDPSOCKET* udp_socket)
{
	/* UDPNCAgo^܂B */
	udp_close(&udp_socket->udp_client);

	/* ML[폜܂B */
	delete_queue(udp_socket->rxque);

	/* UDP\Pbg\̂̃܂B */
	free(udp_socket);
}

int
udp_socket_recv(UDPSOCKET* udp_socket, int* remote_ip_address, int* remote_port, void* data/*[length]*/, int length)
{
	int tmpbuf_length;
	unsigned char* tmpbuf = NULL; /* v */

	/* ꎞobt@mۂ܂B */
	tmpbuf_length = 8/*MIPAhX+M|[g*/ + length/*obt@*/;
	tmpbuf = malloc(tmpbuf_length);
	if(!tmpbuf) {
		DIE();
	}

	/* ML[AMIPAhXAM|[gAf[^o܂B */
	length = read_queue(udp_socket->rxque, tmpbuf, tmpbuf_length);
	if(length < 0) {
		goto L_EXIT; /* f[^A܂́Aobt@s  (߂l=) */
	}
	if(length < 4/*remote_ip_address*/ + 4/*remote_port*/) {
		DIE(); /* ML[j */
	}

	/* MIPAhXAM|[gAf[^i[܂B */
	if(remote_ip_address) {
		*remote_ip_address = LEWORD(tmpbuf + 0);/* +0,4: MIPAhX */
	}
	if(remote_port) {
		*remote_port = LEWORD(tmpbuf + 4);	/* +4,4: M|[g */
	}
	length -= 8/*remote_ip_address+remote_port*/;
	memcpy(data, tmpbuf + 8, length);		/* +8,?: f[^ */

L_EXIT:

	/* ꎞobt@܂B */
	free(tmpbuf);

	return length;
}

int
udp_socket_send(UDPSOCKET* udp_socket, int remote_ip_address, int remote_port, const void* data/*[length]*/, int length)
{
	return udp_send(udp_socket ? &udp_socket->udp_client : NULL, remote_ip_address, remote_port, data, length);
}
