/*
 *	cliptaps.c
 *
 *	TAPV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Sun Sep 13 20:50:05 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Mon Nov 16 21:09:12 JST 2015 Naoyuki Sawa
 *	- ST_TapSeqInfo.nEvt,iEvtMskAyсATapSeq_EvtGet(),TapSeq_EvtOvr()ǉ܂B
 *	  荞ݓŔ\̗LeCxgA荞݊OŎ擾ď邽߂̎dg݂łB
 *	  Oobt@̎́Acliprinb.cW[ɏĂ܂B
 *	* Mon Jan 11 21:31:05 JST 2016 Naoyuki Sawa
 *	- St[Y̎R~̃oOC܂B
 *	  ʏt[YƓlɎR~ׂƂAԃt[YƓlɎ̃t[YĐĂ܂B
 *	  TapLogCh_Exec()̏(-2)ԈĎ̃t[YԍƌȂĂ܂ĂoOłB
 *	* Tue Feb 16 21:10:19 JST 2016 Naoyuki Sawa
 *	- TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
 *	  ύXÓA_`lԍ傫قǗDxႭAfoCX`l肳ՂƂĂ܂B
 *	  ύX́A_`lԍقǗDxႭAfoCX`l肳Ղ悤ɂ܂B
 *	  ύXŔAvO̍쐬rŘ_`l̐݌vύXɁAォǉ_`l(=_`lԍ傫)قǁAʏ̉o肵čĐ(=Dx)P[XłB
 *	- TapSeq_AcqLogCh()ɂāA~̃foCX`lAcTAPZbg𑖍ɁAAfoCX`l̊lֈڍs悤ɕύX܂B
 *	  ܂ł́A~̃foCX`lĂAcTAPZbg̑pĂAʂłB
 *	* Tue Aug 02 21:11:08 JST 2016 Naoyuki Sawa
 *	- RJڒʒmǉ܂B
 *	  ܂ł́Aŏ̃t[YĐJn鎞Ãt[Yֈڍs鎞AʂŁAĐJnʒm(fnPlay)ĂяoĂ܂B
 *	  ́Aŏ̃t[YĐJn鎞͍ĐJnʒm(fnPlay)Ãt[Yֈڍs鎞͎RJڒʒm(fnNext)Ăяo悤ɂ܂B
 *	- ύXŔAfoCXV[XAĐ@\Ăꍇ(ADX2)ɁÃt[Yֈڍs鎞͖IȍĐJnsȂ悤ɂ鎖o悤ɁAAvP[V҂ʏo悤ɂ邽߂łB
 *	  foCX̃V[XAĐ@\𗘗pꍇ́AAvP[V`(*fnNext)()֐ł́AsȂ悤ɂĉB
 *	  ܂AfoCXɐݒ肷V[XAĐ̃vCobNXgƁAW[ŊǗt[Y`FCAō쐬ĉB
 *	  foCXۂɍĐĂt[YƁAW[FĂ'ݍĐ̃t[Y'v邽߂łB
 *	- foCXV[XAĐ@\ĂȂꍇ(P/ECEDxLib)́A܂ŒʂARJڎɂIȍĐsĉB
 *	  ̓Iɂ́AAvP[V`(*fnNext)()֐ɂ(*fnPlay)()ƓsÁA֐|C^ݒ肵ĉB
 *	* Fri Aug 19 21:29:24 JST 2016 Naoyuki Sawa
 *	- ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂B
 *	  tB[h̐錾p~ŁACAEg͕ςĂ܂B
 *	- L̃tB[hp~ŔAvf[0]̃tB[hɑΉĂȂRpCƁAR[hʉ邽߂łB
 *	  IɃAhX߂鏈قǕGȖł̂ŁA#ifdefŏRpCR[hʉՂƎv܂B
 *	* Thu Oct 13 21:52:21 JST 2016 Naoyuki Sawa
 *	- fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
 *	  Hł͂Ǝv܂ATAPV[PT̕CX^X쐬AR[obN֐LꍇɁAǂ̃CX^XĂяoꂽ𔻒f邽߂łB
 *	  gṕAclipxmp1.cW[QƂĉB
 *	* Thu Feb 09 23:42:37 JST 2017 Naoyuki Sawa
 *	- ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂B
 *	  ɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
 *	- pTBL_BaseChtB[hǉŔAȉ̒ʂłB
 *	  ܂ł́AV[PXf[^̒Ř_`lԍ𒼐ڎw肵Ă߁AV[PXf[^_`l\ƓƗč쐬鎖肪L܂B
 *	  V[PX`lƘ_`ľѕt߂āAAvP[VvOV[PX`lԍwoƂ͌AV[PXf[^gpĂ_`lԍɂāAV[PX`lŒƂȂĂ܂Ă܂B
 *	  ܂A_`l̍\ςƁAV[PXf[^̘_`lԍSďCȂ΂ȂƂ肪L܂B
 *	- ApTBL_BaseChtB[hǉɔAV[PXf[^ۂɍĐV[PX`lɂāAV[PXf[^Ŏw肳ꂽ_`lԍɑ΂āAItZbg|悤ɂ܂B
 *	  Ⴆ΁AV[PXf[^ł͑S'_`lԍ0x[X'ō쐬ĂAeV[PX`lۂɂǂ͈̘̔͂_`lgp邩́ApTBL_BaseChtB[hx[X_`lԍe[uɂĎw肷鎖o悤ɂȂ܂B
 *	  ɂāAV[PXf[^ՂȂA܂AV[PXf[^gł̏_P܂B
 *	- tɂƁÃAvP[V́A'SĂ̗vf0̃x[X_`lԍe[u'gē삵ĂƌȂo܂B
 *	  ̃AvP[VȂԂňڍsɂ́A'SĂ̗vf0̃x[X_`lԍe[u'ApTBL_BaseChtB[hɎw肵ĉB
 *	  ܂A܂ŒʂV[PXf[^̒Ř_`lԍ𒼐ڎw肵ꍇA'SĂ̗vf0̃x[X_`lԍe[u'ApTBL_BaseChtB[hɎw肵ĉB
 *	* Sat Feb 11 21:09:58 JST 2017 Naoyuki Sawa
 *	- [vǉ܂B
 *	  ڍׂ́A'/clip/tool/dTapSeqC/winapp.h'̓̃RgQƂĉB
 *	* Mon Feb 13 22:57:25 JST 2017 Naoyuki Sawa
 *	- 'play.w'߂ǉ܂B
 *	  ڍׂ́A'/clip/tool/dTapSeqC/winapp.h'̓̃RgQƂĉB
 */
#include "clip.h"
//#define PRODUCT_SPECIFIC_WORKAROUND//̃V{`ƁAiŗL̒sB
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
static void TapSeqInfo_Verify(const ST_TapSeqInfo* pInfo);
static void TapSeq_fnPlay(ST_TapSeq* pTapSeq, int iLogCh);
static void TapSeq_fnStop(ST_TapSeq* pTapSeq, int iLogCh);
static void TapSeq_fnLoop(ST_TapSeq* pTapSeq, int iLogCh);
static void TapSeq_fnEnd(ST_TapSeq* pTapSeq, int iLogCh);
static void TapSeq_fnCtrl(ST_TapSeq* pTapSeq, int iLogCh);
static int TapSeq_fnGetPhrTime(ST_TapSeq* pTapSeq, int iPhr);
static int TapSeq_fnGetPhrNext(ST_TapSeq* pTapSeq, int iPhr);
static int TapSeq_GetPhrType(ST_TapSeq* pTapSeq, int iPhr);
static void TapSeq_AcqLogCh(ST_TapSeq* pTapSeq, int iLogCh);
static void TapLogCh_PlaySubr(ST_TapSeq* pTapSeq, int iLogCh, int iPhr);
static void TapLogCh_LoopSubr(ST_TapSeq* pTapSeq, int iLogCh);
static void TapLogCh_StopSubr(ST_TapSeq* pTapSeq, int iLogCh);
static void TapLogCh_Exec(ST_TapSeq* pTapSeq, int iLogCh, int iElapTime);
static void TapSeqCh_Exec(ST_TapSeq* pTapSeq, int iSeqCh, int iElapTime);
static ST_TapEvtBuf* TapSeq_GetEvtBuf(ST_TapSeq* pTapSeq);
static void TapSeq_AddEvt(ST_TapSeq* pTapSeq, int iEvt, int iLogCh, int iPhr);
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//V[PT𓮓Iɍ쐬B
ST_TapSeq* TapSeq_New(const ST_TapSeqInfo* pInfo) {
	ST_TapSeq* pTapSeq;
	int nBytes;
	//B
	TapSeqInfo_Verify(pInfo);
	//mۂB
	nBytes = sizeof(ST_TapSeq) +					//V[PT
		(sizeof(ST_TapDevCh) * ((pInfo->nDevCh+3)&~3)) +	//foCX`l
		(sizeof(ST_TapLogCh) *   pInfo->nLogCh       ) +	//_`l
		(sizeof(ST_TapSeqCh) *   pInfo->nSeqCh       );		//V[PT`l
	if(pInfo->nEvt) {
		nBytes += sizeof(ST_TapEvtBuf) +			//Cxgobt@
			 (sizeof(ST_TapEvt) * (pInfo->nEvt + 1));	//Cxg
	}
	pTapSeq = malloc(nBytes);
	if(!pTapSeq) { DIE(); }
	//V[PTÓIɏB
	TapSeq_Init(pTapSeq, pInfo);
	return pTapSeq;
}
/*---------------------------------------------------------------------------*/
//V[PTÓIɏB
void TapSeq_Init(ST_TapSeq* pTapSeq, const ST_TapSeqInfo* pInfo) {
	int iDevCh, iLogCh, iSeqCh;
	//B
	TapSeqInfo_Verify(pInfo);
	//i[B
	pTapSeq->pInfo = pInfo;
	//foCX`lNAB
	for(iDevCh = 0; iDevCh < pTapSeq->pInfo->nDevCh; iDevCh++) {
		ST_TapDevCh* pDevCh = TapSeq_GetDevCh(pTapSeq, iDevCh);
		pDevCh->iLogCh = -1;	//̃foCX`l𐧌䂵Ă_`lԍ	UINT8_MAX=(~Ӗ)
	}
	//_`lNAB
	for(iLogCh = 0; iLogCh < pTapSeq->pInfo->nLogCh; iLogCh++) {
		ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
		pLogCh->iPhr   = -1;	//t[Yԍ						UINT16_MAX=(~Ӗ)
		pLogCh->iDevCh = -1;	//̘_`l䂵ĂfoCX`lԍ	UINT8_MAX=(~,,ĐJnɃfoCX`lloȂ,,ĐJnɃfoCX`l肳ꂽӖ)
		pLogCh->iSeqCh = -1;	//̘_`l𐧌䂵ĂV[PT`lԍ	UINT8_MAX=(V[PT`lɐ䂳ĂȂӖB~Ӗ̂ł͂Ȃɒӂ)
	}
	//V[PT`lNAB
	for(iSeqCh = 0; iSeqCh < pTapSeq->pInfo->nSeqCh; iSeqCh++) {
		ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
		pSeqCh->pData  = NULL;	//V[PXf[^					NULL=(~Ӗ)
	}
	//Cxgobt@NAB
	if(pInfo->nEvt) {
		ST_TapEvtBuf* pEvtBuf = TapSeq_GetEvtBuf(pTapSeq);
		pEvtBuf->iAddPos = 0;	//vfވʒu
		pEvtBuf->iGetPos = 0;	//vfǂݏoʒu
		pEvtBuf->nOvrCnt = 0;	//I[o[
	}
}
/*---------------------------------------------------------------------------*/
//Iɍ쐬V[PTJB
void TapSeq_Free(ST_TapSeq* pTapSeq) {
	free(pTapSeq);
}
/*---------------------------------------------------------------------------*/
//V[PTsB
// - ʂ͊荞ݏĂяoƎvAAvP[VCӂ̃ReLXgŌĂяo\L̂ŁAr䂪KvłB
void TapSeq_Exec(ST_TapSeq* pTapSeq, int iElapTime) {
	int iLogCh, iSeqCh;
	if(iElapTime <    0) { iElapTime =    0; }	//oߎԂ0bȂ΁A0bɕ␳B
	if(iElapTime > 1000) { iElapTime = 1000; }	//oߎԂ1b߂Ȃ΁A1bɕ␳B
ENTER_CS;
	//_`lsB
	for(iLogCh = 0; iLogCh < pTapSeq->pInfo->nLogCh; iLogCh++) {
		TapLogCh_Exec(pTapSeq, iLogCh, iElapTime);
	}
	//̏K{łBtɂƃV[PTĐJn̘_`l̑҂Ԃ炵Ă܂ꂪL܂B
	//V[PT`lsB
	for(iSeqCh = 0; iSeqCh < pTapSeq->pInfo->nSeqCh; iSeqCh++) {
		TapSeqCh_Exec(pTapSeq, iSeqCh, iElapTime);
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//_`lĐJnB
// - TapSeqCh_Exec()Ăяoꂽꍇ͔r䂪svłAAvP[VڌĂяo\L̂ŁAr䂪KvłB
void TapLogCh_Play(ST_TapSeq* pTapSeq, int iLogCh, int iPhr, int iLoop, int iAtt, int iPan) {
	int iPhrType;
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
ENTER_CS;
	//̘_`l𐧌䂵ĂV[PT`lԍAmɃNAB
	// - AvP[V璼ڌĂяoꂽꍇ́A(pLogCh->iSeqCh=-1)̂܂܂ƂȂB
	// - V[PTĂяoꂽꍇ́Å֐ԂɁAV[PT̒pLogCh->iSeqChݒ肷B
	pLogCh->iSeqCh = -1;
	//[vt[YpԂAmɃNAB
	// - ݂̍ĐpꍇA擪ĐJnꍇAǂɂKvȏȂ̂ŁAōŝǂB
	pLogCh->iCont  = 0;
	//ĐJnt[Ỹt[Y`FC̍Ō̃t[ÝAt[Yʂ擾B
	iPhrType = TapSeq_GetPhrType(pTapSeq, iPhr);
	//ĐJnt[Ỹt[Y`FC̍Ō̃t[YA[vt[YȂ΁c
	// - ʏt[Y(-1),,St[Y(-2)Ȃ΁AL̔fs킸AɁA݂̍Đ~擪ĐJnB
	if(iPhrType >= 0) {
		//_`lĐȂ΁c
		if(pLogCh->iPhr != UINT16_MAX) {
			//Đ̃t[Y̍Ō̃t[Y[vt[Ył,,ĐJnt[YƓt[Y`FCȂ΁AĐJns킸Ɍ݂̍ĐpB
			//Đ̃t[Y̍Ō̃t[Y[vt[YȊO,,ĐJnt[Yƕʂ̃t[Y`FCȂ΁A݂̍Đ~擪ĐJnB
			if(TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) == iPhrType) {
				//_`ľʂƃpύXB
				// - ĐJns킸Ɍ݂̍Đp鎞Aʂƃp͐VlKpKvLB
				TapLogCh_Ctrl(pTapSeq, iLogCh, iAtt, iPan);
				goto L_RETURN;	//܂	ENTER_CS`LEAVE_CSԂȂ̂ŁAPreturnĂ͂ȂB
			}
		}
		//ĐJnt[Ỹt[Y`FC̍Ō̃t[Y[vt[YȂ̂ŁA[v񐔂𖳌[vɒuB
		iLoop = 0;
	}
	//_`lmɍĐ~B
	TapLogCh_Stop(pTapSeq, iLogCh);
	//[v񐔂i[B
	pLogCh->iLoop = iLoop;
	//ʂi[B
	pLogCh->iAtt  = iAtt;
	//pi[B
	pLogCh->iPan  = iPan;
	//҂ԂNAB
	// - ̌AĐJñTu[`̒ŁAt[YԂZB
	pLogCh->iWait = 0;
	//foCX`llB
	// - foCX`l̊lɎsꍇLB
	//   foCX`l̊lɎsꍇAȉ̏sB
	TapSeq_AcqLogCh(pTapSeq, iLogCh);
	//ĐJñTu[`sB
	TapLogCh_PlaySubr(pTapSeq, iLogCh, iPhr);
L_RETURN:	//
LEAVE_CS;	//tɂȂ悤ӂB
}
/*---------------------------------------------------------------------------*/
//_`lĐ~B
// - TapLogCh_Play(),,TapSeqCh_Stop(),,TapSeqCh_Exec()Ăяoꂽꍇ͔r䂪svłAAvP[VڌĂяo\L̂ŁAr䂪KvłB
void TapLogCh_Stop(ST_TapSeq* pTapSeq, int iLogCh) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
ENTER_CS;
	//̘_`l𐧌䂵ĂV[PT`lԍAmɃNAB
	pLogCh->iSeqCh = -1;
	//_`l~Ȃ΁AɋAB
	if(pLogCh->iPhr == UINT16_MAX) { goto L_RETURN; }	//܂	ENTER_CS`LEAVE_CSԂȂ̂ŁAPreturnĂ͂ȂB
	//Đ̃t[Ỹt[Y`FC̍Ō̃t[YASt[YȊOȂ΁c
	// - St[YȂ΁A_`l̓V[PT`l̐OAR~܂ŌpB
	if(TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) != -2/*St[Y*/) {
		//Đ~ʒmsB
		// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
		TapSeq_fnStop(pTapSeq, iLogCh);
		//Đ~̃Tu[`sB
		TapLogCh_StopSubr(pTapSeq, iLogCh);
	}
L_RETURN:	//
LEAVE_CS;	//tɂȂ悤ӂB
}
/*---------------------------------------------------------------------------*/
//_`ľʂƃpύXB
// - TapLogCh_Play(),,TapSeqCh_Exec()Ăяoꂽꍇ͔r䂪svłAAvP[VڌĂяo\L̂ŁAr䂪KvłB
void TapLogCh_Ctrl(ST_TapSeq* pTapSeq, int iLogCh, int iAtt, int iPan) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
ENTER_CS;
	//_`l~Ȃ΁AɋAB
	if(pLogCh->iPhr == UINT16_MAX) { goto L_RETURN; }	//܂	ENTER_CS`LEAVE_CSԂȂ̂ŁAPreturnĂ͂ȂB
	//ʂƃpωȂ΁AɋAB
	if((pLogCh->iAtt == iAtt) && (pLogCh->iPan == iPan)) { goto L_RETURN; }	//܂	ENTER_CS`LEAVE_CSԂȂ̂ŁAPreturnĂ͂ȂB
	//ʂi[B
	pLogCh->iAtt = iAtt;
	//pi[B
	pLogCh->iPan = iPan;
	//Rg[ʒmsB
	// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
	TapSeq_fnCtrl(pTapSeq, iLogCh);
L_RETURN:	//
LEAVE_CS;	//tɂȂ悤ӂB
}
/*---------------------------------------------------------------------------*/
//V[PT`lĐJnB
// - AvP[VCӂ̃ReLXgŌĂяo\L̂ŁAr䂪KvłB
void TapSeqCh_Play(ST_TapSeq* pTapSeq, int iSeqCh, const void* pData) {
	ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
ENTER_CS;
	//V[PT`lmɍĐ~B
	TapSeqCh_Stop(pTapSeq, iSeqCh);
	//V[PXf[^i[B
	pSeqCh->pData = pData;
	//҂ԂNAB
	pSeqCh->iWait = 0;
	//V[PXf[^̐擪Ɂu҂Ԗv̏L΁AsB
	TapSeqCh_Exec(pTapSeq, iSeqCh, 0);
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//V[PT`lĐ~B
// - AvP[VCӂ̃ReLXgŌĂяo\L̂ŁAr䂪KvłB
void TapSeqCh_Stop(ST_TapSeq* pTapSeq, int iSeqCh) {
	ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
	int iLogCh;
ENTER_CS;
	//V[PXf[^NAB
	pSeqCh->pData = NULL;
	//e_`lɂāc
	for(iLogCh = 0; iLogCh < pTapSeq->pInfo->nLogCh; iLogCh++) {
		ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
		//̃V[PT`l䂵Ă_`lȂ΁c
		if(pLogCh->iSeqCh == iSeqCh) {
			//̘_`l𐧌䂵ĂV[PT`lԍNAB
			// - ̉̏TapLogCh_Stop()Ăяoꍇ́A(pLogCh->iSeqCh=-1)xsɂȂAʂQ͖B
			pLogCh->iSeqCh = -1;
			//_`lĐȂ΁c
			// - KĐł͂AÔ߂ɊmF鎖ɂB
			if(pLogCh->iPhr != UINT16_MAX) {
				//AvP[V`̃[vt[YpԂ0łȂ,,Đ̃t[Ỹt[Y`FC̍Ō̃t[Y[vt[YȂ΁c
				if(pTapSeq->pInfo->iCont && (TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) >= 0)) {
					//[vt[YpԂ܂JnĂȂ΁A[vt[YpԂJnB
					// - [vpԓɍēx̏sꂽꍇ́A[vpԂĊJȂB
					if(!pLogCh->iCont) { pLogCh->iCont = pTapSeq->pInfo->iCont; }
				//AvP[V`̃[vt[YpԂ0,,Đ̃t[Ỹt[Y`FC̍Ō̃t[Y[vt[YłȂ΁c
				} else {
					//_`lĐ~B
					TapLogCh_Stop(pTapSeq, iLogCh);
				}
			}
		}
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//foCX`l擾B
ST_TapDevCh* TapSeq_GetDevCh(ST_TapSeq* pTapSeq, int iDevCh) {
	if((unsigned)iDevCh >= (unsigned)pTapSeq->pInfo->nDevCh) { DIE(); }	//foCX`lԍ͈͊OȂ΃G[
	return (ST_TapDevCh*)(pTapSeq + 1) + iDevCh;
}
/*---------------------------------------------------------------------------*/
//_`l擾B
ST_TapLogCh* TapSeq_GetLogCh(ST_TapSeq* pTapSeq, int iLogCh) {
	if((unsigned)iLogCh >= (unsigned)pTapSeq->pInfo->nLogCh) { DIE(); }	//_`lԍ͈͊OȂ΃G[
	return (ST_TapLogCh*)(TapSeq_GetDevCh(pTapSeq, 0) + ((pTapSeq->pInfo->nDevCh+3)&~3)) + iLogCh;
}
/*---------------------------------------------------------------------------*/
//V[PT`l擾B
ST_TapSeqCh* TapSeq_GetSeqCh(ST_TapSeq* pTapSeq, int iSeqCh) {
	if((unsigned)iSeqCh >= (unsigned)pTapSeq->pInfo->nSeqCh) { DIE(); }	//V[PT`lԍ͈͊OȂ΃G[
	return (ST_TapSeqCh*)(TapSeq_GetLogCh(pTapSeq, 0) + pTapSeq->pInfo->nLogCh) + iSeqCh;
}
/*---------------------------------------------------------------------------*/
//Cxg擾B
ST_TapEvt* TapSeq_EvtGet(ST_TapSeq* pTapSeq) {
	ST_TapEvtBuf* pEvtBuf = TapSeq_GetEvtBuf(pTapSeq);
//{{2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
	ST_TapEvt* TBL_Buf = (ST_TapEvt*)(pEvtBuf + 1);
//}}2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//{{cliprinb.cRinBuf_Get()Ɠl̏łB
	ST_TapEvt* pBuf;
ENTER_CS;
	{
		//̗vfǂݏoʒu擾B
		int iGetPos = pEvtBuf->iGetPos;
		//obt@łȂ΁c
		if(iGetPos != pEvtBuf->iAddPos) {
			//̗vfǂݏoʒuւ̃|C^߂B
//{{2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//			pBuf = &pEvtBuf->TBL_Buf[iGetPos];
//2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
			pBuf = &TBL_Buf[iGetPos];
//}}2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
			//̗vfǂݏoʒui߂B
			if(++iGetPos > pTapSeq->pInfo->nEvt) { iGetPos = 0; }
			//̗vfǂݏoʒui[B
			pEvtBuf->iGetPos = iGetPos;
		//obt@Ȃ΁c
		} else {
			//NULL|C^ԂB
			pBuf = NULL;
		}
	}
LEAVE_CS;
	return pBuf;
//}}cliprinb.cRinBuf_Get()Ɠl̏łB
}
/*---------------------------------------------------------------------------*/
//Cxg̃I[o[񐔂擾B
int TapSeq_EvtOvr(ST_TapSeq* pTapSeq) {
	ST_TapEvtBuf* pEvtBuf = TapSeq_GetEvtBuf(pTapSeq);
//{{cliprinb.cRinBuf_Ovr()Ɠl̏łB
	int nOvrCnt;
ENTER_CS;
	{
		//I[o[񐔂擾B
		nOvrCnt = pEvtBuf->nOvrCnt;
		//I[o[񐔂mɃNAB
		pEvtBuf->nOvrCnt = 0;
	}
LEAVE_CS;
	return nOvrCnt;
//}}cliprinb.cRinBuf_Ovr()Ɠl̏łB
}
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
//B
static void TapSeqInfo_Verify(const ST_TapSeqInfo* pInfo) {
//{{2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
////{{2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	const uint8_t** TBL_TapSet = (const uint8_t**)(pInfo + 1);
////}}2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	int iDevCh, iLogCh;
//2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
	int iDevCh, iLogCh, iSeqCh;
//}}2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
	if(!pInfo->nPhr				||	//t[Y				1`UINT16_MAX
	   !pInfo->nDevCh			||	//foCX`l			1`UINT8_MAX
	   !pInfo->nLogCh			||	//_`l			1`UINT8_MAX
	   !pInfo->nSeqCh			||	//V[PT`l			1`UINT8_MAX
	// !pInfo->iCont			||	//[vt[Yp[ms]	0`UINT8_MAX	sv
	  (!pInfo->nEvt ^ !pInfo->iEvtMsk)	||	//CxgL^,Cxg}XN		0`UINT8_MAX	(nEvt=0)Ȃ(iEvtMsk=0)łȂ΂ȂȂB(nEvt!=0)Ȃ(iEvtMsk!=0)łȂ΂ȂȂB
	   !pInfo->fnPlay			||	//ĐJnʒm
	   !pInfo->fnStop			||	//Đ~ʒm
	   !pInfo->fnLoop			||	//R[vʒm
	   !pInfo->fnEnd			||	//R~ʒm
	   !pInfo->fnNext			||	//RJڒʒm				//{{2016/08/02ǉ:RJڒʒmǉ܂B}}
	   !pInfo->fnCtrl			||	//Rg[ʒm
	   !pInfo->fnGetPhrTime			||	//t[Y[ms]擾B
	   !pInfo->fnGetPhrNext) { DIE(); }		//t[Y`FC̎̃t[Yԍ擾B
	for(iLogCh = 0; iLogCh < pInfo->nLogCh; iLogCh++) {
//{{2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//		const uint8_t* pTapSet = pInfo->TBL_TapSet[iLogCh];	//TAPZbg
//2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//		const uint8_t* pTapSet = TBL_TapSet[iLogCh];	//TAPZbg
//2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
		const uint8_t* pTapSet = pInfo->pTBL_TapSet[iLogCh];	//TAPZbg
//}}2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
		uint8_t mask[256/8];
		memset(mask, 0, sizeof mask);
		while((iDevCh = *pTapSet++) != UINT8_MAX) {	//TAPZbg(擪UINT8_MAX)ƂBtF[_[Ƃėp_`ĺAfoCX`l̊lsvłꍇɁATAPZbgݒ肹B
			if((unsigned)iDevCh >= (unsigned)pInfo->nDevCh) { DIE(); }	//foCX`lԍ͈͊OȂ΃G[
			if(mask[iDevCh/8] &  (1<<(iDevCh&7))) { DIE(); }		//̘_`lTAPZbgŁAfoCX`lԍ𕡐w肵Ă͂ȂB
			   mask[iDevCh/8] |= (1<<(iDevCh&7));
		}
	}
//{{2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
	for(iSeqCh = 0; iSeqCh < pInfo->nSeqCh; iSeqCh++) {
		iLogCh = pInfo->pTBL_BaseCh[iSeqCh];
		if((unsigned)iLogCh >= (unsigned)pInfo->nLogCh) { DIE(); }	//x[X_`lԍ͈͊OȂ΃G[
	}
//}}2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
}
/*---------------------------------------------------------------------------*/
//ĐJnʒmsB
static void TapSeq_fnPlay(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	TapSeq_AddEvt(pTapSeq, TapEvt_Play, iLogCh, pLogCh->iPhr);		//Cxgobt@݂ȂΉȂBCxg}XNŎw肳ĂȂΉȂB
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	(*pTapSeq->pInfo->fnPlay)(iLogCh, pLogCh);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	(*pTapSeq->pInfo->fnPlay)(pTapSeq, iLogCh, pLogCh);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
}
/*---------------------------------------------------------------------------*/
//Đ~ʒmsB
static void TapSeq_fnStop(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	TapSeq_AddEvt(pTapSeq, TapEvt_Stop, iLogCh, pLogCh->iPhr);		//Cxgobt@݂ȂΉȂBCxg}XNŎw肳ĂȂΉȂB
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	(*pTapSeq->pInfo->fnStop)(iLogCh, pLogCh);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	(*pTapSeq->pInfo->fnStop)(pTapSeq, iLogCh, pLogCh);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
}
/*---------------------------------------------------------------------------*/
//R[vʒmsB
static void TapSeq_fnLoop(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	TapSeq_AddEvt(pTapSeq, TapEvt_Loop, iLogCh, pLogCh->iPhr);		//Cxgobt@݂ȂΉȂBCxg}XNŎw肳ĂȂΉȂB
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	(*pTapSeq->pInfo->fnLoop)(iLogCh, pLogCh);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	(*pTapSeq->pInfo->fnLoop)(pTapSeq, iLogCh, pLogCh);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
}
/*---------------------------------------------------------------------------*/
//R~ʒmsB
static void TapSeq_fnEnd(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	TapSeq_AddEvt(pTapSeq, TapEvt_End, iLogCh, pLogCh->iPhr);		//Cxgobt@݂ȂΉȂBCxg}XNŎw肳ĂȂΉȂB
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	(*pTapSeq->pInfo->fnEnd)(iLogCh, pLogCh);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	(*pTapSeq->pInfo->fnEnd)(pTapSeq, iLogCh, pLogCh);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
}
/*---------------------------------------------------------------------------*/
//{{2016/08/02ǉ:RJڒʒmǉ܂B
//RJڒʒmsB
static void TapSeq_fnNext(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	TapSeq_AddEvt(pTapSeq, TapEvt_Next, iLogCh, pLogCh->iPhr);		//Cxgobt@݂ȂΉȂBCxg}XNŎw肳ĂȂΉȂB
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	(*pTapSeq->pInfo->fnNext)(iLogCh, pLogCh);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	(*pTapSeq->pInfo->fnNext)(pTapSeq, iLogCh, pLogCh);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
}
//}}2016/08/02ǉ:RJڒʒmǉ܂B
/*---------------------------------------------------------------------------*/
//Rg[ʒmsB
static void TapSeq_fnCtrl(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	TapSeq_AddEvt(pTapSeq, TapEvt_Ctrl, iLogCh, pLogCh->iPhr);		//Cxgobt@݂ȂΉȂBCxg}XNŎw肳ĂȂΉȂB
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	(*pTapSeq->pInfo->fnCtrl)(iLogCh, pLogCh);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	(*pTapSeq->pInfo->fnCtrl)(pTapSeq, iLogCh, pLogCh);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
}
/*---------------------------------------------------------------------------*/
//t[Y[ms]擾B
static int TapSeq_fnGetPhrTime(ST_TapSeq* pTapSeq, int iPhr) {
	int iTime;
	if((unsigned)iPhr >= (unsigned)pTapSeq->pInfo->nPhr) { DIE(); }		//t[Yԍ͈͊OȂ΃G[		Œ~ꍇ͓W[̃oOł\B
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	iTime = (*pTapSeq->pInfo->fnGetPhrTime)(iPhr);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	iTime = (*pTapSeq->pInfo->fnGetPhrTime)(pTapSeq, iPhr);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	if(iTime < 0) { DIE(); }						//(0`INT_MAX)͈̔͊OȂ΃G[		Œ~ꍇ̓AvP[V`̃R[obN֐̃oOł\B
	return iTime;
}
/*---------------------------------------------------------------------------*/
//t[Y`FC̎̃t[Yԍ擾B
static int TapSeq_fnGetPhrNext(ST_TapSeq* pTapSeq, int iPhr) {
	if((unsigned)iPhr >= (unsigned)pTapSeq->pInfo->nPhr) { DIE(); }		//t[Yԍ͈͊OȂ΃G[		Œ~ꍇ͓W[̃oOł\B
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	iPhr = (*pTapSeq->pInfo->fnGetPhrNext)(iPhr);
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	iPhr = (*pTapSeq->pInfo->fnGetPhrNext)(pTapSeq, iPhr);
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	if((iPhr < -2) || (iPhr >= pTapSeq->pInfo->nPhr)) { DIE(); }		//-2,,t[Yԍ͈͊OȂ΃G[	Œ~ꍇ̓AvP[V`̃R[obN֐̃oOł\B
	return iPhr;
}
/*---------------------------------------------------------------------------*/
//t[Y`FC̍Ō̃t[ÝAt[Yʂ擾B
static int TapSeq_GetPhrType(ST_TapSeq* pTapSeq, int iPhr) {
	if((unsigned)iPhr >= (unsigned)pTapSeq->pInfo->nPhr) { DIE(); }		//t[Yԍ͈͊OȂ΃G[		Œ~ꍇ͓W[̃oOł\B
	for(;;) {
		int iPhrNext = TapSeq_fnGetPhrNext(pTapSeq, iPhr);
		if(iPhrNext <     0) { return iPhrNext; }	//-1=ʏt[Y,,-2=St[Y
		if(iPhrNext == iPhr) { return iPhr;     }	//0ȏ=[vt[Y
		iPhr = iPhrNext;
	}
}
/*---------------------------------------------------------------------------*/
//foCX`llB
// - TapLogCh_Play()ENTER_CS`LEAVE_CSԂĂяôŁA֐ł͔r䂪svłB
static void TapSeq_AcqLogCh(ST_TapSeq* pTapSeq, int iLogCh) {
	ST_TapLogCh* pLogCh;
	ST_TapDevCh* pDevCh;
//{{2017/02/09폜:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
////{{2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	const uint8_t** TBL_TapSet;
////}}2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//}}2017/02/09폜:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
	const uint8_t* pTapSet;
//{{2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
//	int iDevCh, iDevChSel, iLogChMax;
//2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
	int iDevCh, iDevChSel, iLogChMin;
//}}2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
	//_`l擾B
	pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`lAɃfoCX`l𐧌䂵Ă鎖́AN蓾Ȃ͂łB
	if(pLogCh->iDevCh != UINT8_MAX) { DIE(); }	//ŃG[~ꍇA֐ĂяoOTapLogCh_Stop()ĂяoAYĂ\B
	//TAPZbg(̘_`lŎgpfoCX`lԍ̃Xg)擾B
//{{2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	pTapSet = pTapSeq->pInfo->TBL_TapSet[iLogCh];	//TAPZbg
//2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	TBL_TapSet = (const uint8_t**)(pTapSeq->pInfo + 1);
//	pTapSet = TBL_TapSet[iLogCh];	//TAPZbg
//2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
	pTapSet = pTapSeq->pInfo->pTBL_TapSet[iLogCh];	//TAPZbg
//}}2017/02/09ύX:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
//{{2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
//	//foCX`lԍ(-1)Cő̘_`lԍ̘_`lԍƂĂB
//	iDevChSel = -1, iLogChMax = iLogCh;
//2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
	//foCX`lԍ(-1)Cŏ̘_`lԍ̘_`lԍƂĂB
	iDevChSel = -1, iLogChMin = iLogCh;
//}}2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
	//TAPZbg̏I[(UINT8_MAX)ɓB܂Łc
	while((iDevCh = *pTapSet++) != UINT8_MAX) {	//TAPZbg(擪UINT8_MAX)ƂBtF[_[Ƃėp_`ĺAfoCX`l̊lsvłꍇɁATAPZbgݒ肹B
		//foCX`l擾B
		pDevCh = TapSeq_GetDevCh(pTapSeq, iDevCh);
		//foCX`lAɂ̘_`lɐ䂳Ă鎖́AN蓾Ȃ͂łB
		if(pDevCh->iLogCh == iLogCh) { DIE(); }
//{{2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
//		//foCX`l𐧌䂵Ă_`lA̘_`l傫,,~(UINT8_MAX)Ȃ΁AfoCX`lloB
//		//~̃foCX`lL΂lA~̃foCX`l΁Aő̘_`lԍɐ䂳ĂfoCX`llB
//		//̘_`l傫_`lԍɐ䂳ĂfoCX`l΁AlɎsB
//		if(pDevCh->iLogCh > iLogChMax) {
//			iDevChSel = iDevCh;
//			iLogChMax = pDevCh->iLogCh;
//		}
//2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
		//foCX`l𐧌䂵Ă_`lA̘_`l,,~(UINT8_MAX)Ȃ΁AfoCX`lloB
		//~̃foCX`lL΂lA~̃foCX`l΁Aŏ̘_`lԍɐ䂳ĂfoCX`llB
		//̘_`l_`lԍɐ䂳ĂfoCX`l΁AlɎsB
		if(pDevCh->iLogCh == UINT8_MAX) {
			iDevChSel = iDevCh;
			break;	//܂
		}
		if(pDevCh->iLogCh < iLogChMin) {
			iDevChSel = iDevCh;
			iLogChMin = pDevCh->iLogCh;
		}
//}}2016/02/16ύX:TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
	}
	//foCX`lloc
	if(iDevChSel != -1) {
		//̘_`l䂵ĂfoCX`lԍi[B
		pLogCh->iDevCh = iDevChSel;
		//foCX`l擾B
		pDevCh = TapSeq_GetDevCh(pTapSeq, iDevChSel);
		//̃foCX`lA̘_`lɐ䂳Ăc
		if(pDevCh->iLogCh != UINT8_MAX) {
			//̃foCX`l𐧌䂵Ă_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, pDevCh->iLogCh);
			//̘_`l䂵ĂfoCX`lÃfoCX`lł鎖mFB
			if(pLogCh->iDevCh != iDevChSel) { DIE(); }
			//̘_`l䂵ĂfoCX`lANAB
			pLogCh->iDevCh = -1;
		}
		//̃foCX`l𐧌䂵Ă_`lԍi[B
		pDevCh->iLogCh = iLogCh;
	}
}
/*---------------------------------------------------------------------------*/
//ĐJñTu[`B
// - TapLogCh_Play()ENTER_CS`LEAVE_CS,,TapLogCh_Exec()ĂяôŁA֐ł͔r䂪svłB
static void TapLogCh_PlaySubr(ST_TapSeq* pTapSeq, int iLogCh, int iPhr) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//t[Yԍi[B
	pLogCh->iPhr   = iPhr;
	//t[YԂ擾A҂ԂɉZB
	pLogCh->iWait += TapSeq_fnGetPhrTime(pTapSeq, pLogCh->iPhr);
	//ĐJnʒmsB
	// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
	TapSeq_fnPlay(pTapSeq, iLogCh);
}
/*---------------------------------------------------------------------------*/
//{{2016/08/02ǉ:RJڒʒmǉ܂B
//RJڏ̃Tu[`B
// - TapLogCh_Exec()ĂяôŁA֐ł͔r䂪svłB
static void TapLogCh_NextSubr(ST_TapSeq* pTapSeq, int iLogCh, int iPhr) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//t[Yԍi[B
	pLogCh->iPhr   = iPhr;
	//t[YԂ擾A҂ԂɉZB
	pLogCh->iWait += TapSeq_fnGetPhrTime(pTapSeq, pLogCh->iPhr);
	//RJڒʒmsB
	// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
	TapSeq_fnNext(pTapSeq, iLogCh);
}
//}}2016/08/02ǉ:RJڒʒmǉ܂B
/*---------------------------------------------------------------------------*/
//R[ṽTu[`B
// - TapLogCh_Exec()ĂяôŁA֐ł͔r䂪svłB
static void TapLogCh_LoopSubr(ST_TapSeq* pTapSeq, int iLogCh) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//t[YԂ擾A҂ԂɉZB
	pLogCh->iWait += TapSeq_fnGetPhrTime(pTapSeq, pLogCh->iPhr);
	//R[vʒmsB
	// - ̘_`l䂵ĂfoCX`lꍇŗǂB
	TapSeq_fnLoop(pTapSeq, iLogCh);
}
/*---------------------------------------------------------------------------*/
//Đ~̃Tu[`B
// - TapLogCh_Stop()ENTER_CS`LEAVE_CS,,TapLogCh_Exec()ĂяôŁA֐ł͔r䂪svłB
static void TapLogCh_StopSubr(ST_TapSeq* pTapSeq, int iLogCh) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`l~ƂB
	pLogCh->iPhr = -1;
	//̘_`l䂵ĂfoCX`lL΁c
	if(pLogCh->iDevCh != UINT8_MAX) {
		//foCX`l擾B
		ST_TapDevCh* pDevCh = TapSeq_GetDevCh(pTapSeq, pLogCh->iDevCh);
		//̃foCX`l𐧌䂵Ă_`lA̘_`lł鎖mFB
		if(pDevCh->iLogCh != iLogCh) { DIE(); }
		//foCX`l~ƂB
		pDevCh->iLogCh = -1;
		//̘_`l䂵ĂfoCX`lANAB
		pLogCh->iDevCh = -1;
	}
}
/*---------------------------------------------------------------------------*/
//_`lsB
// - TapSeq_Exec()ENTER_CS`LEAVE_CSԂĂяôŁA֐ł͔r䂪svłB
static void TapLogCh_Exec(ST_TapSeq* pTapSeq, int iLogCh, int iElapTime) {
	//_`l擾B
	ST_TapLogCh* pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
	//_`l~Ȃ΁AɋAB
	if(pLogCh->iPhr == UINT16_MAX) { return; }	//܂
	//[vt[YpԂJnĂc
	if(pLogCh->iCont) {
		//[vt[YpԂ炷B
		UVAR_SUB(pLogCh->iCont, iElapTime);
		//[vt[YpԂ0ɂȂc
		if(!pLogCh->iCont) {
			//Đ~ʒmsB
			// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
			TapSeq_fnStop(pTapSeq, iLogCh);
			//Đ~̃Tu[`sB
			TapLogCh_StopSubr(pTapSeq, iLogCh);
			return;	//܂
		}
	}
	//҂Ԃ炷B
	VAR_SUB(pLogCh->iWait, iElapTime);
	//҂Ԃ0ȉłԁAJԂB
	while(pLogCh->iWait <= 0) {
		//̃t[Y擾B
		int iPhr = TapSeq_fnGetPhrNext(pTapSeq, pLogCh->iPhr);
	    //{{2016/01/11C:St[Y̎R~̃oOC܂Bʏt[YƓlɎR~ׂƂAԃt[YƓlɎ̃t[YĐĂ܂BTapLogCh_Exec()̏(-2)ԈĎ̃t[YԍƌȂĂ܂ĂoOłB
	    //	//݂̃t[YAʏt[YȂ΁c
	    //	if(iPhr == -1) {
	    //2016/01/11C:St[Y̎R~̃oOC܂Bʏt[YƓlɎR~ׂƂAԃt[YƓlɎ̃t[YĐĂ܂BTapLogCh_Exec()̏(-2)ԈĎ̃t[YԍƌȂĂ܂ĂoOłB
		//݂̃t[YAʏt[Y(-1),,St[Y(-2)Ȃ΁c
		if(iPhr < 0) {
	    //}}2016/01/11C:St[Y̎R~̃oOC܂Bʏt[YƓlɎR~ׂƂAԃt[YƓlɎ̃t[YĐĂ܂BTapLogCh_Exec()̏(-2)ԈĎ̃t[YԍƌȂĂ܂ĂoOłB
			//[vłȂ,,[v񐔂炵0ɂȂc
			if(pLogCh->iLoop && !--pLogCh->iLoop) {
				//R~ʒmsB
				// - ̘_`l䂵ĂfoCX`lԍꍇAŗǂB
				TapSeq_fnEnd(pTapSeq, iLogCh);
				//Đ~̃Tu[`sB
				TapLogCh_StopSubr(pTapSeq, iLogCh);
				return;	//܂
			//[v,,[v񐔂炵0ɂȂȂ΁c
			} else {
				//R[ṽTu[`sB
				TapLogCh_LoopSubr(pTapSeq, iLogCh);
			}
		//݂̃t[YA[vt[YȂ΁c
		} else if(iPhr == pLogCh->iPhr) {
			//R[ṽTu[`sB
			TapLogCh_LoopSubr(pTapSeq, iLogCh);
		//݂̃t[YAԃt[YȂ΁c
		} else {
//{{2016/08/02ύX:RJڒʒmǉ܂B
//			//ĐJñTu[`sB
//			TapLogCh_PlaySubr(pTapSeq, iLogCh, iPhr);
//2016/08/02ύX:RJڒʒmǉ܂B
			//RJڏ̃Tu[`sB
			TapLogCh_NextSubr(pTapSeq, iLogCh, iPhr);
//}}2016/08/02ύX:RJڒʒmǉ܂B
		}
	}
}
/*---------------------------------------------------------------------------*/
//V[PT`lsB
// - TapSeq_Exec(),,TapSeqCh_Play()ENTER_CS`LEAVE_CSԂĂяôŁA֐ł͔r䂪svłB
static void TapSeqCh_Exec(ST_TapSeq* pTapSeq, int iSeqCh, int iElapTime) {
	ST_TapSeqCh* pSeqCh = TapSeq_GetSeqCh(pTapSeq, iSeqCh);
	ST_TapLogCh* pLogCh;
//{{2017/02/11ύX:[vǉ܂B
//	int iData, iTime, iLogCh, iPhr, iLoop, iAtt, iPan;
//2017/02/11ύX:[vǉ܂B
	int iData, iTime, iDist, iLogCh, iPhr, iLoop, iAtt, iPan;
	const uint8_t* pData;
//}}2017/02/11ύX:[vǉ܂B
	//V[PT`l~Ȃ΁AɋAB
	if(!pSeqCh->pData) { return; }	//܂
	//҂Ԃ炷B
	VAR_SUB(pSeqCh->iWait, iElapTime);
	//҂Ԃ0ȉłԁAJԂB
	while(pSeqCh->iWait <= 0) {
		switch((iData = *pSeqCh->pData++)) {
		default:DIE();
		//V[PXf[^̏I[
		case 0x00://
			//V[PXf[^̏I[ŃXeCB
			pSeqCh->pData--;
			return;	//܂
		//1`4oCgEFCg
		case 0x01://(iTime-0x00001)[ 7: 0]								//1oCgEFCg͈̔ = 0x00001+(0`0x000000FF) [ms]
		case 0x02://(iTime-0x00101)[15: 8] (iTime-0x00101)[ 7: 0]					//2oCgEFCg͈̔ = 0x00101+(0`0x0000FFFF) [ms]
		case 0x03://(iTime-0x10101)[23:16] (iTime-0x10101)[15: 8] (iTime-0x10101)[ 7:0]			//3oCgEFCg͈̔ = 0x10101+(0`0x00FFFFFF) [ms]
		case 0x04://(iTime        )[31:24] (iTime        )[23:16] (iTime        )[15:8] (iTime)[7:0]	//4oCgEFCg͈̔ =         (0`0xFFFFFFFF) [ms]
			//EFCgԂ擾B
			iTime  = 0;
			if(iData == 0x04) { iTime = -0x01010101; }	//4oCgEFCgȂ4񃋁[v閈(+1)𑊎EB
			do {
				iTime <<= 8;
				iTime  += ((*pSeqCh->pData++) + 1);
			} while(--iData);
			//҂Ԃ𑝂₷B
			VAR_ADD(pSeqCh->iWait, iTime);
			break;
		//Rg[`FW
		case 0x05://iLogCh iAtt
		case 0x06://iLogCh      iPan
		case 0x07://iLogCh iAtt iPan
			//_`lԍ擾B
			iLogCh = *pSeqCh->pData++;
//{{2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
			//x[X_`lԍZB
			iLogCh += pTapSeq->pInfo->pTBL_BaseCh[iSeqCh];
//}}2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
			//_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
			//,p擾B
			iAtt   = pLogCh->iAtt; if(iData & 1) { iAtt =         *pSeqCh->pData++; }	//l:ݒl
			iPan   = pLogCh->iPan; if(iData & 2) { iPan = (int8_t)*pSeqCh->pData++; }	//l:ݒl
			//Rg[`FWsB
			TapLogCh_Ctrl(pTapSeq, iLogCh, iAtt, pLogCh->iPan);
			break;
		//_`lĐJn
		case 0x08://iLogCh iPhr[15:8] iPhr[7:0]                
		case 0x09://iLogCh iPhr[15:8] iPhr[7:0] iLoop          
		case 0x0A://iLogCh iPhr[15:8] iPhr[7:0]       iAtt     
		case 0x0B://iLogCh iPhr[15:8] iPhr[7:0] iLoop iAtt     
		case 0x0C://iLogCh iPhr[15:8] iPhr[7:0]            iPan
		case 0x0D://iLogCh iPhr[15:8] iPhr[7:0] iLoop      iPan
		case 0x0E://iLogCh iPhr[15:8] iPhr[7:0]       iAtt iPan
		case 0x0F://iLogCh iPhr[15:8] iPhr[7:0] iLoop iAtt iPan
//{{2017/02/13ǉ:'play.w'߂ǉ܂B
		//_`lĐJn(EFCgt)
		case 0x18://iLogCh iPhr[15:8] iPhr[7:0]                
		case 0x19://iLogCh iPhr[15:8] iPhr[7:0] iLoop          
		case 0x1A://iLogCh iPhr[15:8] iPhr[7:0]       iAtt     
		case 0x1B://iLogCh iPhr[15:8] iPhr[7:0] iLoop iAtt     
		case 0x1C://iLogCh iPhr[15:8] iPhr[7:0]            iPan
		case 0x1D://iLogCh iPhr[15:8] iPhr[7:0] iLoop      iPan
		case 0x1E://iLogCh iPhr[15:8] iPhr[7:0]       iAtt iPan
		case 0x1F://iLogCh iPhr[15:8] iPhr[7:0] iLoop iAtt iPan
//}}2017/02/13ǉ:'play.w'߂ǉ܂B
			//_`lԍ擾B
			iLogCh = *pSeqCh->pData++;
//{{2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
			//x[X_`lԍZB
			iLogCh += pTapSeq->pInfo->pTBL_BaseCh[iSeqCh];
//}}2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
			//_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
			//t[Yԍ擾B
			iPhr   = *pSeqCh->pData++;
			iPhr <<= 8;
			iPhr  |= *pSeqCh->pData++;
			//,p,[v񐔂擾B
			iLoop  = 1; if(iData & 1) { iLoop =         *pSeqCh->pData++; }			//l:[v=1
			iAtt   = 0; if(iData & 2) { iAtt  =         *pSeqCh->pData++; }			//l:=0()
			iPan   = 0; if(iData & 4) { iPan  = (int8_t)*pSeqCh->pData++; }			//l:p=0()
			//_`lĐJnB
			TapLogCh_Play(pTapSeq, iLogCh, iPhr, iLoop, iAtt, iPan);
			//̘_`l𐧌䂵ĂV[PT`lԍݒ肷B
			pLogCh->iSeqCh = iSeqCh;
//{{2017/02/13ǉ:'play.w'߂ǉ܂B
			//_`lĐJn(EFCgt)Ȃ΁c
			if(iData & 0x10) {
				//t[YԂ擾B
				iTime = TapSeq_fnGetPhrTime(pTapSeq, iPhr);
				//҂Ԃ𑝂₷B
				VAR_ADD(pSeqCh->iWait, iTime);
			}
//}}2017/02/13ǉ:'play.w'߂ǉ܂B
			break;
		//_`lĐ~
		case 0x10://iLogCh
			//_`lԍ擾B
			iLogCh = *pSeqCh->pData++;
//{{2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
			//x[X_`lԍZB
			iLogCh += pTapSeq->pInfo->pTBL_BaseCh[iSeqCh];
//}}2017/02/09ǉ:ST_TapSeqInfo\̂ɁApTBL_BaseChtB[hǉ܂Bɔē̂߂ɁATBL_TapSettB[hzłȂzւ̃|C^ɕύXāApTBL_TapSettB[hƂ܂B
			//_`l擾B
			pLogCh = TapSeq_GetLogCh(pTapSeq, iLogCh);
#ifdef  PRODUCT_SPECIFIC_WORKAROUND
			//_`lĐ,,Đ̃t[Ỹt[Y`FC̍Ō̃t[Y[vt[YȂ΁A_`lĐ~R}h𖳎B
			if((pLogCh->iPhr != UINT16_MAX) && (TapSeq_GetPhrType(pTapSeq, pLogCh->iPhr) >= 0)) { break; }
#endif//PRODUCT_SPECIFIC_WORKAROUND
			//_`lĐ~B
			TapLogCh_Stop(pTapSeq, iLogCh);
			break;
//{{2017/02/11ǉ:[vǉ܂B
		//1`4oCgWv
		case 0x11://(iDist-0x00001)[ 7: 0]								//1oCgWv͈̔ = 0x00001+(0`0x000000FF) [ms]
		case 0x12://(iDist-0x00101)[15: 8] (iDist-0x00101)[ 7: 0]					//2oCgWv͈̔ = 0x00101+(0`0x0000FFFF) [ms]
		case 0x13://(iDist-0x10101)[23:16] (iDist-0x10101)[15: 8] (iDist-0x10101)[ 7:0]			//3oCgWv͈̔ = 0x10101+(0`0x00FFFFFF) [ms]
		case 0x14://(iDist        )[31:24] (iDist        )[23:16] (iDist        )[15:8] (iDist)[7:0]	//4oCgWv͈̔ =         (0`0xFFFFFFFF) [ms]
			iData -= 0x10;			//1`4oCgWṽfR[h@A1`4oCgEFCg̃fR[h@Ɠɂ邽߂ɁAR}hԍ(0x11`0x14)(0x01`0x04)ɕϊĂB
			pData = pSeqCh->pData - 1;	//Wv́AWv߂̃R}hԍi[ĂAhX̋t΂łB(pSeqCh->pData)͊ɃR}hԍi[Ă鎟̃AhX֐ił܂Ă邵Ả̏(pSeqCh->pData)ωĂ܂̂ŁAŃR}hԍi[ĂAhXLĂB
		    //{{1`4oCgWṽfR[h@́A1`4oCgEFCg̃fR[h@ƓłB
			//Wv擾B
			iDist  = 0;
			if(iData == 0x04) { iDist = -0x01010101; }	//4oCgWvȂ4񃋁[v閈(+1)𑊎EB
			do {
				iDist <<= 8;
				iDist  += ((*pSeqCh->pData++) + 1);
			} while(--iData);
		    //}}1`4oCgWṽfR[h@́A1`4oCgEFCg̃fR[h@ƓłB
			//Wv߂̃R}hԍi[ĂAhX̋tΈʒuփWvB
			pSeqCh->pData = pData - iDist;
			break;
//}}2017/02/11ǉ:[vǉ܂B
		}
	}
}
/*---------------------------------------------------------------------------*/
//Cxgobt@擾B
static ST_TapEvtBuf* TapSeq_GetEvtBuf(ST_TapSeq* pTapSeq) {
	if(!pTapSeq->pInfo->nEvt) { DIE(); }					//Cxgobt@݂Ȃ΃G[
	return (ST_TapEvtBuf*)(TapSeq_GetSeqCh(pTapSeq, 0) + pTapSeq->pInfo->nSeqCh);
}
/*---------------------------------------------------------------------------*/
//CxgǉB
static void TapSeq_AddEvt(ST_TapSeq* pTapSeq, int iEvt, int iLogCh, int iPhr) {
	if(pTapSeq->pInfo->nEvt &&						//Cxgobt@݂ȂΉȂB
	  (pTapSeq->pInfo->iEvtMsk & (1<<iEvt))) {				//Cxg}XNŎw肳ĂȂΉȂB
		ST_TapEvtBuf* pEvtBuf = TapSeq_GetEvtBuf(pTapSeq);
//{{2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
		ST_TapEvt* TBL_Buf = (ST_TapEvt*)(pEvtBuf + 1);
//}}2016/08/19ǉ:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//{{cliprinb.cRinBuf_Add()Ɠl̏łB
ENTER_CS;
		{
			//̗vfވʒu擾B
			int iAddPos = pEvtBuf->iAddPos;
			//̗vfވʒuւ̃|C^߂B
//{{2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//			ST_TapEvt* pBuf = &pEvtBuf->TBL_Buf[iAddPos];
//2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
			ST_TapEvt* pBuf = &TBL_Buf[iAddPos];
//}}2016/08/19ύX:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
			//̗vfވʒui߂B
			if(++iAddPos > pTapSeq->pInfo->nEvt) { iAddPos = 0; }
			//̗vfވʒuAvfǂݏoʒuɈvȂ΁c
			// - A̗vfވʒuA݃AvP[VQƒ(mȂ)̈ʒu(=OTapSeq_EvtGet()Ԃʒu)OȂ΁c
			if(iAddPos != pEvtBuf->iGetPos) {
				//̗vfވʒui[B
				pEvtBuf->iAddPos = iAddPos;
				//̗vfށB
				pBuf->iEvt   = iEvt;
				pBuf->iLogCh = iLogCh;
				pBuf->iPhr   = iPhr;
			//̗vfވʒuAvfǂݏoʒuɈvc
			// - AvfވʒuA݃AvP[VQƒ(mȂ)̈ʒu(=OTapSeq_EvtGet()Ԃʒu)Ȃ΁c
			} else {
				//̗vfގ͏oȂBI[o[񐔂𑝂₷B
				if(pEvtBuf->nOvrCnt < UINT16_MAX) { pEvtBuf->nOvrCnt++; }
			}
		}
LEAVE_CS;
//}}cliprinb.cRinBuf_Add()Ɠl̏łB
	}
}
/****************************************************************************
 *	dTapSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#ifdef  USE_TAPDEF_BIN
void TapSeqCh_PlayNo(ST_TapSeq* pTapSeq, int iTapSeqCh, const void* pTapDefBin, int iTapSeqNo) {
	const int* const TBL_TapSeqNo = pTapDefBin;						//oCi̐擪ɃAhXe[uLBAhX̓f[^{(BYTEz)̃CfNXłB
	const int nTapSeqNo = TBL_TapSeqNo[0];							//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
	const unsigned char* const TBL_TapSeq = (const unsigned char*)&TBL_TapSeqNo[nTapSeqNo];	//AhXe[u̒ォf[^{(BYTEz)JnB
	if((iTapSeqNo <= 0) || (iTapSeqNo >= nTapSeqNo)) { DIE(); }
	TapSeqCh_Play(pTapSeq, iTapSeqCh, &TBL_TapSeq[TBL_TapSeqNo[iTapSeqNo]]);
}
#endif//USE_TAPDEF_BIN
/*****************************************************************************
 *	
 *****************************************************************************/
//:YMZ871ٰߏɂ
//YMZ871ٰߏͤƭقƎ@̋Ⴄ
//@ƭق̐ǂނƤȉ̂悤ȏłƓǂݎ̂:
////QƎ:YMZ871عƭ٣(5MZ871A40.pdf)3.4.1.3.ٰߏ
//for(;;) {
//  1Đ;
//  if(LOOP_x != 255) {
//    if(!LOOP_x) { break; }
//    LOOP_x--;
//  }
//}
//Aۂ̋琄Ƥۂ͈̓ȉ̂悤ɂȂĂƎv:
// = 0;
//for(;;) {
//  1Đ;
//  if( < 255) { ++; }
//  if( > LOOP_x) { break; }
//}
//@ȂΤLOOP_xωuԂPVUP_x=1sƋԂĂ܂
//ł͖肪L̂Ť@ł͂ȂAłɂȂĂ
//rLOOP_xPVUP_x=1sƤAɉɂȂ鎖mF
//]ĤL̐A͍ĂƎv
//:L𓥂܂Ă̒ӓ_
//عݒ`fnCtrlPVUP_x=1sۤLOOP_xpLogCh->iLoopݒ肵Ă͂Ȃ
//pLogCh->iLoop͏LAŌƂ(LOOP_x-)łLOOP_xƂ͈Ⴄl
//LOOP_xpLogCh->iLoopݒ肵PVUP_x=1sƤc񐔂]vɌĂ܂
//]ĤعݑfnPlaypLogCh->iLoopLĂKvL
//PNRCL=1Ă\Ȃغق͔ς킵̂ŤعݑŋLĂǂ낤
//L̏ͤ_ٖɋLĂKv͖޲ٖō\Ȃ
//PVUP_x=1sɂऍĐJnƓLOOP_xݒ肷邽߂̖ړI
