/*
 *	clipsndm.h
 *
 *	Sound Manager
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Sat Jul 27 21:43:04 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Aug 01 00:52:48 JST 2013 Naoyuki Sawa
 *	- ֐̐ǋL܂B
 *	* Thu Sep 12 23:08:12 JST 2013 Naoyuki Sawa
 *	- SndMgr_AttCh()A`lĐ̏ꍇ̂ݏs悤ɁAC܂B
 *	- CÕR[h́A`l~łĂAsĂ܂Ă܂B
 *	  ĂȂ`lɑ΂fnAtt()sƂAʂ܂B(Q͖)
 *	* Fri Sep 13 01:48:44 JST 2013 Naoyuki Sawa
 *	- SndMgr_AttMaster()ǉ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_SNDM_H__
#define __CLIP_SNDM_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	萔A\
 ****************************************************************************/

/*  */
typedef struct _ST_SndMgrInfo {
	void (*fnPlay)(int iCh, int iData, int iLoop);	/* + 0,4 */
	void (*fnStop)(int iCh);			/* + 4,4 */
	int  (*fnStat)(int iCh);			/* + 8,4 */
	void (*fnAtt )(int iCh, int attNow);		/* +12,4 */
} ST_SndMgrInfo;					/* =16 */

/* `l\ */
typedef struct _ST_SndMgrCh {
	         short iLoop;		/* + 0,2 ĐJñ[vwL ((=0)~,(>0)L[vĐ,(<0)[vĐ) */
	unsigned short iData;		/* + 2,2 Đ̃f[^ԍ ((0`USHRT_MAX)SėLȃf[^ԍƂBʈl͖) */
	unsigned short uKeep;		/* + 4,2 Đێdvx (USHRT_MAX0) */
	unsigned short attPeriod;	/* + 6,2 ωɗv鎞 (0=ω) */
	unsigned short attTime;		/* + 8,2 ω̌oߎ (0attPeriod) */
	unsigned char  attOld;		/* +10,1 ωǑ (0`64) */
	unsigned char  attNew;		/* +11,1 ω̌ (0`64) */
} ST_SndMgrCh;				/* =12 */

/* Sound Manager\ */
typedef struct _ST_SndMgr {
	const ST_SndMgrInfo* pInfo;		/* +0,4 ւ̃|C^ */
	unsigned char MinCh;			/* +4,1 `lԍ */
	unsigned char MaxCh;			/* +5,1 `lԍ (̔ԍ܂݂܂) */
	unsigned char attMaster;		/* +6,1 Ŝ̌ (0`64) */
	/* unsigned char Padding; */		/* +7,1 */
	ST_SndMgrCh Ch[0/*MaxCh-MinCh+1*/];	/* +8,12*(MaxCh-MinCh+1) */
} ST_SndMgr;					/* =8+12*(MaxCh-MinCh+1) */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* Sound Manager쐬܂B
 * [in]
 *	pInfo		ւ̃|C^
 *	MinCh		`lԍ
 *	MaxCh		`lԍ (̔ԍ܂݂܂)
 * [out]
 *	߂l		Sound Manager
 * [note]
 *	- pInfoweSound Manager\̂̒ɃRs[A|C^̂܂܂ŕێ܂B
 *	  AvP[V́ASndMgr_Init()ԂApInfoJĂ͂܂B
 *	- ݌vɂŔAfoCX(sound or adpcm)́AقȂ`l͈͂wA
 *	  Sound ManagerA1̏LAߖłƍl߂łB
 */
ST_SndMgr* SndMgr_Init(const ST_SndMgrInfo* pInfo, int MinCh, int MaxCh);


/* Sound ManagerJ܂B
 * [in]
 *	pSndMgr		Sound Manager
 *			{֐̂݁ApSndMgrNULLw\łB
 *			uSndMgr_Free(NULL)v̌Ăяo͈SłAs܂B
 * [note]
 *	- Sound ManagerǗ`l͈͂SčĐ~AJ܂B
 *	- AvP[VIOȂ΁AISound ManagerJKv͂܂B
 *	  Sound Manager̓\[X̂ݎgpA荞݃tbN͍sĂȂłB
 */
void SndMgr_Free(ST_SndMgr* pSndMgr);

/* Sound Manager1t[s܂B
 * [in]
 *	pSndMgr		Sound Manager
 * [note]
 *	- {֐́A̓Iɂ͈ȉ̏s܂:
 *	EĐ`lAĐ~ɖ߂
 *	EĐpԂ̊Ď (Đێdvx̌)
 *	EtF[hCtF[hAEg (ʂ̕ω)
 */
void SndMgr_Exec(ST_SndMgr* pSndMgr);

/* `lԍw肵āAĐJn܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	iCh		`lԍ (MinChiChMaxCh)
 *	iData		f[^ԍ (pInfo->fnPlayɂĉ߂AAvP[V`̒l)
 *	iLoop		(1`SHRT_MAX)=L[vA(-1)=[vBLȊO̒l͓얢`
 * [note]
 *	- {֐́A̓Iɂ͈ȉ̏s܂:
 *	Ew肳ꂽ`ľ݂̏ԂɊ֌WȂAVĐJn܂B
 *	Ew肳ꂽ`ľʂAA0(=ʍő)ɐݒ肵܂B
 *	Ẽ`lɉe^܂Bf[^ԍĐ̃`lɗLĂA֌W܂B
 */
void SndMgr_PlayCh(ST_SndMgr* pSndMgr, int iCh, int iData, int iLoop);

/* f[^ԍw肵āAĐJn܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	iData		f[^ԍ (pInfo->fnPlayɂĉ߂AAvP[V`̒l)
 *	iLoop		(1`SHRT_MAX)=L[vA(-1)=[vBLȊO̒l͓얢`
 * [note]
 *	- {֐́A̓Iɂ͈ȉ̏s܂:
 *	Ew肳ꂽf[^ԍĐ̃`lSĂA~܂B
 *	EɂĒ~`lĆCɒ~̃`lL΁Ã`lōĐJn܂B
 *	E~`lꍇAĐێdvxŏ̃`lւāAĐJn܂B
 *	  A̖[vAVL[vɍւ邱Ƃ͂܂B(QƂĂ)
 *	EĐJnꍇAĐJn`ľʂAA0(=ʍő)ɐݒ肵܂B
 */
void SndMgr_PlayData(ST_SndMgr* pSndMgr, int iData, int iLoop);

/* `lԍw肵āAĐ~܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	iCh		`lԍ (MinChiChMaxCh)
 * [note]
 *	- w肳ꂽ`ľ݂̏ԂɊ֌WȂAmɒ~܂B
 */
void SndMgr_StopCh(ST_SndMgr* pSndMgr, int iCh);

/* f[^ԍw肵āAĐ~܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	iData		f[^ԍ (pInfo->fnPlayɂĉ߂AAvP[V`̒l)
 * [note]
 *	- w肳ꂽf[^ԍĐ̃`lSĂA~܂B
 */
void SndMgr_StopData(ST_SndMgr* pSndMgr, int iData);

/* S`lAĐ~܂B
 * [in]
 *	pSndMgr		Sound Manager
 */
void SndMgr_StopAll(ST_SndMgr* pSndMgr);

/* `lԍw肵āAʂݒ肵܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	iCh		`lԍ (MinChiChMaxCh)
 *	attNew		ŏI
 *	attPeriod	ω[t[] (0=)
 * [note]
 *	- O̕ωȂ΁AAO̍ŏIʂݒ肵A̕ωJn܂B
 *	  vɁAO̕ωɂ炸A̕ω̌X͓ɂȂ܂B
 */
void SndMgr_AttCh(ST_SndMgr* pSndMgr, int iCh, int attNew, int attPeriod);

/* f[^ԍw肵āAʂݒ肵܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	iData		f[^ԍ (pInfo->fnPlayɂĉ߂AAvP[V`̒l)
 *	attNew		ŏI
 *	attPeriod	ω[t[] (0=)
 * [note]
 *	- w肳ꂽf[^ԍĐ̃`lSĂɑ΂Aʂݒ肵܂B
 *	- ω̌X̓ɂẮASndMgr_AttCh()[note]QƂĂB
 */
void SndMgr_AttData(ST_SndMgr* pSndMgr, int iData, int attNew, int attPeriod);

/* S`ĺAʂݒ肵܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	attNew		ŏI
 *	attPeriod	ω[t[] (0=)
 * [note]
 *	- ω̌X̓ɂẮASndMgr_AttCh()[note]QƂĂB
 */
void SndMgr_AttAll(ST_SndMgr* pSndMgr, int attNew, int attPeriod);

/* Ŝ̌ʂݒ肵܂B
 * [in]
 *	pSndMgr		Sound Manager
 *	attMaster	Ŝ̌
 * [note]
 *	- ֐Őݒ肷uŜ̌ʁvƁASndMgr_AttCh()Őݒ肷u`lPʂ̌ʁv̍vAe`l̎ʂɂȂ܂B
 *	- ֐Őݒ肷uŜ̌ʁv̖ړÍASound ManagerPʂ"g[^{["Ӑ}̂łB
 *	  op̋@\ł͂Ȃ̂ŁAuŜ̌ʁvAIɕω@\͂܂B
 */
void SndMgr_AttMaster(ST_SndMgr* pSndMgr, int attMaster);

/****************************************************************************
 *	gp
 ****************************************************************************/

//	//f[^ԍ߂邽߂̃X^u֐
//	static void sound_play_stub(int iCh, int iData, int iLoop) {
//		if((unsigned)iData >= SOUND_COUNT) { DIE(); }
//		sound_play(iCh, sound_table[iData], iLoop);
//	}
//	//eXg֐
//	void test_init() {
//		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
//		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, 0, 0); //BGM Sound Manager
//		pSndMgrSe  = SndMgr_Init(&stSndMgrInfo, 1, 3); //SE  Sound Manager
//	}
//	//eXgC֐
//	void test_main() {
//		test_init();
//		SndMgr_AttMaster(pSndMgrBgm, 6); //BGM Sound ManagerŜ50%
//		SndMgr_AttMaster(pSndMgrSe , 3); //SE  Sound ManagerŜ30%
//		for(;;) {
//			schedule();
//			SndMgr_Exec(pSndMgrBgm); //BGM Sound Manager
//			SndMgr_Exec(pSndMgrSe ); //SE  Sound Manager
//			if(joy & PAD_A) {
//				if(joy & TRG_LF) { SndMgr_PlayCh(pSndMgrBgm, 0, SND_BGM1, -1); } //BGM1[vĐ
//				if(joy & TRG_RI) { SndMgr_PlayCh(pSndMgrBgm, 0, SND_BGM2, -1); } //BGM2[vĐ
//				if(joy & TRG_UP) { SndMgr_PlayCh(pSndMgrBgm, 0, SND_JNGL,  1); } //WOĐ
//				if(joy & TRG_DN) { SndMgr_StopCh(pSndMgrBgm, 0); } //Đ~
//				if(joy & TRG_START) { SndMgr_AttCh(pSndMgrBgm, 0, 64, SEC(1)); } //bԂď
//			}
//			if(joy & PAD_B) {
//				if(joy & TRG_LF) { SndMgr_PlayData(pSndMgrSe, SND_SE1, 1); } //SE1ĐBJ`lꍇ͈ԌÂւ
//				if(joy & TRG_RI) { SndMgr_PlayData(pSndMgrSe, SND_SE2, 1); } //SE2ĐBJ`lꍇ͈ԌÂւ
//				if(joy & TRG_UP) { SndMgr_PlayData(pSndMgrSe, SND_SE3, 1); } //SE3ĐBJ`lꍇ͈ԌÂւ
//				if(joy & TRG_DN) { SndMgr_PlayData(pSndMgrSe, SND_SE4, 1); } //SE4ĐBJ`lꍇ͈ԌÂւ
//				if(joy & TRG_START) { SndMgr_AttData(pSndMgrBgm, SND_SE1, 64, SEC(1)); } //SE1Đ̃`lL΁AbԂď
//			}
//		}
//	}

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif/*__CLIP_SNDM_H__*/
