/*	
 *	clipsn7.c
 *
 *	P/ECE SN76489/SN76496(DCSG) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 24 18:30:00 JST 2005 Naoyuki Sawa
 *	- ̂߂ɑ啝ȉs܂B
 *	  VGM PlayerŜ2.5{xȂ̂ŁAP̂ł͂ƑȂĂƎv܂B
 *	- т̂鋌R[h keep/SN76489Oۑ-20050124.zip ɕۑĂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

void
sn76489_reset(SN76489* sn, int clock)
{
	memset(sn, 0, sizeof(SN76489));

	/* ̓NbNi[܂B */
	sn->clock = clock;
}

void
sn76489_write(SN76489* sn, unsigned char data)
{
	int i_channel;
	SN76489TONE* tone;
	SN76489NOISE* noise;

	if(data & 0x80) {
		// data: 76543210
		//       ||||++++- [3:0] or 
		//       |||+----- 0=[3:0]ݒ,1=ʐݒ
		//       |++------ `lԍ(0..2:Tone,3:Noise)
		//       +-------- 1
		i_channel = sn->i_channel = (data >> 5) & 3;
		if(i_channel <= 2) {
			tone = &sn->tone[i_channel];
			if(data & 0x10) {
				/* ʂi[܂B
				 * ݒl(:15..0:)Ȃ̂ŁA炩ߔ]Ă܂B
				 */
				tone->volume = ~data & 0xf;
			} else {
				/* ̉ʃrbgi[܂B */
				tone->period = (tone->period & ~0xf) | (data & 0xf);
			}
		} else {
			noise = &sn->noise;
			if(data & 0x10) {
				/* ʂi[܂B
				 * ݒl(:15..0:)Ȃ̂ŁA炩ߔ]Ă܂B
				 */
				noise->volume = ~data & 0xf;
			} else {
				/* i[܂B */
				switch(data & 3) {
				case 0:  noise->period = 0x20; break;
				case 1:  noise->period = 0x40; break;
				case 2:  noise->period = 0x80; break;
				default: noise->period = 0x00; break; /* Tone2̎gp */
				}
				/* tB[hobN^Cvi[܂B */
				noise->fbtype = (data >> 2) & 1;
				/* LFSR܂B
				 * zCgmCY̏ꍇA0ȊOȂΉł\܂B
				 * mCY̏ꍇAf[eB[1:15ɂ邽1K{łB
				 * ]āA1ɏ邱Ƃɂ܂B
				 */
				noise->lfsr = 1; /* Kv!! */
			}
		}
	} else {
		// data: 76543210
		//       ||++++++- [9:4]
		//       |+------- (gp)
		//       +-------- 0
		i_channel = sn->i_channel;
		if(i_channel <= 2) {
			tone = &sn->tone[i_channel];
			/* ̏ʃrbgi[܂B */
			tone->period = (tone->period & 0xf) | ((data & 0x3f) << 4);
		}
	}
}

void
sn76489_mix(SN76489* sn, short wbuff[/*count*/], int count)
{
	/* ܂o̓obt@NA܂B */
	memset(wbuff, 0, sizeof(short) * count);

	/* vTv0ȉȂ΁A܂B */
	if(count <= 0) {
		return;
	}

	/* e`l̏o͔g`܂B */
	sn76489_tone_mix (sn, &sn->tone[0], wbuff, count);
	sn76489_tone_mix (sn, &sn->tone[1], wbuff, count);
	sn76489_tone_mix (sn, &sn->tone[2], wbuff, count);
	sn76489_noise_mix(sn, &sn->noise  , wbuff, count);

	/* ꂽo͔g`XP[O܂B */
	sn76489_volume_shift(wbuff, count);
}
