/*
 *	clippsrl.c
 *
 *	p`XQ[p[V~[^
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2017 Naoyuki Sawa
 *
 *	* Mon Jan 30 21:41:16 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Jan 31 22:45:54 JST 2017 Naoyuki Sawa
 *	- PslRelCh_Intr()́u(ZTo)ṽZToɁAZToJE^̍ŏLlłAĉֈڍsȂ悤ɏC܂B
 *	  CŔAȂƁA[]Jn̏̓(ZTo)ɃZToɁAԈčĉֈڍs肪邩łB
 *	  ȂȂ΁A[]Jn̏ɓ(ZTo)ֈڍs_ł̓ZT܂ł͕̋słAɃZToĂ킾łB
 *	* Wed Feb 01 21:56:57 JST 2017 Naoyuki Sawa
 *	- PslRelCh_Intr()ɂđS㎥̏o̓p^[ԈႦĂ̂C܂B
 *	  CÓufOut = -1vƂĂāAPslRel_Intr()ɂđ̃[̏o̓p^[ƃ}[WۂɁÃ[̏o̓p^[j󂵂Ă܂Ă܂B
 *	  ĆufOut = (1<<0)|(1<<1)|(1<<2)|(1<<3)vƂāÃ[̏o̓p^[j󂵂ĂȂ悤ɂȂ܂B
 */
#include "clip.h"
/****************************************************************************
 *	[J萔
 ****************************************************************************/
//o̓p^[e[u
static const uint8_t TBL_PslRel_OutPat[8]={	//   X Y~X~Y
	(1<<0)|(0<<1)|(0<<2)|(0<<3),	//0 1㎥ 
	(1<<0)|(1<<1)|(0<<2)|(0<<3),	//1 2㎥ 
	(0<<0)|(1<<1)|(0<<2)|(0<<3),	//2 1㎥ 
	(0<<0)|(1<<1)|(1<<2)|(0<<3),	//3 2㎥ 
	(0<<0)|(0<<1)|(1<<2)|(0<<3),	//4 1㎥ 
	(0<<0)|(0<<1)|(1<<2)|(1<<3),	//5 2㎥ 
	(0<<0)|(0<<1)|(0<<2)|(1<<3),	//6 1㎥ 
	(1<<0)|(0<<1)|(0<<2)|(1<<3),	//7 2㎥ 
};
/*--------------------------------------------------------------------------*/
//p^[e[u
static const uint8_t TBL_PslRel_AccPat[][2/*0=,1=*/]={
	{10, 4},	//		//Ⴆ΂̍s̏ꍇA101̑xŁA4pXo͂ƂӖłB
	{ 7, 8},	//
	{ 2, 5},	//
};
/****************************************************************************
 *	[J֐
 ****************************************************************************/
#ifdef  __RENESAS__
#pragma section ERAM
#endif//__RENESAS__
static int PslRelCh_Intr(ST_PslRelCh* pPslRelCh, int fSns) {
	int OnEdge, fOut = 0;	//̕ϐɁȀo͒li[B
#ifdef  PslRel_UseVirtualReel
	//z[Ȃ΁AfSns͖AzIȈʒuŃZTôƌȂB
	static_assert(PslRel_Sns_Ofs, "ȉ̔莮PslRel_Sns_Ofs0łȂɈˑĂ܂BPslRel_Sns_Ofs0ɂꍇ͔莮ύXĉB");
	fSns = (pPslRelCh->iOfs == (PslRel_Sns_Ofs - 1)) && (pPslRelCh->iPos == PslRel_Sns_Pos);
	//                                         ~~~̓̈ʒuŔ肷邽߁B
#endif//PslRel_UseVirtualReel
	//ZTԂXVB
	OnEdge = (pPslRelCh->fSns ^ fSns) & fSns;	//OnGbW
	pPslRelCh->fSns = (pPslRelCh->fSns << 1) | fSns;
	//Ԃɂāc
	switch(pPslRelCh->iStat) {
	default:DIE();
	//-------------------------------------------------------------------------------------
	//㎥
	case PslRelCh_Stat_Off:
		/** no job **/
		break;
	//-------------------------------------------------------------------------------------
	//(ĉ܂)
	case PslRelCh_Stat_Accel:
		//̏o͒l擾B
		fOut = TBL_PslRel_OutPat[pPslRelCh->iOutPat & 7];
		//p^[JE^1i߂āẢ݂p^[̕ɒBc
		if(++pPslRelCh->nAccCnt1 >= TBL_PslRel_AccPat[pPslRelCh->iAccPat][0/**/]) {
			//p^[JE^1ZbgB
			pPslRelCh->nAccCnt1 = 0;
			//o̓p^[CfNXi߂B
			pPslRelCh->iOutPat++;
#ifdef  PslRel_UseVirtualReel
			//ItZbgi߂āA(G̃pX-1)𒴂c
			if(++pPslRelCh->iOfs > PslRel_Ofs_Max) {
				//ItZbgZbgB
				pPslRelCh->iOfs = 0;
				//Gʒu炷,,܂ԂB
				pPslRelCh->iPos = pPslRelCh->iPos ? (pPslRelCh->iPos - 1) : PslRel_Pos_Max;
			}
#endif//PslRel_UseVirtualReel
			//p^[JE^2i߂āẢ݂p^[̉񐔂ɒBc
			if(++pPslRelCh->nAccCnt2 >= TBL_PslRel_AccPat[pPslRelCh->iAccPat][1/**/]) {
				//p^[JE^2ZbgB
				pPslRelCh->nAccCnt2 = 0;
				//p^[CfNXi߂āAp^[̏I[ɒBc
				if(++pPslRelCh->iAccPat >= ARRAY_SIZE(TBL_PslRel_AccPat)) {
					//p^[CfNXZbgB
					pPslRelCh->iAccPat = 0;
					//ZToJE^ZbgB
					pPslRelCh->nNdCnt = 0;
					//̏ԂA(ZTo)ƂB
					pPslRelCh->iStat = PslRelCh_Stat_Nd;
				}
			}
		}
		break;
	//-------------------------------------------------------------------------------------
	//(ZTo)
	case PslRelCh_Stat_Nd:
		//̏o͒l擾B
		fOut = TBL_PslRel_OutPat[pPslRelCh->iOutPat & 7];
		//o̓p^[CfNXi߂B
		pPslRelCh->iOutPat++;
#ifdef  PslRel_UseVirtualReel
		//ItZbgi߂āA(G̃pX-1)𒴂c
		if(++pPslRelCh->iOfs > PslRel_Ofs_Max) {
			//ItZbgZbgB
			pPslRelCh->iOfs = 0;
			//Gʒu炷,,܂ԂB
			pPslRelCh->iPos = pPslRelCh->iPos ? (pPslRelCh->iPos - 1) : PslRel_Pos_Max;
		}
#endif//PslRel_UseVirtualReel
		//ZToc
		if(OnEdge) {
//{{2017/01/31폜:PslRelCh_Intr()́u(ZTo)ṽZToɁAZToJE^̍ŏLlłAĉֈڍsȂ悤ɏC܂B
//			//ZToJE^AZToJE^̍ŏLlȏȂ΁c
//			if(pPslRelCh->nNdCnt >= PslRel_NdCnt_Min) {
//}}2017/01/31폜:PslRelCh_Intr()́u(ZTo)ṽZToɁAZToJE^̍ŏLlłAĉֈڍsȂ悤ɏC܂B
				//ZToJE^ZbgB
				pPslRelCh->nNdCnt = 0;
				//̏ԂA(ZToς)ƂB
				pPslRelCh->iOfs = PslRel_Sns_Ofs;
				pPslRelCh->iPos = PslRel_Sns_Pos;
				pPslRelCh->iStat = PslRelCh_Stat_Cruise;
//{{2017/01/31폜:PslRelCh_Intr()́u(ZTo)ṽZToɁAZToJE^̍ŏLlłAĉֈڍsȂ悤ɏC܂B
//			//ZToJE^AZToJE^̍ŏLlȂ΁c
//			} else {
//				//̏ԂA(ĉ܂)ƂB
//			//sv	pPslRelCh->nAccCnt1 = 0;	//PslRelCh_Stat_AccelPslRelCh_Stat_Ndֈڍs鎞ɁAnAccCnt1nAccCnt2ZbgĂ͂B
//			//sv	pPslRelCh->nAccCnt2 = 0;	//
//				ASSERT(!pPslRelCh->nAccCnt1 && !pPslRelCh->nAccCnt2);
//				pPslRelCh->iStat = PslRelCh_Stat_Accel;
//			}
//}}2017/01/31폜:PslRelCh_Intr()́u(ZTo)ṽZToɁAZToJE^̍ŏLlłAĉֈڍsȂ悤ɏC܂B
		//ZToȂ΁c
		} else {
			//ZToJE^i߂āAZToJE^̍őLl𒴂c
			if(++pPslRelCh->nNdCnt > PslRel_NdCnt_Max) {
				//̏ԂA(ĉ܂)ƂB
			//sv	pPslRelCh->nAccCnt1 = 0;	//PslRelCh_Stat_AccelPslRelCh_Stat_Ndֈڍs鎞ɁAnAccCnt1nAccCnt2ZbgĂ͂B
			//sv	pPslRelCh->nAccCnt2 = 0;	//
				ASSERT(!pPslRelCh->nAccCnt1 && !pPslRelCh->nAccCnt2);
				pPslRelCh->iStat = PslRelCh_Stat_Accel;
			}
		}
		break;
	//-------------------------------------------------------------------------------------
	//(ZToς)
	case PslRelCh_Stat_Cruise:
		//̏o͒l擾B
		fOut = TBL_PslRel_OutPat[pPslRelCh->iOutPat & 7];
		//o̓p^[CfNXi߂B
		pPslRelCh->iOutPat++;
		//ItZbgi߂āA(G̃pX-1)𒴂c
		if(++pPslRelCh->iOfs > PslRel_Ofs_Max) {
			//ItZbgZbgB
			pPslRelCh->iOfs = 0;
			//Gʒu炷,,܂ԂB
			pPslRelCh->iPos = pPslRelCh->iPos ? (pPslRelCh->iPos - 1) : PslRel_Pos_Max;
		}
		//ZToc
		if(OnEdge) {
			//ZToJE^AZToJE^̍ŏLlȏȂ΁c
			if(pPslRelCh->nNdCnt >= PslRel_NdCnt_Min) {
				//ZToJE^ZbgB
				pPslRelCh->nNdCnt = 0;
				//ItZbgƊGʒuݒ肷B
				pPslRelCh->iOfs = PslRel_Sns_Ofs;
				pPslRelCh->iPos = PslRel_Sns_Pos;
			//ZToJE^AZToJE^̍ŏLlȂ΁c
			} else {
				//̏ԂA(ĉ܂)ƂB
			//sv	pPslRelCh->nAccCnt1 = 0;	//PslRelCh_Stat_AccelPslRelCh_Stat_Ndֈڍs鎞ɁAnAccCnt1nAccCnt2ZbgĂ͂B
			//sv	pPslRelCh->nAccCnt2 = 0;	//
				ASSERT(!pPslRelCh->nAccCnt1 && !pPslRelCh->nAccCnt2);
				pPslRelCh->iStat = PslRelCh_Stat_Accel;
			}
		//ZToȂ΁c
		} else {
			//ZToJE^i߂āAZToJE^̍őLl𒴂c
			if(++pPslRelCh->nNdCnt > PslRel_NdCnt_Max) {
				//̏ԂA(ĉ܂)ƂB
			//sv	pPslRelCh->nAccCnt1 = 0;	//PslRelCh_Stat_AccelPslRelCh_Stat_Ndֈڍs鎞ɁAnAccCnt1nAccCnt2ZbgĂ͂B
			//sv	pPslRelCh->nAccCnt2 = 0;	//
				ASSERT(!pPslRelCh->nAccCnt1 && !pPslRelCh->nAccCnt2);
				pPslRelCh->iStat = PslRelCh_Stat_Accel;
			}
		}
		break;
	//-------------------------------------------------------------------------------------
	//~
	case PslRelCh_Stat_Brake:
		//̏o͒l擾B
		fOut = TBL_PslRel_OutPat[pPslRelCh->iOutPat & 7];
		//o̓p^[CfNXi߂B
		pPslRelCh->iOutPat++;
#if 0	//@ɂ͂̂̕łEEE
		//ItZbgi߂āA(G̃pX-1)𒴂c
		if(++pPslRelCh->iOfs > PslRel_Ofs_Max) {
			//ItZbgZbgB
			pPslRelCh->iOfs = 0;
			//Gʒu炷,,܂ԂB
			pPslRelCh->iPos = pPslRelCh->iPos ? (pPslRelCh->iPos - 1) : PslRel_Pos_Max;
			//GʒuA~ʒuɒBc
			if(pPslRelCh->iPos == pPslRelCh->iStpPos) {
				//ŏo̓p^[CfNXi߂ʂ2㎥Ȃ΁c(=̏o͒l1㎥Ȃ΁c)	//
				if(pPslRelCh->iOutPat & 1) {									//@
					//̏ԂA1XebvxƂB							//@̏tɂĂ\ȂB[jbg̓łB
					pPslRelCh->iStat = PslRelCh_Stat_Brake2;						//@
				//ŏo̓p^[CfNXi߂ʂ1㎥Ȃ΁c(=̏o͒l2㎥Ȃ΁c)	//
				} else {
					//̏ԂAS㎥ƂB
					pPslRelCh->iStat = PslRelCh_Stat_Stop;
				}
			}
		}
#else	//AEEEp͂̕SłBA(iOfs==PslRel_Ofs_Max)̃^C~OŒ~ʒu𔻒fĎ̃R}Ńr^~܂̎w߂oÅԂɊ荞ݏĎ̃R}֐ił܂ĂꍇA@ƈ鋓ɂȂĂ܂łBAȂ1pXĎ~܂邾ōς݂܂B
		//ItZbgi߂āA(G̃pX-1)𒴂c
		if(++pPslRelCh->iOfs > PslRel_Ofs_Max) {
			//ItZbgZbgB
			pPslRelCh->iOfs = 0;
			//Gʒu炷,,܂ԂB
			pPslRelCh->iPos = pPslRelCh->iPos ? (pPslRelCh->iPos - 1) : PslRel_Pos_Max;
		}
		//GʒuA~ʒuɒBc
		if(pPslRelCh->iPos == pPslRelCh->iStpPos) {
			//ŏo̓p^[CfNXi߂ʂ2㎥Ȃ΁c(=̏o͒l1㎥Ȃ΁c)	//
			if(pPslRelCh->iOutPat & 1) {									//@
				//̏ԂA1XebvxƂB							//@̏tɂĂ\ȂB[jbg̓łB
				pPslRelCh->iStat = PslRelCh_Stat_Brake2;						//@
			//ŏo̓p^[CfNXi߂ʂ1㎥Ȃ΁c(=̏o͒l2㎥Ȃ΁c)	//
			} else {
				//̏ԂAS㎥ƂB
				pPslRelCh->iStat = PslRelCh_Stat_Stop;
			}
		}
#endif
		break;
	//-------------------------------------------------------------------------------------
	//1Xebvx
	case PslRelCh_Stat_Brake2:
		//̏o͒l擾B
		fOut = TBL_PslRel_OutPat[pPslRelCh->iOutPat & 7];
		//o̓p^[CfNXi߂B
		pPslRelCh->iOutPat++;
#ifdef  PslRel_UseVirtualReel
		//ItZbgi߂āA(G̃pX-1)𒴂c
		if(++pPslRelCh->iOfs > PslRel_Ofs_Max) {
			//ItZbgZbgB
			pPslRelCh->iOfs = 0;
			//Gʒu炷,,܂ԂB
			pPslRelCh->iPos = pPslRelCh->iPos ? (pPslRelCh->iPos - 1) : PslRel_Pos_Max;
		}
#endif//PslRel_UseVirtualReel
		//̏ԂAS㎥ƂB
		pPslRelCh->iStat = PslRelCh_Stat_Stop;
		break;
	//-------------------------------------------------------------------------------------
	//S㎥
	case PslRelCh_Stat_Stop:
//{{2017/02/01C:PslRelCh_Intr()ɂđS㎥̏o̓p^[ԈႦĂ̂C܂B
//		//̏o͒lS㎥ƂB
//		fOut = -1;
//2017/02/01C:PslRelCh_Intr()ɂđS㎥̏o̓p^[ԈႦĂ̂C܂B
		//̏o͒lS㎥ƂB	//          X Y~X~Y
		fOut = (1<<0)|(1<<1)|(1<<2)|(1<<3);	//S㎥ 
//}}2017/02/01C:PslRelCh_Intr()ɂđS㎥̏o̓p^[ԈႦĂ̂C܂B
		//S㎥JE^i߂āA(S㎥-1)𒴂c
		if(++pPslRelCh->nStpCnt > PslRel_StpCnt_Max) {
			//S㎥ɏo̓p^[CfNXɉZlZB
			pPslRelCh->iOutPat += PslRel_OutPat_Add;
			//̏ԂA㎥ƂB
			pPslRelCh->iStat = PslRelCh_Stat_Off;
		}
		break;
	}
	return fOut;
}
#ifdef  __RENESAS__
#pragma section
#endif//__RENESAS__
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
//\̂B
//[in]
//	pPslRel		ST_PslRel\̂̃|C^
void PslRel_Init(ST_PslRel* pPslRel) {
	//\̂NAB
	memset(pPslRel, 0, sizeof(ST_PslRel));
}
/*--------------------------------------------------------------------------*/
//荞ݏsB
//[in]
//	pPslRel		ST_PslRel\̂̃|C^
//	fSns		bit0=[̃ZŤ݂̏
//			bit1=[̃ZŤ݂̏
//			bit2=E[̃ZŤ݂̏
//[out]
//	߂l		bit0` 3=[̍̏o͒l(X,Y,~X,~Y)
//			bit4` 7=[̍̏o͒l(X,Y,~X,~Y)
//			bit8`11=E[̍̏o͒l(X,Y,~X,~Y)
//[note]
//	- ĂяoɂāAZT̓|[gǂݏoāA֐ɈnĉB
//	  ĂяoɂāA֐̖߂lA㎥p^[̏o̓|[g֐ݒ肵ĉB
int PslRel_Intr(ST_PslRel* pPslRel, int fSns) {
	int fOut = 0;
	fOut |= (PslRelCh_Intr(&pPslRel->TBL_PslRelCh[0], ((fSns >> 0) & 1)) << 0);	//[
	fOut |= (PslRelCh_Intr(&pPslRel->TBL_PslRelCh[1], ((fSns >> 1) & 1)) << 4);	//[
	fOut |= (PslRelCh_Intr(&pPslRel->TBL_PslRelCh[2], ((fSns >> 2) & 1)) << 8);	//E[
#ifndef PslRel_UseVirtualReel
	pPslRel->iIntr++;	//z[łȂ΁A荞݃JE^i߂B
#endif//PslRel_UseVirtualReel
	return fOut;
}
/*--------------------------------------------------------------------------*/
//荞ݏ^C~Oɓ܂B
//[in]
//	pPslRel		ST_PslRel\̂̃|C^
//[note]
//	- AvP[V̊֐ĂяoړÍAST_PslRelCh\̂̓e荞ݏɂĕω邽߁AωȂԂȂׂmۂ邽߂łB
//	  AvP[VAST_PslRelCh\̂̓eQƂāA~ʒu߁APslRel_Brake()ĂяoꍇAȀ̒Oœ֐ĂяoĉB
//	  ̌AŒłPslRel_IntrNs[ns]ȓɁAST_PslRelCh\̂̓e̎QƂPslRel_Brake()̌ĂяoĉB
//	  A[̃^C}荞݂Å荞݂Dx}XNs荞݂ŋ쓮Ăꍇ́Å荞݂ꎞIɃ}XNSłB
//	  <>
//	  ST_PslRelCh* pPslRelCh = PslRel_GetPslRelCh(pPslRel, iPslRelCh);
//	  ENTER_IL(6); //Ⴆ΁A[̃^C}荞݂Dx7ŋ쓮Ăꍇ́ADx6ȉ̊荞݂}XNB
//	  PslRel_Sync(pPslRel);							
//	  int iStpPos = Slot_GetStpCtl1(pStpCtl, iHitCd, iPslRelCh, pPslRelCh->iPos);	ŒłPslRel_IntrNs[ns]ȓ
//	  PslRel_Brake(pPslRel, iPslRelCh, iStpPos);					
//	  LEAVE_IL;
void PslRel_Sync(ST_PslRel* pPslRel) {
#ifndef PslRel_UseVirtualReel
	volatile uint8_t* pIntr = &pPslRel->iIntr;
	int iIntr = *pIntr;
	while(*pIntr == iIntr) { /** no job **/ };	//z[łȂ΁A荞݃JE^ω܂ő҂B
#endif//PslRel_UseVirtualReel
}
/*--------------------------------------------------------------------------*/
//SẴ[ֈڍsB
//[in]
//	pPslRel		ST_PslRel\̂̃|C^
void PslRel_Accel(ST_PslRel* pPslRel) {
	//o̓p^[CfNX͈ێB
	int iOutPat0 = pPslRel->TBL_PslRelCh[0].iOutPat, iOutPat1 = pPslRel->TBL_PslRelCh[1].iOutPat, iOutPat2 = pPslRel->TBL_PslRelCh[2].iOutPat;
#ifdef  PslRel_UseVirtualReel
	//z[Ȃ΁AItZbgƊGʒuێB
	int iOfs0 = pPslRel->TBL_PslRelCh[0].iOfs, iOfs1 = pPslRel->TBL_PslRelCh[1].iOfs, iOfs2 = pPslRel->TBL_PslRelCh[2].iOfs;
	int iPos0 = pPslRel->TBL_PslRelCh[0].iPos, iPos1 = pPslRel->TBL_PslRelCh[1].iPos, iPos2 = pPslRel->TBL_PslRelCh[2].iPos;
#endif//PslRel_UseVirtualReel
	//\̂NAB
	memset(pPslRel, 0, sizeof(ST_PslRel));
	//o̓p^[CfNX͕B
	pPslRel->TBL_PslRelCh[0].iOutPat = iOutPat0, pPslRel->TBL_PslRelCh[1].iOutPat = iOutPat1, pPslRel->TBL_PslRelCh[2].iOutPat = iOutPat2;
#ifdef  PslRel_UseVirtualReel
	//z[Ȃ΁AItZbgƊGʒuB
	pPslRel->TBL_PslRelCh[0].iOfs = iOfs0, pPslRel->TBL_PslRelCh[1].iOfs = iOfs1, pPslRel->TBL_PslRelCh[2].iOfs = iOfs2;
	pPslRel->TBL_PslRelCh[0].iPos = iPos0, pPslRel->TBL_PslRelCh[1].iPos = iPos1, pPslRel->TBL_PslRelCh[2].iPos = iPos2;
#endif//PslRel_UseVirtualReel
	//SẴ[ֈڍsB
	pPslRel->TBL_PslRelCh[0].iStat = pPslRel->TBL_PslRelCh[1].iStat = pPslRel->TBL_PslRelCh[2].iStat = PslRelCh_Stat_Accel;
}
/*--------------------------------------------------------------------------*/
//w肵[~ֈڍsB
//[in]
//	pPslRel		ST_PslRel\̂̃|C^
//	iPslRelCh	0=[,1=[,2=E[
//[note]
//	- (ZToς)ȊÕ[A~ֈڍs鎖͏o܂B
//	- [̊GʒuQƂāA~ʒu肵A~ֈڍs鏈́AŒłPslRel_IntrNs[ns]ȓɊKvL܂B
//	  ڍׂ́APslRel_Sync()֐̃RǵA<>QƂĉB
void PslRel_Brake(ST_PslRel* pPslRel, int iPslRelCh, int iStpPos) {
	ST_PslRelCh* pPslRelCh = PslRel_GetPslRelCh(pPslRel, iPslRelCh);
//	ASSERT(pPslRelCh->iStat == PslRelCh_Stat_Cruise);	//(ZToς)ȊOA~ֈڍs鎖͏oȂB	ˁˁˁv:ɂ͂̌sׂȂ̂łApD悵čsȂɂ܂BȂȂ΃^C~OɂẮAAvP[Vu(ZToς)ł鎖mFvāuPslRel_Brake()ĂяovԂɁA[\IɁuv́u(ZTo)vֈڍsĂ\L邩łBPslRel_Sync()ĂяoĂȂׂLȂ悤ɂ͂̂łASɖh͏oȂ̂ŃG[~̂͊댯łBL̂悤ȃAP[XɂāAG[~[Ď~܂}VƎv̂ŁǍ͍sȂɂ܂B
	//̏ԂA~ƂB
	pPslRelCh->iStpPos = iStpPos;
	pPslRelCh->iStat = PslRelCh_Stat_Brake;
}
/*--------------------------------------------------------------------------*/
//ST_PslRelCh\̂̃|C^擾B
//[in]
//	pPslRel		ST_PslRel\̂̃|C^
//	iPslRelCh	0=[,1=[,2=E[
//[out]
//	߂l		ST_PslRelCh\̂̃|C^
//[note]
//	- ֐ԂST_PslRelCh\̂́AɂvolatileƌȂׂŁA{͓֐̖߂l'volatile ST_PslRelCh*'Ƃ̂łB
//	  AĂяoɂāAST_PslRelCh\̂̓eωȂ^C~O_łď̂ŁAvolatilełĂȂĂłB
//	  ST_PslRelCh\̂̓eωȂԂȂΔvolatileƌȂ܂Avolatile̕ȃR[ĥłĈSłB
//	  ]āA֐ԂST_PslRelCh\̂́AvolatileƂ鎖ɂ܂B
ST_PslRelCh* PslRel_GetPslRelCh(ST_PslRel* pPslRel, int iPslRelCh) {
	ST_PslRelCh* pPslRelCh;
	ASSERT((unsigned)iPslRelCh < (unsigned)ARRAY_SIZE(pPslRel->TBL_PslRelCh));
	pPslRelCh = &pPslRel->TBL_PslRelCh[iPslRelCh];
	return pPslRelCh;
}
/*****************************************************************************
 *	gp
 *****************************************************************************/
#if 0
//TODO:͊JɓKɏgpłBƂƂgpB
int app_main(int argc, char* argv[]) {
	ST_PslRel stPslRel;
	PslRel_Init(&stPslRel);
	for(;;) {
		printf("%2d %2d %2d %2d %2d | %2d %2d %2d %2d %2d | %2d %2d %2d %2d %2d\n",
			stPslRel.TBL_PslRelCh[0].iOutPat&7, stPslRel.TBL_PslRelCh[0].iStat, stPslRel.TBL_PslRelCh[0].iOfs, stPslRel.TBL_PslRelCh[0].iPos, stPslRel.TBL_PslRelCh[0].iStpPos,
			stPslRel.TBL_PslRelCh[1].iOutPat&7, stPslRel.TBL_PslRelCh[1].iStat, stPslRel.TBL_PslRelCh[1].iOfs, stPslRel.TBL_PslRelCh[1].iPos, stPslRel.TBL_PslRelCh[1].iStpPos,
			stPslRel.TBL_PslRelCh[2].iOutPat&7, stPslRel.TBL_PslRelCh[2].iStat, stPslRel.TBL_PslRelCh[2].iOfs, stPslRel.TBL_PslRelCh[2].iPos, stPslRel.TBL_PslRelCh[2].iStpPos);

		PslRel_Intr(&stPslRel, 0);
		if(kbhit()) {
			int i = getch() - '1';
			if((unsigned)i < 3) {
				ST_PslRelCh* pPslRelCh = PslRel_GetPslRelCh(&stPslRel, i, 1);
				if(pPslRelCh->iStat == PslRelCh_Stat_Cruise) {
					int iPos = pPslRelCh->iPos;
					if(--iPos < 0) { iPos = PslRel_Pos_Max; }
					PslRel_Brake(&stPslRel, i, iPos);
				}
			} else {
				PslRel_Accel(&stPslRel);
			}
		}
	}
	return 0;
}
#endif
