/*	
 *	clipprnt.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Tue May 20 06:00:00 JST 2003 Naoyuki Sawa
 *	- http://minix.technoir.org/src/lib/stdio/doprnt.cɉ܂B
 *	* Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 *	- snprintf(),vsnprintf()ǉ܂B
 *	- snprintf(),vsnprintf()Ή̂߂ɁAdoprnt()܂B
 *	  doprnt()sprintf(),vsprintf()pĂTu[`ŁAp܂B
 *	  sprintf(),vsprintf()ɉeoȂ悤CłA΂炭̊Ԃ͗vӂłB
 *	* Wed Nov 16 02:21:10 JST 2011 Naoyuki Sawa
 *	- ^tB[h'g'(y'G')ɊȈՑΉ܂B
 *	* Tue Jan 31 23:45:07 JST 2012 Naoyuki Sawa
 *	- f_print()́AΒl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC܂B
 *	  Βl4294967296.0(=UINT_MAX+1)ȏ̎\ƕoO(H)́A܂CłB
 *	* Thu Oct 02 01:02:39 JST 2014 Naoyuki Sawa
 *	- snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
 *	  scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B
 *	* Sun Oct 12 15:49:27 JST 2014 Naoyuki Sawa
 *	- doprnt()֐ɁAȉ̕ύXs܂B
 *	- W[VC++6.0ŃrhꍇAOUT̒`Windowswb_t@Curpcdce.hvƏՓ˂邽߁AOUT\ߒ`܂B
 *	  W[VC++6.0Ńrhꍇ̑΍􂪕KvɂȂŔAȉ̂ƂłB
 *	- ܂ł́AVC++6.0Ɋ܂܂Ăprintfŏ[̂ŁAW[VC++6.0Ńrh邱Ƃ͍lĂȂ̂łA
 *	  snprintf(),vsnprintf()̖߂l̋ύXAscprintf(),vscprintf(),asprintf(),vasprintf()̒ǉɔ (2014/10/02RgQ)
 *	  VC++6.0p̃vWFNgɂW[܂߂ărhAP/ECEpvOƓʉƎv܂B
 *	  ̂߂ɁAW[VC++6.0ŃrhꍇxoȂ悤A΍􂵂܂B
 *	* Thu Jan 22 21:10:35 JST 2015 Naoyuki Sawa
 *	- Cq'll'Ή܂B
 *	  Cq'll'w肳ꂽꍇAψ̒l̎擾ƁAϊwq'n'ւ̒l̊i[A64rbgōs悤ɂłB
 *	  32rbĝ܂܂łA32rbg͈̔͂𒴂64rbglw肷ƁA32rbĝ݂߂ĕ\܂B	{{2016/08/04RgǋL:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B}}
 *	- 32rbĝ܂܂ɂŔAHȃP[XɑΉ邽߂ɐ\ቺ邱Ƃ邽߂łB
 *	  long long^gpvOłAقƂǂ̏ꍇAl32rbg͈̔͂Ɏ܂Ǝv܂B
 *	  ܂ȂĂA\Ȃ邾ŁA(炭)肠܂B
 *	* Sun Aug 02 16:45:48 JST 2015 Naoyuki Sawa
 *	- fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂B
 *	  Win32vWFNgłAdoprnt()𗘗pprintf()𗘗płB
 *	  clipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
 *	- ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B
 *	  '%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B
 *	  ̓Perlsprintf֐Ɍ݊łB
 *	* Wed Sep 16 21:59:48 JST 2015 Naoyuki Sawa
 *	- vasprintf()va_list̎gȂ_C܂B
 *	  P/ECEJ(GCC)Windows(VC++6.0)ł̓͏CÔ܂܂ł薳삷̂łÂ߂ɏC鎖ɂ܂B
 *	* Tue Feb 23 21:40:12 JST 2016 Naoyuki Sawa
 *	- O؂̃tOu'vΉ܂B
 *	  uLinux Programmer's Manual - PRINTFv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/printf.3.html)p:
 *	  tOu'v
 *	  10iϊ(i,d,u,f,F,g,G)ɂāAP[Ɏw肪1000Pʂ̋؂蕶o͂B
 *	  gcc̑̃o[ẂÃIvV߂邱ƂłAxo͂邱ƂɒӂB
 *	- L̐ɂ́A"10iϊ(i,d,u,f,F,g,G)ɂ"Ƃ܂Ał͊ȒP̂߂ɁA
 *	  tOu'vw肳ꂽA10iϊɌ炸(Ƃ΂16iϊłĂ)AɎO؂\鎖ɂ܂B
 *	  Ăяo10iϊȊOƃtOu'v𕹗pȂÄႢɂȂ鎖͖Ǝv܂B
 *	- tOu'ṽV{́AFL_THOUSANDSƂ܂B̃V{́Aōlĕt܂B
 *	  O؂ɑΉẴCũ\[XAC^[lbgŌꂸAʓIȃV{ȂłB
 *	  Ƃ́Ã\[X̏ȋ^_łAɋCɂKv͂܂B
 *	* Sat May 28 21:20:19 JST 2016 Naoyuki Sawa
 *	- snprintf(),vsnprintf()̈cnť^intsize_tɏC܂B
 *	  C̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łA
 *	  VC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB
 *	  ̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
 *	* Sun May 29 21:54:56 JST 2016 Naoyuki Sawa
 *	- Visual C++ .NETŃRpCɁAvsprintf()ŌxC4028\܂B
 *	  ڍׂ́Aȉ̒ʂłB
 *	- VC++2015œCuRpCĂ݂ACu̎Œu邽߂́Avsprintf()ŌxC4028\܂B
 *	  ́AVC++2015ł́Å֐̃vg^CvAWIȃvg^CvƈقȂĂ鎖łB
 *	  ȉɁAVC++2015ł́Avsprintf()̐錾܂B(̊֐lł)
 *	  c:\Program Files (x86)\Windows Kits\10\Include\10.0.10240.0\ucrt\stdio.h
 *	  _CRT_STDIO_INLINE int __CRTDECL vsprintf(
 *	      _Pre_notnull_ _Post_z_        char*       const _Buffer,
 *	      _In_z_ _Printf_format_string_ char const* const _Format,
 *	                                    va_list           _ArgList
 *	      )
 *	  WIȃvg^Cvł́A'char*','char const*'łAVC++2015ł͑'char* const','char const* const'ɂȂĂ܂B
 *	  (Ȃ݂ɁAMSDN̊֐t@Xł͑O҂ɂȂĂAVC++2015̃wb_t@C҂̐錾ł悤łB)
 *	- Ώ@́Aލl܂B
 *	  E́AVisual C++ .NETȂ΁AW[̊֐̈^ύXāAVisual C++ .NET̊֐vg^Cvɍ킹鎖łB
 *	  E́AVisual C++ .NETȂ΁Ax𖳎@łB
 *	  {͑O҂̕SȂ̂ł傤ǁA͌҂̕@gɂ܂B
 *	  ̖͖炩Visual C++ .NET̖łA̖ɑΏ邽߂ɑ̊֐̒`RpC肵āAR[hGɂȂ̂͗ǂȂƎvłB
 *	- {Aclipprnt.cclipscan.cɁA@őΏs܂B
 *	  AΏ@ύXꍇ́AɂāAύXKvL邩ĉB
 *	* Thu Aug 04 21:10:05 JST 2016 Naoyuki Sawa
 *	- __int64long longRpCŎgĂAint64_tŋʉ܂B
 *	  W[쐬́A܂/clip/include/stdint.h쐬ĂȂ̂ŁA__int64long longRpCŎgĂ܂B
 *	  ݂ł́Aint64_tgp__int64long longRpCŎgKv͖ȂĂ̂ŁAW[̂悤ɏC܂B
 *	- 32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
 *	  ܂ł́A32rbĝ܂܂łA32rbg͈̔͂𒴂64rbglw肷ƁA32rbĝ݂߂ĕ\Ă܂B
 *	  ́A64rbgōsA32rbg͈̔͂𒴂64rbgl(double,int64_t,uint64_t)\o悤ɂȂ܂B
 *	  ܂œ32rbgɂĂŔA\̒ቺ邽߂łA傫double̒l\oȂƍ鎖L̂ŁAς64rbg鎖ɂ܂B
 *	  ̕ύXɂAprintfn֐̑xቺƁAframdi.sW[N鎖ɂR[hTCY̑傪܂Aނ܂B
 *	  Aframdi.sW[N悤ɂȂ̂ŁÁAAvP[V⑼̃W[ɂāAR[hTCYጸ̂߂64rbgZӖ͖Ȃ܂B
 *	* Sun Sep 04 21:41:17 JST 2016 Naoyuki Sawa
 *	- u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
 *	  ڍׂ́Aclipstd.h ̓̃RgQƂĉB
 *	- 64rbgłł́Aϊwqp64rbgƉ߂悤ɂ܂B
 *	  32rbgł̓ɂ͉eL܂B
 *	- Cqj,z,tΉ܂B
 *	  Cqhh͖Ήł鎖𖾎IɎ߂ɃG[I悤ɂ܂B
 *	* Sun Oct 02 21:48:17 JST 2016 Naoyuki Sawa
 *	- doprnt()32rbgł̏ɂāACqz,tǂݔ΂ĂȂoOC܂B
 *	* Tue Oct 18 21:19:07 JST 2016 Naoyuki Sawa
 *	- 0l,,O؂Ȃ΁A0l߂ɂO؂܂߂悤ɂ܂B
 *	  ڍׂ́Aȉ̒ʂłB
 *	- Q[̃XRA\sꍇɁA0l߂ƎO؂𕹗pP[XXL܂B
 *	  A܂ł́A0l߂ƎO؂𕹗pƁA0l߂ɎO؂肪܂܂ꂸAڂɕsRȏo͂ɂȂ肪L܂B
 *	  yύXOz
 *	  printf("$%'014d\n", 123456789);		//$000123,456,789
 *	  printf("$%'020.5f\n", 12345678.90123);	//$000012,345,678.90123
 *	  ꉞȀꍇ́Ao͕wł͂ȂAxwp邱ƂŁAڂɎRȏo͂ɂ鎖\ł͂̂ł`
 *	  yύXOz
 *	  printf("$%'.14d\n", 123456789);		//$00,000,123,456,789
 *	  `̐xwp̂͒ϓIłȂAʓIɂ͏o͕w0l߂p鎖̂̕ŁA͂łB
 *	- ōA0l,,O؂Ȃ΁A0l߂ɂO؂܂߂悤ɂ܂B
 *	  ύX́AĹ̗Aȉ̂悤ȏo͂ƂȂ܂B
 *	  yύXz
 *	  printf("$%'014d\n", 123456789);		//$00,123,456,789
 *	  printf("$%'020.5f\n", 12345678.90123);	//$00,012,345,678.90123
 *	  printf("$%'.14d\n", 123456789);		//$00,000,123,456,789	'0l,,O؂'ł͂Ȃ̂ŁA̕ύX̉e͎󂯂܂B
 *	- ӓ_ƂāA0l߂ƎO؂𕹗pꍇ́Ao͕̎wɒӂĉB
 *	  ̓Iɂ́Ȁo͕4̔{łƁA擪ɎO؂肪uāAڂɕsRȏo͂ɂȂĂ܂܂B
 *	  yύXz
 *	  printf("$%'016d\n", 123456789);		//$,000,123,456,789
 *	  printf("$%'022.5f\n", 12345678.90123);	//$,000,012,345,678.90123
 *	  printf("$%'017d\n", -123456789);		//$-,000,123,456,789
 *	  printf("$%'023.5f\n", -12345678.90123);	//$-,000,012,345,678.90123
 *	  0l߂ƎO؂𕹗pꍇ́Ȁo͕4̔{ɂȂȂ悤AAvP[VŒӂĉB
 *	- A茳ɎO؂ɑΉn(VS2015x86pGCCΉĂȂ悤ł)߁AʓIɂǂ̂悤ɏo͂邩słB
 *	  ]āAL̕ύX́AʓIȏn̏o͌ʂɍ킹̂ł͂ȂÅoŎRȏo͌ʂƎvdlɂ̂łB
 *	  XAO؂CWCu̎dlɂ͊܂܂ĂȂ(?vmF)̂ŁẢ߂ŎĂ傫Ȗ͖Ǝv܂B
 *	* Wed Dec 14 21:49:23 JST 2016 Naoyuki Sawa
 *	- tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
 *	  ܂ł́Auprintf("%#x",0)vA"0x0"o͂Ă܂Ă܂B
 *	  ۂɂꂪɂȂP[X͏Ȃ̂łAɂ̓tO'#'w肳Ăl0ȂΊ\sȂ̂dlłB
 *	  ōAuprintf("%#x",0)v́A"0"o͂悤ɏC܂B
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

					// Ӗ		၁
#define FL_LJUST	(1 <<  0)	// l		%-5d
#define FL_ZEROFILL	(1 <<  1)	// 0l		%05d
#define FL_SIGN		(1 <<  2)	// +/-\		%+5d
#define FL_SPACE	(1 <<  3)	// /-\		% 5d
#define FL_ALT		(1 <<  4)	// 0/0x/0X\		%#x
#define FL_SHORT	(1 <<  5)	// n[t[h	%hd
#define FL_LONG_LONG	(1 <<  6)	// 64rbg		%lld				//{{2015/01/22ύX:Cq'll'Ή܂B}}
#define FL_PRECSPEC	(1 <<  7)	// xw肠		%9.5f
#define FL_SIGNEDCONV	(1 <<  8)	// 		%d
#define FL_THOUSANDS	(1 <<  9)	// O؂		%'d				//{{2016/02/23ǉ:O؂̃tOu'vΉ܂B}}
#define FL_NOMORE	(1 << 31)	// igpj

/* widthprecision擾܂B */
static const char*
gnum(const char* fmt, int* ip, va_list* app)
{
	int i, c;

	if(*fmt == '*') {
		*ip = va_arg(*app, int);
		fmt++;
	} else {
		i = 0;
		for(;;) {
			c = *fmt;
			if(c < '0' || '9' < c) break;
			i = i * 10 + (c - '0');
			fmt++;
		}
		*ip = i;
	}

	return fmt;
}

//{{2016/02/23ǉ:O؂̃tOu'vΉ܂B
///* l\܂B */
//static char*
//i_compute(unsigned val, int base, char* s, int precision)
//{
//	int c;
//
//	c = val % base;
//	val /= base;
//	if(val || precision > 1) s = i_compute(val, base, s, precision - 1);
//	*s++ = c < 10 ? '0' + c : 'a' + (c - 10);
//
//	return s;
//}
//2016/02/23ǉ:O؂̃tOu'vΉ܂B
/* l\܂B */
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//static char* i_compute(unsigned val, int base, char* s, int precision, int thousands) {
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
static char* i_compute(uint64_t val, int base, char* s, int precision, int thousands) {
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
	//݂̌̒l߂B
	int c = val % base;
	//ʂ̌̒l߂B
	val /= base;
	//ʂ̌̒lcĂ邩,,precisioncĂc
	// - precisionľ傫ꍇAprecision͊0ȉɂȂĂ\L鎖ɒӂB
	if(val || (precision > 1)) {
		//ʂ̌ɂčċAB
		s = i_compute(val, base, s, (precision - 1), (thousands + 1));
		//݂̌(3N+2)Ȃ΁Aʂ̌(3N)ƌ݂̌(3N+2)̊ԂɎO؂o͂B
		// - ŖIɁAO؂̃tOu'vw肳ꂽǂ𔻒fKv͖BR͈ȉ̒ʂłB
		//   O؂̃tOu'vw肳ĂȂꍇAthousands̏lINT_MINłAċAɃvẌɂȂ鎖͖B
		//   }CiẌthousandsɑ΂(thousands%3)̌ʂ̓}CiXɂȂA((thousands%3)==2)鎖͖łB
		if((thousands % 3) == 2) { *s++ = ','; }
	}
	//݂̌̒lo͂B
	*s++ = ((c < 10) ? '0' : ('a' - 10)) + c;
	//ŌɊi[̎̈ʒuԂB
	return s;
}
//}}2016/02/23ǉ:O؂̃tOu'vΉ܂B

/* \܂B */
static char*
o_print(char* s, int flags, int nrdigits, int c, va_list* app)
{
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//	unsigned val;
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
	int64_t val;
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
	int base;
	char *old_s = s;

	/* l擾B */
	       if(flags & FL_LONG_LONG) {
//{{2016/08/04ύX:__int64long longRpCŎgĂAint64_tŋʉ܂B
//#ifdef  _MSC_VER
//		                            val = va_arg(*app, unsigned __int64  );		//{{2015/01/22ύX:Cq'll'Ή܂B}}
//#else //_MSC_VER
//		                            val = va_arg(*app, unsigned long long);		//{{2015/01/22ύX:Cq'll'Ή܂B}}
//#endif//_MSC_VER
//2016/08/04ύX:__int64long longRpCŎgĂAint64_tŋʉ܂B
		                            val = va_arg(*app, int64_t);
//}}2016/08/04ύX:__int64long longRpCŎgĂAint64_tŋʉ܂B
	} else if(flags & FL_SHORT    ) {
		if(flags & FL_SIGNEDCONV) { val = va_arg(*app,          short    ); }
		else                      { val = va_arg(*app, unsigned short    ); }
	} else {
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//		                            val = va_arg(*app, unsigned          );
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
		if(flags & FL_SIGNEDCONV) { val = va_arg(*app,          int      ); }
		else                      { val = va_arg(*app, unsigned int      ); }
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
	}

	/* \B */
	if(flags & FL_SIGNEDCONV) {
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//		if((int)val < 0) {
//			*s++ = '-';
//			val = -(int)val;
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
		if(val < 0) {
			*s++ = '-';
			val = -val;
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
		} else if(flags & FL_SIGN) {
			*s++ = '+';
		} else if(flags & FL_SPACE) {
			*s++ = ' ';
		}
	}

	/* \B */
//{{2016/12/14ύX:tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
//	if(flags & FL_ALT) {
//2016/12/14ύX:tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
	if((flags & FL_ALT) && (val != 0)) {
//}}2016/12/14ύX:tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
		switch(c) {
	    //{{2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
		case 'b':
		case 'B': *s++ = '0'; *s++ = 'b'; break;
	    //}}2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
		case 'o': *s++ = '0';             break;
		case 'p':
		case 'x':
		case 'X': *s++ = '0'; *s++ = 'x'; break;
		}
	}

	/* l\B */
	switch(c) {
	case 'b':
	case 'B': base =  2; break;
	case 'o': base =  8; break;
	case 'd':
	case 'i':
	case 'u': base = 10; break;
	case 'p':
	case 'x':
	case 'X': base = 16; break;
	default : base = -1; DIE();
	}
    //{{2016/02/23ǉ:O؂̃tOu'vΉ܂B
    //	s = i_compute(val, base, s, nrdigits);
    //2016/02/23ǉ:O؂̃tOu'vΉ܂B
	s = i_compute(val, base, s, nrdigits, (flags & FL_THOUSANDS) ? 0 : INT_MIN);	//O؂̃tOu'vw肳Ăthousands̏l0Aw肳ĂȂthousands̏lINT_MINƂBڍׂi_compute()̃RgQƂĉB
    //}}2016/02/23ǉ:O؂̃tOu'vΉ܂B
    //{{2015/08/02ύX:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
    //	if(c == 'X') {
    //2015/08/02ύX:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
	if(isupper(c)) {
    //}}2015/08/02ύX:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
		while(old_s != s) {
			*old_s = toupper(*old_s);
			old_s++;
		}
	}

	return s;
}

/* \܂B */
static char*
f_print(char* s, int flags, int precision, va_list* app)
{
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//	double val;
//	int c;
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
	double val, ival;
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B

	/* l擾B */
	val = va_arg(*app, double);

	/* \B */
	if(val < 0) {
		*s++ = '-';
		val = -val;
	} else if(flags & FL_SIGN) {
		*s++ = '+';
	} else if(flags & FL_SPACE) {
		*s++ = ' ';
	}

	/* ľܓp+0.5or0.05or0.005... */
	val += pow(10, -precision) / 2;

	/* \B */
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//	c = (int)val;
////{{2012/01/31:Βl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC
////	val -= c;
////2012/01/31:Βl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC
//	val -= (unsigned)c;
////}}2012/01/31:Βl2147483648.0(=INT_MAX+1)ȏ̎\ƕoOC
//    //{{2016/02/23ǉ:O؂̃tOu'vΉ܂B
//    //	s = i_compute(c, 10, s, 1);
//    //2016/02/23ǉ:O؂̃tOu'vΉ܂B
//	s = i_compute(c, 10, s, 1, (flags & FL_THOUSANDS) ? 0 : INT_MIN);	//O؂̃tOu'vw肳Ăthousands̏l0Aw肳ĂȂthousands̏lINT_MINƂBڍׂi_compute()̃RgQƂĉB
//    //}}2016/02/23ǉ:O؂̃tOu'vΉ܂B
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
	val = modf(val, &ival);
	s = i_compute(ival, 10, s, 1, (flags & FL_THOUSANDS) ? 0 : INT_MIN);	//O؂̃tOu'vw肳Ăthousands̏l0Aw肳ĂȂthousands̏lINT_MINƂBڍׂi_compute()̃RgQƂĉB
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B

	/* \B */
	if(precision) {
		*s++ = '.';
		do {
//{{2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
//			val *= 10;
//			c = (int)val;
//			val -= c;
//			*s++ = '0' + c;
//2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
			val = modf(val * 10.0, &ival);
			*s++ = '0' + (int)ival;
//}}2016/08/04ύX:32rbg͈̔͂𒴂64rbgl̕\ɐΉ܂B
		} while(--precision);
	}

	return s;
}

static int
//doprnt(char* out, const char* fmt, va_list ap)
//~2006/07/13 snprintf(),vsnprintf()Ή
//~
//~- snprintf(),vsnprintf()ΉɂāAdoprnt()̈Ƀobt@TCY(cnt)ǉ̂łȂAobt@̃|C^(end)ǉ悤݌vŔA
//~  Avsprintf()̗pɁAobt@\̂eՂłB(obt@̖̃|C^́A((char*)-1)ƕ\܂B)
//~  ܂Adoprnt()̎ɂĂAcobt@TCYǗȀo͈ʒu(out)obt@(end)𒴂ĂȂȒPłB
//~
//~- snprintf()ȉ̂悤ɌĂяoꍇA
//~
//~	char buf[10];
//~	snprintf(buf, 10, fmt, ...);
//~
//~  doprnt()ւ̈out,end́A}̂悤ȈʒuwĂ܂B
//~
//~	buf[0][1][2][3][4][5][6][7][8][9]
//~	    |                          |
//~	   out                        end
//~
//~  end(obt@̖)łA(obt@̖+1)ł͂ȂƂɒӂĂB
//~  I[nul܂܂ȂALȕi[ł̂́A(out`end-1)͈̔͂ƂȂ܂B
//~
//~- I[nul܂܂ȂLȕ(out`end-1)͈̔͂Ɏ܂ꍇAnuli[Anul܂܂ȂԂ܂B
//~  I[nul܂܂ȂLȕ(end-1)𒴂ꍇA(end-1)ȍ~؂̂Ă(end)nuli[A(-1)Ԃ܂B
//~
//~- Asnprintf()obt@TCY0ŌĂяoꍇA
//~
//~	snprintf(buf, 0, fmt, ...);
//~
//~  doprnt()ւ̈out,end́AendoutOwĂ܂B
//~
//~	buf[-1][0]
//~	    |   |
//~	   end out
//~
//~  ̏ꍇAI[nuli[ɁA(-1)Ԃ܂B
//~
//* Thu Oct 02 01:02:39 JST 2014 Naoyuki Sawa
//- snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//
//  ɔAdoprnt()̈end̎dlA(obt@̖)(obt@̖+1)ɕύX܂B
//  usnprintf(NULL,0,fmt,...)vĂяoꂽꍇɁA(out=0x00000000,end=0xFFFFFFFF)ɂȂ邽߂łB
//
//  OUT(C)}NAobt@I[nuli[ʒu܂ŁAi[Ă܂ƂɂȂ܂AŌnulŏ㏑̂Ŗ肠܂B
//  uif(out<end)v̏uif(out<(end-1))vɕύXĂǂ̂łAR[hTCŶŁAs܂łB
//  Oq̂ƂAuif(out<end)v̂܂܂łAʂ͓ɂȂ̂Ŗ肠܂B
//
//  ́Aoutend̎wʒúAȉ̂悤ɂȂ܂B
//
//- snprintf()ȉ̂悤ɌĂяoꍇA
//
//	char buf[10];
//	snprintf(buf, 10, fmt, ...);
//
//  doprnt()ւ̈out,end́A}̂悤ȈʒuwĂ܂B
//
//	buf[0][1][2][3][4][5][6][7][8][9](10)
//	    |                             |
//	   out                           end
//
//- Asnprintf()obt@TCY0ŌĂяoꍇA
//
//	snprintf(buf, 0, fmt, ...);
//
//  doprnt()ւ̈out,end́AǂʒuwĂ܂B
//
//	buf[0]
//	    |
//	 out,end 
//
doprnt(char* out, char* end, const char* fmt, va_list ap)
{
//{{2014/10/12ǉ:W[VC++6.0ŃrhꍇAOUT̒`Windowswb_t@Curpcdce.hvƏՓ˂邽߁AOUT\ߒ`܂B
#ifdef  WIN32
#undef  OUT
#endif//WIN32
//}}2014/10/12ǉ:W[VC++6.0ŃrhꍇAOUT̒`Windowswb_t@Curpcdce.hvƏՓ˂邽߁AOUT\ߒ`܂B
/*{{2006/07/13 snprintf(),vsnprintf()Ή*/
#define OUT(C)				\
	do {				\
		char __c__ = (C);	\
		if(out < end) {		\
			*out = __c__;	\
		}			\
		out++;			\
	} while(0)
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/

	int c, pad, len, flags, width, precision, zfill;
	char buf[256];	/* l̏o͕␸x̃TCY𒴂ƈُ퓮삵܂B */
	char *s, *old_s;
	char *old_out = out;

	/* 𑖍āc */
	while((c = *fmt++) != '\0') {
		/* w%[flags][width][.precision][h|l]typexłȂ΂̂܂ܕ\B */
		if(c != '%') {
			//*out++ = c;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(c);
			continue;
		}

		/* [flags]擾B */
		flags = 0;
		do {
			switch(*fmt) {
			case '-':  flags |= FL_LJUST;     break;	/* l */
			case '0':  flags |= FL_ZEROFILL;  break;	/* 0l */
			case '+':  flags |= FL_SIGN;      break;	/* +/-\ */
			case ' ':  flags |= FL_SPACE;     break;	/* /-\ */
			case '#':  flags |= FL_ALT;       break;	/* 0/0x/0X\ */
			case '\'': flags |= FL_THOUSANDS; break;	/* O؂ */	//{{2016/02/23ǉ:O؂̃tOu'vΉ܂B}}
			default :  flags |= FL_NOMORE;    continue;
			}
			fmt++;
		} while(!(flags & FL_NOMORE));
		if((flags & FL_LJUST) && (flags & FL_ZEROFILL)) DIE();
		if((flags & FL_SIGN ) && (flags & FL_SPACE   )) DIE();

		/* [width]擾B */
		fmt = gnum(fmt, &width, &ap);
		if(*fmt == '.') {
			fmt++;
			fmt = gnum(fmt, &precision, &ap);
			flags |= FL_PRECSPEC;
		}

//{{2016/09/04ύX:Cqj,z,tΉ܂BCqhh͖Ήł鎖𖾎IɎ߂ɃG[I悤ɂ܂B
//		/* [h|l]擾B */
//		switch(*fmt) {
//		case 'h': flags |= FL_SHORT; fmt++; break;
//		case 'l': fmt++; if(*fmt == 'l') { flags |= FL_LONG_LONG; fmt++; } break;	//{{2015/01/22ύX:Cq'll'Ή܂B}}
//		case 'L': DIE(); /* long double ͖Ή */
//		}
//2016/09/04ύX:Cqj,z,tΉ܂BCqhh͖Ήł鎖𖾎IɎ߂ɃG[I悤ɂ܂B
		/* [h|l|ll|j|z|t]擾B */
		switch(*fmt) {
		case 'h': flags |= FL_SHORT; fmt++; if(*fmt == 'h') { /* [un]signed char͖Ή */ DIE(); } break;
		case 'l': /** no job **/     fmt++; if(*fmt == 'l') { flags |= FL_LONG_LONG; fmt++; } break;
		case 'L': DIE(); /* long double ͖Ή */
#ifndef _WIN64
		case 'j': //ϊɑΉintmax_tuintmax_tŁAnϊɑΉintmax_tւ̃|C^[ł邱ƂB
			flags |= FL_LONG_LONG; fmt++;
			break;
		case 'z': //ϊɑΉsize_tssize_tŁAnϊɑΉsize_tւ̃|C^[ł邱ƂB
		case 't': //ϊɑΉptrdiff_tŁAnϊɑΉptrdiff_tւ̃|C^[ł邱ƂB
	//{{2016/10/02C:doprnt()32rbgł̏ɂāACqz,tǂݔ΂ĂȂoOC܂B
	//		/** no job **/
	//2016/10/02C:doprnt()32rbgł̏ɂāACqz,tǂݔ΂ĂȂoOC܂B
			fmt++;
	//}}2016/10/02C:doprnt()32rbgł̏ɂāACqz,tǂݔ΂ĂȂoOC܂B
			break;
#else //_WIN64
		case 'j': //ϊɑΉintmax_tuintmax_tŁAnϊɑΉintmax_tւ̃|C^[ł邱ƂB
		case 'z': //ϊɑΉsize_tssize_tŁAnϊɑΉsize_tւ̃|C^[ł邱ƂB
		case 't': //ϊɑΉptrdiff_tŁAnϊɑΉptrdiff_tւ̃|C^[ł邱ƂB
			flags |= FL_LONG_LONG; fmt++;
			break;
#endif//_WIN64
		}
//}}2016/09/04ύX:Cqj,z,tΉ܂BCqhh͖Ήł鎖𖾎IɎ߂ɃG[I悤ɂ܂B

		s = old_s = buf;
		switch(c = *fmt++) {
		default:
			//*out++ = c;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(c);
			continue;
		case 'n':
			       if(flags & FL_LONG_LONG) {
//{{2016/08/04ύX:__int64long longRpCŎgĂAint64_tŋʉ܂B
//#ifdef  _MSC_VER
//				*va_arg(ap, __int64  *) = (__int64  )(out - old_out);		//{{2015/01/22ύX:Cq'll'Ή܂B}}
//#else //_MSC_VER
//				*va_arg(ap, long long*) = (long long)(out - old_out);		//{{2015/01/22ύX:Cq'll'Ή܂B}}
//#endif//_MSC_VER
//2016/08/04ύX:__int64long longRpCŎgĂAint64_tŋʉ܂B
				*va_arg(ap, int64_t*) = (int64_t)(out - old_out);
//}}2016/08/04ύX:__int64long longRpCŎgĂAint64_tŋʉ܂B
			} else if(flags & FL_SHORT    ) {
				*va_arg(ap, short    *) = (short    )(out - old_out);
			} else {
				*va_arg(ap, int      *) = (int      )(out - old_out);
			}
			continue;
		case 'c':
			*s++ = va_arg(ap, int);
			break;
		case 's':
			old_s = va_arg(ap, char*);
			if(old_s == NULL) old_s = "(null)";
			s = old_s;
			while(*s != '\0') {
				if(flags & FL_PRECSPEC) {
					if(!precision) break;
					precision--;
				}
				s++;
			}
			break;
		case 'b':
		case 'B':
		case 'o':
		case 'u':
		case 'p':
		case 'x':
		case 'X':
//{{2016/09/04ǉ:64rbgłł́Aϊwqp64rbgƉ߂悤ɂ܂B32rbgł̓ɂ͉eL܂B
#ifdef  _WIN64
			if(c == 'p') { flags |= FL_LONG_LONG; }
#endif//_WIN64
//}}2016/09/04ǉ:64rbgłł́Aϊwqp64rbgƉ߂悤ɂ܂B32rbgł̓ɂ͉eL܂B
			if(!(flags & FL_PRECSPEC)) precision = 1;
			s = o_print(s, flags, precision, c, &ap);
			break;
		case 'd':
		case 'i':
			flags |= FL_SIGNEDCONV;
			if(!(flags & FL_PRECSPEC)) precision = 1;
			s = o_print(s, flags, precision, c, &ap);
			break;
		case 'f':
		case 'e': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'E': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'g': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'G': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
			flags |= FL_SIGNEDCONV;
			if(!(flags & FL_PRECSPEC)) precision = 6;
			s = f_print(s, flags, precision, &ap);
/*{{2011/11/16ǉ 'g'(y'G')ȈՑΉ*/
			/* * Wed Nov 16 02:21:10 JST 2011 Naoyuki Sawa
			 * - ^tB[h'g'(y'G')ɊȈՑΉ܂B
			 * - {́A'g'(y'G')̓́Aȉ̂ƂłB
			 *   @ lɂāA'f''e'('E')̏AIB
			 *   A x́Ǎł͂ȂA+̌łB
			 *   B ̖ɂ'0'(S'0'Ȃ'.')A\ȂB
			 * - 'g'(y'G')p闝ŔAB̖ړIł悤łB
			 *   ṓA@A͑ΉAB݂̂ȈՑΉ܂B
			 * - 'g'(y'G')̎gpƂẮALUAꂪ'g'gpĂ܂B
			 *   LUA͑SĂ̐lłA'g'gpĐl\Ă邽߁A̖ĺAł邩̂悤ɕ\̂łB
			 */
			if((c == 'g') || (c == 'G')) {
				/* x0łȂ΁Af_print()̏ŁA'.'ƏȂƂꌅ̏AsɊi[Ă͂B */
				if(precision) {
					/* sɊi[ꂽ񂩂A'0'ƁAS'0'Ȃ'.'菜B */
					for(;;) {
						/* ꕶO'.'Ȃ΁A'.'菜āAB */
						       if(*(s - 1) == '.') {
							s--;
							break;
						/* ꕶO'0'Ȃ΁A'0'菜āApB */
						} else if(*(s - 1) == '0') {
							s--;
						/* ꕶO'1'`'9'Ȃ΁A菜ɁAB */
						} else {
							break;
						}
					}
				}
			}
/*}}2011/11/16ǉ 'g'(y'G')ȈՑΉ*/
			break;
		}

		zfill = (flags & FL_ZEROFILL) ? '0' : ' ';
		len = s - old_s;
		pad = width - len;
		if(pad > 0) {
			if(!(flags & FL_LJUST)) {
				/* (+/-/)Ɗ(0/0x/0X)0l߂ɐs܂B */
				if(flags & FL_ZEROFILL) {
					if(flags & FL_SIGNEDCONV) {
						switch(*old_s) {
						case '+':
						case '-':
						case ' ':
							//*out++ = *old_s++;
							//2006/07/13 snprintf(),vsnprintf()Ή
							OUT(*old_s++);
							len--;
							break;
						}
					}
//{{2016/12/14ύX:tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
//					if(flags & FL_ALT) {
//2016/12/14ύX:tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
					if((flags & FL_ALT) && (len >= 2)) {	//̏ꏊł́Al0ǂ𒼐ړIɔoȂ̂ŁAo_print()̏o͕ɂĔ肷鎖ɂBl0Ȃ΁AFL_ALTw肳ĂĂo_print()̏o͌ʂ"0"ƂȂA(len == 1)ƂȂĂ͂B]Ă̏ꏊł́A(len >= 2)𔻒肷鎖ɂāAl0P[XOoB
//}}2016/12/14ύX:tO'#'w肳ĂAl0ȂΊ\sȂ悤ɏC܂B
						//switch(c) {
						//case 'o':
						//	*out++ = *old_s++;
						//	len--;
						//	break;
						//case 'p':
						//case 'x':
						//case 'X':
						//	*out++ = *old_s++;
						//	*out++ = *old_s++;
						//	len -= 2;
						//	break;
						//}
						//2006/07/13 snprintf(),vsnprintf()Ή
						switch(c) {
					    //{{2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
						case 'b':
						case 'B':
					    //}}2015/08/02ǉ:ϊwq'b'ɑ΂ĂtO'#'wo悤ɂ܂B'%#b'̏ꍇ'0b','%#B'̏ꍇ'0B's܂B̓Perlsprintf֐Ɍ݊łB
						case 'p':
						case 'x':
						case 'X':
							OUT(*old_s++);
							len--;
							/* FALLTHRU */
						case 'o':
							OUT(*old_s++);
							len--;
							break;
						}
					}
				}
//{{2016/10/18ύX:0l,,O؂Ȃ΁A0l߂ɂO؂܂߂悤ɂ܂B
//				/* 󔒂܂0l߁B */
//				while(pad > 0) {
//					//*out++ = zfill;
//					//2006/07/13 snprintf(),vsnprintf()Ή
//					OUT(zfill);
//					pad--;
//				}
//2016/10/18ύX:0l,,O؂Ȃ΁A0l߂ɂO؂܂߂悤ɂ܂B
				/* 󔒂܂0l߁B */
				if(pad > 0) {
					//0l,,O؂Ȃ΁A0l߂ɂO؂܂߂B
					if((flags & FL_ZEROFILL) && (flags & FL_THOUSANDS)) {
						//0l߂̒ォAŏ̎O؂,,_,,ȍ͕I[܂łɁAL邩𐔂B
						// - vɁA0l߂̒ォ\o͕̐擪ɁAO؂̒[AL邩𐔂B
						// - A"%'09s"̂悤ȕsȎw肪ꂽꍇ̏ʂ邪AxƂȍ͕I[Ŕ̂ňSłB
						//   '%s'̑ΏۂƂȂ镶̓r',''.'܂܂Ăꍇ͈Ӑ}Ȃo͂ɂȂ邪AX'%s'ƎO؂𕹗p̂ԈႢȂ̂ŎdB
						//   ̏ꍇo͌ʂsɂȂ̂̓AvP[V̖łA֐̏ƂĂ̓jvO~ȂΖ薳B
						int thousands;
						for(thousands = 0; thousands < len; thousands++) {
							if((old_s[thousands] == ',') ||
							   (old_s[thousands] == '.')) { break; }
						}
						do {
							//L̏ŋ߂ƁAc0lߕ𑫂āA4̔{Ȃ΁AO؂\B
							//ȊOȂ΁A0\B
							if((thousands + pad) % (3 + 1/*','*/)) {
								OUT('0');
							} else {
								OUT(',');
							}
						} while(--pad);
					//0l,,O؂łȂ΁Aʏ0l,,󔒋l߂sB
					} else {
						do {
							OUT(zfill);
						} while(--pad);
					}
				}
//}}2016/10/18ύX:0l,,O؂Ȃ΁A0l߂ɂO؂܂߂悤ɂ܂B
			}
		}
		while(len > 0) {
			//*out++ = *old_s++;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(*old_s++);
			len--;
		}
		while(pad > 0) {
			//*out++ = zfill;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(zfill);
			pad--;
		}
	}

//{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//	//*out = '\0'; /* I[NULYꂸ! */
//	//return out - old_out;
//	//2006/07/13 snprintf(),vsnprintf()Ή
//	if(out <= end) {
//		*out = '\0';
//		return out - old_out;
//	} else {
//		if(end >= old_out) {
//			*end = '\0';
//		} else {
//			/* obt@TCY0ȉ̏ꍇ́Anuli[ȂB */
//		}
//		return -1;
//	}
//2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
	if(out < end) {
		*out = '\0';
	} else {
		if(end > old_out) {
			*(end - 1) = '\0';
		} else {
			/* obt@TCY0ȉ̏ꍇ́Anuli[ȂB */
		}
	}
	return out - old_out;	//obt@s(-1)łȂu\ȃXy[XΏ܂ꂽł낤̌vԂ܂B
//}}2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B

/*{{2006/07/13 snprintf(),vsnprintf()Ή*/
#undef OUT
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/
}

/****************************************************************************
 *
 ****************************************************************************/
//{{2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
// * Sun May 29 21:54:56 JST 2016 Naoyuki Sawa
// - Visual C++ .NETŃRpCɁAvsprintf()ŌxC4028\܂B
//   ڍׂ́Aȉ̒ʂłB
// - VC++2015œCuRpCĂ݂ACu̎Œu邽߂́Avsprintf()ŌxC4028\܂B
//   ́AVC++2015ł́Å֐̃vg^CvAWIȃvg^CvƈقȂĂ鎖łB
//   ȉɁAVC++2015ł́Avsprintf()̐錾܂B(̊֐lł)
//   c:\Program Files (x86)\Windows Kits\10\Include\10.0.10240.0\ucrt\stdio.h
//   _CRT_STDIO_INLINE int __CRTDECL vsprintf(
//       _Pre_notnull_ _Post_z_        char*       const _Buffer,
//       _In_z_ _Printf_format_string_ char const* const _Format,
//                                     va_list           _ArgList
//       )
//   WIȃvg^Cvł́A'char*','char const*'łAVC++2015ł͑'char* const','char const* const'ɂȂĂ܂B
//   (Ȃ݂ɁAMSDN̊֐t@Xł͑O҂ɂȂĂAVC++2015̃wb_t@C҂̐錾ł悤łB)
// - Ώ@́Aލl܂B
//   E́AVisual C++ .NETȂ΁AW[̊֐̈^ύXāAVisual C++ .NET̊֐vg^Cvɍ킹鎖łB
//   E́AVisual C++ .NETȂ΁Ax𖳎@łB
//   {͑O҂̕SȂ̂ł傤ǁA͌҂̕@gɂ܂B
//   ̖͖炩Visual C++ .NET̖łA̖ɑΏ邽߂ɑ̊֐̒`RpC肵āAR[hGɂȂ̂͗ǂȂƎvłB
// - {Aclipprnt.cclipscan.cɁA@őΏs܂B
//   AΏ@ύXꍇ́AɂāAύXKvL邩ĉB
#if     (defined(_MSC_VER) && (_MSC_VER > 1200))
//{{2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
//#pragma warning(disable: 4028)	//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#pragma warning(push)
#pragma warning(disable: 4028)		//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//}}2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#endif//(defined(_MSC_VER) && (_MSC_VER > 1200))
//}}2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
/****************************************************************************
 *
 ****************************************************************************/

/* u#include <piece.h>v̑OɁu#define NOPCESPRINTFvYꂸɁI */

/* P/ECEJ[l܂EPSONCů֐u܂B */
int
vsprintf(char* out, const char* fmt, va_list ap)
{
	//return doprnt(out, fmt, ap);
	//2006/07/13 snprintf(),vsnprintf()Ή
	return doprnt(out, (char*)-1/*obt@̖*/, fmt, ap);	//{{2014/10/02l:ɂ͍L̎wł͖obt@[0xFFFFFFFF]܂܂܂B{[0xFFFFFFFF]܂ގ͍lȂ̂Ŏ肠܂B}}
}

/* P/ECEJ[l܂EPSONCů֐u܂B */
int
sprintf(char* out, const char* fmt, ...)
{
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vsprintf(out, fmt, ap);
	va_end(ap);
	return n;
}

/*{{2006/07/13 snprintf(),vsnprintf()Ή*/

/* * Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 * - vsnprintf()ǉ܂B
 *   P/ECEJ̃Cuɂ́Avsnprintf()܂܂Ă܂B
 * - vsnprintf()́AC99ɂĐɒǉꂽ֐łB
 *   C99ɏĂȂRpCł́Avsnprintf()T|[gĂȂAĂꍇ܂B
 *   ƂVC++6.0_vsnprintf()́Ao͕(n-1)𒴂ꍇ̋Ă܂B
 *   o͕(n-1)𒴂ꍇAC99̎dlł́A(n-1)܂ŕo͂A(n)ڂnuli[܂B
 *   ɑ΂VC++6.0̎dlł́A(n)܂ŕo͂Anuli[܂B(strncpy()ɎłB)
 *   C99̎dl̕Ao͕񂪊mnulI[̂ŁAgՂƎv܂B
 *   ̎́AC99̎dlɏ]܂B
 * - C99VC++6.0̋̈ႢTvR[hAȉɎ܂B
 *   ȉ̃TvR[hsnprintf()̗łAvsnprintf()lłB
 *
 *	main() {
 *	    char buf[] = "0123456789";
 *	    snprintf(buf, 5, "ABCDEFG");     // C99̋c
 *	    printf("<%s>\n", buf);           //   ʁuABCDv
 *	    _snprintf(buf, 5, "ABCDEFG");    // VC++6.0̋c
 *	    printf("<%s>\n", buf);           //   ʁuABCDE56789v
 *	}
 *
 * - QluvO~O C ̐V@\ (http://seclan.dll.jp/c99d/c99d08.htm#dt19991115)v
 *	
 *	O	int vsnprintf(char * restrict s, size_t n, const char * restrict format, va_list arg);		
 *	
 *	wb_stdio.h												
 *	
 *		s      : o͐obt@										
 *		n      : o͐obt@̕									
 *		format : 												
 *		arg    : va_start ŏl									
 *	
 *	߂lo͂BI[̃k͊܂܂ȂBG[͕̒lB							{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bobt@s(-1)łȂu\ȃXy[XΏ܂ꂽł낤̌vԂ܂BG[邱Ƃ͖̂Ŏ(-1)Ԃ邱Ƃ͗L܂Bڍׂ́uThu Oct 02 01:02:39 JST 2014ṽRgQƂĂB}}
 *	
 *		vsprintf  o͕ΉŁBformat ɏ] s ɍő n - 1 o͂B		
 *		n - 1 ȏo͂ꂽꍇ͔jBs ̏I[ɂ̓ktB				
 *		Ql : wchar_t 󂯕t֐ vswprintf A̓obt@włdlɂȂĂB	
 *	
 */
int
//{{2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂BC̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łAVC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
//vsnprintf(char* out, int cnt, const char* fmt, va_list ap)
//2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂BC̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łAVC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
vsnprintf(char* out, size_t cnt, const char* fmt, va_list ap)
//}}2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂BC̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łAVC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
{
//{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//	return doprnt(out, out + cnt - 1/*obt@̖*/, fmt, ap);
//2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
	return doprnt(out, (out + cnt)/*obt@̖+1*/, fmt, ap);
//}}2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
}

/* * Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 * - snprintf()ǉ܂B
 *   P/ECEJ̃Cuɂ́Asnprintf()܂܂Ă܂B
 * - VC++6.0_snprintf()Ƃ̋̈ႢɂẮAvsnprintf()ƓlłB
 *   vsnprintf()̃RgQƂĂB
 *
 * - QluvO~O C ̐V@\ (http://seclan.dll.jp/c99d/c99d08.htm#dt19991115)v
 *	
 *	O	int snprintf(char * restrict s, size_t n, const char * restrict format, ...);				
 *	
 *	wb_stdio.h												
 *	
 *		s      : o͐obt@										
 *		n      : o͐obt@̕									
 *		format : 												
 *		...    : Ŏw肵l										
 *	
 *	߂lo͂BI[̃k͊܂܂ȂBG[͕̒lB							{{2014/10/02ύX:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bobt@s(-1)łȂu\ȃXy[XΏ܂ꂽł낤̌vԂ܂BG[邱Ƃ͖̂Ŏ(-1)Ԃ邱Ƃ͗L܂Bڍׂ́uThu Oct 02 01:02:39 JST 2014ṽRgQƂĂB}}
 *	
 *		sprintf ̏o͕wŁBformat ɏ] s ɍő n - 1 o͂B		
 *		n - 1 ȏo͂ꂽꍇ͔jBs ̏I[ɂ̓ktB				
 *		Ql : wchar_t 󂯕t֐ swprintf A̓obt@włdlɂȂĂB	
 *	
 */
int
//{{2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂BC̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łAVC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
//snprintf(char* out, int cnt, const char* fmt, ...)
//2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂BC̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łAVC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
snprintf(char* out, size_t cnt, const char* fmt, ...)
//}}2016/05/28ύX:snprintf(),vsnprintf()̈cnť^intsize_tɏC܂BC̕WdlɉĂ܂BVC++6.0ł̓RpCvsnprintf()ĂȂ̂ŕWdlƈقȂ^łG[͏oȂ̂łAVC++.NETł̓RpCvsnprintf()Ă̂ň^قȂƃG[ɂȂłB̏Cɂ铮̕ω͗L܂BAVisual C++ .NETֈڍs邽߂̏łB
{
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vsnprintf(out, cnt, fmt, ap);
	va_end(ap);
	return n;
}
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/

/****************************************************************************
 *
 ****************************************************************************/

//{{2014/10/02ǉ:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bscprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B

//	* Thu Oct 02 01:02:39 JST 2014 Naoyuki Sawa
//	- snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂B
//	  scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B
//	  ڍׂ́Aȉ̍ڂQƂĂB
//	- ܂ŁAI[nul̋ɂĂC99ɂĂ̂łAsnprintf̃obt@s̖߂l̋VC++6.0̋ɂȂĂ܂Ă܂B
//	  C99(yGCC)́u\ȃXy[XΏ܂ꂽł낤̌vԂ܂BVC++6.0́u̒l(ۂɂ-1)vԂ܂BcQl@
//	  snprintf̃obt@s̖߂l̋AC99֗̕ł邽߁AC99ɕύX邱Ƃɂ܂B
//	- ̕ύXÃvOɉe\邽߁AӂĂB
//	  Cuł́Acliptime.cstrftime()ɉeL߁Astrftime()C܂B
//	  ́Asnprintf̖߂lobt@s𔻒fɂ́Auretval<0vł͂Ȃu(unsigned)retval>=(unsigned)cntvƂĂB
//	- VC++łA_vscprintfgp邱ƂŁAC99̋V~[g邱Ƃł܂BcQlA
//	  AVC++6.0ɂ_vscprintf͗L܂B(Visual Studio 2005ȍ~Œǉꂽ悤łB)
//	  _vscprintf́APƂł֗Ȃ̂ŁAP/ECEVC++6.0łgpł悤ACuŎ邱Ƃɂ܂B
//	- _vscprintfƃmۂ𕹗pƁAtH[}bgWJobt@̊mۂs܂BcQlB
//	  GCCɂ́AL܂Ƃ߂čs֐ƂāAasprintfL܂BcQlC
//	  ֗Ȃ̂ŁAP/ECEVC++6.0łgpł悤ACuŎ邱Ƃɂ܂B
//	  ȂAG[strp̋́AFreeBSD̎Ɍ݊ƂAG[̍ۂɂstrpNULLɃZbg邱Ƃɂ܂B
//	- asprintfgƁA̕AāAVubN쐬邱Ƃł܂B
//	  strdup()strcat()𓯎ɍs悤ȊłBcQlD
//	
//	Ql@uStack Overflowv(http://stackoverflow.com/)́Awsnprintf and Visual Studio 2010x(http://stackoverflow.com/questions/2915672/snprintf-and-visual-studio-2010)̃y[Wp:
//	Microsoft says its customers aren't pressuring enough for C99 support. But with snprintf part of C++11, you're likely to see it implemented by 2014.
//	Until then, you can simulate (v)snprintf like this:
//	#ifdef  _MSC_VER
//	#define snprintf c99_snprintf
//	inline int c99_snprintf(char* str, size_t size, const char* format, ...) {
//	  int count;
//	  va_list ap;
//	  va_start(ap, format);
//	  count = c99_vsnprintf(str, size, format, ap);
//	  va_end(ap);
//	  return count;
//	}
//	inline int c99_vsnprintf(char* str, size_t size, const char* format, va_list ap) {
//	    int count = -1;
//	    if(size != 0)
//	      count = _vsnprintf_s(str, size, _TRUNCATE, format, ap);
//	    if(count == -1)
//	      count = _vscprintf(format, ap);
//	    return count;
//	}
//	#endif//_MSC_VER
//	As mentioned in the standard:
//	Eat most size bytes get written (including terminating '\0')
//	Eif output was truncated, the return value is the number of characters (excluding terminating '\0') that would have been written
//	
//	This will not always terminate the string with a 0 which is required on a overflow.
//	The second if in c99_vsnprintf must be: if (count == -1) { if (size > 0) str[size - 1] = 0; count = _vscprintf(format, ap); }
//	
//	QlAuMicrosoft Developer Networkv(http://msdn.microsoft.com/)́Aw_vscprintfA_vscprintf_lA_vscwprintfA_vscwprintf_lx(http://msdn.microsoft.com/ja-jp/library/w05tbk72.aspx)̃y[Wp:
//	Xgւ̃|C^[gpďw肳ꂽ̕Ԃ܂B
//	              int _vscprintf(const char* format, va_list argptr);
//	              int _vscprintf_l(const char* format, locale_t locale, va_list argptr);
//	              int _vscwprintf(const wchar_t* format, va_list argptr);
//	              int _vscwprintf_l(const wchar_t* format, locale_t locale, va_list argptr);
//	p[^[  format w蕶B
//	              argptr Xgւ̃|C^[B
//	              locale gp郍P[B
//	߂l        _vscprintf֐́AXgw񂪁Aw̏R[hgpďo͂邩A܂̓t@Cobt@[ɑMꂽꍇɐ镶Ԃ܂B
//	              Ԃlɂ́AI[NULL͊܂܂܂BCh̏ꍇ́A_vscwprintf@\s܂B
//	              _lTtBbNXtĂ邱̊֐̊eo[ẂÃ݂XbhP[̑ɓnꂽP[p[^[gp_ēłB
//	              formatnull|C^[̏ꍇ́Aup[^[̌؁vɐĂ悤ɁAȃp[^[nh[Ăяo܂B
//	              špꂽꍇA֐-1ԂAerrnoEINVALɐݒ肵܂B
//	          eargumentformat̑Ή鏑wɏ](݂ꍇ)ɕϊ܂Bformat͒ʏ̕ō\Ǎ`Ƌ@\printf֐formatƓłB
//			
//	QlBujianji-productionv(http://jianji.noor.jp/)́AwtH[}bgWJobt@̊mہx(http://jianji.noor.jp/wiki/index.cgi?page=%A5%D5%A5%A9%A1%BC%A5%DE%A5%C3%A5%C8%CA%B8%BB%FA%CE%F3%A4%F2%C5%B8%B3%AB%A4%B9%A4%EB%A5%D0%A5%C3%A5%D5%A5%A1%A4%CE%B3%CE%CA%DD)̃y[Wp:
//	RpCɂĕ悤B
//	GNUg̏ꍇ
//	vasprintfŃobt@̊mۂƃRs[𓯎ɍsB
//	void MyPrintf(const char* format, ...) {
//	  va_list argptr;
//	  va_start(argptr, format);
//	  char* buf_ = NULL;
//	  vasprintf(&buf_, format, argptr);
//	  MyPrintString(buf_);
//	  free(buf_);
//	  va_end(argptr);
//	}
//	VCg̏ꍇ
//	_vscprintfœWJ̕񒷂擾A+1̃obt@pӂB
//	void MyPrintf(const char* format, ...) {
//	  va_list argptr;
//	  va_start(argptr, format);
//	  int length = _vscprintf(format, argptr);
//	  char* buf_ = new char [length + 1];
//	  vsprintf(buf_, format, argptr);
//	  MyPrintString(buf_);
//	  delete[] buf_;
//	  va_end(argptr);
//	}
//	VCg̓mۂOł̂ŁA_ȈہB
//	
//	QlCuJM Projectv(http://linuxjm.sourceforge.jp/)́AwMan page of ASPRINTFx(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/asprintf.3.html)̃y[Wp:
//	O          asprintf, vasprintf - 蓖ĂĂɏo͂
//	          #define _GNU_SOURCE /* feature_test_macros(7) Q */
//	              #include <stdio.h>
//	              int asprintf(char** strp, const char* fmt, ...);
//	              int vasprintf(char** strp, const char* fmt, va_list ap);
//	          asprintf()֐vasprintf()֐Ƃ́Aꂼsprintf(3)֐vsprintf(3)֐ƂɎĂ邪A
//	              o͕(I[̃koCg('\0')܂߂)ێ̂ɏ\ȑ傫̃mۂAŏ̈ɂ̕ւ̃|C^ԂB
//	              ̃|C^́AsvɂȂfree(3)ɓnA蓖ĂꂽLׂ̈łB
//	Ԃl        ƁÅ֐͏o͂ꂽoCg(sprintf(3)̂悤)ԂB
//	              ̊蓖ĂłȂȂG[ƁÅ֐-1ԂAstrp̓e͖`ƂȂB
//	          ̊֐GNŮgłACPOSIX̂̂ł͂ȂB*BSDłpłB
//	              FreeBSD̎ł́AG[̍ۂɂstrpNULLɃZbgB
//	
//	QlDuStack Overflowv(http://stackoverflow.com/)́AwIs there a neat way to do strdup() followed by strcat()?x(http://stackoverflow.com/questions/12591074/is-there-a-neat-way-to-do-strdup-followed-by-strcat)̃y[Wp:
//	Say I wanted to duplicate a string then concatenate a value to it.
//	Using stl std::string, it's:
//	string s = "hello";
//	string s2 = s + " there"; //effectively dup/cat
//	in C:
//	char* s = "hello";
//	char* s2 = strdup(s);
//	strcat(s2, " there"); //s2 is too short for this operation
//	The only way I know to do this in C is:
//	char* s = "hello";
//	char* s2 = (char*)malloc(strlen(s) + strlen(" there") + 1); //allocate enough space
//	strcpy(s2, s);
//	strcat(s2, " there");
//	Is there a more elegant way to do this in C?
//	
//	A GNU extension is asprintf() that allocates the required buffer:
//	char* s2;
//	if(-1 != asprintf(&s2, "%s%s", "hello", " there") {
//	  free(s2);
//	}

int scprintf(const char* fmt, ...) {
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vscprintf(fmt, ap);
	va_end(ap);
	return n;
}
int vscprintf(const char* fmt, va_list ap) {
	return doprnt(NULL, NULL, fmt, ap);
}

int asprintf(char** strp, const char* fmt, ...) {
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vasprintf(strp, fmt, ap);
	va_end(ap);
	return n;
}
//{{2015/09/16ύX:vasprintf()va_list̎gȂ_C܂BP/ECEJ(GCC)Windows(VC++6.0)ł̓͏CÔ܂܂ł薳삷̂łÂ߂ɏC鎖ɂ܂B
//int vasprintf(char** strp, const char* fmt, va_list ap) {
//	if(!(*strp = malloc(vscprintf(fmt, ap) + 1/*nul*/))) { return -1; }
//	return vsprintf(*strp, fmt, ap);
//}
//2015/09/16ύX:vasprintf()va_list̎gȂ_C܂BP/ECEJ(GCC)Windows(VC++6.0)ł̓͏CÔ܂܂ł薳삷̂łÂ߂ɏC鎖ɂ܂B
int vasprintf(char** strp, const char* fmt, va_list ap) {
	va_list ap2;
	va_copy(ap2, ap);					//apap2ɃRs[B
	*strp = malloc(vscprintf(fmt, ap2) + 1/*nul*/);		//ap2vscprintf()ɂĕύX̂ŁÂvsprintf()ɓnĂ͂ȂB	P/ECEJ(GCC)Windows(VC++6.0)ł͒lnȂ̂Ŗ薳̂Anˑł茵ɂ͂̂悤ɏKvLB
	va_end(ap2);						//ap2̎gpIB
	if(!*strp) { return -1; }
	return vsprintf(*strp, fmt, ap);			//ύXĂȂapvsprintf()ɓnB
}
//}}2015/09/16ύX:vasprintf()va_list̎gȂ_C܂BP/ECEJ(GCC)Windows(VC++6.0)ł̓͏CÔ܂܂ł薳삷̂łÂ߂ɏC鎖ɂ܂B

//}}2014/10/02ǉ:snprintf(),vsnprintf()̖߂l̋VC++6.0C99ɕύX܂Bscprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B

/****************************************************************************
 *
 ****************************************************************************/

//{{2015/08/02ǉ:fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂BWin32vWFNgłAdoprnt()𗘗pprintf()𗘗płBclipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B

/* * Sun Aug 02 16:45:48 JST 2015 Naoyuki Sawa
 * - fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂B
 *   Win32vWFNgłAdoprnt()𗘗pprintf()𗘗płB
 *   clipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B
 */
int fprintf(FILE* stream, const char* format, ...) {
	int retval;
	va_list argptr;
	va_start(argptr, format);
	retval = vfprintf(stream, format, argptr);
	va_end(argptr);
	return retval;
}
int printf(const char* format, ...) {
	int retval;
	va_list argptr;
	va_start(argptr, format);
	retval = vprintf(format, argptr);
	va_end(argptr);
	return retval;
}
int vfprintf(FILE* stream, const char* format, va_list argptr) {
   //{{2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
   //	//WJobt@Ƃ_def_vbuff[]𗘗pĂ܂B
   //	return fwrite(_def_vbuff, 1, vsprintf(_def_vbuff, format, argptr), stream);
   //2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
	char* s;
	int n = vasprintf(&s, format, argptr);
	if(n < 0) { DIE(); }
	n = fwrite(s, 1, n, stream);
	free(s);
	return n;
   //}}2015/05/01ύX:vfprintf()_def_vbuff[]𗘗p̂߂āAvasprintf()𗘗p悤ɕύX܂B
}
int vprintf(const char* format, va_list argptr) {
	return vfprintf(stdout, format, argptr);
}

//}}2015/08/02ǉ:fprintf(),printf(),vfprintf(),vprintf()Aclipio.cclipprnt.cֈړ܂BWin32vWFNgłAdoprnt()𗘗pprintf()𗘗płBclipio.cP/ECEɈˑĂ̂Win32vWFNgɊ܂߂܂񂪁Aclipprnt.cȂWin32vWFNgɊ܂߂܂B

/****************************************************************************
 *
 ****************************************************************************/
//{{2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
#if     (defined(_MSC_VER) && (_MSC_VER > 1200))
//{{2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
//#pragma warning(default: 4028)	//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#pragma warning(pop)			//Visual C++ .NETȂ΁A͈̔͂ŌxC4028}܂B
//}}2016/09/04ύX:u#pragma warning(disable:...)v`u#pragma warning(default:...)vAu#pragma warning(push)vu#pragma warning(disable:...)v`u#pragma warning(pop)vɕύX܂B
#endif//(defined(_MSC_VER) && (_MSC_VER > 1200))
//}}2016/05/29ǉ:Visual C++ .NETŃRpCɁAxC4028\܂B
/****************************************************************************
 *
 ****************************************************************************/
