/*	
 *	clipm65i.h
 *
 *	P/ECE MOS6502 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 07 12:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Mar 16 07:13:00 JST 2005 Naoyuki Sawa
 *	- m6502_ruńACłAsmł̑ɂāARgǉB
 *	  Cł̃vO͕ύXς݁AAsmł̃vO͖ύXłB
 *	  2005/03/16݁ACłAsmłƂŁATCNJEg̓삪قȂĂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_M65I_H__
#define __CLIP_M65I_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*
 *	M6502RAp̃}N`܂B
 *	}NPāȂ̃}NƏՓ˂鋰ꂪ̂ŁA
 *	M6502RA\[Xt@Ĉ݃CN[hĂB
 */

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	M6502\̃oANZX̊ȗ\L
 */
/*===== WX^ =====*/
#define A		(m6502->a)
#define X		(m6502->x)
#define Y		(m6502->y)
#define PC		(m6502->pc)
#define SP		(m6502->sp)
#define PSR		(m6502->psr)
/*=====  =====*/
#define CYCLE		(m6502->cycle)
#define WAIT		(m6502->wait)
/*===== O֐ =====*/
#define READ(a)		    ((m6502->read )(m6502, (unsigned short)(a)))
#define WRITE(a, n)	do { (m6502->write)(m6502, (unsigned short)(a), (unsigned char)(n)); } while(0)

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	16rbgWX^̏/8rbgANZX
 */
#define LO(nn)		(*(((unsigned char*)&(nn)) + 0))
#define HI(nn)		(*(((unsigned char*)&(nn)) + 1))
#define PCL		LO(PC)
#define PCH		HI(PC)

/*
 *	16rbgANZX
 */
#define READ16(a)	(READ(a) | READ((a) + 1) << 8)

/*
 *	PUSH/PULL
 */
#define PUSH(r)		do {       WRITE(0x0100 | SP, (r)); SP--; } while(0)
#define PULL(r)		do { SP++; (r) = READ(0x0100 | SP);       } while(0)

/*
 *	CXgNVtFb`/s
 */
#define FETCH(n)	do {		\
	(n) = READ(PC++);		\
	M6502TRACE("%02x ", (n));	\
} while(0)
//#define EXEC()		do {				\
//	M6502TRACE("[%s]", &m6502_op_name_table[op->name]);	\
//	op->proc(m6502, code, arg);				\
//	CYCLE -= op->cycle;					\
//} while(0)
//2005/03/16
//ߎsOɃTCNJEg炷悤ύX܂B
//ATARI VCSG~[VɂāATIAւ̏ݑOɃ^C~Om肷Kv邽߂łB
//܂łɍ쐬vOŁA݃^C~OɈˑ̂͂ȂƎv̂ŁA
//̕ύXɂāA܂łɍ쐬vOɖ肪o邱Ƃ͂ȂƎv܂B
//ȂAAZuŃ[`(framm65a.s m6502_run)́A܂ύXĂ܂B
//P/ECEMOS6502G~[V́Aɍ(clip65c.*)ֈڍsĂ̂ŁA
//Aᑬł̃AZuŃ[`gƂ͖Ǝv܂AgƂ͏CKvłB
#define EXEC()		do {					\
	M6502TRACE("[%s]", &m6502_op_name_table[op->name]);	\
	CYCLE -= op->cycle;					\
	op->proc(m6502, code, arg);				\
} while(0)

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_M65I_H__*/
