
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

		.code
		.align		1
		.global		sqrti
		.global		sqrtu
sqrti:
		;//%r12 := s
		cmp		%r12, 0				;//if(s < 0) { DIE() }
		jrlt		sqrti_DIE			;//return sqrtu(s)
		;//---------------------------------------------;//
		;//%r12 := s
sqrtu:
		ld.w		%r13, 1				;//%r13 := t = 0x40000000
		rr		%r13, 2				;//
		ld.w		%r10, 0				;//%r10 := a = 0
		ld.w		%r11, %r10			;//%r11 := h = 0
		add		%r12, 1				;//%r12 := (s+1)				y|Cgz{'<='łrA'<'̔rɂɕς邽߂ɁA炩ߔrΏۂ̉Eӂ'+1'Ă܂B鎖ŁArʂ̃L[tÔ܂܁A
		sbc		%r12, %r10			;//if((s+1) == 0) { %r12 := UINT_MAX }		As=UINT_MAXꍇɁA(s+1)=0ɂȂĂ܂肪L܂BŁAs=UINT_MAX̏ꍇ́A(s+1)=UINT_MAXɕ␳܂BUINT_MAX
		ld.w		%r14, %r11			;//%r14 := b = h		
sqrtu_LOOP:							;//do {					
		add		%r14, %r13			;//  %r14 := b += t		
		srl		%r11, 1				;//  %r11 := h >>= 1			
		cmp		%r14, %r12			;//  %psr(C) := b < (s+1)		
		jruge.d		sqrtu_SKIP			;//  if(b < (s+1)) {			
		adc		%r10, %r10			;//  %r10 := (a << 1) | %psr(C)			*delay*
		sub		%r12, %r14			;//    %r12 := (s+1) -= b		
		add		%r11, %r13			;//    %r11 := h += t			
sqrtu_SKIP:							;//  }					
		srl		%r13, 2				;//  %r13 := t >>= 2			
		jrne.d		sqrtu_LOOP			;//} while(t)				
		ld.w		%r14, %r11			;//  %r14 := b = h			*delay*
		ret						;//return a

	.code
	.align	2
__LC0:
	.ascii	"clipint.$\000"
; NO_APP
	.code
	.align	1
sqrti_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	int	2
	.word	__LC0
	.half	0x000000a6
	ret
	.global	vec2i_0
	.code
	.align	2
vec2i_0:
	.word	0
	.word	0
	.global	vec2i_1
	.align	2
vec2i_1:
	.word	1
	.word	1
	.global	vec2i_x
	.align	2
vec2i_x:
	.word	1
	.word	0
	.global	vec2i_y
	.align	2
vec2i_y:
	.word	0
	.word	1
	.code
	.align	1
	.global	vec2i_add
vec2i_add:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ld.w	%r11,[%r13]	; 	xld.w	%r11,[%r13]
	add	%r10,%r11
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	%r10,[%r12+0x4]
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.w	%r11,[%r13+0x4]
	ld.w	%r11,[%r13]
	add	%r10,%r11
	ext	0x4		; 	xld.w	[%r12+0x4],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
	.global	vec2i_sub
vec2i_sub:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ld.w	%r11,[%r13]	; 	xld.w	%r11,[%r13]
	sub	%r10,%r11
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	%r10,[%r12+0x4]
	ld.w	%r10,[%r12]
	ext	0x4		; 	xld.w	%r11,[%r13+0x4]
	ld.w	%r11,[%r13]
	sub	%r10,%r11
	ext	0x4		; 	xld.w	[%r12+0x4],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
	.global	vec2i_mul
vec2i_mul:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,[%r12]	; 	xld.w	%r11,[%r12]
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	mlt.w	%r11,%r10
	ld.w	%r14,%alr
	ld.w	[%r12],%r14	; 	xld.w	[%r12],%r14
	ext	0x4		; 	xld.w	%r11,[%r12+0x4]
	ld.w	%r11,[%r12]
	ext	0x4		; 	xld.w	%r10,[%r13+0x4]
	ld.w	%r10,[%r13]
	mlt.w	%r11,%r10
	ld.w	%r14,%alr
	ext	0x4		; 	xld.w	[%r12+0x4],%r14
	ld.w	[%r12],%r14
	ret
	.align	1
	.global	vec2i_div
vec2i_div:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,[%r1]	; 	xld.w	%r13,[%r1]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	ext	0x4		; 	xld.w	%r12,[%r0+0x4]
	ld.w	%r12,[%r0]
	ext	0x4		; 	xld.w	%r13,[%r1+0x4]
	ld.w	%r13,[%r1]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ext	0x4		; 	xld.w	[%r0+0x4],%r10
	ld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	vec2i_neg
vec2i_neg:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	not	%r10,%r10
	add	%r10,1
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	%r10,[%r12+0x4]
	ld.w	%r10,[%r12]
	not	%r10,%r10
	add	%r10,1
	ext	0x4		; 	xld.w	[%r12+0x4],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
	.global	vec2i_normal
vec2i_normal:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	call	vec2i_mag	; 	xcall	vec2i_mag
	ld.w	%r1,%r10
	ld.w	%r12,[%r0]	; 	xld.w	%r12,[%r0]
	ld.w	%r13,%r1
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	ext	0x4		; 	xld.w	%r12,[%r0+0x4]
	ld.w	%r12,[%r0]
	ld.w	%r13,%r1
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ext	0x4		; 	xld.w	[%r0+0x4],%r10
	ld.w	[%r0],%r10
	popn	%r1
	ret
	.align	1
	.global	vec2i_mag
vec2i_mag:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	call	vec2i_mag2	; 	xcall	vec2i_mag2
	ld.w	%r12,%r10
	ext	sqrti@rm	; 	xcall	sqrti
	call	sqrti@rl
	ret
	.align	1
	.global	vec2i_mag2
vec2i_mag2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r13,%r12
	call	vec2i_dot	; 	xcall	vec2i_dot
	ret
	.align	1
	.global	vec2i_dot
vec2i_dot:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,[%r12]	; 	xld.w	%r11,[%r12]
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	mlt.w	%r11,%r10
	ld.w	%r14,%alr
	ext	0x4		; 	xld.w	%r11,[%r12+0x4]
	ld.w	%r11,[%r12]
	ext	0x4		; 	xld.w	%r10,[%r13+0x4]
	ld.w	%r10,[%r13]
	mlt.w	%r11,%r10
	ld.w	%r11,%alr
	ld.w	%r10,%r14
	add	%r10,%r11
	ret
	.align	1
	.global	vec2i_cross
vec2i_cross:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,[%r12]	; 	xld.w	%r11,[%r12]
	ext	0x4		; 	xld.w	%r10,[%r13+0x4]
	ld.w	%r10,[%r13]
	mlt.w	%r11,%r10
	ld.w	%r14,%alr
	ext	0x4		; 	xld.w	%r11,[%r12+0x4]
	ld.w	%r11,[%r12]
	ld.w	%r10,[%r13]	; 	xld.w	%r10,[%r13]
	mlt.w	%r11,%r10
	ld.w	%r11,%alr
	ld.w	%r10,%r14
	sub	%r10,%r11
	ret
	.align	1
	.global	vec2i_dist
vec2i_dist:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	call	vec2i_dist2	; 	xcall	vec2i_dist2
	ld.w	%r12,%r10
	ext	sqrti@rm	; 	xcall	sqrti
	call	sqrti@rl
	ret
	.align	1
	.global	vec2i_dist2
vec2i_dist2:
;	.frame	%sp,12,$31		# vars= 8, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ext	0x4		; 	xld.w	%r11,[%r12+0x4]
	ld.w	%r11,[%r12]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,%sp
	call	vec2i_sub	; 	xcall	vec2i_sub
	ld.w	%r12,%sp
	call	vec2i_mag2	; 	xcall	vec2i_mag2
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	ret
	.align	1
	.global	vec2i_distance_l_p
vec2i_distance_l_p:
;	.frame	%sp,28,$31		# vars= 16, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x4		; 	xsub	%sp,%sp,16
	ld.w	%r1,%r14
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ext	0x4		; 	xld.w	%r11,[%r12+0x4]
	ld.w	%r11,[%r12]
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ld.w	[%sp+0x3],%r11	; 	xld.w	[%sp+0xc],%r11
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,%sp
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,8
	add	%r0,0x8
	ld.w	%r12,%r0
	ld.w	%r13,%r1
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%sp
	ld.w	%r13,%r0
	call	vec2i_cross	; 	xcall	vec2i_cross
	ld.w	%r0,%r10
	ld.w	%r12,%sp
	call	vec2i_mag	; 	xcall	vec2i_mag
	ld.w	%r12,%r0
	ld.w	%r13,%r10
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
; APP
	cmp  %r10, 0
jrge 3
 not %r10, %r10
 add %r10, 1

; NO_APP
	add	%sp,0x4		; 	xadd	%sp,%sp,16
	popn	%r1
	ret
	.align	1
	.global	vec2i_intersection_l_p
vec2i_intersection_l_p:
;	.frame	%sp,28,$31		# vars= 16, regs= 2/0, args= 4, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	sub	%sp,0x5		; 	xsub	%sp,%sp,20
	ld.w	%r0,%r12
	ext	0x4		; 	xld.w	%r10,[%r13+0x4]
	ld.w	%r10,[%r13]
	ext	0x4		; 	xld.w	%r11,[%r14+0x4]
	ld.w	%r11,[%r14]
	sub	%r10,%r11
	ld.w	%r11,[%r15]	; 	xld.w	%r11,[%r15]
	add	%r10,%r11
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4],%r10
	ld.w	%r10,[%r14]	; 	xld.w	%r10,[%r14]
	ld.w	%r11,[%r13]	; 	xld.w	%r11,[%r13]
	sub	%r10,%r11
	ext	0x4		; 	xld.w	%r11,[%r15+0x4]
	ld.w	%r11,[%r15]
	add	%r10,%r11
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ld.w	%r10,%sp	; 	xadd	%r10,%sp,4
	add	%r10,0x4
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,12
	add	%r12,0xc
	call	vec2i_intersection_l	; 	xcall	vec2i_intersection_l
	ld.w	%r10,[%sp+0x3]	; 	xld.w	%r10,[%sp+0xc]
	ld.w	%r11,[%sp+0x4]	; 	xld.w	%r11,[%sp+0x10]
	ld.w	[%r0],%r10	; 	xld.w	[%r0],%r10
	ext	0x4		; 	xld.w	[%r0+0x4],%r11
	ld.w	[%r0],%r11
	ld.w	%r10,%r0
	add	%sp,0x5		; 	xadd	%sp,%sp,20
	popn	%r0
	ret
	.align	1
	.global	vec2i_intersection_l
vec2i_intersection_l:
;	.frame	%sp,48,$31		# vars= 28, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x7		; 	xsub	%sp,%sp,28
	ld.w	[%sp+0x6],%r12	; 	xld.w	[%sp+0x18],%r12
	ld.w	%r0,%r13
	ld.w	%r3,%r15
	ld.w	%r2,[%sp+0xc]	; 	xld.w	%r2,[%sp+0x30]
	ld.w	%r10,[%r14]	; 	xld.w	%r10,[%r14]
	ext	0x4		; 	xld.w	%r11,[%r14+0x4]
	ld.w	%r11,[%r14]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,%sp
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	ext	0x4		; 	xld.w	%r11,[%r0+0x4]
	ld.w	%r11,[%r0]
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ld.w	[%sp+0x3],%r11	; 	xld.w	[%sp+0xc],%r11
	ld.w	%r1,%sp		; 	xadd	%r1,%sp,8
	add	%r1,0x8
	ld.w	%r12,%r1
	ld.w	%r13,%r2
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r10,[%r3]	; 	xld.w	%r10,[%r3]
	ext	0x4		; 	xld.w	%r11,[%r3+0x4]
	ld.w	%r11,[%r3]
	ld.w	[%sp+0x4],%r10	; 	xld.w	[%sp+0x10],%r10
	ld.w	[%sp+0x5],%r11	; 	xld.w	[%sp+0x14],%r11
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,16
	add	%r0,0x10
	ld.w	%r12,%r0
	ld.w	%r13,%r2
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%sp
	ld.w	%r13,%r1
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ld.w	%r1,%r10
	ld.w	%r12,%sp
	ld.w	%r13,%r0
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ld.w	%r0,%r10
	ld.w	%r10,[%sp+0x4]	; 	xld.w	%r10,[%sp+0x10]
	mlt.w	%r10,%r1
	ld.w	%r12,%alr
	ld.w	%r13,%r0
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r11,[%r2]	; 	xld.w	%r11,[%r2]
	add	%r10,%r11
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	%r10,[%sp+0x5]	; 	xld.w	%r10,[%sp+0x14]
	mlt.w	%r10,%r1
	ld.w	%r12,%alr
	ld.w	%r13,%r0
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ext	0x4		; 	xld.w	%r11,[%r2+0x4]
	ld.w	%r11,[%r2]
	add	%r10,%r11
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4],%r10
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	ld.w	%r11,[%sp+0x1]	; 	xld.w	%r11,[%sp+0x4]
	ld.w	%r4,[%sp+0x6]	; 	xld.w	%r4,[%sp+0x18]
	ld.w	[%r4],%r10	; 	xld.w	[%r4],%r10
	ext	0x4		; 	xld.w	[%r4+0x4],%r11
	ld.w	[%r4],%r11
	ld.w	%r10,[%sp+0x6]	; 	xld.w	%r10,[%sp+0x18]
	add	%sp,0x7		; 	xadd	%sp,%sp,28
	popn	%r3
	ret
	.align	1
	.global	vec2i_is_intersected_ls
vec2i_is_intersected_ls:
;	.frame	%sp,56,$31		# vars= 36, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x9		; 	xsub	%sp,%sp,36
	ld.w	[%sp+0x6],%r12	; 	xld.w	[%sp+0x18],%r12
	ld.w	[%sp+0x7],%r13	; 	xld.w	[%sp+0x1c],%r13
	ld.w	%r3,%r14
	ld.w	[%sp+0x8],%r15	; 	xld.w	[%sp+0x20],%r15
	ld.w	%r10,[%r12]	; 	xld.w	%r10,[%r12]
	ext	0x4		; 	xld.w	%r11,[%r12+0x4]
	ld.w	%r11,[%r12]
	ld.w	[%sp+0x4],%r10	; 	xld.w	[%sp+0x10],%r10
	ld.w	[%sp+0x5],%r11	; 	xld.w	[%sp+0x14],%r11
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ld.w	[%sp+0x3],%r11	; 	xld.w	[%sp+0xc],%r11
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,%sp
	ld.w	%r13,[%sp+0x7]	; 	xld.w	%r13,[%sp+0x1c]
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r1,%sp		; 	xadd	%r1,%sp,8
	add	%r1,0x8
	ld.w	%r12,%r1
	ld.w	%r13,%r3
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r2,%sp		; 	xadd	%r2,%sp,16
	add	%r2,0x10
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x8]	; 	xld.w	%r13,[%sp+0x20]
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%sp
	ld.w	%r13,%r1
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ld.w	%r0,%r10
	ld.w	%r12,%sp
	ld.w	%r13,%r2
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	cmp	%r0,0x0
	jreq	__LX90		; 	xjreq	__L90
	cmp	%r10,0x0
	jreq	__LX90		; 	xjreq	__L90
	xor	%r0,%r10
	ld.w	%r10,%r0
	cmp	%r10,0x0
	jrge	__LX90		; 	xjrge	__L90
	ld.w	%r10,[%r3]	; 	xld.w	%r10,[%r3]
	ext	0x4		; 	xld.w	%r11,[%r3+0x4]
	ld.w	%r11,[%r3]
	ld.w	[%sp+0x4],%r10	; 	xld.w	[%sp+0x10],%r10
	ld.w	[%sp+0x5],%r11	; 	xld.w	[%sp+0x14],%r11
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ld.w	[%sp+0x3],%r11	; 	xld.w	[%sp+0xc],%r11
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r11	; 	xld.w	[%sp+0x4],%r11
	ld.w	%r12,%sp
	ld.w	%r13,[%sp+0x8]	; 	xld.w	%r13,[%sp+0x20]
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%r1
	ld.w	%r13,[%sp+0x6]	; 	xld.w	%r13,[%sp+0x18]
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%r2
	ld.w	%r13,[%sp+0x7]	; 	xld.w	%r13,[%sp+0x1c]
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%sp
	ld.w	%r13,%r1
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ld.w	%r0,%r10
	ld.w	%r12,%sp
	ld.w	%r13,%r2
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	cmp	%r0,0x0
	jreq	__LX90		; 	xjreq	__L90
	cmp	%r10,0x0
	jreq	__LX90		; 	xjreq	__L90
	xor	%r0,%r10
	ld.w	%r10,%r0
	cmp	%r10,0x0
	jrlt	__LX89		; 	xjrlt	__L89
__LX90:				; __L90:
	ld.w	%r10,0x0
	jp	__LX91		; 	xjp	__L91
__LX89:				; __L89:
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
__LX91:				; __L91:
	add	%sp,0x9		; 	xadd	%sp,%sp,36
	popn	%r3
	ret
	.align	1
	.global	vec2i_is_point_in_convex
vec2i_is_point_in_convex:
;	.frame	%sp,48,$31		# vars= 28, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x7		; 	xsub	%sp,%sp,28
	ld.w	[%sp+0x4],%r12	; 	xld.w	[%sp+0x10],%r12
	ld.w	%r2,%r13
	ld.w	%r3,%r14
	ld.w	%r10,%r3
	sll	%r10,0x3	; 	xsll	%r10,3
	add	%r10,%r2
	sub	%r10,0x8	; 	xsub	%r10,%r10,8
	ld.w	%r0,[%r10]	; 	xld.w	%r0,[%r10]
	ext	0x4		; 	xld.w	%r1,[%r10+0x4]
	ld.w	%r1,[%r10]
	ld.w	%r15,0x0
	ld.w	[%sp+0x5],%r15	; 	xld.w	[%sp+0x14],%r15
	ld.w	%r15,%sp	; 	xadd	%r15,%sp,8
	add	%r15,0x8
	ld.w	[%sp+0x6],%r15	; 	xld.w	[%sp+0x18],%r15
__LX93:				; __L93:
	ld.w	[%sp+0x0],%r0	; 	xld.w	[%sp],%r0
	ld.w	[%sp+0x1],%r1	; 	xld.w	[%sp+0x4],%r1
	ld.w	%r12,%sp
	ld.w	%r13,[%sp+0x4]	; 	xld.w	%r13,[%sp+0x10]
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	[%sp+0x2],%r0	; 	xld.w	[%sp+0x8],%r0
	ld.w	[%sp+0x3],%r1	; 	xld.w	[%sp+0xc],%r1
	ld.w	%r12,[%sp+0x6]	; 	xld.w	%r12,[%sp+0x18]
	ld.w	%r13,%r2
	ext	vec2i_sub@rm	; 	xcall	vec2i_sub
	call	vec2i_sub@rl
	ld.w	%r12,%sp
	ld.w	%r13,[%sp+0x6]	; 	xld.w	%r13,[%sp+0x18]
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ld.w	%r11,%r10
	cmp	%r11,0x0
	jreq	__LX96		; 	xjreq	__L96
	ld.w	%r15,[%sp+0x5]	; 	xld.w	%r15,[%sp+0x14]
	cmp	%r15,0x0
	jreq	__LX97		; 	xjreq	__L97
	ld.w	%r10,%r15
	xor	%r10,%r11
	jrge	__LX97		; 	xjrge	__L97
	ld.w	%r10,0x0
	jp	__LX100		; 	xjp	__L100
__LX97:				; __L97:
	ld.w	[%sp+0x5],%r11	; 	xld.w	[%sp+0x14],%r11
__LX96:				; __L96:
	ld.w	%r0,[%r2]	; 	xld.w	%r0,[%r2]
	ext	0x4		; 	xld.w	%r1,[%r2+0x4]
	ld.w	%r1,[%r2]
	add	%r2,0x8		; 	xadd	%r2,%r2,8
	sub	%r3,0x1		; 	xsub	%r3,%r3,1
	jrne	__LX93		; 	xjrne	__L93
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
__LX100:				; __L100:
	add	%sp,0x7		; 	xadd	%sp,%sp,28
	popn	%r3
	ret
; APP

		.code
		.align		1
		.global		vec2i_is_point_in_concave
vec2i_is_point_in_concave:
		pushn		%r3
		;// %r12 := p
		;// %r13 := v
		;// %r14 := nv
		;//-----------------------------------------------------;
		ld.w		%r2, %r14				;// %r2  := j = nv
		ld.w		%r3, %r13				;// %r3  := vj = v
		ld.w		%r4, [%r3]+				;// %r4  := xmin = vj->x
		ld.w		%r5, [%r3]+				;// %r5  := ymin = vj->y, %r3  := vj++
		ld.w		%r6, %r4				;// %r6  := xmax = vj->x
		ld.w		%r7, %r5				;// %r7  := ymax = vj->y
		sub		%r2, 1					;// %r2  := j--
		ld.w		%r0, %r2				;// %r0  :=  i - 1 =  j ( i1lێĂAmɖ߂B)
		ld.w		%r1, %r3				;// %r1  := vi + 1 = vj (vi1i񂾒lێĂAmɖ߂B)
		;// %r0  :=  i - 1
		;// %r1  := vi + 1
		;// %r2  := j
		;// %r3  := vj
		;// %r4  := xmin
		;// %r5  := ymin
		;// %r6  := xmax
		;// %r7  := ymax
		;// %r12 := p
		;// %r13 := v
		;// %r14 := nv
vec2i_is_point_in_concave_LOOP1:					;// do {
		ld.w		%r10, [%r3]+				;//   %r10  := vj->x
		ld.w		%r11, [%r3]+				;//   %r11  := vj->y, %r3  := vj++
		;//
		cmp		%r10, %r4				;//   if(vj->x < xmin)
		jrge.d		3
		cmp		%r10, %r6				;//   <-------------------------+	*delay*
		 ld.w		%r4, %r10				;//     %r4  := xmin = vj->x	|
		;//							;//				|
;//		cmp		%r10, %r6				;//   if(vj->x > xmax) ---------+
		jrle.d		3
		cmp		%r11, %r5				;//   <-------------------------+	*delay*
		 ld.w		%r6, %r10				;//     %r6  := xmax = vj->x	|
		;//							;//				|
;//		cmp		%r11, %r5				;//   if(vj->y < ymin) ---------+
		jrge.d		3
		cmp		%r11, %r7				;//   <-------------------------+	*delay*
		 ld.w		%r5, %r11				;//     %r5  := ymin = vj->y	|
		;//							;//				|
;//		cmp		%r11, %r7				;//   if(vj->y > ymax) ---------+
		jrle.d		5
		sub		%r2, 1					;//   <-------------------------+	*delay*
		 ld.w		%r7, %r11				;//     %r7  := ymax = vj->y	|
		 ld.w		%r0, %r2				;//     %r0  :=  i - 1 =  j	|
		 ld.w		%r1, %r3				;//     %r1  := vi + 1 = vj	|
		;//							;//				|
;//		sub		%r2, 1					;//   %r2  := j-- --------------+
		jrne		vec2i_is_point_in_concave_LOOP1		;// } while(j)
		;//
		ld.w		%r2, [%r12]+				;// %r2  := p->x
		ld.w		%r3, [%r12]				;// %r3  := p->y
		;//
		cmp		%r2, %r4				;// if(p->x < xmin)
		jrlt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		cmp		%r2, %r6				;// if(p->x > xmax)
		jrgt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		cmp		%r3, %r5				;// if(p->y < ymin)
		jrlt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		cmp		%r3, %r7				;// if(p->y > ymax)
		jrgt		vec2i_is_point_in_concave_RET0		;//   return 0
		;//
		add		%r0, 1					;// %r0  :=  i ( i1lێĂB im肵̂ŁAŖ߂)
		sub		%r1, 8					;// %r1  := vi (vi1i񂾒lێĂBvim肵̂ŁAŖ߂)
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r13 := v
		;// %r14 := nv
		;//-----------------------------------------------------;
		ld.w		%r10, 0					;// %r10 := n = 0
		ld.w		%r11, 0					;// %r11 := prev = 0
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r10 := n
		;// %r11 := prev
		;// %r13 := v
		;// %r14 := j = nv
vec2i_is_point_in_concave_LOOP2:					;// do {
		ld.w		%r4, [%r1]+				;//   %r4  := v0.x = vi->x
		ld.w		%r5, [%r1]+				;//   %r5  := v0.y = vi->y, %r1  := vi++
		ld.w		%r6, %r4				;//   %r6  := v1.x = vi->x
		ld.w		%r7, %r5				;//   %r7  := v1.y = vi->y
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r4  := v0.x
		;// %r5  := v0.y
		;// %r6  := v1.x
		;// %r7  := v1.y
		;// %r10 := n
		;// %r11 := prev
		;// %r13 := v
		;// %r14 := j
		sub		%r0, 1					;//   %r0  := i--
		jrne.d		3					;//   if(!i)
		sub		%r4, %r2				;//   <-------------------------+	*delay*
		 ld.w		%r1, %r13				;//     %r1  := vi = v		|
		;//							;//				|
;//		sub		%r4, %r2				;//   %r4  := v0.x -= p->x -----+
		sub		%r5, %r3				;//   %r5  := v0.y -= p->y
		;//
	ld.w	%r12,[%r1]	; 		xld.w		%r12, [%r1+0x0]				;//   %r12 :=         vi->x
	ext	0x4		; 		xld.w		%r15, [%r1+0x4]				;//   %r15 :=         vi->y
	ld.w	%r15,[%r1]
		sub		%r6, %r12				;//   %r6  := v1.x -= vi->x
		sub		%r7, %r15				;//   %r7  := v1.y -= vi->y
		;//
		mlt.w		%r4, %r7				;//   %alr :=     v0.x * v1.y
		ld.w		%r12, %alr				;//   %r12 :=     v0.x * v1.y
		mlt.w		%r5, %r6				;//   %alr :=                   v0.y * v1.x
		ld.w		%r15, %alr				;//   %r13 :=                   v0.y * v1.x
		sub		%r12, %r15				;//   %r12 := f = v0.x * v1.y - v0.y * v1.x
		jrne		vec2i_is_point_in_concave_NOT_ON_LS	;//   if(!f)
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
		cmp		%r4, 0					;//     if(v0.x) {
		jreq		vec2i_is_point_in_concave_X_ON_LS
		jrgt		vec2i_is_point_in_concave_V0X_GT_0	;//       if(v0.x < 0)
		cmp		%r4, %r6				;//         if(v0.x < v1.x)
		jrlt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
		jp		vec2i_is_point_in_concave_X_ON_LS
vec2i_is_point_in_concave_V0X_GT_0:					;//       else
		cmp		%r4, %r6				;//         if(v0.x > v1.x)
		jrgt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
vec2i_is_point_in_concave_X_ON_LS:					;//     }
		cmp		%r5, 0					;//     if(v0.y) {
		jreq		vec2i_is_point_in_concave_RET_1
		jrgt		vec2i_is_point_in_concave_V0Y_GT_0	;//       if(v0.y < 0)
		cmp		%r5, %r7				;//         if(v0.y < v1.y)
		jrlt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
		jp		vec2i_is_point_in_concave_RET_1
vec2i_is_point_in_concave_V0Y_GT_0:					;//       else
		cmp		%r5, %r7				;//         if(v0.y > v1.y)
		jrgt		vec2i_is_point_in_concave_NOT_ON_LS	;//           goto NOT_ON_LS
		jp		vec2i_is_point_in_concave_RET_1
vec2i_is_point_in_concave_NOT_ON_LS:					;//     }
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
		cmp		%r7, 0					;//   if(v1.y)
		jreq		vec2i_is_point_in_concave_NEXT
		jrgt.d		vec2i_is_point_in_concave_V1Y_GT_0	;//     if(v1.y < 0)
		cmp		%r12, 0					;//     %psr := f - 0				*delay*
;//vec2i_is_point_in_concave_V1Y_LT_0:
		jrge		vec2i_is_point_in_concave_PREV_V1Y	;//       if(f < 0)
		cmp		%r7, %r5				;//         if(v1.y <= v0.y)
		jrgt		vec2i_is_point_in_concave_PREV_V1Y
		cmp		%r11, 0					;//           if(prev < 0) {
		jrge.d		4
		 cmp		%r5, 0					;//           %psr := v0.y - 0			*delay*
		 jrge		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y < 0)
		 jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           } else {
		jrgt		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y <= 0)
		jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           }
vec2i_is_point_in_concave_V1Y_GT_0:					;//     } else {
		jrle		vec2i_is_point_in_concave_PREV_V1Y	;//       if(f > 0)
		cmp		%r7, %r5				;//         if(v1.y >= v0.y)
		jrlt		vec2i_is_point_in_concave_PREV_V1Y
		cmp		%r11, 0					;//           if(prev < 0) {
		jrle.d		4
		 cmp		%r5, 0					;//           %psr := v0.y - 0			*delay*
		 jrle		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y > 0)
		 jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           } else {
		jrlt		vec2i_is_point_in_concave_PREV_V1Y	;//             if(v0.y >= 0)
;//		jp		vec2i_is_point_in_concave_N_TOGGLE	;//               n ^= 1
		;//							;//           }
vec2i_is_point_in_concave_N_TOGGLE:					;//     }
		xor		%r10, 1					;//   %r10 := n ^= 1
vec2i_is_point_in_concave_PREV_V1Y:
		ld.w		%r11, %r7				;//   %r3  := prev = v1.y
		;// %r0  := i
		;// %r1  := vi
		;// %r2  := p->x
		;// %r3  := p->y
		;// %r10 := n
		;// %r11 := prev
		;// %r13 := v
		;// %r14 := j
vec2i_is_point_in_concave_NEXT:
		sub		%r14, 1					;//   %r14 := j--
		jrne		vec2i_is_point_in_concave_LOOP2		;// } while(j)
		;//-----------------------------------------------------;
vec2i_is_point_in_concave_RET:
		popn		%r3
		ret
vec2i_is_point_in_concave_RET0:
		jp.d		vec2i_is_point_in_concave_RET
		ld.w		%r10, 0					;// %r10 := n = 0	*delay*
vec2i_is_point_in_concave_RET_1:
		jp.d		vec2i_is_point_in_concave_RET
		ld.w		%r10, -1				;// %r10 := n = -1	*delay*

; NO_APP
	.align	1
	.global	vec2i_is_intersected_p
vec2i_is_intersected_p:
;	.frame	%sp,40,$31		# vars= 20, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x5		; 	xsub	%sp,%sp,20
	ld.w	[%sp+0x0],%r12	; 	xld.w	[%sp],%r12
	ld.w	[%sp+0x1],%r13	; 	xld.w	[%sp+0x4],%r13
	ld.w	[%sp+0x2],%r14	; 	xld.w	[%sp+0x8],%r14
	ld.w	[%sp+0x3],%r15	; 	xld.w	[%sp+0xc],%r15
	ld.w	%r5,[%r12]	; 	xld.w	%r5,[%r12]
	ld.w	%r7,%r5
	ext	0x4		; 	xld.w	%r6,[%r12+0x4]
	ld.w	%r6,[%r12]
	ld.w	%r0,%r6
	ld.w	%r11,%r12
	add	%r11,0x8	; 	xadd	%r11,%r11,8
	ld.w	%r3,%r13
	sub	%r3,0x1		; 	xsub	%r3,%r3,1
__LX102:				; __L102:
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	cmp	%r10,%r7
	jrge	__LX105		; 	xjrge	__L105
	ld.w	%r7,%r10
	jp	__LX106		; 	xjp	__L106
__LX105:				; __L105:
	cmp	%r10,%r5
	jrle	__LX106		; 	xjrle	__L106
	ld.w	%r5,%r10
__LX106:				; __L106:
	ext	0x4		; 	xld.w	%r10,[%r11+0x4]
	ld.w	%r10,[%r11]
	cmp	%r10,%r0
	jrge	__LX108		; 	xjrge	__L108
	ld.w	%r0,%r10
	jp	__LX109		; 	xjp	__L109
__LX108:				; __L108:
	cmp	%r10,%r6
	jrle	__LX109		; 	xjrle	__L109
	ld.w	%r6,%r10
__LX109:				; __L109:
	add	%r11,0x8	; 	xadd	%r11,%r11,8
	sub	%r3,0x1		; 	xsub	%r3,%r3,1
	jrne	__LX102		; 	xjrne	__L102
	ld.w	%r4,[%sp+0x2]	; 	xld.w	%r4,[%sp+0x8]
	ld.w	%r12,[%r4]	; 	xld.w	%r12,[%r4]
	ld.w	%r13,%r12
	ext	0x4		; 	xld.w	%r15,[%r4+0x4]
	ld.w	%r15,[%r4]
	ld.w	%r2,%r15
	ld.w	%r14,%r4
	add	%r14,0x8	; 	xadd	%r14,%r14,8
	ld.w	%r1,[%sp+0x3]	; 	xld.w	%r1,[%sp+0xc]
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
__LX112:				; __L112:
	ld.w	%r10,[%r14]	; 	xld.w	%r10,[%r14]
	cmp	%r10,%r12
	jrge	__LX115		; 	xjrge	__L115
	ld.w	%r12,%r10
	jp	__LX116		; 	xjp	__L116
__LX115:				; __L115:
	cmp	%r10,%r13
	jrle	__LX116		; 	xjrle	__L116
	ld.w	%r13,%r10
__LX116:				; __L116:
	ext	0x4		; 	xld.w	%r10,[%r14+0x4]
	ld.w	%r10,[%r14]
	cmp	%r10,%r15
	jrge	__LX118		; 	xjrge	__L118
	ld.w	%r15,%r10
	jp	__LX119		; 	xjp	__L119
__LX118:				; __L118:
	cmp	%r10,%r2
	jrle	__LX119		; 	xjrle	__L119
	ld.w	%r2,%r10
__LX119:				; __L119:
	add	%r14,0x8	; 	xadd	%r14,%r14,8
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	jrne	__LX112		; 	xjrne	__L112
	cmp	%r7,%r13
	jrgt	__LX123		; 	xjrgt	__L123
	cmp	%r5,%r12
	jrlt	__LX123		; 	xjrlt	__L123
	cmp	%r0,%r2
	jrgt	__LX123		; 	xjrgt	__L123
	cmp	%r6,%r15
	jrge	__LX122		; 	xjrge	__L122
__LX123:				; __L123:
	ld.w	%r10,0x0
	jp	__LX135		; 	xjp	__L135
__LX122:				; __L122:
	sub	%r11,0x8	; 	xsub	%r11,%r11,8
	sub	%r14,0x8	; 	xsub	%r14,%r14,8
	ld.w	%r2,[%sp+0x0]	; 	xld.w	%r2,[%sp]
	ld.w	%r3,[%sp+0x1]	; 	xld.w	%r3,[%sp+0x4]
__LX124:				; __L124:
	ld.w	%r0,[%sp+0x2]	; 	xld.w	%r0,[%sp+0x8]
	ld.w	%r1,[%sp+0x3]	; 	xld.w	%r1,[%sp+0xc]
__LX127:				; __L127:
	ld.w	%r12,%r11
	ld.w	%r13,%r2
	ld.w	%r15,%r0
	ld.w	[%sp+0x4],%r11	; 	xld.w	[%sp+0x10],%r11
	ext	vec2i_is_intersected_ls@rm	; 	xcall	vec2i_is_intersected_ls
	call	vec2i_is_intersected_ls@rl
	ld.w	%r11,[%sp+0x4]	; 	xld.w	%r11,[%sp+0x10]
	cmp	%r10,0x0
	jrne	__LX137		; 	xjrne	__L137
	ld.w	%r14,%r0
	add	%r0,0x8		; 	xadd	%r0,%r0,8
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	jrne	__LX127		; 	xjrne	__L127
	ld.w	%r11,%r2
	add	%r2,0x8		; 	xadd	%r2,%r2,8
	sub	%r3,0x1		; 	xsub	%r3,%r3,1
	jrne	__LX124		; 	xjrne	__L124
	ld.w	%r12,[%sp+0x0]	; 	xld.w	%r12,[%sp]
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]
	ext	vec2i_is_point_in_concave@rm	; 	xcall	vec2i_is_point_in_concave
	call	vec2i_is_point_in_concave@rl
	cmp	%r10,0x0
	jreq	__LX133		; 	xjreq	__L133
__LX137:				; __L137:
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	jp	__LX135		; 	xjp	__L135
__LX133:				; __L133:
	ld.w	%r12,[%sp+0x2]	; 	xld.w	%r12,[%sp+0x8]
	ld.w	%r13,[%sp+0x0]	; 	xld.w	%r13,[%sp]
	ld.w	%r14,[%sp+0x1]	; 	xld.w	%r14,[%sp+0x4]
	ext	vec2i_is_point_in_concave@rm	; 	xcall	vec2i_is_point_in_concave
	call	vec2i_is_point_in_concave@rl
	not	%r11,%r10
	add	%r11,1
	or	%r11,%r10
	ld.w	%r10,%r11
	srl	%r10,0x8	; 	xsrl	%r10,31
	srl	%r10,0x8
	srl	%r10,0x8
	srl	%r10,0x7
__LX135:				; __L135:
	add	%sp,0x5		; 	xadd	%sp,%sp,20
	popn	%r3
	ret
	.align	1
	.global	vec2i_is_point_in_alternate_concaves
vec2i_is_point_in_alternate_concaves:
;	.frame	%sp,24,$31		# vars= 4, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	[%sp+0x0],%r12	; 	xld.w	[%sp],%r12
	ld.w	%r2,%r13
	ld.w	%r0,%r14
	ld.w	%r1,%r15
	ld.w	%r3,0x0
__LX139:				; __L139:
	ld.w	%r12,[%sp+0x0]	; 	xld.w	%r12,[%sp]
	ld.w	%r13,%r2
	ld.w	%r14,[%r0]	; 	xld.w	%r14,[%r0]
	ext	vec2i_is_point_in_concave@rm	; 	xcall	vec2i_is_point_in_concave
	call	vec2i_is_point_in_concave@rl
	cmp	%r10,0x0
	jreq	__LX142		; 	xjreq	__L142
	cmp	%r10,0x3f	; 	xcmp	%r10,-1
	jreq	__LX145		; 	xjreq	__L145
	xor	%r3,0x1		; 	xxor	%r3,%r3,0x00000001
__LX142:				; __L142:
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	sll	%r10,0x3	; 	xsll	%r10,3
	add	%r2,%r10
	add	%r0,0x4		; 	xadd	%r0,%r0,4
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	jrne	__LX139		; 	xjrne	__L139
	ld.w	%r10,%r3
__LX145:				; __L145:
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r3
	ret
	.align	1
	.global	vec2i_split_polygon_into_triangles
vec2i_split_polygon_into_triangles:
;	.frame	%sp,308,$31		# vars= 288, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x48	; 	xsub	%sp,%sp,288
	ext	0x4		; 	xld.w	[%sp+0x100],%r12
	ld.w	[%sp+0x0],%r12
	ld.w	%r4,%r13
	ext	0x4		; 	xld.w	[%sp+0x104],%r14
	ld.w	[%sp+0x4],%r14
	ld.w	%r7,0x0
	ext	0x4		; 	xld.w	[%sp+0x108],%r7
	ld.w	[%sp+0x8],%r7
	cmp	%r4,0x10	; 	xcmp	%r4,16
	jrgt	__LX147		; 	xjrgt	__L147
	ld.w	%r2,%sp
	jp	__LX148		; 	xjp	__L148
__LX147:				; __L147:
	ld.w	%r12,%r4
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	pseudo_alloca@rm	; 	xcall	pseudo_alloca
	call	pseudo_alloca@rl
	ld.w	%r2,%r10
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
__LX148:				; __L148:
	cmp	%r4,0x2		; 	xcmp	%r4,2
	jrgt	__LX149		; 	xjrgt	__L149
	int	2
	.word	__LC0
	.half	0x00000306
__LX149:				; __L149:
	ld.w	%r15,0x0
	ld.w	%r3,%r15
	cmp	%r15,%r4
	jrge	__LX151		; 	xjrge	__L151
__LX153:				; __L153:
	ld.w	%r0,%r15
	sll	%r0,0x3		; 	xsll	%r0,3
	ext	0x4		; 	xld.w	%r7,[%sp+0x100]
	ld.w	%r7,[%sp+0x0]
	add	%r7,%r0
	ld.w	%r0,%r7
	ext	0x1		; 	xadd	%r1,%r15,1
	add	%r1,%r15
	ld.w	%r12,%r1
	ld.w	%r13,%r4
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	__modsi3@rm	; 	xcall	__modsi3
	call	__modsi3@rl
	sll	%r10,0x3	; 	xsll	%r10,3
	ld.w	%r12,%r0
	ext	0x4		; 	xld.w	%r13,[%sp+0x100]
	ld.w	%r13,[%sp+0x0]
	add	%r13,%r10
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	add	%r3,%r10
	ld.w	%r15,%r1
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	cmp	%r15,%r4
	jrlt	__LX153		; 	xjrlt	__L153
__LX151:				; __L151:
	cmp	%r3,0x0
	ext	__LX193@rm	; 	xjreq	__L193
	jreq	__LX193@rl
	ld.w	%r15,0x0
	cmp	%r15,%r4
	ext	__LX195@rm	; 	xjrge	__L195
	jrge	__LX195@rl
	ld.w	%r12,%r2
__LX159:				; __L159:
	ld.w	%r10,%r15
	sll	%r10,0x3	; 	xsll	%r10,3
	cmp	%r3,0x0
	jrgt	__LX160		; 	xjrgt	__L160
	ext	0x1		; 	xadd	%r10,%r15,1
	add	%r10,%r15
	ld.w	%r7,%r4
	sub	%r7,%r10
	ld.w	%r10,%r7
	sll	%r10,0x3	; 	xsll	%r10,3
__LX160:				; __L160:
	ext	0x4		; 	xld.w	%r7,[%sp+0x100]
	ld.w	%r7,[%sp+0x0]
	add	%r7,%r10
	ld.w	%r10,%r7
	ext	0x4		; 	xld.w	%r11,[%r10+0x4]
	ld.w	%r11,[%r10]
	ld.w	%r10,[%r10]	; 	xld.w	%r10,[%r10]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	[%r12+0x4],%r11
	ld.w	[%r12],%r11
	add	%r12,0x8	; 	xadd	%r12,%r12,8
	add	%r15,0x1	; 	xadd	%r15,%r15,1
	cmp	%r15,%r4
	jrlt	__LX159		; 	xjrlt	__L159
	ext	__LX195@rm	; 	xjp	__L195
	jp	__LX195@rl
__LX165:				; __L165:
	ld.w	%r15,0x0
	cmp	%r15,%r4
	ext	__LX193@rm	; 	xjrge	__L193
	jrge	__LX193@rl
__LX169:				; __L169:
	ext	0x8		; 	xld.w	%r10,[%r2+0x8]
	ld.w	%r10,[%r2]
	ld.w	%r11,[%r2]	; 	xld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x20],%r10	; 	xld.w	[%sp+0x80],%r10
	ext	0xc		; 	xld.w	%r10,[%r2+0xc]
	ld.w	%r10,[%r2]
	ext	0x4		; 	xld.w	%r11,[%r2+0x4]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x21],%r10	; 	xld.w	[%sp+0x84],%r10
	ext	0x10		; 	xld.w	%r10,[%r2+0x10]
	ld.w	%r10,[%r2]
	ext	0x8		; 	xld.w	%r11,[%r2+0x8]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x22],%r10	; 	xld.w	[%sp+0x88],%r10
	ext	0x14		; 	xld.w	%r10,[%r2+0x14]
	ld.w	%r10,[%r2]
	ext	0xc		; 	xld.w	%r11,[%r2+0xc]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x23],%r10	; 	xld.w	[%sp+0x8c],%r10
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,128
	ext	0x2
	add	%r12,0x0
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,136
	ext	0x2
	add	%r13,0x8
	ext	0x4		; 	xld.w	[%sp+0x110],%r15
	ld.w	[%sp+0x10],%r15
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ext	0x4		; 	xld.w	%r15,[%sp+0x110]
	ld.w	%r15,[%sp+0x10]
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	cmp	%r10,0x0
	ext	__LX170@rm	; 	xjrlt	__L170
	jrlt	__LX170@rl
	ext	0x8		; 	xld.w	%r10,[%r2+0x8]
	ld.w	%r10,[%r2]
	ld.w	%r11,[%r2]	; 	xld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x36],%r10	; 	xld.w	[%sp+0xd8],%r10
	ext	0xc		; 	xld.w	%r10,[%r2+0xc]
	ld.w	%r10,[%r2]
	ext	0x4		; 	xld.w	%r11,[%r2+0x4]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x37],%r10	; 	xld.w	[%sp+0xdc],%r10
	ext	0x10		; 	xld.w	%r10,[%r2+0x10]
	ld.w	%r10,[%r2]
	ext	0x8		; 	xld.w	%r11,[%r2+0x8]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x3a],%r10	; 	xld.w	[%sp+0xe8],%r10
	ext	0x14		; 	xld.w	%r10,[%r2+0x14]
	ld.w	%r10,[%r2]
	ext	0xc		; 	xld.w	%r11,[%r2+0xc]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x3b],%r10	; 	xld.w	[%sp+0xec],%r10
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	ext	0x10		; 	xld.w	%r11,[%r2+0x10]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x3e],%r10	; 	xld.w	[%sp+0xf8],%r10
	ext	0x4		; 	xld.w	%r10,[%r2+0x4]
	ld.w	%r10,[%r2]
	ext	0x14		; 	xld.w	%r11,[%r2+0x14]
	ld.w	%r11,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x3f],%r10	; 	xld.w	[%sp+0xfc],%r10
	ld.w	%r3,[%r2]	; 	xld.w	%r3,[%r2]
	ext	0x4		; 	xld.w	%r1,[%r2+0x4]
	ld.w	%r1,[%r2]
	ld.w	[%sp+0x24],%r3	; 	xld.w	[%sp+0x90],%r3
	ext	0x8		; 	xld.w	%r10,[%r2+0x8]
	ld.w	%r10,[%r2]
	ld.w	[%sp+0x25],%r10	; 	xld.w	[%sp+0x94],%r10
	ld.w	%r11,%r3
	cmp	%r3,%r10
	jrle	__LX171		; 	xjrle	__L171
	ld.w	%r11,%r10
__LX171:				; __L171:
	ld.w	%r6,%r11
	ld.w	[%sp+0x26],%r3	; 	xld.w	[%sp+0x98],%r3
	ext	0x8		; 	xld.w	%r11,[%r2+0x8]
	ld.w	%r11,[%r2]
	ld.w	[%sp+0x27],%r11	; 	xld.w	[%sp+0x9c],%r11
	ld.w	%r10,%r3
	cmp	%r10,%r11
	jrge	__LX172		; 	xjrge	__L172
	ld.w	%r10,%r11
__LX172:				; __L172:
	ld.w	%r3,%r10
	ld.w	[%sp+0x28],%r1	; 	xld.w	[%sp+0xa0],%r1
	ext	0xc		; 	xld.w	%r10,[%r2+0xc]
	ld.w	%r10,[%r2]
	ld.w	[%sp+0x29],%r10	; 	xld.w	[%sp+0xa4],%r10
	ld.w	%r11,%r1
	cmp	%r1,%r10
	jrle	__LX173		; 	xjrle	__L173
	ld.w	%r11,%r10
__LX173:				; __L173:
	ld.w	%r5,%r11
	ld.w	[%sp+0x2a],%r1	; 	xld.w	[%sp+0xa8],%r1
	ext	0xc		; 	xld.w	%r11,[%r2+0xc]
	ld.w	%r11,[%r2]
	ld.w	[%sp+0x2b],%r11	; 	xld.w	[%sp+0xac],%r11
	ld.w	%r10,%r1
	cmp	%r10,%r11
	jrge	__LX174		; 	xjrge	__L174
	ld.w	%r10,%r11
__LX174:				; __L174:
	ld.w	%r1,%r10
	ld.w	[%sp+0x2c],%r6	; 	xld.w	[%sp+0xb0],%r6
	ext	0x10		; 	xld.w	%r11,[%r2+0x10]
	ld.w	%r11,[%r2]
	ld.w	[%sp+0x2d],%r11	; 	xld.w	[%sp+0xb4],%r11
	ld.w	%r10,%r6
	cmp	%r10,%r11
	jrle	__LX175		; 	xjrle	__L175
	ld.w	%r10,%r11
__LX175:				; __L175:
	ld.w	%r6,%r10
	ld.w	[%sp+0x2e],%r3	; 	xld.w	[%sp+0xb8],%r3
	ext	0x10		; 	xld.w	%r11,[%r2+0x10]
	ld.w	%r11,[%r2]
	ld.w	[%sp+0x2f],%r11	; 	xld.w	[%sp+0xbc],%r11
	ld.w	%r10,%r3
	cmp	%r10,%r11
	jrge	__LX176		; 	xjrge	__L176
	ld.w	%r10,%r11
__LX176:				; __L176:
	ld.w	%r3,%r10
	ld.w	[%sp+0x30],%r5	; 	xld.w	[%sp+0xc0],%r5
	ext	0x14		; 	xld.w	%r11,[%r2+0x14]
	ld.w	%r11,[%r2]
	ld.w	[%sp+0x31],%r11	; 	xld.w	[%sp+0xc4],%r11
	ld.w	%r10,%r5
	cmp	%r10,%r11
	jrle	__LX177		; 	xjrle	__L177
	ld.w	%r10,%r11
__LX177:				; __L177:
	ld.w	%r5,%r10
	ld.w	[%sp+0x32],%r1	; 	xld.w	[%sp+0xc8],%r1
	ext	0x14		; 	xld.w	%r11,[%r2+0x14]
	ld.w	%r11,[%r2]
	ld.w	[%sp+0x33],%r11	; 	xld.w	[%sp+0xcc],%r11
	ld.w	%r10,%r1
	cmp	%r10,%r11
	jrge	__LX178		; 	xjrge	__L178
	ld.w	%r10,%r11
__LX178:				; __L178:
	ld.w	%r1,%r10
	ld.w	%r14,0x3	; 	xld.w	%r14,0x00000003		; 3
	cmp	%r14,%r4
	ext	__LX180@rm	; 	xjrge	__L180
	jrge	__LX180@rl
	ext	0x18		; 	xadd	%r0,%r2,24
	add	%r0,%r2
__LX182:				; __L182:
	ld.w	%r11,[%r0]	; 	xld.w	%r11,[%r0]
	cmp	%r11,%r6
	ext	__LX181@rm	; 	xjrle	__L181
	jrle	__LX181@rl
	cmp	%r11,%r3
	ext	__LX181@rm	; 	xjrge	__L181
	jrge	__LX181@rl
	ext	0x4		; 	xld.w	%r10,[%r0+0x4]
	ld.w	%r10,[%r0]
	cmp	%r10,%r5
	jrle	__LX181		; 	xjrle	__L181
	cmp	%r10,%r1
	jrge	__LX181		; 	xjrge	__L181
	ld.w	%r10,[%r2]	; 	xld.w	%r10,[%r2]
	sub	%r10,%r11
	ld.w	[%sp+0x34],%r10	; 	xld.w	[%sp+0xd0],%r10
	ext	0x4		; 	xld.w	%r11,[%r2+0x4]
	ld.w	%r11,[%r2]
	ext	0x4		; 	xld.w	%r10,[%r0+0x4]
	ld.w	%r10,[%r0]
	sub	%r11,%r10
	ld.w	[%sp+0x35],%r11	; 	xld.w	[%sp+0xd4],%r11
	ext	0x8		; 	xld.w	%r11,[%r2+0x8]
	ld.w	%r11,[%r2]
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	sub	%r11,%r10
	ld.w	[%sp+0x38],%r11	; 	xld.w	[%sp+0xe0],%r11
	ext	0xc		; 	xld.w	%r11,[%r2+0xc]
	ld.w	%r11,[%r2]
	ext	0x4		; 	xld.w	%r10,[%r0+0x4]
	ld.w	%r10,[%r0]
	sub	%r11,%r10
	ld.w	[%sp+0x39],%r11	; 	xld.w	[%sp+0xe4],%r11
	ext	0x10		; 	xld.w	%r11,[%r2+0x10]
	ld.w	%r11,[%r2]
	ld.w	%r10,[%r0]	; 	xld.w	%r10,[%r0]
	sub	%r11,%r10
	ld.w	[%sp+0x3c],%r11	; 	xld.w	[%sp+0xf0],%r11
	ext	0x14		; 	xld.w	%r11,[%r2+0x14]
	ld.w	%r11,[%r2]
	ext	0x4		; 	xld.w	%r10,[%r0+0x4]
	ld.w	%r10,[%r0]
	sub	%r11,%r10
	ld.w	[%sp+0x3d],%r11	; 	xld.w	[%sp+0xf4],%r11
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,208
	ext	0x3
	add	%r12,0x10
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,216
	ext	0x3
	add	%r13,0x18
	ext	0x4		; 	xld.w	[%sp+0x10c],%r14
	ld.w	[%sp+0xc],%r14
	ext	0x4		; 	xld.w	[%sp+0x110],%r15
	ld.w	[%sp+0x10],%r15
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	0x4		; 	xld.w	[%sp+0x118],%r5
	ld.w	[%sp+0x18],%r5
	ext	0x4		; 	xld.w	[%sp+0x11c],%r6
	ld.w	[%sp+0x1c],%r6
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ext	0x4		; 	xld.w	%r14,[%sp+0x10c]
	ld.w	%r14,[%sp+0xc]
	ext	0x4		; 	xld.w	%r15,[%sp+0x110]
	ld.w	%r15,[%sp+0x10]
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	ext	0x4		; 	xld.w	%r5,[%sp+0x118]
	ld.w	%r5,[%sp+0x18]
	ext	0x4		; 	xld.w	%r6,[%sp+0x11c]
	ld.w	%r6,[%sp+0x1c]
	cmp	%r10,0x0
	jrle	__LX181		; 	xjrle	__L181
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,224
	ext	0x3
	add	%r12,0x20
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,232
	ext	0x3
	add	%r13,0x28
	ext	0x4		; 	xld.w	[%sp+0x10c],%r14
	ld.w	[%sp+0xc],%r14
	ext	0x4		; 	xld.w	[%sp+0x110],%r15
	ld.w	[%sp+0x10],%r15
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	0x4		; 	xld.w	[%sp+0x118],%r5
	ld.w	[%sp+0x18],%r5
	ext	0x4		; 	xld.w	[%sp+0x11c],%r6
	ld.w	[%sp+0x1c],%r6
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ext	0x4		; 	xld.w	%r14,[%sp+0x10c]
	ld.w	%r14,[%sp+0xc]
	ext	0x4		; 	xld.w	%r15,[%sp+0x110]
	ld.w	%r15,[%sp+0x10]
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	ext	0x4		; 	xld.w	%r5,[%sp+0x118]
	ld.w	%r5,[%sp+0x18]
	ext	0x4		; 	xld.w	%r6,[%sp+0x11c]
	ld.w	%r6,[%sp+0x1c]
	cmp	%r10,0x0
	jrle	__LX181		; 	xjrle	__L181
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,240
	ext	0x3
	add	%r12,0x30
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,248
	ext	0x3
	add	%r13,0x38
	ext	0x4		; 	xld.w	[%sp+0x10c],%r14
	ld.w	[%sp+0xc],%r14
	ext	0x4		; 	xld.w	[%sp+0x110],%r15
	ld.w	[%sp+0x10],%r15
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	0x4		; 	xld.w	[%sp+0x118],%r5
	ld.w	[%sp+0x18],%r5
	ext	0x4		; 	xld.w	[%sp+0x11c],%r6
	ld.w	[%sp+0x1c],%r6
	ext	vec2i_cross@rm	; 	xcall	vec2i_cross
	call	vec2i_cross@rl
	ext	0x4		; 	xld.w	%r14,[%sp+0x10c]
	ld.w	%r14,[%sp+0xc]
	ext	0x4		; 	xld.w	%r15,[%sp+0x110]
	ld.w	%r15,[%sp+0x10]
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	ext	0x4		; 	xld.w	%r5,[%sp+0x118]
	ld.w	%r5,[%sp+0x18]
	ext	0x4		; 	xld.w	%r6,[%sp+0x11c]
	ld.w	%r6,[%sp+0x1c]
	cmp	%r10,0x0
	jrgt	__LX180		; 	xjrgt	__L180
__LX181:				; __L181:
	add	%r0,0x8		; 	xadd	%r0,%r0,8
	add	%r14,0x1	; 	xadd	%r14,%r14,1
	cmp	%r14,%r4
	ext	__LX182@rm	; 	xjrlt	__L182
	jrlt	__LX182@rl
__LX180:				; __L180:
	cmp	%r14,%r4
	jreq	__LX167		; 	xjreq	__L167
__LX170:				; __L170:
	ld.w	%r12,%r2
	ld.w	%r13,0x8	; 	xld.w	%r13,0x00000008		; 8
	ld.w	%r14,%r4
	sll	%r14,0x3	; 	xsll	%r14,3
	ext	0x4		; 	xld.w	[%sp+0x110],%r15
	ld.w	[%sp+0x10],%r15
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	memrotate@rm	; 	xcall	memrotate
	call	memrotate@rl
	ext	0x4		; 	xld.w	%r15,[%sp+0x110]
	ld.w	%r15,[%sp+0x10]
	add	%r15,0x1	; 	xadd	%r15,%r15,1
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	cmp	%r15,%r4
	ext	__LX169@rm	; 	xjrlt	__L169
	jrlt	__LX169@rl
__LX167:				; __L167:
	cmp	%r15,%r4
	jrge	__LX193		; 	xjrge	__L193
	ld.w	%r14,0x18	; 	xld.w	%r14,0x00000018		; 24
	ext	0x4		; 	xld.w	%r7,[%sp+0x108]
	ld.w	%r7,[%sp+0x8]
	mlt.w	%r7,%r14
	ld.w	%r12,%alr
	ext	0x4		; 	xld.w	%r7,[%sp+0x104]
	ld.w	%r7,[%sp+0x4]
	add	%r12,%r7
	ld.w	%r13,%r2
	ext	0x4		; 	xld.w	[%sp+0x114],%r4
	ld.w	[%sp+0x14],%r4
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ext	0x4		; 	xld.w	%r7,[%sp+0x108]
	ld.w	%r7,[%sp+0x8]
	add	%r7,0x1		; 	xadd	%r7,%r7,1
	ext	0x4		; 	xld.w	[%sp+0x108],%r7
	ld.w	[%sp+0x8],%r7
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	ext	0x2		; 	xsub	%r14,%r4,2
	sub	%r14,%r4
	ext	0x8		; 	xadd	%r12,%r2,8
	add	%r12,%r2
	ext	0x10		; 	xadd	%r13,%r2,16
	add	%r13,%r2
	sll	%r14,0x3	; 	xsll	%r14,3
	ext	memmove@rm	; 	xcall	memmove
	call	memmove@rl
	ext	0x4		; 	xld.w	%r4,[%sp+0x114]
	ld.w	%r4,[%sp+0x14]
	sub	%r4,0x1		; 	xsub	%r4,%r4,1
__LX195:				; __L195:
	cmp	%r4,0x2		; 	xcmp	%r4,2
	ext	__LX165@rm	; 	xjrgt	__L165
	jrgt	__LX165@rl
__LX193:				; __L193:
	ext	0x4		; 	xld.w	%r10,[%sp+0x108]
	ld.w	%r10,[%sp+0x8]
	add	%sp,0x48	; 	xadd	%sp,%sp,288
	popn	%r3
	ret
	.align	1
	.global	render_vec2i_alternate_concaves
render_vec2i_alternate_concaves:
;	.frame	%sp,40,$31		# vars= 20, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x5		; 	xsub	%sp,%sp,20
	ld.w	%r3,%r12
	ld.w	[%sp+0x2],%r13	; 	xld.w	[%sp+0x8],%r13
	ld.w	[%sp+0x3],%r14	; 	xld.w	[%sp+0xc],%r14
	ld.w	[%sp+0x4],%r15	; 	xld.w	[%sp+0x10],%r15
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r0,[%r13]	; 	xld.w	%r0,[%r13]
	ld.w	%r2,%r0
	ext	0x4		; 	xld.w	%r1,[%r13+0x4]
	ld.w	%r1,[%r13]
	ld.w	%r15,%r1
	ld.w	%r5,[%sp+0x4]	; 	xld.w	%r5,[%sp+0x10]
	cmp	%r5,0x0
	jrle	__LX198		; 	xjrle	__L198
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]
	ld.w	%r10,%r5
	sll	%r10,0x2	; 	xsll	%r10,2
	add	%r10,%r14
__LX200:				; __L200:
	ld.w	%r12,0x0
	ld.w	%r11,[%r14]	; 	xld.w	%r11,[%r14]
	cmp	%r12,%r11
	jrge	__LX199		; 	xjrge	__L199
	ld.w	%r4,%r11
__LX204:				; __L204:
	ld.w	%r11,[%r13]	; 	xld.w	%r11,[%r13]
	cmp	%r11,%r2
	jrge	__LX205		; 	xjrge	__L205
	ld.w	%r2,%r11
__LX205:				; __L205:
	cmp	%r11,%r0
	jrle	__LX206		; 	xjrle	__L206
	ld.w	%r0,%r11
__LX206:				; __L206:
	ext	0x4		; 	xld.w	%r11,[%r13+0x4]
	ld.w	%r11,[%r13]
	cmp	%r11,%r15
	jrge	__LX207		; 	xjrge	__L207
	ld.w	%r15,%r11
__LX207:				; __L207:
	cmp	%r11,%r1
	jrle	__LX208		; 	xjrle	__L208
	ld.w	%r1,%r11
__LX208:				; __L208:
	add	%r13,0x8	; 	xadd	%r13,%r13,8
	add	%r12,0x1	; 	xadd	%r12,%r12,1
	cmp	%r12,%r4
	jrlt	__LX204		; 	xjrlt	__L204
__LX199:				; __L199:
	add	%r14,0x4	; 	xadd	%r14,%r14,4
	cmp	%r14,%r10
	jrlt	__LX200		; 	xjrlt	__L200
__LX198:				; __L198:
	ext	0x4		; 	xld.h	%r10,[%r3+0x4]
	ld.h	%r10,[%r3]
	cmp	%r2,%r10
	jrge	__LX211		; 	xjrge	__L211
	ld.w	%r2,%r10
__LX211:				; __L211:
	ext	0x8		; 	xld.h	%r10,[%r3+0x8]
	ld.h	%r10,[%r3]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r0,%r10
	jrle	__LX212		; 	xjrle	__L212
	ld.w	%r0,%r10
__LX212:				; __L212:
	ext	0x6		; 	xld.h	%r10,[%r3+0x6]
	ld.h	%r10,[%r3]
	cmp	%r15,%r10
	jrge	__LX213		; 	xjrge	__L213
	ld.w	%r15,%r10
__LX213:				; __L213:
	ext	0xa		; 	xld.h	%r10,[%r3+0xa]
	ld.h	%r10,[%r3]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r1,%r10
	jrle	__LX214		; 	xjrle	__L214
	ld.w	%r1,%r10
__LX214:				; __L214:
	ld.w	[%sp+0x1],%r15	; 	xld.w	[%sp+0x4],%r15
	cmp	%r15,%r1
	jrgt	__LX216		; 	xjrgt	__L216
__LX218:				; __L218:
	ld.w	[%sp+0x0],%r2	; 	xld.w	[%sp],%r2
	cmp	%r2,%r0
	jrgt	__LX217		; 	xjrgt	__L217
__LX222:				; __L222:
	ld.w	%r12,%sp
	ld.w	%r13,[%sp+0x2]	; 	xld.w	%r13,[%sp+0x8]
	ld.w	%r14,[%sp+0x3]	; 	xld.w	%r14,[%sp+0xc]
	ld.w	%r15,[%sp+0x4]	; 	xld.w	%r15,[%sp+0x10]
	ext	vec2i_is_point_in_alternate_concaves@rm	; 	xcall	vec2i_is_point_in_alternate_concaves
	call	vec2i_is_point_in_alternate_concaves@rl
	cmp	%r10,0x0
	jreq	__LX221		; 	xjreq	__L221
	ld.w	%r12,%r3
	ld.w	%r13,[%sp+0x0]	; 	xld.w	%r13,[%sp]
	ld.w	%r14,[%sp+0x1]	; 	xld.w	%r14,[%sp+0x4]
	ld.w	%r15,[%sp+0xa]	; 	xld.w	%r15,[%sp+0x28]
	ext	render_point@rm	; 	xcall	render_point
	call	render_point@rl
__LX221:				; __L221:
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	cmp	%r10,%r0
	jrle	__LX222		; 	xjrle	__L222
__LX217:				; __L217:
	ld.w	%r10,[%sp+0x1]	; 	xld.w	%r10,[%sp+0x4]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4],%r10
	cmp	%r10,%r1
	jrle	__LX218		; 	xjrle	__L218
__LX216:				; __L216:
	add	%sp,0x5		; 	xadd	%sp,%sp,20
	popn	%r3
	ret
	.align	1
	.global	render_vec2i_thick_polyline
render_vec2i_thick_polyline:
;	.frame	%sp,216,$31		# vars= 192, regs= 5/0, args= 4, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x31	; 	xsub	%sp,%sp,196
	ld.w	[%sp+0x1c],%r12	; 	xld.w	[%sp+0x70],%r12
	ld.w	[%sp+0x1d],%r14	; 	xld.w	[%sp+0x74],%r14
	ld.w	[%sp+0x1e],%r15	; 	xld.w	[%sp+0x78],%r15
	ld.w	%r11,%r14
	sub	%r11,0x1	; 	xsub	%r11,%r11,1
	ld.w	%r5,%r11
	sll	%r5,0x2		; 	xsll	%r5,2
	ld.w	[%sp+0x20],%r5	; 	xld.w	[%sp+0x80],%r5
	ld.w	%r10,%r11
	sll	%r10,0x5	; 	xsll	%r10,5
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r10,%r5
	ld.w	[%sp+0x22],%r10	; 	xld.w	[%sp+0x88],%r10
	ld.w	%r5,0x0
	ld.w	[%sp+0x1f],%r5	; 	xld.w	[%sp+0x7c],%r5
	cmp	%r5,%r11
	ext	__LX228@rm	; 	xjrge	__L228
	jrge	__LX228@rl
	ld.w	%r4,[%sp+0x22]	; 	xld.w	%r4,[%sp+0x88]
	ld.w	[%sp+0x2c],%r13	; 	xld.w	[%sp+0xb0],%r13
__LX230:				; __L230:
	ld.w	%r5,[%sp+0x2c]	; 	xld.w	%r5,[%sp+0xb0]
	ld.w	%r14,[%r5]	; 	xld.w	%r14,[%r5]
	ext	0x4		; 	xld.w	%r15,[%r5+0x4]
	ld.w	%r15,[%r5]
	ext	0x8		; 	xld.w	%r0,[%r5+0x8]
	ld.w	%r0,[%r5]
	ext	0xc		; 	xld.w	%r1,[%r5+0xc]
	ld.w	%r1,[%r5]
	ld.w	%r10,%r0
	sub	%r10,%r14
	ld.w	[%sp+0x1],%r10	; 	xld.w	[%sp+0x4],%r10
	ld.w	%r10,%r1
	sub	%r10,%r15
	ld.w	[%sp+0x2],%r10	; 	xld.w	[%sp+0x8],%r10
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,4
	add	%r12,0x4
	ld.w	[%sp+0x2e],%r14	; 	xld.w	[%sp+0xb8],%r14
	ld.w	[%sp+0x2f],%r15	; 	xld.w	[%sp+0xbc],%r15
	ld.w	[%sp+0x30],%r4	; 	xld.w	[%sp+0xc0],%r4
	ext	vec2i_mag@rm	; 	xcall	vec2i_mag
	call	vec2i_mag@rl
	ld.w	[%sp+0x23],%r10	; 	xld.w	[%sp+0x8c],%r10
	ld.w	%r14,[%sp+0x2e]	; 	xld.w	%r14,[%sp+0xb8]
	ld.w	%r15,[%sp+0x2f]	; 	xld.w	%r15,[%sp+0xbc]
	ld.w	%r4,[%sp+0x30]	; 	xld.w	%r4,[%sp+0xc0]
	cmp	%r10,0x0
	jreq	__LX231		; 	xjreq	__L231
	ld.w	%r5,[%sp+0x2]	; 	xld.w	%r5,[%sp+0x8]
	not	%r0,%r5
	add	%r0,1
	ld.w	%r1,[%sp+0x1]	; 	xld.w	%r1,[%sp+0x4]
	ld.w	%r5,[%sp+0x1e]	; 	xld.w	%r5,[%sp+0x78]
	mlt.w	%r5,%r0
	ld.w	%r5,%alr
	ld.w	[%sp+0x24],%r5	; 	xld.w	[%sp+0x90],%r5
	ld.w	%r11,%r10
	sll	%r11,0x1	; 	xsll	%r11,1
	ld.w	%r12,[%sp+0x24]	; 	xld.w	%r12,[%sp+0x90]
	ld.w	%r13,%r11
	ld.w	[%sp+0x2d],%r11	; 	xld.w	[%sp+0xb4],%r11
	ld.w	[%sp+0x2e],%r14	; 	xld.w	[%sp+0xb8],%r14
	ld.w	[%sp+0x2f],%r15	; 	xld.w	[%sp+0xbc],%r15
	ld.w	[%sp+0x30],%r4	; 	xld.w	[%sp+0xc0],%r4
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r14,[%sp+0x2e]	; 	xld.w	%r14,[%sp+0xb8]
	ld.w	%r15,[%sp+0x2f]	; 	xld.w	%r15,[%sp+0xbc]
	ld.w	%r2,%r14
	sub	%r2,%r10
	ld.w	%r5,[%sp+0x1e]	; 	xld.w	%r5,[%sp+0x78]
	mlt.w	%r5,%r1
	ld.w	%r5,%alr
	ld.w	[%sp+0x25],%r5	; 	xld.w	[%sp+0x94],%r5
	ld.w	%r12,[%sp+0x25]	; 	xld.w	%r12,[%sp+0x94]
	ld.w	%r11,[%sp+0x2d]	; 	xld.w	%r11,[%sp+0xb4]
	ld.w	%r13,%r11
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r14,[%sp+0x2e]	; 	xld.w	%r14,[%sp+0xb8]
	ld.w	%r15,[%sp+0x2f]	; 	xld.w	%r15,[%sp+0xbc]
	ld.w	%r3,%r15
	sub	%r3,%r10
	ld.w	%r12,[%sp+0x24]	; 	xld.w	%r12,[%sp+0x90]
	ld.w	%r13,[%sp+0x23]	; 	xld.w	%r13,[%sp+0x8c]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r0,%r2
	add	%r0,%r10
	ld.w	%r12,[%sp+0x25]	; 	xld.w	%r12,[%sp+0x94]
	ld.w	%r13,[%sp+0x23]	; 	xld.w	%r13,[%sp+0x8c]
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ld.w	%r1,%r3
	add	%r1,%r10
	ld.w	%r12,%r2
	ld.w	%r5,[%sp+0x1]	; 	xld.w	%r5,[%sp+0x4]
	add	%r12,%r5
	ld.w	%r13,%r3
	ld.w	%r5,[%sp+0x2]	; 	xld.w	%r5,[%sp+0x8]
	add	%r13,%r5
	ld.w	%r10,%r0
	ld.w	%r5,[%sp+0x1]	; 	xld.w	%r5,[%sp+0x4]
	add	%r10,%r5
	ld.w	%r11,%r1
	ld.w	%r5,[%sp+0x2]	; 	xld.w	%r5,[%sp+0x8]
	add	%r11,%r5
	ld.w	%r4,[%sp+0x30]	; 	xld.w	%r4,[%sp+0xc0]
	ld.w	[%r4],%r2	; 	xld.w	[%r4],%r2
	ext	0x4		; 	xld.w	[%r4+0x4],%r3
	ld.w	[%r4],%r3
	ext	0x8		; 	xld.w	[%r4+0x8],%r12
	ld.w	[%r4],%r12
	ext	0xc		; 	xld.w	[%r4+0xc],%r13
	ld.w	[%r4],%r13
	ext	0x10		; 	xld.w	[%r4+0x10],%r0
	ld.w	[%r4],%r0
	ext	0x14		; 	xld.w	[%r4+0x14],%r1
	ld.w	[%r4],%r1
	ext	0x18		; 	xld.w	[%r4+0x18],%r10
	ld.w	[%r4],%r10
	ext	0x1c		; 	xld.w	[%r4+0x1c],%r11
	ld.w	[%r4],%r11
	jp	__LX229		; 	xjp	__L229
__LX231:				; __L231:
	ext	0x10		; 	xld.w	[%r4+0x10],%r14
	ld.w	[%r4],%r14
	ext	0x14		; 	xld.w	[%r4+0x14],%r15
	ld.w	[%r4],%r15
	ld.w	[%r4],%r14	; 	xld.w	[%r4],%r14
	ext	0x4		; 	xld.w	[%r4+0x4],%r15
	ld.w	[%r4],%r15
	ext	0x18		; 	xld.w	[%r4+0x18],%r0
	ld.w	[%r4],%r0
	ext	0x1c		; 	xld.w	[%r4+0x1c],%r1
	ld.w	[%r4],%r1
	ext	0x8		; 	xld.w	[%r4+0x8],%r0
	ld.w	[%r4],%r0
	ext	0xc		; 	xld.w	[%r4+0xc],%r1
	ld.w	[%r4],%r1
__LX229:				; __L229:
	add	%r4,0x20	; 	xadd	%r4,%r4,32
	ld.w	%r5,[%sp+0x2c]	; 	xld.w	%r5,[%sp+0xb0]
	add	%r5,0x8		; 	xadd	%r5,%r5,8
	ld.w	[%sp+0x2c],%r5	; 	xld.w	[%sp+0xb0],%r5
	ld.w	%r5,[%sp+0x1f]	; 	xld.w	%r5,[%sp+0x7c]
	add	%r5,0x1		; 	xadd	%r5,%r5,1
	ld.w	[%sp+0x1f],%r5	; 	xld.w	[%sp+0x7c],%r5
	ld.w	%r10,[%sp+0x1d]	; 	xld.w	%r10,[%sp+0x74]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r5,%r10
	ext	__LX230@rm	; 	xjrlt	__L230
	jrlt	__LX230@rl
__LX228:				; __L228:
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	sra	%r5,0x1		; 	xsra	%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	ld.w	%r10,%r5
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,0x0
	ld.w	[%sp+0x1f],%r5	; 	xld.w	[%sp+0x7c],%r5
	ld.w	%r10,[%sp+0x1d]	; 	xld.w	%r10,[%sp+0x74]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r5,%r10
	ext	__LX235@rm	; 	xjrge	__L235
	jrge	__LX235@rl
	ld.w	%r5,%sp		; 	xadd	%r5,%sp,20
	add	%r5,0x14
	ld.w	[%sp+0x27],%r5	; 	xld.w	[%sp+0x9c],%r5
	ld.w	%r5,%sp		; 	xadd	%r5,%sp,4
	add	%r5,0x4
	ld.w	[%sp+0x2a],%r5	; 	xld.w	[%sp+0xa8],%r5
	add	%r5,0x20	; 	xadd	%r5,%r5,32
	ld.w	[%sp+0x28],%r5	; 	xld.w	[%sp+0xa0],%r5
	ld.w	%r5,[%sp+0x22]	; 	xld.w	%r5,[%sp+0x88]
	ld.w	[%sp+0x2b],%r5	; 	xld.w	[%sp+0xac],%r5
	ld.w	%r10,[%sp+0x21]	; 	xld.w	%r10,[%sp+0x84]
	sll	%r10,0x3	; 	xsll	%r10,3
	ld.w	%r1,%r10
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r1,%r5
__LX237:				; __L237:
	ld.w	%r5,[%sp+0x2b]	; 	xld.w	%r5,[%sp+0xac]
	ld.w	%r12,[%r5]	; 	xld.w	%r12,[%r5]
	ext	0x4		; 	xld.w	%r13,[%r5+0x4]
	ld.w	%r13,[%r5]
	ld.w	[%sp+0x3],%r12	; 	xld.w	[%sp+0xc],%r12
	ld.w	[%sp+0x4],%r13	; 	xld.w	[%sp+0x10],%r13
	ext	0x8		; 	xld.w	%r10,[%r5+0x8]
	ld.w	%r10,[%r5]
	ext	0xc		; 	xld.w	%r11,[%r5+0xc]
	ld.w	%r11,[%r5]
	ld.w	[%sp+0x5],%r10	; 	xld.w	[%sp+0x14],%r10
	ld.w	[%sp+0x6],%r11	; 	xld.w	[%sp+0x18],%r11
	ext	0x10		; 	xld.w	%r10,[%r5+0x10]
	ld.w	%r10,[%r5]
	ext	0x14		; 	xld.w	%r11,[%r5+0x14]
	ld.w	%r11,[%r5]
	ld.w	[%sp+0xd],%r10	; 	xld.w	[%sp+0x34],%r10
	ld.w	[%sp+0xe],%r11	; 	xld.w	[%sp+0x38],%r11
	ext	0x18		; 	xld.w	%r10,[%r5+0x18]
	ld.w	%r10,[%r5]
	ext	0x1c		; 	xld.w	%r11,[%r5+0x1c]
	ld.w	%r11,[%r5]
	ld.w	[%sp+0xf],%r10	; 	xld.w	[%sp+0x3c],%r10
	ld.w	[%sp+0x10],%r11	; 	xld.w	[%sp+0x40],%r11
	ld.w	%r5,[%sp+0x1f]	; 	xld.w	%r5,[%sp+0x7c]
	cmp	%r5,0x0
	jrne	__LX238		; 	xjrne	__L238
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX239		; 	xjrge	__L239
	int	2
	.word	__LC0
	.half	0x00000409
__LX239:				; __L239:
	ld.w	[%r1],%r12	; 	xld.w	[%r1],%r12
	ext	0x4		; 	xld.w	[%r1+0x4],%r13
	ld.w	[%r1],%r13
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX240		; 	xjrlt	__L240
	int	2
	.word	__LC0
	.half	0x0000040f
__LX240:				; __L240:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0xd]	; 	xld.w	%r10,[%sp+0x34]
	ld.w	%r11,[%sp+0xe]	; 	xld.w	%r11,[%sp+0x38]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	[%r12+0x4],%r11
	ld.w	[%r12],%r11
__LX238:				; __L238:
	ld.w	%r10,[%sp+0x1d]	; 	xld.w	%r10,[%sp+0x74]
	sub	%r10,0x2	; 	xsub	%r10,%r10,2
	ld.w	%r5,[%sp+0x1f]	; 	xld.w	%r5,[%sp+0x7c]
	cmp	%r5,%r10
	ext	__LX241@rm	; 	xjrge	__L241
	jrge	__LX241@rl
	ld.w	%r10,[%sp+0x2b]	; 	xld.w	%r10,[%sp+0xac]
	add	%r10,0x20	; 	xadd	%r10,%r10,32
	ext	0x4		; 	xld.w	%r11,[%r10+0x4]
	ld.w	%r11,[%r10]
	ld.w	%r10,[%r10]	; 	xld.w	%r10,[%r10]
	ld.w	[%sp+0x7],%r10	; 	xld.w	[%sp+0x1c],%r10
	ld.w	[%sp+0x8],%r11	; 	xld.w	[%sp+0x20],%r11
	ld.w	%r10,[%sp+0x2b]	; 	xld.w	%r10,[%sp+0xac]
	add	%r10,0x28	; 	xadd	%r10,%r10,40
	ext	0x4		; 	xld.w	%r11,[%r10+0x4]
	ld.w	%r11,[%r10]
	ld.w	%r10,[%r10]	; 	xld.w	%r10,[%r10]
	ld.w	[%sp+0x9],%r10	; 	xld.w	[%sp+0x24],%r10
	ld.w	[%sp+0xa],%r11	; 	xld.w	[%sp+0x28],%r11
	ld.w	%r10,[%sp+0x2b]	; 	xld.w	%r10,[%sp+0xac]
	add	%r10,0x30	; 	xadd	%r10,%r10,48
	ext	0x4		; 	xld.w	%r11,[%r10+0x4]
	ld.w	%r11,[%r10]
	ld.w	%r10,[%r10]	; 	xld.w	%r10,[%r10]
	ld.w	[%sp+0x11],%r10	; 	xld.w	[%sp+0x44],%r10
	ld.w	[%sp+0x12],%r11	; 	xld.w	[%sp+0x48],%r11
	ld.w	%r10,[%sp+0x2b]	; 	xld.w	%r10,[%sp+0xac]
	add	%r10,0x38	; 	xadd	%r10,%r10,56
	ext	0x4		; 	xld.w	%r11,[%r10+0x4]
	ld.w	%r11,[%r10]
	ld.w	%r10,[%r10]	; 	xld.w	%r10,[%r10]
	ld.w	[%sp+0x13],%r10	; 	xld.w	[%sp+0x4c],%r10
	ld.w	[%sp+0x14],%r11	; 	xld.w	[%sp+0x50],%r11
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,12
	add	%r0,0xc
	ld.w	%r2,%sp		; 	xadd	%r2,%sp,28
	add	%r2,0x1c
	ld.w	%r12,%r0
	ld.w	%r13,[%sp+0x27]	; 	xld.w	%r13,[%sp+0x9c]
	ld.w	%r14,%r2
	ld.w	%r15,[%sp+0x28]	; 	xld.w	%r15,[%sp+0xa0]
	ext	vec2i_is_intersected_ls@rm	; 	xcall	vec2i_is_intersected_ls
	call	vec2i_is_intersected_ls@rl
	cmp	%r10,0x0
	ext	__LX242@rm	; 	xjreq	__L242
	jreq	__LX242@rl
	ld.w	%r5,[%sp+0x2a]	; 	xld.w	%r5,[%sp+0xa8]
	add	%r5,0x28	; 	xadd	%r5,%r5,40
	ld.w	[%sp+0x29],%r5	; 	xld.w	[%sp+0xa4],%r5
	ld.w	%r5,[%sp+0x28]	; 	xld.w	%r5,[%sp+0xa0]
	ld.w	[%sp+0x0],%r5	; 	xld.w	[%sp],%r5
	ld.w	%r12,[%sp+0x29]	; 	xld.w	%r12,[%sp+0xa4]
	ld.w	%r13,%r0
	ld.w	%r14,[%sp+0x27]	; 	xld.w	%r14,[%sp+0x9c]
	ld.w	%r15,%r2
	ext	vec2i_intersection_l@rm	; 	xcall	vec2i_intersection_l
	call	vec2i_intersection_l@rl
	ld.w	%r10,[%sp+0xb]	; 	xld.w	%r10,[%sp+0x2c]
	ld.w	%r11,[%sp+0xc]	; 	xld.w	%r11,[%sp+0x30]
	ld.w	[%sp+0x15],%r10	; 	xld.w	[%sp+0x54],%r10
	ld.w	[%sp+0x16],%r11	; 	xld.w	[%sp+0x58],%r11
	ld.w	%r2,[%sp+0x2a]	; 	xld.w	%r2,[%sp+0xa8]
	add	%r2,0x30	; 	xadd	%r2,%r2,48
	ld.w	%r3,[%sp+0x2a]	; 	xld.w	%r3,[%sp+0xa8]
	add	%r3,0x38	; 	xadd	%r3,%r3,56
	ld.w	%r11,[%sp+0x2a]	; 	xld.w	%r11,[%sp+0xa8]
	ext	0x1		; 	xadd	%r11,%r11,64
	add	%r11,0x0
	ld.w	%r0,[%sp+0x2a]	; 	xld.w	%r0,[%sp+0xa8]
	ext	0x1		; 	xadd	%r0,%r0,72
	add	%r0,0x8
	ld.w	%r12,%r2
	ld.w	%r13,%r3
	ld.w	%r14,%r11
	ld.w	%r15,%r0
	ld.w	[%sp+0x2d],%r11	; 	xld.w	[%sp+0xb4],%r11
	ext	vec2i_is_intersected_ls@rm	; 	xcall	vec2i_is_intersected_ls
	call	vec2i_is_intersected_ls@rl
	ld.w	%r11,[%sp+0x2d]	; 	xld.w	%r11,[%sp+0xb4]
	cmp	%r10,0x0
	jreq	__LX243		; 	xjreq	__L243
	ld.w	[%sp+0x0],%r0	; 	xld.w	[%sp],%r0
	ld.w	%r12,[%sp+0x29]	; 	xld.w	%r12,[%sp+0xa4]
	ld.w	%r13,%r2
	ld.w	%r14,%r3
	ld.w	%r15,%r11
	ext	vec2i_intersection_l@rm	; 	xcall	vec2i_intersection_l
	call	vec2i_intersection_l@rl
	ld.w	%r10,[%sp+0xb]	; 	xld.w	%r10,[%sp+0x2c]
	ld.w	%r11,[%sp+0xc]	; 	xld.w	%r11,[%sp+0x30]
	ld.w	[%sp+0x17],%r10	; 	xld.w	[%sp+0x5c],%r10
	ld.w	[%sp+0x18],%r11	; 	xld.w	[%sp+0x60],%r11
	ld.w	%r12,%r1
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	ext	0x1		; 	xadd	%r13,%r13,80
	add	%r13,0x10
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX244		; 	xjreq	__L244
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX245		; 	xjrge	__L245
	int	2
	.word	__LC0
	.half	0x00000425
__LX245:				; __L245:
	ld.w	%r10,[%sp+0x15]	; 	xld.w	%r10,[%sp+0x54]
	ld.w	%r11,[%sp+0x16]	; 	xld.w	%r11,[%sp+0x58]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX244:				; __L244:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	ext	0x1		; 	xadd	%r13,%r13,88
	add	%r13,0x18
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	ext	__LX236@rm	; 	xjreq	__L236
	jreq	__LX236@rl
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX247		; 	xjrlt	__L247
	int	2
	.word	__LC0
	.half	0x0000042b
__LX247:				; __L247:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0x17]	; 	xld.w	%r10,[%sp+0x5c]
	ld.w	%r11,[%sp+0x18]	; 	xld.w	%r11,[%sp+0x60]
	ext	__LX279@rm	; 	xjp	__L279
	jp	__LX279@rl
__LX243:				; __L243:
	ld.w	%r12,%r1
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	ext	0x1		; 	xadd	%r13,%r13,80
	add	%r13,0x10
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX249		; 	xjreq	__L249
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX250		; 	xjrge	__L250
	int	2
	.word	__LC0
	.half	0x00000433
__LX250:				; __L250:
	ld.w	%r10,[%sp+0x15]	; 	xld.w	%r10,[%sp+0x54]
	ld.w	%r11,[%sp+0x16]	; 	xld.w	%r11,[%sp+0x58]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX249:				; __L249:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	add	%r13,0x38	; 	xadd	%r13,%r13,56
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX251		; 	xjreq	__L251
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX252		; 	xjrlt	__L252
	int	2
	.word	__LC0
	.half	0x00000439
__LX252:				; __L252:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0xf]	; 	xld.w	%r10,[%sp+0x3c]
	ld.w	%r11,[%sp+0x10]	; 	xld.w	%r11,[%sp+0x40]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	[%r12+0x4],%r11
	ld.w	[%r12],%r11
__LX251:				; __L251:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	ext	0x1		; 	xadd	%r13,%r13,64
	add	%r13,0x0
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	ext	__LX236@rm	; 	xjreq	__L236
	jreq	__LX236@rl
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX254		; 	xjrlt	__L254
	int	2
	.word	__LC0
	.half	0x0000043f
__LX254:				; __L254:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0x11]	; 	xld.w	%r10,[%sp+0x44]
	ld.w	%r11,[%sp+0x12]	; 	xld.w	%r11,[%sp+0x48]
	ext	__LX279@rm	; 	xjp	__L279
	jp	__LX279@rl
__LX242:				; __L242:
	ld.w	%r2,[%sp+0x2a]	; 	xld.w	%r2,[%sp+0xa8]
	add	%r2,0x30	; 	xadd	%r2,%r2,48
	ld.w	%r3,[%sp+0x2a]	; 	xld.w	%r3,[%sp+0xa8]
	add	%r3,0x38	; 	xadd	%r3,%r3,56
	ld.w	%r11,[%sp+0x2a]	; 	xld.w	%r11,[%sp+0xa8]
	ext	0x1		; 	xadd	%r11,%r11,64
	add	%r11,0x0
	ld.w	%r0,[%sp+0x2a]	; 	xld.w	%r0,[%sp+0xa8]
	ext	0x1		; 	xadd	%r0,%r0,72
	add	%r0,0x8
	ld.w	%r12,%r2
	ld.w	%r13,%r3
	ld.w	%r14,%r11
	ld.w	%r15,%r0
	ld.w	[%sp+0x2d],%r11	; 	xld.w	[%sp+0xb4],%r11
	ext	vec2i_is_intersected_ls@rm	; 	xcall	vec2i_is_intersected_ls
	call	vec2i_is_intersected_ls@rl
	ld.w	%r11,[%sp+0x2d]	; 	xld.w	%r11,[%sp+0xb4]
	cmp	%r10,0x0
	jreq	__LX256		; 	xjreq	__L256
	ld.w	[%sp+0x0],%r0	; 	xld.w	[%sp],%r0
	ld.w	%r12,[%sp+0x2a]	; 	xld.w	%r12,[%sp+0xa8]
	add	%r12,0x28	; 	xadd	%r12,%r12,40
	ld.w	%r13,%r2
	ld.w	%r14,%r3
	ld.w	%r15,%r11
	ext	vec2i_intersection_l@rm	; 	xcall	vec2i_intersection_l
	call	vec2i_intersection_l@rl
	ld.w	%r10,[%sp+0xb]	; 	xld.w	%r10,[%sp+0x2c]
	ld.w	%r11,[%sp+0xc]	; 	xld.w	%r11,[%sp+0x30]
	ld.w	[%sp+0x19],%r10	; 	xld.w	[%sp+0x64],%r10
	ld.w	[%sp+0x1a],%r11	; 	xld.w	[%sp+0x68],%r11
	ld.w	%r12,%r1
	ld.w	%r13,[%sp+0x27]	; 	xld.w	%r13,[%sp+0x9c]
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX257		; 	xjreq	__L257
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX258		; 	xjrge	__L258
	int	2
	.word	__LC0
	.half	0x0000044c
__LX258:				; __L258:
	ld.w	%r10,[%sp+0x5]	; 	xld.w	%r10,[%sp+0x14]
	ld.w	%r11,[%sp+0x6]	; 	xld.w	%r11,[%sp+0x18]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX257:				; __L257:
	ld.w	%r12,%r1
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,28
	add	%r13,0x1c
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX259		; 	xjreq	__L259
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX260		; 	xjrge	__L260
	int	2
	.word	__LC0
	.half	0x00000452
__LX260:				; __L260:
	ld.w	%r10,[%sp+0x7]	; 	xld.w	%r10,[%sp+0x1c]
	ld.w	%r11,[%sp+0x8]	; 	xld.w	%r11,[%sp+0x20]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX259:				; __L259:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	ext	0x1		; 	xadd	%r13,%r13,96
	add	%r13,0x20
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	ext	__LX236@rm	; 	xjreq	__L236
	jreq	__LX236@rl
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX262		; 	xjrlt	__L262
	int	2
	.word	__LC0
	.half	0x00000458
__LX262:				; __L262:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0x19]	; 	xld.w	%r10,[%sp+0x64]
	ld.w	%r11,[%sp+0x1a]	; 	xld.w	%r11,[%sp+0x68]
	ext	__LX279@rm	; 	xjp	__L279
	jp	__LX279@rl
__LX256:				; __L256:
	ld.w	%r12,%r1
	ld.w	%r13,[%sp+0x27]	; 	xld.w	%r13,[%sp+0x9c]
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX264		; 	xjreq	__L264
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX265		; 	xjrge	__L265
	int	2
	.word	__LC0
	.half	0x00000460
__LX265:				; __L265:
	ld.w	%r10,[%sp+0x5]	; 	xld.w	%r10,[%sp+0x14]
	ld.w	%r11,[%sp+0x6]	; 	xld.w	%r11,[%sp+0x18]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX264:				; __L264:
	ld.w	%r12,%r1
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,28
	add	%r13,0x1c
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX266		; 	xjreq	__L266
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX267		; 	xjrge	__L267
	int	2
	.word	__LC0
	.half	0x00000466
__LX267:				; __L267:
	ld.w	%r10,[%sp+0x7]	; 	xld.w	%r10,[%sp+0x1c]
	ld.w	%r11,[%sp+0x8]	; 	xld.w	%r11,[%sp+0x20]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX266:				; __L266:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	add	%r13,0x38	; 	xadd	%r13,%r13,56
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX268		; 	xjreq	__L268
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX269		; 	xjrlt	__L269
	int	2
	.word	__LC0
	.half	0x0000046c
__LX269:				; __L269:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0xf]	; 	xld.w	%r10,[%sp+0x3c]
	ld.w	%r11,[%sp+0x10]	; 	xld.w	%r11,[%sp+0x40]
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	[%r12+0x4],%r11
	ld.w	[%r12],%r11
__LX268:				; __L268:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	ext	0x1		; 	xadd	%r13,%r13,64
	add	%r13,0x0
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX236		; 	xjreq	__L236
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX271		; 	xjrlt	__L271
	int	2
	.word	__LC0
	.half	0x00000472
__LX271:				; __L271:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0x11]	; 	xld.w	%r10,[%sp+0x44]
	ld.w	%r11,[%sp+0x12]	; 	xld.w	%r11,[%sp+0x48]
	jp	__LX279		; 	xjp	__L279
__LX241:				; __L241:
	ld.w	%r12,%r1
	ld.w	%r13,%sp	; 	xadd	%r13,%sp,20
	add	%r13,0x14
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX273		; 	xjreq	__L273
	sub	%r1,0x8		; 	xsub	%r1,%r1,8
	ld.w	%r5,[%sp+0x21]	; 	xld.w	%r5,[%sp+0x84]
	sub	%r5,0x1		; 	xsub	%r5,%r5,1
	ld.w	[%sp+0x21],%r5	; 	xld.w	[%sp+0x84],%r5
	jrge	__LX274		; 	xjrge	__L274
	int	2
	.word	__LC0
	.half	0x0000047c
__LX274:				; __L274:
	ld.w	%r10,[%sp+0x5]	; 	xld.w	%r10,[%sp+0x14]
	ld.w	%r11,[%sp+0x6]	; 	xld.w	%r11,[%sp+0x18]
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	ext	0x4		; 	xld.w	[%r1+0x4],%r11
	ld.w	[%r1],%r11
__LX273:				; __L273:
	ld.w	%r12,[%sp+0x1b]	; 	xld.w	%r12,[%sp+0x6c]
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r12
	ld.w	%r12,%r5
	ld.w	%r13,[%sp+0x2a]	; 	xld.w	%r13,[%sp+0xa8]
	add	%r13,0x38	; 	xadd	%r13,%r13,56
	ld.w	%r14,0x8	; 	xld.w	%r14,0x00000008		; 8
	ext	memcmp@rm	; 	xcall	memcmp
	call	memcmp@rl
	cmp	%r10,0x0
	jreq	__LX236		; 	xjreq	__L236
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	ld.w	%r5,[%sp+0x20]	; 	xld.w	%r5,[%sp+0x80]
	cmp	%r10,%r5
	jrlt	__LX276		; 	xjrlt	__L276
	int	2
	.word	__LC0
	.half	0x00000482
__LX276:				; __L276:
	ld.w	%r12,%r10
	sll	%r12,0x3	; 	xsll	%r12,3
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r12,%r5
	ld.w	%r10,[%sp+0xf]	; 	xld.w	%r10,[%sp+0x3c]
	ld.w	%r11,[%sp+0x10]	; 	xld.w	%r11,[%sp+0x40]
__LX279:				; __L279:
	ld.w	[%r12],%r10	; 	xld.w	[%r12],%r10
	ext	0x4		; 	xld.w	[%r12+0x4],%r11
	ld.w	[%r12],%r11
__LX236:				; __L236:
	ld.w	%r5,[%sp+0x2b]	; 	xld.w	%r5,[%sp+0xac]
	add	%r5,0x20	; 	xadd	%r5,%r5,32
	ld.w	[%sp+0x2b],%r5	; 	xld.w	[%sp+0xac],%r5
	ld.w	%r5,[%sp+0x1f]	; 	xld.w	%r5,[%sp+0x7c]
	add	%r5,0x1		; 	xadd	%r5,%r5,1
	ld.w	[%sp+0x1f],%r5	; 	xld.w	[%sp+0x7c],%r5
	ld.w	%r10,[%sp+0x1d]	; 	xld.w	%r10,[%sp+0x74]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	cmp	%r5,%r10
	ext	__LX237@rm	; 	xjrlt	__L237
	jrlt	__LX237@rl
__LX235:				; __L235:
	ld.w	%r11,[%sp+0x21]	; 	xld.w	%r11,[%sp+0x84]
	sub	%r11,0x1	; 	xsub	%r11,%r11,1
	ld.w	%r10,[%sp+0x1b]	; 	xld.w	%r10,[%sp+0x6c]
	sub	%r10,%r11
	ld.w	[%sp+0x1b],%r10	; 	xld.w	[%sp+0x6c],%r10
	cmp	%r10,0x2	; 	xcmp	%r10,2
	jrle	__LX278		; 	xjrle	__L278
	ld.w	%r13,[%sp+0x21]	; 	xld.w	%r13,[%sp+0x84]
	sll	%r13,0x3	; 	xsll	%r13,3
	ld.w	%r5,[%sp+0x36]	; 	xld.w	%r5,[%sp+0xd8]
	ld.w	[%sp+0x0],%r5	; 	xld.w	[%sp],%r5
	ld.w	%r12,[%sp+0x1c]	; 	xld.w	%r12,[%sp+0x70]
	ext	_def_vbuff+0x0@h	; 	xld.w	%r5,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r5,_def_vbuff+0x0@l
	add	%r5,%r13
	ld.w	%r13,%r5
	ld.w	%r14,%sp	; 	xadd	%r14,%sp,108
	ext	0x1
	add	%r14,0x2c
	ld.w	%r15,0x1	; 	xld.w	%r15,0x00000001		; 1
	ext	render_vec2i_alternate_concaves@rm	; 	xcall	render_vec2i_alternate_concaves
	call	render_vec2i_alternate_concaves@rl
__LX278:				; __L278:
	add	%sp,0x31	; 	xadd	%sp,%sp,196
	popn	%r3
	ret
	.align	1
	.global	render_vec2i_render_polygon
render_vec2i_render_polygon:
;	.frame	%sp,28,$31		# vars= 0, regs= 5/0, args= 8, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r3,%r12
	ld.w	%r0,%r13
	ld.w	%r1,%r14
	ld.w	%r2,%r15
	cmp	%r1,0x2		; 	xcmp	%r1,2
	jrgt	__LX281		; 	xjrgt	__L281
	int	2
	.word	__LC0
	.half	0x00000496
__LX281:				; __L281:
	ld.w	%r10,%r1
	sll	%r10,0x3	; 	xsll	%r10,3
	sub	%r10,0x8	; 	xsub	%r10,%r10,8
	ld.w	%r13,%r0
	add	%r13,%r10
	jp	__LX286		; 	xjp	__L286
__LX284:				; __L284:
	ext	0x4		; 	xld.w	%r14,[%r13+0x4]
	ld.w	%r14,[%r13]
	ext	0x4		; 	xld.w	%r10,[%r0+0x4]
	ld.w	%r10,[%r0]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	[%sp+0x1],%r2	; 	xld.w	[%sp+0x4],%r2
	ld.w	%r12,%r3
	ld.w	%r13,[%r13]	; 	xld.w	%r13,[%r13]
	ld.w	%r15,[%r0]	; 	xld.w	%r15,[%r0]
	ext	render_line@rm	; 	xcall	render_line
	call	render_line@rl
	ld.w	%r13,%r0
	add	%r0,0x8		; 	xadd	%r0,%r0,8
__LX286:				; __L286:
	sub	%r1,0x1		; 	xsub	%r1,%r1,1
	jrge	__LX284		; 	xjrge	__L284
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r3
	ret
	.align	1
	.global	render_vec2i_render_polygon_fill
render_vec2i_render_polygon_fill:
;	.frame	%sp,48,$31		# vars= 28, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0x7		; 	xsub	%sp,%sp,28
	ld.w	%r3,%r12
	ld.w	%r12,%r13
	ld.w	%r0,%r14
	ld.w	[%sp+0x5],%r15	; 	xld.w	[%sp+0x14],%r15
	cmp	%r0,0x2		; 	xcmp	%r0,2
	jrgt	__LX288		; 	xjrgt	__L288
	int	2
	.word	__LC0
	.half	0x000004a9
__LX288:				; __L288:
	ext	_def_vbuff+0x0@h	; 	xld.w	%r1,_def_vbuff
	ext	_def_vbuff+0x0@m
	ld.w	%r1,_def_vbuff+0x0@l
	ld.w	%r13,%r0
	ld.w	%r14,%r1
	ext	vec2i_split_polygon_into_triangles@rm	; 	xcall	vec2i_split_polygon_into_triangles
	call	vec2i_split_polygon_into_triangles@rl
	ld.w	%r2,%r10
	ext	0x2		; 	xsub	%r10,%r0,2
	sub	%r10,%r0
	cmp	%r2,%r10
	jrle	__LX289		; 	xjrle	__L289
	int	2
	.word	__LC0
	.half	0x000004b3
__LX289:				; __L289:
	ext	0x14		; 	xld.w	%r10,[%r3+0x14]
	ld.w	%r10,[%r3]
	ext	0x30		; 	xld.w	%r4,[%r10+0x30]
	ld.w	%r4,[%r10]
	ld.w	[%sp+0x6],%r4	; 	xld.w	[%sp+0x18],%r4
	ld.w	%r4,0x0
	ext	0x30		; 	xld.w	[%r10+0x30],%r4
	ld.w	[%r10],%r4
	ld.w	%r0,0x0
	cmp	%r0,%r2
	jrge	__LX291		; 	xjrge	__L291
__LX293:				; __L293:
	ld.w	%r13,0x0
	ld.w	%r12,%sp
	ld.w	%r11,%r1
__LX297:				; __L297:
	ld.w	%r10,[%r11]	; 	xld.w	%r10,[%r11]
	ld.h	[%r12],%r10	; 	xld.h	[%r12],%r10
	ext	0x4		; 	xld.w	%r10,[%r11+0x4]
	ld.w	%r10,[%r11]
	ext	0x2		; 	xld.h	[%r12+0x2],%r10
	ld.h	[%r12],%r10
	add	%r12,0x6	; 	xadd	%r12,%r12,6
	add	%r11,0x8	; 	xadd	%r11,%r11,8
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	cmp	%r13,0x2	; 	xcmp	%r13,2
	jrle	__LX297		; 	xjrle	__L297
	ld.w	%r12,%r3
	ld.w	%r13,%sp
	ld.w	%r14,0x3	; 	xld.w	%r14,0x00000003		; 3
	ld.w	%r15,[%sp+0x5]	; 	xld.w	%r15,[%sp+0x14]
	ext	render_polygon@rm	; 	xcall	render_polygon
	call	render_polygon@rl
	add	%r1,0x18	; 	xadd	%r1,%r1,24
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	cmp	%r0,%r2
	jrlt	__LX293		; 	xjrlt	__L293
__LX291:				; __L291:
	ext	0x14		; 	xld.w	%r10,[%r3+0x14]
	ld.w	%r10,[%r3]
	ld.w	%r4,[%sp+0x6]	; 	xld.w	%r4,[%sp+0x18]
	ext	0x30		; 	xld.w	[%r10+0x30],%r4
	ld.w	[%r10],%r4
	add	%sp,0x7		; 	xadd	%sp,%sp,28
	popn	%r3
	ret

