#include "app.h"
/****************************************************************************
 *	main
 ****************************************************************************/
#ifdef  USE_LUA
static int atpanic(lua_State* L) {
	die("atpanic: %s", luaL_checkstring(L, -1));
}
#endif//USE_LUA
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
#ifdef  _DEBUG
	remove("syslog.out");			//񃍃O폜鎖ɂB
    #ifndef USE_JOB_DEBUG
	openlog(NULL, LOG_PERROR, LOG_USER);	//fobOrhł́AVXeOWG[ɂo͂BAfobOWugpꍇ́AfobOWucurses\ƏՓ˂Ȃ悤AWG[ɂ͏o͂ȂB
    #endif//USE_JOB_DEBUG
#else //_DEBUG
	setlogmask(LOG_UPTO(LOG_INFO));		//[Xrhł́ALOG_DEBUG}B
#endif//_DEBUG
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
	putenv("GC_LOG_FILE=CON");//Oo͐w肷B
	GC_set_find_leak(1);//[NoJnB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
#ifdef  __CLIP_SEH_H__
	SEH_init();
#endif//__CLIP_SEH_H__
#ifdef  __CLIP_WKST_H__
	pWS = Worksheet_new();
#endif//__CLIP_WKST_H__
#ifdef  USE_SQLITE
	if(!(db = sqlite_open(":memory:", 0, NULL))) { DIE(); }
#endif//USE_SQLITE
#ifdef  USE_PDCURSES
	initscr();
	refresh();//initscr()̒refresh()ĂяoĂ̂PDCurses̒΂łB
#endif//USE_PDCURSES
#ifdef  USE_GDIPLUS
	Gdiplus_Init();
#endif//USE_GDIPLUS
#ifdef  USE_PCL
	co_thread_init();
#endif//USE_PCL
#ifdef  USE_LUA
	if(!(L = luaL_newstate())) { DIE(); }
	lua_atpanic(L, atpanic);
	luaL_openlibs(L);
#endif//USE_LUA
#ifdef  USE_ACTIVETCL
	if(!(interp = Tcl_CreateInterp())) { DIE(); }
	Tcl_FindExecutable(argv[0]);
	if(Tcl_Init(interp) || Tk_Init(interp)) { DIE(); }
	if(Tcl_VarEval(interp, "wm title . {", argv[0], "}", NULL)) { DIE(); }
#endif//USE_ACTIVETCL
	app_init(argc, argv);
	exitCode = app_main(argc, argv);
	app_exit();
#ifdef  USE_ACTIVETCL
	Tcl_DeleteInterp(interp);
#endif//USE_ACTIVETCL
#ifdef  USE_LUA
	lua_close(L);
#endif//USE_LUA
#ifdef  USE_PCL
	co_thread_cleanup();
#endif//USE_PCL
#ifdef  USE_GDIPLUS
	Gdiplus_Exit();
#endif//USE_GDIPLUS
#ifdef  USE_PDCURSES
	endwin();
#endif//USE_PDCURSES
#ifdef  USE_SQLITE
	sqlite_close(db);
#endif//USE_SQLITE
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
	CHECK_LEAKS();//[NoB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
#ifdef  USE_ACTIVETCL
	Tcl_Exit(exitCode);
	/* NOTREACHED */
#endif//USE_ACTIVETCL
	return exitCode;
}
/****************************************************************************
 *	usage
 ****************************************************************************/
__declspec(noreturn) static void usage() {
	//TODO:
	exit(EXIT_FAILURE);
}
/****************************************************************************
 *	
 ****************************************************************************/
void app_init(int argc, char* argv[]) {
//{{AvP[VL̏
	{
		seed = GetTickCount();
		srand(seed);
		srand48(seed);
		WELL_init(&well, seed);
	}
//}}AvP[VL̏
}
/*--------------------------------------------------------------------------*/
void app_exit() {
//{{AvP[VL̏
	{
		//TODO:
	}
//}}AvP[VL̏
}
/*--------------------------------------------------------------------------*/
#ifdef  __cplusplus
#ifdef  USE_GDIPLUS
static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hDC = BeginPaint(hWnd, &ps);
			Graphics* graphics = new Graphics(hDC);
			if(graphics->GetLastStatus()) { DIE(); }
			if(graphics->Clear(Color.Red)) { DIE(); }
			wchar_t* fname = strdup_ShiftJisToUnicode("C:/usr/PIECE/HTML/IMAGE/MENULOGO.GIF");
			Image* image = new Image(fname);
			if(image->GetLastStatus()) { DIE(); }
			free(fname);
			if(graphics->DrawImage(image, 0, 0)) { DIE(); }
			delete image;
			delete graphics;
			EndPaint(hWnd, &ps);
		}
		return 0;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}
#endif//USE_GDIPLUS
#endif//__cplusplus








/****************************************************************************
 *	tB[h萔
 ****************************************************************************/
#define MAX_COLS	12		//ő
#define MAX_ROWS	9		//ős
/*--------------------------------------------------------------------------*/
#define Pai_Max		((9*3)+4+3)	//v̎	1`Pai_Max
/****************************************************************************
 *	tB[h\
 ****************************************************************************/
//e[u
typedef struct _ST_Dir {
	char		vCol, vRow;
} ST_Dir;
const ST_Dir TBL_Dir[4]={{1,0},{-1,0},{0,1},{0,-1}};	//0=E,1=,2=,3=				PAD_*TRG_*̕яɍ킹܂B
/*--------------------------------------------------------------------------*/
//Z
typedef struct _ST_Cell {
	uint8_t		iPai;				//v̎					0=,1`Pai_Max=v
	uint8_t		iPutOrd;			//ڂɔzuv?				0=,1=,2=,3=O,...
	uint8_t		iSide;				//zu^Cv					0=,1=(ȂL)[,2=,3=Ȃ[
	uint8_t		fBlank2;			//󂫐2ȏł̃rbg}XN		bit0=E,bit1=,bit2=,bit3=
	uint8_t		TBL_Blank[4];			//eւ̋󂫐				0`max(MAX_COLS,MAX_ROWS)
	//̃tB[h́AField_Gen()ɂĊi[Aȍ~AQ[ɂ͕ύXȂB
	//艺̃tB[h́AQ[ɕύXB
	uint8_t		iGetOrd;			//ڂɏv?				0=,,܂ĂȂ,1=,2=,3=O,...
} ST_Cell;
/*--------------------------------------------------------------------------*/
//tB[h
typedef struct _ST_Field {
	uint8_t		iColMin, iColMax;		//ԍ̍ŏlƍől
	uint8_t		iRowMin, iRowMax;		//sԍ̍ŏlƍől
	ST_Cell		TBL_Cell[MAX_ROWS][MAX_COLS];	//Zz
} ST_Field;
/****************************************************************************
 *	tB[h
 ****************************************************************************/
//Zւ̃|C^擾B
ST_Cell* Field_GetCell(ST_Field* pField, int iCol, int iRow) {
	if((iCol < pField->iColMin) || (iCol > pField->iColMax) ||
	   (iRow < pField->iRowMin) || (iRow > pField->iRowMax)) { DIE(); }	//oO
	return &pField->TBL_Cell[iRow][iCol];
}
/*--------------------------------------------------------------------------*/
//SẴŹATBL_Blank[],y,fBlank2tB[hXVB
void Field_UpdateBlank(ST_Field* pField) {
	int iDir;
	for(iDir = 0; iDir < 4; iDir++) {
		int iCol1 = pField->iColMin, iRow1 = pField->iRowMin;	//Ȃ̋N_ʒu
		for(;;) {
			//󂫂A̋tɐčsB
			int iCol2 = (TBL_Dir[iDir].vCol < 0) ? pField->iColMin : (TBL_Dir[iDir].vCol > 0) ? pField->iColMax : iCol1;
			int iRow2 = (TBL_Dir[iDir].vRow < 0) ? pField->iRowMin : (TBL_Dir[iDir].vRow > 0) ? pField->iRowMax : iRow1;
			int nBlank = 0;	//󂫐̏l0ƂĂB
			for(;;) {
				ST_Cell* pCell = Field_GetCell(pField, iCol2, iRow2);
				nBlank = pCell->iPutOrd ? 0 : (nBlank + 1);	//󂫂łȂ΋󂫐0ɖ߂B󂫂Ȃ΋󂫐𑝂₷B	Field_Gen()̓rĂяoꂽ_ł́AiPai͂܂i[ĂȂ̂ŁAiPaił͂ȂiPutOrdŔf鎖ɒӂB
				pCell->TBL_Blank[iDir] = nBlank;
				if(nBlank >= 2) {
					pCell->fBlank2 |=  (1<<iDir);	//󂫐2ȏȂ΁Ã̕rbgZbgB
				} else {
					pCell->fBlank2 &= ~(1<<iDir);	//󂫐2Ȃ΁Ã̕rbgNAB
				}
				//̈ʒu֐i߂āAtB[hOɂȂ烋[v𔲂B
				iCol2 -= TBL_Dir[iDir].vCol;
				iRow2 -= TBL_Dir[iDir].vRow;
				if((iCol2 < pField->iColMin) || (iCol2 > pField->iColMax)) { break; }
				if((iRow2 < pField->iRowMin) || (iRow2 > pField->iRowMax)) { break; }
			}
			//Ȃ̈ʒu֐i߂āAtB[hOɂȂ烋[v𔲂B
			iCol1 += !TBL_Dir[iDir].vCol;
			iRow1 += !TBL_Dir[iDir].vRow;
			if((iCol1 < pField->iColMin) || (iCol1 > pField->iColMax)) { break; }
			if((iRow1 < pField->iRowMin) || (iRow1 > pField->iRowMax)) { break; }
		}
	}
}
/*--------------------------------------------------------------------------*/
//tB[h̏zu𐶐B
void Field_Gen(ST_Field* pField) {
	int iPutOrd = 0;
	//ɓAȏ̋󂫂Lʒuւ̔zu݂郋[vB
	for(;;) {
		//SẴŹATBL_Blank[],y,fBlank2tB[hXVB
		Field_UpdateBlank(pField);
		{
			uint8_t TBL_DirOrd[][2/*0=,1=ޕ*/]={{0,1},{0,2},{0,3},{1,0},{1,2},{1,3},{2,0},{2,1},{2,3},{3,0},{3,1},{3,2}};
			int iDirOrd, iDir1, iDir2, fBlank2, iCol = -1/*x}*/, iRow, nCount, nLen;
			ST_Cell* pCell;
			//̌VbtB
			shuffle(TBL_DirOrd, ARRAY_SIZE(TBL_DirOrd), sizeof TBL_DirOrd[0], &seed);
			//ɍʒuƕ𐔂B
			nCount = 0;
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir1 = TBL_DirOrd[iDirOrd][0];	//
				iDir2 = TBL_DirOrd[iDirOrd][1];	//ޕ
				fBlank2 = (1 << iDir1) | (1 << iDir2);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if((pCell->fBlank2 & fBlank2) == fBlank2) { nCount++; }
					}
				}
			}
			if(!nCount) { break; }	//ɍʒuƕ΁AɓA̋󂫂Lʒuւ̔zu݂郋[vֈڍsB	ɍʒuƕꍇAɎOAȏ̋󂫂Lʒu͖͂łBɎOAȏ̋󂫂L΁AԂ̈ʒuN_ƂēɓAȏ̋󂫂LʒuƂČo͂łB
			//ɍʒuƕ𒊑IB
			nCount = RND32_RANGE(seed, 0, nCount);
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir1 = TBL_DirOrd[iDirOrd][0];	//
				iDir2 = TBL_DirOrd[iDirOrd][1];	//ޕ
				fBlank2 = (1 << iDir1) | (1 << iDir2);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if((pCell->fBlank2 & fBlank2) == fBlank2) { nCount--; }
						if(nCount < 0) { break; }
					}
					if(nCount < 0) { break; }
				}
				if(nCount < 0) { break; }
			}
			if(nCount >= 0) { DIE(); }	//oO
			//zuԍi߂ĂB
			iPutOrd++;
			//𒊑IB
			pCell = Field_GetCell(pField, iCol, iRow);
#if 0
			nLen = RND32_RANGE(seed, 0, pCell->TBL_Blank[iDir1]);	//0nLen(ւ̋󂫐-1)	ȂLo[W
#else			//ǂł\܂BƂ肠ÂAKɂ܂B
			nLen = RND32_RANGE(seed, 1, pCell->TBL_Blank[iDir1]);	//1nLen(ւ̋󂫐-1)	Ko[W
#endif
			//(ȂL)vzuB
			pCell = Field_GetCell(pField,
				iCol + (TBL_Dir[iDir1].vCol * nLen),
				iRow + (TBL_Dir[iDir1].vRow * nLen));
			if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
			pCell->iPutOrd = iPutOrd;
			pCell->iSide = 1/*(ȂL)[*/;
			//ޒ(I[܂)𒊑IB
			pCell = Field_GetCell(pField, iCol, iRow);
			nLen = RND32_RANGE(seed, 1, pCell->TBL_Blank[iDir2]);	//1nLen(ޕւ̋󂫐-1)
			//̔v(ޒ2ȂΑ݂Ȃ),y,ȂvzuB
			do {
				iCol += TBL_Dir[iDir2].vCol;
				iRow += TBL_Dir[iDir2].vRow;
				pCell = Field_GetCell(pField, iCol, iRow);
				if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
				pCell->iPutOrd = iPutOrd;
				pCell->iSide = (nLen > 1) ? 2/**/ : 3/*Ȃ[*/;
			} while(--nLen);
		}
	}
	//ɓA̋󂫂Lʒuւ̔zu݂郋[v
	for(;;) {
		//SẴŹATBL_Blank[],y,fBlank2tB[hXVB
		Field_UpdateBlank(pField);
		{
			uint8_t TBL_DirOrd[]={0,1,2,3};
			int iDirOrd, iDir, fBlank2, iCol = -1/*x}*/, iRow, nCount, nLen;
			ST_Cell* pCell;
			//̌VbtB
			shuffle(TBL_DirOrd, ARRAY_SIZE(TBL_DirOrd), sizeof TBL_DirOrd[0], &seed);
			//ɍʒuƕ𐔂B
			nCount = 0;
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir = TBL_DirOrd[iDirOrd];	//ޕ
				fBlank2 = (1 << iDir);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if(pCell->fBlank2 & fBlank2) { nCount++; }
					}
				}
			}
			if(!nCount) { break; }	//ɍʒuƕ΁AzuIB
			//ɍʒuƕ𒊑IB
			nCount = RND32_RANGE(seed, 0, nCount);
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir = TBL_DirOrd[iDirOrd];	//ޕ
				fBlank2 = (1 << iDir);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if((pCell->fBlank2 & fBlank2) == fBlank2) { nCount--; }
						if(nCount < 0) { break; }
					}
					if(nCount < 0) { break; }
				}
				if(nCount < 0) { break; }
			}
			if(nCount >= 0) { DIE(); }	//oO
			//zuԍi߂ĂB
			iPutOrd++;
			//n_̔vzuB
			pCell = Field_GetCell(pField, iCol, iRow);
			if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
			pCell->iPutOrd = iPutOrd;
			pCell->iSide = 1/*(ȂL)[*/;
			//ޒ(I[܂)𒊑IB
			pCell = Field_GetCell(pField, iCol, iRow);
			nLen = RND32_RANGE(seed, 1, pCell->TBL_Blank[iDir]);	//1nLen(ޕւ̋󂫐-1)
			if(nLen != 1) { DIE(); }	//ꉞIĂ̂́Aۂɂ͋󂫐2ł͂Ȃ̂ŁAޒ(I[܂)͏1ƂȂ͂B
			//̔v(ޒ2ȂΑ݂Ȃ),y,ȂvzuB
			do {
				iCol += TBL_Dir[iDir].vCol;
				iRow += TBL_Dir[iDir].vRow;
				pCell = Field_GetCell(pField, iCol, iRow);
				if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
				pCell->iPutOrd = iPutOrd;
				pCell->iSide = (nLen > 1) ? 2/**/ : 3/*Ȃ[*/;
			} while(--nLen);
		}
	}
	//v̎ނ肷鏈B
	{
		uint8_t TBL_PaiOrd[Pai_Max * 4/*4Â*/];
		int i, iCol, iRow;
		ST_Cell* pCell;
		//v̎ނ̔zB
		for(i = 0; i < ARRAY_SIZE(TBL_PaiOrd); i++) {
			TBL_PaiOrd[i] = (i / 4) + 1;	//{1,1,1,1,2,2,2,2,3,3,3,3,...,Pai_Max,Pai_Max,Pai_Max,Pai_Max}
		}
		//܂Ag݂ŃVtB([̔v)
		shuffle(TBL_PaiOrd, ARRAY_SIZE(TBL_PaiOrd) / 2, (sizeof TBL_PaiOrd[0]) * 2, &seed);
		//zu񐔂͓̕g݂ێāAȍ~͂΂΂ɃVtB(̔v)
		shuffle(&TBL_PaiOrd[iPutOrd * 2], ARRAY_SIZE(TBL_PaiOrd) - (iPutOrd * 2), sizeof TBL_PaiOrd[0], &seed);
		//zuB
		i = iPutOrd * 2;	//΂΂ɃVt擪ʒu
		for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
			for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
				pCell = Field_GetCell(pField, iCol, iRow);
				if(pCell->iPutOrd) {
					if(pCell->iPai) { DIE(); }	//oO
					switch(pCell->iSide) {
					default:DIE();
					case 1/*(ȂL)[*/:
					case 3/*Ȃ[*/:
						pCell->iPai = TBL_PaiOrd[(pCell->iPutOrd - 1) * 2];
						break;
					case 2/**/:
						pCell->iPai = TBL_PaiOrd[i++];
						break;
					}
					if((pCell->iPai < 1) || (pCell->iPai > Pai_Max)) { DIE(); }	//oO
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//tB[hB
void Field_Init(ST_Field* pField, int iColMin, int iColMax, int iRowMin, int iRowMax) {
	//\̂NAB
	memset(pField, 0, sizeof(ST_Field));
	//ԍƍsԍ̍ŏlƍőli[B
	if((((unsigned)iColMin >= MAX_COLS) || ((unsigned)iColMax >= MAX_COLS) || (iColMin > iColMax)) ||
	   (((unsigned)iRowMin >= MAX_ROWS) || ((unsigned)iRowMax >= MAX_ROWS) || (iRowMin > iRowMax))) { DIE(); }
	pField->iColMin = iColMin;
	pField->iColMax = iColMax;
	pField->iRowMin = iRowMin;
	pField->iRowMax = iRowMax;
	//tB[h̏zu𐶐B
	Field_Gen(pField);
}








int app_main(int argc, char* argv[]) {
	ST_Field stField;
	Field_Init(&stField, 0, MAX_COLS/2 - 1, 0, MAX_ROWS/2 - 1);
	Field_UpdateBlank(&stField);

	{
		int col, row;
		for(row = stField.iRowMin; row <= stField.iRowMax; row++) {
			for(col = stField.iColMin; col <= stField.iColMax; col++) {
				ST_Cell* pCell = Field_GetCell(&stField, col, row);
				printf("%2d ", pCell->iPutOrd);
			}
			puts("");
		}
	}
		puts("");
	{
		int col, row;
		for(row = stField.iRowMin; row <= stField.iRowMax; row++) {
			for(col = stField.iColMin; col <= stField.iColMax; col++) {
				ST_Cell* pCell = Field_GetCell(&stField, col, row);
				printf("%2d ", pCell->iPai);
			}
			puts("");
		}
	}

	getch();

	return 0;
}
