/*
 *	game.c
 *
 *	eǂ
 *
 *	* Sun Jan 29 11:46:37 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
extern char START_JINGLE[];
extern char TEZUMARI_JINGLE[];
extern char CLEAR_JINGLE[];
extern char MAIN_BGM[];
/****************************************************************************
 *	tB[h萔
 ****************************************************************************/
#define MAX_COLS	12		//ő
#define MAX_ROWS	9		//ős
/*--------------------------------------------------------------------------*/
#define Pai_Max		((9*3)+4+3)	//v̎	1`Pai_Max
/****************************************************************************
 *	tB[h\
 ****************************************************************************/
//e[u
typedef struct _ST_Dir {
	char		vCol, vRow;
} ST_Dir;
const ST_Dir TBL_Dir[4]={{1,0},{-1,0},{0,1},{0,-1}};	//0=E,1=,2=,3=				PAD_*TRG_*̕яɍ킹܂B
/*--------------------------------------------------------------------------*/
//Z
typedef struct _ST_Cell {
	uint8_t		iPai;				//v̎					0=,1`Pai_Max=v
	uint8_t		iPutOrd;			//ڂɔzuv?				0=,1=,2=,3=O,...
	uint8_t		iSide;				//zu^Cv					0=,1=(ȂL)[,2=,3=Ȃ[
	uint8_t		iMovCol, iMovRow;		//̈ʒu				(iSide==1)̏ꍇɈړ̈ʒui[B(iSide<>1)̏ꍇ͂̃tB[h͎gpȂB
	uint8_t		fBlank2;			//󂫐2ȏł̃rbg}XN		bit0=E,bit1=,bit2=,bit3=
	uint8_t		TBL_Blank[4];			//eւ̋󂫐				0`max(MAX_COLS,MAX_ROWS)
} ST_Cell;
/*--------------------------------------------------------------------------*/
//tB[h
typedef struct _ST_Field {
	uint8_t		iPutOrd;			//𓚂͉ŉ?
	uint8_t		iColMin, iColMax;		//ԍ̍ŏlƍől
	uint8_t		iRowMin, iRowMax;		//sԍ̍ŏlƍől
	ST_Cell		TBL_Cell[MAX_ROWS][MAX_COLS];	//Zz
} ST_Field;
/****************************************************************************
 *	tB[h
 ****************************************************************************/
//Zւ̃|C^擾B
ST_Cell* Field_GetCell(ST_Field* pField, int iCol, int iRow) {
	if((iCol < pField->iColMin) || (iCol > pField->iColMax) ||
	   (iRow < pField->iRowMin) || (iRow > pField->iRowMax)) { DIE(); }	//oO
	return &pField->TBL_Cell[iRow][iCol];
}
/*--------------------------------------------------------------------------*/
//SẴŹATBL_Blank[],y,fBlank2tB[hXVB
void Field_UpdateBlank(ST_Field* pField) {
	int iDir;
	for(iDir = 0; iDir < 4; iDir++) {
		int iCol1 = pField->iColMin, iRow1 = pField->iRowMin;	//Ȃ̋N_ʒu
		for(;;) {
			//󂫂A̋tɐčsB
			int iCol2 = (TBL_Dir[iDir].vCol < 0) ? pField->iColMin : (TBL_Dir[iDir].vCol > 0) ? pField->iColMax : iCol1;
			int iRow2 = (TBL_Dir[iDir].vRow < 0) ? pField->iRowMin : (TBL_Dir[iDir].vRow > 0) ? pField->iRowMax : iRow1;
			int nBlank = 0;	//󂫐̏l0ƂĂB
			for(;;) {
				ST_Cell* pCell = Field_GetCell(pField, iCol2, iRow2);
				nBlank = pCell->iPutOrd ? 0 : (nBlank + 1);	//󂫂łȂ΋󂫐0ɖ߂B󂫂Ȃ΋󂫐𑝂₷B	Field_Gen()̓rĂяoꂽ_ł́AiPai͂܂i[ĂȂ̂ŁAiPaił͂ȂiPutOrdŔf鎖ɒӂB
				pCell->TBL_Blank[iDir] = nBlank;
				if(nBlank >= 2) {
					pCell->fBlank2 |=  (1<<iDir);	//󂫐2ȏȂ΁Ã̕rbgZbgB
				} else {
					pCell->fBlank2 &= ~(1<<iDir);	//󂫐2Ȃ΁Ã̕rbgNAB
				}
				//̈ʒu֐i߂āAtB[hOɂȂ烋[v𔲂B
				iCol2 -= TBL_Dir[iDir].vCol;
				iRow2 -= TBL_Dir[iDir].vRow;
				if((iCol2 < pField->iColMin) || (iCol2 > pField->iColMax)) { break; }
				if((iRow2 < pField->iRowMin) || (iRow2 > pField->iRowMax)) { break; }
			}
			//Ȃ̈ʒu֐i߂āAtB[hOɂȂ烋[v𔲂B
			iCol1 += !TBL_Dir[iDir].vCol;
			iRow1 += !TBL_Dir[iDir].vRow;
			if((iCol1 < pField->iColMin) || (iCol1 > pField->iColMax)) { break; }
			if((iRow1 < pField->iRowMin) || (iRow1 > pField->iRowMax)) { break; }
		}
	}
}
/*--------------------------------------------------------------------------*/
//tB[h̏zu𐶐B
void Field_Gen(ST_Field* pField) {
	//ɓAȏ̋󂫂Lʒuւ̔zu݂郋[vB
	for(;;) {
		//SẴŹATBL_Blank[],y,fBlank2tB[hXVB
		Field_UpdateBlank(pField);
		{
			uint8_t TBL_DirOrd[][2/*0=,1=ޕ*/]={{0,1},{0,2},{0,3},{1,0},{1,2},{1,3},{2,0},{2,1},{2,3},{3,0},{3,1},{3,2}};
			int iDirOrd, iDir1, iDir2, fBlank2, iCol = -1/*x}*/, iRow, nCount, nLen;
			ST_Cell* pCell;
			//̌VbtB
			shuffle(TBL_DirOrd, ARRAY_SIZE(TBL_DirOrd), sizeof TBL_DirOrd[0], &seed);
			//ɍʒuƕ𐔂B
			nCount = 0;
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir1 = TBL_DirOrd[iDirOrd][0];	//
				iDir2 = TBL_DirOrd[iDirOrd][1];	//ޕ
				fBlank2 = (1 << iDir1) | (1 << iDir2);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if((pCell->fBlank2 & fBlank2) == fBlank2) { nCount++; }
					}
				}
			}
			if(!nCount) { break; }	//ɍʒuƕ΁AɓA̋󂫂Lʒuւ̔zu݂郋[vֈڍsB	ɍʒuƕꍇAɎOAȏ̋󂫂Lʒu͖͂łBɎOAȏ̋󂫂L΁AԂ̈ʒuN_ƂēɓAȏ̋󂫂LʒuƂČo͂łB
			//ɍʒuƕ𒊑IB
			nCount = RND32_RANGE(seed, 0, nCount);
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir1 = TBL_DirOrd[iDirOrd][0];	//
				iDir2 = TBL_DirOrd[iDirOrd][1];	//ޕ
				fBlank2 = (1 << iDir1) | (1 << iDir2);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if((pCell->fBlank2 & fBlank2) == fBlank2) { nCount--; }
						if(nCount < 0) { break; }
					}
					if(nCount < 0) { break; }
				}
				if(nCount < 0) { break; }
			}
			if(nCount >= 0) { DIE(); }	//oO
			//zuԍi߂ĂB
			pField->iPutOrd++;
			//𒊑IB
			pCell = Field_GetCell(pField, iCol, iRow);
#if 0
			nLen = RND32_RANGE(seed, 0, pCell->TBL_Blank[iDir1]);	//0nLen(ւ̋󂫐-1)	ȂLo[W
#else			//ǂł\܂BƂ肠ÂAKɂ܂B
			nLen = RND32_RANGE(seed, 1, pCell->TBL_Blank[iDir1]);	//1nLen(ւ̋󂫐-1)	Ko[W
#endif
			//(ȂL)vzuB
			pCell = Field_GetCell(pField,
				iCol + (TBL_Dir[iDir1].vCol * nLen),
				iRow + (TBL_Dir[iDir1].vRow * nLen));
			if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
			pCell->iPutOrd = pField->iPutOrd;
			pCell->iSide = 1/*(ȂL)[*/;
			pCell->iMovCol = iCol;
			pCell->iMovRow = iRow;
			//ޒ(I[܂)𒊑IB
			pCell = Field_GetCell(pField, iCol, iRow);
			nLen = RND32_RANGE(seed, 1, pCell->TBL_Blank[iDir2]);	//1nLen(ޕւ̋󂫐-1)
			//̔v(ޒ2ȂΑ݂Ȃ),y,ȂvzuB
			do {
				iCol += TBL_Dir[iDir2].vCol;
				iRow += TBL_Dir[iDir2].vRow;
				pCell = Field_GetCell(pField, iCol, iRow);
				if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
				pCell->iPutOrd = pField->iPutOrd;
				pCell->iSide = (nLen > 1) ? 2/**/ : 3/*Ȃ[*/;
			} while(--nLen);
		}
	}
	//ɓA̋󂫂Lʒuւ̔zu݂郋[v
	for(;;) {
		//SẴŹATBL_Blank[],y,fBlank2tB[hXVB
		Field_UpdateBlank(pField);
		{
			uint8_t TBL_DirOrd[]={0,1,2,3};
			int iDirOrd, iDir, fBlank2, iCol = -1/*x}*/, iRow, nCount, nLen;
			ST_Cell* pCell;
			//̌VbtB
			shuffle(TBL_DirOrd, ARRAY_SIZE(TBL_DirOrd), sizeof TBL_DirOrd[0], &seed);
			//ɍʒuƕ𐔂B
			nCount = 0;
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir = TBL_DirOrd[iDirOrd];	//ޕ
				fBlank2 = (1 << iDir);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if(pCell->fBlank2 & fBlank2) { nCount++; }
					}
				}
			}
			if(!nCount) { break; }	//ɍʒuƕ΁AzuIB
			//ɍʒuƕ𒊑IB
			nCount = RND32_RANGE(seed, 0, nCount);
			for(iDirOrd = 0; iDirOrd < ARRAY_SIZE(TBL_DirOrd); iDirOrd++) {
				iDir = TBL_DirOrd[iDirOrd];	//ޕ
				fBlank2 = (1 << iDir);
				for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
					for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
						pCell = Field_GetCell(pField, iCol, iRow);
						if((pCell->fBlank2 & fBlank2) == fBlank2) { nCount--; }
						if(nCount < 0) { break; }
					}
					if(nCount < 0) { break; }
				}
				if(nCount < 0) { break; }
			}
			if(nCount >= 0) { DIE(); }	//oO
			//zuԍi߂ĂB
			pField->iPutOrd++;
			//n_̔vzuB
			pCell = Field_GetCell(pField, iCol, iRow);
			if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
			pCell->iPutOrd = pField->iPutOrd;
			pCell->iSide = 1/*(ȂL)[*/;
			pCell->iMovCol = iCol;
			pCell->iMovRow = iRow;
			//ޒ(I[܂)𒊑IB
			pCell = Field_GetCell(pField, iCol, iRow);
			nLen = RND32_RANGE(seed, 1, pCell->TBL_Blank[iDir]);	//1nLen(ޕւ̋󂫐-1)
			if(nLen != 1) { DIE(); }	//ꉞIĂ̂́Aۂɂ͋󂫐2ł͂Ȃ̂ŁAޒ(I[܂)͏1ƂȂ͂B
			//̔v(ޒ2ȂΑ݂Ȃ),y,ȂvzuB
			do {
				iCol += TBL_Dir[iDir].vCol;
				iRow += TBL_Dir[iDir].vRow;
				pCell = Field_GetCell(pField, iCol, iRow);
				if(pCell->iPai || pCell->iPutOrd || pCell->iSide) { DIE(); }	//oO
				pCell->iPutOrd = pField->iPutOrd;
				pCell->iSide = (nLen > 1) ? 2/**/ : 3/*Ȃ[*/;
			} while(--nLen);
		}
	}
	//v̎ނ肷鏈B
	{
		uint8_t TBL_PaiOrd[Pai_Max * 4/*4Â*/];
		int i, iCol, iRow;
		ST_Cell* pCell;
		//v̎ނ̔zB
		for(i = 0; i < ARRAY_SIZE(TBL_PaiOrd); i++) {
			TBL_PaiOrd[i] = (i / 4) + 1;	//{1,1,1,1,2,2,2,2,3,3,3,3,...,Pai_Max,Pai_Max,Pai_Max,Pai_Max}
		}
		//܂Ag݂ŃVtB([̔v)
		shuffle(TBL_PaiOrd, ARRAY_SIZE(TBL_PaiOrd) / 2, (sizeof TBL_PaiOrd[0]) * 2, &seed);
		//zu񐔂͓̕g݂ێāAȍ~͂΂΂ɃVtB(̔v)
		shuffle(&TBL_PaiOrd[pField->iPutOrd * 2], ARRAY_SIZE(TBL_PaiOrd) - (pField->iPutOrd * 2), sizeof TBL_PaiOrd[0], &seed);
		//zuB
		i = pField->iPutOrd * 2;	//΂΂ɃVt擪ʒu
		for(iRow = pField->iRowMin; iRow <= pField->iRowMax; iRow++) {
			for(iCol = pField->iColMin; iCol <= pField->iColMax; iCol++) {
				pCell = Field_GetCell(pField, iCol, iRow);
				if(pCell->iPutOrd) {
					if(pCell->iPai) { DIE(); }	//oO
					switch(pCell->iSide) {
					default:DIE();
					case 1/*(ȂL)[*/:
					case 3/*Ȃ[*/:
						pCell->iPai = TBL_PaiOrd[(pCell->iPutOrd - 1) * 2];
						break;
					case 2/**/:
						pCell->iPai = TBL_PaiOrd[i++];
						break;
					}
					if((pCell->iPai < 1) || (pCell->iPai > Pai_Max)) { DIE(); }	//oO
				}
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
//tB[hB
void Field_Init(ST_Field* pField, int iColMin, int iColMax, int iRowMin, int iRowMax) {
	//\̂NAB
	memset(pField, 0, sizeof(ST_Field));
	//ԍƍsԍ̍ŏlƍőli[B
	if((((unsigned)iColMin >= MAX_COLS) || ((unsigned)iColMax >= MAX_COLS) || (iColMin > iColMax)) ||
	   (((unsigned)iRowMin >= MAX_ROWS) || ((unsigned)iRowMax >= MAX_ROWS) || (iRowMin > iRowMax))) { DIE(); }
	pField->iColMin = iColMin;
	pField->iColMax = iColMax;
	pField->iRowMin = iRowMin;
	pField->iRowMax = iRowMax;
	//tB[h̏zu𐶐B
	Field_Gen(pField);
}
/****************************************************************************
 *	Q[\
 ****************************************************************************/
//Q[
#define GAME_STAT_SEL1		0	//ڑI
#define GAME_STAT_MOV1		1	//ڈړ
#define GAME_STAT_ERR1		2	//샍bN1
#define GAME_STAT_SEL2		3	//ڑI
#define GAME_STAT_MOV2		4	//ڈړ
#define GAME_STAT_ERR2		5	//샍bN2
#define GAME_STAT_GET		6	//v
/*--------------------------------------------------------------------------*/
//j[
#define MENU_STAT_GAME		1	//Q[𑱂
#define MENU_STAT_HELP		2	//
#define MENU_STAT_TITLE		3	//^Cgɖ߂
/*--------------------------------------------------------------------------*/
//Q[
typedef struct _ST_Game {
	uint8_t		iGameStat;				//Q[
	uint8_t		iMenuStat;				//j[
	uint8_t		bBgmPlaying;				//BGMĐtO			l܂WO炵0ɂBAhD0BGMĐ1ɂB
	//
	uint16_t	nTime;					//c莞				NA̎c莞ԂXRAɉZ܂BԂȂĂQ[I[o[ɂ͂܂B
	uint16_t	nScore;					//XRA
	//
	const char*	pErrMsg;				//G[bZ[W
	uint8_t		iErrCnt;				//샍bNJE^
	//
	uint16_t	nScoEff;				//XRAGtFNg			0ȊOȂΗL
	uint8_t		iScoCnt;				//XRAGtFNgJE^
	uint8_t		iScoX;					//XRAGtFNg\WX
	uint8_t		iScoY;					//XRAGtFNg\WY
	//
	uint8_t		iCurCol, iCurRow;			//J[\ʒu
	uint8_t		iSelPai;				//Iv
	uint8_t		iSelCol1, iSelRow1;			//ڑIʒu
	uint8_t		iMovCol1, iMovRow1;			//ڈړʒu
	uint8_t		iSelCol2, iSelRow2;			//ڑIʒu
	uint8_t		iMovCol2, iMovRow2;			//ڈړʒu
	//
	uint8_t		iGetOrd;				//Ōɏ(=)		0=ĂȂ,1=,2=,...
	uint8_t		TBL_GetOrd[MAX_ROWS][MAX_COLS];		//eʒu̔v		0=ĂȂ,1`=		݂̃tB[h̕`p,y,AhDpłB
	//
	uint8_t		nStartOffset;				//Jnopv`ItZbg
	uint8_t		TBL_StartMask[MAX_ROWS][MAX_COLS];	//Jnopv}XN
	//
	ST_Field	Field;					//tB[h̏zu
} ST_Game;
ST_Game		stGame;
/****************************************************************************
 *	Q[
 ****************************************************************************/
//Q[B
void Game_Init() {
	int iColMin, iColMax, iRowMin, iRowMax;
	//\̂NAB
	memset(&stGame, 0, sizeof stGame);
	//tB[h͈̔͂vZB
	iColMin = (MAX_COLS - cols_sel) / 2;
	iColMax = iColMin + cols_sel - 1;
	iRowMin = (MAX_ROWS - rows_sel) / 2;
	iRowMax = iRowMin + rows_sel - 1;
	//tB[hB
	Field_Init(&stGame.Field, iColMin, iColMax, iRowMin, iRowMax);
	//c莞ԂB
	stGame.nTime = (cols_sel * rows_sel) * 10;	//ő(12*9)*10=1080
	stGame.nTime -= stGame.nTime % 100;		//100̈ʂ؂̂ĂB
	if(stGame.nTime > 900) { stGame.nTime = 900; }	//900߂Ȃ900ɂB
	if(stGame.nTime < 100) { stGame.nTime = 100; }	//100Ȃ100ɂB
	stGame.nTime *= FPS;				//t[PʂɂB
	//J[\ʒuB
	stGame.iCurCol = iColMin;
	stGame.iCurRow = iRowMin;
}
/*--------------------------------------------------------------------------*/
//tB[h`悷B
void Field_Draw() {
	int iCol, iRow, iPri, x, y, iSprNo;
	ST_Cell* pCell;
	//wi`悷B
	CbkQue_sprite_draw(pCbkQue,
		PRI__BG,
		X__BG,
		Y__BG,
		SPR_BG,
		DRW_NOMAL);
	//ZNbsOݒ肷B
	CbkQue_render_set_draw_area(pCbkQue,		//ݒ
		PRI__CELL,
		&render,
		X__CELL,
		Y__CELL,
		X__CELL + (W__CELL * MAX_COLS) + 1,
		Y__CELL + (H__CELL * MAX_ROWS) + 1);
	CbkQue_render_set_draw_area_full(pCbkQue,	//
		PRI__CELL + ((MAX_ROWS + 1) * 10/**/),
		&render);
	//ʏZ`悷B
	for(iRow = 0; iRow < MAX_ROWS; iRow++) {
		for(iCol = 0; iCol < MAX_COLS; iCol++) {
			iPri = PRI__CELL + (iRow * 10/**/);
			iSprNo = -1;
			//tB[hȂ΁c
			if(((iCol >= stGame.Field.iColMin) && (iCol <= stGame.Field.iColMax)) &&
			   ((iRow >= stGame.Field.iRowMin) && (iRow <= stGame.Field.iRowMax))) {
				//܂ĂȂ΁c
				if(!stGame.TBL_GetOrd[iRow][iCol]) {
					pCell = Field_GetCell(&stGame.Field, iCol, iRow);
					//zu̔vL΁c
					if(pCell->iPai) {
						iSprNo = SPR_PAI1_G1 + (pCell->iPai - 1);	//XvCgԍ̃x[XM1ł͂ȂG1ł鎖ɒӂB
						if(stGame.iGameStat >= GAME_STAT_MOV1) {	//ڈړȍ~Ȃ΁c
							if((iCol == stGame.iSelCol1) &&
							   (iRow == stGame.iSelRow1)) {		//ڑIʒuȂ΁c
								iSprNo = -1;
							}
						}
						if(stGame.iGameStat >= GAME_STAT_MOV2) {	//ڈړȍ~Ȃ΁c
							if((iCol == stGame.iSelCol2) &&
							   (iRow == stGame.iSelRow2)) {		//ڑIʒuȂ΁c
								iSprNo = -1;
							}
						}
					}
				}
			//tB[hOȂ΁c
			} else {
				iSprNo = SPR_PAI_OUTER;
			}
		    //{{Jnop
			if(stGame.TBL_StartMask[iRow][iCol]) { iSprNo = SPR_PAI_OUTER; }
		    //}}Jnop
			//XvCgL΁c
			if(iSprNo != -1) {
				x = X__CELL + (W__CELL * iCol);
				y = Y__CELL + (H__CELL * iRow);
			    //{{Jnop
				x -= stGame.nStartOffset;
			    //}}Jnop
				CbkQue_sprite_draw(pCbkQue,
					iPri,
					x,
					y,
					iSprNo,
					DRW_NOMAL);
			}
		}
	}
	//쒆̃Z`悷B
	if(stGame.iGameStat < GAME_STAT_GET) {				//쒆Ȃ΁c
		if(stGame.iGameStat == GAME_STAT_MOV1) {		//ڈړȂ΁c
			if((stGame.iSelCol1 != stGame.iMovCol1) ||
			   (stGame.iSelRow1 != stGame.iMovRow1)) {	//ڂ̔vړĂc
				if((now % SEC(0.5)) < SEC(0.25)) {
					iCol = stGame.iSelCol1;
					iRow = stGame.iSelRow1;
					iPri = PRI__CELL + (iRow * 10/**/) + 1/**/;
					x = X__CELL + (W__CELL * iCol);
					y = Y__CELL + (H__CELL * iRow);
					iSprNo = SPR_PAI_FRAME;
					CbkQue_sprite_draw(pCbkQue,
						iPri,
						x,
						y,
						iSprNo,
						DRW_NOMAL);
				}
			}
		}
		if(stGame.iGameStat >= GAME_STAT_MOV1) {		//ڈړȍ~Ȃ΁c
			iCol = stGame.iMovCol1;
			iRow = stGame.iMovRow1;
			iPri = PRI__CELL + (iRow * 10/**/);
			x = X__CELL + (W__CELL * iCol);
			y = Y__CELL + (H__CELL * iRow);
			pCell = Field_GetCell(&stGame.Field, stGame.iSelCol1, stGame.iSelRow1);
			iSprNo = SPR_PAI2_G1 + (pCell->iPai - 1);	//XvCgԍ̃x[XM1ł͂ȂG1ł鎖ɒӂB
			CbkQue_sprite_draw(pCbkQue,
				iPri,
				x,
				y,
				iSprNo,
				DRW_NOMAL);
		}
		if(stGame.iGameStat == GAME_STAT_MOV2) {		//ڈړȂ΁c
			if((stGame.iSelCol2 != stGame.iMovCol2) ||
			   (stGame.iSelRow2 != stGame.iMovRow2)) {	//ڂ̔vړĂc
				if((now % SEC(0.5)) < SEC(0.25)) {
					iCol = stGame.iSelCol2;
					iRow = stGame.iSelRow2;
					iPri = PRI__CELL + (iRow * 10/**/) + 1/**/;
					x = X__CELL + (W__CELL * iCol);
					y = Y__CELL + (H__CELL * iRow);
					iSprNo = SPR_PAI_FRAME;
					CbkQue_sprite_draw(pCbkQue,
						iPri,
						x,
						y,
						iSprNo,
						DRW_NOMAL);
				}
			}
		}
		if(stGame.iGameStat >= GAME_STAT_MOV2) {		//ڈړȍ~Ȃ΁c
			iCol = stGame.iMovCol2;
			iRow = stGame.iMovRow2;
			iPri = PRI__CELL + (iRow * 10/**/);
			x = X__CELL + (W__CELL * iCol);
			y = Y__CELL + (H__CELL * iRow);
			pCell = Field_GetCell(&stGame.Field, stGame.iSelCol2, stGame.iSelRow2);
			iSprNo = SPR_PAI2_G1 + (pCell->iPai - 1);	//XvCgԍ̃x[XM1ł͂ȂG1ł鎖ɒӂB
			CbkQue_sprite_draw(pCbkQue,
				iPri,
				x,
				y,
				iSprNo,
				DRW_NOMAL);
		}
	}
	//XRA`悷B
	CbkQue_render_printf(pCbkQue,
		PRI__1P,
		&render,
		X__1P,
		Y__1P,
		3,
		0,
		"%07d",
		stGame.nScore * 10);
	//nCXRA`悷B
	CbkQue_render_printf(pCbkQue,
		PRI__HI,
		&render,
		X__HI,
		Y__HI,
		3,
		0,
		"%07d",
		hiscore * 10);
	//^C`悷B
	CbkQue_render_printf(pCbkQue,
		PRI__TIME,
		&render,
		X__TIME - 1,
		Y__TIME - 1,
		1,
		0,
		"%03d",
		(stGame.nTime + (FPS - 1)) / FPS);
	//bZ[W`悷B
	if(stGame.pErrMsg) {
		char** v = textwrap(stGame.pErrMsg, 6);
		int i = 0;
		iPri = PRI__ERR;
		x = X__ERR;
		y = Y__ERR;
		while(v[i]) {
			CbkQue_render_printf(pCbkQue,
				iPri,
				&render,
				x,
				y,
				3,
				0,
				"%s",
				v[i]);
			y += 5;
			i++;
		}
		strfreev(v);
	}
	//XRAGtFNg\B
	if(stGame.nScoEff) {
		if(!(stGame.iScoCnt & 1)) {
			iPri = PRI__CURSOR + 1;
			x = stGame.iScoX;
			y = stGame.iScoY;
			if(stGame.nScoEff <= 9) {
				iSprNo = SPR_POINT2;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, DRW_NOMAL);
				x += 1;
				y += 3;
				CbkQue_render_printf(pCbkQue, iPri, &render, x, y, 3, 3, "%2d", stGame.nScoEff * 10);
			} else if(stGame.nScoEff <= 99) {
				iSprNo = SPR_POINT3;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, DRW_NOMAL);
				x -= 1;
				y += 3;
				CbkQue_render_printf(pCbkQue, iPri, &render, x, y, 3, 3, "%2d", stGame.nScoEff * 10);
			} else if(stGame.nScoEff <= 999) {
				iSprNo = SPR_POINT4;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, DRW_NOMAL);
				x -= 3;
				y += 3;
				CbkQue_render_printf(pCbkQue, iPri, &render, x, y, 3, 3, "%2d", stGame.nScoEff * 10);
			} else {
				iSprNo = SPR_POINT5;
				CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, DRW_NOMAL);
				x -= 5;
				y += 3;
				CbkQue_render_printf(pCbkQue, iPri, &render, x, y, 3, 3, "%2d", stGame.nScoEff * 10);
			}
		}
		if(++stGame.iScoCnt >= SEC(0.5)) { stGame.nScoEff = 0; }	//\̒ŃJE^̐issĂ܂B
	}
	//j[\Ȃ΁c
	if(stGame.iMenuStat) {
		x = 14;
		y = 27;
		CbkQue_render_rectangle(       pCbkQue, SHRT_MAX, &render, x - 2, y - 3, 76, 39,    0);
		CbkQue_render_rectangle_shadow(pCbkQue, SHRT_MAX, &render, x - 1, y - 2, 74, 37, 2, 3);
		CbkQue_render_printf_framed(pCbkQue, SHRT_MAX, &render, x, y, 0, (stGame.iMenuStat == MENU_STAT_GAME ) ? 0x220 : 0x331, "%s", "Q[𑱂");
		y += 11;
		CbkQue_render_printf_framed(pCbkQue, SHRT_MAX, &render, x, y, 0, (stGame.iMenuStat == MENU_STAT_HELP ) ? 0x220 : 0x331, "%s", "");
		y += 11;
		CbkQue_render_printf_framed(pCbkQue, SHRT_MAX, &render, x, y, 0, (stGame.iMenuStat == MENU_STAT_TITLE) ? 0x220 : 0x331, "%s", "^Cgɖ߂");
	}
}
/*--------------------------------------------------------------------------*/
//ڈړɁÄʒuŋ߂邩B
int MoveCheck1() {
	int iDir1, iCol1, iRow1;
	ST_Cell* pCell;
	//ڂ̔v̈ړ̈ʒuAl̂ǂɁAvAĂāAIvƓނ̔vL邩𒲂ׂB	ڂ̔vg͊܂߂Ȃ悤ɒӂB
	for(iDir1 = 0; iDir1 < 4; iDir1++) {
		iCol1 = stGame.iMovCol1;
		iRow1 = stGame.iMovRow1;
		for(;;) {
			iCol1 += TBL_Dir[iDir1].vCol;
			iRow1 += TBL_Dir[iDir1].vRow;
			if(((iCol1 < stGame.Field.iColMin) || (iCol1 > stGame.Field.iColMax)) ||
			   ((iRow1 < stGame.Field.iRowMin) || (iRow1 > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
				break;	//̕ɂ͋߂ȂB
			}
			if((iCol1 == stGame.iSelCol1) &&
			   (iRow1 == stGame.iSelRow1)) {	//ڑIʒuȂ΁c	vCNgňʒui߂ĂāAňڂ̑IʒuƂ́Aڂ̔vړĂƂłB]āAڂ̔vړċ߂邩AKv͖B
				break;	//̕ɂ͋߂ȂB
			}
			pCell = Field_GetCell(&stGame.Field, iCol1, iRow1);
			if(pCell->iPai &&			//̈ʒuɏzu̔vLAA
			   !stGame.TBL_GetOrd[iRow1][iCol1]) {	//̈ʒu̔v܂ĂȂ΁c
				if(pCell->iPai == stGame.iSelPai) {	//IvƓނȂ΁c
					return 1;	//߂B
				}
			} else {				//̈ʒuɏzu̔vÁÄʒu̔vĂc
				//ڂ̔vړĂȂ΁c
				if((stGame.iSelCol1 == stGame.iMovCol1) &&
				   (stGame.iSelRow1 == stGame.iMovRow1)) {
					int iDir2, iCol2, iRow2;
					for(iDir2 = 0; iDir2 < 4; iDir2++) {
						if((iDir1 ^ iDir2) != 1) {	//ܒHĂɖ߂Ă̑͂ȂBEɑ΂鍶,y,ɑ΂͏OƌłB΁Aڂ̔vg܂߂Ă܂͔܂B
							iCol2 = iCol1;
							iRow2 = iRow1;
							for(;;) {
								iCol2 += TBL_Dir[iDir2].vCol;
								iRow2 += TBL_Dir[iDir2].vRow;
								if(((iCol2 < stGame.Field.iColMin) || (iCol2 > stGame.Field.iColMax)) ||
								   ((iRow2 < stGame.Field.iRowMin) || (iRow2 > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
									break;	//̕ړĂċގ͏oȂB
								}
								pCell = Field_GetCell(&stGame.Field, iCol2, iRow2);
								if(pCell->iPai &&			//̈ʒuɏzu̔vLAA
								   !stGame.TBL_GetOrd[iRow2][iCol2]) {	//̈ʒu̔v܂ĂȂ΁c
									if(pCell->iPai == stGame.iSelPai) {	//IvƓނȂ΁c
										return 1;	//߂B
									} else {				//IvƈႤނȂ΁c
										break;	//̕ړĂċގ͏oȂB
									}
								}
							}
						}
					}
				}
				break;	//̕ɂ͋߂ȂB
			}
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//ڈړɁÄʒuŋ߂邩B
int MoveCheck2() {
	int iDir, iCol, iRow;
	ST_Cell* pCell;
	//ڂ̔v̈ړ̈ʒuAl̂ǂɁAvAĂāAڂ̔v̈ړ̈ʒu֓Bo邩𒲂ׂB	ڂ̔v,y,ڂ̔v́AړÖʒu͊܂߂Ȃ悤ɒӂBAꂪЕ̔v̈ړ̈ʒuȂ΁AB\Ɣf鏈D悷B
	for(iDir = 0; iDir < 4; iDir++) {
		iCol = stGame.iMovCol1;
		iRow = stGame.iMovRow1;
		for(;;) {
			iCol += TBL_Dir[iDir].vCol;
			iRow += TBL_Dir[iDir].vRow;
			if(((iCol < stGame.Field.iColMin) || (iCol > stGame.Field.iColMax)) ||
			   ((iRow < stGame.Field.iRowMin) || (iRow > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
				break;	//̕ɂ͋߂ȂB
			}
		    //{{̏K{łB
			if((iCol == stGame.iMovCol2) &&
			   (iRow == stGame.iMovRow2)) {		//ڈړʒuȂ΁c	̉̔莮ł́AڈړʒuZƔfĂ܂\L̂ŁAɔfKvL܂B
				return 1;	//߂B
			}
			pCell = Field_GetCell(&stGame.Field, iCol, iRow);
			if((!pCell->iPai || stGame.TBL_GetOrd[iRow][iCol]) ||			//̈ʒuɏzu̔v,,̈ʒu̔vĂ邩ÁA	//
			   ((iCol == stGame.iSelCol1) && (iRow == stGame.iSelRow1)) ||		//ڑIʒuÁA							//Z̔fłB
			   ((iCol == stGame.iSelCol2) && (iRow == stGame.iSelRow2))) {		//ڑIʒuȂ΁c							//
				break;	//̕ɂ͋߂ȂB
			}
		    //}}̏K{łB
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
//NA`FbNsB
int IsCleared() {
	int iCol, iRow;
	ST_Cell* pCell;
	for(iRow = stGame.Field.iRowMin; iRow <= stGame.Field.iRowMax; iRow++) {
		for(iCol = stGame.Field.iColMin; iCol <= stGame.Field.iColMax; iCol++) {
			pCell = Field_GetCell(&stGame.Field, iCol, iRow);
			if(pCell->iPai &&			//̈ʒuɏzu̔vLAA
			   !stGame.TBL_GetOrd[iRow][iCol]) {	//̈ʒu̔v܂ĂȂ΁c
				return 0;	//NAł͂ȂB
			}
		}
	}
	return 1;	//NAłB
}
/*--------------------------------------------------------------------------*/
//l܂`FbNsB
int IsDeadLock() {
	int iCol, iRow;
	ST_Cell* pCell;
	for(iRow = stGame.Field.iRowMin; iRow <= stGame.Field.iRowMax; iRow++) {
		for(iCol = stGame.Field.iColMin; iCol <= stGame.Field.iColMax; iCol++) {
			pCell = Field_GetCell(&stGame.Field, iCol, iRow);
			if(pCell->iPai &&			//̈ʒuɏzu̔vLAA
			   !stGame.TBL_GetOrd[iRow][iCol]) {	//̈ʒu̔v܂ĂȂ΁c
				//ڂIĈړɁAڂړ\Ƃ̂ŁAړ`FbNsB
				stGame.iSelPai = pCell->iPai;
				stGame.iSelCol1 = stGame.iMovCol1 = iCol;
				stGame.iSelRow1 = stGame.iMovRow1 = iRow;
				if(MoveCheck1()) { return 0; }	//l܂ł͂ȂB
			}
		}
	}
	return 1;	//l܂łB
}
/*--------------------------------------------------------------------------*/
//J[\̎sB
void Cursor_Exec() {
	int iCol, iRow, iDir;
	ST_Cell* pCell;
//{{j[
	//j[\łȂ΁c
	if(!stGame.iMenuStat) {
		if((stGame.iGameStat == GAME_STAT_SEL1) ||	//ڑI
		   (stGame.iGameStat == GAME_STAT_SEL2)) {	//ڑI
			if(joy & TRG_SELECT) {
				sound_play(0, sound_table[SND_MENU_HYOUJI], 1);	//j[\
				stGame.iMenuStat = MENU_STAT_GAME;
				stGame.pErrMsg = NULL;
				return;	//܂
			}
		}
	//j[\Ȃ΁c
	} else {
		if((joy & TRG_UP) && (stGame.iMenuStat > MENU_STAT_GAME)) {
			sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
			stGame.iMenuStat--;
			return;	//܂
		}
		if((joy & TRG_DN) && (stGame.iMenuStat < MENU_STAT_TITLE)) {
			sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
			stGame.iMenuStat++;
			return;	//܂
		}
		if(joy & (TRG_B|TRG_SELECT)) {
			sound_play(0, sound_table[SND_CURSOR_SENTAKU], 1);	//J[\I
			stGame.iMenuStat = 0;
			return;	//܂
		}
		return;	//܂
	}
//}}j[
	switch(stGame.iGameStat) {
	default:DIE();
	case GAME_STAT_SEL1:	//ڑI
		if(IsDeadLock()) {
			stGame.pErrMsg = " ޽";
		} else {
			stGame.pErrMsg = NULL;
			//I
			if(joy & TRG_A) {
				pCell = Field_GetCell(&stGame.Field, stGame.iCurCol, stGame.iCurRow);
				if(!pCell->iPai ||						//̈ʒuɏzu̔vÁA
				   stGame.TBL_GetOrd[stGame.iCurRow][stGame.iCurCol]) {		//̈ʒu̔vĂc
					sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
					return;	//܂
				}
				sound_play(0, sound_table[SND_CURSOR_SENTAKU], 1);	//J[\I
				stGame.iGameStat = GAME_STAT_MOV1;
				stGame.iSelPai = pCell->iPai;
				stGame.iSelCol1 = stGame.iMovCol1 = stGame.iCurCol;
				stGame.iSelRow1 = stGame.iMovRow1 = stGame.iCurRow;
				return;	//܂
			}
		}
		//ړ
		iDir = ffs(joy >> 8) - 1;	//TRG_RIZbgĂ0ATRG_LFZbgĂ1ATRG_DNZbgĂ2ATRG_UPZbgĂ3AłȂ0`3ȊO̒lɂȂB
		if((unsigned)iDir <= 3) {
			iCol = stGame.iCurCol + TBL_Dir[iDir].vCol;
			iRow = stGame.iCurRow + TBL_Dir[iDir].vRow;
			if(((iCol < stGame.Field.iColMin) || (iCol > stGame.Field.iColMax)) ||
			   ((iRow < stGame.Field.iRowMin) || (iRow > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
				sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
				return;	//܂
			}
			sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
			stGame.iCurCol = iCol;
			stGame.iCurRow = iRow;
			return;	//܂
		}
		//AhD
		if(joy & TRG_B) {
			if(!stGame.iGetOrd) {	//ĂȂ΁c
				sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
				return;	//܂
			}
			sound_play(0, sound_table[SND_UNDO], 1);	//AhD
			if(!stGame.bBgmPlaying) {	//l܂WOȂ΁ABGMĊJ
				PlayMusic(MAIN_BGM);
				stGame.bBgmPlaying = 1;
			}
			{
				int nPoint = 0;
				for(iRow = stGame.Field.iRowMin; iRow <= stGame.Field.iRowMax; iRow++) {
					for(iCol = stGame.Field.iColMin; iCol <= stGame.Field.iColMax; iCol++) {
						if(stGame.TBL_GetOrd[iRow][iCol] == stGame.iGetOrd) {
							stGame.TBL_GetOrd[iRow][iCol] = 0;
							nPoint++;
						}
					}
				}
				if(!nPoint) { DIE(); }
				nPoint = 1 << (nPoint - 2);
				stGame.nScore -= nPoint;
			}
			stGame.iGetOrd--;
			return;	//܂
		}
		break;
	case GAME_STAT_MOV1:	//ڈړ
		//ړ
		iDir = ffs(joy >> 8) - 1;	//TRG_RIZbgĂ0ATRG_LFZbgĂ1ATRG_DNZbgĂ2ATRG_UPZbgĂ3AłȂ0`3ȊO̒lɂȂB
		if((unsigned)iDir <= 3) {
			iCol = stGame.iCurCol + TBL_Dir[iDir].vCol;
			iRow = stGame.iCurRow + TBL_Dir[iDir].vRow;
			if(((iCol < stGame.Field.iColMin) || (iCol > stGame.Field.iColMax)) ||
			   ((iRow < stGame.Field.iRowMin) || (iRow > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
				sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
				return;	//܂
			}
			if((iCol != stGame.iSelCol1) ||
			   (iRow != stGame.iSelRow1)) {			//̈ʒułȂ΁c
				if((iCol != stGame.iSelCol1) &&
				   (iRow != stGame.iSelRow1)) {		//̈ړłȂ΁c
					sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
					return;	//܂
				}
				pCell = Field_GetCell(&stGame.Field, iCol, iRow);
				if(pCell->iPai &&			//̈ʒuɏzu̔vLAA
				   !stGame.TBL_GetOrd[iRow][iCol]) {	//̈ʒu̔v܂ĂȂ΁c
					sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
					return;	//܂
				}
			}
			sound_play(0, sound_table[SND_PAI_IDOU], 1);	//vړ
			stGame.iMovCol1 = stGame.iCurCol = iCol;
			stGame.iMovRow1 = stGame.iCurRow = iRow;
			return;	//܂
		}
		//ړ
		if(!(joy & PAD_A)) {
			if(!MoveCheck1()) {	//̈ʒuŋ߂Ȃ΁c
				sound_play(1, sound_table[SND_PIPIPIPI_ERROR], 1);	//ssssG[
				stGame.iGameStat = GAME_STAT_ERR1;
				stGame.pErrMsg = "ɲ ʻϾ";
				stGame.iErrCnt = 0;
				return;	//܂
			}
			stGame.iGameStat = GAME_STAT_SEL2;
			return;	//܂
		}
		break;
	case GAME_STAT_ERR1:	//샍bN1
		stGame.iErrCnt++;
		if((stGame.iErrCnt >= SEC(1.0/**/)) ||
		  ((stGame.iErrCnt >= SEC(0.2/**/)) && (joy & (TRG_LRUD|TRG_AB)))) {
			sound_play(0, sound_table[SND_UNDO], 1);	//AhD
			stGame.iGameStat = GAME_STAT_SEL1;
			stGame.iCurCol = stGame.iSelCol1;
			stGame.iCurRow = stGame.iSelRow1;
			stGame.pErrMsg = NULL;
			return;	//܂
		}
		break;
	case GAME_STAT_SEL2:	//ڑI
	    //{{bN
		if(stGame.pErrMsg) {
			stGame.iErrCnt++;
			if(stGame.iErrCnt >= SEC(1.0)) {
				stGame.pErrMsg = NULL;
			}
		}
	    //}}bN
		//ړ
		iDir = ffs(joy >> 8) - 1;	//TRG_RIZbgĂ0ATRG_LFZbgĂ1ATRG_DNZbgĂ2ATRG_UPZbgĂ3AłȂ0`3ȊO̒lɂȂB
		if((unsigned)iDir <= 3) {
	    //{{bN
			stGame.pErrMsg = NULL;
	    //}}bN
			iCol = stGame.iCurCol + TBL_Dir[iDir].vCol;
			iRow = stGame.iCurRow + TBL_Dir[iDir].vRow;
			if(((iCol < stGame.Field.iColMin) || (iCol > stGame.Field.iColMax)) ||
			   ((iRow < stGame.Field.iRowMin) || (iRow > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
				sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
				return;	//܂
			}
			sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
			stGame.iCurCol = iCol;
			stGame.iCurRow = iRow;
			return;	//܂
		}
		//I
		if(joy & TRG_A) {
			pCell = Field_GetCell(&stGame.Field, stGame.iCurCol, stGame.iCurRow);
			if(!pCell->iPai ||						//̈ʒuɏzu̔vÁA
			   stGame.TBL_GetOrd[stGame.iCurRow][stGame.iCurCol] ||		//̈ʒu̔vĂ邩ÁA
			   ((stGame.iCurCol == stGame.iSelCol1) &&
			    (stGame.iCurRow == stGame.iSelRow1))) {			//ڑIʒuƓȂ΁c
				sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
				return;	//܂
			}
			if(pCell->iPai != stGame.iSelPai) {	//ڂ̔vƈႤނȂ΁c
				sound_play(1, sound_table[SND_PIPIPIPI_ERROR], 1);	//ssssG[
	    //{{bN
				stGame.pErrMsg = "߲ɽ޶׶ ޲Ͻ";
				stGame.iErrCnt = 0;
	    //}}bN
				return;	//܂
			}
			sound_play(0, sound_table[SND_CURSOR_SENTAKU], 1);	//J[\I
			stGame.iGameStat = GAME_STAT_MOV2;
			stGame.iSelCol2 = stGame.iMovCol2 = stGame.iCurCol;
			stGame.iSelRow2 = stGame.iMovRow2 = stGame.iCurRow;
			return;	//܂
		}
		//
		if(joy & TRG_B) {
			sound_play(0, sound_table[SND_UNDO], 1);	//AhD
			stGame.iGameStat = GAME_STAT_SEL1;
			stGame.iCurCol = stGame.iSelCol1;
			stGame.iCurRow = stGame.iSelRow1;
			return;	//܂
		}
		break;
	case GAME_STAT_MOV2:	//ڈړ
	    //{{bN
		if(stGame.pErrMsg) {
			stGame.iErrCnt++;
			if(stGame.iErrCnt >= SEC(1.0)) {
				stGame.pErrMsg = NULL;
			}
		}
	    //}}bN
		//ړ
		iDir = ffs(joy >> 8) - 1;	//TRG_RIZbgĂ0ATRG_LFZbgĂ1ATRG_DNZbgĂ2ATRG_UPZbgĂ3AłȂ0`3ȊO̒lɂȂB
		if((unsigned)iDir <= 3) {
	    //{{bN
			stGame.pErrMsg = NULL;
	    //}}bN
			iCol = stGame.iCurCol + TBL_Dir[iDir].vCol;
			iRow = stGame.iCurRow + TBL_Dir[iDir].vRow;
			if(((iCol < stGame.Field.iColMin) || (iCol > stGame.Field.iColMax)) ||
			   ((iRow < stGame.Field.iRowMin) || (iRow > stGame.Field.iRowMax))) {	//tB[hOȂ΁c
				sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
				return;	//܂
			}
			if((iCol != stGame.iSelCol2) ||
			   (iRow != stGame.iSelRow2)) {			//̈ʒułȂ΁c
				if((iCol != stGame.iSelCol2) &&
				   (iRow != stGame.iSelRow2)) {		//̈ړłȂ΁c
					sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
					return;	//܂
				}
				pCell = Field_GetCell(&stGame.Field, iCol, iRow);
				if(pCell->iPai &&			//̈ʒuɏzu̔vLAA
				   !stGame.TBL_GetOrd[iRow][iCol]) {	//̈ʒu̔v܂ĂȂ΁c
					sound_play(0, sound_table[SND_TANJYUN_ERROR], 1);	//PG[
					return;	//܂
				}
			}
			if((stGame.iSelCol1 != stGame.iMovCol1) ||
			   (stGame.iSelRow1 != stGame.iMovRow1)) {	//ڂ̔vړĂc
				sound_play(1, sound_table[SND_PIPIPIPI_ERROR], 1);	//ssssG[
	    //{{bN
				stGame.pErrMsg = "γ޹ ޶Ͻ";
				stGame.iErrCnt = 0;
	    //}}bN
				return;	//܂
			}
			sound_play(0, sound_table[SND_PAI_IDOU], 1);	//vړ
			stGame.iMovCol2 = stGame.iCurCol = iCol;
			stGame.iMovRow2 = stGame.iCurRow = iRow;
			return;	//܂
		}
		//ړ
		if(!(joy & PAD_A)) {
			if(!MoveCheck2()) {	//̈ʒuŋ߂Ȃ΁c
				sound_play(1, sound_table[SND_PIPIPIPI_ERROR], 1);	//ssssG[
				stGame.iGameStat = GAME_STAT_ERR2;
				stGame.pErrMsg = "ɲ ʻϾ";
				stGame.iErrCnt = 0;
				return;	//܂
			}
			stGame.iGameStat = GAME_STAT_GET;
			return;	//܂
		}
		break;
	case GAME_STAT_ERR2:	//샍bN2
		stGame.iErrCnt++;
		if((stGame.iErrCnt >= SEC(1.0/**/)) ||
		  ((stGame.iErrCnt >= SEC(0.2/**/)) && (joy & (TRG_LRUD|TRG_AB)))) {
			sound_play(0, sound_table[SND_UNDO], 1);	//AhD
			stGame.iGameStat = GAME_STAT_SEL2;
			stGame.iCurCol = stGame.iSelCol2;
			stGame.iCurRow = stGame.iSelRow2;
			stGame.pErrMsg = NULL;
			return;	//܂
		}
		break;
	case GAME_STAT_GET:	//v
		/** no job **/
		break;
	}
}
/*--------------------------------------------------------------------------*/
//J[\`悷B
void Cursor_Draw() {
	int iPri, x, y, iSprNo;
	switch(stGame.iGameStat) {
	default:DIE();
	case GAME_STAT_SEL1:	//ڑI
	case GAME_STAT_MOV1:	//ڈړ
	case GAME_STAT_ERR1:	//샍bN1
	case GAME_STAT_SEL2:	//ڑI
	case GAME_STAT_MOV2:	//ڈړ
	case GAME_STAT_ERR2:	//샍bN2
	case GAME_STAT_GET:	//v
		iPri = PRI__CURSOR;
		x = X__CELL + (W__CELL * stGame.iCurCol);
		y = Y__CELL + (H__CELL * stGame.iCurRow);
		switch(stGame.iGameStat) {
		default:DIE();
		case GAME_STAT_SEL1:	//ڑI
		case GAME_STAT_SEL2:	//ڑI
		case GAME_STAT_ERR1:	//샍bN1
		case GAME_STAT_ERR2:	//샍bN2
		case GAME_STAT_GET:	//v
			iSprNo = SPR_CURSOR1;
			break;
		case GAME_STAT_MOV1:	//ڈړ
		case GAME_STAT_MOV2:	//ڈړ
			iSprNo = SPR_CURSOR2;
			break;
		}
		CbkQue_sprite_draw(pCbkQue,
			iPri,
			x,
			y,
			iSprNo,
			DRW_NOMAL);
		break;
	}
}
/*--------------------------------------------------------------------------*/
//v鏈sB
int DoGet(int bHelp) {
	int nPoint;
	//񐔂i߂B
	stGame.iGetOrd++;
	//ڑIʒuɎ}[Ni[B
	if(!Field_GetCell(&stGame.Field, stGame.iSelCol1, stGame.iSelRow1)->iPai) { DIE(); }	//oO
	if(stGame.TBL_GetOrd[stGame.iSelRow1][stGame.iSelCol1]) { DIE(); }	//oO
	stGame.TBL_GetOrd[stGame.iSelRow1][stGame.iSelCol1] = stGame.iGetOrd;
	sound_play(1, sound_table[SND_GET_IDOU], 1);	//GETړ
	//ڑIʒuɎ}[Ni[B
	if(!Field_GetCell(&stGame.Field, stGame.iSelCol2, stGame.iSelRow2)->iPai) { DIE(); }	//oO
	if(stGame.TBL_GetOrd[stGame.iSelRow2][stGame.iSelCol2]) { DIE(); }	//oO
	stGame.TBL_GetOrd[stGame.iSelRow2][stGame.iSelCol2] = stGame.iGetOrd;
	sound_play(1, sound_table[SND_GET_IDOU], 1);	//GETړ
	//ɋނȂ΁c
	if(stGame.iMovRow1 == stGame.iMovRow2) {
		int iCol, iRow, iCol1, iCol2, iOfs, iDiff;
		//ړ̈ʒu擾B
		iRow = stGame.iMovRow1;
		iCol1 = stGame.iMovCol1;
		iCol2 = stGame.iMovCol2;
		if(iCol1 > iCol2) { XCHG(iCol1, iCol2); }	//iCol1=,iCol2=E
		nPoint = 1 << ((iCol2 - iCol1) - 1);
		//Aj[VsB
		iOfs = 0;
		for(;;) {
			schedule();
			if(bHelp && (joy & (TRG_B|TRG_SELECT))) { return 1; }
			Field_Draw();
			Cursor_Draw();
			iCol = iCol1;
			if(Field_GetCell(&stGame.Field, iCol, iRow)->iPai) {	//ړ̈ʒułȂ΁c
				if(!stGame.TBL_GetOrd[iRow][iCol]) {		//Õ[vł܂}[NĂȂ΁c
					stGame.TBL_GetOrd[iRow][iCol] = stGame.iGetOrd;	//}[Ni[B
					sound_play(1, sound_table[SND_GET_IDOU], 1);	//GETړ
				}
			}
			iCol = iCol2;
			if(Field_GetCell(&stGame.Field, iCol, iRow)->iPai) {	//ړ̈ʒułȂ΁c
				if(!stGame.TBL_GetOrd[iRow][iCol]) {		//Õ[vł܂}[NĂȂ΁c
					stGame.TBL_GetOrd[iRow][iCol] = stGame.iGetOrd;	//}[Ni[B
					sound_play(1, sound_table[SND_GET_IDOU], 1);	//GETړ
				}
			}
			{
				int iPri, x, y, iSprNo;
				iSprNo = SPR_PAI2_G1 + (stGame.iSelPai - 1);	//XvCgԍ̃x[XM1ł͂ȂG1ł鎖ɒӂB
				iCol = iCol1;
				iPri = PRI__CELL + (iRow * 10/**/) + 1/**/;
				x = X__CELL + (W__CELL * iCol);
				y = Y__CELL + (H__CELL * iRow);
				x += iOfs;
				CbkQue_sprite_draw(pCbkQue,
					iPri,
					x,
					y,
					iSprNo,
					DRW_NOMAL);
				iCol = iCol2;
				iPri = PRI__CELL + (iRow * 10/**/) + 1/**/;
				x = X__CELL + (W__CELL * iCol);
				y = Y__CELL + (H__CELL * iRow);
				x -= iOfs;
				CbkQue_sprite_draw(pCbkQue,
					iPri,
					x,
					y,
					iSprNo,
					DRW_NOMAL);
			}
			iDiff = iCol2 - iCol1;
			if(iDiff <  0) { DIE(); }
			if(iDiff == 0) { break; }
			iOfs += 3/**/;
			if(iDiff == 1) { if(iOfs >  (W__CELL / 2)) { break;                      } }
			else           { if(iOfs >=  W__CELL     ) { iOfs = 0; iCol1++; iCol2--; } }
		}
	//cɋނȂ΁c
	} else if(stGame.iMovCol1 == stGame.iMovCol2) {
		int iCol, iRow, iRow1, iRow2, iOfs, iDiff;
		//ړ̈ʒu擾B
		iCol = stGame.iMovCol1;
		iRow1 = stGame.iMovRow1;
		iRow2 = stGame.iMovRow2;
		if(iRow1 > iRow2) { XCHG(iRow1, iRow2); }	//iRow1=,iRow2=
		nPoint = 1 << ((iRow2 - iRow1) - 1);
		//Aj[VsB
		iOfs = 0;
		for(;;) {
			schedule();
			if(bHelp && (joy & (TRG_B|TRG_SELECT))) { return 1; }
			Field_Draw();
			Cursor_Draw();
			iRow = iRow1;
			if(Field_GetCell(&stGame.Field, iCol, iRow)->iPai) {	//ړ̈ʒułȂ΁c
				if(!stGame.TBL_GetOrd[iRow][iCol]) {		//Õ[vł܂}[NĂȂ΁c
					stGame.TBL_GetOrd[iRow][iCol] = stGame.iGetOrd;	//}[Ni[B
					sound_play(1, sound_table[SND_GET_IDOU], 1);	//GETړ
				}
			}
			iRow = iRow2;
			if(Field_GetCell(&stGame.Field, iCol, iRow)->iPai) {	//ړ̈ʒułȂ΁c
				if(!stGame.TBL_GetOrd[iRow][iCol]) {		//Õ[vł܂}[NĂȂ΁c
					stGame.TBL_GetOrd[iRow][iCol] = stGame.iGetOrd;	//}[Ni[B
					sound_play(1, sound_table[SND_GET_IDOU], 1);	//GETړ
				}
			}
			{
				int iPri, x, y, iSprNo;
				iSprNo = SPR_PAI2_G1 + (stGame.iSelPai - 1);	//XvCgԍ̃x[XM1ł͂ȂG1ł鎖ɒӂB
				iRow = iRow1;
				iPri = PRI__CELL + (iRow * 10/**/) + 1/**/;		if(iOfs) { iPri += 10/**/; }
				x = X__CELL + (W__CELL * iCol);
				y = Y__CELL + (H__CELL * iRow);
				y += iOfs;
				CbkQue_sprite_draw(pCbkQue,
					iPri,
					x,
					y,
					iSprNo,
					DRW_NOMAL);
				iRow = iRow2;
				iPri = PRI__CELL + (iRow * 10/**/) + 2/**/;
				x = X__CELL + (W__CELL * iCol);
				y = Y__CELL + (H__CELL * iRow);
				y -= iOfs;
				CbkQue_sprite_draw(pCbkQue,
					iPri,
					x,
					y,
					iSprNo,
					DRW_NOMAL);
			}
			iDiff = iRow2 - iRow1;
			if(iDiff <  0) { DIE(); }
			if(iDiff == 0) { break; }
			iOfs += 3/**/;
			if(iDiff == 1) { if(iOfs >  (H__CELL / 2)) { break;                      } }
			else           { if(iOfs >=  H__CELL     ) { iOfs = 0; iRow1++; iRow2--; } }
		}
	} else {
		DIE();	//oO
	}
	if(!bHelp) {
		//XRAZB
		stGame.nScore += nPoint;
	}
	//XRAGtFNg𐶐B		ŃbNĕ\Ƒ쐫̂ŁȂƓis鎖ɂB
	stGame.nScoEff = nPoint;
	stGame.iScoCnt = 0;
	stGame.iScoX = X__CELL + ((stGame.iMovCol1 + stGame.iMovCol2) * W__CELL) / 2;
	stGame.iScoY = Y__CELL + ((stGame.iMovRow1 + stGame.iMovRow2) * H__CELL) / 2;
	sound_play(1, sound_table[SND_SCORE_EFFECT], 1);	//XRAGtFNg
	return 0;
}
/****************************************************************************
 *	Game_Run
 ****************************************************************************/
void Game_Run() {
	Game_Init();
	//Jno
	{
		int i, iCol, iRow, iDir;
		sound_play(1, sound_table[SND_DORA], 1);	//h
		for(iRow = stGame.Field.iRowMin; iRow <= stGame.Field.iRowMax; iRow++) {
			for(iCol = stGame.Field.iColMin; iCol <= stGame.Field.iColMax; iCol++) {
				stGame.TBL_StartMask[iRow][iCol] = 1;
			}
		}
		for(i = (W__CELL * MAX_COLS) + (SEC(1.5) * 4); i > 0; i -= 4) {
			stGame.nStartOffset = i;
			schedule();
			Field_Draw();
			if(i == (W__CELL * MAX_COLS)) {
				PlayMusic(START_JINGLE);
			}
			if(joy & (TRG_LRUD|TRG_AB)) { goto L_START_10; }
		}
		stGame.nStartOffset = 0;
		for(i = 0; i < SEC(0.34); i++) {
			schedule();
			Field_Draw();
			if(joy & (TRG_LRUD|TRG_AB)) { goto L_START_10; }
		}
		iDir = 0;
		iCol = stGame.Field.iColMin;
		iRow = stGame.Field.iRowMin;
		for(;;) {
			schedule();
			Field_Draw();
			if(joy & (TRG_LRUD|TRG_AB)) { goto L_START_10; }
			for(i = 0; i < 2/**/; i++) {
				sound_play(0, sound_table[SND_PAI_IDOU], 1);	//vړ
				stGame.TBL_StartMask[iRow][iCol] = 0;
				if(!memchr(stGame.TBL_StartMask, 1, sizeof stGame.TBL_StartMask)) { break; }
				for(;;) {
					iCol += TBL_Dir[iDir].vCol;
					iRow += TBL_Dir[iDir].vRow;
					if(((iCol < stGame.Field.iColMin) || (iCol > stGame.Field.iColMax)) ||
					   ((iRow < stGame.Field.iRowMin) || (iRow > stGame.Field.iRowMax)) ||
					   !stGame.TBL_StartMask[iRow][iCol]) {
						iCol -= TBL_Dir[iDir].vCol;
						iRow -= TBL_Dir[iDir].vRow;
						iDir = (iDir + 1) & 3;
					} else {
						break;
					}
				}
			}
			if(!memchr(stGame.TBL_StartMask, 1, sizeof stGame.TBL_StartMask)) { break; }
		}
		for(i = 0; i < SEC(0.34); i++) {
			schedule();
			Field_Draw();
			if(joy & (TRG_LRUD|TRG_AB)) { goto L_START_10; }
		}
	L_START_10:
		stGame.nStartOffset = 0;
		memset(stGame.TBL_StartMask, 0, sizeof stGame.TBL_StartMask);
	}
	//Q[
L_GAME:
	{
		PlayMusic(MAIN_BGM);
		stGame.bBgmPlaying = 1;
	}
	stGame.nScore = 0;
	stGame.iGetOrd = 0;
	memset(stGame.TBL_GetOrd, 0, sizeof stGame.TBL_GetOrd);
	stGame.iGameStat = GAME_STAT_SEL1;
	stGame.iCurCol = stGame.Field.iColMin;
	stGame.iCurRow = stGame.Field.iRowMin;
	for(;;) {
		stGame.iGameStat = GAME_STAT_SEL1;
		for(;;) {
			schedule();
			Field_Draw();
			Cursor_Draw();
			Cursor_Exec();
			if(stGame.iGameStat == GAME_STAT_GET) { break; }
			if(stGame.iMenuStat && (joy & TRG_A)) {
				sound_play(0, sound_table[SND_CURSOR_SENTAKU], 1);	//J[\I
				switch(stGame.iMenuStat) {
				default:DIE();
				case MENU_STAT_GAME:
					stGame.iMenuStat = 0;
					break;
				case MENU_STAT_HELP:
					stGame.iMenuStat = 0;
					goto L_HELP;
				case MENU_STAT_TITLE:
				//sv	stGame.iMenuStat = 0;
					return;	//߂
				}
			}
			if(!stGame.iMenuStat && stGame.nTime) { stGame.nTime--; }
		}
		DoGet(0);
		if(IsCleared()) { break; }
		if(IsDeadLock()) {
			stGame.iGameStat = GAME_STAT_SEL1;	//KvBstGame.iSelCol1,stGame.iMovCol1,stGame.iSelRow1,stGame.iMovRow1Ă̂ŁAGAME_STAT_GET̂܂܂Ƒ҂ɔv\ȂB
			while(stGame.nScoEff) {	//XRGGtFNg܂" ޽"̕\҂B
				schedule();
				Field_Draw();
				Cursor_Draw();
			}
			{
				PlayMusic(TEZUMARI_JINGLE);
				stGame.bBgmPlaying = 0;
			}
		}
	}
	//NAo
	{
		const int nClearPrize = 100;
		const int nTime = ((stGame.nTime + (FPS - 1)) / FPS);
		const int nTotal = nClearPrize + nTime;
		int i, x, y, bDora;
		for(i = 0; i < SEC(1.5)/**/; i++) {
			schedule();
			Field_Draw();
			Cursor_Draw();
			if(i == SEC(0.5)) {
				StopMusic();
			}
		}
		PlayMusic(CLEAR_JINGLE);
		bDora = 1;
		for(i = 0; i < SEC(10.0); i++) {
			schedule();
			Field_Draw();
			if(bDora && MusicCheck()) {
				sound_play(1, sound_table[SND_DORA], 1);	//h
				bDora = 0;
			}
			x = 15;
			y = 32;
			CbkQue_render_rectangle(       pCbkQue, SHRT_MAX, &render, x - 3, y - 3, 75, 30,    0);
			CbkQue_render_rectangle_shadow(pCbkQue, SHRT_MAX, &render, x - 2, y - 2, 73, 28, 2, 3);
			if(i >= SEC(0.5)) {
				CbkQue_render_printf_framed(pCbkQue, SHRT_MAX, &render, x, y, 3, 0x220, "CLEAR PRIZE %5d", nClearPrize * 10);
				if(i == SEC(0.5)) {
					sound_play(0, sound_table[SND_SCORE_HYOUJI], 1);	//XRA\
				}
			}
			y += 9;
			if(i >= SEC(1.0)) {
				CbkQue_render_printf_framed(pCbkQue, SHRT_MAX, &render, x, y, 3, 0x220, "TIME x 10   %5d", nTime * 10);
				if(i == SEC(1.0)) {
					sound_play(0, sound_table[SND_SCORE_HYOUJI], 1);	//XRA\
				}
			}
			y += 9;
			if(i >= SEC(1.5)) {
				CbkQue_render_printf_framed(pCbkQue, SHRT_MAX, &render, x, y, 3, 0x220, "TOTAL       %5d", nTotal * 10);
				if(i == SEC(1.5)) {
					sound_play(0, sound_table[SND_SCORE_HYOUJI], 1);	//XRA\
				}
			}
			if(i == SEC(2.0)) {
				stGame.nScore += nTotal;
				sound_play(0, sound_table[SND_SCORE_KASAN], 1);	//XRAZ
				if(stGame.nScore > hiscore) { hiscore = stGame.nScore; }
			}
			if(i >= SEC(2.5)) {
				if(joy & (TRG_AB|TRG_SELECT)) { break; }
			}
		}
	}
	return;	//܂
	//
L_HELP:
	StopMusic();
	{
		const int HELP_DELAY = 3/**/;
		int i, iCol1, iRow1, iCol2, iRow2;
		int iPutOrd = stGame.Field.iPutOrd;
		stGame.nScore = 0;
		stGame.iGetOrd = 0;
		memset(stGame.TBL_GetOrd, 0, sizeof stGame.TBL_GetOrd);
		stGame.iGameStat = GAME_STAT_SEL1;
		stGame.iCurCol = stGame.Field.iColMin;
		stGame.iCurRow = stGame.Field.iRowMin;
		for(i = 0; i < SEC(1.0)/**/; i++) {
			schedule();
			Field_Draw();
		//	Cursor_Draw();
			if(joy & (TRG_B|TRG_SELECT)) { goto L_GAME; }
		}
		do {
			ST_Cell* pCell;
			//(ȂL)[B
			for(iRow1 = stGame.Field.iRowMin; iRow1 <= stGame.Field.iRowMax; iRow1++) {
				for(iCol1 = stGame.Field.iColMin; iCol1 <= stGame.Field.iColMax; iCol1++) {
					pCell = Field_GetCell(&stGame.Field, iCol1, iRow1);
					if((pCell->iPutOrd == iPutOrd) &&
					   (pCell->iSide == 1/*(ȂL)[*/)) { goto L_HELP_10; }
				}
			}
			DIE();	//oO
		L_HELP_10:
			//ړ擾B
			pCell = Field_GetCell(&stGame.Field, iCol1, iRow1);
			iCol2 = pCell->iMovCol;
			iRow2 = pCell->iMovRow;
			if((iCol1 != iCol2) && (iRow1 != iRow2)) { DIE(); }	//ȂƂǂ炩(͗)ł͂BƂoOłB
			//(ȂL)[ړB
			stGame.iGameStat = GAME_STAT_SEL1;
			stGame.iCurCol = iCol1;
			stGame.iCurRow = iRow1;
			for(i = 0; i < HELP_DELAY; i++) {
				schedule();
				Field_Draw();
				Cursor_Draw();
				if(joy & (TRG_B|TRG_SELECT)) { goto L_GAME; }
			}
			joy = TRG_A|PAD_A;
			Cursor_Exec();
			if(stGame.iGameStat != GAME_STAT_MOV1) { DIE(); }
			for(;;) {
				for(i = 0; i < HELP_DELAY; i++) {
					schedule();
					Field_Draw();
					Cursor_Draw();
					if(joy & (TRG_B|TRG_SELECT)) { goto L_GAME; }
				}
				if((stGame.iCurCol == iCol2) &&
				   (stGame.iCurRow == iRow2)) { break; }
				if(stGame.iCurCol < iCol2) { joy = TRG_RI|PAD_A; }
				if(stGame.iCurCol > iCol2) { joy = TRG_LF|PAD_A; }
				if(stGame.iCurRow < iRow2) { joy = TRG_DN|PAD_A; }
				if(stGame.iCurRow > iRow2) { joy = TRG_UP|PAD_A; }
				Cursor_Exec();
				if(stGame.iGameStat != GAME_STAT_MOV1) { DIE(); }
			}
			joy = 0;
			Cursor_Exec();
			if(stGame.iGameStat != GAME_STAT_SEL2) { DIE(); }
			//Ȃ[B
			for(iRow1 = stGame.Field.iRowMin; iRow1 <= stGame.Field.iRowMax; iRow1++) {
				for(iCol1 = stGame.Field.iColMin; iCol1 <= stGame.Field.iColMax; iCol1++) {
					pCell = Field_GetCell(&stGame.Field, iCol1, iRow1);
					if((pCell->iPutOrd == iPutOrd) &&
					   (pCell->iSide == 3/*Ȃ[*/)) { goto L_HELP_20; }
				}
			}
			DIE();	//oO
		L_HELP_20:
			//Ȃ[肷B
			stGame.iCurCol = iCol1;
			stGame.iCurRow = iRow1;
			for(i = 0; i < HELP_DELAY; i++) {
				schedule();
				Field_Draw();
				Cursor_Draw();
				if(joy & (TRG_B|TRG_SELECT)) { goto L_GAME; }
			}
			joy = TRG_A|PAD_A;
			Cursor_Exec();
			if(stGame.iGameStat != GAME_STAT_MOV2) { DIE(); }
			for(i = 0; i < HELP_DELAY; i++) {
				schedule();
				Field_Draw();
				Cursor_Draw();
				if(joy & (TRG_B|TRG_SELECT)) { goto L_GAME; }
			}
			joy = 0;
			Cursor_Exec();
			if(stGame.iGameStat != GAME_STAT_GET) { DIE(); }
			//vB
			if(DoGet(1)) { goto L_GAME; }
		} while(--iPutOrd);
		if(!IsCleared()) { DIE(); }	//oO
		for(i = 0; i < SEC(1.0)/**/; i++) {
			schedule();
			Field_Draw();
		//	Cursor_Draw();
			if(joy & (TRG_B|TRG_SELECT)) { goto L_GAME; }
		}
	}
	goto L_GAME;
}
/****************************************************************************
 *	Demo_Run
 ****************************************************************************/
void Demo_Run() {
	int iSel = 0, bStart = 0;
	int x, y;
	for(bStart = 0; bStart < SEC(1.0); /** no job **/) {
		schedule();
		if(joy & TRG_SELECT) { exit(EXIT_SUCCESS); }
		//
		x = UPDOWN_MOTION((now / 8), 21) - 10;
		x = clamp(x, -8, 8);
		CbkQue_sprite_draw(pCbkQue, 0, x, 0, SPR_PHOTO, DRW_NOMAL);
		CbkQue_sprite_draw(pCbkQue, 0, 0, 0, SPR_TITLE, DRW_NOMAL);
		x = 103;
		y =  43;
		CbkQue_render_printf_framed(pCbkQue, 0, &render, x  , y  , 3, 0x003, "%s", "ķ");
		CbkQue_render_printf_framed(pCbkQue, 0, &render, x+2, y-2, 3, 0x003, "%s", "  ");
		//
		CbkQue_render_printf_framed(pCbkQue, 0, &render,           1, 1, 3, 0x330, "1P %07d", stGame.nScore * 10);
		CbkQue_render_printf_framed(pCbkQue, 0, &render, DISP_X - 42, 1, 3, 0x330, "HI %07d",       hiscore * 10);
		x = 22;
		y = 53;
		if(!bStart) {
			if(iSel == 0) {
				CbkQue_render_printf_framed(pCbkQue, 0, &render, x, y, 0, 0x330, "Ֆʂ̕   %c %2d %c", (cols_sel > 2) ? '<' : ' ', cols_sel, (cols_sel < MAX_COLS) ? '>' : ' ');
				y += 13;
				CbkQue_render_printf_framed(pCbkQue, 0, &render, x, y, 0, 0x331, "Ֆʂ̍ %c %2d %c",                        ' ', rows_sel,                               ' ');
				if((joy & TRG_LF) && (cols_sel > 2)) {
					cols_sel--;
					sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
				}
				if((joy & TRG_RI) && (cols_sel < MAX_COLS)) {
					cols_sel++;
					sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
				}
				if(joy & TRG_DN) {
					iSel = 1;
					sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
				}
			} else {
				CbkQue_render_printf_framed(pCbkQue, 0, &render, x, y, 0, 0x331, "Ֆʂ̕   %c %2d %c",                        ' ', cols_sel,                               ' ');
				y += 13;
				CbkQue_render_printf_framed(pCbkQue, 0, &render, x, y, 0, 0x330, "Ֆʂ̍ %c %2d %c", (rows_sel > 2) ? '<' : ' ', rows_sel, (rows_sel < MAX_ROWS) ? '>' : ' ');
				if((joy & TRG_LF) && (rows_sel > 2)) {
					rows_sel--;
					sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
				}
				if((joy & TRG_RI) && (rows_sel < MAX_ROWS)) {
					rows_sel++;
					sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
				}
				if(joy & TRG_UP) {
					iSel = 0;
					sound_play(0, sound_table[SND_CURSOR_IDOU], 1);	//J[\ړ
				}
			}
		} else {
				CbkQue_render_printf_framed(pCbkQue, 0, &render, x, y, 0, 0x330, "Ֆʂ̕   %c %2d %c",                        ' ', cols_sel,                               ' ');
				y += 13;
				CbkQue_render_printf_framed(pCbkQue, 0, &render, x, y, 0, 0x330, "Ֆʂ̍ %c %2d %c",                        ' ', rows_sel,                               ' ');
		}
		//
		if(!bStart) {
			if((now % SEC(2.0)) < SEC(1.0)) {
				CbkQue_render_printf_framed(pCbkQue, 0, &render, 18, DISP_Y - 7, 3, 0x330, "PRESS A BUTTON TO START");
			}
			if(joy & TRG_AB) {
				bStart = 1;
				sound_play(0, sound_table[SND_START], 1);	//X^[g
			}
		} else {
			if(bStart & 1) {
				CbkQue_render_printf_framed(pCbkQue, 0, &render, 18, DISP_Y - 7, 3, 0x330, "PRESS A BUTTON TO START");
			}
			bStart++;
		}
	}
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
int app_main(int argc, char* argv[]) {
    //{{B:B{^ȂNƍő剹ʂɂēdr\܂B
	delay(1);
	if(joy & PAD_B) {
		pceWaveSetMasterAtt(0);
		pcePowerSetReport(PWR_RPTOFF);
	}
    //}}B:B{^ȂNƍő剹ʂɂēdr\܂B
	cols_sel = MAX_COLS/2;
	rows_sel = MAX_ROWS/2;
	for(;;) {
		Demo_Run();
		Game_Run();
		StopMusic();
	}
	return 0;
}
