/*****************************************************************************
 * Bison/FlexvOeXg邽߂́AWindowsAvP[V̐^ *
 * rhEs@:                                                       *
 * "C:\Program Files (x86)\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"  *
 * make -f winapp.mk run                                                   *
 *****************************************************************************/
#include "winapp.h"
//-----------------------------------------------------------------------------
//x`
enum {
	WARN_CAST,			//Öق̌^ϊŌ덷Ax\ŏIIɃG[I܂B̃IvVw肵Ȃ΁Ax\G[I܂B
};
static const char* const warn_tokens[]={
	"cast",				//Öق̌^ϊŌ덷Ax\ŏIIɃG[I܂B̃IvVw肵Ȃ΁Ax\G[I܂B
NULL};//I[
int warn;				//ex(WARN_*)ɂ(warn&(1<<WARN_*))ZbgĂ炻̌xOnł鎖܂B
//-----------------------------------------------------------------------------
//O[oϐ`
int grid_w, grid_h;
/*---------------------------------------------------------------------------*/
//[Jϐ`
static ght_hash_table_t* ht_tex;	//eNX`(ST_Tex*)
static ght_hash_table_t* ht_spr;	//XvCg(ST_Spr*)
//x̃\[g@
int (*fnLabCmp)(const void*, const void*) = strcmp;	//'n'IvVw肳ꂽstrnatcmpɕύXB
//{{i\p
static int opt_q;
static int newMsgLen, oldMsgLen = 0;
//}}i\p
/*---------------------------------------------------------------------------*/
//G[Op
static char err_path[_MAX_PATH];	//'-e'IvVw肳ꂽAG[Ot@Ci[B
static FILE* fp_err;			//ŏ̃G[OL^鎞ɁAG[Ot@C쐬B
//{{2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
typedef struct _ST_Location {
	const char*	path;					//push_location()ĂяoꂽÕt@C
	int		line;					//push_location()ĂяoꂽO̍sԍ
} ST_Location;
static ST_Location TBL_Location[16/**/];			//P[VX^bN
static nLocation;						//P[VX^bN̊i[
static const char* filename = "-";				//݂̃t@C(popen̓R}h)B݂̍sԍyylinenoQƂĉB
static void init_location(const char* path) {
	nLocation = 0;						//P[VX^bNɂB
	filename = strdup(path);				//݂̃t@CRs[ĕێB
	yylineno = 1;						//݂̍sԍB	yylex_init()łĂ̂ł̍s͖Ă\Ȃ̂AՂ̂߂ɂł鎖ɂB
}
void push_location(const char* path) {
	if(nLocation >= ARRAY_SIZE(TBL_Location)) { DIE(); }	//P[VX^bNtłȂmFB
	TBL_Location[nLocation].path = filename;		//݂̃t@CP[VX^bNɑޔB
	TBL_Location[nLocation].line = yylineno;		//݂̍sԍP[VX^bNɑޔB
	nLocation++;						//P[VX^bN̊i[𑝂₷B
	filename = strdup(path);				//݂̃t@CRs[ĕێB
	yylineno = 1;						//݂̍sԍB
}
void pop_location() {
	if(!nLocation) { DIE(); }				//P[VX^bNłȂmFB
	nLocation--;						//P[VX^bN̊i[炷B
	filename = TBL_Location[nLocation].path;		//݂̃t@CP[VX^bN畜B
	yylineno = TBL_Location[nLocation].line;		//݂̍sԍP[VX^bN畜B
}
//}}2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
void yyerror(const char* fmt, ...) {	//{{2015/03/06:'-e'IvVΉ̂߂winapp.cړ܂B}}
	//'-e'IvVw肳ĂāAŏ̃G[OL^鎞Ȃ΁c
	if(*err_path && !fp_err) {
		//G[Ot@C쐬B
		fp_err = fopen(err_path, "w");
		if(!fp_err) { error(EXIT_FAILURE, errno, "%s 쐬ł܂B", err_path); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
		//G[Ot@C̏o̓Xg[́Aobt@OƂB
		// - die()ŏI(abort())ɁAobt@tbVȂ悤Ȃ̂ŁAĂKvLB
		//   ʂ̈ĂƂāẢ̏Ŗfflush()@L邪Aobt@OƂȒP낤B
		setbuf(fp_err, NULL);
	}
	//G[bZ[W(,y,G[O)o͂B
//{{2016/09/24ύX:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
//	             fprintf(stderr, "### error at line %d : ", yylineno);	//G[bZ[W
//	if(fp_err) { fprintf(fp_err, "### error at line %d : ", yylineno); }	//G[O
//2016/09/24ύX:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
	             fprintf(stderr, "%s(%d) : ", filename, yylineno);		//G[bZ[W
	if(fp_err) { fprintf(fp_err, "%s(%d) : ", filename, yylineno); }	//G[O
//}}2016/09/24ύX:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B
	{
		va_list ap;
		va_start(ap, fmt);
		             vfprintf(stderr, fmt, ap);		//G[bZ[W
		if(fp_err) { vfprintf(fp_err, fmt, ap); }	//G[O
		va_end(ap);
	}
	             fputc('\n', stderr);	//G[bZ[W
	if(fp_err) { fputc('\n', fp_err); }	//G[O
}
/*---------------------------------------------------------------------------*/
//[J֐錾
__declspec(noreturn) static void usage();
static int subr(int argc, char* argv[]);
static void pass2(int bOptimize);
static void output(const char* sTexOut, const char* sSprOut, const char* sEnmOut, const char* sRegOut);
static void output_tex(FILE* fp);
static void output_spr(FILE* fp);
static void output_enm(FILE* fp);
static void output_reg(FILE* fp);
/*---------------------------------------------------------------------------*/
int main(int argc, char* argv[]) {
	int exitCode;
	SEH_init();
	exitCode = subr(argc, argv);
	return exitCode;
}
/*---------------------------------------------------------------------------*/
static int subr(int argc, char* argv[]) {
	int opt, bOptimize = 1;		//'-d'IvVw肳Ȃ΍œKsB
	const char* sTexOut = NULL;	//'-t'IvVw肳ꂽeNX``wb_̃t@C,,"-"(Wo)ݒ肷B	P/ECEp
	const char* sSprOut = NULL;	//'-p'IvVw肳ꂽXvCg`wb_̃t@C,,"-"(Wo)ݒ肷B	
	const char* sEnmOut = NULL;	//'-u'IvVw肳ꂽ񋓒`XNvg̃t@C,,"-"(Wo)ݒ肷B	ėp
	const char* sRegOut = NULL;	//'-r'IvVw肳ꂽ烌WXgXNvg̃t@C,,"-"(Wo)ݒ肷B	
#if     (YYDEBUG!=0)
//	yydebug = 1; //nonzero means print parse trace
#endif/*(YYDEBUG!=0)*/
	//R}hCIvVB
	opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
	while((opt = getopt(argc, argv, "dt::p::u::r::enw::qh")) != -1) {
		switch(opt) {
		case 'd':
			bOptimize = 0;				//œKsȂB
			break;
		case 't':
			sTexOut = optarg ? optarg : "-";	//eNX``wb_̃t@C,,"-"(Wo)ݒ肷B
			break;
		case 'p':
			sSprOut = optarg ? optarg : "-";	//XvCg`wb_̃t@C,,"-"(Wo)ݒ肷B
			break;
		case 'u':
			sEnmOut = optarg ? optarg : "-";	//񋓒`XNvg̃t@C,,"-"(Wo)ݒ肷B
			break;
		case 'r':
			sRegOut = optarg ? optarg : "-";	//WXgXNvg̃t@C,,"-"(Wo)ݒ肷B
			break;
		case 'e':
			{
				//G[Ot@C쐬B
				// - JgtH_'st@C.err'ƂOŐ鎖ɂB̓́A'lk33.exe'̎dlQlɂB
				char fname[_MAX_FNAME];
				_splitpath(argv[0], NULL, NULL, fname, NULL);
				_makepath(err_path, NULL, NULL, fname, ".err");
				//'-e'IvVw肳ꂽAŏɊmɁÃG[Ot@C폜ĂB
				//OɐG[OcĂāA񐶐G[Oƍ댯邽߂łB
				//A'-e'IvVw肳Ȃꍇ́ÃG[Ot@C폜鏈͍sȂB
				remove(err_path);
			}
			break;
		case 'n':
			fnLabCmp = strnatcmp;	//x̃\[gstrnatcmp()gpB
			break;
		case 'w':
			if(optarg) {
				char *optionp = optarg, *valuep;
				while(*optionp) {
					switch(getsubopt(&optionp, (char* const*)warn_tokens, &valuep)) {
					case WARN_CAST:
						if(valuep) { usage(); }
						warn |= (1<<WARN_CAST);
						break;
					default:
						usage();
					}
				}
			} else {
				warn = -1;
			}
			break;
		case 'q':
			opt_q = 1;
			break;
		case 'h':
		default:
			usage();
		}
	}
	//nbVe[u쐬B
	ght_set_rehash((ht_tex = ght_create(0)), 1);
	ght_set_rehash((ht_spr = ght_create(0)), 1);
	//--- 1pXڂ̏ ---
	//t@Cw肳ĂȂ΁AW͂ǂݍށB
	if(optind == argc) {
		init_location("-");	//{{2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B}}
		yylex_init(stdin);
		if((yyparse() != 0) /*|| (yynerrs != 0)*/) { error(EXIT_FAILURE, 0, "G[܂B"); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
	//t@Cw肳ĂAet@CǂݍށB
	} else {
		int i;
		for(i = optind; i < argc; i++) {
			FILE* fp = fopen(argv[i], "r");
			if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[i]); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
			init_location(argv[i]);	//{{2016/09/24ǉ:G[bZ[WɁA݂̍sԍłȂÃ݂t@C\悤ɂ܂B}}
			yylex_init(fp);
			if((yyparse() != 0) /*|| (yynerrs != 0)*/) { error(EXIT_FAILURE, 0, "%s: G[܂B", argv[i]); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
			fclose(fp);
		}
	}
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass1 ok");
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } putc('\n', stderr); oldMsgLen = 0;
	}
    //}}i\p
	//1pXڂ̏ŃG[ĂA2pXڂ̏sāASẴZ}eBNXG[񍐂B
	//--- 2pXڂ̏ ---
	//2pXڂ̏sB
	pass2(bOptimize);
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass2 ok");
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } putc('\n', stderr); oldMsgLen = 0;
	}
    //}}i\p
	if(yynerrs != 0) { error(EXIT_FAILURE, 0, "G[܂B"); }	//1pX,,2pXڂ̏ŃG[ĂAo͏sȂB	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
	//--- o͏ ---
	//o͏sB
	output(sTexOut, sSprOut, sEnmOut, sRegOut);
	if(yynerrs != 0) { error(EXIT_FAILURE, 0, "G[܂B"); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
	return EXIT_SUCCESS;
}
/*---------------------------------------------------------------------------*/
//g\ďIB
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dTexDefC - eNX``RpC (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2016 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dTexDefC [option ...] [filename ...] \n");
	fprintf(stderr, "  Efilenamew肵Ȃ΁AW͂ǂݍ݂܂B\n");
	fprintf(stderr, "  EfilenaméAChJ[hɂ镡w\łB\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -d             œKs܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁AœKs܂B\n");
	fprintf(stderr, "  -t[t@C] P/ECEp̃eNX``wb_At@C֏o͂܂B\n");
	fprintf(stderr, "                 t@Cw肵Ȃ΁AWo͂֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁AeNX``wb_o͂܂B\n");
	fprintf(stderr, "  -p[t@C] P/ECEp̃XvCg`wb_At@C֏o͂܂B\n");
	fprintf(stderr, "                 t@Cw肵Ȃ΁AWo͂֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁AXvCg`wb_o͂܂B\n");
	fprintf(stderr, "  -u[t@C] ėp̗񋓒`XNvgAt@C֏o͂܂B\n");
	fprintf(stderr, "                 t@Cw肵Ȃ΁AWo͂֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁A񋓒`XNvgo͂܂B\n");
	fprintf(stderr, "  -r[t@C] ėp̃WXgXNvgAt@C֏o͂܂B\n");
	fprintf(stderr, "                 t@Cw肵Ȃ΁AWo͂֏o͂܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁AWXgXNvgo͂܂B\n");
	fprintf(stderr, "  -e             G[Ot@C𐶐܂B\n");
	fprintf(stderr, "                 ̃IvVw肵ĂAG[Ȃΐ܂B\n");
	fprintf(stderr, "  -n             x̃\[gɁAstrnatcmp()gp܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Astrcmp()gp܂B\n");
	fprintf(stderr, "  -w             SĂ̌xLɂ܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Aʂɐݒ肵x݂̂LɂȂ܂B\n");
	fprintf(stderr, "  -wcast         Öق̌^ϊŌ덷Ax\ŏIIɃG[I܂B\n");
	fprintf(stderr, "                 ̃IvVw肵Ȃ΁Ax\G[I܂B\n");
	fprintf(stderr, "  -q             i\}܂B\n");
	fprintf(stderr, "  -h             g\܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "EXAMPLE:\n");
	fprintf(stderr, "  @dTexDefC.exe -t -p TexDef.txt\n");
	fprintf(stderr, "  @TexDef.txtRpC܂B\n");
	fprintf(stderr, "  @P/ECEp̃eNX``wb_ƃXvCg`wb_AWo͂֏o͂܂B\n");
	fprintf(stderr, "  AdTexDefC.exe -ttexture.h -psprite.h TexDef.txt\n");
	fprintf(stderr, "  @TexDef.txtRpC܂B\n");
	fprintf(stderr, "  @P/ECEp̃eNX``wb_Atexture.h֏o͂܂B\n");
	fprintf(stderr, "  @P/ECEp̃XvCg`wb_Asprite.h֏o͂܂B\n");
	fprintf(stderr, "  BdTexDefC.exe -uEnmTexDef.txt -rRegTexDef.txt TexDef.txt\n");
	fprintf(stderr, "  @TexDef.txtRpC܂B\n");
	fprintf(stderr, "  @ėp̗񋓒`XNvgAEnmTexDef.txt֏o͂܂B\n");
	fprintf(stderr, "  @ėp̃WXgXNvgARegTexDef.txt֏o͂܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "  P/ECEp̃eNX`ԍ,y,XvCgԍ͊̃}Ndl̂0x[XłB\n");
	fprintf(stderr, "  ėp̃eNX`ԍ,y,XvCgԍ͎gpl1x[XƂĂ܂B\n");
	fprintf(stderr, "  ҂̔ԍ͈vĂȂ̂ň̃AvP[Vŗ҂𕹗pȂŉB\n");
	exit(EXIT_FAILURE);
}
/*---------------------------------------------------------------------------*/
//1pXڂ̏
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
int cast_dbl_to_int(double d) {
	int i = d;
	if(i != d) {
		if(warn & (1<<WARN_CAST)) {
			yyerror("؂̂Č덷܂: %f  %d", d, i);
			yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
			//SẴZ}eBNXG[񍐂邽߂ɌpB
		}
	}
	return i;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
void addTex(ST_Tex* pTex) {
	ST_TexHdr*  pTexHdr  = pTex->pTexHdr;
	ST_TexBody* pTexBody = pTex->pTexBody;
	ST_Tex* pTex2;
    //{{i\p
	if(!opt_q) {
		newMsgLen = fprintf(stderr, "\rpass1 %s", pTexHdr->pTexLab);
		if(oldMsgLen > newMsgLen) { fprintf(stderr, "%*s", oldMsgLen - newMsgLen, ""); } oldMsgLen = newMsgLen;
	}
    //}}i\p
	//ÕeNX`ɓo^Ăc
	pTex2 = ght_get(ht_tex,
		strlen(pTexHdr->pTexLab) + 1/*nul*/,
		       pTexHdr->pTexLab);
	if(pTex2) {
		ST_TexHdr*  pTexHdr2  = pTex2->pTexHdr;
		ST_TexBody* pTexBody2 = pTex2->pTexBody;
		if(pTexHdr->pPath) {
			//̃eNX`ƁÃeNX`́AƂt@Cݒ肳Ăc
			if(pTexHdr2->pPath) {
				//t@CĂc
				if(strcmp(pTexHdr->pPath, pTexHdr2->pPath)) {
					yyerror("eNX`Ńt@CĂ܂B(%s)", pTexHdr->pTexLab);
					yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
					return;		//SẴZ}eBNXG[񍐂邽߂ɌpB
				}
			//̃eNX`Ƀt@Cݒ肳ĂāÃeNX`Ƀt@Cݒ肳ĂȂ΁c
			} else {
				//̃eNX`Ƀt@Cݒ肷B
				pTexHdr2->pPath		= pTexHdr->pPath;
			}
		} else {
			//̃eNX`Ƀt@Cݒ肳ĂȂāÃeNX`Ƀt@Cݒ肳Ăc
			if(pTexHdr2->pPath) {
				/** no job **/
			//̃eNX`ƁÃeNX`́AƂt@Cݒ肳ĂȂ΁c
			} else {
				/** no job **/
			}
		}
		//̃eNX`̃\[XtOɁÃeNX`̃\[XtO}[WB
		pTexHdr2->bResource	|= pTexHdr->bResource;
		//̃eNX`̃[vtOɁÃeNX`̃[vtO}[WB
		pTexHdr2->bLoop		|= pTexHdr->bLoop;
		//̃eNX`̃XvCgzɁÃeNX`̃XvCgz}[WB
		{
			pTexBody2 = realloc(pTexBody2, sizeof(ST_TexBody) + (sizeof pTexBody2->aSpr[0]) * (pTexBody2->nSpr + pTexBody->nSpr));
			if(!pTexBody2) { DIE(); }
			memcpy(&pTexBody2->aSpr[pTexBody2->nSpr], &pTexBody->aSpr[0], (sizeof pTexBody2->aSpr[0]) * (pTexBody->nSpr));
			pTexBody2->nSpr		+= pTexBody->nSpr;
			pTex2->pTexBody		 = pTexBody2;	//YȂ!!
		}
	//ÕeNX`܂o^ĂȂ΁c
	} else {
		//̃eNX`o^B
		if(ght_insert(ht_tex,
			       pTex,
			strlen(pTexHdr->pTexLab) + 1/*nul*/,
			       pTexHdr->pTexLab)) { DIE(); }	//Œ~鎖͗L肦Ȃ͂B
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Tex* Tex_new(ST_TexHdr* pTexHdr, ST_TexBody* pTexBody) {
	ST_Tex* pTex = calloc(1, sizeof(ST_Tex));
	if(!pTex) { DIE(); }
	pTex->pTexHdr		= pTexHdr;
	pTex->pTexBody		= pTexBody;
	return pTex;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_TexHdr* TexHdr_new(char* pTexLab/*Е̂NULL*/, char* pPath/*Е̂NULL*/, int bResource, int bLoop) {
	ST_TexHdr* pTexHdr = calloc(1, sizeof(ST_TexHdr));
	if(!pTexHdr) { DIE(); }
	if(!pTexLab && !pPath) { DIE(); }	//NULLŌĂяo鎖͖͂BŒ~y.tab.ỹoOłB
	//xȗĂAt@C烉xB
	if(!pTexLab) {
		char fname[MAX_FNAME];
		int i;
		splitpath(pPath, NULL, NULL, fname, NULL);
//{{2016/01/27ύX:t@C烉x鏈ύX܂B
//		for(i = 0; iscsym(fname[i]); i++) { /** no job **/ }
//2016/01/27ύX:t@C烉x鏈ύX܂B
		// * Wed Jan 27 22:56:05 JST 2016 Naoyuki Sawa
		// - t@C烉x鏈ύX܂B
		// - ύXÓAPɁACV{ȊO̕oőł؂Ă܂B
		//   ꂾƁA'foo 001.bmp','foo 002.bmp','foo 003.bmp',ĉ悤ȋ󔒂܂ރt@Cɑ΂āAʂ̃x肭oȂ肪܂B
		//   uAVI2JPGv(http://www.gigafree.net/media/conv/avi2jpg.html)̃t[\tgŘAԉ摜쐬ƁAL̂悤Ƀt@Cɋ󔒂܂܂邩łB
		// - ŁAt@C烉x鏈Aȉ̂悤ɕύX܂B
		//   @'-'o܂ł̊ԁACV{ȊO̕oA'_'ɒuČpB
		//   A'-'oAőł؂B
		//   (Adpbmpcnv.exeɏ邽߂̎dlłBWin32vWFNgŎgpꍇ͕KK؂ł͂Ȃ̂łAP/ECEvWFNgł̎gՂD悷鎖ɂ܂B)
		// - ύX̏ŁAOq̗̃t@ĆAȉ̂悤ȃxɎϊ܂B
		//   'foo 001.bmp'FOO_001,'foo 002.bmp'FOO_002,'foo 003.bmp'FOO_003
		//   ʂ̗ƂāAdpbmpcnv.exep̃tH[}bgw肪tĂt@C̏ꍇAȉ̂悤Ƀxϊ܂B
		//   'bar 001-2m.bmp'BAR_001,'bar 002-2m.bmp'BAR_002,'bar 003-2m.bmp'BAR_003
		for(i = 0; fname[i]; i++) {
			if(fname[i] == '-') { break; }			//A'-'oAőł؂B							͕̏K{łB
			if(!iscsym(fname[i])) { fname[i] = '_'; }	//@'-'o܂ł̊ԁACV{ȊO̕oA'_'ɒuČpB	
		}
//}}2016/01/27ύX:t@C烉x鏈ύX܂B
		if(!i) {
			yyerror("t@C烉xo܂B(%s)", pPath);
			yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB	//KvBYYERROR}NĂяoyynerrs͑₳Ȃ悤B	dv
			return NULL;	//y.tab.y̏YYERRORsB
		}
		pTexLab = strndup(fname, i);
		if(!pTexLab) { DIE(); }
		strupr(pTexLab);
	}
	pTexHdr->pTexLab	= pTexLab;	//̎_pTexLabNULLł͂ȂB
	pTexHdr->pPath		= pPath;	//̎_pPathNULL̉\LBʓrAÕeNX``sŃt@Cݒ肷BaddTex()QƂB
	pTexHdr->bResource	= bResource;
	pTexHdr->bLoop		= bLoop;
	return pTexHdr;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_TexBody* TexBody_new(int iGridW, int iGridH) {
	ST_TexBody* pTexBody = calloc(1, sizeof(ST_TexBody));
	if(!pTexBody) { DIE(); }
	if((iGridW <= 0) || (iGridH <= 0)) {
		yyerror("ObhTCY͈͊OłB(%d,%d)", iGridW, iGridH);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB	//KvBYYERROR}NĂяoyynerrs͑₳Ȃ悤B	dv
		return NULL;	//y.tab.y̏YYERRORsB
	}
	grid_w			= iGridW;
	grid_h			= iGridH;
	return pTexBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_TexBody* TexBody_addSpr(ST_TexBody* pTexBody, ST_Spr* pSpr) {
	pTexBody = realloc(pTexBody, sizeof(ST_TexBody) + (sizeof pTexBody->aSpr[0]) * (pTexBody->nSpr + 1));
	if(!pTexBody) { DIE(); }
	pTexBody->aSpr[pTexBody->nSpr++]	= pSpr;
	//XvCgdĂȂmFAXvCgo^B
	if(ght_insert(ht_spr,
		       pSpr,
		strlen(pSpr->pSprLab) + 1/*nul*/,
		       pSpr->pSprLab)) {
		yyerror("XvCgdĂ܂B(%s)", pSpr->pSprLab);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB	//KvBYYERROR}NĂяoyynerrs͑₳Ȃ悤B	dv
		return NULL;	//y.tab.y̏YYERRORsB
	}
	return pTexBody;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Spr* Spr_new(char* pSprLab, int x, int y, int w, int h, int cx, int cy, char* Param) {
	ST_Spr* pSpr = calloc(1, sizeof(ST_Spr));
	if(!pSpr) { DIE(); }
	if((x < 0) || (y < 0)) {
		yyerror("XvCg̍WsłB(%s)", pSprLab);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB	//KvBYYERROR}NĂяoyynerrs͑₳Ȃ悤B	dv
		return NULL;	//y.tab.y̏YYERRORsB
	}
	if((w <= 0) || (h <= 0)) {
		yyerror("XvCg̃TCYsłB(%s)", pSprLab);
		yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB	//KvBYYERROR}NĂяoyynerrs͑₳Ȃ悤B	dv
		return NULL;	//y.tab.y̏YYERRORsB
	}
	pSpr->pSprLab		= pSprLab;
	pSpr->x			= x;
	pSpr->y			= y;
	pSpr->w			= w;
	pSpr->h			= h;
	pSpr->cx		= cx;
	pSpr->cy		= cy;
	pSpr->Param		= Param;
	return pSpr;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
ST_Spr* Spr_newP(char* pSprLab, int x, int y, int w, int h, int px, int py, char* Param) {
	return Spr_new(pSprLab,
		x,
		y,
		w,
		h,
		(w * px) / 100,	//ɑ΂p[Ze[W
		(h * py) / 100,	//ɑ΂p[Ze[W
		Param);
}
/*---------------------------------------------------------------------------*/
//2pXڂ̏
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static int Label_compar(LIST_ENTRY* _x, LIST_ENTRY* _y) {
	//֐̏́Aght_hash_table.h/cW[̓ɈˑĂ܂B
	//Oght_hash_table_t.le_iteratoȑԂёւĂAL܂B
	ght_hash_entry_t* x = CONTAINING_RECORD(_x, ght_hash_entry_t, le_iterator);
	ght_hash_entry_t* y = CONTAINING_RECORD(_y, ght_hash_entry_t, le_iterator);
	return (*fnLabCmp)(x->key_data, y->key_data);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void pass2(int bOptimize) {
	//eNX`𖼑ȌɃ\[gB		//ӁFght_hash_table_t̎ˑ̏łB
	SortList(&ht_tex->le_iterator, Label_compar);
	{
		ght_iterator_t it;
		ST_Tex* pTex;
		char* pTexLab;
		int iTexNo = 0;
		//eeNX`ɂāc
		for(pTex = ght_first(ht_tex, &it, &pTexLab);
		    pTex;
		    pTex = ght_next( ht_tex, &it, &pTexLab)) {
			ST_TexHdr*  pTexHdr  = pTex->pTexHdr;
			ST_TexBody* pTexBody = pTex->pTexBody;
			//eNX`ԍ(1x[X)i[B
			pTex->iTexNo		= ++iTexNo;
			//eNX`̃t@Cݒ肳Ă鎖mFB
			// - eNX`̃t@Cȗ`ŃXvCg`ꍇ́AʓrAeNX``sŃeNX`̃t@Cw肵Ȃ΂ȂB
			{
				if(!pTexHdr->pPath) {
					yyerror("eNX`̃t@Cݒ肳Ă܂B(%s)", pTexLab);
					yynerrs++;	//Ăяo(main)ɒm点邽߂ɁB
					//SẴZ}eBNXG[񍐂邽߂ɌpB
				}
			}
			//eXvCgɁAXvCgeNX`̃eNX`i[B
			{
				int iSpr;
				for(iSpr = 0; iSpr < pTexBody->nSpr; iSpr++) {
					ST_Spr* pSpr = pTexBody->aSpr[iSpr];
					pSpr->pTexLab		= pTexLab;
				}
			}
		}
	}
	//XvCg𖼑ȌɃ\[gB		//ӁFght_hash_table_t̎ˑ̏łB
	SortList(&ht_spr->le_iterator, Label_compar);
	{
		ght_iterator_t it;
		ST_Spr* pSpr;
		char* pSprLab;
		int iSprNo = 0;
		//eXvCgɂāc
		for(pSpr = ght_first(ht_spr, &it, &pSprLab);
		    pSpr;
		    pSpr = ght_next( ht_spr, &it, &pSprLab)) {
			//XvCgԍ(1x[X)i[B
			pSpr->iSprNo		= ++iSprNo;
		}
	}
}
/*---------------------------------------------------------------------------*/
//o͏
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
static void output(const char* sTexOut, const char* sSprOut, const char* sEnmOut, const char* sRegOut) {
	int nOut = 0;
	//eNX``wb_̃t@C,,"-"(Wo)w肳Ăc
	if(sTexOut) {
		FILE* fp = strcmp(sTexOut, "-") ? fopen(sTexOut, "w") : stdout;
		if(!fp) { error(EXIT_FAILURE, errno, "%s 쐬o܂B", sTexOut); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
		output_tex(fp);
		if(fp != stdout) { fclose(fp); }
		nOut++;
	}
	//XvCg`wb_̃t@C,,"-"(Wo)w肳Ăc
	if(sSprOut) {
		FILE* fp = strcmp(sSprOut, "-") ? fopen(sSprOut, "w") : stdout;
		if(!fp) { error(EXIT_FAILURE, errno, "%s 쐬o܂B", sSprOut); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
		output_spr(fp);
		if(fp != stdout) { fclose(fp); }
		nOut++;
	}
	//񋓒`XNvg̃t@C,,"-"(Wo)w肳Ăc
	if(sEnmOut) {
		FILE* fp = strcmp(sEnmOut, "-") ? fopen(sEnmOut, "w") : stdout;
		if(!fp) { error(EXIT_FAILURE, errno, "%s 쐬o܂B", sEnmOut); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
		output_enm(fp);
		if(fp != stdout) { fclose(fp); }
		nOut++;
	}
	//WXgXNvg̃t@C,,"-"(Wo)w肳Ăc
	if(sRegOut) {
		FILE* fp = strcmp(sRegOut, "-") ? fopen(sRegOut, "w") : stdout;
		if(!fp) { error(EXIT_FAILURE, errno, "%s 쐬o܂B", sRegOut); }	//{{2016/09/21ύX:die(`)ŏIĂӏAerror(EXIT_FAILURE,`)ŏI悤ɕύX܂B}}	//{{2016/09/28ύX:error()̍̕Ōɗ]vȉstĂ̂폜܂B}}
		output_reg(fp);
		if(fp != stdout) { fclose(fp); }
		nOut++;
	}
	if(!nOut) {
		fprintf(stderr, "-t/-p/-u/-rIvVw肳Ȃ̂ŁAo͂s܂łB\n");
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//eNX``wb_o͂B
static void output_tex(FILE* fp) {
	ght_iterator_t it;
	ST_Tex* pTex;
	char* pTexLab;
	//eeNX`ɂāc
	for(pTex = ght_first(ht_tex, &it, &pTexLab);
	    pTex;
	    pTex = ght_next( ht_tex, &it, &pTexLab)) {
		ST_TexHdr*  pTexHdr  = pTex->pTexHdr;
		ST_TexBody* pTexBody = pTex->pTexBody;
		if(pTexHdr->bResource) {
			//T[rXƂāApXP/ECE\[XɓKt@Cɕϊďo͂B
			char fname[MAX_FNAME];
			splitpath(pTexHdr->pPath, NULL, NULL, fname, NULL);
			fprintf(fp, "TEXTURE_RESOURCE_(%s,\"%s.pgd\")\n",
				pTexLab,
				fname);
		} else {
			fprintf(fp, "TEXTURE_(%s)\n",
				pTexLab);
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//XvCg`wb_o͂B
static void output_spr(FILE* fp) {
	ght_iterator_t it;
	ST_Spr* pSpr;
	char* pSprLab;
	//eXvCgɂāc
	for(pSpr = ght_first(ht_spr, &it, &pSprLab);
	    pSpr;
	    pSpr = ght_next( ht_spr, &it, &pSprLab)) {
		//TODO:͈̓`FbNB
		fprintf(fp, "SPRITE_(SPR_%s,TEX_%s,%d,%d,%d,%d,%d,%d,%s)\n",
			pSprLab,
			pSpr->pTexLab,
			pSpr->x, pSpr->y,
			pSpr->w, pSpr->h,
			pSpr->cx, pSpr->cy,
			pSpr->Param);
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//񋓒`XNvgo͂B
static void output_enm(FILE* fp) {
	//eNX`
	if(ght_size(ht_tex)) {
		ght_iterator_t it;
		ST_Tex* pTex;
		char* pTexLab;
		fprintf(fp, "TexNo\n");
		//eeNX`ɂāc
		for(pTex = ght_first(ht_tex, &it, &pTexLab);
		    pTex;
		    pTex = ght_next( ht_tex, &it, &pTexLab)) {
			ST_TexHdr*  pTexHdr  = pTex->pTexHdr;
			ST_TexBody* pTexBody = pTex->pTexBody;
			//eNX`̈ꕶڂCV{̈ꕶڂƂėLȕȂ΁c
			if(iscsymf(*pTexLab)) {
				fprintf(fp, "\t%s", pTexLab);
			//eNX`̈ꕶڂCV{̈ꕶڂƂĖȕ()Ȃ΁c
			} else {
				fprintf(fp, "\t`%s", pTexLab);	//eNX`̐擪Ɂu`vt^BdEnmDefC.exê߂łB
			}
			if(pTex->iTexNo == 1) { fprintf(fp, "\t%d", pTex->iTexNo); }	//1s
			fputc('\n', fp);
		}
		fprintf(fp, "end\n");
	}
	//XvCg
	if(ght_size(ht_spr)) {
		ght_iterator_t it;
		ST_Spr* pSpr;
		char* pSprLab;
		fprintf(fp, "SprNo\n");
		//eXvCgɂāc
		for(pSpr = ght_first(ht_spr, &it, &pSprLab);
		    pSpr;
		    pSpr = ght_next( ht_spr, &it, &pSprLab)) {
			//XvCg̈ꕶڂCV{̈ꕶڂƂėLȕȂ΁c
			if(iscsymf(*pSprLab)) {
				fprintf(fp, "\t%s", pSprLab);
			//XvCg̈ꕶڂCV{̈ꕶڂƂĖȕ()Ȃ΁c
			} else {
				fprintf(fp, "\t`%s", pSprLab);	//XvCg̐擪Ɂu`vt^BdEnmDefC.exê߂łB
			}
			if(pSpr->iSprNo == 1) { fprintf(fp, "\t%d", pSpr->iSprNo); }	//1s
			fputc('\n', fp);
		}
		fprintf(fp, "end\n");
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//WXgXNvgo͂B
static void output_reg(FILE* fp) {
	//eNX`
	if(ght_size(ht_tex)) {
		ght_iterator_t it;
		ST_Tex* pTex;
		char* pTexLab;
		fprintf(fp, "%s\t\t\t\t#//\t%s\n", "TexDef", "TexDef");
		//eeNX`ɂāc
		for(pTex = ght_first(ht_tex, &it, &pTexLab);
		    pTex;
		    pTex = ght_next( ht_tex, &it, &pTexLab)) {
			ST_TexHdr*  pTexHdr  = pTex->pTexHdr;
			ST_TexBody* pTexBody = pTex->pTexBody;
			fprintf(fp, "\t%d\t\t\t#//\t\t%s\n", pTex->iTexNo, pTexLab);
			fprintf(fp, "\t\t%s\t= \"%s\"\t#//\t\t\t%s\t= \"%s\"\n", "Path", pTexHdr->pPath, "Path", pTexHdr->pPath);
			if(pTexHdr->bLoop) {
				fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "Loop", 1, "Loop", 1);		//[vtO1̏ꍇ̂'Loop=1'o͂B'Loop=0'͏o͂ȂB
			}
			fprintf(fp, "\t%s\t\t\t#//\t\t%s\n", "end", "end");
		}
		fprintf(fp, "%s\t\t\t\t#//\t%s\n", "end", "end");
	}
	//XvCg
	if(ght_size(ht_spr)) {
		ght_iterator_t it;
		ST_Spr* pSpr;
		char* pSprLab;
		fprintf(fp, "%s\t\t\t\t#//\t%s\n", "SprDef", "SprDef");
		//eXvCgɂāc
		for(pSpr = ght_first(ht_spr, &it, &pSprLab);
		    pSpr;
		    pSpr = ght_next( ht_spr, &it, &pSprLab)) {
			//̃XvCgeNX`擾B
			ST_Tex* pTex = ght_get(ht_tex,
				strlen(pSpr->pTexLab) + 1/*nul*/,
				       pSpr->pTexLab);
			if(!pTex) { DIE(); }	//c[̃oO
			fprintf(fp, "\t%d\t\t\t#//\t\t%s\n", pSpr->iSprNo, pSprLab);
			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %s\n", "TexNo", pTex->iTexNo, "TexNo", pSpr->pTexLab);
			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "x",     pSpr->x,      "x",     pSpr->x);
			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "y",     pSpr->y,      "y",     pSpr->y);
			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "w",     pSpr->w,      "w",     pSpr->w);
			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "h",     pSpr->h,      "h",     pSpr->h);
//{{2016/01/27ύX:WXgXNvgłA}CiXcx,cy\o悤ɂ܂BAvP[Vł́A擾cx,cy(((int)(x<<8))>>8)̂悤ɕgĎgpĉB
//			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "cx",    pSpr->cx,     "cx",    pSpr->cx);
//			fprintf(fp, "\t\t%s\t= %d\t#//\t\t\t%s\t= %d\n", "cy",    pSpr->cy,     "cy",    pSpr->cy);
//2016/01/27ύX:WXgXNvgłA}CiXcx,cy\o悤ɂ܂BAvP[Vł́A擾cx,cy(((int)(x<<8))>>8)̂悤ɕgĎgpĉB
			fprintf(fp, "\t\t%s\t= (%d)&(~(-1<<24))\t#//\t\t\t%s\t= %d\n", "cx",    pSpr->cx,     "cx",    pSpr->cx);
			fprintf(fp, "\t\t%s\t= (%d)&(~(-1<<24))\t#//\t\t\t%s\t= %d\n", "cy",    pSpr->cy,     "cy",    pSpr->cy);
//}}2016/01/27ύX:WXgXNvgłA}CiXcx,cy\o悤ɂ܂BAvP[Vł́A擾cx,cy(((int)(x<<8))>>8)̂悤ɕgĎgpĉB
			fprintf(fp, "\t\t%s\t= %s\t#//\t\t\t%s\t= %s\n", "Param", pSpr->Param,  "Param", pSpr->Param);
			fprintf(fp, "\t%s\t\t\t#//\t\t%s\n", "end", "end");
		}
		fprintf(fp, "%s\t\t\t\t#//\t%s\n", "end", "end");
	}
}
