#//	
#//	DumpXlsx.tcl - xlsx/xlsmt@C̃V[gf[^_vTclXNvg
#//	
#//	* Thu Jun 30 21:54:58 JST 2016 Naoyuki Sawa
#//	- 1st [XB
#//	  DumpXlsx.batoRŎgpĉB
#//	
package require tdom
package require vfs::zip
#------------------------------------------------------------------------------
#//O[oϐ
proc initGlobal {} {
useGlobal
set	VERSION			"20160630"		;#//ŏIXV
set	g_zipfd			""
set	g_sharedStrings		[list]
set	g_sheetNameToId		[dict create]
set	g_sheetIdToFileName	[dict create]
}
#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
proc useGlobal {} {
uplevel {
global	VERSION
global	g_zipfd
global	g_sharedStrings
global	g_sheetNameToId
global	g_sheetIdToFileName
}}
#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
initGlobal
#------------------------------------------------------------------------------
#//ZIPt@CAzt@CVXeɃ}EgB
proc mountZip {zipFileName} {
	useGlobal
	#//ZIPt@CAzI"zip"tH_Ƀ}EgB
	set g_zipfd [vfs::zip::Mount $zipFileName "zip"]
}
#------------------------------------------------------------------------------
#//ZIPt@CAzt@CVXe}EgB
proc unmountZip {} {
	useGlobal
	#//ZIPt@CAzI"zip"tH_}EgB
	vfs::zip::Unmount $g_zipfd "zip"
}
#------------------------------------------------------------------------------
#//zt@CVXeAXMLt@Cǂݍ݁AhLgIuWFNgԂB
proc loadXml {xmlFileName} {
	useGlobal
	#//XMLt@CɁAzt@CVeX̃pXǉB
	set xmlFileName [file join "zip" $xmlFileName]
	#//XMLt@CɎw肳ꂽGR[fBOgāAXMLt@CJB
	set fd [tDOM::xmlOpenFile $xmlFileName]
	#//XMLt@Cǂݍ݁AhLgIuWFNg쐬B
	set doc [dom parse -channel $fd]
	#//XMLt@CB
	close $fd
	#//hLgIuWFNgԂB
	return $doc
}
#------------------------------------------------------------------------------
#//Le[uǂݍށB
proc loadSharedStrings {} {
	useGlobal
	#//Le[uXMLt@C
	set xmlFileName [file join "xl" "sharedStrings.xml"]
	#//Le[uXMLt@CL΁c
	#// - ؎gpĂȂGNZt@C̏ꍇ́ALe[uXMLt@C܂܂Ă܂B
	if {[file exists [file join "zip" $xmlFileName]]} then {
		#//XMLt@Cǂݍ݁AhLgIuWFNg擾B
		set doc [loadXml $xmlFileName]
		#//[gm[h<sst>ɂāc
		set sst [$doc selectNodes {*[local-name()='sst']}]
		if {[llength $sst] != 1} then {DIE}
		#//qm[h<si>ɂāc
		foreach si [$sst selectNodes {*[local-name()='si']}] {
			#//擾B
			set s [loadSharedStrings_subr $si ""]
			#//XgɒǉB
			lappend g_sharedStrings $s
		}
		#//hLgIuWFNgB
		$doc delete
	}
}
#- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
proc loadSharedStrings_subr {node s} {
	useGlobal
	#//ǂ݉̃m[h͏OB
	if {[$node localName] ne "rPh"} then {
		#//̃m[h<t>Ȃ΁c
		if {[$node localName] eq "t"} then {
			#//ǉB
			append s [$node text]
		}
		#//eqm[hɂāc
		foreach i [$node selectNodes {*}] {
			#//ċNsB
			set s [loadSharedStrings_subr $i $s]
		}
	}
	return $s
}
#------------------------------------------------------------------------------
#//(V[g˃V[gID)ǂݍށB
proc loadSheetNameToId {} {
	useGlobal
	#//[NubNXMLt@C
	set xmlFileName [file join "xl" "workbook.xml"]
	#//XMLt@Cǂݍ݁AhLgIuWFNg擾B
	set doc [loadXml $xmlFileName]
	#//[gm[h<workbook>ɂāc
	set workbook [$doc selectNodes {*[local-name()='workbook']}]
	if {[llength $workbook] != 1} then {DIE}
	#//qm[h<sheets>ɂāc
	set sheets [$workbook selectNodes {*[local-name()='sheets']}]
	if {[llength $sheets] != 1} then {DIE}
	#//qm[h<sheet>ɂāc
	foreach sheet [$sheets selectNodes {*[local-name()='sheet']}] {
		#//id擾B
		set id [$sheet getAttribute "r:id"]	;#//TODO:ꉞł擾o邪CBl[Xy[X𖳎鏑͖̂?(v)
		#//name擾B
		set name [$sheet getAttribute "name"]
		#//(V[g˃V[gID)o^B
		dict set g_sheetNameToId $name $id
	}
	#//hLgIuWFNgB
	$doc delete
}
#------------------------------------------------------------------------------
#//(V[gID˃V[gt@C)ǂݍށB
proc loadSheetIdToFileName {} {
	useGlobal
	#//[NubN[VXMLt@C
	set xmlFileName [file join "xl" "_rels" "workbook.xml.rels"]
	#//XMLt@Cǂݍ݁AhLgIuWFNg擾B
	set doc [loadXml $xmlFileName]
	#//[gm[h<Relationships>ɂāc
	set Relationships [$doc selectNodes {*[local-name()='Relationships']}]
	if {[llength $Relationships] != 1} then {DIE}
	#//qm[h<Relationship>ɂāc
	foreach Relationship [$Relationships selectNodes {*[local-name()='Relationship']}] {
		#//Id擾B
		set Id [$Relationship getAttribute "Id"]
		#//Target擾B
		set Target [$Relationship getAttribute "Target"]
		#//(V[gID˃V[gt@C)o^B
		dict set g_sheetIdToFileName $Id $Target
	}
	#//hLgIuWFNgB
	$doc delete
}
#------------------------------------------------------------------------------
#//V[gf[^ǂݍށB
proc loadSheetData {sheetFileName} {
	useGlobal
	#//V[gf[^̎쐬B
	set d [dict create]
	#//V[gt@CɁAÖق"xl"̃pXǉB
	set sheetFileName [file join "xl" $sheetFileName]
	#//XMLt@Cǂݍ݁AhLgIuWFNg擾B
	set doc [loadXml $sheetFileName]
	#//[gm[h<worksheet>ɂāc
	set worksheet [$doc selectNodes {*[local-name()='worksheet']}]
	if {[llength $worksheet] != 1} then {DIE}
	#//qm[h<sheetData>ɂāc
	set sheetData [$worksheet selectNodes {*[local-name()='sheetData']}]
	if {[llength $sheetData] != 1} then {DIE}
	#//qm[h<row>ɂāc
	foreach row [$sheetData selectNodes {*[local-name()='row']}] {
		#//qm[h<c>ɂāc
		foreach c [$row selectNodes {*[local-name()='c']}] {
			#//r擾B
			set r [$c getAttribute "r"]
			#//t擾Bt""ƂB
			set t [$c getAttribute "t" ""]
			#//qm[h<v>L΁c
			#// - Fhĉ͂ĂȂZ̏ꍇAqm[h<v>B
			#//   ̂悤ȃZo^ĂʂȂ̂ŁAqm[h<v>Z͖鎖ɂB
			set v [$c selectNodes {*[local-name()='v']}]
			if {$v ne ""} then {
				if {[llength $v] != 1} then {DIE}
				#//l擾B
				set v [$v text]
				#//lłȂ΁c
				#// - 񎮂ݒ肳ĂǍʂ󕶎ɂȂZ̏ꍇA<v/>ƂȂB
				#//   ̂悤ȃZo^ĂʂȂ̂ŁAlłZ͖鎖ɂB
				if {$v ne ""} then {
					#//t̒l"s"Ȃ΁c
					if {$t eq "s"} then {
						#//Le[ul擾B
						if {$v >= [llength $g_sharedStrings]} then {DIE}
						set v [lindex $g_sharedStrings $v]
					}
					#//lɐ䕶܂܂ĂȂmFB
					if {[regexp {[[:cntrl:]]} $v]} then {DIE}	;#//䕶(s^u܂)͎gpsB̃GNZt@CCĉB
					#//lo^B
					dict set d $r $v
				}
			}
		}
	}
	#//hLgIuWFNgB
	$doc delete
	#//V[gf[^̎ԂB
	return $d
}
#------------------------------------------------------------------------------
#//V[gf[^o͂B
proc doSave {sheetData xlsxFileName sheetName outDir} {
	#//V[gɊgq".txt"ǉāAo̓t@CƂB
	set fileName "$sheetName.txt"
	#//o̓tH_w肳ĂApXǉB
	if {$outDir ne ""} then {
		set fileName [file join $outDir $fileName]
	}
	#//o̓t@C쐬B
	set fd [open $fileName "w"]
	#//GNZt@CApXƃt@CɕB
;#{{sv?v
	set xlsxFileName [file normalize $xlsxFileName]			;#//GNZt@CAtpXɕϊB
;#}}sv?v
	set bookName [file tail    $xlsxFileName]			;#//t@C̕擾B
	set pathName [file dirname $xlsxFileName]			;#//pX̕擾B														̏K{Btɂ'file dirname'ɂāu\vˁu/vɖ߂Ă܂B
	set pathName [file nativename $pathName]			;#//GNZ̎QƎ̃pXZp[^́Au/vłu\vłvȂ悤Au\v̕mȂ̂ŁAu\vɑĂɂB	
	if {$pathName ne ""} then {					;#//pXłȂ΁c(Ƃ͎vAAu\vǉāu\vɂȂĂ܂댯邽߂łB)
		if {[string index $pathName end] ne "\\"} then {	;#//pX̍Ō̕u\vłȂ΁c(Tcl'file dirname'splitpath()ƈāAfBNg̍Ō̃pXZp[^Ă܂悤Ȃ̂ŁAȂł傤B)
			append pathName "\\"				;#//pX̍ŌɃpXZp[^₤BGNZ̎Qƕ\u'pX\[ubN]V[g'!ZQƁv̂߂ɕK{łB
		}
	}
	#//V[gf[^o͂B
	dict for {r v} $sheetData {
		set r [format {'%s[%s]%s'!%s} $pathName $bookName $sheetName $r]	;#//u'pX\[ubN]V[g'!ZQƁv(clipxls.cQ)
		puts $fd "$r\t$v"
	}
	#//o̓t@CB
	close $fd
}
#------------------------------------------------------------------------------
#//g\ďIB
proc usage {} {
	useGlobal
	puts stderr "DumpXlsx.tcl - xlsx/xlsmt@C̃V[gf[^_vTclXNvg ($VERSION)"
	puts stderr {Copyright (C) 2016 Naoyuki Sawa}
	puts stderr {}
	puts stderr {USAGE:}
	puts stderr {  tclsh.exe DumpXlsx.tcl GNZt@C [o̓tH_]}
	puts stderr {  Eo̓tH_ȗƁA"out"tH_ɏo͂܂B}
	puts stderr {}
	puts stderr {EXAMPLE:}
	puts stderr {  tclsh.exe DumpXlsx.tcl Sample.xlsx out}
	puts stderr {  Sample.xlsxǂݍŁASẴV[g̃V[gf[^AouttH_ɏo͂܂B}
	exit 1
}
#------------------------------------------------------------------------------
#//C[`
proc main {argv} {
	useGlobal
	#//R}hCŎw肳ꂽAGNZt@C擾B
	set xlsxFileName [lindex $argv 0]
	if {$xlsxFileName eq ""} then {usage}		;#//GNZt@C͏ȗsłB
	#//R}hCŎw肳ꂽAo̓tH_擾B
	set outDir [lindex $argv 1]
	if {$outDir eq ""} then {set outDir "out"}	;#//o̓tH_ȗꂽ"out"ƂB
	;#//o̓tH_mɍ쐬B
	file mkdir $outDir				;#//쐬悤ƂtH_ɑ݂ĂĂA'file mkdir'̓G[ɂȂȂ̂ňSłB
	#//GNZt@CAZIPt@CƂĉzt@CVXeɃ}EgB
	mountZip $xlsxFileName
	#//Le[uǂݍށB
	loadSharedStrings
	#//(V[g˃V[gID)ǂݍށB
	loadSheetNameToId
	#//(V[gID˃V[gt@C)ǂݍށB
	loadSheetIdToFileName
	#//e(V[g,V[gID)ɂāc
	dict for {sheetName sheetId} $g_sheetNameToId {
		puts stderr $sheetName
		#//V[gt@C擾B
		set fileName [dict get $g_sheetIdToFileName $sheetId]
		#//V[gf[^ǂݍށB
		set sheetData [loadSheetData $fileName]
		#//V[gf[^o͂B
		doSave $sheetData $xlsxFileName $sheetName $outDir
	}
	#//ZIPt@CAzt@CVXe}EgB
	unmountZip
}
main $argv
#------------------------------------------------------------------------------
