m4_dnl#
m4_dnl#		dict.tcl.m4
m4_dnl#
m4_dnl#		TclXNvgɂdictR}h̎
m4_dnl#
m4_dnl#		CLiP - Common Library for P/ECE
m4_dnl#		Copyright (C) 2014 Naoyuki Sawa
m4_dnl#	
m4_dnl#		* Sun Nov 16 15:42:56 JST 2014 Naoyuki Sawa
m4_dnl#		- Tcl8.5dictR}h̎vȃTuR}hATclXNvggĎ܂B
m4_dnl#		  Tcl̃AvP[VXNvgAusource dict.tclvœǂݍŁAgpĂB
m4_dnl#		- uinternal proceduresṽvV[ẂAXNvg̓ŎgpvV[WłB
m4_dnl#		  AvP[VXNvǵAĂяoȂłB
m4_dnl#		- utest suiteṽvV[ẂAXNvg̃eXgpłB
m4_dnl#		  dict_testR}hsAG[邱ƂmF܂B
m4_dnl#		  AύXꍇ́Adict_testR}hsāAG[邱ƂmFĂB
m4_dnl#		- TcĺARg̈h(http://wiki.tcl.tk/462)ATcl̃RgłȂAm4găRgLq邱ƂɂB
m4_dnl#		  Am4ɂ肪LAVtgJIS2oCgڂu`vɈvƁAu`vƂďĂ܂A҂ʂȂB
m4_dnl#		  ŁAnkfEUCɕϊ(EUCȂ2oCgڂɁu`v͏oȂ)Am4ŃRgATclXNvg𐶐邱ƂɂB
m4_dnl#		  ̓Iɂ́Aȉ̃R}hsĂB
m4_dnl#		  nkf.exe -e dict.tcl.m4 | m4.exe -P > dict.tcl
m4_dnl#
m4_dnl#=========================================================================
m4_dnl#global procedures
m4_dnl#=========================================================================
proc dict {option args} {
	set argc [llength $args]
	switch $option {
	m4_dnl#dict create ?key value ...?
	create {
		m4_dnl#̎ɑ΂āAP̎}[W铮ƂB
		set d {}
		set dList [list $args]
		m4_dnl#vV[WĂяoB
		return [dict_merge $d $dList]
	}
	m4_dnl#dict merge ?dictionaryValue ...?
	merge {
		m4_dnl#̎ɑ΂āA̎}[W铮ƂB
		set d {}
		set dList $args
		m4_dnl#vV[WĂяoB
		return [dict_merge $d $dList]
	}
	m4_dnl#dict replace dictionaryValue ?key value ...?
	replace {
		m4_dnl#w肳ꂽɑ΂āAP̎}[W铮ƂB
		set d [lindex $args 0]
		set dList [list [lrange $args 1 end]]
		m4_dnl#vV[WĂяoB
		return [dict_merge $d $dList]
	}
	m4_dnl#dict remove dictionaryValue ?key ...?
	remove {
		m4_dnl#擾B
		set d [lindex $args 0]
		set keyList [lrange $args 1 end]
		m4_dnl#w肳ꂽeL[ɂāc
		foreach key $keyList {
			m4_dnl#L[폜B
			set d [dict_unset $d $key]
		}
		m4_dnl#ʂ̎ԂB
		return $d
	}
	m4_dnl#dict exists dictionaryValue key ?key ...?
	exists {
		if {$argc < 2} then {error "syntax error"}
		m4_dnl#擾B
		set d [lindex $args 0]
		set keyList [lrange $args 1 end]
		m4_dnl#vV[WĂяoB
		return [dict_exists $d $keyList]
	}
	m4_dnl#dict size dictionaryValue
	size {
		if {$argc < 1} then {error "syntax error"}
		m4_dnl#擾B
		set d [lindex $args 0]
		m4_dnl#vV[WĂяoB
		return [llength [dict_from_list $d]]
	}
	m4_dnl#dict get dictionaryValue ?key ...?
	get {
		if {$argc < 2} then {error "syntax error"}
		m4_dnl#擾B
		set d [lindex $args 0]
		set keyList [lrange $args 1 end]
		m4_dnl#vV[WĂяoB
		return [dict_get $d $keyList]
	}
	m4_dnl#dict set dictionaryVariable key ?key ...? value
	set {
		if {$argc < 3} then {error "syntax error"}
		m4_dnl#ϐd㋉vV[WϐɃNB
		upvar [lindex $args 0] d
		m4_dnl#ϐd`̏ꍇ\Ƃ邽߁Aappenďʂ𗘗pdmɒ`B
		append d ""
		set keyList [lrange $args 1 end-1]
		set value [lindex $args end]
		m4_dnl#vV[WĂяoB㋉vV[Wϐ֔f邽߂ɁAʂ̎ϐdɂi[KvL邱ƂɒӂB
		return [set d [dict_set $d $keyList $value]]
	}
	m4_dnl#dict unset dictionaryVariable key ?key ...?
	unset {
		if {$argc < 2} then {error "syntax error"}
		m4_dnl#ϐd㋉vV[WϐɃNB
		upvar [lindex $args 0] d
		m4_dnl#ϐd`̏ꍇ\Ƃ邽߁Aappenďʂ𗘗pdmɒ`B
		append d ""
		set keyList [lrange $args 1 end]
		m4_dnl#vV[WĂяoB㋉vV[Wϐ֔f邽߂ɁAʂ̎ϐdɂi[KvL邱ƂɒӂB
		return [set d [dict_unset $d $keyList]]
	}
	m4_dnl#dict append dictionaryVariable key ?string ...?
	append -
	m4_dnl#dict lappend dictionaryVariable key ?value ...?
	lappend {
		if {$argc < 2} then {error "syntax error"}
		m4_dnl#ϐd㋉vV[WϐɃNB
		upvar [lindex $args 0] d
		m4_dnl#ϐd`̏ꍇ\Ƃ邽߁Aappenďʂ𗘗pdmɒ`B
		append d ""
		m4_dnl#擾B
		set key [lindex $args 1]
		set stringList [lrange $args 2 end]
		m4_dnl#L[`ς݂Ȃ΁c
		if {[dict_exists $d $key]} then {
			m4_dnl#l擾B
			set value [dict_get $d $key]
		m4_dnl#L[`Ȃ΁c
		} else {
			m4_dnl#l̏l󕶎ƂB
			set value ""
		}
		m4_dnl#ǉevfɂāc
		foreach string $stringList {
			m4_dnl#ǉevfɂāc
			eval $option value [list $string]
			m4_dnl#            ~~~~~        ~c$stringm1vfƂĒǉ邽߂ɕKvBevaľ͂邽߂łBlistsȂƁA$string̒ɋ󔒂LꍇɁA󔒂ꂽ(append)A2vfƌȂꂽ(lappend)B
		}
		m4_dnl#vV[WĂяoB㋉vV[Wϐ֔f邽߂ɁAʂ̎ϐdɂi[KvL邱ƂɒӂB
		return [set d [dict_set $d $key $value]]
	}
	m4_dnl#dict incr dictionaryVariable key ?increment?
	incr {
		if {($argc < 2) || ($argc > 3)} then {error "syntax error"}
		m4_dnl#ϐd㋉vV[WϐɃNB
		upvar [lindex $args 0] d
		m4_dnl#ϐd`̏ꍇ\Ƃ邽߁Aappenďʂ𗘗pdmɒ`B
		append d ""
		m4_dnl#擾B
		set key [lindex $args 1]
		if {$argc == 3} then {
			set increment [lindex $args 2]
		} else {
			set increment 1
		}
		m4_dnl#L[`ς݂Ȃ΁c
		if {[dict_exists $d $key]} then {
			m4_dnl#l擾B
			set value [dict_get $d $key]
		m4_dnl#L[`Ȃ΁c
		} else {
			m4_dnl#l̏l0ƂB
			set value 0
		}
		m4_dnl#l𑝌B
		incr value $increment
		m4_dnl#vV[WĂяoB㋉vV[Wϐ֔f邽߂ɁAʂ̎ϐdɂi[KvL邱ƂɒӂB
		return [set d [dict_set $d $key $value]]
	}
	m4_dnl#dict keys dictionaryValue ?globPattern?
	keys -
	m4_dnl#dict values dictionaryValue ?globPattern?
	values {
		if {($argc < 1) || ($argc > 2)} then {error "syntax error"}
		m4_dnl#擾B
		set d [lindex $args 0]
		if {$argc == 2} then {
			set globPattern [lindex $args 1]
		} else {
			set globPattern {*}
		}
		m4_dnl#Xg̏lƂĂB
		set iList {}
		m4_dnl#L[ƒl̊eyAɂāc
		foreach i [dict_from_list $d] {
			m4_dnl#keysR}hȂ΁c
			if {$option == "keys"} then {
				m4_dnl#L[擾B
				set i [lindex $i 0]
			m4_dnl#keysR}hȂ΁c
			} else {
				m4_dnl#l擾B
				set i [lindex $i 1]
			}
			m4_dnl#p^[ɈvȂ΁c
			if {[string match $globPattern $i]} then {
				m4_dnl#XgɒǉB
				lappend iList $i
			}
		}
		m4_dnl#ʂ̃XgԂB
		return $iList
	}
	m4_dnl#dict filter dictionaryValue filterType arg ?arg ...?
	m4_dnl#dict filter dictionaryValue key ?globPattern ...?
	m4_dnl#dict filter dictionaryValue script {keyVariable valueVariable} script
	m4_dnl#dict filter dictionaryValue value ?globPattern ...?
	filter -
	m4_dnl#dict for {keyVariable valueVariable} dictionaryValue body
	for -
	m4_dnl#dict info dictionaryValue
	info -
	m4_dnl#dict map {keyVariable valueVariable} dictionaryValue body
	map -
	m4_dnl#dict update dictionaryVariable key varName ?key varName ...? body
	update -
	m4_dnl#dict with dictionaryVariable ?key ...? body
	with {
		error "not implemented"
	}
	default {
		error "invalid command name"
	}}
}
m4_dnl#=========================================================================
m4_dnl#internal procedures
m4_dnl#=========================================================================
m4_dnl#l={key,value,key,value,...}{{key,value},{key,value},...}ɕϊB
m4_dnl#value͍ċAI{key,value}łĂǂB
proc dict_from_list {l} {
	m4_dnl#L[ƒl̃yA̗vf擾B
	set i [llength $l]
	m4_dnl#vfȂ΁AŌ̃yA̒lsĂƌȂAG[ƂB
	if {$i & 1} then {error "wrong # args"}
	m4_dnl#L[ƒl̃yAA擪֑āc
	while {[incr i -1] > 0} {
		m4_dnl#l̃CfNX擾B
		set j $i
		m4_dnl#L[̃CfNX擾B
		incr i -1
		m4_dnl#L[ƒl̃yAA{L[,l}̈vfɒuB
		set l [lreplace $l $i $j [lrange $l $i $j]]
	}
	m4_dnl#ʂ̎ԂB
	return $l
}
m4_dnl#-------------------------------------------------------------------------------
m4_dnl#d={{key,value},{key,value},...}{key,value,key,value,...}ɕϊB
m4_dnl#value͍ċAI{key,value}łĂǂB
proc dict_to_list {d} {
	return [join $d]
}
m4_dnl#-------------------------------------------------------------------------------
m4_dnl#d={{key1,{key2,{key3,value}}},{key1,{key2,{key3,value}}},...}̒A
m4_dnl#w肳ꂽkeyList={key1,key2,key3}Ɉvvf́A{index1,index2,index3}擾B
m4_dnl#Ȃ΁A{}ԂB
m4_dnl#̗ł͎OiKƂAۂɂ͉iKłǂAL[ɒiKĂĂ\ȂB
proc dict_search {d keyList} {
	m4_dnl#CfNXXgƂĂB
	set indexList {}
	m4_dnl#eL[ɂāc
	foreach key $keyList {
		m4_dnl#Xg`ɕϊB
		set d [dict_from_list $d]
		m4_dnl#L[Ɉvvf̃CfNX擾B
		set i [lsearch -index 0 $d $key]
		m4_dnl#Ȃ΁A{}ԂB
		if {$i == -1} then {return {}}
		m4_dnl#CfNXXgɁACfNXǉB
		lappend indexList $i
		m4_dnl#L[Ɉvvf̒lɂāAJԂB
		set d [lindex $d $i 1]
	}
	m4_dnl#CfNXXgԂB
	return $indexList
}
m4_dnl#-------------------------------------------------------------------------------
proc dict_exists {d keyList} {
	m4_dnl#L[XgɈvvf̃CfNXXg擾B
	set indexList [dict_search $d $keyList]
	m4_dnl#1AȂ0ԂB
	return [expr {$indexList != {}}]
}
m4_dnl#-------------------------------------------------------------------------------
proc dict_get {d keyList} {
	m4_dnl#L[XgȂ΁Â܂ܕԂB
	if {$keyList == {}} then {return $d}
	m4_dnl#Xg`ɕϊB
	set d [dict_from_list $d]
	m4_dnl#擪̃L[擾B
	set key [lindex $keyList 0]
	m4_dnl#c̃L[Xg擾B
	set keyList [lrange $keyList 1 end]
	m4_dnl#擪̃L[Ɉvvf̃CfNX擾B
	set i [lsearch -index 0 $d $key]
	m4_dnl#Ȃ΁AG[ƂB
	if {$i == -1} then {error "missing value to go with key"}
	m4_dnl#l擾B
	set d [lindex $d $i 1]
	m4_dnl#ċAIɏsB
	return [dict_get $d $keyList]
}
m4_dnl#-------------------------------------------------------------------------------
proc dict_set {d keyList value} {
	m4_dnl#L[XgȂ΁Al̂܂ܕԂB
	if {$keyList == {}} then {return $value}
	m4_dnl#Xg`ɕϊB
	set d [dict_from_list $d]
	m4_dnl#擪̃L[擾B
	set key [lindex $keyList 0]
	m4_dnl#c̃L[Xg擾B
	set keyList [lrange $keyList 1 end]
	m4_dnl#擪̃L[Ɉvvf̃CfNX擾B
	set i [lsearch -index 0 $d $key]
	m4_dnl#c
	if {$i != -1} then {
		m4_dnl#l擾B
		set e [lindex $d $i 1]
		m4_dnl#lTuXgƌȂAċAIɏsB
		set e [dict_set $e $keyList $value]
		m4_dnl#L[ɒli[B
		lset d $i [list $key $e]
	m4_dnl#Ȃ΁c
	} else {
		m4_dnl#̃Xgɑ΂AċAIɏsB
		set e [dict_set {} $keyList $value]
		m4_dnl#VK̃L[ƒl̃yAi[B
		lappend d [list $key $e]
	}
	m4_dnl#`XgɕϊB
	return [dict_to_list $d]
}
m4_dnl#-------------------------------------------------------------------------------
proc dict_unset {d keyList} {
	m4_dnl#L[XgȂ΁Â܂ܕԂB
	if {$keyList == {}} then {return $d}
	m4_dnl#Xg`ɕϊB
	set d [dict_from_list $d]
	m4_dnl#擪̃L[擾B
	set key [lindex $keyList 0]
	m4_dnl#c̃L[Xg擾B
	set keyList [lrange $keyList 1 end]
	m4_dnl#擪̃L[Ɉvvf̃CfNX擾B
	set i [lsearch -index 0 $d $key]
	m4_dnl#c̃L[XgłȂ΁c
	if {$keyList != {}} then {
		m4_dnl#c
		if {$i != -1} then {
			m4_dnl#l擾B
			set e [lindex $d $i 1]
			m4_dnl#lTuXgƌȂAċAIɏsB
			set e [dict_unset $e $keyList]
			m4_dnl#L[ɒli[B
			lset d $i [list $key $e]
		}
	m4_dnl#c̃L[XgȂ΁c
	} else {
		m4_dnl#c
		if {$i != -1} then {
			m4_dnl#L[폜B
			set d [lreplace $d $i $i]
		}
	}
	m4_dnl#`XgɕϊB
	return [dict_to_list $d]
}
m4_dnl#-------------------------------------------------------------------------------
proc dict_merge {d dList} {
	m4_dnl#}[Weɂāc
	foreach e $dList {
		m4_dnl#L[ƒl̊eyAɂāc
		foreach i [dict_from_list $e] {
			m4_dnl#L[ƒl擾B
			set key   [lindex $i 0]
			set value [lindex $i 1]
			m4_dnl#L[ɒli[B
			set d [dict_set $d $key $value]
		}
	}
	m4_dnl#ʂ̎ԂB
	return $d
}
m4_dnl#=========================================================================
m4_dnl#test suite
m4_dnl#=========================================================================
proc dict_test {} {
	m4_dnl#dict create ?key value ...?
	unset -nocomplain d
	set d [dict create]
	if {$d != {}} then {error failed}
	set d [dict create 1 2]
	if {$d != {1 2}} then {error failed}
	set d [dict create 1 2 3 4]
	if {$d != {1 2 3 4}} then {error failed}
	set d [dict create 1 2 3 4 1 5]
	if {$d != {1 5 3 4}} then {error failed}
	m4_dnl#dict merge ?dictionaryValue ...?
	unset -nocomplain d e
	set d [dict create 1 2 3 4]
	set e [dict create 1 5 6 7]
	set d [dict merge $d $e]
	if {$d != {1 5 3 4 6 7}} then {error failed}
	m4_dnl#dict replace dictionaryValue ?key value ...?
	unset -nocomplain d
	set d [dict create 1 2 3 4]
	set d [dict replace $d 1 a 5 b]
	if {$d != {1 a 3 4 5 b}} then {error failed}
	m4_dnl#dict remove dictionaryValue ?key ...?
	unset -nocomplain d
	set d [dict create 1 2 3 4 5 6 7 8]
	set d [dict remove $d 1 5 9]
	if {$d != {3 4 7 8}} then {error failed}
	m4_dnl#dict exists dictionaryValue key ?key ...?
	unset -nocomplain d
	set d [dict create 1 2 3 4]
	set i [dict exists $d 1]
	if {$i != 1} then {error failed}
	set i [dict exists $d 2]
	if {$i != 0} then {error failed}
	m4_dnl#dict size dictionaryValue
	unset -nocomplain d
	set d [dict create 1 2 3 4 5 6]
	set i [dict size $d]
	if {$i != 3} then {error failed}
	m4_dnl#dict get dictionaryValue ?key ...?
	m4_dnl#dict set dictionaryVariable key ?key ...? value
	unset -nocomplain d
	dict set d 1 2 3 4
	set i [dict get $d 1 2 3]
	if {$i != 4} then {error failed}
	m4_dnl#dict unset dictionaryVariable key ?key ...?
	unset -nocomplain d
	dict set d 1 2
	dict set d 3 4 5
	dict set d 3 6 7
	dict set d 6 8 9 a
	dict set d 6 8 b c
	dict unset d 3 4
	dict unset d 6 8
	if {$d != [list 1 2 3 [list 6 7] 6 {}]} then {error failed}
	m4_dnl#dict append dictionaryVariable key ?string ...?
	unset -nocomplain d
	dict append d 1 a
	dict append d 1 bc
	dict append d 1 def
	dict append d 2 g
	dict append d 2 hi
	dict append d 2 jkl
	if {$d != {1 abcdef 2 ghijkl}} then {error failed}
	m4_dnl#dict lappend dictionaryVariable key ?value ...?
	unset -nocomplain d
	dict lappend d 1 a
	dict lappend d 1 bc
	dict lappend d 1 def
	dict lappend d 2 g
	dict lappend d 2 hi
	dict lappend d 2 jkl
	set i [dict get $d 1]
	if {$i != {a bc def}} then {error failed}
	set i [dict get $d 2]
	if {$i != {g hi jkl}} then {error failed}
	m4_dnl#dict incr dictionaryVariable key ?increment?
	unset -nocomplain d
	dict incr d a
	dict incr d a  2
	dict incr d a -1
	if {$d != {a 2}} then {error failed}
	m4_dnl#dict keys dictionaryValue ?globPattern?
	unset -nocomplain d
	dict set d 1 2
	dict set d 3 4 5
	dict set d 6 7 8 9
	set i [dict keys $d]
	if {$i != {1 3 6}} then {error failed}
	set i [dict keys $d {[1-5]}]
	if {$i != {1 3}} then {error failed}
	m4_dnl#dict values dictionaryValue ?globPattern?
	unset -nocomplain d
	set d [dict create 1 2 3 4 5 6]
	set i [dict values $d]
	if {$i != {2 4 6}} then {error failed}
	set i [dict values $d {[1-5]}]
	if {$i != {2 4}} then {error failed}
	m4_dnl#
	puts ok
}
