/*	
 *	rand48.c
 *
 *	`ASY48rbgZpċ^𐶐B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Sat Apr 25 21:45:24 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	  錾́Ainclude/stdlib.hɗL܂B
 *	- drand48(),  erand48(),  lrand48(),  nrand48(),  mrand48(),  jrand48(),  srand48(),  seed48(),  lcong48()  POSIX.1-2001łB
 *	  drand48_r(),erand48_r(),lrand48_r(),nrand48_r(),mrand48_r(),jrand48_r(),srand48_r(),seed48_r(),lcong48_r()GNUgłB
 *	- QƎ
 *	  Linux Programmer's Manual (3) - DRAND48   (http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/drand48.3.html)
 *	  Linux Programmer's Manual (3) - DRAND48_R (http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/drand48_r.3.html)
 */
#include "clip.h"
/****************************************************************************
 *	[Jϐ
 ****************************************************************************/
#ifndef PIECE
static struct drand48_data __drand48_data/*__attribute__((unused))*/={{0x330E,0xABCD,0x1234}};
#else //PIECE
static struct drand48_data __drand48_data  __attribute__((unused))  ={{0x330E,0xABCD,0x1234}};
#endif//PIECE
/****************************************************************************
 *	[J֐
 ****************************************************************************/
#ifndef PIECE
static void __drand48_iterate(unsigned short xsubi[3], struct drand48_data* buffer) {
	uint64_t x, a, c;
	x  = xsubi[2]; x <<= 16;	//
	x |= xsubi[1]; x <<= 16;	//48rbg,gGfBA
	x |= xsubi[0];			//
	a  = buffer->a[2]; a <<= 16;	//
	a |= buffer->a[1]; a <<= 16;	//48rbg,gGfBA
	a |= buffer->a[0];		//
	c  = buffer->c[0];
	if(!a && !c) {
		a = UINT64_C(0x5DEECE66D);
		c = 0xB;
	}
	x *= a;
	x += c;
	xsubi[0] = x; x >>= 16;		//
	xsubi[1] = x; x >>= 16;		//48rbg,gGfBA
	xsubi[2] = x;			//
}
#else //PIECE
/*static*/ void __drand48_iterate(unsigned short xsubi[3], struct drand48_data* buffer);
asm("
		.code
		.align		1
__drand48_iterate:
		;//%r12 := xsubi
		;//%r13 := buffer
		add		%r13, 6				;//%r13      :=       buffer->a
		ld.uh		%r14, [%r13]+			;//%r14      := al  = buffer->a[0]
		ld.uh		%r9, [%r13]+			;//%r9       :=       buffer->a[1]
		xsla		%r9, 16				;//%r9       :=       buffer->a[1] << 16
		or		%r14, %r9			;//%r14      := al |= buffer->a[1] << 16
		ld.uh		%r15, [%r13]+			;//%r15      := ah  = buffer->a[2]
		ld.uh		%r6, [%r13]			;//%r6       := c   = buffer->c[0]
		ld.w		%r9, %r14			;//%r9       := al
		or		%r9, %r15			;//%r9       := al | ah
		or		%r9, %r6			;//%r9       := al | ah | c
		jrne.d		__drand48_iterate_L10		;//if(        !(al | ah | c)) {
		ld.w		%r7, %r12			;//%r7       := xsubi									*delay*
		xld.w		%r14, 0xDEECE66D		;//  %r15:%r14 := ah:al = UINT64_C(0x5DEECE66D)
		ld.w		%r15, 0x5			;//  
		ld.w		%r6,  0xB			;//  %r6       := c     = 0xB
__drand48_iterate_L10:						;//}
		ld.uh		%r10, [%r12]+			;//%r10      := xl  = xsubi[0]
		ld.uh		%r9, [%r12]+			;//%r9       :=       xsubi[1]
		xsla		%r9, 16				;//%r9       :=       xsubi[1] << 16
		or		%r10, %r9			;//%r10      := xl |= xsubi[1] << 16
		ld.uh		%r13, [%r12]			;//%r13      := xh  = xsubi[2]
		xcall.d		__muldi3			;//%r11:%r10 := xh:xl *= ah:al	__muldi3%r4~%r7j󂵂Ȃframdi.sQƂ
		ld.w		%r12, %r10			;//%r12      :=    xl									*delay*
		add		%r10, %r6			;//%r11:%r10 := xh:xl += 0:c
		adc		%r11, %r8			;//
		ld.h		[%r7]+, %r10			;//xsubi[0]  := xl
		xsra		%r10, 16			;//%r10      := xl >> 16
		ld.h		[%r7]+, %r10			;//xsubi[1]  := xl >> 16
		ld.h		[%r7], %r11			;//xsubi[2]  := xh
		ret						;//
");
#endif//PIECE
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
//Return non-negative, double-precision floating-point value in [0.0,1.0).
#ifndef PIECE
double drand48() {
	double result;
	drand48_r(&__drand48_data, &result);
	return result;
}
int drand48_r(struct drand48_data* buffer, double* result) {				//GNU extension
	return erand48_r(buffer->x, buffer, result);
}
double erand48(unsigned short xsubi[3]) {
	double result;
	erand48_r(xsubi, &__drand48_data, &result);
	return result;
}
int erand48_r(unsigned short xsubi[3], struct drand48_data* buffer, double* result) {	//GNU extension
	uint64_t x;
	__drand48_iterate(xsubi, buffer);
	x  =     1023; x <<= 16;	//
	x |= xsubi[2]; x <<= 16;	//01023 xsubi[2]  xsubi[1]  xsubi[0] 0000
	x |= xsubi[1]; x <<= 16;	//seeeeeee eeeemmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm
	x |= xsubi[0]; x <<=  4;	//
	*result = *(double*)&x - 1.0;
	return 0;
}
#else //PIECE
double drand48();
int drand48_r(struct drand48_data* buffer, double* result);				//GNU extension
double erand48(unsigned short xsubi[3]);
int erand48_r(unsigned short xsubi[3], struct drand48_data* buffer, double* result);	//GNU extension
asm("
		.align		1
		.global		drand48
		.global		drand48_r
		.global		erand48
		.global		erand48_r
drand48:
		xsub		%sp, %sp, 8			;//
		xld.w		%r12, __drand48_data		;//%r12      := &__drand48_data
		ld.w		%r13, %sp			;//%r13      :=                  &result
		call		drand48_r			;//drand48_r(   &__drand48_data, &result)
		xld.w		%r10, [%sp+0]			;//%r11:%r10 := result
		xld.w		%r11, [%sp+4]			;//
		xadd		%sp, %sp, 8			;//
		ret						;//return       result
drand48_r:
		;//%r12 := buffer
		;//%r13 := result
		ld.w		%r14, %r13			;//%r14      :=                              result
		jp.d		erand48_r			;//%r10      := erand48_r(buffer->x, buffer, result)
		ld.w		%r13, %r12			;//%r13      :=                      buffer						*delay*
erand48:
		;//%r12 := xsubi
		xsub		%sp, %sp, 8			;//
		xld.w		%r13, __drand48_data		;//%r13      :=     &__drand48_data
		ld.w		%r14, %sp			;//%r14      :=                      &result
		call		erand48_r			;//erand48_r(xsubi, &__drand48_data, &result)
		xld.w		%r10, [%sp+0]			;//%r11:%r10 := result
		xld.w		%r11, [%sp+4]			;//
		ret						;//return       result
erand48_r:
		;//%r12 := xsubi
		;//%r13 := buffer
		;//%r14 := result
		pushn		%r0
		ld.w		%r0, %r14			;//%r0       := result
		xcall.d		__drand48_iterate		;//__drand48_iterate(xsubi, buffer)	__drand48_iterate%r4~%r5j󂵂Ȃ
		ld.w		%r4, %r12			;//%r4       := xsubi									*delay*
		ld.uh		%r12, [%r4]+			;//%r12      := xl  = xsubi[0]
		ld.uh		%r9, [%r4]+			;//%r9       :=       xsubi[1]
		ld.uh		%r13, [%r4]			;//%r13      := xh  = xsubi[2]								*anti-interlock*
		xsla		%r9, 16				;//%r9       :=       xsubi[1] << 16
		or		%r12, %r9			;//%r12      := xl |= xsubi[1] << 16
		rl		%r13, 4				;//%r13      := xh  = 00000000 0000hhhh hhhhhhhh hhhh0000	
		rl		%r12, 4				;//%r12      := xl  = llllllll llllllll llllllll llllLLLL	
		xor		%r13, %r12			;//%r13      := xh  = llllllll llllXXXX XXXXXXXX XXXXLLLL	%r13:%r124ޯčĂøƯł
		and		%r12, -16			;//%r12      := xl  = llllllll llllllll llllllll llll0000	
		xor		%r13, %r12			;//%r13      := xh  = 00000000 0000hhhh hhhhhhhh hhhhLLLL	
		ld.w		%r14, 0				;//%r15:%r14 :=         1.0
		xld.w		%r15, 0x3FF00000		;//
		xcall.d		__subdf3			;//%r11:%r10 := xh:xl - 1.0
		or		%r13, %r15			;//%r13      := 0eeeeeee eeeehhhh hhhhhhhh hhhhLLLL					*delay*
		ld.w		[%r0]+, %r10			;//*result   := xh:xl - 1.0
		ld.w		[%r0], %r11			;//
		popn		%r0				;//
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*
");
#endif//PIECE
//-----------------------------------------------------------------------------
//Return non-negative, long integer in [0,2^31).
#ifndef PIECE
long lrand48() {
	long result;
	lrand48_r(&__drand48_data, &result);
	return result;
}
int lrand48_r(struct drand48_data* buffer, long* result) {				//GNU extension
	return nrand48_r(buffer->x, buffer, result);
}
long nrand48(unsigned short xsubi[3]) {
	long result;
	nrand48_r(xsubi, &__drand48_data, &result);
	return result;
}
int nrand48_r(unsigned short xsubi[3], struct drand48_data* buffer, long* result) {	//GNU extension
	__drand48_iterate(xsubi, buffer);
	*result = (xsubi[2] << 15) | (xsubi[1] >> 1);
	return 0;
}
#else //PIECE
long lrand48();
int lrand48_r(struct drand48_data* buffer, long* result);				//GNU extension
long nrand48(unsigned short xsubi[3]);
int nrand48_r(unsigned short xsubi[3], struct drand48_data* buffer, long* result);	//GNU extension
asm("
		.code
		.align		1
		.global		lrand48
		.global		lrand48_r
		.global		nrand48
		.global		nrand48_r
lrand48:
		xsub		%sp, %sp, 4			;//
		xld.w		%r12, __drand48_data		;//%r12 :=   &__drand48_data
		ld.w		%r13, %sp			;//%r13 :=                    &result
		call		lrand48_r			;//lrand48_r(&__drand48_data, &result)
		xld.w		%r10, [%sp+0]			;//%r10 := result
		xadd		%sp, %sp, 4			;//
		ret						;//return  result
lrand48_r:
		;//%r12 := buffer
		;//%r13 := result
		ld.w		%r14, %r13			;//%r14 :=                             result
		jp.d		nrand48_r			;//return nrand48_r(buffer->x, buffer, result)
		ld.w		%r13, %r12			;//%r13 :=                     buffer							*delay*
		;//---------------------------------------------;//
nrand48:
		;//%r12 := xsubi
		xsub		%sp, %sp, 4			;//
		xld.w		%r13, __drand48_data		;//%r13 :=          &__drand48_data
		ld.w		%r14, %sp			;//%r14 :=                           &result
		call		nrand48_r			;//nrand48_r(xsubi, &__drand48_data, &result)
		xld.w		%r10, [%sp+0]			;//%r10 := result
		xadd		%sp, %sp, 4			;//
		ret						;//return  result
nrand48_r:
		;//%r12 := xsubi
		;//%r13 := buffer
		;//%r14 := result
		ld.w		%r4, %r12			;//%r4  := xsubi
		ld.w		%r5, %r14			;//%r5  := result
		xcall.d		__drand48_iterate		;//__drand48_iterate(xsubi, buffer)	__drand48_iterate%r4~%r5j󂵂Ȃ
		add		%r4, 2				;//%r4  :=                     &xsubi[1]						*delay*
		ld.uh		%r9, [%r4]+			;//%r9  :=                      xsubi[1]
		ld.uh		%r4, [%r4]			;//%r4  :=    xsubi[2]
		sra		%r9, 1				;//%r9  :=                       xsubi[1] >> 1						*anti-interlock*
		xsla		%r4, 15				;//%r4  :=    xsubi[2] << 15
		or		%r4, %r9			;//%r4  :=   (xsubi[2] << 15) | (xsubi[1] >> 1)
		ld.w		[%r5], %r4			;//*result = (xsubi[2] << 15) | (xsubi[1] >> 1)
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*
");
#endif//PIECE
//-----------------------------------------------------------------------------
//Return signed, long integers in [-2^31,2^31).
#ifndef PIECE
long mrand48() {
	long result;
	mrand48_r(&__drand48_data, &result);
	return result;
}
int mrand48_r(struct drand48_data* buffer, long* result) {				//GNU extension
	return jrand48_r(buffer->x, buffer, result);
}
long jrand48(unsigned short xsubi[3]) {
	long result;
	jrand48_r(xsubi, &__drand48_data, &result);
	return result;
}
int jrand48_r(unsigned short xsubi[3], struct drand48_data* buffer, long* result) {	//GNU extension
	__drand48_iterate(xsubi, buffer);
	*result = (xsubi[2] << 16) | xsubi[1];
	return 0;
}
#else //PIECE
long mrand48();
int mrand48_r(struct drand48_data* buffer, long* result);				//GNU extension
long jrand48(unsigned short xsubi[3]);
int jrand48_r(unsigned short xsubi[3], struct drand48_data* buffer, long* result);	//GNU extension
asm("
		.code
		.align		1
		.global		mrand48
		.global		mrand48_r
		.global		jrand48
		.global		jrand48_r
mrand48:
		xsub		%sp, %sp, 4			;//
		xld.w		%r12, __drand48_data		;//%r12 :=   &__drand48_data
		ld.w		%r13, %sp			;//%r13 :=                    &result
		call		mrand48_r			;//mrand48_r(&__drand48_data, &result)
		xld.w		%r10, [%sp+0]			;//%r10 := result
		xadd		%sp, %sp, 4			;//
		ret						;//return  result
mrand48_r:
		;//%r12 := buffer
		;//%r13 := result
		ld.w		%r14, %r13			;//%r14 :=                             result
		jp.d		jrand48_r			;//return jrand48_r(buffer->x, buffer, result)
		ld.w		%r13, %r12			;//%r13 :=                     buffer							*delay*
		;//---------------------------------------------;//
jrand48:
		;//%r12 := xsubi
		xsub		%sp, %sp, 4			;//
		xld.w		%r13, __drand48_data		;//%r13 :=          &__drand48_data
		ld.w		%r14, %sp			;//%r14 :=                           &result
		call		jrand48_r			;//jrand48_r(xsubi, &__drand48_data, &result)
		xld.w		%r10, [%sp+0]			;//%r10 := result
		xadd		%sp, %sp, 4			;//
		ret						;//return  result
jrand48_r:
		;//%r12 := xsubi
		;//%r13 := buffer
		;//%r14 := result
		ld.w		%r4, %r12			;//%r4  := xsubi
		ld.w		%r5, %r14			;//%r5  := result
		xcall.d		__drand48_iterate		;//__drand48_iterate(xsubi, buffer)	__drand48_iterate%r4~%r5j󂵂Ȃ
		add		%r4, 2				;//%r4  :=                     &xsubi[1]						*delay*
		ld.uh		%r9, [%r4]+			;//%r9  :=                      xsubi[1]
		ld.uh		%r4, [%r4]			;//%r4  :=    xsubi[2]
		xsla		%r4, 16				;//%r4  :=    xsubi[2] << 16								!INTERLOCK!
		or		%r4, %r9			;//%r4  :=   (xsubi[2] << 16) | xsubi[1]
		ld.w		[%r5], %r4			;//*result = (xsubi[2] << 16) | xsubi[1]
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*
");
#endif//PIECE
//-----------------------------------------------------------------------------
//Seed random number generator.
#ifndef PIECE
void srand48(long seedval) {
	srand48_r(seedval, &__drand48_data);
}
int srand48_r(long seedval, struct drand48_data* buffer) {				//GNU extension
	unsigned short seed16v[3];
	seed16v[0] = 0x330E;			//
	seed16v[1] = seedval; seedval >>= 16;	//48rbg,gGfBA
	seed16v[2] = seedval;			//
	return seed48_r(seed16v, buffer);
}
unsigned short* seed48(unsigned short seed16v[3]) {
	seed48_r(seed16v, &__drand48_data);
	return __drand48_data.old_x;
}
int seed48_r(unsigned short seed16v[3], struct drand48_data* buffer) {			//GNU extension
	memcpy(buffer->old_x, buffer->x, sizeof buffer->x);
	memcpy(buffer->x,       seed16v, sizeof buffer->x);
	memset(buffer->a,             0, sizeof buffer->a +
	                                 sizeof buffer->c);
	return 0;
}
void lcong48(unsigned short param[7]) {
	lcong48_r(param, &__drand48_data);
}
int lcong48_r(unsigned short param[7], struct drand48_data* buffer) {			//GNU extension
	memcpy(buffer->x, param, sizeof buffer->x +	//param[0`2]
	                         sizeof buffer->a +	//param[3`5]
	                         sizeof buffer->c);	//param[   6]
	return 0;
}
#else //PIECE
void srand48(long seedval);
int srand48_r(long seedval, struct drand48_data* buffer);				//GNU extension
unsigned short* seed48(unsigned short seed16v[3]);
int seed48_r(unsigned short seed16v[3], struct drand48_data* buffer);			//GNU extension
void lcong48(unsigned short param[7]);
int lcong48_r(unsigned short param[7], struct drand48_data* buffer);			//GNU extension
asm("
		.code
		.align		1
		.global		srand48
		.global		srand48_r
		.global		seed48
		.global		seed48_r
		.global		lcong48
		.global		lcong48_r
srand48:
		;//%r12 := seedval
		xld.w		%r13, __drand48_data		;//%r13 := &__drand48_data
srand48_r:
		;//%r12 := seedval
		;//%r13 := buffer
		xsub		%sp, %sp, 8			;//
		xld.w		%r9, 0x330E			;//%r9        := 0x330E
		xld.h		[%sp+0], %r9			;//seed16v[0] := 0x330E
		xld.h		[%sp+2], %r12			;//seed16v[1] := seedval
		xsra		%r12, 16			;//%r12       := seedval >>= 16
		xld.h		[%sp+4], %r12			;//seed16v[2] := seedval
		ld.w		%r12, %sp			;//%r12       :=          seed16v
		call		seed48_r			;//%r10       := seed48_r(seed16v, buffer)
		xadd		%sp, %sp, 8			;//
		ret						;//return        seed48_r(seed16v, buffer)
		;//---------------------------------------------;//
seed48:
		;//%r12 := seed16v
		xld.w		%r13, __drand48_data		;//%r13 :=           &__drand48_data
		call		seed48_r			;//seed48_r(seed16v, &__drand48_data)
		xld.w		%r10, __drand48_data+14		;//%r10 := __drand48_data.old_x
		ret						;//return  __drand48_data.old_x
seed48_r:
		;//%r12 := seed16v
		;//%r13 := buffer
		pushn		%r1				;//
		ld.w		%r0, %r12			;//%r0  := seed16v
		ld.w		%r1, %r13			;//%r1  :=                buffer->x
		xadd		%r12, %r1, 14			;//%r12 := buffer->old_x
		xcall.d		memcpy				;//memcpy( buffer->old_x, buffer->x, sizeof buffer->x)
		ld.w		%r14, 6				;//%r14 :=                           sizeof buffer->x					*delay*
		ld.w		%r12, %r1			;//%r12 := buffer->x
		ld.w		%r13, %r0			;//%r13 :=            seed16v
		xcall.d		memcpy				;//memcpy( buffer->x, seed16v, sizeof buffer->x)
		ld.w		%r14, 6				;//%r14 :=                     sizeof buffer->x						*delay*
		xadd		%r12, %r1, 6			;//%r12 := buffer->a
		ld.w		%r13, 0				;//%r13 :=            0
		xcall.d		memset				;//memset( buffer->a, 0, sizeof buffer->a + sizeof buffer->c)
		ld.w		%r14, 8				;//%r14 :=               sizeof buffer->a + sizeof buffer->c				*delay*
		popn		%r1				;//
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*
		;//---------------------------------------------;//
lcong48:
		;//%r12 := param
		xld.w		%r13, __drand48_data		;//%r13 := &__drand48_data
lcong48_r:
		;//%r12 := param
		;//%r13 := buffer
		xor		%r12, %r13			;//%r12 := param ^ buffer
		xor		%r13, %r12			;//%r13 := param
		xor		%r12, %r13			;//%r12 := buffer
		xcall.d		memcpy				;//memcpy(buffer->x, param, sizeof buffer->x + sizeof buffer->a + sizeof buffer->c)
		ld.w		%r14, 14			;//%r14 :=                  sizeof buffer->x + sizeof buffer->a + sizeof buffer->c	*delay*
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*
");
#endif//PIECE
